;;;   
;;;   %% File: th-stg.st
;;;   %% Alan W Black (awb@ed.ac.uk) July 91
;;;   
;;;   This adds a Situation Theoretic Grammar semantic treatment for
;;;   the Rooth fragment \cite{rooth87}.  This deals with simple
;;;   declarative sentences, but not anaphora.  See Section
;;;   \ref{stg-description} for a full discussion.  Note unlike
;;;   the Rooth \astl/ description above here we distinguish between
;;;   proper nouns, pronouns and noun phrases.
;;;   
;;;   The semantics of an utterance is represented by a parametric fact 
;;;   and anchoring
;;;   environment.  The anchoring environment is extended with anchor
;;;   relations as more information is available about the sentence.
;;;   The described situation is represented by the reduction
;;;   of the anchoring environment and parametric fact.
;;;   
;;;   \begin{linespacing}{1.0}\begin{verbatim}
Individuals
    {a,h,t}
Relations
    ( use_of/2 cat/2 
      env/2 sem/2 described/2
      NounPhrase/1 Noun/1 Determiner/1
      Sentence/1 VerbPhrase/1 Verb/1 
      PrepPhrase/1 Preposition/1
      Discourse/1 pform/2
      subj/1 obj/1 comp/1 pred/1 
      var/1 range/1 body/1 quantifier/1
      arg/1 arg1/1 arg2/1 prep/1
      label/2 anchor/2 
      beat/2 like/2 walk/1 talk/1 smile/1 sing/1 run/1
      man/1 donkey/1
      named/2 )
Parameters
    {R1,Q1,P1,A1,A2,A3,D,S,NP,VP,PN,N,PREP,DET,V,ENV,DS
     SMA1, WA1, SA1, RA1, R1, TA1, LA1, LA2, BA1, BA2, MA1,
     DA1 }
Variables
    {*X, *S, *Y, *Z, *Fact, *Qexpr, *use,
     *DS, *Env, 
     *SEnv, *VPEnv, *VEnv, *NPEnv, *NEnv, *DetEnv, *PEnv,
     *PPEnv, *EnvType,
     *Body, *Range, *Type, *Z
     *R1, *A1, *A2, *A3, *VR1, *VA1, *VA2, *VA3,
     *SDS, *DStype, *DS, *DS2, *DS3
     *pred, *Var, *Pvar, *Basis, *pobj, *obj, *prep,
     *PA1, *PA2, *PR1 }
Situations
    (SmileEnv :: [Env ! Env != <<label,R1,pred,1>>
                        Env != <<anchor,R1,smile,1>>
                        Env != <<label,SMA1,subj,1>>]
     SingEnv :: [Env ! Env != <<label,R1,pred,1>>
                       Env != <<anchor,R1,sing,1>>
                       Env != <<label,SA1,subj,1>>]
     WalkEnv :: [Env ! Env != <<label,R1,pred,1>>
                       Env != <<anchor,R1,walk,1>>
                       Env != <<label,WA1,subj,1>>]
     RunEnv :: [Env ! Env != <<label,R1,pred,1>>
                      Env != <<anchor,R1,run,1>>
                      Env != <<label,RA1,subj,1>>]
     TalkEnv :: [Env ! Env != <<label,R1,pred,1>>
                       Env != <<anchor,R1,talk,1>>
                       Env != <<label,TA1,subj,1>>]
     LikeEnv :: [Env ! Env != <<label,R1,pred,1>>
                       Env != <<anchor,R1,like,1>>
                       Env != <<label,LA1,subj,1>>
                       Env != <<label,LA2,obj,1>>]
     BeatEnv :: [Env ! Env != <<label,R1,pred,1>>
                       Env != <<anchor,R1,beat,1>>
                       Env != <<label,BA1,subj,1>>
                       Env != <<label,BA2,obj,1>>]
     ManEnv :: [Env ! Env != <<label,R1,pred,1>>
                      Env != <<anchor,R1,man,1>>
                      Env != <<label,MA1,arg1,1>>]
     DonkeyEnv :: [Env ! Env != <<label,R1,pred,1>>
                         Env != <<anchor,R1,donkey,1>>
                         Env != <<label,DA1,arg1,1>>]
     AEnv :: [Env ! Env != <<label,Q1,quantifier,1>>
                    Env != <<anchor,Q1,some,1>>
                    Env != <<label,A1,var,1>>
                    Env != <<label,A2,range,1>>
                    Env != <<label,A3,body,1>>]
     EveryEnv :: [Env ! Env != <<label,Q1,quantifier,1>>
                        Env != <<anchor,Q1,every,1>>
                        Env != <<label,A1,var,1>>
                        Env != <<label,A2,range,1>>
                        Env != <<label,A3,body,1>>]
     WithEnv :: [Env ! Env != <<label,P1,prep,1>>
                       Env != <<anchor,P1,with,1>>
                       Env != <<label,A1,arg1,1>>
                       Env != <<label,A2,arg2,1>>]
    )
GoalProp
   *S : [S ! S != <<cat,S,discourse,1>>]
;;;   \end{verbatim}\end{linespacing}
;;;   A rather exhaustive set of constraints is needed to specify
;;;   the relationship between the parametric fact and anchoring
;;;   environment to the described situation.  These constraints
;;;   are really just cases of the same notional constraint.  They
;;;   try to capture the notion of reduction as discussed in 
;;;   Section~\ref{abstraction-extension}.  Even with this large
;;;   number of similar constraints the full notion of reduction
;;;   is actually not captured.
;;;   
;;;   \begin{linespacing}{1.0}\begin{verbatim}
Constraints

*S : [S ! S != <<described,S,*DS :: 
                  [DS ! DS != <<*VR1,*VA1,*VA2,*VA3,1>>],1>>]
<=
   *S : [S ! S != <<cat,S,sentence,1>>
             S != <<sem,S,<<*R1,*A1,*A2,*A3,1>>,1>>
             S != <<env,S,*SEnv ::
                          [Env ! Env != <<anchor,*R1,*VR1,1>>
                                 Env != <<anchor,*A1,*VA1,1>>
                                 Env != <<anchor,*A2,*VA2,1>>
                                 Env != <<anchor,*A3,*VA3,1>>],1>>].

*S : [S ! S != <<described,S,*DS :: 
                  [DS ! DS != <<*VR1,*VA1,*VA2,*VA3,1>>],1>>]
<=
   *S : [S ! S != <<cat,S,VerbPhrase,1>>
             S != <<env,S,*SEnv ::
                          [Env ! Env != <<anchor,*R1,*VR1,1>>
                                 Env != <<anchor,*A1,*VA1,1>>
                                 Env != <<anchor,*A2,*VA2,1>>
                                 Env != <<anchor,*A3,*VA3,1>>],1>>
             S != <<sem,S,<<*R1,*A1,*A2,*A3,1>>,1>>].

*S : [S ! S != <<described,S,*DS :: 
                 [DS ! DS != <<*VR1,*VA1,*VA2,1>>],1>>]
<=
   *S : [S ! S != <<cat,S,sentence,1>>
             S != <<sem,S,<<*R1,*A1,*A2,1>>,1>>
             S != <<env,S,*SEnv ::
                          [Env ! Env != <<anchor,*R1,*VR1,1>>
                                 Env != <<anchor,*A1,*VA1,1>>
                                 Env != <<anchor,*A2,*VA2,1>>],1>>].

*S : [S ! S != <<described,S,
                 *DS :: [DS ! DS != <<*VR1,*A1,*VA2,1>>],1>>]
<=
   *S : [S ! S != <<cat,S,VerbPhrase,1>>
             S != <<env,S,*VPEnv ::
                          [Env ! Env != <<anchor,*R1,*VR1,1>>
                                 Env != <<anchor,*A2,*VA2,1>>],1>>
             S != <<sem,S,<<*R1,*A1,*A2,1>>,1>>].

*S : [S ! S != <<described,S,*DS :: [DS ! DS != <<*VR1,*VA1,1>>],1>>]
<=
   *S : [S ! S != <<cat,S,sentence,1>>
             S != <<sem,S,<<*R1,*A1,1>>,1>>
             S != <<env,S,*SEnv ::
                          [Env ! Env != <<anchor,*R1,*VR1,1>>
                                 Env != <<anchor,*A1,*VA1,1>>],1>>].

*S : [S ! S != <<described,S,*DS :: [DS ! DS != <<*VR1,*A1,1>>],1>>]
<=
   *S : [S ! S != <<cat,S,VerbPhrase,1>>
             S != <<sem,S,<<*R1,*A1,1>>,1>>
             S != <<env,S,*VPEnv ::
                          [Env ! Env != <<anchor,*R1,*VR1,1>>],1>>].

*S : [S ! S != <<described,S,*DS :: *DStype,1>>]
<=
   *S : [S ! S != <<cat,S,noun,1>>
             S != <<use_of,S,*X,1>>].

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                       Grammar Rules
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  S -> NP VP
;;;  As proper nouns are not treated like quantifiers (a la
;;;  Montague) two rules are necessary, one to deal with a 
;;;  proper noun subject and a second to deal with a quantified 
;;;  NP.
;;;
   [S ! S != <<cat,S,Sentence,1>>
        S != <<sem,S,*Fact,1>>
        S != <<env,S,*SEnv :: *EnvType & 
               [Env ! Env != <<anchor,*X,*Y,1>>],1>>]
   ->
    [NP ! NP != <<cat,NP,NounPhrase,1>>
          NP != <<use_of,NP,*use,1>>  ;; lexical NP
          NP != <<sem,NP,*Y,1>>],
    [VP ! VP != <<cat,VP,VerbPhrase,1>>
          VP != <<sem,VP,*Fact,1>>
          VP != <<env,VP,*VPEnv :: *EnvType & 
                          [Env ! Env != <<label,*X,subj,1>>],
                         1>>].

   [S ! S != <<cat,S,Sentence,1>>
        S != <<sem,S,*Qexpr,1>>
        S != <<env,S,*SEnv :: *EnvType & 
                         [Env ! Env != <<anchor,*Y,*Var,1>>
                                Env != <<anchor,*Body,*DSType,1>>],
                   1>>]
   ->
    [NP ! NP != <<cat,NP,NounPhrase,1>>
          NP != <<sem,NP,*Qexpr,1>>
          NP != <<env,NP, *Env :: *EnvType &
                             [Env ! Env != <<label,*Body,body,1>>
                                    Env != <<label,*X,var,1>>
                                    Env != <<anchor,*X,*Var,1>>],1>>],
    [VP ! VP != <<cat,VP,VerbPhrase,1>>
          VP != <<described,VP,*DS :: *DSType,1>>
          VP != <<env,VP,*VPEnv :: [Env ! Env != <<label,*Y,subj,1>>],
                         1>>
          VP != <<sem,VP,*Fact,1>>].
;;;
;;;  VP -> V NP
;;;  Again two rules, one for a proper noun object and the
;;;  second for quantified NPs.
;;;
    [VP ! VP != <<cat,VP,VerbPhrase,1>>
          VP != <<env,VP,*VPEnv :: *EnvType &
                          [Env ! Env != <<anchor,*Body,
                                          <<*pred,*Y,*Var,1>>,1>>
                                 Env != <<label,*Y,subj,1>>],
                      1>>
          VP != <<sem,VP,*Qexpr,1>>]
    ->
       [V ! V != <<cat,V,Verb,1>>
            V != <<env,V,*Env :: 
                          [Env ! Env != <<label,*Y,subj,1>>
                                 Env != <<label,*R1,pred,1>>
                                 Env != <<anchor,*R1,*pred,1>>],
                         1>>
            V != <<sem,V,*Fact,1>>],
       [NP ! NP != <<cat,NP,NounPhrase,1>>
             NP != <<env,NP,*Env :: *Envtype & 
                             [Env ! Env != <<label,*Range,range,1>>
                                    Env != <<label,*Body,body,1>>
                                    Env != <<label,*Pvar,var,1>>
                                    Env != <<anchor,*Pvar,*Var,1>>],
                         1>>
             NP != <<sem,NP,*Qexpr,1>>].

    [VP ! VP != <<cat,VP,VerbPhrase,1>>
          VP != <<env,VP,*VPEnv :: *EnvType &
                           [Env ! Env != <<anchor,*X,*Y,1>>],1>>
          VP != <<sem,VP,*Fact,1>>]
    ->
       [V ! V != <<cat,V,Verb,1>>
            V != <<env,V,*Env :: *Envtype & 
                                  [Env ! Env != <<label,*X,obj,1>>],
                         1>>
            V != <<sem,V,*Fact,1>>],
       [NP ! NP != <<cat,NP,NounPhrase,1>>
             NP != <<use_of,NP,*use,1>>  ;; lexical NP
             NP != <<sem,NP,*Y,1>>].
;;;
;;;  NP -> Det N
;;;
    [NP ! NP != <<cat,NP,NounPhrase,1>>
          NP != <<sem,NP,*QEXPR,1>>
          NP != <<env,NP,*NPEnv ::
                  *EnvType &
                  [Env ! Env != <<anchor,*X,*A1,1>>
                         Env != <<anchor,*Range,
                                   *DStype &
                                   [DS ! DS != <<*pred,*A1,1>>],1>>],
                  1>>]
    ->
      [DET ! DET != <<cat,DET,Determiner,1>>
             DET != <<sem,DET,*QEXPR,1>>
             DET != <<env,DET,*DetEnv ::
                      *EnvType &
                      [Env ! Env != <<label,*Range,range,1>>
                             Env != <<label,*X,var,1>>],1>>],
      [N ! N != <<cat,N,noun,1>>
           N != <<env,N,*Env :: 
                  [Env ! Env != <<label,*A1,arg1,1>>
                         Env != <<anchor,*R1,*pred,1>>],1>>
           N != <<described,N,*DS :: *DStype,1>>
           N != <<sem,N,<<*R1,*A1,1>>,1>>].
;;;
;;;  N -> N PP
;;;  Reduction is done on the fly here
;;;
    [N ! N != <<cat,N,noun,1>>
         N != <<sem,N,*Y,1>>
         N != <<described,N,*DS2 :: *DStype &
                         [DS ! DS != <<*prep,*A1,*Z,1>>],1>>
         N != <<env,N,*NEnv :: *Envtype, 1>>]
    ->
      [N ! N != <<cat,N,noun,1>>
           N != <<env,N,*Env :: *Envtype &
                 [Env ! Env != <<label,*A1,arg1,1>>],1>>
           N != <<sem,N,*Y,1>>],
      [PP ! PP != <<cat,PP,PrepPhrase,1>>
            PP != <<described,PP,*DS :: *DStype,1>>
            PP != <<env,PP,*PPEnv ::
                    [Env ! Env != <<label,*PA1,arg1,1>>
                           Env != <<label,*PA2,arg2,1>>
                           Env != <<anchor,*PA2,*Z,1>>
                           Env != <<label,*PR1,prep,1>>
                           Env != <<anchor,*PR1,*prep,1>>],1>>].
;;;
;;;  PP -> P NP
;;;  Two are required -- the first for proper nouns, second for
;;;  quantified NPs
;;;
    [PP ! PP != <<cat,PP,PrepPhrase,1>>
          PP != <<described,PP,*DS2 :: *DStype,1>>
          PP != <<env,PP,*PPEnv :: *Envtype &
                  [Env ! Env != <<anchor,*PA2,*Y,1>>],1>>]
    ->
      [PREP ! PREP != <<cat,PREP,Preposition,1>>
              PREP != <<env,PREP,*Penv :: *Envtype &
                        [Env ! Env != <<label,*PA2,arg2,1>>],1>>],
      [NP ! NP != <<cat,NP,NounPhrase,1>>
            NP != <<use_of,NP,*use,1>>  ;; lexical NP
            NP != <<sem,NP,*Y,1>>].
;;;
;;;  D -> S
;;;
    [D ! D != <<cat,D,Discourse,1>>
         D != <<env,S,*Env,1>>
         D != <<described,D,*DS,1>>]
    ->
      [S ! S != <<cat,S,Sentence,1>>
           S != <<env,S,*Env,1>>
           S != <<described,S,*DS,1>>].
;;;
;;;  D -> D S
;;;  This is again a little hacky.  The sentence described is always
;;;  one fact so we can add *it* (we know it's not a them) to the
;;;  discourse described -- but we need a rule for each semantic arity
;;;
    [D ! D != <<cat,D,Discourse,1>>
         D != <<described,D,*DS2 :: *DStype &
                     [DS ! DS != <<*R1,*A1,1>>],1>>]
    ->
      [D ! D != <<cat,D,Discourse,1>>
           D != <<described,D,*DS :: *DStype,1>>],
      [S ! S != <<cat,S,Sentence,1>>
           S != <<described,S,*DS3 :: 
                     [DS ! DS != <<*R1,*A1,1>>],1>>].
;;;   \end{verbatim}\end{linespacing}
;;;   %%               ***** Lexical Entries *****
;;;   A basic set of lexical entries to allow some the simple classic
;;;   sentences.  Note the constraints above are sometimes used to
;;;   expand entries (i.e like Lexical Redundancy Rules).
;;;   
;;;   \begin{linespacing}{1.0}\begin{verbatim}
Lexical Entries
;;;
;;;  Nouns
;;;
Hanako - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Hanako",1>>
         PN != <<sem,PN,h,1>>]
Taro -
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Taro",1>>
         PN != <<sem,PN,t,1>>]
Anna - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Anna",1>>
         PN != <<sem,PN,a,1>>]
man -
   [N ! N != <<cat,N,Noun,1>>
        N != <<use_of,N,"man",1>>
        N != <<sem,N,<<R1,MA1,1>>,1>>
        N != <<env,N,ManEnv,1>>]
donkey -
   [N ! N != <<cat,N,Noun,1>>
        N != <<use_of,N,"donkey",1>>
        N != <<sem,N,<<R1,DA1,1>>,1>>
        N != <<env,N,DonkeyEnv,1>>]
;;;
;;;  Pronouns
;;;
;;;  Not used in this actual description
;;;
he - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"he",1>>
         PN != <<sem,PN,*X,1>>]
she - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"she",1>>
         PN != <<sem,PN,*X,1>>]
it - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"it",1>>
         PN != <<sem,PN,*X,1>>]
;;;
;;;  Determiners
;;;
;;;  Their semantics is a relation between a variable (a parameter)
;;;  and a range (a type) and a body (a type too).
;;;
a - 
   [DET ! DET != <<cat,DET,Determiner,1>>
          DET != <<use_of,DET,"a",1>>
          DET != <<sem,DET,<<Q1,A1,A2,A3,1>>,1>>
          DET != <<env,DET,AEnv,1>>]
every - 
   [DET ! DET != <<cat,DET,Determiner,1>>
          DET != <<use_of,DET,"every",1>>
          DET != <<sem,DET,<<Q1,A1,A2,A3,1>>,1>>
          DET != <<env,DET,EveryEnv,1>>]
;;;
;;;  Verbs
;;;
smiles -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"smiles",1>>
         VP != <<sem,VP, <<R1,SMA1,1>>,1>>
         VP != <<env,VP,SmileEnv,1>>]
sings -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"sings",1>>
         VP != <<sem,VP, <<R1,SA1,1>>,1>>
         VP != <<env,VP,SingEnv,1>>]
walks -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"walks",1>>
         VP != <<sem,VP, <<R1,WA1,1>>,1>>
         VP != <<env,VP,WalkEnv,1>>]
talks -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"talks",1>>
         VP != <<sem,VP,<<R1,TA1,1>>,1>>
         VP != <<env,VP,TalkEnv,1>>]
runs -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"runs",1>>
         VP != <<sem,VP,<<R1,RA1,1>>,1>>
         VP != <<env,VP,RunEnv,1>>]
likes -
   [V ! V != <<cat,V,Verb,1>>
        V != <<use_of,V,"likes",1>>
        V != <<env,V,LikeEnv,1>>
        V != <<sem,V,<<R1,LA1,LA2,1>>,1>>]
beats -
   [V ! V != <<cat,V,Verb,1>>
        V != <<use_of,V,"beats",1>>
        V != <<sem,V,<<R1,BA1,BA2,1>>,1>>
        V != <<env,V,BeatEnv,1>>]
;;;
;;;  Prepositions
;;;
to - 
     [PREP ! PREP != <<cat,PREP,Preposition,1>>
             PREP != <<use_of,PREP,"to",1>>]
with - 
     [PREP ! PREP != <<cat,PREP,Preposition,1>>
             PREP != <<use_of,PREP,"with",1>>
             PREP != <<sem,PREP,<<P1,A1,A2,1>>,1>>
             PREP != <<env,PREP,WithEnv,1>>]
on - 
     [PREP ! PREP != <<cat,PREP,Preposition,1>>
             PREP != <<pform,PREP,on,1>>
             PREP != <<use_of,PREP,"on",1>>]
;;;   \end{verbatim}\end{linespacing}
