;***********************************************************************/
;*	grbxfill.asm                                                  */
;***********************************************************************/
         PAGE ,132
         .SALL
;
INCLUDE MACROS.INC
INCLUDE BIOSDATA.INC

IFDEF MSDOS        ; DEFINED IN LATTICE 2.X M8086.MAC

PSEG

ENDIF


;****************************************************************************
;
;	FUNCTION TO FILL A RECTANGLE WITH COLOR CALLED AS FOLLOWS:
;		GRBXFILL(ULC,ULR,LRC,LRR,COLOR);
;	WHERE:
;		INT ULC,ULR; /* UPPER LEFT COLUMN AND ROW COORDINATES */
;		INT LRC,LRR; /* LOWER RIGHT CORNER COORDINATES */
;		INT COLOR; /* COLOR VALUE FROM 0 TO 3 */



	PUBLIC	GRBXFILL

IF @BIGMODEL+LPROG    ;LARGE CODE MODELS

GRBXFILL PROC FAR
FIRST EQU 6		;OFFSET FROM BP OF FIRST VARIABLE

ELSE			; SMALL CODE MODELS

GRBXFILL PROC	NEAR
FIRST EQU 4		;OFFSET FROM BP OF FIRST VARIABLE

ENDIF

	PUSH BP
	MOV BP,SP
	PUSH BX			;SAVE BX,CX,DX,SI
	PUSH CX
	PUSH DX
	PUSH SI

	MOV BX,[BP+FIRST+4]	;GET LOWER RIGHT COLUMN
	MOV CX,[BP+FIRST]	;GET UPPER LEFT COLUMN 
	SUB BX,CX		;SUBTRACT ULC FROM LRC 
	INC BX			;ADD ONE TO GET NUMBER OF COLUMNS IN WIDTH
	PUSH BX			;SAVE NUMBER OF COLUMNS
	MOV AX,[BP+FIRST+6]	;GET LOWER RIGHT ROW
	MOV DX,[BP+FIRST+2]	;GET UPPER LEFT ROW
	PUSH DX			;SAVE STARTING ROW
	SUB AX,DX		;LRR - ULR + 1 = NUMBER OF ROWS IN LENGTH
	INC AX			
	PUSH AX 		;SAVE NUMBER OF ROWS
	PUSH AX			;AGAIN	
	MOV AX,[BP+FIRST+8]	;COLOR IN AX

;LOOOP FILLING COLUMN BY COLUMN

GR01:
	PUSH AX			;SAVE AH AND AL VALUES WHICH GET DESTROYED
	CALL ASMDOT		;ROUTINE TO WRITE DOT
	POP AX			;RESTORE AX
	POP BX			;RETRIEVE ROWS WRITTEN COUNTER
	DEC BX			;DECREMENT FOR DOT JUST WRITTEN
	JZ GR02			;GOTO GR02 IF DONE WITH ROWS
	PUSH BX			;SAVE ROW COUNTER AGAIN
	INC DX			;NEXT ROW FOR BIOS CALL
	JMP GR01		;PLOT IT
GR02:
	POP BX			;GET ORIGINAL NUMBER OF ROWS TO PLOT
	POP DX			;GET ORIGINAL STARTING ROW
	POP SI			;GET COLUMN COUNTER
	DEC SI			;DECREMENT FOR COLUMN JUST PLOTTED
	JZ GR03			;WE ARE FINISHED IF NO MORE COLUMNS
	PUSH SI			;SAVE COLUMN COUNTER
	PUSH DX			;SAVE ORIGINAL STARTING ROW
	PUSH BX			;SAVE ROW COUNTER
	PUSH BX			;AGAIN
	INC CX			;NEXT COLUMN
	JMP GR01		;PLOT NEXT COLUMN
GR03:

	POP SI
	POP DX
	POP CX
	POP BX
	POP BP

	RET


GRBXFILL ENDP
;
;
;****************************************************************
;
;	This function draws a colored dot in medium resolution
;	graphics mode. It is called from assembler procs as follows:
;		CX = ROW
;		DX = COLUMN
;		AX = COLOR
;


ASMDOT	PROC	NEAR

	JMP PASTDATA

BITTBL	DB	03FH,0CFH,0F3H,0FCH  ; mask to locate proper bits

COLRTBL	DB	00H,040H,080H,0C0H   ; table of color masks
	DB	00H,010H,020H,030H
	DB	00H,004H,008H,00CH
	DB	00H,001H,002H,003H

PASTDATA:
	PUSH BP			;save registers changed
	MOV BP,SP
	PUSH ES
	PUSH BX
	PUSH SI
	PUSH DI

	PUSH AX		;SAVE COLOR ON STACK FOR LATER USE

	MOV AX,0B800H	;point es to screen memory
	MOV ES,AX
	XOR DI,DI
	MOV AX,DX	 ;get row into ax and
	SHR AL,1         ;divide by two to get odd/even bit

	JNC EVENROW     ;even rows start at offset 0 and odd rows
	MOV DI,02000H   ;start at an offset 2000h 

EVENROW:
	SAL AX,1	;multiply row by 80 to get offset of correct
	SAL AX,1	;80 byte row for point
	SAL AX,1
	SAL AX,1
	MOV BX,AX
	SAL AX,1
	SAL AX,1
	ADD AX,BX	;now multiplied by 80

	ADD DI,AX	;add to odd/even offset for location in memory

	MOV AX,CX  	;get column
	MOV SI,AX	;store it in si
	SHR AX,1	;divide it by 4 to get specific byte (4 points/byte)
	SHR AX,1
	ADD DI,AX	;add to offset for exact byte - save it in di

	AND SI,03H		;mask off all bits except color bits
	MOV AL,CS:BITTBL[SI]	;get proper byte mask

	POP BX			;GET SAVED COLOR FROM STACK
	SHL SI,1		;multiply by 4 
	SHL SI,1
	ADD SI,BX		;add to color to get correct color mask

	AND AL,ES:[DI]		;mask memory byte with bit mask
	OR  AL,CS:COLRTBL[SI]	;or it with color mask
	MOV ES:[DI],AL		;move it back to memory

	POP DI		;restore original register values
	POP SI
	POP BX
	POP ES
	POP BP
	RET

ASMDOT	ENDP
;
IFDEF CI_C86

@CODE	ENDS

ELSE

ENDPS

ENDIF
	END



