;***********************************************************************/
;*	hdot.asm                                                      */
;***********************************************************************/
         PAGE ,132
         .SALL
;
INCLUDE MACROS.INC
INCLUDE BIOSDATA.INC

IFNDEF CI_C86      ; DEFINED IN CI-C86.INC
@BIGMODEL EQU 0    ; required for Lattice to define flag below	
PSEG               ; macro defined in Lattice xM8086.MAC file

ENDIF
;****************************************************************
;
;	This function draws a colored dot in medium resolution
;	graphics mode. It is called as follows:
; 		dot(col,row,color);
;	where:
;		int col,row;  /* row and coloumn coordinates of point
;		int color;    /* color value between 0 and 3 */
;

	PUBLIC DOT

IF @BIGMODEL+LPROG		;LARGE CODE MODELS
DOT	PROC	FAR
COL	EQU	6

ELSE
DOT	PROC	NEAR
COL	EQU	4
ENDIF

ROW	EQU	COL + 2
COLOR	EQU	COL + 4
	PUSH BP			;save BP for caller
	MOV BP,SP
	MOV CX,[BP+COL]                 ;get column into CX
        MOV DX,[BP+ROW]	                ;row into DX
	MOV AL,BYTE PTR [BP+COLOR]	;color into AL for INT call
        MOV AH,12                       ;write dot functions
        INT 10H                         ;video I/O interrupt
	POP BP
	RET
DOT	ENDP
;
IFDEF CI_C86
@CODE	ENDS
ELSE
ENDPS
ENDIF
	END
