/* demo3.c - graphics part of demo             */

#include "graphics.h"

demo3()
{
extern struct plotpos base;
extern int i,k,d1,d2,d3,dx[7],dy[7];
extern int l1[10],l2[10],l3[10];
extern int r1x[20],r1y[20],r2x[20],r2y[20],r3x[20],r3y[20];
extern int r4x[20],r4y[20];
extern char color;
int r,c,col,f;
char x[80];
/* check that color adapter is present */
/* if not, graphics can not be shown   */
if(color == 'n')
  {
  clrscrn();
  dispmsg(10,27,7,0,"NEED COLOR ADAPTER TO RUN");
  dispmsg(11,33,7,0,"GRAPHICS DEMO");
  dispmsg(24,23,7,0,"HIT ANY KEY TO RETURN TO DEMO MENU");
  getkeycl(&r);
  return;
  }
/* store points that will be used for plotting of points */
l1[0] = 177; l1[1] = 50;
l1[2] = 161; l1[3] = 50;
l1[4] = 131; l1[5] = 68;
l1[6] = 91; l1[7] = 108;
l1[8] = 41; l1[9] = 158;
l2[0] = 177; l2[1] = 50;
l2[2] = 161; l2[3] = 60;
l2[4] = 161; l2[5] = 80;
l2[6] = 145; l2[7] = 96;
l2[8] = 105; l2[9] = 256;
l3[0] = 177; l3[1] = 50;
l3[2] = 177; l3[3] = 53;
l3[4] = 160; l3[5] = 89;
l3[6] = 100; l3[7] = 149;
l3[8] = 40; l3[9] = 209;
 for(i = 0; i < 10; ++i)
  {
  r1x[i] = 50 + randnum(0,1000) % 120;
  r1y[i] = 57 + randnum(0,1000) % 260;
  r2x[i] = 50 + randnum(0,1000) % 120;
  r2y[i] = 57 + randnum(0,1000) % 260;
  r3x[i] = 50 + randnum(0,1000) % 120;
  r3y[i] = 57 + randnum(0,1000) % 260;
  r4x[i] = 50 + randnum(0,1000) % 120;
  r4y[i] = 57 + randnum(0,1000) % 260;
  } 
dx[0] = 110; dy[0] = 41;
dx[1] = 80; dy[1] = 60;
dx[2] = 165; dy[2] = 110;
dx[3] = 30; dy[3] = 160;
dx[4] = 95; dy[4] = 210;
dx[5] = 75; dy[5] = 260;
dx[6] = 165; dy[6] = 305;
menu:
initgraf(1,1,0);
strcpy(&x[0],"ESSENTIAL SOFTWARE GRAPHICS DEMO");
grxlab(&x[0],3,3,1);
strcpy(&x[0],"GRAPHICS MENU");
grxlab(&x[0],3,3,3);
strcpy(&x[0],"-------------");
grxlab(&x[0],3,3,4);
strcpy(&x[0],"1.BAR GRAPH");
grxlab(&x[0],3,3,5);
strcpy(&x[0],"2.COMPONENT BAR GRAPH");
grxlab(&x[0],3,3,6);
strcpy(&x[0],"3.SCATTER GRAPH");
grxlab(&x[0],3,3,7);
strcpy(&x[0],"4.ABOVE/BELOW LINE GRAPH");
grxlab(&x[0],3,3,8);
strcpy(&x[0],"5.LINE GRAPH");
grxlab(&x[0],3,3,9);
strcpy(&x[0],"6.PIE GRAPH");
grxlab(&x[0],3,3,10);
strcpy(&x[0],"7.MULTIPLE GRAPHS ON ONE SCREEN");
grxlab(&x[0],3,3,11);
strcpy(&x[0],"ENTER # OF GRAPH TO BE DISPLAYED");
grxlab(&x[0],2,3,13);
strcpy(&x[0],"OR ANY OTHER KEY TO EXIT:");
grxlab(&x[0],2,3,14);
strcpy(&x[0],"AFTER VIEWING A GRAPH, HIT ANY");
grxlab(&x[0],1,3,20);
strcpy(&x[0],"KEY TO RETURN TO GRAPHICS MENU");
grxlab(&x[0],1,3,21);
f = 0;
r = 0;
c = 0;
col = 1;
/* clear the keyboard before starting */
clearkbd();
for( ; ; )
  {
  if((i = checkkey()) == 1) break;
  dot(c,r,col);
  if(f == 0)
    {
    ++c;
    if(c == 320)
      {
      f = 1;
      c = 319;
      if(col == 3) col = 1;
        else ++col;
      }
    continue;
    }
  if(f == 1)
    {
    ++r;
    if(r == 200)
      {
      f = 2;
      r = 199;
      if(col == 3) col = 1;
        else ++col;
      }
    continue;
    }
  if(f == 2)
    {
    --c;
    if(c == -1)
      {
      f = 3;
      c = 0;
      if(col == 3) col = 1;
       else ++col;
      }
    continue;
    }
  if(f == 3)
    {
    --r;
    if(r == -1)
      {
      f = 0;
      r = 0;
      if(col == 3) col = 1;
        else ++col;
      }
    continue;
    }
  }
i = getkey(&k);
if((k < 49)||(k > 55)) goto done;
if(i != 0) goto done;
switch(k)
  {
  case 49: f1(); break;
  case 50: f2(); break;
  case 51: f3(); break;
  case 52: f4(); break;
  case 53: f5(); break;
  case 54: f6(); break;
  case 55: f7(); break;
  }
goto menu;
done:
setscmod(2);
}


f1()
{
initgraf(1,1,1);
/* bar graph */
grylab("% OF SALES",1,0,6);
grxlab("YEAR",1,18,24);
grxlab("1984",1,10,23);
grxlab("1983",1,21,23);
grxlab("1982",1,32,23);
grline(49,25,49,180,1);
grline(49,180,319,180,1);
grxlab("BAR GRAPH",1,15,0);
grxlab("KEY",1,32,1);
grxlab("PRODUCT 1",1,30,2);
grxlab("PRODUCT 2",1,30,3);
grxlab("PRODUCT 3",1,30,4);
grshdn(224,17,232,17,24,1,1);
grshdn(224,25,232,25,32,2,2);
grshdn(224,33,232,33,40,3,3);
grline(220,6,319,6,1);
grline(220,6,220,42,1);
grline(220,42,319,42,1);
grline(319,42,319,6,1);
for(i = 176; i > 25; i = i - 8)
  {
  if(i != 176) grxlab("-",1,5,(i / 8));
  if((i % 16) == 0)
    {
    switch((i /16))
      {
      case 10: grxlab("10",1,3,(i / 8)); break;
      case 9: grxlab("20",1,3,(i / 8)); break;
      case 8: grxlab("30",1,3,(i / 8)); break;
      case 7: grxlab("40",1,3,(i / 8)); break;
      case 6: grxlab("50",1,3,(i / 8)); break;
      case 5: grxlab("60",1,3,(i / 8)); break;
      case 4: grxlab("70",1,3,(i / 8)); break;
      case 3: grxlab("80",1,3,(i / 8)); break;
      case 2: grxlab("90",1,3,(i / 8)); break;
      }
    }
  }
grshdn(56,86,80,86,180,1,1);
grshdn(81,160,105,160,180,2,2);
grshdn(106,140,130,140,180,3,3);
grshdn(146,95,170,95,180,1,1);
grshdn(171,138,195,138,180,2,2);
grshdn(196,160,220,160,180,3,3);
grshdn(236,100,260,100,180,1,1);
grshdn(261,130,285,130,180,2,2);
grshdn(286,170,310,170,180,3,3);
i = getkey(&k);
}


f2()
{
/* component bar graph */
initgraf(1,1,1);
grylab("% OF SALES",1,0,6);
grxlab("YEAR",1,13,24);
grxlab("1984",1,7,23);
grxlab("1983",1,13,23);
grxlab("1982",1,19,23);
grline(49,19,49,180,1);
grline(49,180,182,180,1);
grxlab("COMPONENT BAR GRAPH",1,7,0);
grxlab("KEY",1,32,1);
grxlab("PRODUCT 1",1,30,2);
grxlab("PRODUCT 2",1,30,3);
grxlab("PRODUCT 3",1,30,4);
grshdn(224,17,232,17,24,1,1);
grshdn(224,25,232,25,32,2,2);
grshdn(224,33,232,33,40,3,3);
grline(220,6,319,6,1);
grline(220,6,220,42,1);
grline(220,42,319,42,1);
grline(319,42,319,6,1);
for(i = 176; i > 15; i = i - 8)
  {
  if(i != 176) grxlab("-",1,5,(i / 8));
  if((i % 16) == 0)
    {
    switch((i /16))
      {
      case 10: grxlab("10",1,3,(i / 8)); break;
      case 9: grxlab("20",1,3,(i / 8)); break;
      case 8: grxlab("30",1,3,(i / 8)); break;
      case 7: grxlab("40",1,3,(i / 8)); break;
      case 6: grxlab("50",1,3,(i / 8)); break;
      case 5: grxlab("60",1,3,(i / 8)); break;
      case 4: grxlab("70",1,3,(i / 8)); break;
      case 3: grxlab("80",1,3,(i / 8)); break;
      case 2: grxlab("90",1,3,(i / 8)); break;
      case 1: grxlab("100",1,2,i/8); break;
      }
    }
  }
grshdn(60,86,82,86,180,1,1);
grshdn(60,50,82,50,85,2,2);
grshdn(60,19,82,19,49,3,3);
grshdn(108,100,130,100,180,1,1);
grshdn(108,60,130,60,99,2,2);
grshdn(108,19,130,19,59,3,3);
grshdn(156,121,178,121,180,1,1);
grshdn(156,70,178,70,120,2,2);
grshdn(156,19,178,19,69,3,3);
i = getkey(&k);
}


f3()
{
/* scatter graph */
initgraf(1,1,1);
grylab("PRICE",1,0,10);
grxlab("VOLUME",1,17,24);
grxlab("SCATTER GRAPH",1,13,0);
grxlab("(points by random # func.)",1,0,1);
for(i = 168; i > 17; i = i - 8)
  {
  if(i != 168) grxlab("-",1,5,(i / 8));
  if((i % 16) == 0)
    {
    switch((i / 16))
      {
      case 10: grxlab("$10",1,2,(i / 8)); break;
      case 9: grxlab("$20",1,2,i / 8); break;
      case 8: grxlab("$30",1,2,i / 8); break;
      case 7: grxlab("$40",1,2,i / 8); break;
      case 6: grxlab("$50",1,2,i / 8); break;
      case 5: grxlab("$60",1,2,i / 8); break;
      case 4: grxlab("$70",1,2,i / 8); break;
      case 3: grxlab("$80",1,2,i / 8); break;
      case 2: grxlab("$90",1,2,i / 8); break;
      }
    }
  }
for(i = 80; i < 310; i = i + 32)
  {
  grline(i+3,176,i+3,181,1);
  switch(i)
    {
    case 80: grxlab("1",1,i/8,23); break;
    case 112: grxlab("2",1,i/8,23); break;
    case 144: grxlab("3",1,i/8,23); break;
    case 176: grxlab("4",1,i/8,23); break;
    case 208: grxlab("5",1,i/8,23); break;
    case 240: grxlab("6",1,i/8,23); break;
    case 272: grxlab("7",1,i/8,23); break;
    case 304: grxlab("8",1,i/8,23); break;
    }
  }
grline(49,25,49,172,1);
grline(49,172,319,172,1);
grxlab("KEY",1,32,1);
grxlab("PRODUCT 1",1,30,2);
grxlab("PRODCUT 2",1,30,3);
grxlab("PRODUCT 3",1,30,4);
grxlab("PRODUCT 4",1,30,5);
dot(224,19,1);
grwx(224,27,2);
grbx(224,35,3);
grdiab(224,43,1);
grline(220,6,319,6,1);
grline(220,6,220,50,1);
grline(220,50,319,50,1);
grline(319,50,319,6,1);
for(i = 0; i < 10; ++i)
  {
  dot(r1y[i],r1x[i],1);
  grwx(r2y[i],r2x[i],2);
  grbx(r3y[i],r3x[i],3);
  grdiab(r4y[i],r4x[i],1);
  }
i = getkey(&k);
}


f4()
{
/* above/below graph */
initgraf(1,1,0);
grxlab("ABOVE",3,8,0);
grxlab("----- SHADED LINE GRAPH",3,8,1);
grxlab("BELOW",3,8,2);
grline(41,25,41,172,3);
grline(41,172,305,172,3);
grylab("PROFIT IN THOUSANDS",1,0,3);
grxlab("POINT IN TIME",1,13,24);
grline(62,176,62,181,3);
grline(159,176,159,181,3);
grline(291,176,291,181,3);
grxlab("1/84",3,6,23);
grxlab("7/84",3,18,23);
grxlab("12/84",3,34,23);
for(i = 168; i > 17; i = i - 16)
  {
  if(i != 16)
    {
    switch(i)
      {
      case 152: grxlab("-$4",3,2,i/8); break;
      case 136: grxlab("-$3",3,2,i/8); break;
      case 120: grxlab("-$2",3,2,i/8); break;
      case 104: grxlab("-$1",3,2,i/8); break;
      case 88: grxlab("0",3,4,i/8); break;
      case 72: grxlab("+$1",3,2,i/8); break;
      case 56: grxlab("+$2",3,2,i/8); break;
      case 40: grxlab("+$3",3,2,i/8); break;
      case 24: grxlab("+$4",3,2,i/8); break;
      }
    }
  }
for(i = 0; i < 6; ++i)
  {
  grshup(dy[i],dx[i],dy[i+1],dx[i+1],91,3,2);
  grshdn(dy[i],dx[i],dy[i+1],dx[i+1],91,3,1);
  }
grline(41,91,305,91,3);
i = getkey(&k);
}


f5()
{
/* line graph */
initgraf(1,1,0);
grline(49,19,49,177,3);
grline(49,177,319,177,3);
grxlab("LINE,DOT,DASH GRAPH",3,7,0);
grxlab("KEY",3,32,1);
grxlab("PRODUCT 1",3,30,2);
grxlab("PRODUCT 2",3,30,3);
grxlab("PRODUCT 3",3,30,4);
grline(224,19,232,19,1);
grdotb(224,27,232,27,2);
grdash(224,35,232,35,3);
grline(220,6,319,6,3);
grline(220,6,220,42,3);
grline(220,42,319,42,3);
grline(319,42,319,6,3);
for(i = 176; i > 15; i = i - 8)
  {
  if(i != 176) grylab("-",1,5,(i / 8));
  if((i % 16) == 0)
    {
    switch((i /16))
      {
      case 10: grxlab("10",3,3,i/8); break;
      case 9: grxlab("20",3,3,i/8); break;
      case 8: grxlab("30",3,3,i/8); break;
      case 7: grxlab("40",3,3,i/8); break;
      case 6: grxlab("50",3,3,i/8); break;
      case 5: grxlab("60",3,3,i/8); break;
      case 4: grxlab("70",3,3,i/8); break;
      case 3: grxlab("80",3,3,i/8); break;
      case 2: grxlab("90",3,3,i/8); break;
      case 1: grxlab("100",3,2,i/8); break;
      }
    }
  }
for(i = 80; i < 310; i = i + 32)
  {
  grline(i+3,178,i+3,181,1);
  switch(i)
    {
    case 80: grxlab("1",3,i/8,23); break;
    case 112: grxlab("2",3,i/8,23); break;
    case 144: grxlab("3",3,i/8,23); break;
    case 176: grxlab("4",3,i/8,23); break;
    case 208: grxlab("5",3,i/8,23); break;
    case 240: grxlab("6",3,i/8,23); break;
    case 272: grxlab("7",3,i/8,23); break;
    case 304: grxlab("8",3,i/8,23); break;
    }
  }
for(i=0;i<4;++i)grline(l1[(i*2)+1],l1[i*2],l1[(i*2)+3],l1[(i*2)+2],1);
for(i=0;i<4;++i)grdotb(l2[(i*2)+1],l2[i*2],l2[(i*2)+3],l2[(i*2)+2],2);
for(i=0;i<4;++i) grdash(l3[(i*2)+1],l3[i*2],l3[(i*2)+3],l3[(i*2)+2],3);
i = getkey(&k);
}


f6()
{
/* pie charts */
initgraf(1,1,1);
grxlab("PIE GRAPHS",1,15,2);
grxlab("KEY",1,32,1);
grxlab("PRODUCT 1",1,30,2);
grxlab("PRODUCT 2",1,30,3);
grxlab("PRODUCT 3",1,30,4);
grshdn(224,17,232,17,24,1,1);
grshdn(224,25,232,25,32,2,2);
grshdn(224,33,232,33,40,3,3);
grline(220,6,319,6,1);
grline(220,6,220,42,1);
grline(220,42,319,42,1);
grline(319,42,319,6,1);
grxlab("NORMAL",1,7,20);
grxlab("EMPHASIZING",1,24,20);
grxlab("ONE SLICE",1,25,21);
grarc(80,100,50,1,0,215,1,1);
grarc(80,100,50,1,215,315,2,1);
grarc(80,100,50,1,315,359,3,1);
grarc(230,100,50,1,0,157,1,1);
grarc(225,100,50,1,160,220,2,1);
grarc(230,100,50,1,221,360,3,1);
i = getkey(&k);
}


f7()
{
/* multiple graphs on a page */
initgraf(1,1,0);
grxlab("MULTIPLE GRAPHS ON ONE SCREEN",1,3,0);
grline(40,10,40,90,1);
grline(40,90,130,90,1);
grxlab("BAR GRAPH",1,6,12);
grshdn(42,45,72,45,89,1,1);
grshdn(73,30,103,30,89,2,2);
grshdn(104,40,128,40,89,3,3);
grline(150,90,230,90,1);
grline(150,10,150,90,1);
grxlab("LINE GRAPH",1,19,12);
grline(150,90,170,70,1);
grline(170,70,210,50,1);
grdotb(150,90,180,80,2);
grdotb(180,80,210,20,2);
grdash(150,90,180,50,3);
grdash(180,50,190,30,3);
grxlab("PIE GRAPH",1,6,24);
grarc(78,146,38,1,0,45,1,1);
grarc(78,146,38,1,45,215,2,1);
grarc(78,146,38,1,215,360,3,1);
grline(150,110,150,184,1);
grline(150,184,230,184,1);
grxlab("AREA GRAPH",1,19,24);
grshdn(152,184,180,150,183,1,1);
grshdn(180,150,210,160,183,2,2);
grshdn(210,160,230,140,183,3,3);
i = getkey(&k);
}
