;	THIS PROGRAM IS USED TO SET THE STATE OF THE NUM LOCK,
;	CAPS LOCK, AND SCROLL LOCK KEYS AS FOLLOWS:

;	KEYS C[O],N[O],S[O]

;	WHERE C = CAPS LOCK, N = NUM LOCK, AND S = SCROLL LOCK.
;	SPECIFYING THE LETTER BY ITSELF TURNS THE AFFECTED KEY ON.
;	SPECIFYING O AFTER THE LETTER TURNS THE KEY OFF.

;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  25-JUL-88

BIOS	SEGMENT AT 40H
	ORG	17H
KEYFLG	LABEL	BYTE			;DEFINE KEY FLAG
BIOS	ENDS

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:BIOS,SS:CODE
	ORG	100H

START:	MOV	SI,OFFSET 80H		;POINT TO USER ARGUMENT
	LODSB				;GET COUNT
	OR	AL,AL			;ANY ARGUMENT?
	JNZ	GOTARG			;YES
EXPL:	MOV	DX,OFFSET EXPMSG
	MOV	AH,9
	INT	21H			;ELSE, EXPLAIN PROGRAM
	INT	20H			;AND EXIT
GOTARG:	MOV	CL,AL
	XOR	CH,CH			;CX = COUNT
	MOV	BX,CX			;COUNT TO BX
	MOV	BYTE PTR [BX+SI],13	;TERMINATE STRING
SOS:	CMP	BYTE PTR [SI],' '	;CHECK FOR SPACES
	JNZ	NOTSP			;NOT ONE
	INC	SI			;SKIP SPACES
	LOOP	SOS
	JMP	EXPL			;ALL CHARACTERS USED
NOTSP:	MOV	AX,40H
	MOV	ES,AX			;POINT TO BIOS RAM
KEYLP:	LODSB				;GET CHARACTER
	CMP	AL,13			;END OF STRING?
	JNZ	NOTEND
EXIT:	INT	20H			;ESLE, EXIT
NOTEND:	OR	AL,20H			;MAKE LOWER CASE
	MOV	DL,01000000B		;ASSUME CAPS LOCK
	CMP	AL,'c'			;SET CAPS LOCK STATE?
	JZ	SETKEY			;YES
	MOV	DL,00100000B		;ASSUME NUM LOCK
	CMP	AL,'n'			;SET NUM LOCK STATE?
	JZ	SETKEY			;YES
	MOV	DL,00010000B		;ASSUME SCROLL LOCK
	CMP	AL,'s'			;SET SCROLL LOCK STATE?
	JZ	SETKEY			;YES
	JMP	EXPL			;BAD ENTRY
SETKEY:	LODSB				;GET NEXT CHARACTER
	OR	AL,20H			;MAKE LOWER CASE
	CMP	AL,'o'			;TURN OFF KEY?
	JNZ	KEYON			;NO, TURN IT ON
	LODSB				;ELSE, SKIP COMMA
	NOT	DL			;INVERT FLAG
	AND	ES:KEYFLG,DL		;CLEAR SPECIFIED KEY
CHKEND:	CMP	AL,13
	JZ	EXIT			;END OF STRING
	JMP	KEYLP
KEYON:	OR	ES:KEYFLG,DL		;TURN ON SPECIFIED KEY
	AND	AL,0FFH-20H		;FIX CHARACTER
	JMP	CHKEND

EXPMSG	DB	13,10,'Key control program, v. 1.0',13,10
	DB	'To use this program, enter',13,10,10
	DB	'  KEYS C[O],N[O],S[O]',13,10,10
	DB	'where C = Caps Lock, N = Num Lock, and',13,10
	DB	'S = Scroll Lock.  Specify the key',13,10
	DB	'designator by itself to turn the state',13,10
	DB	'of the key on.  Specify O after the',13,10
	DB	'designator to turn the key off.',13,10,'$'

CODE	ENDS
	END	START
