;***********************************************************************/
;*	sound.asm                                                     */
;***********************************************************************/
;
INCLUDE MACROS.INC
INCLUDE BIOSDATA.INC

IFDEF MSDOS        ; DEFINED IN LATTICE 2.X M8086.MAC
PSEG
ENDIF
;
;***************************************************************************
;
;	This subroutine produces a frequency of specific duration on
;	the speaker. It functions like the SOUND command in Basic.
;	It is called as follows:
;
;		sound(frequency,duration);
;		where: 
;			int frequency; - the frequency in megahurtz
;			unsigned duration; - in clock ticks, between
;					     0 and 65535. There are
;					     approximately 18.2 ticks
;					     per second.
;
;
	PUBLIC SOUND

if @bigmodel+LPROG
	SOUND	PROC FAR
	bigoff  equ  2
else
	SOUND	PROC NEAR
	bigoff  equ  0
endif
	PUSH BP		;STANDARD FUNCTION SETUP
	MOV BP,SP
	PUSH DS
	MOV CX,[BP+4+bigoff]	;GET FREQUENCY
	CMP CX,0	;IF FREQUENCY IS 0 => REST
	JE S10		;DON'T TOUCH SPEAKER AND COUNT DELAY
	MOV DX,12H	;
	MOV AX,34DCH	;
	DIV CX
	PUSH AX		;PASS PARAMETER TO SUBROUTINE CALLED
	CALL SPEAKERON
	POP AX		;CLEAR STACK OF PARAMETER
S10:
	MOV CX,[BP+6+bigoff]	;GET DURATION INTO COUNTER FOR S20 LOOP
	CMP CX,0	;
	JE S30		; IF 0 DURATION, TURN OFF SPEAKER & EXIT
	MOV AX,BIOS_DATA
	MOV DS,AX	;SET UP DATA SEGMENT TO BIOS FOR ADDRESSING
	ASSUME DS:BIOS_DATA
	MOV AX,TIMER_LOW
S20:
	CMP AX,TIMER_LOW	;WAIT UNTIL TIMER COUNTER IS 
				;INCREMENTED => ONE TICK
	JE S20		;LOOP UNTIL ONE TICK
	INC AX		;INC TIMER TICK FOR NEXT LOOP ITERATION
	LOOP S20	;LOOP FOR CX TICKS
S30:
	PUSH CX		;COUNTER = 0 EITHER FROM COUNTDOWN OF 
			;S20 LOOP OR PASSED PARAMETER. PASSED AS
			;PARAMETER TO TURN OFF SPEAKER
	CALL SPEAKERON
	POP CX
	POP DS
	POP BP
	RET 
SOUND	ENDP
;
;	SPEAKERON
;
;	THIS SUBROUTINE EITHER TURNS THE SPEAKER ON OR OFF. TO TURN
;	IT ON, IT IS PASSEDBA FREQUENCY DIVISOR WHICH IS PASSED
;	TO THE SYSTEM TIMER TO CONTROL THE SPEAKER.
;	IT IS CALLED AS FOLLOWS:
;		SPEAKERON(FREQ_DIV);
;		WHERE:
;			UNSIGNED FREQ_DIV; - DIVISOR TO PLACE IN
;			SYSTEM TIMER TO BE USED TO CONTROL SPEAKER
;
SPEAKERON	PROC NEAR
	PUSH BP		;STANDARD SETUP
	MOV BP,SP
	IN AL,61H	;GET CURRENT PORT SETTING
	AND AL,0FCH	;SETTING TO TURN OFF SPEAKER
	OUT 61H,AL	;TURN OFF SPEAKER
	MOV AL,10110110B
	OUT 43H,AL
	MOV AX,[BP+4]	;GET FREQUENCY DIVISOR
	CMP AX,0	;IS IT = 0?
	JE SP10		;IF YES, JUST EXIT
	OUT 42H,AL	;OUTPUT LOW ORDER BYTE TO PORT FIRST
	MOV AL,AH	;PREPARE HIGH ORDER BYTE FOR OUT INSTRUCTION
	OUT 42H,AL	;OUTPUT HIGH ORDER BYTE TO TIMER PORT
	IN AL,61H	;GET CURRENT PORT SETTING
	OR AL,3		;TURN ON TWO LOW ORDER BITS FOR SPEAKER ON
			;UNDER CONTROL OF TIMER PORT
	OUT 61H,AL	;TURN SPEAKER ON
SP10:
	POP BP
	RET
SPEAKERON ENDP

;***********************************************************************
;
IFDEF CI_C86
@CODE	ENDS
ELSE
ENDPS
ENDIF
	END
