/***********************************************************************/
/*	seekfil.c                                                     */
/***********************************************************************/

/* move to specific location in file */
seekfil(handle,method,bytes,location)
unsigned handle; /* 16 bit handle from openfil */
int method; /* 0,1 or 2 */
long bytes; /* number of bytes to move in file */
long *location; /* new location in file returned */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  int temp; /* temporary int set up for breaking longs into two ints */

  if ( method < 0 || method > 3 ) /* invalid access method check */
       return(-1);
  regs.ds=regs.es=0; /* default es reg. */
  regs.bh=handle/256;  /* handle loaded into bx register */
  regs.bl=handle - (regs.bh*256);
  temp=bytes/65536; /* two high bytes of bytes placed in temp */
  regs.ch=temp/256; /* now load these two bytes into cx register */
  regs.cl=temp - (regs.ch*256);
  temp=bytes-temp;  /* two low bytes of bytes into temp */
  regs.dh=temp/256; /* now load these two bytes into dx register */
  regs.dl=temp - (regs.dh*256);
  regs.al=method;
  regs.ah=0x42;  /* DOS function number */
  int_no=0x21;  /* interrupt number for DOS function call */
  ret_code = gdosint(int_no,&regs,&regs);
  *location=(((regs.dh*256)+regs.dl)*65536) + ((regs.ah*256)+regs.al); 
             /* two high bytes of location returned in dx */
             /* two low bytes returned in ax              */
  return(ret_code);
}
