PAGE ,132

	TITLE SCDMPCIT - Z-100/Z-150 SCREEN DUMP UTILITY
;                   Version 3.52   30-Dec-86

;	for C. Itoh 8510A/1550/1570/M24LQ and NEC 8023A Printers
 
;	Written by Les Bordelon - All Rights Reserved

;	Usage:  SCDMP<cr>

;		 loads screen dump and set defaults to:

;		   bank: All (if only one VRAM bank, green) - Z-100
;		    or
;		   mode: Graphics			    - Z-150

;		   image: Negative
;		   density: Standard
;		   25th line: Dumped, if displayed

;	or	SCDMP wxyz<cr>  for Z-100

;		 loads screen dump and changes defaults to:

;	           w = <B>lue, <R>ed, <G>reen or <T>ext - Z-100
;		    or
;		   w = <T>ext				- Z-150

;		   x = <P>ositive image

;		   y = <S>tandard, <M>edium, or <H>igh density - 8510/8023A
;		    or
;		   y = <S>tandard or <H>igh density            - M24LQ

;		   z = <D>o not dump 25th line, unless requested


;	Activation:  <SHIFT-F12>[U][V][W][X][Y][Z]     for Z-100
;		      or
;		     <SHIFT-PrtSc>[U][V][W][X][Y][Z]   for Z-150

;		 initiates screen dump and sets parameters to:

;	           U = <A>ll, <B>lue, <R>ed, <G>reen or <T>ext - Z-100
;		    or
;		   U = <G>raphics or <T>ext		       - Z-150

;		   V = <N>egative or <P>ositive image

;		   W = <S>tandard, <M>edium, or <H>igh density - 8510/8023A
;		    or
;		   W = <S>tandard or <H>igh density            - M24LQ

;		   X = <D>ump/<D>o not dump 25th line
;		   Y = <C>hange default settings
;		   Z = <Q>uery default settings


;	Credits:  Zenith Data Systems 	      - Interrupt-5 routine (PSC)
;		  Digital Information Systems - Original Graphic Routines

;	Definitions 

FALSE	=	0
TRUE	=	NOT FALSE

;	Set Z100 to TRUE for Z-100 or FALSE for Z-150

Z100	=	TRUE
Z150	=	NOT Z100

;	Set ZPC to TRUE if Z150 version to be used on Z100 under ZPC

ZPC	=	FALSE

;	Set C_ITOH to TRUE for C. Itoh or FALSE for NEC

C_ITOH	=	TRUE
NEC	=	NOT C_ITOH

;	Set M24LQ to TRUE if C. Itoh M24LQ/1570 or FALSE if C. Itoh 8510/1550

M24LQ	=	FALSE
C8510	=	NOT M24LQ

;	Set CLOCK_8 to TRUE if higher clock speed

CLOCK_8	=	FALSE


IF Z100
BIOS_SEG SEGMENT AT 40H 			;bios location
	ORG 1*3
  BIOS_STATUS	LABEL FAR			;console status
	ORG 2*3
  BIOS_CONIN	LABEL FAR			;console input
	ORG 3*3
  BIOS_CONOUT	LABEL FAR			;console output
	ORG 4*3
  BIOS_PRINT	LABEL FAR			;printer output 
BIOS_SEG ENDS

;  	If monitor version = 1, then change MTR_VERP ORG to 0290H or 
;		the 25th line will not be printed.

MTR_D_SEG SEGMENT AT 0				;ROM monitor data
	ORG	007FH
  MTR_RDC	DD ?				;addr of read displayed char
	ORG	0292H
  MTR_VERP	DB ?				;vertical position of cursor
MTR_D_SEG ENDS

IPAGE_SEG SEGMENT AT 0				;the interrupt area page
	ORG	03FEH
  MTR_DS	LABEL WORD			;location of monitor DS value
IPAGE_SEG ENDS

ELSE

DMPSTAT	SEGMENT AT 0				;current dump status
	ORG	500H
  DMP_CHK	LABEL BYTE
DMPSTAT	ENDS
ENDIF

CMDBUF	EQU	80H

CODE	SEGMENT PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	100H

;*****************ENTRY POINT******************

BEGIN:
	JMP	START


CHECK	DB	'SCREEN DUMP version 3.52'
CHECKLN EQU	$-CHECK
DEFCLR	DB	'G'
DEFDEN	DB	'S'
DEFL25	DB	25D
DEFIMG	DB	'N'

IF Z100
BANKS	DB	0
ENDIF

	DB	' Copyright (c) 1985, 1986, Bordelon Software '

;************INTERRUPT_5 HANDLER***************

INT_5:
	PUSH	DS				;save previous data segment
	PUSH	AX

IF Z150
	SUB	AX,AX				;check current dump status
	MOV	DS,AX
	MOV	AL,01
	XCHG	AL,DS:DMP_CHK
	CMP	AL,01
	JZ	IT3				;exit if already in dump mode
ENDIF

	MOV	CS:INT_SP,SP
	MOV	CS:INT_SS,SS			;save previous stack

	MOV	AX,CS
	MOV	SS,AX				;set local stack
	MOV	SP,OFFSET INT_STACK

	STI					;now allow interrupts

	PUSH	ES
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI

	MOV	DS,AX
	MOV	ES,AX				;set up new segments

	MOV	AL,DEFDEN			;set defaults - print density
	MOV	DENFLG,AL
	MOV	BYTE PTR L25FLG,0		; 25th line
	MOV	BYTE PTR CHGFLG,0
	MOV	AL,DEFCLR			; VRAM bank/mode
	MOV	CLRFLG,AL
	MOV	AL,DEFIMG			; and image
	MOV	IMGFLG,AL

IF Z100
	CALL	INT_SIZE			;size screen
ELSE
	MOV	WORD PTR LINES,25D		;size screen
ENDIF

	CALL	INT_SCRN			;process the screen

	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	ES

	CLI					;INTs off while messing around
	MOV	AX,INT_SP
	MOV	SP,AX
	MOV	AX,INT_SS			;restore original stack
	MOV	SS,AX

IF Z100
	POP	AX
	POP	DS
	IRET					;back to bios
ELSE
	SUB	AX,AX
	MOV	DS,AX
	MOV	BYTE PTR DS:DMP_CHK,00		;reset status bit

	POP	AX
	POP	DS
	CMP	BYTE PTR CS:VRAM_MD,04		;check video status
	JB	IT2				;if text mode, do text dump
	IRET					;else, back to bios

IT2:	JMP	CS:DWORD PTR TXTINT5		;jump to text int 5

IT3:	POP	AX
	POP	DS
	IRET					;back to bios
ENDIF

INT_SS	DW	0				;saved stack values
INT_SP	DW	0
LINES	DW	0				;minimum lines

IF Z100
INT_CX	DW	0				;current X location
INT_CY	DW	0				;current Y location
MYCHR	DW	0				;character at position

ELSE

TXTINT5	DW	00				;text dump interrupt address
	DW	00
ENDIF

	DW	128 DUP (?)

INT_STACK LABEL NEAR				;internal stack

IF Z100
;*****************SIZE SCREEN******************

;	INT_SIZE checks to see if the 25th line is enabled. If
;	it is, LINES is modified to be 25, so all lines are
;	printed


INT_SIZE:
	MOV	WORD PTR LINES,24		;assume not
	MOV	SI,OFFSET INT_SIZA		;print first line
	CLI					;don't interrupt me now
	CALL	INT_PLINE			;output line
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX				;get data segment
	MOV	DS,DS:[MTR_DS]
	MOV	AL,DS:[MTR_VERP]		;AL=vertical position of cursor
	POP	DS
	PUSH	AX
	MOV	SI,OFFSET INT_SIZB		;put cursor back
	CALL	INT_PLINE			;output line
	STI
	POP	AX
	CMP	AL,24
	JNZ	INT_SIZ1			;if not on 24th line

;	Cursor moved to 25th line, must be enabled

	INC	WORD PTR LINES

INT_SIZ1:
	RET

INT_SIZA LABEL	NEAR
	DB	01BH,'j'			;save cursor
	DB	01BH,'Y',25+31,1+31		;go here
	DB	-1				;end of message

INT_SIZB LABEL	NEAR
	DB	01BH,'k'			;restore cursor
	DB	-1

INT_PLINE:
	MOV	AL,BYTE PTR [SI]		;get character
	INC	SI				;bump for next time
	CMP	AL,-1
	JZ	INT_PLIN1			;if end of text
	PUSH	SI
	CALL	FAR PTR BIOS_CONOUT		;output it
	POP	SI
	JMP	SHORT INT_PLINE 		;do next

INT_PLIN1:
	RET

ENDIF

VRAM_MD	DB	0
CLRFLG	DB	0
DENFLG	DB	0
L25FLG	DB	0
IMGFLG	DB	0
CHGFLG	DB	0
G_CHR	DB	0
SCN_LN	DW	0
CUR_RO	DW	0
COL_INR DW	0

IF C_ITOH AND M24LQ
G_CHR1	DB	0
G_CHR2	DB	0
G_CHR3	DB	0
CNT	DB	0
ENDIF

;************VIDEO ADDRESS TABLE***************

IF Z100

ROW_DAT DW	00				;Z-100 address table
L24	DW	50176D
L23	DW	48128D
L22	DW	46080D
L21	DW	44032D
L20	DW	41984D
L19	DW	39936D
L18	DW	37888D
L17	DW	35840D
L16	DW	33792D
L15	DW	31744D
L14	DW	29696D
L13	DW	27648D
L12	DW	25600D
L11	DW	23552D
L10	DW	21504D
L09	DW	19456D
L08	DW	17408D
L07	DW	15360D
L06	DW	13312D
L05	DW	11264D
L04	DW	09216D
L03	DW	07168D
L02	DW	05120D
L01	DW	03072D
L00	DW	01024D
ETAB	DW	0000

ELSE

ROW_DAT DW	00				;Z-150 address table
L24	DW	16112D
L23	DW	15792D
L22	DW	15472D
L21	DW	15152D
L20	DW	14832D
L19	DW	14512D
L18	DW	14192D
L17	DW	13872D
L16	DW	13552D
L15	DW	13232D
L14	DW	12912D
L13	DW	12592D
L12	DW	12272D
L11	DW	11952D
L10	DW	11632D
L09	DW	11312D
L08	DW	10992D
L07	DW	10672D
L06	DW	10352D
L05	DW	10032D
L04	DW	09712D
L03	DW	09392D
L02	DW	09072D
L01	DW	08752D
L00	DW	08432D
ETAB	DW	0000

ENDIF

;***************END TO TABLE*********************

ADDR	DW	0000

;***INT_SCRN - INTERRUPT TIME SCREEN PROCESSOR***

INT_SCRN:

IF Z100
	MOV	DX,0D8H				;video port
	IN	AL,DX				;get current status
	MOV	VRAM_MD,AL			;store it
	MOV	AL,78H				;enable video port
	OUT	DX,AL
ELSE
	MOV	AH,0FH				;get current video status
	INT	10H
	MOV	VRAM_MD,AL			;store it
ENDIF

DE_LAY:
	MOV	DX,5D				;set max number of char input

IF Z100 OR ZPC
IF CLOCK_8
	MOV	BX,300D
ELSE
	MOV	BX,200D 
ENDIF
ENDIF

IF Z150 AND NOT ZPC
IF CLOCK_8
	MOV	BX,35D
ELSE
	MOV	BX,20D 
ENDIF
ENDIF

DL1:	DEC	DX
DL2:	MOV	CX,1000D			;initialize delay loop 2
DL3:	DEC	CX				;delay loop 1

IF Z100 OR ZPC
	IN	AL,0F5H				;check for char avail
	TEST	AL,01H
	JZ	DL4				;no, continue
	IN	AL,0F4H				;else get char
ELSE
	MOV	AH,01H				;check for char avail
	INT	16H
	JZ	DL4				;no, continue
	MOV	AH,0	 			;else get char
	INT	16H
ENDIF

	JMP	SHORT GET_ARG

DL4:	CMP	CX,0
	JG	DL3
	DEC	BX				;delay loop 2
	CMP	BX,0
	JG	DL2
	JMP	CHK_CHNG

GET_ARG:
	AND	AL,0DFH				;force to upper case

IF Z100
	CMP	BANKS,33H			;check # VRAM banks
	JNE	GA3				;only one bank, continue
	CMP	AL,'B'				;check for 'B'
	JNE	GA1				;nope
	JMP	SHORT GA5			;set color flag for blue
GA1:	CMP	AL,'R'				;check for 'R'	
	JNE	GA2				;nope
	JMP	SHORT GA5			;set color flag for red
GA2:	CMP	AL,'A'				;check for 'A'
	JNE	GA3				;nope
	JMP	SHORT GA5			;set color flag for all banks
ENDIF

GA3:	CMP	AL,'G'				;check for 'G'
	JNE	GA4				;nope
	JMP	SHORT GA5			;set color/mode flag for green
GA4:	CMP	AL,'T'				;check for 'T'
	JNE	GA6				;nope
GA5:	MOV	CLRFLG,AL			;set color/mode flag for text
	JMP	SHORT GA17
GA6:	CMP	AL,'P'				;check for 'P'
	JNE	GA7				;nope
	JMP	SHORT GA8			;set image flag for positive
GA7:	CMP	AL,'N'				;check for 'N'
	JNE	GA9				;nope
GA8:	MOV	IMGFLG,AL			;set image flag for negative
	JMP	SHORT GA17
GA9:	CMP	AL,'H'				;check for 'H'

IF C_ITOH AND M24LQ
	JNE	GA11				;nope
	JMP	SHORT GA12
ELSE
	JNE	GA10				;nope
	JMP	SHORT GA12			;set density flag for high
GA10:	CMP	AL,'M'				;check for 'M'
	JNE	GA11				;nope
	JMP	SHORT GA12			;set density flag for medium
ENDIF

GA11:	CMP	AL,'S'				;check for 'S'
	JNE	GA13				;nope
GA12:	MOV	DENFLG,AL			;set density flag for standard
	JMP	SHORT GA17
GA13:	CMP	AL,'D'				;check for 'D'
	JNE	GA14				;nope
	MOV	L25FLG,AL			;set to 24 line screen
	JMP	SHORT GA17	
GA14:	CMP	AL,'C'				;check for 'C'
	JNE	GA15				;nope
	JMP	SHORT GA16			;set to change flag
GA15:	CMP	AL,'Q'				;check for 'Q'
	JNE	GA17				;nope
GA16:	MOV	CHGFLG,AL			;set to change flag
GA17:	CMP	DX,0				;more characters to get?
	JBE	CHK_CHNG			;no, continue
	JMP	DL1				;yes, go get

CHK_CHNG:
	CMP	CHGFLG,0			;check for change flag
	JNE	CC1				;no, continue
	JMP	GET_SIZE
CC1:	CMP	CHGFLG,'C'			;change defaults?
	JNE	CHK_QURY			;no, then print defaults
	MOV	AL,CLRFLG			;get color/mode flag
	CMP	DEFCLR,AL			;was change made?
	JE	CC2				;no change, continue
	MOV	DEFCLR,AL			;reset color/mode default
CC2:	MOV	AL,IMGFLG			;get image flag
	CMP	DEFIMG,AL			;was change made?
	JE	CC3				;no change, continue
	MOV	DEFIMG,AL			;reset image flag
CC3:	MOV	AL,DENFLG			;get density flag
	CMP	DEFDEN,AL			;was change made?
	JE	CC4				;no change, continue
	MOV	DEFDEN,AL			;reset density default
CC4:	CMP	L25FLG,0			;was change made?
	JE	CC6				;no change, continue
	CMP	DEFL25,25D			;is default 25 lines?
	JE	CC5				;yes, reset to 24 lines
	MOV	DEFL25,25D			;no, reset to 25 lines
	JMP	SHORT CC6
CC5:	MOV	DEFL25,24D
CC6:	MOV	AL,07H				;sound bell to indicate 

IF Z100
	CALL	FAR PTR BIOS_CONOUT		; defaults reset
ELSE
	MOV	BX,0000H			; defaults reset
	MOV	AH,0EH
	INT	10H
ENDIF

	JMP	SHORT CQ3			;exit

CHK_QURY:
	MOV	SI,OFFSET DEFMSG1		;get default message signon
	CALL	PRT_MSG				;print it
	MOV	SI,OFFSET DEFMSG2		;get VRAM default message
	CALL	PRT_MSG				;print it
	MOV	AL,DEFCLR
	CALL	CPRN
	MOV	SI,OFFSET DEFMSG3		;get image default message
	CALL	PRT_MSG				;print it
	MOV	AL,DEFIMG
	CALL	CPRN
	MOV	SI,OFFSET DEFMSG4		;get density default message
	CALL	PRT_MSG				;print it
	MOV	AL,DEFDEN
	CALL	CPRN
	MOV	SI,OFFSET DEFMSG5		;get 25th line default message
	CALL	PRT_MSG				;print it
	CMP	DEFL25,25D
	JE	CQ1
	MOV	AL,'N'
	JMP	SHORT CQ2
CQ1:	MOV	AL,'Y'
CQ2:	CALL	CPRN
	MOV	AL,13D				;terminate with <CR>, <LF>
	CALL	CPRN
	MOV	AL,10D
	CALL	CPRN

IF Z100
CQ3:	RET					;exit to DOS
ELSE
CQ3:	MOV	VRAM_MD,04			;set up to exit
	RET					;exit to DOS
ENDIF

PRT_MSG:
	MOV	AL,BYTE PTR [SI]		;get character
	INC	SI				;bump for next time
	CMP	AL,0
	JZ	PM1				;if end of text
	PUSH	SI
	CALL	CPRN				;output it
	POP	SI
	JMP	SHORT PRT_MSG	 		;do next
PM1:	RET

GET_SIZE:
	CMP	DEFL25,25D			;print 25 lines?
	JNE	GS1				;no, only if directed
	CMP	L25FLG,0			;yes, check 25th line flag
	JE	GET_BANK			;print 25 lines
	JMP	SHORT GS2			;else, print 24 lines
GS1:	CMP	L25FLG,0			;check 25th line flag
	JNE	GET_BANK			;print 25 lines
GS2:	MOV	WORD PTR LINES,24D		;else, set to 24 lines

GET_BANK:

IF Z100
	CMP	CLRFLG,'T'			;check color flag for text
	JNE	GTB1				;no, continue
	JMP	TXT_DMP				;else, dump text only
GTB1:	CMP	CLRFLG,'B'			;if flag -> B, dump blue
	JE	B_BANK
	CMP	CLRFLG,'R'			;if flag -> R, dump red
	JE	R_BANK

G_BANK: 					;green VRAM bank
	MOV	AX,0E000H			;select location E000H
	JMP	SHORT GO_PSC

R_BANK: 					;red VRAM bank
	MOV	AX,0D000H			;select location D000H
	JMP	SHORT GO_PSC

B_BANK: 					;blue VRAM bank
	MOV	AX,0C000H			;select location C000H

ELSE

	CMP	CLRFLG,'T'			;check mode flag for 'T'
	JNE	GTB3				;no, continue
GTB1:	MOV	VRAM_MD,00			;yes, dump text only
GTB2:	RET
GTB3:	CMP	VRAM_MD,04			;check for graphics mode
	JB	GTB2				;no, dump text only
	CMP	VRAM_MD,06			;check if valid CGA mode 4-5-6
	JG	GTB1				;no, dump text only
	MOV	AX,0B800H			;select video segment
ENDIF

GO_PSC: 					;C. ITOH/NEC graphics routine
	MOV	ES,AX				;set up seg
	MOV	WORD PTR COL_INR,79D		;init col =79
	MOV	WORD PTR CUR_RO,24D 		;init row =24 -->max lines
	MOV	WORD PTR SCN_LN,0		;init scan line =0
	CMP	DENFLG,'S'			;check density flag for standard
	JNE	GP1
	MOV	AL,1BH				;set to pica print
	CALL	CPRN
	MOV	AL,'N'				;ESC 'N'
	CALL	CPRN

IF C_ITOH AND M24LQ
	JMP	SHORT GP3
GP1:	MOV	AL,1BH				;set to compressed print
	CALL	CPRN
	MOV	AL,'Q'				;ESC 'Q'
	CALL	CPRN
ELSE
	MOV	AL,0EH				;set to elongated print
	CALL	CPRN
	MOV	AL,1BH				;set to 14/144 line feed
	CALL	CPRN
	MOV	AL,54H				;ESC 'T'
	CALL	CPRN
	MOV	AL,31H				;N1=1
	CALL	CPRN
	MOV	AL,34H				;N2=4	  ...14/144
	CALL	CPRN
	JMP	SHORT GP4
GP1:	CMP	DENFLG,'M'			;check density flag for medium
	JNE	GP2
	MOV	AL,1BH				;set to elite print
	CALL	CPRN
	MOV	AL,45H				;ESC 'E'
	CALL	CPRN
	JMP	SHORT GP3
GP2:	MOV	AL,1BH				;set to proportional print
	CALL	CPRN
	MOV	AL,50H				;ESC 'P'
	CALL	CPRN
ENDIF

GP3:	MOV	AL,1BH				;set line feed
	CALL	CPRN
	MOV	AL,54H				;ESC 'T'
	CALL	CPRN

IF C_ITOH AND M24LQ
	MOV	AL,34H				;N1=4
	CALL	CPRN
	MOV	AL,38H				;N2=8	  ...48/360
	CALL	CPRN
ELSE
	MOV	AL,31H				;N1=1
	CALL	CPRN
	MOV	AL,36H				;N2=6	  ...16/144
	CALL	CPRN
ENDIF

GP4:
IF C_ITOH
	MOV	AL,1BH				;set to unidirectional print
	CALL	CPRN
	MOV	AL,3EH				;ESC '>'
	CALL	CPRN
ELSE
	MOV	AL,1BH				;set to incremental mode
	CALL	CPRN				; to force unidirectional print
	MOV	AL,5BH				;ESC '['
	CALL	CPRN
ENDIF

IF C_ITOH AND M24LQ
	MOV	BX,01H				;set top page margin
ELSE
	CMP	DENFLG,'S'			;check density flag
	JNE	GP5
	MOV	BX,11D				;set top page margin
	JMP	SHORT GP6
GP5:	MOV	BX,06D	
ENDIF

GP6:	CALL	PRLF				;print line feeds
	CALL	MODE_S 				;graphics mode
	CALL	PRSPC				;print spaces (to center)
	JMP	ROW2

;*********CHARACTER PRINT - CPRN***************

CPRN:

IF Z100
	CALL	FAR PTR BIOS_PRINT		;character print function
ELSE
	PUSH	AX
	PUSH	DX
	XOR	DX,DX				;character print function
	MOV	AH,0
	INT	17H				; for parallel printer
	POP	DX
	POP	AX
ENDIF

	RET


;*********PRINT SPACES ROUTINE*****************

PRSPC:
	CMP	LINES,25			;if 25 lines
	JB	PRSPC1				;pad with spaces
	CMP	DENFLG,'S'
	JNE	PR1

IF C_ITOH AND M24LQ
IF Z100
	MOV	BX,135D				;45 spaces * 3, standard
ELSE
	MOV	BX,360D				;120 spaces * 3, standard
ENDIF

	JMP	SHORT PSC1

IF Z100
PR1:	MOV	BX,270D				;90 spaces * 3, high density
ELSE
PR1:	MOV	BX,720D				;240 spaces * 3, high density
ENDIF

ELSE

IF Z100
	MOV	BX,47D				;47 spaces, standard density 
ELSE
	MOV	BX,60D				;60 spaces, standard density
ENDIF

	JMP	SHORT PSC1
PR1:	CMP	DENFLG,'M'
	JNE	PR2

IF Z100
	MOV	BX,55D				;55 spaces, medium density
ELSE
	MOV	BX,92D				;92 spaces, medium density
ENDIF

	JMP	SHORT PSC1

IF Z100
PR2:	MOV	BX,77D				;77 spaces, high density
ELSE
PR2:	MOV	BX,138D				;138 spaces, high density
ENDIF
ENDIF

PSC1:
	MOV	AL,00H				;print spaces 
	CALL	CPRN				;spaces+graphics+spaces
	DEC	BX
	CMP	BX,0
	JG	PSC1				;continue as needed
	RET

PRSPC1:
	CMP	DENFLG,'S'			;check density flag for standard
	JNE	PS1

IF C_ITOH AND M24LQ
IF Z100
	MOV	BX,219D				;if 24 lines, 73 spaces * 3
ELSE
	MOV	BX,426D				;142 spaces * 3, standard
ENDIF

	JMP	SHORT PSC1

IF Z100
PS1:	MOV	BX,438D				;146 spaces * 3, high density
ELSE
PS1:	MOV	BX,852D				;284 spaces * 3, high density
ENDIF

	JMP	SHORT PSC1

ELSE

IF Z100
	MOV	BX,52D				;if 24 lines, 52 spaces
ELSE
	MOV	BX,64D				;if 24 lines, 64 spaces
ENDIF

	JMP	SHORT PSC1			;52 spaces, standard density
PS1:	CMP	DENFLG,'M'			;check density flag for medium
	JNE	PS2

IF Z100
	MOV	BX,69D				;69 spaces, medium density
ELSE
	MOV	BX,103D				;103 spaces, medium density
ENDIF

	JMP	SHORT PSC1

IF Z100
PS2:	MOV	BX,100D				;100 spaces, high density
ELSE
PS2:	MOV	BX,156D				;156 spaces, high density
ENDIF

	JMP	SHORT PSC1
ENDIF

;*********PRINT LINE FEED ROUTINE**************

PRLF:
	MOV	AL,0AH				;print <LF>
	CALL	CPRN
	DEC	BX
	CMP	BX,0
	JG	PRLF				;continue as needed
	RET


;***MODE_S - SENDS ESC 'S'OR 'G' TO PRINTER****

MODE_S:
	MOV	AX,0000H			;clear AX reg
	MOV	AL,1BH				;ESC character
	CALL	CPRN

IF C_ITOH AND M24LQ
	MOV	AL,'G'				;the 'G'
ELSE
	MOV	AL,'S'				;the 'S'
ENDIF

	CALL	CPRN
	CMP	DENFLG,'S'			;check density flag for standard
	JNE	MS1

IF C_ITOH AND M24LQ
IF Z100
	MOV	AL,31H				;N1=1  (standard density)
	CALL	CPRN
	MOV	AL,33H				;N2=3
	CALL	CPRN
	MOV	AL,39H				;N3=9
	CALL	CPRN
	MOV	AL,35H				;N4=5
	CALL	CPRN
ELSE
	MOV	AL,31H				;N1=1  (standard density)
	CALL	CPRN
	MOV	AL,33H				;N2=3
	CALL	CPRN
	MOV	AL,32H				;N3=2
	CALL	CPRN
	MOV	AL,30H				;N4=0
	CALL	CPRN
ENDIF

	JMP	SHORT MS3

IF Z100
MS1:	MOV	AL,32H				;N1=2  (high density)
	CALL	CPRN
	MOV	AL,37H				;N2=7
	CALL	CPRN
	MOV	AL,39H				;N3=9
	CALL	CPRN
	MOV	AL,30H				;N4=0
	CALL	CPRN
ELSE
MS1:	MOV	AL,32H				;N1=2  (high density)
	CALL	CPRN
	MOV	AL,36H				;N2=6
	CALL	CPRN
	MOV	AL,34H				;N3=4
	CALL	CPRN
	MOV	AL,30H				;N4=0
	CALL	CPRN
ENDIF

ELSE

IF Z100
	MOV	AL,30H				;N1=0  (standard density)
	CALL	CPRN
	MOV	AL,32H				;N2=2
	CALL	CPRN
	MOV	AL,37H				;N3=7
	CALL	CPRN
	MOV	AL,32H				;N4=2
	CALL	CPRN
ELSE
	MOV	AL,30H				;N1=0  (standard density)
	CALL	CPRN
	MOV	AL,32H				;N2=2
	CALL	CPRN
	MOV	AL,36H				;N3=6
	CALL	CPRN
	MOV	AL,30H				;N4=0
	CALL	CPRN
ENDIF

	JMP	SHORT MS3
MS1:	CMP	DENFLG,'M'			;check density flag for medium
	JNE	MS2

IF Z100
	MOV	AL,30H				;N1=0  (medium density)	
	CALL	CPRN
	MOV	AL,37H				;N2=7
	CALL	CPRN
	MOV	AL,33H				;N3=3
	CALL	CPRN
	MOV	AL,30H				;N4=0
	CALL	CPRN
ELSE
	MOV	AL,30H				;N1=0	(medium density)
	CALL	CPRN
	MOV	AL,36H				;N2=6
	CALL	CPRN
	MOV	AL,39H				;N3=9
	CALL	CPRN
	MOV	AL,32H				;N4=2
	CALL	CPRN
ENDIF

	JMP	SHORT MS3

IF Z100
MS2:	MOV	AL,31H				;N1=1  (high density)
	CALL	CPRN
	MOV	AL,32H				;N2=2
	CALL	CPRN
	MOV	AL,30H				;N3=0
	CALL	CPRN
	MOV	AL,32H				;N4=2
	CALL	CPRN
ELSE
MS2:	MOV	AL,31H				;N1=1  (high density)
	CALL	CPRN
	MOV	AL,31H				;N2=1
	CALL	CPRN
	MOV	AL,33H				;N3=3
	CALL	CPRN
	MOV	AL,38H				;N4=8
	CALL	CPRN
ENDIF
ENDIF

MS3:	RET					;back to calling

;****DO_BYTE - READ THE VRAM AND SEND TO PRN***

DO_BYTE:
	MOV	BX,WORD PTR ADDR		;current address
	MOV	AL,BYTE PTR ES:[BX]		;byte pointed by cur addr

IF Z100
	CMP	BANKS,33H			;check # of VRAM banks
	JNE	DB1				;nope, print green bank
	CMP	CLRFLG,'A'			;check for 'A'
	JNE	DB1				;nope, print green bank
	MOV	G_CHR,AL			;save green bank char
	MOV	AX,0D000H			;get red bank segment
	MOV	ES,AX				;set up segment
	MOV	BX,WORD PTR ADDR		;current address
	MOV	AL,BYTE PTR ES:[BX]		;byte pointed by cur addr
	OR	G_CHR,AL			;OR with green bank char
	MOV	AX,0C000H			;get blue bank segment
	MOV	ES,AX				;set up segment
	MOV	BX,WORD PTR ADDR		;current address
	MOV	AL,BYTE PTR ES:[BX]		;byte pointed by cur addr
	OR	G_CHR,AL			;OR with other banks
	MOV	AX,0E000H			;get green bank segment
	MOV	ES,AX				;set up segment
	MOV	AL,G_CHR			;set char for print	
ENDIF

DB1:	CMP	IMGFLG,'N'			;check image flag for negative
	JE	DB2				;yes, continue
	NOT	AL				;reverse image to positive

IF C_ITOH AND M24LQ
DB2:	MOV	G_CHR,AL			;store char
	CALL	ADJ_BYTE			;convert to 3 byte word
	MOV	CX,06D
	CMP	DENFLG,'S'			;check density flag
	JE	DB3				;print 6 times for standard
	MOV	CX,12D				; or 12 times for high
DB3:	MOV	AL,G_CHR3			;print char 3
	CALL	CPRN
	MOV	AL,G_CHR2			;print char 2
	CALL	CPRN
	MOV	AL,G_CHR1			;print char 1
	CALL	CPRN
	LOOP	DB3				;loop 6 or 12 times
	INC	SCN_LN
ELSE
DB2:	CALL	CPRN				;print once for standard
	CMP	DENFLG,'S'			;check density flag
	JE	DB3
	CALL	CPRN				;print two more for medium
	CALL	CPRN
	CMP	DENFLG,'H'			;check density flag for high
	JNE	DB3
	CALL	CPRN				;print two more for high
	CALL	CPRN
DB3:	INC	SCN_LN				;count scan line done
ENDIF

	CALL	ADJ_SCN				;adjust for scan line
	MOV	WORD PTR ADDR,BX		; and save addr

IF Z100
	CMP	SCN_LN,9			;have we done all 9
ELSE
	CMP	SCN_LN,8			;have we done all 8
ENDIF

	JGE	ROW				;all are done
	JMP	DO_BYTE

;**********ADJUST FOR NEXT SCAN LINE***********

ADJ_SCN:

IF Z100
	ADD	BX,128D				;adjust for scan line
ELSE
	CMP	BX,2000H			;adjust for scan line
	JB	AS1
	SUB	BX,1FB0H
	JMP	SHORT AS2
AS1:	ADD	BX,2000H
ENDIF

AS2:	RET

;**********ROW - LOOP FOR EACH ROW*************

ROW:
	MOV	SCN_LN,0			;init scan line again
	DEC	CUR_RO				;count row done
	CMP	LINES,25			;if 25 lines
	JB	ROW24

	CMP	CUR_RO,-1H			;test all lines done
	JE	DO_COL				;do next col 
	JMP	SHORT ROW2

ROW24:
	CMP	CUR_RO,0			;if 24 lines, test all done
	JZ	DO_COL				;do next col

ROW2:	
	MOV	AX,CUR_RO			;else more rows
	MOV	BX,OFFSET ROW_DAT		;table start

LNS:						;return tgt
	ADD	BX,AX				;R_ADDR=ROW_DAT+CUR_RO
	ADD	BX,AX				;--times two
	MOV	AX,WORD [BX]			;get actual address
	MOV	BX,AX				;swap it back
	MOV	AX,COL_INR			;get current column
	ADD	BX,AX				;C_ADDR=R_ADDR+COL_INR

IF Z100
	SUB	BX,1024D			;adjust table for reverse
ELSE
	SUB	BX,8432D			;adjust table for reverse
ENDIF

	MOV	WORD PTR ADDR,BX		;save it at ADDR
	JMP	DO_BYTE				;do next row


;*DO_COL - INCREMENT COLUMN AT END OF EACH ROW*

DO_COL:
	CMP	LINES,25D			;if 25 lines
	JE	TERM_LN 			;no spaces required
	CMP	DENFLG,'S'			;check density flag for standard
	JNE	DC1

IF C_ITOH AND M24LQ
	MOV	BX,78D				;pad 26 spaces * 3 for standard
	JMP	SHORT DC3
DC1:	MOV	BX,156D				;pad 52 spaces * 3 for high
ELSE
	MOV	BX,04D				;pad 4 spaces for standard
	JMP	SHORT DC3
DC1:	CMP	DENFLG,'M'			;check density flag for medium
	JNE	DC2
	MOV	BX,13D				;pad 13 spaces for medium
	JMP	SHORT DC3
DC2:	MOV	BX,22D				;pad 22 spaces for high
ENDIF

DC3:	CALL	PSC1				;print spaces

TERM_LN:
	MOV	AL,0DH
	CALL	CPRN				;terminate line with
	MOV	AL,0AH
	CALL	CPRN				; <CR/LF>

IF Z100 OR ZPC
	IN	AL,0F5H				;check for char avail
	TEST	AL,01H

IF ZPC AND Z150
	JZ	TL2
ELSE
	JZ	TL1				;no, continue
ENDIF

	IN	AL,0F4H 			;poll the keyboard port
	CMP	AL,01BH 			 
	JE	FINI1				;if port -><ESC> then quit

IF Z100
TL1:	CALL	FAR PTR BIOS_STATUS		;check console status
	JZ	TL2				;no char, continue
	CALL	FAR PTR BIOS_CONIN		;else, get char
ENDIF

ELSE
	MOV	AH,01H				;check console status
	INT	16H
	JZ	TL2				;no char, continue
	MOV	AH,0				;else, get char
	INT	16H
ENDIF

	CMP	AL,01BH 			;is it an <ESC>
	JE	FINI1				;if yes then quit
	AND	AL,0DFH				;force to upper case
	CMP	AL,'Q'				;is it a 'Q'
	JE	FINI1				;if yes then quit

TL2:	DEC	COL_INR 			;decrement column
	CMP	COL_INR,-1H			;are all done?
	JG	CON_CL 				;if no --> continue
	JMP	SHORT FINI			;else we are done

CON_CL:
	MOV	CUR_RO,24D			;reset max rows =24
	CALL	MODE_S 				;do next col
	CALL	PRSPC				
	JMP	ROW2

;*************FINISH - ALL DONE****************

FINI1:
	MOV	BX,COL_INR			;adjust lines if quit early
	CALL	PRLF

FINI:						;reset

IF C_ITOH AND M24LQ
	MOV	BX,02H				;2 lines
ELSE
	CMP	DENFLG,'S'			;check density flag for standard
	JNE	FI1				;set to bottom of page
	MOV	BX,22D				;22 lines for standard density
	JMP	SHORT FI2
FI1:	MOV	BX,13D				;13 lines for other densities
ENDIF

FI2:	CALL	PRLF
	MOV	AL,1BH				;reset to pica
	CALL	CPRN
	MOV 	AL,4EH				;ESC 'N'	
	CALL	CPRN
	MOV	AL,0FH				;reset char width
	CALL	CPRN
	MOV	AL,1BH				;set to normal line feed
	CALL	CPRN
	MOV	AL,41H				;ESC 'A'
	CALL	CPRN

IF C_ITOH
	MOV	AL,1BH				;set to bidirectional
	CALL	CPRN
	MOV	AL,3CH				;ESC '<'
	CALL	CPRN
ELSE
	MOV	AL,1BH				;set to logic seek mode
	CALL	CPRN				; for bidirectional print
	MOV	AL,5DH				;ESC ']'
	CALL	CPRN
ENDIF

	MOV	AL,0DH				;<CR>
	CALL	CPRN

IF Z100
FI3:	MOV	AL,VRAM_MD			;restore video mode
	OUT	0D8H,AL
ENDIF

	RET

IF C_ITOH AND M24LQ

;************MAKE THREE BYTE ROUTINE************

ADJ_BYTE:
	MOV	G_CHR1,0			;zero storage locations
	MOV	G_CHR2,0
	MOV	G_CHR3,0
	MOV	CNT,0				;zero position counter
ADB1:	MOV	AL,G_CHR			;get video byte
	CMP	CNT,0				;if first bit, skip shift
	JZ	ADB2				;else, shift left by count
	MOV	CL,CNT				; to place required bit
	SHL	AL,CL				; in left most place
ADB2:	MOV	CL,7				;shift bit to right most
	SHR	AL,CL				; place in byte
	CMP	AL,0				;if it is a '0'
	JNZ	ADB3				;then leave as is and do next
	JMP	ADB11
ADB3:	CMP	CNT,0				;if bit position one
	JNZ	ADB4
	MOV	AL,11100000B			;multiply by three and position
	OR	G_CHR1,AL			;store in G_CHR1
	JMP	SHORT ADB11
ADB4:	CMP	CNT,1				;if bit position two
	JNZ	ADB5
	MOV	AL,00011100B			;multiply by three and position
	OR	G_CHR1,AL			;store in G_CHR1
	JMP	SHORT ADB11
ADB5:	CMP	CNT,2				;if bit position three
	JNZ	ADB6
	MOV	AL,00000011B			;multiply by three and position
	OR	G_CHR1,AL			;store in G_CHR1
	MOV	AL,10000000B
	OR	G_CHR2,AL			; and G_CHR2
	JMP	SHORT ADB11
ADB6:	CMP	CNT,3				;if bit position four
	JNZ	ADB7
	MOV	AL,01110000B			;multiply by three and position
	OR	G_CHR2,AL			;store in G_CHR2
	JMP	SHORT ADB11
ADB7:	CMP	CNT,4				;if bit position five
	JNZ	ADB8
	MOV	AL,00001110B			;multiply by three and position
	OR	G_CHR2,AL			;store in G_CHR2
	JMP	SHORT ADB11
ADB8:	CMP	CNT,5				;if bit postion six
	JNZ	ADB9
	MOV	AL,00000001B			;multiply by three and position
	OR	G_CHR2,AL			;store in G_CHR2
	MOV	AL,11000000B
	OR	G_CHR3,AL			; and G_CHR3
	JMP	SHORT ADB11
ADB9:	CMP	CNT,6				;if bit positon seven
	JNZ	ADB10
	MOV	AL,00111000B			;multiply by three and position
	OR	G_CHR3,AL			;store in G_CHR3
	JMP	SHORT ADB11
ADB10:	MOV	AL,00000111B			;multiply by three and position		
	OR	G_CHR3,AL			;store last in G_CHR3
ADB11:	INC	CNT				;increment bit counter
	CMP	CNT,8				;check for last bit
	JGE	ADB12				;yes, return
	JMP	ADB1				;no, get next bit
ADB12:	RET
ENDIF

;*******TXT_DMP - Z100 TEXT DUMP ROUTINE********

IF Z100
TXT_DMP:
	MOV	WORD PTR INT_CX,0		;start at line 0
	MOV	WORD PTR INT_CY,0		; and column 0

TD1:	PUSH	DS
	PUSH	DS
	MOV	AX,OFFSET MYCHR
	PUSH	AX				;32 bit address for character

	PUSH	WORD PTR INT_CY			;vertical location
	PUSH	WORD PTR INT_CX			;horizontal location

	XOR	AX,AX
	MOV	DS,AX
	MOV	DS,DS:[MTR_DS]			;pointer to MTR data area

	CALL	DS:DWORD PTR MTR_RDC		;read character at CX, CY

	POP	DS

	MOV	AL,BYTE PTR MYCHR
	ADD	AL,' '				;AL = character

	AND	AL,07FH				;make it printable
	CMP	AL,' '
	JNE	TD2				;if printable, continue
	MOV	AL,' '				;else, make it a space

TD2:	CALL	CPRN				;print it

	INC	WORD PTR INT_CX			;go to next character
	CMP	WORD PTR INT_CX,80D		;check if end of line
	JB	TD1				;no, continue

	MOV	AL,0DH				;else, terminate line with
	CALL	CPRN				; a CR
	MOV	AL,0AH
	CALL	CPRN				; a LF

	MOV	WORD PTR INT_CX,0		;reset to column 0
	INC	WORD PTR INT_CY			;go to next horizontal line

	MOV	AX,WORD PTR INT_CY
	CMP	AX,LINES			;end of screen?
	JB	TD1				;nope, continue
	MOV	AL,0AH
	CALL	CPRN
	JMP	FI3				;exit
ENDIF

DEFMSG1	DB	'SCREEN DUMP defaults:',0

IF Z100
DEFMSG2	DB	13,10,'    VRAM bank = ',0
ELSE
DEFMSG2	DB	13,10,'    mode      = ',0
ENDIF

DEFMSG3 DB	13,10,'    image     = ',0
DEFMSG4 DB	13,10,'    density   = ',0
DEFMSG5 DB	13,10,'    dump 25th = ',0

;*******MARK END OF RESIDENT PORTION***********

INT_END LABEL	NEAR

;*************MAIN ENTRY POINT*****************


START:
	MOV	AX,00H				;check to see if already
	MOV	ES,AX				; installed.
	MOV	SI,5*4				;SI points to interrupt
	MOV	ES,ES:WORD PTR [SI+2]
	MOV	SI,OFFSET CHECK 		;get ID message
	MOV	DI,SI
	MOV	CX,CHECKLN			;get length
	REPE	CMPSB				;compare
	JNZ	SETUP				;not installed

	PUSH	DS				;save DS
	MOV	AX,ES
	MOV	DS,AX				;get default settings
	LODSB					
	MOV	CS:DEFCLR,AL			; of currently installed
	LODSB
	MOV	CS:DEFDEN,AL			; version and save for
	LODSB
	MOV	CS:DEFL25,AL			; for print out
	LODSB
	MOV	CS:DEFIMG,AL

IF Z100
	LODSB
	MOV	CS:BANKS,AL
ENDIF
	POP	DS				;restore DS
	MOV	BYTE PTR LDFLG,01H		;set already loaded flag
	JMP	PRTMSG				;print signon message

SETUP:
	MOV	SP,OFFSET INT_STACK		;good place for it
	PUSH	DS

IF Z100
	MOV	AX,0C00H			;flush keyboard buffer
	INT	21H	
	MOV	DX,OFFSET VRAM_CK		;get # banks of VRAM
	CALL	PRTSTR

CHKVRM:	MOV	AH,0BH				;check for char available
	INT	21H
	CMP	AL,0FFH
	JNE	GETCMD				;no, continue
	MOV	AH,08H				;else, get character
	INT	21H
	CMP	AL,33H				;is it a '3'
	JNE	CHKVRM				;no, only green bank
	MOV	BANKS,AL			;else, store (all VRAM)
	MOV	DEFCLR,'A'			;set default to 'All' banks
	JMP	CHKVRM
ENDIF

GETCMD:	MOV	SI,OFFSET CMDBUF		;point to command line
	LODSB					;get count byte
	OR	AL,AL				;any arguments?
	JZ	SETINT				;no, continue

GETCHR:	LODSB					;get next byte
	CMP	AL,' '				;space?
	JZ	GETCHR				;if so, skip it
	CMP	AL,0DH
	JE	SETINT
	AND	AL,0DFH				;force to upper case

IF Z100
	CMP	BANKS,33H			;check # VRAM banks
	JNE	GC3				;only one bank, continue
	CMP	AL,'B'				;check for 'B'
	JNE	GC1				;nope
	MOV	DEFCLR,AL			;set color default for blue
	JMP	GETCHR	
GC1:	CMP	AL,'R'				;check for 'R'	
	JNE	GC2				;nope
	MOV	DEFCLR,AL			;set color default for red
	JMP	GETCHR
GC2:	CMP	AL,'G'				;check for 'G'
	JNE	GC3				;nope
	MOV	DEFCLR,AL			;set color default for green
	JMP	GETCHR
ENDIF

GC3:	CMP	AL,'T'				;check for 'T'
	JNE	GC4				;nope
	MOV	DEFCLR,AL			;set color default for text
	JMP	GETCHR
GC4:	CMP	AL,'P'				;check for 'P'
	JNE	GC5				;nope
	MOV	DEFIMG,AL			;set image default for positive
	JMP	GETCHR
GC5:	CMP	AL,'M'				;check for 'M'
	JNE	GC6				;nope
	MOV	DEFDEN,AL			;set density default for medium
	JMP	GETCHR
GC6:	CMP	AL,'H'                          ;check for 'H'
	JNE	GC7      			;nope
	MOV	DEFDEN,AL			;set density default for high
	JMP	GETCHR
GC7:	CMP	AL,'D'				;check for 'D'
	JNE	GETCHR      			;nope
	MOV	DEFL25,24D			;set 24 line dump as default
	JMP	GETCHR

SETINT:	XOR	AX,AX
	MOV	DS,AX				;clear DS

	MOV	SI,5*4				;SI points to interrupt

IF Z150
	MOV	AX,[SI]				;save address of text int 5
	MOV	CS:TXTINT5,AX
	MOV	AX,[SI+2]
	MOV	CS:TXTINT5+2,AX
ENDIF

	CLI

	MOV	WORD PTR [SI],OFFSET INT_5
	MOV	WORD PTR [SI+2],CS		;set my interrupt vector

	STI
	POP	DS

PRTMSG:	MOV	DX,OFFSET MESG1 		;get signon message address
     	CALL	PRTSTR				;print signon message
	CMP	LDFLG,0                         ;check loaded flag
	JZ	PRTM1				; and print proper message
	MOV	DX,OFFSET MESG2
	CALL	PRTSTR
	MOV	DX,OFFSET MESG4
	JMP	SHORT PRTM2
PRTM1:	MOV	DX,OFFSET MESG3
PRTM2:	CALL	PRTSTR

IF Z100
	CMP	BANKS,33H
	JNE	PRTM3
	MOV	DX,OFFSET MESG5			; and instruction
	CALL	PRTSTR
	JMP	SHORT PRTM4
PRTM3:	MOV	DX,OFFSET MESG6			; messages
	CALL	PRTSTR
ENDIF

PRTM4:	CMP	DEFL25,25D			;which 25th line message?
	JE	PRTM5				
	MOV	DX,OFFSET MESG8			;print 'dump on switch'
	JMP	SHORT PRTM6
PRTM5:	MOV	DX,OFFSET MESG7			;print 'do not dump' on switch
PRTM6:	CALL	PRTSTR				;print default settings
	MOV	DL,DEFCLR
	CALL	PRTCHR				; bank/mode
	MOV	DX,OFFSET MESG9
	CALL	PRTSTR
	MOV	DL,DEFIMG			; image
	CALL	PRTCHR
	MOV	DX,OFFSET MESG10
	CALL	PRTSTR
	MOV	DL,DEFDEN			; density
	CALL	PRTCHR
	MOV	DX,OFFSET MESG11		; 25th line
	CALL	PRTSTR
	CMP	DEFL25,25D
	JE	PRTM7
	MOV	DL,'N'
	JMP	SHORT PRTM8
PRTM7:	MOV	DL,'Y'
PRTM8:	CALL	PRTCHR
	MOV	DX,OFFSET MESG12		;print abort message
	CALL	PRTSTR
	CMP	LDFLG,01
	JZ	PRTM9

	MOV	DX,OFFSET INT_END		;LWA of resident portion
	INT	27H

PRTM9:	INT	20H

PRTSTR:	MOV	AH,09H				;print string function
	INT	21H
	RET

PRTCHR:	MOV	AH,02H				;print character function
	INT	21H
	RET

IF Z100
VRAM_CK	DB	1BH,'i0$'

MESG1	DB	13,10,'              Z-100 '

ELSE
IF ZPC

MESG1	DB	13,10,'            Z-150/ZPC '

ELSE

MESG1	DB	13,10,'              Z-150 '
ENDIF
ENDIF

	DB	'SCREEN DUMP version 3.52',13,10
	DB	'        Copyright (c) 1985, 1986, Bordelon Software',13,10,10

IF C_ITOH
IF M24LQ
	DB	'Printer:  C. Itoh M24LQ/1570',13,10,10,'$'
ELSE
	DB	'Printer:  C. Itoh 8510A/1550 Prowriter',13,10,10,'$'
ENDIF
ELSE
	DB	'Printer:  NEC 8023A',13,10,10,'$'
ENDIF

MESG2	DB	7,'Already installed...',13,10,10,'$'

MESG3	DB	'Installed and ready...',13,10,10
MESG4	DB	'To dump screen, type:   '

IF Z100
	DB	'<SHIFT-F12>[U][V][W][X][Y][Z]',13,10,10
	DB	'   [U = $'
MESG5	DB	'<A>ll, <B>lue, <R>ed, '
MESG6	DB	'<G>reen or <T>ext]',13,10
ELSE
IF ZPC
	DB	'<SHIFT-F12>[U][V][W][X][Y][Z]',13,10,10
ELSE
	DB	'<SHIFT-PrtSc>[U][V][W][X][Y][Z]',13,10,10
ENDIF

	DB	'   [U = <G>raphics or <T>ext mode]',13,10
ENDIF

	DB	'   [V = <N>egative or <P>ositive image]',13,10
	DB	'   [W = <S>tandard'

IF C8510
	DB	', <M>edium,'
ENDIF

	DB	' or <H>igh density]',13,10
	DB	'   [X = <D>$'

MESG7	DB	'o not d'
MESG8	DB	'ump 25th line]',13,10
	DB	'   [Y = <C>hange default settings]',13,10
	DB	'   [Z = <Q>uery default settings]',13,10,10
	DB	'   defaults:'

IF Z100
	DB	'  bank=$'
ELSE
	DB	'  mode=$'
ENDIF

MESG9	DB	'  image=$'

MESG10	DB	'  density=$'

MESG11	DB	'  dump 25th=$'

MESG12	DB	13,10,10,'To abort dump during printing, type:   <ESC>'
	DB	13,10,10,'$'

LDFLG	DB	0

CODE	ENDS
	END	BEGIN
