;	SCRNCLK -- CP/M SCREEN CLOCK PROGRAM
;
;	THIS PROGRAM PROVIDES A SCREEN CLOCK LIKE THE BIOS
;	MODS PRESENTED IN THE NOV. 81 REMARK, EXCEPT THAT
;	NO BIOS MODIFICATIONS ARE NEEDED.
;
;	THE CLOCK IS CONTROLLED BY THE COMPANION "CLOCK"
;	PROGRAM
;
;	BY P. SWAYNE, HUG  17-JUN-84
;

;	DEFINITIONS

TRUE	EQU	0FFFFH
FALSE	EQU	NOT TRUE

LINE25	EQU	FALSE		;WHERE TO PUT CLOCK
				;0 = TOP OF SCREEN, 1 = BOTTOM

BIOS	EQU	0		;BIOS JUMP VECTOR
BDOS	EQU	5		;BDOS JUMP VECTOR
CURDSK	EQU	4		;CURRENT DISK
TIMEINT	EQU	8		;TIMER INTERRUPT VECTOR
TICCNT	EQU	0BH		;TIC COUNTER
CCPSIZ	EQU	800H		;SIZE OF CCP
PRGSIZ	EQU	200H		;SIZE ALLOWED FOR THIS PROGRAM

	ORG	100H

;	TEST IF SCRNCLK ALREADY LOADED

START:	LHLD	BIOS+1		;GET BIOS VECTOR
	INX	H		;SKIP JUMP
	MOV	E,M
	INX	H
	MOV	D,M		;DE = WARM BOOT
	CALL	CPHD		;TEST IF EXTENSION ALREADY IN
	JC	LDED		;SOMETHING'S IN, DON'T LOAD
	LHLD	BDOS+1		;GET BDOS ADDRESS
	PUSH	H		;SAVE IT
	LXI	D,7
	DAD	D		;MOVE TO SIGNATURE
	MOV	A,M		;GET FIRST CHARACTER
	CPI	'C'		;IS IT "C"?
	JNZ	NTLDED		;IF NOT, CLOCK NOT LOADED
	INX	H
	MOV	A,M		;GET SECOND CHARACTER
	CPI	'K'		;IS IT "K"?
	JNZ	NTLDED		;NO, OK TO LOAD
LDED:	LXI	D,ITSIN
	MVI	C,9
	CALL	BDOS		;ELSE, SAY "IT'S IN"
	JMP	BIOS		;RETURN TO CP/M

;	PREPARE TO RELOCATE CODE

NTLDED:	POP	H		;RESTORE BDOS ADDRESS
	LXI	D,-(JBDOS+CCPSIZ+PRGSIZ)	;CODE START + SPACE ALLOWED
	DAD	D		;CALCULATE OFFSET FOR MOVED CODE
	SHLD	BIAS		;STORE IT
	LXI	H,MYTIME	;HL = ORG ADDR
	LXI	D,CODEND 	;END OF CODE TO FIX
LOCAT0:	MOV	A,M		;GET OPCODE
	MOV	B,A		;SAVE IT
	PUSH	H		;SAVE ADDRESS

;	LOCATE TWO AND THREE BYTE OPCODES

	LXI	H,THBYT		;THREE BYTE TABLE
LOCAT1:	MOV	A,M		;GET TABLE OPCODE
	CMP	B		;MATCHES PROGRAM OPCODE?
	JZ	LOCAT5		;YES, PROCESS IT
	CPI	0F7H		;END OF TABLE?
	INX	H
	JNZ	LOCAT1		;IF NOT, CONTINUE
	LXI	H,TWBYT		;TWO BYTE TABLE
LOCAT2:	MOV	A,M		;GET TABLE OPCODE
	CMP	B		;MATCHES PROGRAM OPCODE?
	JZ	LOCAT3		;YES, SKIP DATA BYTE
	CPI	0F7H		;END OF TABLE?
	INX	H		;MOVE POINTER
	JNZ	LOCAT2		;IF NOT, CONTINUE
	JMP	LOCAT4		;ONE BYTE INSTRUCTION
LOCAT3:	POP	H		;RESTORE ADDRESS POINTER
	INX	H		;SKIP DATA BYTE
	PUSH	H		;SAVE ADDRESS
LOCAT4:	POP	H		;RESTORE ADDRESS
	CALL	CPHD		;END OF PROGRAM?
	JNC	LOCAT0		;IF NOT, CONTINUE
	JMP	LOCAT8		;CODE FIXED, MOVE IT

; FIX THREE BYTE INSTRUCTIONS

LOCAT5:	POP	H		;RESTORE ADDRESS
	INX	H		;POINT TO CODE ARGUMENT
	PUSH	D		;SAVE END POINTER
	MOV	E,M
	INX	H
	MOV	D,M		;DE = ADDR TO CHECK
	PUSH	H		;SAVE ADDRESS POINTER
	LXI	H,JBDOS-1 	;CHECK IF ADDRESS IS
	CALL	CPHD		;BELOW PROGRAM?
	JC	LOCAT6		;IF SO, DO NOT ADJUST
	POP	H		;RESTORE ADDRESS
	POP	D		;RESTORE END POINTER
	DCX	H		;ADDR LOW BYTE
	LDA	BIAS		;FIX CODE
	ADD	M
	MOV	M,A
	INX	H
	LDA	BIAS+1
	ADC	M
	MOV	M,A		;ADDR = ADDR + BIAS
	JMP	LOCAT7
LOCAT6:	POP	H		;RESTORE ADDRESS
	POP	D		;RESTORE END POINTER
LOCAT7:	CALL	CPHD		;END OF FIXABLE CODE?
	JNC	LOCAT0		;IF NOT, CONTINUE
LOCAT8:

;	CODE IS FIXED, NOW ALTER BIOS TABLE
;	TO KEEP WARM BOOT FROM WIPING OUT THIS PROGRAM

	LHLD	BIAS		;GET RELOCATION OFFSET
	MOV	B,H
	MOV	C,L		;RESULT TO BC
	LHLD	BIOS+1		;GET WARM BOOT ADDRESS
	INX	H		;SKIP JUMP INSTRUCTION
	PUSH	H		;SAVE THIS ADDRESS
	MOV	E,M		;GET OLD WARM BOOT ADDRESS
	INX	H
	MOV	D,M
	XCHG
	SHLD	OLDWB		;SAVE IT
	POP	H		;RESTORE POINTER
	LXI	D,MYWBOOT	;GET MY WARM BOOT ADDRESS
	XCHG
	DAD	B		;ADD OFFSET
	XCHG
	MOV	M,E		;INSERT IT IN BIOS TABLE
	INX	H
	MOV	M,D
	LHLD	BDOS+1		;GET BDOS ADDRESS
	PUSH	H		;SAVE IT
	SHLD	JBDOS+1		;SAVE IT HERE, TOO
	LXI	D,-(CCPSIZ+3)
	DAD	D		;CALCULATE CCP CLEAR START ADDR
	SHLD	JCCP		;SET UP WARM BOOT EXIT
	LXI	H,JBDOS
	DAD	B		;ADD OFFSET
	SHLD	BDOS+1		;UPDATE BDOS VECTOR
	LHLD	TIMEINT+1	;GET CLOCK ADDRESS
	SHLD	OLDCK		;SAVE IT IN PGM
	POP	H		;GET OLD BDOS ADDRESS
	LXI	D,-(CCPSIZ+PRGSIZ)
	DAD	D		;SUBTRACT CCP AND PROGRAM SIZE
	LXI	D,JBDOS		;MOVABLE CODE STARTS HERE
	LXI	B,SAVCHR-JBDOS	;SIZE OF CODE
MOVE:	LDAX	D		;GET A BYTE
	MOV	M,A		;MOVE IT
	INX	H		;INCREMENT POINTERS
	INX	D
	DCX	B		;DECREMENT COUNTER
	MOV	A,B
	ORA	C		;DONE?
	JNZ	MOVE		;LOOP UNTIL DONE

;	NOW, INTERCEPT TIMER INTERRUPTS

	LHLD	BIAS		;GET OFFSET
	MOV	B,H
	MOV	C,L		;TO BC
	LXI	H,TIMEX		;GET EXIT ADDRESS
	DAD	B		;ADD OFFSET
	XCHG			;RESULT TO DE
	LHLD	TIMEINT+1	;GET CLOCK ADDRESS
	MOV	A,L
	STAX	D		;STORE LOW BYTE
	INX	D
	MOV	A,H
	STAX	D		;STORE HIGH BYTE
	LXI	H,MYTIME	;GET MY TIMER ADDRESS
	DAD	B		;ADD OFFSET
	DI			;KILL INTERRUPTS
	SHLD	TIMEINT+1	;PUT IT IN TIME VECTOR
	EI			;RE-ENABLE INTERRUPTS
	JMP	BIOS		;RETURN TO CP/M

; COMPARE HL TO DE

CPHD:	INX	H		;INCREMENT HL
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	RET

; TABLE OF THREE BYTE INSTRUCTIONS
; THAT REQUIRE FIXING

THBYT	DB	01H		;LXI B
	DB	11H		;LXI D
	DB	21H		;LXI H
	DB	31H		;LXI SP
	DB	22H		;SHLD
	DB	2AH		;LHLD
	DB	32H		;STA
	DB	3AH		;LDA
	DB	0CDH		;CALL
	DB	0CCH		;CZ
	DB	0C3H		;JMP
	DB	0C2H		;JNZ
	DB	0CAH		;JZ
	DB	0D2H		;JNC
	DB	0DAH		;JC
	DB	0F2H		;JP
	DB	0FAH		;JM
	DB	0F7H		;END OF TABLE

; TWO BYTE OPCODES

TWBYT	DB	3EH		;MVI A
	DB	6		;MVI B
	DB	0EH		;MVI C
	DB	16H		;MVI D
	DB	1EH		;MVI E
	DB	26H		;MVI H
	DB	2EH		;MVI L
	DB	36H		;MVI M
	DB	0C6H		;ADI
	DB	0CEH		;ACI
	DB	0D6H		;SUI
	DB	0E6H		;ANI
	DB	0EEH		;XRI
	DB	0FEH		;CPI
	DB	0D3H		;OUT
	DB	0DBH		;IN
	DB	0F7H		;END OF TABLE

BIAS	DW	0		;RELOCATION BIAS

ITSIN	DB	'ERROR -- SCRNCLK or other extension '
	DB	'already loaded.$'

;	SCREEN CLOCK CODE STARTS HERE

JBDOS:	JMP	0		;BDOS JUMP VECTOR
OLDWB	DW	0		;OLD WARM BOOT ADDRESS
OLDCK	DW	0		;OLD CLOCK ADDRESS
	DB	'CK'		;SIGNATURE

	IF	LINE25
SAVCUR	DB	27,'j',27,'x1',27,'Y8h'
	ENDIF
	IF	NOT LINE25
SAVCUR	DB	27,'j',27,'Y h'
	ENDIF
TIMEBUF	DS	0		;TIME STRING
HOUR	DB	'00:'
MINUTE	DB	'00:'
SECOND	DB	'00'
RESCUR	DB	27,'k',0
TICK	DW	0		;LOCAL TICK COUNTER
ENABL	DB	1		;CLOCK ENABLE FLAG

;	HERE, WE INTERCEPT TIMER INTERRUPTS

MYTIME:	SHLD	HSAVE		;SAVE HL
	POP	H		;GET RETURN ADDRESS
	SHLD	RETSAV		;SAVE IT
	PUSH	PSW		;SAVE A,F
	XCHG
	SHLD	DSAVE		;SAVE DE
	LHLD	TICK		;GET LOCAL TICKER
	INX	H		;ADD ONE
	SHLD	TICK		;UPDATE IT
	MVI	E,-500 AND 0FFH
	MVI	D,(-500)/256	;DE = -500
	DAD	D		;TEST FOR ONE SECOND
	JNC	MYEXIT
	SHLD	TICK		;ELSE, UPDATE TICKER
	MVI	D,'0'		;GET A "0"
	LXI	H,TIMEBUF+7	;POINT TO UNITS OF SECONDS
	INR	M		;INCREMENT IT
	MOV	A,M
	CPI	'9'+1		;OVERFLOW?
	JC	PTIME		;IF NOT, PRINT TIME
	MOV	M,D		;ELSE, ZERO UNITS OF SECONDS
	DCX	H		;DO TENS OF SECONDS
	INR	M
	MOV	A,M
	CPI	'6'
	JC	PTIME
	MOV	M,D
	DCX	H		;DO UNTIS OF MINUTES
	DCX	H
	INR	M
	MOV	A,M
	CPI	'9'+1
	JC	PTIME
	MOV	M,D
	DCX	H		;DO TENS OF MINUTES
	INR	M
	MOV	A,M
	CPI	'6'
	JC	PTIME
	MOV	M,D
	DCX	H		;DO UNITS OF HOURS
	DCX	H
	INR	M
	MOV	A,M
	CPI	'4'		;24 HOURS?
	JC	PTIME
	DCX	H		;CHECK TENS OF HOURS
	MOV	A,M
	CPI	'2'		;24 HOURS?
	JC	CHKUH
	MOV	M,D		;IF SO, ZERO HOUR DIGITS
	INX	H
	MOV	M,D
	JMP	PTIME		;AND PRINT TIME
CHKUH:	INX	H		;CHECK UNITS OF HOURS
	MOV	A,M
	CPI	'9'+1		;OVERFLOW?
	JC	PTIME
	MOV	M,D		;IF SO, ZERO UNIT DIGIT
	DCX	H
	INR	M		;INCREMENT TENS DIGITS

;	CLOCK IS UPDATED, NOW PRINT TIME

PTIME:	LDA	ENABL
	ORA	A		;CLOCK ENABLED?
	JZ	MYEXIT		;NO, EXIT
	LXI	H,0
	DAD	SP		;GET OLD STACK
	LXI	SP,STACK	;SET NEW ONE
	PUSH	H		;SAVE OLD ONE
	LHLD	TICK
	DCX	H		;AVOID DOUBLE TICK
	SHLD	TICK
	LXI	H,LOCLK		;GET LOCAL CLOCK ADDRESS
	SHLD	TIMEINT+1	;FIX CLOCK INTERRUPTS
	EI			;EI WHILE TIME WRITTEN
	LXI	H,SAVCUR	;POINT TO STRING TO PRINT
	IN	351Q		;READ UART PORT
	ORA	A		;ANYTHING THERE?
	JZ	H5PRT		;IF NOT, MUST BE H8-5
PRINT:	MOV	A,M		;GET A CHARACTER
	ORA	A		;END?
	JZ	PEXIT		;YES
	STA	SAVCHR		;ELSE, SAVE CHARACTER
PRINT1:	IN	355Q		;READ STATUS PORT
	ANI	40Q		;READY TO SEND?
	JZ	PRINT1		;IF NOT, LOOP
	LDA	SAVCHR		;ELSE, GET CHARACTER
	OUT	350Q		;SEND IT
	INX	H		;MOVE TO NEXT ONE
	JMP	PRINT		;AND LOOP
H5PRT:	MOV	A,M		;GET A CHARACTER
	ORA	A		;END?
	JZ	PEXIT		;YES
	STA	SAVCHR		;ELSE, SAVE CHARACTER
H5PRT1:	IN	373Q		;H8-5 CODE, LIKE ABOVE
	ANI	1
	JZ	H5PRT1
	LDA	SAVCHR
	OUT	372Q
	INX	H
	JMP	H5PRT
PEXIT:	DI			;KILL INTERRUPTS
	LXI	H,MYTIME
	SHLD	TIMEINT+1	;RESTORE VECTOR TO HERE
	POP	H		;RESTORE OLD STACK
	SPHL			;SET IT
MYEXIT:	LHLD	DSAVE		;GET OLD DE
	XCHG			;RESTORE IT
	POP	PSW		;RESTORE PSW
	LHLD	RETSAV		;GET RETURN ADDRESS
	PUSH	H		;RESTORE IT
	LHLD	HSAVE		;RESTORE HL
	JMP	0		;GO TO CP/M TIME PROCESSOR
TIMEX	EQU	$-2

;	LOCAL CLOCK -- KEEPS TIME WHILE PRINTING TIME

LOCLK:	PUSH	PSW		;SAVE A,F
	PUSH	H		;SAVE HL
	LHLD	TICK		;GET TICKER
	INX	H		;ADD ONE
	SHLD	TICK		;SAVE IT
	POP	H		;RESTORE HL
LOEXIT:	POP	PSW		;RESTORE A,F
	JMP	TIMEX-1		;EXIT TO SYSTEM CLOCK

;	LOCAL WARM BOOT -- TO PROTECT THIS PROGRAM

MYWBOOT:LHLD	JBDOS+1		;GET BDOS ADDRESS
	LXI	D,JBDOS		;AND START OF KEYMAP
	MVI	B,6		;SET A COUNTER
MVSER:	DCX	H		;DECREMENT POINTERS
	DCX	D
	MOV	A,M		;MOVE CP/M SERIAL NO.
	STAX	D		;TO BEFORE KEYMAP
	DCR	B
	JNZ	MVSER
	LDA	CURDSK		;GET CURRENT DISK
	MOV	C,A		;IN C
	JMP	0		;JUMP TO CCP
JCCP	EQU	$-2

CODEND	EQU	$		;CODE ENDS HERE

;	DATA AREA

HSAVE	DW	0
DSAVE	DW	0
RETSAV	DW	0
SAVCHR	DB	0
	DS	128
STACK	DS	0

	END
CODEND	E