;	Keymap -- map function keys to user defined characters
;
;	This program maps the various function keys to user
;	defined character sequences.  The sequence for any
;	one key can be up to 20 characters.
;
;	This version is for CP/M + on the H/Z computers
;
;	BY W.M. Adney 08-31-85
;	COPYRiGHT (C) 1985 BY W. M. Adney

;	Modified by W.M. Adney to include additional keys: 6-1-85
;	Modification Notes
;	1. This program must be assembled before KEYCON & KEYUNmap
;	   because addresses must be obtained from this PRN list
;	   for the KEYCON/UNmap programs.
;	2. All addresses required for the KEYCON program are indicated
;	   by the literal KEYCON in the comments. Addresses required
;	   for KEYUNmap are indicated by UNmap in the comments.
;	3. New and modified code is indicated by my initials - WMA
;	4. Major enhancements to Pat's code include:
;		a. Expansion of code from 41 keys to 56 keys for
;		keypad.
;		b. Keypad default is to alternate mode to allow
;		addition of 13 keys (0-9, ".", "-", and ENTER.
;		Indexing scheme required addition of dummy ESC ?o
;		to maintain. Reset to normal mode by KEYUNmap.
;		c. Added BREAK key to program for mapping.
;		d. Main keyboard can be mapped for following keys:
;			F0-F12, ICHR/DCHR, ILINE/DLINE, HELP, BREAK
;		   17 keys can be mapped in 4 modes:
;		   	Unshifted, shifted, alternate unshifted, alt shifted
;			for a total of 68 commands.
;		e. Keypad (all 18 keys) can be mapped in 2 modes:
;			unshifted, alternate unshifted.
;			One key reserved (normally HOME) for alt key
;			for a total of 35 commands [17 x 2 + 1 (Home)]
;	5. Hard code the SF1 key for ^Q DEL for Wordstar.
;	6. Add special processing for BACKSPACE, LINEFEED, DELETE keys.

;****************************************************************
;                           Definitions				*
;****************************************************************

bios	equ	0	; bios jump vector
cr	equ	0dh	; carriage return
lf	equ	0ah	; line feed
esc	equ	1bh	; escape character
constat	equ	11	; get console status function
dconio	equ	06h	; direct console i/o function
myconin	equ	01h	; read console input function

;****************************************************************
;		RSX Prefix Structure				*
;****************************************************************

	db	0,0,0,0,0,0	; room for serial number
	jmp	FTEST		; beginning of program
next:	db	0c3h		; jump
        dw	0		; next module in line
prev:	dw	0		; previous module
;
;	The remove flag indicates that the CCP can remove any RSX's
;	from memory after a system warm start. Since this RSX will
;	perform key mapping with WordStar, we don't want the RSX
;	removed since a new disk may be logged and WS will
;	perform a warm start for the new disk. Flag is normally
;	set to 0FFh to indicate removal...we will set to 0h so
;	that CCP will not remove key may from memory.
;
remov:	db	0h		; remove flag not set
nonbnk:	db	0		; 0 indicates banked system
				; change to 0ffh for non-banked
pname:	db	'KEYMAP  '	; name of this program
loader:	db	0		; reserve space for loader flag
	db	0,0		; reserved space for RSX

;****************************************************************
;								*
;                        MAIN PROGRAM CODE			*
;                  Check function for intercept			*
;****************************************************************

FTEST:				; is this function 1? (CONIN)
	mov 	a,c 
	cpi 	1 
	jz 	BEGIN		; yes - intercept
        jmp 	next		; some other function 

BEGIN:				; Start the intercept code
	lxi 	h,0	
	dad 	sp 		; save stack
	shld 	ret$stack
	lxi 	sp,loc$stack

CHECKIT:
	call	CCONIN		; get character
	cpi	esc		; is it escape character?
escchr	equ	$-1
	cz	GOTESC		; Yes, check it - otherwise exit

ENDIT:
 	lhld 	ret$stack 	; restore user stack
	sphl
	lxi 	h,0031h		; return SCB ??
	ret

;**************************
;	Escape char found *
;**************************

GOTESC:				; Is it part of a defined key?
	mvi	c,50		; Try for esc 50 times for delay
ESCLP:
;	push	c
	call	CCONST		; check console status
;	pop	c
	ora	a		; Character ready = 01h
	jnz	CREADY		; Is character ready?
	dcr	c		; no - decrement counter
	jnz	ESCLP		; and try again
	xra	a		; took too long to get next character
	sta	asflg		; clear alternate select flag
	mvi	a,esc		; 
	ret			; and exit to program with esc

;************************************************
;	Looks ok - verify that it's a defined function key
;************************************************

CREADY:
	call	CCONIN		; get next character
	lxi	h,HELPKEY	; assume help key
	cpi	'~'		; is it help?
	jz	MHELP		; yes - process
	lxi	h,BRKKEY 	; assume break key
	cpi	'|'		; is it break?
	jz	MBRK		; yes - process
	lxi	h,MAPTBL1	; assume function keys F9-F12
	cpi	'0'		; is it?
	jz	MAPT1		; yes
	lxi	h,MAPTBL2	; assume shifted function keys F0-F12
	cpi	'1'		; is it?
	jz	MAPT2		; yes
	lxi	h,KEYPAD	; assume alt keypad keys
	cpi	'?'		; is it
	jz	KEYP		; yes
	lxi	h,MAPTBL	; otherwise it's regular table
	cpi	'@'		; "@" or more?
	jc	SPMAP		; no
	cpi	'W'+1		; "W" or less?
	jnc	SPMAP		; no
	jmp	GDCHR		; else, good character
;
;	The following code is used to remove special characters
;	from the keys so that the table index can be set up.
;
MHELP:	
	sui	'~'-'@'		; fix reg a (Help key) for index into table
	jmp	NOAS
MBRK:
 	sui	'|'-'@'		; fix reg a (Break key) for table
	jmp	NOAS
MAPT1:				; it's unshifted F9-F12
	push	h		; ESC 0 -  I,J,K or L
	call	CCONIN		; get next character
	pop	h
	sui	'I'-'@'		; fix a register
	jmp	NOAS
MAPT2:				; it's shifted F1-F12
	push	h		; ESC 1A to ESC 1L
	call	CCONIN		; get next character
	pop	h
	sui	1		; fix al to del 1 from key code
	jmp	NOAS		; and process key
KEYP:
	push	h
	call	CCONIN		; get next character
	pop	h
	cpi	'M'		; is it enter key? (ESC ?M)
	jnz	KEYE		; no, it's another keypad key
	lxi 	h,ENTKEY	; process enter key
	sui	'M'-'@'		; fix a register for table index
	jmp	NOAS
KEYE:
	sui	'm'-'@'		; fix reg a to del ? from key code
	jmp	NOAS
;
GDCHR:	push	h
	lxi	h,asflg
	inr	m
	dcr	m		; Working on alternate select key?
	pop	h
	jnz	NOAS		; yes, skip shift check
	cpi	0		; Is this the alternate select key?
askey	equ	$-1		; -KEYCON
	jnz	NOAS		; no - process as usual
	push	h		; Otherwise, 
	lxi	h,asflg
	inr	m		; set alternate select flag
	pop	h
	call	CCONIN		; and get the next key
	cpi	esc		; is it escape?
	jz	GOTESC		; yes, get next character
	push	h
	lxi	h,asflg
	dcr	m		; otherwise, clear alternate select flag
	pop	h
	ret			; and exit	

;************************************************
;	It's a valid function key -- turn mapping on
;************************************************

NOAS:
	push	h
	lxi	h,mapflg
	inr	m		; Set mapping in progress flag
	pop	h
	sui	'@'		; remove ASCII from character
	add	a		; double it
	add	l		; add result to hl
	mov	l,a
	mov	a,h
	aci	0
	mov	h,a		; hl points to table entry
	mov	a,m		; get table entry
	inx	h
	mov	h,m
	mov	l,a		; hl points to defined string
	lda	asflg
	ora	a		; Is this alternate function?
	jz	NOAS1		; no
	mvi	d,LTBL shr 8	; yes, alternate function
	mvi	e,LTBL and 0FFh	; so use second shift table entry
	dad	d
	xra	a
	sta	asflg		; and clear alternate flag
NOAS1:	shld	mapptr		; Set up map pointer

;*******************************************************************
;	mapping routine -- Sends a character from the user supplied
;	string as long as the system requests keyboard input, until
;	the end of the string is reached.  Then normal input is
;	resumed
;*******************************************************************

MAP:
	lhld	mapptr		; get map pointer
	mov	a,m		; get mapped character
	sta	savchr		; Save character
	inx	h
	mov	a,m		; Check next character
	ora	a		; Is it end of defined string?
	jnz	NOTEND		; no
	sta	mapflg		; it's end, clear map flag
NOTEND:	mvi	a,0		; get character
savchr	equ	$-1
	shld	mapptr		; Update map pointer
	ret			; and return with mapped character


;************************************************************************
;	map non-definded escape sequences
;	to preserve them intact
;************************************************************************

SPMAP:	
	sta	spchar		;insert character in buffer
	lxi	h,mapflg
	inr	m		;turn on mapping
	lxi	h,spchar
	shld	mapptr		;Set up map pointer
	mvi	a,esc		;return with esc. character
	ret	

;************************************************
;
;	Special console subroutines for mapping
;
;************************************************

;
;	Special console status routine for mapping
;

CCONST:
	mvi	c,constat	; check console status	
	call 	next		; call bdos
	ret
;
;	Console read subroutine for mapping
;

CCONIN:
;	mvi	c,dconio	; direct i/o
;	mvi	e,0fdh		; load input function
	mvi	c,myconin	; load read console function
	call	next		; call bdos
	ret

;
;	Console write subroutine for mapping
;

CCNOUT:
	mvi	c,dconio	; direct i/o
	mvi	e,m		; load character for console output
	call	next		; call bdos
	ret

;********************************************************
;
;	Basic table of mapped sequences
;
;********************************************************

MAPTBL	dw	IC		; -KEYCON
	dw	UP
	dw	DN
	dw	FWD
	dw	BK
	dw	SF0
	dw	ESCF	; This maintains continuity in the index
	dw	ESCG	; scheme
	dw	HOME
	dw	ESCI	; Another dummy
	dw	F0
	dw	ESCK	; Dummy
	dw	IL
	dw	DLX
	dw	DC
	dw	ESCO	; Dummy
	dw	F6
	dw	F7
	dw	F8
	dw	F1
	dw	F2
	dw	F3
	dw	F4
	dw	F5
MAPTBL1	dw	F9
	dw	F10
	dw	F11
	dw	F12
MAPTBL2	dw	SF1
	dw	SF2
	dw	SF3
	dw	SF4
	dw	SF5
	dw	SF6
	dw	SF7
	dw	SF8
	dw	SF9
	dw	SF10
	dw	SF11
	dw	SF12
HELPKEY	dw	HELP
BRKKEY	dw	BREAK		; note dummy ESCOH required to
KEYPAD	dw	KEYDAS		; maintain index
	dw	KEYDOT
	dw	ESCOH		; for ESC ? o - not used
	dw	KEY0
	dw	KEY1
	dw	KEY2
	dw	KEY3
	dw	KEY4
	dw	KEY5
	dw	KEY6
	dw	KEY7
	dw	KEY8
	dw	KEY9
ENTKEY	dw	KEYENT

;***********************************************
;	mapped character sequences - normal    *
;***********************************************

F0	db	esc,'J',0	; -KEYCON
	ds	18
F1	db	esc,'S',0
	ds	18
F2	db	esc,'T',0
	ds	18
F3	db	esc,'U',0
	ds	18
F4	db	esc,'V',0
	ds	18
F5	db	esc,'W',0
	ds	18
F6	db	esc,'P',0
	ds	18
F7	db	esc,'Q',0
	ds	18
F8	db	esc,'R',0
	ds	18
F9	db	esc,'0I',0
	ds	17
F10	db	esc,'0J',0
	ds	17
F11	db	esc,'0K',0
	ds	17
F12	db	esc,'0L',0
	ds	17
SF0	db	esc,'E',0
	ds	18
SF1	db	11h,7Fh,0	;^Q DEL FOR ShIFT F1
	ds	18		; normal is ESC 1 A
SF2	db	esc,'1B',0
	ds	17
SF3	db	esc,'1C',0
	ds	17
SF4	db	esc,'1D',0
	ds	17
SF5	db	esc,'1E',0
	ds	17
SF6	db	esc,'1F',0
	ds	17
SF7	db	esc,'1G',0
	ds	17
SF8	db	esc,'1H',0
	ds	17
SF9	db	esc,'1I',0
	ds	17
SF10	db	esc,'1J',0
	ds	17
SF11	db	esc,'1K',0
	ds	17
SF12	db	esc,'1L',0
	ds	17
IC	db	esc,'@',0
	ds	18
DC	db	esc,'N',0
	ds	18
IL	db	esc,'L',0
	ds	18
DLX	db	esc,'M',0
	ds	18
HOME	db	esc,'H',0
	ds	18
BK	db	esc,'D',0
	ds	18
FWD	db	esc,'C',0
	ds	18
UP	db	esc,'A',0
	ds	18
DN	db	esc,'B',0
	ds	18
HELP	db	esc,'~',0 
	ds	18 
BREAK	db	esc,'|',0
	ds	18
KEYDAS	db	esc,'?m',0
	ds	17
KEYDOT	db	esc,'?n',0
	ds	17
KEY0	db	esc,'?p',0
	ds	17
KEY1	db	esc,'?q',0
	ds	17
KEY2	db	esc,'?r',0
	ds	17
KEY3	db	esc,'?s',0
	ds	17
KEY4	db	esc,'?t',0
	ds	17
KEY5	db	esc,'?u',0
	ds	17
KEY6	db	esc,'?v',0
	ds	17
KEY7	db	esc,'?w',0
	ds	17
KEY8	db	esc,'?x',0
	ds	17
KEY9	db	esc,'?y',0
	ds	17
KEYENT	db	esc,'?M',0
	ds	17
ESCF	db	esc,'F',0	; These are dummy sequences
ESCG	db	esc,'G',0
ESCI	db	esc,'I',0
ESCK	db	esc,'K',0
ESCO	db	esc,'O',0
ESCOH	db	esc,'?o',0

;************************************************
;	mapped character sequences - alternate  *
;************************************************

F0S	db	esc,'J',0	; -KEYCON
LTBL	equ	F0S-F0
	ds	18
F1S	db	esc,'S',0
	ds	18
F2S	db	esc,'T',0
	ds	18
F3S	db	esc,'U',0
	ds	18
F4S	db	esc,'V',0
	ds	18
F5S	db	esc,'W',0
	ds	18
F6S	db	esc,'P',0
	ds	18
F7S	db	esc,'Q',0
	ds	18
F8S	db	esc,'R',0
	ds	18
F9S	db	esc,'0I',0
	ds	17
F10S	db	esc,'0J',0
	ds	17
F11S	db	esc,'0K',0
	ds	17
F12S	db	esc,'0L',0
	ds	17
SF0S	db	esc,'E',0
	ds	18
SF1S	db	esc,'1A',0
	ds	17
SF2S	db	esc,'1B',0
	ds	17
SF3S	db	esc,'1C',0
	ds	17
SF4S	db	esc,'1D',0
	ds	17
SF5S	db	esc,'1E',0
	ds	17
SF6S	db	esc,'1F',0
	ds	17
SF7S	db	esc,'1G',0
	ds	17
SF8S	db	esc,'1H',0
	ds	17
SF9S	db	esc,'1I',0
	ds	17
SF10S	db	esc,'1J',0
	ds	17
SF11S	db	esc,'1K',0
	ds	17
SF12S	db	esc,'1L',0
	ds	17
ICS	db	esc,'@',0
	ds	18
DCS	db	esc,'N',0
	ds	18
ILS	db	esc,'L',0
	ds	18
DLS	db	esc,'M',0
	ds	18
HOMES	db	esc,'H',0
	ds	18
BKS	db	esc,'D',0
	ds	18
FWDS	db	esc,'C',0
	ds	18
UPS	db	esc,'A',0
	ds	18
DNS	db	esc,'B',0
	ds	18
HELPS	db	esc,'~',0
	ds	18
BREAKS	db	esc,'|',0
	ds	18
KEYDASS	db	esc,'?m',0
	ds	17
KEYDOTS	db	esc,'?n',0
	ds	17
KEY0S	db	esc,'?p',0
	ds	17
KEY1S	db	esc,'?q',0
	ds	17
KEY2S	db	esc,'?r',0
	ds	17
KEY3S	db	esc,'?s',0
	ds	17
KEY4S	db	esc,'?t',0
	ds	17
KEY5S	db	esc,'?u',0
	ds	17
KEY6S	db	esc,'?v',0
	ds	17
KEY7S	db	esc,'?w',0
	ds	17
KEY8S	db	esc,'?x',0	
	ds	17
KEY9S	db	esc,'?y',0
	ds	17
KEYENTS	db	esc,'?M',0
	ds	17
ESCFS	db	esc,'F',0	; Dummy sequences for shifted table
ESCGS	db	esc,'G',0
ESCIS	db	esc,'I',0
ESCKS	db	esc,'K',0
ESCOS	db	esc,'O',0
ESCOHS	db	esc,'?o',0

;****************************************************************
;                      Miscellaneous Data			*
;****************************************************************

spchar	db	0,0		;special char for undef. seq.

mapflg	db	0		;mapping in progress flag
mapptr	dw	0		;mapped character pointer
asflg	db	0		;alternate select flag
ret$stack:	
	dw	0
	ds	32			; 16 level stack
loc$stack:
	end
