	title   getargs - get command arguments
	page    ,96
	subttl  Program Documentation
;
;       getargs - extract arguments from command line image
;
;       getargs version 1 revision 1 of 5/20/84
;
;       Copyright (c) 1984 by   David A. Wallace
;                               146 Westford St.
;                               Chelmsford,  Ma.
;                                       01824
;
;       Released with PRINTL Version 4.04
;
;       This function copies the command line image into a private buffer
;       area with all leading and trailing white space removed and all other
;       white space (unless surrounded by quotes) converted to a single NULL
;       character ('\0').  It returns the number of arguments (words) in the
;       command line as (CX) and builds a structure of pointers to the first
;       byte of each argument.  A pointer to the array of pointers is returned
;       in (BX).  This function is roughly equivelent to the 'c' programming
;       language's "argc" and "*argv[]" invocation sequence, the primary
;       difference being that the I/O redirection operators are not recognized.
;
	subttl  Definitions
	.xlist
	include b:defascii.asm
	include b:defms.asm
	.list
	subttl  Code
	page
prog    segment byte public 'PROG'
	assume  cs:prog,ds:prog,es:prog,ss:prog
	public _getargs
_getargs:
	push    ax
	push    dx
	push    si
	push    di
	mov     si,offset phd_dioa+1    ;       points to command line string
	mov     di,offset argbuf
	mov     bx,offset argptr0
	mov     cx,0
l1:     call    findarg
	jc      x1
	inc     cx
	mov     [bx],di
	inc     bx
	inc     bx
	call    copyarg
	jnc     l1
;
;       end of command line found.
;
x1:     mov     bx,offset argptr0
	pop     di
	pop     si
	pop     dx
	pop     ax
	ret
	subttl  Subroutines
	page
findarg:
	lodsb
	cmp     al,' '
	je      findarg         ;       skip blanks
	cmp     al,cc_ht
	je      findarg         ;         and tabs
	dec     si
	cmp     al,cc_cr
	jne     fax             ;         but return if anything else
	stc                     ;         and quit on carriage return
	ret


fax:    clc
	ret


copyarg:
	lodsb
	cmp     al,' '
	je      cax             ;       copy the arg until a space
	cmp     al,cc_ht
	je      cax             ;         or a tab
	cmp     al,cc_cr
	je      cax             ;         or a carriage return is found
	cmp     al,'"'
	je      caq             ;         but treat quote specially.
	stosb
	jmp     copyarg


cax:    xchg    ah,al
	mov     al,0
	stosb                   ;       put stopper at end of arg string
	xchg    ah,al
	dec     si
	cmp     al,cc_cr
	jne     cax1            ;       if carriage return was the break
	stc                     ;         character, set carry and exit.
	ret


cax1:   clc                     ;       otherwise, clear carry and exit.
	ret


caq:    lodsb
	cmp     al,'"'
	je      caq2            ;       found a second quote
	cmp     al,cc_cr
	je      cax             ;       oops -- unbalanced quote string!
caqd:   stosb                   ;       save the character.
	jmp     caq


caq2:   lodsb                   ;       look at next character.
	cmp     al,'"'          ;         if it is a second quote, save a
	je      caqd            ;         quote and keep scanning the string.
	jmp     cax             ;       Else, we have found end of quoted string
	subttl  Data Area
	page
;
;       Private storage for _getargs
;
argbuf  db      128 dup(?)
argptr0 dw      0               ;       pointer to arg #1
	db      126 dup (0)     ;       pointers to args #2 - #64.
prog    ends
	end     _getargs






















ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ