PAGE ,132 

	TITLE SCDMPGEM - SCREEN DUMP UTILITY
;              Version 3.0   30-Dec-84

;	for Star Micronics Gemini 10/15(X) Printer

;	Written by Les Bordelon - All Rights Reserved

;	SCDMP reproduces Graphics and Text data from the screen of
;	the Zenith Z-100 series system for print out using a Star
;	Micronics GEMINI 10/15 printer in bit-image graphics mode.
;	On receipt of an interrupt-5 (generated by entering
;	<SHFT-F12>) VRAM is enabled and the screen printing is
;	performed.  If COLOR is set to true, then entering a <B> for
;	blue, <R> for red, or <G> for green immediately after the
;	<SHFT-F12> will select the VRAM bank to be printed.  If no
;	character is entered, the green bank is default.  If COLOR
;	is set to false, only the green bank can be dumped.  Two
;	densities of print are selectable.  Entering a <N> for
;	normal or <H> for high immediately after the color or
;	<SHFT-F12> will select print density.  Normal density is the
;	default.  Approximately two seconds is allowed before the
;	program assumes the default settings.  Press <ESC> during
;	printing of the screen to abort the dump.  Note:  To use with
;	the 10X or 15X printer set the GEMX switch to TRUE.


;	Credits:  Zenith Data Systems 	      - Interrupt-5 routine (PSC)
;		  Digital Information Systems - Original Graphic Routines

;	Definitions 

BIOS_SEG SEGMENT AT 40H 			;bios location
	ORG 3*3
  BIOS_CONOUT	LABEL FAR			;console output
	ORG 4*3
  BIOS_PRINT	LABEL FAR			;printer output 
BIOS_SEG ENDS

;	If monitor version = 1, then change ORG to 0290H or the 25th
;		line will not be printed.

MTR_D_SEG SEGMENT AT 0				;ROM monitor data
	ORG	0292H
  MTR_VERP	DB ?				;vertical position of cursor
MTR_D_SEG ENDS

IPAGE_SEG SEGMENT AT 0				;the interrupt area page
	ORG	03FEH
  MTR_DS	LABEL WORD			;location of monitor DS value
IPAGE_SEG ENDS


FALSE	=	0
TRUE	=	NOT FALSE

;	Set to match your printer:  GEM=Gemini 10/15  or GEMX=Gemini 10X 

GEM	=	TRUE
GEMX	=	FALSE

;	Set COLOR to TRUE if all three banks of VRAM are installed

COLOR	=	TRUE


CODE	SEGMENT BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	100H

;*****************ENTRY POINT******************

BEGIN:
	JMP	NEAR PTR START

CHECK	DB	'SCREEN DUMP  VERSION 3.0'	;identification message
CHECKLN EQU	24				;message length

;************INTERRUPT_5 HANDLER***************

INT_5:
	PUSH	DS				;save previous data segment
	PUSH	AX

	MOV	CS:INT_SP,SP
	MOV	CS:INT_SS,SS			;save previous stack

	MOV	AX,CS
	MOV	SS,AX				;set local stack
	MOV	SP,OFFSET INT_STACK

	STI					;now allow interrupts

	PUSH	ES
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI

	MOV	DS,AX
	MOV	ES,AX				;set up new segments

	MOV	AL,'G'				;set defaults - VRAM bank
	MOV	CLRFLG,AL
	MOV	AL,'N'				; and print density
	MOV	DENFLG,AL

	CALL	INT_SIZE			;size screen
	CALL	INT_SCRN			;process the screen

	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	ES

	CLI					;INTs off while messing around
	MOV	AX,INT_SP
	MOV	SP,AX
	MOV	AX,INT_SS			;restore original stack
	MOV	SS,AX

	POP	AX
	POP	DS
	IRET					;back to bios

INT_SS	DW	0				;saved stack values
INT_SP	DW	0

INT_CX	DW	0				;current X location
INT_CY	DW	0				;current Y location
MYCHR	DW	0				;character at position
MYLINE	DB	82 DUP (?)			;line buffer
LINES	DW	24D				;minimum lines

	DW	128 DUP (?)

INT_STACK LABEL NEAR				;internal stack

;*****************SIZE SCREEN******************

;	INT_SIZE checks to see if the 25th line is enabled. If
;	it is, LINES is modified to be 25, so all lines are
;	printed


INT_SIZE:
	MOV	WORD PTR LINES,24		;assume not
	MOV	SI,OFFSET INT_SIZA		;print first line
	CLI					;don't interrupt me now
	CALL	INT_PLINE			;output line
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX				;get data segment
	MOV	DS,DS:[MTR_DS]
	MOV	AL,DS:[MTR_VERP]		;AL = horiz. position of cursor
	POP	DS
	PUSH	AX
	MOV	SI,OFFSET INT_SIZB		;put cursor back
	CALL	INT_PLINE			;output line
	STI
	POP	AX
	CMP	AL,24
	JNZ	INT_SIZ1			;if not on 24th line

;	Cursor moved to 25th line, must be enabled

	INC	WORD PTR LINES

INT_SIZ1:
	RET

INT_SIZA LABEL	NEAR
	DB	01BH,'j'			;save cursor
	DB	01BH,'Y',25+31,1+31		;go here
	DB	-1				;end of message

INT_SIZB LABEL	NEAR
	DB	01BH,'k'			;restore cursor
	DB	-1

INT_PLINE:
	MOV	AL,BYTE PTR [SI]		;get character
	INC	SI				;bump for next time
	CMP	AL,-1
	JZ	INT_PLIN1			;if end of text
	PUSH	SI
	CALL	FAR PTR BIOS_CONOUT		;output it
	POP	SI
	JMP	SHORT INT_PLINE 		;do next

INT_PLIN1:
	RET


SCN_LN	DW	0
CUR_RO	DW	0
COL_INR DW	0
CLRFLG	DB	0
DENFLG	DB	0

;************VIDEO ADDRESS TABLE***************

ROW_DAT DW	00				;base of table
L24	DW	50176D
L23	DW	48128D
L22	DW	46080D
L21	DW	44032D
L20	DW	41984D
L19	DW	39936D
L18	DW	37888D
L17	DW	35840D
L16	DW	33792D
L15	DW	31744D
L14	DW	29696D
L13	DW	27648D
L12	DW	25600D
L11	DW	23552D
L10	DW	21504D
L09	DW	19456D
L08	DW	17408D
L07	DW	15360D
L06	DW	13312D
L05	DW	11264D
L04	DW	09216D
L03	DW	07168D
L02	DW	05120D
L01	DW	03072D
L00	DW	01024D

;*****************END TO TABLE******************
					      
ADDR	DW	0000

;***INT_SCRN - INTERRUPT TIME SCREEN PROCESSOR**

INT_SCRN:
	MOV	AX,0A78H			;video port =11110000 enabled
	OUT	0D8H,AL
	CALL	DE_LAY1				;delay for first input
	CALL	GET_ARG				;determine character input

IF COLOR
	CALL	DE_LAY2				;delay for second input 
	CALL	GET_ARG				;determine character input
	JMP	GET_BANK			;select bank to dump
ELSE
	JMP	G_BANK				;dump green bank only
ENDIF

DE_LAY1:
	MOV	BX,200D 			;initialize delay loop 1

DE_LAY2:
	MOV	CX,1000D			;initialize delay loop 2

DL3:	DEC	CX				;delay loop 1
	IN	AL,0F5H				;check for char avail
	TEST	AL,01H
	JZ	DL4				;no, continue
	IN	AL,0F4H				;else get char
	JMP	DL5
DL4:	CMP	CX,0
	JG	DL3
	DEC	BX				;delay loop 2
	CMP	BX,0
	JG	DE_LAY2
DL5:	RET

GET_ARG:
	AND	AL,0DFH				;force to upper case
	CMP	AL,'B'				;check for 'B'
	JNE	GA1				;nope
	MOV	CLRFLG,AL			;set color flag for blue
	JMP	GA3	
GA1:	CMP	AL,'R'				;check for 'R'	
	JNE	GA2				;nope
	MOV	CLRFLG,AL			;set color flag for red
	JMP	GA3
GA2:	CMP	AL,'H'				;check for 'H'
	JNE	GA3				;nope
	MOV	DENFLG,AL			;set density flag for HIGH
GA3:	RET


GET_BANK:
	CMP	CLRFLG,'B'			;if flag -> B, dump blue
	JE	B_BANK
	CMP	CLRFLG,'R'			;if flag -> R, dump red
	JE	R_BANK

G_BANK: 					;green VRAM bank
	MOV	AX,0E000H			;select location E000H
	JMP	GO_PSC

R_BANK: 					;red VRAM bank
	MOV	AX,0D000H			;select location D000H
	JMP	GO_PSC

B_BANK: 					;blue VRAM bank
	MOV	AX,0C000H			;select location C000H

GO_PSC: 					;GEMINI graphics routine
	DEC	LINES				;adjust lines value
	MOV	ES,AX				;set up seg
	MOV WORD PTR COL_INR,0			;init col =0
	MOV WORD PTR CUR_RO,0			;init row =0
	MOV WORD PTR SCN_LN,0			;init scan line =0
	MOV	AL,1BH				;set line feed
	CALL	CPRN
	MOV	AL,41H				;<ESC>,'A'
	CALL	CPRN
	MOV	AL,08H				;'8'	...8/72
	CALL	CPRN
	MOV	AL,1BH
	CALL	CPRN
	MOV	AL,23H				;accept 8 bit as is
	CALL	CPRN
	MOV	AL,1BH				;set to unidirectional
	CALL	CPRN
	MOV	AL,5FH				;ESC 'U' '1'
	CALL	CPRN
	MOV	AL,01H
	CALL	CPRN
	MOV	AL,0DH				;<CR>
	CALL	CPRN
	MOV	BX,06D				;set top page margin
	CALL	PRLF				;print line feeds
	CALL	NEAR PTR MODE_K 		;graphics mode
	CALL	NEAR PTR PRSPC			;print spaces
	JMP	ROW2

;*********CHARACTER PRINT - CPRN***************

CPRN:
	CALL	FAR PTR BIOS_PRINT		;character print function
	RET


;***********PRINT SPACES ROUTINE***************

PRSPC:
	CMP	LINES,24D			;if 25 lines
	JB	PRSPC1				;pad with spaces
	CMP	DENFLG,'N'			;check density flag for normal
	JNE	PR1
	MOV	BX,15D				;15 SPACES, normal density
	JMP	PSC1
PR1:	MOV	BX,30D				;30 spaces, high density

PSC1:	MOV	AL,00H				;print spaces 
	CALL	CPRN				;spaces+graphics+spaces
	DEC	BX
	CMP	BX,0
	JG	PSC1				;continue as needed
	RET

PRSPC1:
	CMP	DENFLG,'N'			;check density flag for normal
	JNE	PS1
	MOV	BX,24D				;if 24 lines
	JMP	PSC1				;24 spaces, normal density
PS1:	MOV	BX,48D				;48 spaces, high density
	JMP	PSC1

;*********PRINT LINE FEED ROUTINE*************

PRLF:
	MOV	AL,0AH				;print <LF>
	CALL	CPRN
	DEC	BX
	CMP	BX,0
	JG	PRLF				;continue as needed
	MOV	AL,0DH				;terminate with <CR>
	CALL	CPRN
	RET


;***MODE K - SENDS ESC 'K'or 'L' TO PRINTER*****

MODE_K:
	MOV	AX,0000H			;clear AX reg
	CMP	DENFLG,'N'			;check density flag for normal
	JNE	MK1
	MOV	AL,01BH 			;ESC character
	CALL	NEAR PTR CPRN
	MOV	AL,'K'				;the 'K"
	CALL	NEAR PTR CPRN
	MOV	AL,0D1H 			;209 (N1)
	CALL	NEAR PTR CPRN
	MOV	AL,01H				;01 (N2)
	CALL	NEAR PTR CPRN
	JMP	MK2
MK1:	MOV	AL,01BH 			;ESC character
	CALL	NEAR PTR CPRN
	MOV	AL,'L'				;the 'L'
	CALL	NEAR PTR CPRN
	MOV	AL,162D 			;162 (N1)
	CALL	NEAR PTR CPRN
	MOV	AL,03D				;03 (N2)
	CALL	NEAR PTR CPRN
MK2:	RET					;back to calling

;****DO_BYTE - READ THE VRAM AND SEND TO PRN***

DO_BYTE:

	MOV	BX,WORD PTR ADDR		;current address
	MOV	AL,BYTE PTR ES:[BX]		;byte pointed by cur addr
	CALL	NEAR PTR CPRN			;print twice for 
	CALL	NEAR PTR CPRN			; full screen effect
	CMP	DENFLG,'H'			;check density flag for high
	JNE	DB1
	CALL	NEAR PTR CPRN			;print two more times for high
	CALL	NEAR PTR CPRN
DB1:	INC	SCN_LN				;count scan line done
	SUB	BX,128D 			;adjust for scan line
	MOV	WORD PTR ADDR,BX		; and save addr
	CMP	SCN_LN,9			;have we done all 9
	JB	NEAR PTR DO_BYTE		;less than 8 done

;***********ROW - LOOP FOR EACH ROW************

ROW:
	MOV	SCN_LN,0			;init scan line again
	INC	CUR_RO				;count row done

	MOV	BX,LINES			;test # of lines
	CMP	CUR_RO,BX			;test against lines

	JG	DO_COL				;do next col 

ROW2:	
	MOV	AX,CUR_RO			;else more rows
	CMP	LINES,24			;if 25 lines
	JB	LNS24				;--not 25
	MOV	BX,OFFSET ROW_DAT		;begin first table entry

LNS:						;return tgt
	ADD	BX,AX				;R_ADDR=ROW_DAT+CUR_RO
	ADD	BX,AX				;--times two
	MOV	AX,WORD [BX]			;get actual address
	MOV	BX,AX				;swap it back
	MOV	AX,COL_INR			;get current column
	ADD	BX,AX				;C_ADDR=R_ADDR+COL_INR
	MOV	WORD PTR ADDR,BX		;save it at ADDR
	JMP	NEAR PTR DO_BYTE		;do next row

;************24 LINES ROUTINE******************

LNS24:
	MOV	BX,OFFSET ROW_DAT+2		;skip first table entry
	JMP	LNS				;resume at target


;*DO_COL - INCREMENT COLUMN AT END OF EACH ROW*

DO_COL:
	CMP	LINES,24			;if 25 lines
	JE	TERM_LN 			;terminate line 
	CMP	DENFLG,'N'			;check density flag for normal
	JNE	DC1
	MOV	BX,09D				;pad 9 spaces for normal
	JMP	DC2
DC1:	MOV	BX,18D				;pad 18 spaces for high
DC2:	CALL	NEAR PTR PSC1			;print spaces

TERM_LN: 
	MOV	AL,0DH
	CALL	NEAR PTR CPRN			;terminate line with
	MOV	AL,0AH	
	CALL	NEAR PTR CPRN			;<CR/LF>

	IN	AL,0F5H				;check for char avail
	TEST	AL,01H
	JZ	TL1				;no, continue
	IN	AL,0F4H 			;poll the keyboard port
	CMP	AL,01BH 
	JE	NEAR PTR FINI1			;if port -><ESC> then quit

TL1:	INC	COL_INR 			;increment column
	CMP	COL_INR,79D
	JG	NEAR PTR FINI			;screen processed
	MOV	CUR_RO,0			;else re-init row

IF GEMX						;if GEMINI-10X
	MOV	AL,01BH 			;reset printer
	CALL	CPRN
	MOV	AL,40H				;<ESC> '@'
	CALL	CPRN
	MOV	AL,01BH 			;reset line feed
	CALL	CPRN
	MOV	AL,41H				;<ESC> 'A'
	CALL	CPRN
	MOV	AL,08H				;'8'    ...8/72
	CALL	CPRN
	MOV	AL,0DH				;do a <CR>
	CALL	CPRN
ENDIF

	CALL	NEAR PTR MODE_K
	CALL	PRSPC
	JMP	NEAR PTR ROW2

;**************FINISH - ALL DONE**************

FINI1:
	MOV	BX,79D				;adjust lines for quit early
	SUB	BX,COL_INR
	CALL	PRLF

FINI:
	MOV	BX,13D				;reset to top of page
	CALL	PRLF
	MOV	AL,1BH				;reset printer to default
	CALL	CPRN
	MOV	AL,40H				;ESC '@'
	CALL	CPRN
	RET

;*******MARK END OF RESIDENT PORTION**********

INT_END LABEL	NEAR

;**************MAIN ENTRY POINT***************


START:
	MOV	AX,00H				;check to see if already
	MOV	ES,AX				; installed.
	MOV	SI,5*4				;SI points to interrupt
	MOV	ES,ES:WORD PTR [SI+2]
	MOV	SI,OFFSET CHECK 		;get ID message
	MOV	DI,SI
	MOV	CX,CHECKLN			;get length
	REPE	CMPSB				;compare
	JNZ	SETUP				;not installed

	MOV	DX,OFFSET MESG2 		;already installed
	MOV	AH,09H				;get message and function
	INT	21H				;print message
	INT	20H				;exit

SETUP:
	MOV	SP,OFFSET INT_STACK		;good place for it
	PUSH	DS

	XOR	AX,AX
	MOV	DS,AX				;clear DS

	MOV	SI,5*4				;SI points to interrupt
	CLI

	MOV	WORD PTR [SI],OFFSET INT_5
	MOV	WORD PTR [SI+2],CS		;set my interrupt vector

	STI
	POP	DS

	MOV	DX,OFFSET MESG1 		;get signon message address
	MOV	AH,09H				;get function code
	INT	21H				;print message

	MOV	DX,OFFSET INT_END		;LWA of resident portion
	INT	27H

MESG1	DB	13,10,'SCREEN DUMP  Version 3.0  30-Dec-84',13,10,
	DB	'Printer:  Star Micronics Gemini 10/15',

IF GEMX
	DB	'(X)',
ENDIF

	DB	13,10,10,
	DB	'Installed and ready...',13,10,10,
	DB	'To dump screen, type:   <SHIFT-F12>[X]',

IF COLOR
	DB	'[Y]',
ENDIF

	DB	,13,10,10,

IF COLOR
	DB	'  where [X = <G>reen  or <B>lue or <R>ed bank]',13,10,
	DB	'   and  [Y = <N>ormal or <H>igh density]', 
ELSE
	DB	'  where [X = <N>ormal or <H>igh density]',
ENDIF

	DB	13,10,10,'To abort dump during printing, type:   <ESC>',
	DB	13,10,10,'$'

MESG2	DB	13,10,7,'SCREEN DUMP already installed!',
	DB	13,10,10,'$'

CODE	ENDS
	END	BEGIN
