	PAGE	,132
;	101 -- A FIX FOR FAULTY 101-KEYBOARD EMULATION ON
;	ZENITH SUPERSPORT COMPUTERS.  TO USE THIS PROGRAM,
;	ENTER
;
;	101		TO INSTALL IT
;	101 U		TO UN-INSTALL IT (MUST BE LAST TSR)
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  07-JUL-89
;	COPYRIGHT (C) HEATH/ZENITH USERS' GROUP 1988.
;	ALL RIGHTS RESERVED.

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

;	DEFINE SOME MEMORY LOCATIONS

	ORG	1
PSPSEG	LABEL	WORD			;PROGRAM SEGMENT PREFIX SEGMENT ADDR.
	ORG	3
MCBSIZE	LABEL	WORD			;MEMORY CONTROL BLOCK SIZE
	ORG	2CH
ENVSEG	LABEL	WORD			;ENVIRONMENT SEGMENT
	ORG	5DH
FCBARG	LABEL	BYTE			;FCB ARGUMENT
	ORG	100H

START:	JMP	SETUP			;GO SET UP PROGRAM
	EVEN
SIG	DB	'101KEY 1.0'		;PROGRAM SIGNATURE

INT15V	DW	0,0			;INT 15H VECTOR
INT28V	DW	0,0			;INT 28H VECTOR
EXFLG	DB	0			;EXIT FLAG

;	INT 15H PROCESSOR. KEYS ARE SWAPPED HERE

INT15:	CMP	AH,0C0H			;FUNCTION C0?
	JZ	SAY101			;YES
	JMP	CS:DWORD PTR INT15V-0C0H	;ELSE, GO TO OTHER PROCESSES
SAY101:	CLC				;INDICATE 101 KEY KEYBOARD
DUMMY	PROC	FAR
	RET	2			;AND EXIT WITH THIS CONFIGURATION
DUMMY	ENDP

;	INT 28H PROCESSOR.  USED FOR UN-INSTALLING 101.

INT28:	CMP	CS:EXFLG-0C0H,1		;UN-INSTALL 101?
	JZ	UNINS			;YES
	JMP	CS:DWORD PTR INT28V-0C0H	;ELSE, EXIT
UNINS:	PUSH	CS
	POP	DS			;POINT TO THIS SEGMENT
	XOR	AX,AX
	MOV	ES,AX			;AND TO INT. SEGMENT
	MOV	SI,OFFSET INT15V-0C0H	;POINT TO INT 15 VECTOR
	MOV	DI,15H*4		;WHERE IT GOES
	CLD
	MOVSW				;RESTORE VECTOR
	MOVSW
	MOV	SI,OFFSET INT28V-0C0H	;POINT TO INT 28 VECTOR
	MOV	DI,28H*4		;WHERE IT GOES
	MOVSW				;RESTORE VECTOR
	MOVSW
	PUSH	CS
	POP	ES			;PUT ES HERE
	MOV	AH,49H
	INT	21H			;RELEASE THIS PROGRAM'S MEMORY
	MOV	ES,ENVSEG		;POINT TO ENVIRONMENT SEGMENT
	MOV	AH,49H
	INT	21H			;RELEASE ENVIRONMENT SEGMENT
	STI				;ENABLE INTERRUPTS
	INT	20H			;EXIT
ENDRES:					;END OF RESIDENT CODE

;	INSTALL 101 IN MEMORY

SETUP:	MOV	AL,FCBARG
	MOV	FCBARG1,AL		;SAVE FCB ARGUMENT
	CLD
	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;PRINT SIGN-ON
	MOV	AH,52H
	INT	21H			;GET MEMORY CONTROL BLOCK ADDR.
	MOV	AX,ES:[BX-2]		;GET FIRST MCB SEGMENT
	MOV	DS,AX			;POINT TO IT
FNDLP:	MOV	AX,PSPSEG		;GET PSP SEGMENT
	MOV	DX,CS
	CMP	AX,DX			;IN THIS SEGMENT?
	JAE	CHKFND			;IF SO, CHECK IF 101 FOUND
	MOV	ES,AX			;ELSE, PSP SEGMENT TO ES
	MOV	SI,OFFSET SIG
	MOV	DI,SI
	SUB	DI,0C0H			;PROGRAM IS MOVED DOWN
	PUSH	DS			;SAVE MCB SEGMENT
	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	CX,5			;5 WORDS IN SIGNATURE
	REPZ	CMPSW			;IS 101 HERE?
	JZ	GOTCC			;WE FOUND 101
	MOV	LSTSEG,ES		;SAVE PSP SEGMENT
FNDNXT:	POP	DS			;RESTORE MCB SEGMENT
	MOV	AX,MCBSIZE		;GET MCB SIZE
	INC	AX			;CORRECT IT
	MOV	BX,DS
	ADD	AX,BX			;CALCULATE NEXT MCB SEGMENT
	MOV	DS,AX			;POINT TO IT
	JMP	FNDLP			;TRY AGAIN
GOTCC:	MOV	FNDSEG,ES		;SAVE SEGMENT WHERE FOUND
	MOV	BYTE PTR FNDFLG,1	;MARK PROGRAM FOUND
	JMP	FNDNXT
CHKFND:	PUSH	CS
	POP	DS			;FIX DS
	CMP	BYTE PTR FNDFLG,1	;WAS 101 FOUND?
	JNZ	NOTFND			;NO
	MOV	ES,FNDSEG		;GET SEGMENT WHERE FOUND
	CMP	FCBARG1,'U'		;UNINSTALL?
	JNZ	ALINS			;NO
	MOV	BX,FNDSEG		;GET SEGMENT WHERE FOUND
	CMP	BX,LSTSEG		;COMPARE WITH LAST PSP FOUND
	JNC	SETFLG			;OK TO UNLOAD
	MOV	DX,OFFSET NOUNMSG
ALEX:	MOV	AH,9
	INT	21H			;ELSE, SAY "CAN'T UNLOAD"
	INT	20H
ALINS:	MOV	DX,OFFSET ALMSG
	JMP	ALEX			;SAY ALREADY INSTALLED
SETFLG:	MOV	DX,OFFSET UNMSG
	MOV	AH,9
	INT	21H			;PRINT UNINSTALL MSG
	MOV	ES:EXFLG-0C0H,1		;FLAG UNINSTALL
	INT	20H			;AND EXIT
NOTFND:	CMP	FCBARG1,'U'		;UNINSTALL?
	JZ	CANTUN			;CAN'T, IT'S NOT INSTALLED!
	PUSH	CS
	POP	ES			;FIX ES
	MOV	SI,OFFSET START		;POINT TO START OF PROGRAM
	MOV	DI,40H			;PUT IT HERE
	MOV	CX,ENDRES-START		;SIZE OF PROGRAM
	REP	MOVSB			;MOVE PROGRAM DOWN
	MOV	AX,3515H
	INT	21H			;GET INT 15H VECTOR
	MOV	INT15V-0C0H,BX		;SAVE IT
	MOV	INT15V-0BEH,ES
	MOV	AX,3528H
	INT	21H			;GET INT 28H VECTOR
	MOV	INT28V-0C0H,BX
	MOV	INT28V-0BEH,ES		;SAVE IT
	MOV	AX,2515H
	MOV	DX,OFFSET INT15-0C0H
	INT	21H			;INSTALL NEW INT 15H VECTOR
	MOV	AX,2528H
	MOV	DX,OFFSET INT28-0C0H
	INT	21H			;INSTALL NEW INT 28H VECTOR
	MOV	DX,OFFSET INSMSG
	MOV	AH,9
	INT	21H			;PRINT INSTALLATION MSG
NOTDIS:	MOV	DX,OFFSET ENDRES-0C0H
	INT	27H			;EXIT WITH 101 RESIDENT
CANTUN:	MOV	DX,OFFSET NINMSG
	MOV	AH,9
	INT	21H			;SAY "NOT INSTALLED"
	INT	20H

LSTSEG	DW	0			;LAST PSP SEGMENT (SHOULD BE < PSPSEG)
FNDSEG	DW	0			;SEGMENT WHERE FOUND
FNDFLG	DB	0			;PROGRAM FOUND FLAG
FCBARG1	DB	0			;FCB ARGUMENT COPY

SIGNON	DB	13,10,'101 -- 101 key keyboard simulator, v. 1.0'
	DB	13,10,10,'$'
INSMSG	DB	'101 is now installed in memory.  You may uninstall it',13,10
	DB	'by entering',13,10,10
	DB	'  101 U',13,10,10
	DB	'You can only uninstall if 101 is the last TSR loaded.',13,10,'$'
ALMSG	DB	'101 is already installed.',13,10,'$'
UNMSG	DB	'101 is now uninstalled.',13,10,'$'
NOUNMSG	DB	"101 is not the last TSR.  Can't uninstall.",13,10,'$'
NINMSG	DB	"101 is already not installed.",13,10,'$'

CODE	ENDS
	END	START
