	PAGE	,132
;	DTEST -- A DISK TEST PROGRAM.
;	THIS PROGRAM TESTS ANY MS-DOS DISK, AND REPORTS ANY BAD
;	SECTORS FOUND.  IF THE BAD SECTORS ARE IN AN UNUSED PART
;	OF THE DATA AREA OF THE DISK, DTEST CAN MARK THEM AS BAD
;	IN THE FILE ALLOCATION TABLE, SO THAT THEY WILL NOT BE
;	USED BY MS-DOS.  TO USE THIS PROGRAM, ENTER
;
;	DTEST d:
;
;	WHERE d: IS THE DRIVE CONTAINING THE DISK TO TEST.  DISKS
;	MAY BE FLOPPIES, HARD DISKS, OR ANY MEDIUM SUPPORTED BY
;	MS-DOS.
;
;	BY PATRICK SWAYNE, HUG SOFTWARE ENGINEER  25-AUG-88
;	DOS 3.3+ SUPPORT ADDED 22-MAR-89
;	COPYRIGHT (C) HEATH/ZENITH USERS' GROUP 1989.  ALL RIGHTS RESERVED.

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	2
MSIZE	LABEL	WORD			;MEMORY SIZE
	ORG	5CH
DFCB	LABEL	BYTE			;DEFAULT FCB
	ORG	100H

;	MAIN PROGRAM
;	FIRST, GET INFORMATION ABOUT DISK

START:	MOV	DX,OFFSET SIGNON
	CALL	PMSG			;PRINT SIGN-ON
	MOV	AH,30H
	INT	21H			;GET DOS VERSION
	CMP	AL,2			;VERSION 2 OR MORE?
	JAE	DOSOK			;VERSION OK
	MOV	DX,OFFSET BADVER
	CALL	PMSG
	INT	20H			;ELSE, SAY "BAD VERSION"
DOSOK:	CMP	AL,4			;DOS 4 OR ABOVE?
	JAE	NEWDOS
	CMP	AH,30			;VERSION 3.3 OR MORE?
	JB	OLDDOS			;NO
NEWDOS:	MOV	DOS3FLG,1		;ELSE, FLAG DOS 3.3+
	MOV	AX,CS
	MOV	FATADR+2,AX		;SET UP FAT READ ADDRESS
	ADD	AX,1000H
	MOV	D3ADR+2,AX		;SET UP TRANSFER ADDRESS
OLDDOS:	MOV	AX,MSIZE		;GET MEMORY SIZE
	MOV	BX,CS			;AND THIS SEGMENT
	SUB	AX,BX			;SEE HOW MUCH IS FREE
	CMP	AX,2000H		;DO WE HAVE 2 SEGMENTS?
	JAE	MEMOK			;YES
	MOV	DX,OFFSET NEMMSG
	CALL	PMSG			;ELSE, SAY "NOT ENOUGH MEMORY
	INT	20H			;AND EXIT
MEMOK:	MOV	AL,DFCB			;GET DRIVE FROM FCB
	MOV	SP,OFFSET START		;AND GET STACK OUT OF DATA AREA
	DEC	AL			;USE DEFAULT DISK?
	JNS	NOTDEF			;NO
	MOV	AH,19H
	INT	21H			;ELSE, GET DEFAULT
NOTDEF:	MOV	DRIVE,AL		;SAVE AS DRIVE TO READ
	MOV	DX,OFFSET SIGNON1
	CALL	PMSG			;PRINT REST OF SIGN-ON
	MOV	DL,DRIVE		;GET DRIVE
	ADD	DL,'A'			;MAKE IT ASCII
	MOV	AH,2
	INT	21H			;PRINT DRIVE
	MOV	DX,OFFSET COLON
	CALL	PMSG			;PRINT COLON AFTER LETTER
	MOV	AL,DRIVE		;GET DRIVE AGAIN
	INC	AL			;MAKE DRIVE 1-BASED
	MOV	DL,AL			;DRIVE TO DL
	MOV	AH,32H
	INT	21H			;GET INFO ABOUT DRIVE
	MOV	SI,BX			;POINT SI TO TABLE
	MOV	DI,OFFSET DSKBLK	;COPY IT TO HERE
	MOV	CX,18
	REP	MOVSB			;COPY THE TABLE
	PUSH	CS
	POP	DS			;FIX DS
	MOV	AL,MAXSC		;GET MAX SECTOR IN CLUSTER
	INC	AL
	MOV	SPC,AL			;SAVE SECTORS/CLUSTER
	MOV	AX,LASTCL		;GET LAST CLUSTER NO.
	DEC	AX			;MAKE CLUSTERS/DISK
;	MOV	CL,SCLS			;GET SECTOR TO CLUSTER SHIFT
;	SHL	AX,CL			;GET DATA SECTORS/DISK
	MOV	CL,SPC
	XOR	CH,CH			;CX = SECTORS/CLUSTER
	MUL	CX			;CALCULATE SECTORS/DISK
	ADD	AX,FDATS		;ADD NON-DATA SECTORS
	ADC	DX,0
	MOV	COUNT,AX		;SAVE COUNT OF SECTORS ON DISK
	MOV	COUNT+2,DX
	MOV	DX,1
	MOV	AX,0			;DX:AX = 64 K
	MOV	CX,BPS			;GET BYTES/SECTOR
	DIV	CX			;DIVIDE 64K BY BYTES/SECTOR
	MOV	SECTORS,AX		;SAVE SECTORS/64K

;	READ THE FAT INTO MEMORY

	MOV	DX,BOOTS		;GET FIRST FAT SECTOR
	MOV	CL,SPF			;GET SECTORS/FAT
	XOR	CH,CH			;IN CX
RDFAT:	MOV	BX,OFFSET BA.FATBUF	;READ FAT HERE
	MOV	AL,DRIVE
	CMP	DOS3FLG,1		;DOS 3.3+?
	JZ	RF3			;IF SO, USE DIFFERENT READ
	PUSH	CX
	PUSH	DX
	INT	25H			;READ IN THE FAT
	POP	DX			;DUMP FLAGS
	POP	DX
	POP	CX
	JNC	READLP			;READ OK, GO ON WITH TEST
	JMP	SHORT CHK2F		;CHECK FOR 2 FATS
RF3:	MOV	FATSEC,DX		;AND START SECTOR
	MOV	FATCNT,CX		;AND COUNT
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	CX,-1
	MOV	BX,OFFSET FATSEC
	INT	25H			;READ IN THE FAT
	POP	DX
	POP	DX
	POP	CX
	POP	BX
	JNC	READLP			;READ OK, GO ON WITH TEST
CHK2F:	CMP	BYTE PTR NFATS,2	;ARE THERE 2 FATS?
	JNZ	NOFAT			;IF NOT, READ ATTEMPS DONE
	CMP	DX,BOOTS		;ATTEMPTING FIRST READ?
	JNZ	NOFAT			;NO, CAN'T READ EITHER FAT
	PUSH	DX
	MOV	DX,OFFSET FAT1MSG
	CALL	PMSG			;SAY "CAN'T READ FAT 1"
	POP	DX
	ADD	DX,CX			;MOVE TO SECOND FAT
	MOV	BFFLG,1			;MARK FIRST ONE BAD
	JMP	RDFAT			;AND TRY AGAIN
NOFAT:	MOV	DX,OFFSET NFMSG
	CALL	PMSG			;SAY "NO FAT"
	CALL	AYN			;TEST ANYWAY
	JZ	DOTEST			;YES
	INT	20H			;ELSE, EXIT
DOTEST:	MOV	BFFLG,2			;MARK 2 FATS BAD

;	READ THE ENTIRE DISK SURFACE

READLP:	MOV	DX,COUNT+2		;GET SECTOR COUNT HIGH
	OR	DX,DX			;MORE THAN 64K?
	JNZ	FULLRD			;IF SO, MUST BE FULL READ
	MOV	AX,COUNT		;GET COUNT OF SECTORS
	OR	AX,AX			;DONE?
	JZ	DSKDN			;DISK TEST DONE
	CMP	AX,SECTORS		;COMPARE WITH SECTORS/64K
	JB	LASTRD			;COUNT IS LESS, LAST READ
FULLRD:	MOV	AX,SECTORS		;ELSE, READ A FULL SEGMENT
LASTRD:	SUB	COUNT,AX		;AND REDUCE COUNT
	SBB	WORD PTR COUNT+2,0
	MOV	CX,AX			;SECTORS TO CX
	MOV	DX,OFFSET TSTMSG
	CALL	PMSG			;SAY "TESTING SECTORS"
	MOV	AX,SECTOR		;GET START SECTOR
	MOV	DX,SECTOR+2
	CALL	DDECOUT			;PRINT IT
	PUSH	AX
	PUSH	DX
	MOV	DX,OFFSET TOMSG
	CALL	PMSG			;SAY "TO"
	POP	DX
	POP	AX
	ADD	AX,CX			;ADD COUNT TO SECTOR
	ADC	DX,0
	SUB 	AX,1			;GET LAST SECTOR IN GROUP
	SBB	DX,0
	CALL	DDECOUT			;PRINT IT
	CALL	DSKRD			;READ FROM DISK
	JNC	DSKOK			;DISK IS OK
	JMP	DSKBAD			;BAD BLOCK FOUND, CHECK IT OUT
DSKOK:	ADD	SECTOR,CX		;UPDATE CURRENT SECTOR
	ADC	WORD PTR SECTOR+2,0
	JMP	READLP			;AND READ MORE
DSKDN:	TEST	BYTE PTR BADFLG,7	;ANY FAILURES REPORTED?
	JNZ	CHKBF			;YES, CHECK THEM
	MOV	DX,OFFSET GOODMSG
PEXIT:	CALL	PMSG			;SAY "DISK IS GOOD"
EXIT:	INT	20H
CHKBF:	TEST	BYTE PTR BADFLG,2	;UNUSED BAD CLUSTERS?
	JNZ	BADCLUS			;YES, SEE IF MARKING WANTED
CHKMRG:	TEST	BYTE PTR BADFLG,4	;ANY MARGINAL SECTORS?
	JZ	EXIT			;IF NOT, JUST EXIT
	MOV	DX,OFFSET MRGMSG
	JMP	PEXIT			;ELSE, SAY "MARGINAL SECTORS"

;	BAD DATA CLUSTERS FOUND.  SEE IF USER WANTS TO MARK THEM.

BADCLUS:MOV	DX,OFFSET BADCLM
	CALL	PMSG			;SAY "BAD CLUSTERS FOUND"
	CALL	AYN			;ASK IF TO MARK
	JNZ	CHKMRG			;DON'T MARK
	MOV	DI,OFFSET BA.BADBUF	;POINT TO BAD CLUSTER LIST
MCLLP:	CMP	DI,BADPTR		;MARKING DONE?
	JZ	MRKDN			;YES
	MOV	BX,[DI]			;ELSE, GET CLUSTER NUMBER
	INC	DI			;POINT TO NEXT NUMBER
	INC	DI
	CMP	LASTCL,0FF0H		;CHECK FOR 16-BIT FAT
	JGE	MFAT16			;IT IS
	MOV	SI,BX			;ELSE, GET CLUSTER NUMBER IN SI
	SHR	BX,1			;GET 1/2 CLUSTER
	MOV	AX,BA.FATBUF[BX+SI]	;GET WORD FROM FAT TABLE
	JNC	MEVEN			;CLUSTER NUMBER IS EVEN
	OR	AX,0FF70H		;MARK CLUSTER AS BAD
	JMP	SHORT REPCL
MEVEN:	OR	AX,0FF7H		;MARK CLUSTER AS BAD
REPCL:	MOV	BA.FATBUF[BX+SI],AX	;REPLACE MARKED CLUSTER NUMBER
	JMP	MCLLP			;MARK REST OF CLUSTERS
MFAT16:	SHL	BX,1			;DOUBLE CLUSTER NUMBER
	MOV	WORD PTR BA.FATBUF[BX],0FFF7H	;MARK CLUSTER AS BAD
	JMP	MCLLP			;DO MORE
MRKDN:	MOV	DI,OFFSET WF1ERR	;GET FAT 1 BAD MSG
	MOV	DX,BOOTS		;GET FIRST FAT SECTOR
	MOV	CL,SPF			;GET SECTORS/FAT
	XOR	CH,CH			;IN CX
	CMP	BFFLG,1			;IS FAT 1 BAD?
	JNZ	F1NB			;NO
TRYF2:	MOV	DI,OFFSET WF2ERR	;ELSE, GET FAT 2 BAD MSG
	ADD	DX,CX			;AND ADJUST SECTOR NUMBER
F1NB:	MOV	BX,OFFSET BA.FATBUF	;FAT IS HERE
	MOV	AL,DRIVE
	CMP	DOS3FLG,1		;DOS 3.3+?
	JZ	WF3			;IF SO, USE OTHER ROUTINE
	PUSH	CX
	PUSH	DX
	PUSH	DI
	INT	26H			;WRITE THE FAT
	POP	DI			;DUMP FLAGS
	POP	DI
	POP	DX
	POP	CX
	JNC	EXIT1			;WRITE OK
	JMP	SHORT PFMSG		;PRINT FAT ERROR MSG
WF3:	MOV	FATSEC,DX		;AND START SECTOR
	MOV	FATCNT,CX		;AND COUNT
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	MOV	CX,-1
	MOV	BX,OFFSET FATSEC
	INT	26H			;WRITE THE FAT
	POP	DI
	POP	DX
	POP	DX
	POP	CX
	POP	BX
	JNC	EXIT1			;WRITE OK
PFMSG:	MOV	DX,DI			;GET APPROPRIATE MSG
	CALL	PMSG			;SAY "CAN'T WRITE FAT"
	CMP	DI,OFFSET WF2ERR	;FAT 2 ATTEMPTED?
	JNZ	TRYF2			;IF NOT, TRY IT
EXIT1:	JMP	CHKMRG			;CHECK FOR MARGINAL SECTORS

;	BAD SECTOR FOUND IN CURRENT BLOCK.  FIND OUT WHICH
;	ONE IT IS, AND REPORT IT.

DSKBAD:	OR	BYTE PTR BADFLG,80H	;SET TEMPORARY MARGINAL FLAG
	MOV	TCOUNT,CX		;SAVE COUNT
	MOV	DX,OFFSET ERRMSG
	CALL	PMSG			;INDICATE BAD SECTOR(S) FOUND
BADLP:	MOV	CX,1			;READ 1 SECTOR
	CALL	DSKRD
	JC	SECBAD
	JMP	SECOK			;THIS SECTOR WAS OK
SECBAD:	OR	BYTE PTR BADFLG,1	;MARK BAD SECTOR FOUND
	AND	BYTE PTR BADFLG,7FH	;REMOVE TEMPORARY MARGINAL FLAG
	CBW				;MAKE ERROR NUMBER A WORD
	SHL	AX,1			;DOUBLE ERROR NUMBER
	MOV	BX,AX			;IN BX
	MOV	DX,ERRTBL[BX]		;POINT TO ERROR
	CALL	PMSG			;PRINT ERROR
	MOV	DX,OFFSET BADMSG
	CALL	PMSG			;PRINT BAD MESSAGE
	MOV	AX,SECTOR		;GET SECTOR NUMBER
	MOV	DX,SECTOR+2
	CALL	DDECOUT			;PRINT SECTOR NUMBER
	OR	DX,DX			;HUGE SECTOR NUMBER?
	JZ	INDAT			;MUST BE IN DATA AREA
	CMP	AX,BOOTS		;IN BOOT AREA?
	JNB	NOTBOOT
	MOV	DX,OFFSET BOOTMSG
	JMP	NOCLUS			;SHOW ERROR IS IN BOOT AREA
NOTBOOT:CMP	AX,FDIRS		;BELOW DIRECTORY?
	JNB	NOTFAT			;NO
	MOV	DX,OFFSET FATMSG
	JMP	NOCLUS			;SHOW ERROR IS IN FAT AREA
NOTFAT:	CMP	AX,FDATS		;BELOW FIRST DATA SECTOR?
	JNB	INDAT			;NO
	MOV	DX,OFFSET DIRMSG
	JMP	NOCLUS			;SHOW ERROR IS IN DIRECTORY
INDAT:	PUSH	AX
	PUSH	DX
	MOV	DX,OFFSET SECMSG
	CALL	PMSG			;PRINT "IN SECTOR"
	POP	DX
	POP	AX
	SUB	AX,FDATS		;REMOVE NON-DATA SECTORS
	MOV	CL,SPC			;GET SECTORS/CLUSTER
	XOR	CH,CH			;IN CX
	DIV	CX			;CALCULATE CLUSTER AND SECTOR IN IT
	ADD	AX,2			;FIRST CLUSTER IS NO. 2
	MOV	CX,AX			;SAVE CLUSTER NUMBER
	MOV	BX,DX			;GET SECTOR WITHIN CLUSTER
	INC	BX			;MAKE IT 1-BASED
	CALL	DECOUT			;PRINT SECTOR NUMBER
	MOV	DX,OFFSET CLUMSG
	CALL	PMSG			;PRINT "IN CLUSTER"
	MOV	BX,CX			;GET CLUSTER
	CALL	DECOUT			;PRINT CLUSTER NO.
	CMP	BFFLG,2			;BOTH FATS BAD?
	JZ	FATBAD			;YES
	CMP	LASTCL,0FF0H		;CHECK FOR 16-BIT FAT
	JGE	FAT16			;IT IS
	MOV	SI,CX			;ELSE, GET CLUSTER NO. IN SI
	SHR	BX,1			;GET 1/2 CLUSTER
	MOV	AX,BA.FATBUF[BX+SI]	;GET WORD FROM FAT TABLE
	JNC	EVENCL			;EVEN CLUSTER NUMBER
	PUSH	CX			;ELSE, SAVE CLUSTER NUMBER
	MOV	CL,4
	SHR	AX,CL			;SHIFT FAT WORD
	POP	CX
EVENCL:	OR	AX,0F000H		;MAKE IT LOOK LIKE 16-BIT FAT
	TEST	AX,0FFFH		;TEST LOWER 12 BITS
	JMP	SHORT CHKCS		;CHECK CLUSTER STATE
FAT16:	SHL	BX,1			;DOUBLE CLUSTER NUMBER
	MOV	AX,BA.FATBUF[BX]	;GET FAT WORD
	OR	AX,AX			;TEST FOR ZERO
CHKCS:	MOV	DX,OFFSET CLUU		;ASSUME CLUSTER NOT USED
	JZ	GOTCS			;CLUSTER IS NOT IN USE
	MOV	DX,OFFSET CLBAD		;ASSUME CLUSTER IS BAD
	CMP	AX,0FFF7H		;IS IT BAD?
	JZ	GOTCS1			;YES, AND ALREADY MARKED
	MOV	DX,OFFSET CLIU		;CLUSTER MUST BE IN USE
	JMP	SHORT GOTCS1
GOTCS:	OR	BYTE PTR BADFLG,2	;MARK BAD DATA CLUSTERS
	MOV	BX,BADPTR		;GET BAD CLUSTER LIST POINTER
	CMP	BX,OFFSET BA.BADBUF+200	;LIST FILLED?
	JNZ	LNF			;NO
	PUSH	DX			;SAVE MSG
	MOV	DL,7
	MOV	AH,2
	INT	21H			;ELSE, BEEP
	POP	DX
	JMP	SHORT GOTCS1
LNF:	MOV	[BX],CX			;SAVE BAD CLUSTER NUMBER
	INC	BX
	INC	BX			;MOVE POINTER
	MOV	BADPTR,BX		;UPDATE IT
GOTCS1:	CALL	PMSG			;PRINT CLUSTER STATE
FATBAD:	MOV	DX,OFFSET PERIOD
NOCLUS:	CALL	PMSG			;PRINT ".",CR,LF
SECOK:	ADD	WORD PTR SECTOR,1	;INCREMENT SECTOR NUMBER
	ADC	WORD PTR SECTOR+2,0
	DEC	WORD PTR TCOUNT		;COUNT SECTOR
	JNZ	BADLPJ			;LOOK FOR MORE BAD SECTORS
	TEST	BYTE PTR BADFLG,80H
	JZ	READLPJ			;YES
	OR	BYTE PTR BADFLG,4	;ELSE, MARK MARGINAL SECTORS
READLPJ:JMP	READLP			;CONTINUE READING DISK
BADLPJ:	JMP	BADLP

;	DISK READ ROUTINE.  CX = COUNT.

DSKRD:	CMP	BYTE PTR DOS3FLG,1	;DOS 3.3+?
	JZ	D3READ			;IF SO, DIFFERENT READ USED
	MOV	DX,SECTOR		;GET CURRENT SECTOR
	MOV	AX,CS
	ADD	AX,1000H		;MOVE TO READ BUFFER
	MOV	DS,AX			;PUT DS THERE
	XOR	BX,BX			;READ INTO BUFFER BOTTOM
	MOV	AL,CS:DRIVE		;GET DRIVE
	PUSH	CX			;SAVE COUNT
	INT	25H			;READ FROM DISK
	POP	CX			;DUMP FLAGS
	POP	CX			;GET COUNT
	MOV	BX,CS
	MOV	DS,BX			;FIX DS
	RET				;RETURN
D3READ:	MOV	BX,OFFSET SECTOR	;POINT TO STARTING SECTOR
	MOV	D3CNT,CX		;SET UP COUNT
	PUSH	CX
	MOV	CX,-1			;FLAG DOS 3.3+ READ
	MOV	AL,DRIVE
	INT	25H			;READ FROM DISK
	POP	CX			;DUMP FLAGS
	POP	CX			;RESTORE COUNT
	RET

;	DECOUT - PRINT BX IN DECIMAL

DECOUT:	PUSH	AX
	PUSH	DX
	MOV	AX,BX
	XOR	DX,DX
	CALL	DDECOUT			;USE DDECOUT TO PRINT
	POP	DX
	POP	AX
	RET

;	DDECOUT - PRINT 32 BIT NO. IN DX,AX IN DECIMAL
;	(DX) = HIGH WORD, (AX) = LOW WORD

DDECOUT:PUSH	AX			;SAVE REGISTERS
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	BP
	XOR	SI,SI			;CLEAR LEADING ZERO FLAG
	MOV	CX,3B9AH
	MOV	BX,0CA00H		;CX:BX = 1,000,000,000
	CALL	DIVPR			;DIVIDE AND PRINT
	MOV	CX,5F5H
	MOV	BX,0E100H		;CX:BX = 100,000,000
	CALL	DIVPR
	MOV	CX,98H
	MOV	BX,9680H		;CX:BX = 10,000,000
	CALL	DIVPR
	MOV	CX,0FH
	MOV	BX,4240H		;CX:BX = 1,000,000
	CALL	DIVPR
	MOV	CX,1
	MOV	BX,86A0H		;CX:BX = 100,000
	CALL	DIVPR
	XOR	CX,CX			;CX = 0
	MOV	BX,10000		;CX:BX = 10000
	CALL	DIVPR
	MOV	BX,1000			;CX:BX = 1000
	CALL	DIVPR
	MOV	BX,100			;CX:BX = 100
	CALL	DIVPR
	MOV	BX,10			;CX:BX = 10
	CALL	DIVPR
	ADD	AL,'0'			;ADD ASCII TO ONES DIGIT
	MOV	DL,AL
	MOV	AH,2
	INT	21H			;PRINT LAST DIGIT
	POP	BP			;RESTORE REGISTERS
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET				;AND RETURN
DIVPR:	MOV	BP,-1			;SET A COUNTER
DIVPR1:	INC	BP			;INCREMENT COUNTER
	SUB	AX,BX			;SUBTRACT DIVISOR
	SBB	DX,CX
	JNB	DIVPR1			;REPEAT UNTIL OVERFLOW
	ADD	AX,BX			;ADD DIVISOR BACK IN ONCE
	ADC	DX,CX
	PUSH	AX			;SAVE AX
	MOV	AX,BP			;GET COUNTER (WHICH IS DIGIT)
	ADD	AL,'0'			;ADD ASCII OFFSET
	TEST	SI,1			;CKECK ZERO FLAG
	JNZ	DIVPR2			;PASSED LEADING ZEROS, PRINT NO.
	CMP	AL,'0'			;IS NO. ZERO?
	JZ	DIVPR3			;IF SO, EXIT
	OR	SI,1			;ELSE, FLAG ZEROS PASSED
DIVPR2:	PUSH	DX
	MOV	DL,AL
	MOV	AH,2
	INT	21H			;PRINT DIGIT
	POP	DX
DIVPR3:	POP	AX			;RESTORE AX
	RET

;	GET YES OR NO ANSWER

AYN:	MOV	AH,8
	INT	21H			;GET REPLY
	AND	AL,5FH			;CAPITALIZE
	CMP	AL,'Y'			;YES?
	JZ	AYNX			;YES
	CMP	AL,'N'			;NO?
	JZ	AYNN			;YES
	MOV	DL,7
	MOV	AH,2
	INT	21H			;ELSE, BEEP
	JMP	AYN			;TRY AGAIN
AYNN:	OR	AL,AL			;MARK NO ANSWER
AYNX:	PUSHF				;SAVE ANSWER
	MOV	DL,AL
	MOV	AH,2
	INT	21H			;ECHO ANSWER
	MOV	DX,OFFSET CRLFF
	CALL	PMSG			;MOVE DOWN 2 LINES
	POPF
	RET

;	PRINT MESSAGES

PMSG:	MOV	AH,9
	INT	21H
	RET

;	DATA AREA

DOS3FLG	DB	0			;DOS 3.3+ FLAG
DRIVE	DB	0			;DRIVE TO TEST
SPC	DB	0			;SECTORS/CLUSTER
COUNT	DW	0,0			;SECTOR COUNT FOR THIS DISK
TCOUNT	DW	0			;TEMPORARY COUNT
SECTORS	DW	0			;SECTORS/64K
SECTOR	DW	0,0			;CURRENT SECTOR
D3CNT	DW	0			;DOS 3.3 COUNT
D3ADR	DW	0,0			;DOS 3.3 XFER ADDRESS
BADFLG	DB	0			;BAD DISK FLAG
BFFLG	DB	0			;BAD FAT FLAG
BADPTR	DW	OFFSET BA.BADBUF	;BAD CLUSTER LIST POINTER

DSKBLK	LABEL	NEAR			;STORE DISK BLOCK HERE
DCODE	DB	0			;DISK CODE
UNIT	DB	0			;UNIT WITHIN DVD
BPS	DW	0			;BYTES/SECTOR
MAXSC	DB	0			;MAX SECTOR IN CLUSTER
SCLS	DB	0			;SECTOR TO CLUSTER SHIFT
BOOTS	DW	0			;BOOT (RESERVED) SECTORS
NFATS	DB	0			;NUMBER OF FATS
NDIR	DW	0			;NUMBER OF DIR. ENTRIES
FDATS	DW	0			;FIRST DATA SECTOR
LASTCL	DW	0			;LAST CLUSTER NUMBER
SPF	DB	0			;SECTORS/FAT
FDIRS	DW	0			;FIRST DIRECTORY SECTOR

FRBLK	LABEL	NEAR			;FAT READ BLOCK
FATSEC	DW	0,0			;START SECTOR
FATCNT	DW	0			;COUNT
FATADR	DW	OFFSET BA.FATBUF	;ADDRESS LOW
	DW	0			;ADDRESS HIGH

SIGNON	DB	13,10,'HUG Disk Test, v. 1.1',13,10,10,'$'
BADVER	DB	'This program requires DOS 2 or above.',13,10,'$'
NEMMSG	DB	'There is not enough free memory to run this program.',13,10,'$'
SIGNON1	DB	'by Patrick Swayne, HUG Software Engineer',13,10
	DB	"Copyright (C) Heath/Zenith Users' Group 1989.  "
	DB	'All rights reserved.',13,10,10
	DB	'This program tests a disk for bad sectors and reports',13,10
	DB	'any found.  If the bad sectors are in an unused part',13,10
	DB	'of the data area of the disk, you will be given the',13,10
	DB	'option of having them marked as bad sectors in the File',13,10
	DB	'Allocation Table (FAT) so that MS-DOS will not use them',13,10
	DB	'for storing files.',13,10,10
	DB	'Now testing the disk in drive $'
TSTMSG	DB	13,'Testing sectors $'
TOMSG	DB	' to $'
GOODMSG	DB	13,10,10,'This disk is OK (no bad sectors found).',13,10,'$'
FAT1MSG	DB	"Can't read the first FAT.  Will try the second one.",13,10,10,'$'
NFMSG	DB	'Both FATs are bad.  Test disk anyway?  $'
COLON	DB	':'
CRLFF	DB	13,10
CRLF	DB	13,10,'$'
ERRMSG	DB	'.  Possible bad sector(s) located.',13,10,'$'
BADMSG	DB	' at abs. sector $'
SECMSG	DB	', sector $'
CLUMSG	DB	' of cluster $'
PERIOD	DB	'.',13,10,'$'
BOOTMSG	DB	', in the boot sector.',13,10,'$'
FATMSG	DB	', in the FAT sectors.',13,10,'$'
DIRMSG	DB	', in the root directory.',13,10,'$'
MRGMSG	DB	13,10,10,'WARNING: There are marginal sectors on this'
	DB	' disk.',13,10,'$'
BADCLM	DB	13,10,'Bad unused clusters were found.  '
	DB	'Do you want them marked?  $'
WF1ERR	DB	'Unable to write FAT 1.',13,10,'$'
WF2ERR	DB	'Unable to write FAT 2.',13,10,'$'

ERRTBL	DW	OFFSET ERRORA
	DW	OFFSET ERRORB
	DW	OFFSET ERRORC
	DW	OFFSET ERRORD
	DW	OFFSET ERRORE
	DW	OFFSET ERRORF
	DW	OFFSET ERRORG
	DW	OFFSET ERRORH
	DW	OFFSET ERRORI
	DW	OFFSET ERRORJ
	DW	OFFSET ERRORK
	DW	OFFSET ERRORL
	DW	OFFSET ERRORM
	DW	OFFSET ERRORN
	DW	OFFSET ERRORO
	DW	OFFSET ERRORP
ERRORA:
ERRORB:
ERRORD:
ERRORJ:
ERRORK:
ERRORN:
ERRORO:
ERRORP	DB	'N/A error$'
ERRORC	DB	'Drive not ready$'
ERRORE	DB	'CRC error$'
ERRORF	DB	'Bad structure$'
ERRORG	DB	'Seek error$'
ERRORH	DB	'Unknown media$'
ERRORI	DB	'Sector not found$'
ERRORL	DB	'Read fault$'
ERRORM	DB	'General failure$'

CLUU	DB	' (Unused)$'
CLIU	DB	' (In use)$'
CLBAD	DB	' (Marked bad)$'

	EVEN
BA	LABEL	BYTE			;BUFFERS START HERE
BUFFER	STRUC				;BUFFER STRUCTURE
BADBUF	DW	100 DUP (?)		;BAD CLUSTER LIST
FATBUF	DW	?			;FAT BUFFER
BUFFER	ENDS

CODE	ENDS
	END	START
