;DTC PAPER CLEAR AND RESET FUNCTION FOR STYLE WRITER PRINTER
;
;	This program will reset the DTC Style Writer printer to the
;	power up configuration and empty the platen of paper.
;
;BY WILLIAM M. ADNEY: 12-18-85
;
BOOT	  EQU	  0000H
BDOS	  EQU	  0005H
CONIN	  EQU	  1
CONOUT	  EQU	  2
LSTOUT	EQU	5
PLINE	  EQU	  9
FF	EQU	0CH	; form feed
CR	EQU	0DH	; carriage return
LF	EQU	0AH	; line feed
ESC	EQU	1BH	; ESCape character
LINECNT	EQU	60	; # lines (66 decimal) to clear the printer
LINEMAX	EQU	126	; max number of lines available on DTC printer
WAITCNT	EQU	99999	; count for wait loop
;
	  ORG	  0100H

MAIN:	LXI	D,LINE1
	CALL 	SENDLINE

;	Reset the number of lines per page to 126 maximum
;	MVI	E,ESC		;ESCape character
;	CALL	SENDCHAR
;	MVI	E,LINEMAX	; Hopefully sets lines at 126, ASCII '~'
;	CALL	SENDCHAR	  

;	Send Line Feeds to clear the platten
	MVI	B,LINECNT	; set number of printer lines
CNTIT1:	MVI	E,LF		; Line feed
	PUSH	B
	CALL	SENDCHAR	; send it to the printer
	POP	B
	DCR	B		; decrement the counter
	JNZ	CNTIT1		; try again if counter not zero

;	Roll the platen again to clear the paper
	MVI	B,LINECNT	; set number of printer lines
CNTIT2:	MVI	E,LF		; Line feed
	PUSH	B
	CALL	SENDCHAR	; send it to the printer
	POP	B
	DCR	B		; decrement the counter
	JNZ	CNTIT2		; try again if counter not zero

;	Must wait until the above is finished or the reset
;	will clear all commands from the printer.
HOLDIT:	LXI	D,LINE2
	CALL 	SENDLINE
HOLD1:	MVI	E,0FFH		; To read the console
	MVI	C,6		; Direct console I/0 function
	CALL	BDOS		; to check if character input
	JZ	HOLD1		; check again if nothing input

;	Send a complete printer reset
	MVI	E,ESC	      	;ESCape character
	CALL	SENDCHAR
	MVI	E,CR
	CALL	SENDCHAR	  
	MVI	E,'P'
	CALL	SENDCHAR	  

	RET			; Return to operating system
;
;************************************
;				    *
;    SUBROUTINES		    *
;				    *
;************************************
;
SENDCHAR: MVI	    C,LSTOUT
	  CALL	    BDOS
	  RET
SENDLINE: MVI	    C,PLINE
	  CALL	    BDOS
	  RET
;HOLDIT:	MVI	B,WAITCNT	; set the wait value
;WAITIT:
;	DCR	B		; decrement the counter
;	JNZ	WAITIT		; try again if counter not zero
;	RET
;
;
LINE1:	DB  'Clearing paper from DTC Style Writer',CR,LF,LF,'$'
LINE2:	DB  'Press any key to reset the DTC Style Writer',CR,LF,'$'
	DS	014H		;RESERVE SPACE FOR 10 ENTRIES
STACK	  DS	  001H		  ;TOP OF STACK IS HERE
BUFFER	  EQU	  $		  ;STORAGE AREA STARTS HERE
	  END	  MAIN
