;SCROLL KEY CONTROL FOR THE SCREEN USING HEATH HOLD SCREEN MODE
;
;	This program will clear the screen and provide scroll key
;	control for each line. The scroll key only allows one line of
;	information to be printed on the bottom line...the top line
;	scrolls off.
;
;	SHIFT SCROLL allows a new page to scroll on the screen.
;
;BY WILLIAM M. ADNEY--2-23-83
;
BOOT	  EQU	  0000H
BDOS	  EQU	  0005H
CONIN	  EQU	  1
CONOUT	  EQU	  2
PLINE	  EQU	  9
CR	  EQU	  0DH
LF	  EQU	  0AH
;
	  ORG	  0100H
MAIN:	  LXI	  D,CLEARIT	  ;CLEAR FUNCTION
	  CALL	  SENDLINE	  ;SENT CLS
	  LXI	  D,LINE1	  
	  CALL	  SENDLINE	  
	  LXI	  D,LINE2
	  CALL	  SENDLINE
	  LXI	  D,LINE3
	  CALL	  SENDLINE
	  LXI	  D,LINE4
	  CALL	  SENDLINE
	  LXI	  D,LINE5
	  CALL	  SENDLINE
;
;Enter the hold screen mode(ESC [)
;
	  LXI	  D,HOLDIT  ;Enter hold screen mode
	  CALL	  SENDLINE
;
;
;Remember the cursor position
;
	  LXI	  D,CURPOS  ;REMEMBER CURSOR POSITION
	  CALL	  SENDLINE
;
;Enable the 25th line
;
	  LXI	  D,ENABLE25	      ;25TH LINE ENABLE
	  CALL	  SENDLINE
;
;Position cursor at the beginning of 25th line
;
	  LXI	  D,BEGIN25	      ;25TH LINE BEGINNING
	  CALL	  SENDLINE
;
;
;Print 25th line
;
	  LXI	  D,LINE25	      ;25TH LINE HEADINGS
	  CALL	  SENDLINE
;
;
;Set cursor to previously saved position
;
	  LXI	  D,CURSAVE	      ;cursor to saved position
	  CALL	  SENDLINE
	  RET
;
;************************************
;				    *
;    SUBROUTINES		    *
;				    *
;************************************
;
SENDLINE: MVI	    C,PLINE
	  CALL	    BDOS
	  RET
;
HOLDIT:   DB	1BH,5BH,'$'   ;Enter hold screen mode--ESC [
;
ENABLE25: DB	1BH,78H,31H,'$'     ;25th line enable--ESC x 1
;
BEGIN25: DB	1BH,59H,38H,20H,'$'	;CURSOR-25th line--ESC Y 8 SP
;
LINE25:   DB '     ***** SCROLL ENABLED *****$'
;
CLEARIT:  DB	1BH,45H,'$'	;CLEAR FUNCTION--ESCAPE E
;
CURPOS:   DB	1BH,6AH,'$'	;Remember cursor position--Escape j
;
CURSAVE:  DB	1BH,6BH,'$'	;Cursor to saved position-ESC k
;
;
LINE1:	DB  'This program sets the SCROLL key enable.',CR,LF,'$'
LINE2:	DB  ' ',CR,LF,'$'
LINE3:	DB  'SCROLL key controls one line at a time.',CR,LF,'$'
LINE4:	DB  'SHIFT SCROLL controls one page at a time.',CR,LF,'$'
LINE5:	DB  'To reset the CRT, use the command CRTRESET',CR,LF,'$'
	DS	014H		;RESERVE SPACE FOR 10 ENTRIES
STACK	  DS	  001H		  ;TOP OF STACK IS HERE
BUFFER	  EQU	  $		  ;STORAGE AREA STARTS HERE
	  END	  MAIN
PACE FOR 10 ENTRIES
STACK	  DS	  001H		  ;TOP OF STACK IS HERE
BUFFER