	PAGE	,132
;	BLKCUR -- FORCE NORMAL CURSOR TO BLOCK CURSOR
;	THIS PROGRAM FORCES THE CURSOR TO BE A BLOCK CURSOR
;	WHENEVER A PROGRAM SETS IT TO A NORMAL (2 LINE)
;	CURSOR VIA THE BIOS.  IF THE PROGRAM ATTEMPTS TO
;	SET A BLOCK CURSOR, IT WILL BE SET TO A BLOCK WITH
;	THE LAST TWO LINES GONE.
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  08-DEC-86

VIDINT	EQU	10H*4		;KEYBOARD INTERRUPT VECTOR
BIOSSEG	EQU	40H		;BIOS RAM SEGMENT

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	JMP	SETUP		;SET UP THE PROGRAM

BLKCUR	DW	7		;CURSOR END LINE
VIDVEC	DD	0		;KEYBOARD INTERRUPT VECTOR

;	VIDEO INTERRUPT PROCESSOR
;	HERE, AN ATTEMPT TO PROGRAM THE CURSOR TYPE
;	IS CHECKED, AND IF A NORMAL OR BLOCK CURSOR IS
;	TO BE SET, THE RESULTS ARE ALTERED.

VIP:	CMP	AH,0			;SETTING VIDEO MODE?
	JZ	SETMOD			;YES
	CMP	AH,1			;SET CURSOR TYPE?
	JZ	SETCT			;YES
	CMP	AH,3			;GET CURSOR TYPE?
	JNZ	VIPX			;NO
	JMP	GETCT
SETCT:	CMP	CX,607H			;SET NORMAL CURSOR?
	JZ	SETBLK			;IF SO, SET BLOCK
	CMP	CX,0B0CH		;NORMAL MONO CURSOR?
	JNZ	CHKBLK			;NO, CHECK FOR BLOCK
SETBLK:	MOV	CX,CS:BLKCUR		;ELSE, MAKE IT A BLOCK
	JMP	SHORT VIPX		;AND EXIT
CHKBLK:	OR	CH,CH			;SETTING BLOCK CURSOR?
	JNZ	VIPX			;NO
	CMP	CL,7			;FULL BLOCK?
	JB	VIPX			;NO
	SUB	CX,2			;ELSE, MODIFY IT
VIPX:	JMP	CS:DWORD PTR VIDVEC	;ELSE, EXIT
SETMOD:	PUSHF
	CALL	CS:DWORD PTR VIDVEC	;SET MODE
	PUSH	AX
	PUSH	CX
	MOV	AH,1
	MOV	CX,607H
	STI
	INT	10H			;FIX CURSOR
	POP	CX
	POP	AX
	IRET
GETCT:	PUSHF
	CALL	CS:DWORD PTR VIDVEC	;GET CURSOR TYPE
	OR	CH,CH			;BLOCK CURSOR?
	JNZ	GETCX			;NO
	PUSH	AX
	MOV	AL,CS:BYTE PTR BLKCUR
	CMP	CL,AL			;CURSOR IS BLOCK NOW?
	JZ	RETNOR			;RETURN NORMAL CURSOR
	SUB	AL,2
	CMP	CL,AL			;CURSOR SET AS BLOCK?
	POP	AX
	JNZ	GETCX			;NO
	ADD	CL,2			;ELSE, RETURN FULL BLOCK SIZE
GETCX:	IRET
RETNOR:	MOV	CL,AL			;RETURN CURSOR BOTTOM
	DEC	AL
	MOV	CH,AL			;RETURN CURSOR TOP
	POP	AX
	IRET
ENDRES:					;END OF RESIDENT CODE

;	SET UP PROGRAM IN MEMORY

SETUP:	MOV	AH,15
	INT	10H			;TEST VIDEO MODE
	CMP	AL,7			;MONOCHROME?
	JNZ	SETUP1			;NO
	MOV	BYTE PTR BLKCUR,0CH	;ELSE, FIX CURSOR END
SETUP1:	XOR	AX,AX
	MOV	DS,AX			;POINT TO INT. SEGMENT
	MOV	SI,OFFSET VIDINT	;POINT TO VID INT.
	MOV	DI,OFFSET VIDVEC	;PUT IT HERE
	PUSH	SI
	CLD
	MOVSW				;MOVE VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET VIP ;SET NEW VECTOR
	MOV	2[SI],CS
	PUSH	CS
	POP	DS			;FIX DS
	MOV	AH,1
	MOV	CX,607H
	INT	10H			;FIX CURSOR
	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;PRINT SIGN-ON MESSAGE
	MOV	DX,OFFSET ENDRES
	INT	27H			;EXIT, CODE RESIDENT

SIGNON	DB	13,10,'BLKCUR installed.'
	DB	13,10,'$'

CODE	ENDS
	END	START
