	PAGE	,132
	TITLE	ANTI-PARANOID 2
;	ANTI-PARANOID PROGRAM DEBUGGING AID (APPROACH 2)
;	THIS PROGRAM ALLOWS YOU TO DEBUG PARANOID PROGRAMS
;	THAT WIPE OUT THE BREAKPOINT INTERRUPT
;
;	THIS PROGRAM MUST BE RUN UNDER DEBUG!
;
;	BY PATRICK SWAYNE, HUG SOFTWARE ENGINEER  04-APR-86

DIV0	EQU	0			;DIV/0 INTERRUPT VECTOR
BKPINT	EQU	3*4			;BREAKPOINT INTERRUPT VECTOR
UNUSED	EQU	18H			;UNUSED INTERRUPT VECTOR

CODE	SEGMENT
	ORG	2
MEMSIZ	DW	0			;MEMORY SIZE STORED HERE
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;PRINT SIGN-ON
	XOR	AX,AX
	MOV	ES,AX			;POINT TO INTERRUPT SEGMENT
	MOV	DS,AX			;DS ALSO
	CLD
	MOV	DI,OFFSET DIV0		;POINT TO DIV/0 VECTOR
	MOV	AX,16EBH		;GET "JMP 18H"
	STOSW				;PUT IT IN DIV/0 VECTOR
	MOV	DI,OFFSET UNUSED	;POINT TO UNUSED VECTOR
	MOV	SI,OFFSET BKPINT	;AND TO BREAKPOINT VECTOR
	MOV	AL,0EAH			;GET "JMPF"
	STOSB				;PUT IT IN
	PUSH	SI
	MOVSW				;MOVE IN BREAKPOINT VECTOR
	MOVSW
	POP	SI
	MOV	AX,CS			;GET CURRENT SEGMENT
	CMP	AX,3000H		;TEST IT
	JB	NOTTM			;NOT TOO MUCH USED
	PUSH	CS
	POP	DS			;ELSE, PUT DS HERE
	MOV	DX,OFFSET TOOMSG
	MOV	AH,9
	INT	21H			;SAY "TOO MUCH MEMORY USED"
	INT	20H			;AND EXIT
NOTTM:	MOV	AX,CS:MEMSIZ		;GET MEMORY SIZE
	CMP	AX,7000H		;TEST IT
	JNB	MEMOK			;MEMORY OK
	PUSH	CS
	POP	DS
	MOV	DX,OFFSET NEMMSG
	MOV	AH,9
	INT	21H			;SAY "NOT ENOUGH MEMORY"
	INT	20H
MEMOK:	MOV	AX,4E4EH
	MOV	ES,AX			;POINT TO 4E4EH SEGMENT
	MOV	DI,4E4EH		;POINT TO 4E4EH OFFSET
	MOV	AL,0EAH
	STOSB				;PUT IN "JMPF"
	MOVSW				;MOVE IN BREAKPOINT VECTOR
	MOVSW
	PUSH	CS
	POP	DS
	MOV	DX,OFFSET VECMSG
	MOV	AH,9
	INT	21H			;SAY "VECTORS INSTALLED"
	INT	20H

SIGNON	DB	13,10,'ANTI-PARANOID Debug Support Utility, V 2.0',13,10
	DB	'By Patrick Swayne, HUG Software Engineer',13,10
	DB	"Copyright (C) 1986 by Heath/Zenith Users' Group",13,10,10
	DB	'THIS PROGRAM MUST BE RUN USING APSET2!',13,10,10,'$'
TOOMSG	DB	'Too much memory used for vector at 4E4E:4E4E.',13,10,'$'
NEMMSG	DB	'Not enough memory for vector at 4E4E:4E4E.',13,10,'$'
VECMSG	DB	'Vectors at 0:0 and 4E4E:4E4E installed.',13,10,'$'

CODE	ENDS
	END	START
