	TITLE	PWINDOW CONTROL PROGRAM
	PAGE	,132
;	THIS PROGRAM ALLOWS YOU TO TURN OFF OR ON THE SCREEN
;	DISPLAY PRODUCED BY THE PWINDOW PROGRAM.  TO USE IT,
;	ENTER
;
;	A>PW OFF		TO TURN THE DISPLAY OFF
;
;	A>PW			TO TURN THE DISPLAY ON (OLD SETTINGS)
;
;	A>PW xx,xx		TO SET THE DISPLAY TO xx:xx
;
;	WHERE xx,xx IS REGISTER NAMES OR HEX NUMBERS
;
;	BY P. SWAYNE, HUG  01-APR-86

;	DEFINITIONS

CMDBUF	EQU	80H			;COMMAND LINE BUFFER

PW	SEGMENT
	ASSUME	CS:PW,DS:PW,ES:PW,SS:PW
	ORG	100H

START:	MOV	SI,OFFSET CMDBUF	;POINT TO COMMAND LINE
	LODSB				;GET COUNT BYTE
	OR	AL,AL			;ANY ARGUMENT?
	JNZ	GOTARG			;YES
	MOV	BX,0FEFEH		;ELSE, SIGNAL TURN ON
	JMP	PWON
GOTARG:	CBW				;AX = COUNT
	MOV	CX,AX			;IN CX
SOS:	LODSB				;GET NEXT BYTE
	CMP	AL,' '			;SPACE?
	JNZ	NOTSP			;NO
	LOOP	SOS
NOTSP:	CMP	AL,'?'			;EXPLAIN?
	JNZ	NOEXP			;NO
	MOV	DX,OFFSET EXPMSG
	MOV	AH,9
	INT	21H			;PRINT EXPLANATION
	INT	20H
NOEXP:	DEC	SI			;BACK UP TO ENTRY
	PUSH	SI			;SAVE ADDRESS
	PUSH	CX			;SAVE COUNT
MAPUC:	MOV	AL,[SI]			;GET CHARACTER
	CALL	MUC			;MAP TO UPPER CASE
	MOV	[SI],AL			;REPLACE IT
	INC	SI			;INCREMENT POINTER
	LOOP	MAPUC			;DO ALL OF ENTRY
	POP	CX			;RESTORE COUNTER
	POP	SI			;AND ADDRESS
	CMP	BYTE PTR [SI],'O'	;OFF?
	JNZ	CHKARG			;NO, CHECK ARGUMENT
	MOV	AX,0F300H		;TRACER FUNC., DISPLAY OFF
	INT	21H			;KILL DISPLAY
	MOV	DX,OFFSET CLMSG
	MOV	AH,9
	INT	21H			;SAY "WINDOW IS CLOSED"
EXIT:	INT	20H			;AND EXIT
CHKARG:	MOV	AX,[SI]			;GET FIRST TWO CHARACTERS
	MOV	CX,14			;14 REGISTERS
	MOV	DI,OFFSET REGTBL	;POINT TO REGISTER TABLE
	REPNZ	SCASW			;LOOK FOR USERS'S ENTRY
	JNZ	NOTREG			;NOT A REGISTER
	SUB	DI,(OFFSET REGTBL)+2	;ELSE, CALCULATE OFFSET
	MOV	AX,DI
	MOV	BH,AL			;BH = HIGH REGISTER NO.
	INC	SI
	INC	SI			;MOVE PAST REGISTER NAME
	JMP	CHKLOW			;CHECK FOR LOW ENTRY
NOTREG:	CALL	HEXIN			;GET NUMBER
	CMP	AL,':'			;MUST SPECIFY SEGMENT
	JZ	GOTSEG
	MOV	DX,OFFSET NSMSG
	MOV	AH,9
	INT	21H			;SAY "NO SEGMENT"
	INT	20H
GOTSEG:	MOV	CX,BX			;SEGMENT IN CX
	CALL	HEXIN			;GET NEXT NUMBER
	DEC	SI			;BACK UP POINTER
	MOV	DX,BX			;IN DX
	MOV	BH,0FFH			;MARK HIGH = ADDRESS
CHKLOW:	MOV	BL,0FEH			;MARK LOW NOT CHANGED
	MOV	AL,[SI]			;GET NEXT CHARACTER
	CMP	AL,','			;MORE TO COME?
	JNZ	PWON			;NO, DONE
	INC	SI			;SKIP COMMA
	MOV	AX,[SI]			;GET FIRST TWO CHARACTERS
	MOV	CX,14			;14 REGISTERS
	MOV	DI,OFFSET REGTBL	;POINT TO REGISTER TABLE
	REPNZ	SCASW			;LOOK FOR USERS'S ENTRY
	JNZ	NOTREG1			;NOT A REGISTER
	SUB	DI,(OFFSET REGTBL)+2	;ELSE, CALCULATE OFFSET
	MOV	AX,DI
	MOV	BL,AL			;BL = LOW REGISTER NO.
	JMP	SHORT PWON		;TURN PWINDOW ON
NOTREG1:PUSH	BX			;SAVE HIGH INDICATOR
	CALL	HEXIN			;GET NUMBER
	MOV	BP,CX			;ASSUME NO SEGMENT
	CMP	AL,':'			;IS IT SEGMENT?
	JNZ	NOSEG			;NO
	MOV	BP,BX			;ELSE, SEGMENT IN BP
	CALL	HEXIN			;GET NEXT NUMBER
NOSEG:	MOV	DI,BX			;IN DI
	MOV	SI,BP			;SEGMENT IN SI
	POP	BX			;GET INDICATOR
	MOV	BL,0FFH			;MARK LOW IS NUMBER
PWON:	MOV	AX,0F301H		;TRACER FUNC, ENABLE DISPLAY
	INT	21H			;SET TRACER
	MOV	DX,OFFSET OPMSG
	MOV	AH,9
	INT	21H
	INT	20H			;AND EXIT

;	MAP LOWER TO UPPER CASE

MUC:	CMP	AL,'a'			;LESS THAN "a"?
	JB	NOMAP
	CMP	AL,'z'+1		;MORE THAN "z"?
	JNB	NOMAP
	AND	AL,5FH			;BETWEEN "a" AND "z", MAP
NOMAP:	RET

;	INPUT ASCII HEX NUMBERS. SI POINTS TO STRING.
;	RESULT IN BX.

HEXIN:	XOR	BX,BX			;CLEAR ACCUMULATOR
HEXLP:	MOV	AL,[SI]			;GET DIGIT
	INC	SI			;MOVE POINTER
	MOV	AH,AL			;SAVE IN AH
	SUB	AL,'0'			;REMOVE ASCII
	JC	HEXEND			;LESS THAN "0"
	ADD	AL,'0'-'G'
	JC	HEXEND			;MORE THAN "F"
	ADD	AL,6			;TEST FOR A-F
	JNS	HEXOK			;DIGIT IS A-F
	ADD	AL,7			;TEST FOR 0-9
	JC	HEXEND			;DIGIT OUT OF RANGE
HEXOK:	ADD	AL,10			;ELSE, ADJUST
	PUSH	AX			;SAVE DIGIT
	MOV	AX,BX
	MUL	BYTE PTR SIXTEEN	;MULTIPLY ACCUMULATOR BY 16
	MOV	BX,AX
	POP	AX
	OR	BL,AL			;ADD IN LATEST DIGIT
	JMP	HEXLP			;GET ANOTHER ONE
HEXEND:	MOV	AL,AH			;PUT LAST CHAR IN AL
	RET

;	DATA AREA

REGTBL	DB	'AXBXCXDXSIDIBPSPIPCSDSESSSFL'	;REGISTER NAMES
SIXTEEN	DB	16				;MULTIPLIER
NSMSG	DB	'ERROR -- Specify address in the form ssss:oooo.$'
OPMSG	DB	'Processor Window is Opened.$'
CLMSG	DB	'Processor Window is Closed.$'
EXPMSG	DB	13,10
	DB	'PROCESSOR WINDOW Debug Support Utility (Control Program) V 1.0'
	DB	13,10,10
	DB	'To use this program, enter',13,10,10
	DB	'  PW ?			to print this message',13,10,10
	DB	'  PW			to open the window',13,10,10
	DB	'  PW OFF		to close the window',13,10,10
	DB	'  PW xx[,xx]		to open the window and',13,10
	DB	'			select the display',13,10,10
	DB	'where xx is AX, BX, CX, DX, SI, DI, BP, SP, IP,',13,10
	DB	'CS, DS, ES, SS, or FL; or a hex address in the',13,10
	DB	'form ssss:oooo.  If the segment (ssss:) is left',13,10
	DB	'off of a second address entry, the segment from',13,10
	DB	'the first entry is used.',13,10,'$'
PW	ENDS
	END	START
