;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
PAGE	,132
	TITLE	MDISK - Memory disk driver

;***	MDISK - Memory Disk driver
;
;	MDISK is a memory based disk. Its is configurable to the users
;	system size through the parameters listed below.
;
;	Brian Barnes
;	Copyright(C) 1983, Zenith Data Systems
;	February 10, 1983
;

;	User settable options

DISK_SIZE	EQU	64		; # of k bytes in disk
DIR_SIZE	EQU	1		; # of 16 entry directory blocks

;	Non-user settable options

MDISK_SIZE	EQU	DISK_SIZE/16*1024	; 64k in 16 byte units
MDISK_DIRS	EQU	(512*DIR_SIZE)/32	; # of dirs in 512 byte units

	INCLUDE	PARMS.ASM
	INCLUDE	DEFDEV.ASM
	INCLUDE	MACLIB.ASM

CODE	SEGMENT	BYTE
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

MDISK	LABEL	NEAR			; Begin header information

	ERRNZ	MDISK,DVH_OFF
	DW	-1			; Link to next device
	ERRNZ	MDISK,DVH_SEG
	DW	-1			;  as a dword pointer

	ERRNZ	MDISK,DVH_ATTR
	DW	DVHA_IBM		; Non-IBM format
	ERRNZ	MDISK,DVH_STRAT
	DW	OFFSET MD_STRAT		; Address of strategy routine
	ERRNZ	MDISK,DVH_INTR
	DW	OFFSET MD_INTR		; Address of interrupt routine
	ERRNZ	MDISK,DVH_NAME
	DB	1,'*MDISK*'
	ERRNZ	MDISK,<SIZE DVH_STRUC>

MDISK_BPBVEC	LABEL	NEAR
	DW	OFFSET MDISK_BPB

MDISK_BPB	LABEL	NEAR		; BPB table for MDISK
	DW	512			; 512 byte sectors
	DB	1			; Allocation units
	DW	0			; No reserved sectors
	DB	1			; 1 FAT
	DW	MDISK_DIRS		; Directory entries
	DW	DISK_SIZE*2		; # of sectors
	DB	0FFH			; Media byte
	DW	12			; # of sectors in a FAT

;	There are 2 entry points to a drive, the strategy entry point
;	and the interrupt entry point. When Z-DOS wishes to do an i/o
;	request, it first calls the strategy routine with a dword pointer
;	in the ES:BX registers. The strategy routine simply saves this
;	pointer and returns to the system. The interrupt routine is then
;	called by Z-DOS. The interrupt routine retrieves the dword pointer
;	saved by the strategy routine. This pointer is the address of a
;	"request packet" that contains the information needed to carry
;	out the i/o request, such as transfer address, byte count, etc.

;	The strategy routine

MD_STRAT PROC	FAR
	MOV	WORD PTR CS:PTRSAV,BX
	MOV	WORD PTR CS:PTRSAV+2,ES		; Save ES:BX as dword
	RET
MD_STRAT ENDP

;	Now the interrupt routine.

MD_INTR	PROC	FAR

;	Save everything

	PUSH	AX

	CLI
	MOV	CS:SAVESS,SS
	MOV	CS:SAVESP,SP
	MOV	AX,CS
	MOV	SS,AX
	MOV	SP,OFFSET MYSTACK
	STI

	PUSH	BX
	PUSH	CX
	PUSH	ES
	PUSH	SI
	PUSH	DI

	LES	BX,CS:PTRSAV			; ES:BX = request packet
	MOV	SI,OFFSET MD_CTAB		; Command table
	MOV	CL,ES:SRH_CMD[BX]		; CL = requested command
	XOR	CH,CH
	SHL	CX,1				; Make into word offset
	ADD	SI,CX				; SI = pointer to routine
	JMP	WORD PTR CS:[SI]		; Go to it

;	The routines exit through MD_SUCC if no error, or MD_ERROR if
;	an error has occured

MD_SUCC:
	MOV	AH,SRHS_DON			; Show 'DONE'
	XOR	AL,AL				;  Error code 0
	JMP	SHORT MD_EXIT

MD_ERROR:
	MOV	AH,SRHS_ERR			; Add the error bits
;	JMP	SHORT MD_EXIT			; Error code in AL

;	Now exit from the request

MD_EXIT:
	LES	BX,CS:PTRSAV			; ES:BX = packet
	MOV	ES:SRH_STAT[BX],AX		; Save the status
	POP	DI
	POP	SI
	POP	ES
	POP	CX
	POP	BX
	CLI
	MOV	SS,CS:SAVESS
	MOV	SP,CS:SAVESP
	STI
	POP	AX
	RET

MD_INTR	ENDP

;	This is the dispatch table

MD_CTAB	LABEL	NEAR
	ERRNZ	MD_CTAB,(2*SRHC_INIT)
	DW	MD_INIT			; Initialize
	ERRNZ	MD_CTAB,(2*SRHC_MCHK)
	DW	MD_MCHK			; Media check
	ERRNZ	MD_CTAB,(2*SRHC_BPB)
	DW	MD_BPB			; Build BPB
	ERRNZ	MD_CTAB,(2*SRHC_ICTL)
	DW	MD_RES3			; Reserved?
	ERRNZ	MD_CTAB,(2*SRHC_IN)
	DW	MD_IN			; Input
	ERRNZ	MD_CTAB,(2*SRHC_ICHK)
	DW	MD_ICHK			; Input check (buffer status)
	ERRNZ	MD_CTAB,(2*SRHC_ISTAT)
	DW	MD_ISTAT		; Input status
	ERRNZ	MD_CTAB,(2*SRHC_IFL)
	DW	MD_IFL			; Input flush
	ERRNZ	MD_CTAB,(2*SRHC_OUT)
	DW	MD_OUT			; Output
	ERRNZ	MD_CTAB,(2*SRHC_OUTV)
	DW	MD_OUTV			; Output with verify
	ERRNZ	MD_CTAB,(2*SRHC_OSTAT)
	DW	MD_OSTAT		; Output status
	ERRNZ	MD_CTAB,(2*SRHC_OFL)
	DW	MD_OFL			; Output buffer flush
	ERRNZ	MD_CTAB,(2*SRHC_OCTL)
	DW	MD_RES3			; Output control string
	ERRNZ	MD_CTAB,(2*(1+SRHC_MAX))

;	Now for each of the routines

;*	MD_INIT - Initialize device
;
;	Return DS:DX = dword pointer to end of driver, after
;	allocating any buffer space. The next drive will be
;	installed starting at this location (Much like the
;	DS:DX usage of a terminate/stay resident system call
;

MD_INIT	PROC	NEAR

;	Allocate space for the MDISK

	MOV	AX,CS
	MOV	DX,OFFSET MD_END
	MOV	CX,4
	SHR	DX,CL
	ADD	AX,DX
	INC	AX			; AX = our segment
	MOV	CS:MDISK_START,AX
	ADD	AX,MDISK_SIZE		; Size in 16 byte blocks
	XOR	DX,DX
	MOV	ES:WORD PTR CIN_UNITS[BX],1	; One unit
	MOV	ES:WORD PTR CIN_KADDR[BX],DX	; Break address
	MOV	ES:WORD PTR CIN_KADDR[BX+2],AX	;  dword
	MOV	ES:WORD PTR CIN_BADDR[BX],OFFSET MDISK_BPBVEC
	MOV	ES:WORD PTR CIN_BADDR[BX+2],CS

;	Now initialize the MDISK area

	PUSH	ES
	MOV	AX,CS:MDISK_START
	MOV	ES,AX
	MOV	CX,32*1024/2
	MOV	AX,0E5E5H
	XOR	DI,DI
	REP	STOSW			; Clear all to E5's for 32k

	MOV	CX,12*512/2
	XOR	DI,DI
	XOR	AX,AX
	REP	STOSW			; Clear FAT to zeros
	MOV	BYTE PTR ES:[0],0FFH	; Media byte
	MOV	WORD PTR ES:[1],0FF7H
	POP	ES
	LDS	DX,ES:DWORD PTR CIN_KADDR[BX]
	JMP	MD_SUCC			; Successful exit
MD_INIT	ENDP

;*	MD_MCHK - Media check
;
;	This call is used only by the block device drivers
;	so we simply return
;

MD_MCHK	PROC	NEAR
	MOV	ES:CMC_STAT[BX],CMCS_NOC	; Show no change
	CLC
	JMP	MD_SUCC			; Do nothing
MD_MCHK	ENDP

;*	MD_BPB - Build BPB
;
;	This is another one of the block device driver calls.
;	Again, simply return with no error
;

MD_BPB	PROC	NEAR
	MOV	ES:WORD PTR CBPB_BADDR[BX],OFFSET MDISK_BPB
	MOV	ES:WORD PTR CBPB_BADDR[BX+2],CS
	JMP	MD_SUCC
MD_BPB	ENDP

;*	MD_RES3 - Reserved entry point
;
;	This one is reserved, so we exit indicating an
;	error condition.
;

MD_RES3	PROC	NEAR
	MOV	AL,SRHS_EUKC		; Unknown command given
	JMP	MD_ERROR
MD_RES3	ENDP

;*	MD_IN - Character Input
;
;	MD_IN reads the number of characters requested into the
;	address given in the request packet.
;

MD_IN	PROC	NEAR
	MOV	CS:BYTE PTR TFLAG,0	; Flag a read
	JMP	NEAR PTR MD_IO
MD_IN	ENDP

;*	MD_ICHK - Non-destructive input check
;
;	MD_ICHK returns the status of the input queue. A
;	return of BUSY indicates queue empty, otherwise
;	return character at front of queue (without removing
;	it).
;

MD_ICHK	PROC	NEAR
	MOV	ES:CIC_CHAR[BX],01AH	; Show next is EOF
	JMP	MD_SUCC
MD_ICHK	ENDP

;*	MD_ISTAT - Input Status
;
;	MD_ISTAT Sets the busy bit if there is a character
;	ready to be read. If BUSY is set, the I/O will have
;	to go to the physical device. If BUSY is clear, the
;	read will return quickly.
;

MD_ISTAT PROC	NEAR
	JMP	MD_SUCC			; Show always ready
MD_ISTAT ENDP

;*	MD_IFL - Input Queue Flush
;
;	Flush the input queue
;

MD_IFL	PROC	NEAR
	JMP	MD_SUCC			; Consider it done!
MD_IFL	ENDP

;*	MD_OUT - Device Output
;
;	MD_OUT sends the output to the device
;

MD_OUT	PROC	NEAR
	MOV	CS:BYTE PTR TFLAG,1	; Show output
	JMP	NEAR PTR MD_IO
MD_OUT	ENDP

;*	MD_OUTV - Device Output with Verify
;
;	MD_OUTV verifies the output it sent
;

MD_OUTV	PROC	NEAR
	JMP	MD_OUT			; It verifies ok?
MD_OUTV	ENDP

;*	MD_OSTAT - Output Status
;
;	MD_OSTAT returns the status of the device. If BUSY
;	is a 1, output will have to wait for device ready. If
;	BUSY is a 0, output will go directly to device with
;	no waiting.
;

MD_OSTAT PROC	NEAR
	JMP	MD_SUCC			; Output device is ready
MD_OSTAT ENDP

;*	MD_OFL - Output buffer flush
;
;	MD_OFL Flushes the output buffer
;

MD_OFL	PROC	NEAR
	JMP	MD_SUCC			; Consider it done!
MD_OFL	ENDP

;*	MD_IO - Major I/O routine
;
;	This is the I/O routine
;

MD_IO	PROC	NEAR
	PUSH	DS
	PUSH	DX
	LDS	SI,ES:CRW_TADDR[BX]	; DS:SI = trans address
	MOV	DX,ES:CRW_CNT[BX]		; dX = count
	MOV	BX,ES:CRW_START[BX]		; BX = sector number
	MOV	CX,5			; BX << 9 >> 4
	SHL	BX,CL
	XOR	DI,DI			; Compute starting address
	MOV	AX,CS:MDISK_START	; AX = start segment
	ADD	AX,BX
	MOV	ES,AX
	PUSH	SI
	MOV	CX,4
	SHR	SI,CL
	MOV	AX,DS
	ADD	AX,SI			; Compute new base address
	MOV	DS,AX
	POP	SI
	AND	SI,000FH

;	DS:SI = transfer address, ES:DI = MDISK address, DX = count

	MOV	CS:WORD PTR SECCNT,DX	; Set in count

;	Transfer sector between DS:SI and ES:DI

MD_IO3:
	MOV	CX,CS:WORD PTR SECCNT
	JCXZ	MD_IO9			; If count extinguished
	CMP	CX,128
	JL	MD_IO3X
	MOV	CX,127			; Max count / transfer
MD_IO3X:
	PUSH	ES
	PUSH	DS
	PUSH	SI
	PUSH	DI
	TEST	CS:BYTE PTR TFLAG,0FFH
	JZ	MD_IO4

;	Is a write request, from DS:SI to ES:DI

MD_IO3A:
	PUSH	CX
	MOV	BX,CX
	MOV	CX,8
	SHL	BX,CL
	MOV	CX,BX
	REP	MOVSW			; Move it in
	POP	CX
	JMP	MD_IO5

MD_IO4:
	PUSH	ES
	PUSH	DS
	POP	ES
	POP	DS			; Swap DS, ES
	XCHG	SI,DI
	JMP	MD_IO3A			; Reverse and transfer

MD_IO5:
	POP	DI
	POP	SI
	POP	DS
	POP	ES
	PUSH	CX
	MOV	BX,CX
	MOV	CL,5			; Left 9 and right 4
	SHL	BX,CL
	POP	CX
	MOV	AX,DS
	ADD	AX,BX		; Next transfer and sector
	MOV	DS,AX
	MOV	AX,ES
	ADD	AX,BX		;   values
	MOV	ES,AX
	SUB	CS:WORD PTR SECCNT,CX
	JMP	MD_IO3			; Do next

;	End of transfer

MD_IO9:
	POP	DX
	POP	DS
	JMP	MD_SUCC
MD_IO	ENDP

;*	DATA areas

MDISK_START	DW	0		; Start segment of MDISK
PTRSAV	DD	0			; Request packet address
SAVESS	DW	?			; Old stack save
SAVESP	DW	?
TFLAG	DB	0			; 0 = read, 1 = write

SECCNT	DW	?

	DW	128 DUP (?)
MYSTACK	LABEL	NEAR

;	End of resident code/data

MD_END	LABEL	NEAR

CODE	ENDS
	END	MDISK			; End of program

