*	SEARCH - MEMORY SEARCH FOR DDT
*
*	THIS PROGRAM PROVIDES A MEMORY SEARCH
*	COMMAND TO AID IN PROGRAM DEBUGGING WITH
*	DIGITAL RESEARCH'S DDT.
*
*	IT USES THE LONGREL MACRO LIBRARY TO
*	MAKE IT A COMPLETELY POSITION INDEPENDENT
*	PROGRAM.
*
*	BY P. SWAYNE, HUG 28-SEP-83

	MACLIB	LONGREL		;INCLUDE RELATIVE MACROS

*	CP/M DEFINITIONS

BDOS	EQU	5		;BDOS VECTOR
CONOUT	EQU	2		;CONSOLE OUTPUT
PRINT	EQU	9		;PRINT FUNCTION
RCBUF	EQU	10		;READ CONSOLE BUFFER

	ORG	100H		;START HERE, FOR NOW!

START:	PUSH H!PUSH D!PUSH B!PUSH PSW	;SAVE ALL REGISTERS
	LXI	H,0E9E3H	;GET "XTHL, PCHL"
	SHLD	60Q		;SET RST 6 VECTOR
	LXI	H,0
	DAD	SP		;LOCATE USER STACK
	SRPR	USRSTAK,H	;SAVE IT
MLOOP:	LRI	H,STACK
	SPHL			;SET LOCAL STACK
	LRI	D,PROMPT
	MVI	C,PRINT
	CALL	BDOS		;PRINT PROMPT CHARACTER
	LRI	D,INBUF
	PUSH	D		;SAVE BUFFER ADDRESS
	MVI	C,RCBUF
	CALL	BDOS		;GET USER'S INPUT
	POP	H		;HL = BUFFER
	INX	H		;POINT TO COUNT
	MOV	A,M		;GET IT
	ORA	A		;NULL ENTRY?
	JRLC	MLOOP,RZ	;IF SO, TRY AGAIN
	MOV	E,A		;ELSE, PUT COUNT IN E
	MVI	D,0		;DE = COUNT
	INX	H		;POINT TO COMMAND
	PUSH	H		;SAVE THIS ADDRESS
	DAD	D		;MOVE TO END
	MVI	M,13		;TERMINATE COMMAND
	POP	D		;GET COMMAND START
	LDAX	D		;GET FIRST COMMAND LETTER
	CPI	'.'		;PERIOD?
	JRLC	EXIT,RZ		;IF SO, EXIT
	CRL	RDNUM		;READ NUMBERS ENTERED
	JRLC	MLOOP,RC	;BAD ENTRY
	POP	PSW		;GET DELIMITER
	POP	B		;GET SEARCH NUMBER
	POP	D		;GET END
	POP	H		;GET START
	CPI	'W'		;WORD SEARCH?
	JRLC	SLOOP1,RNZ	;NO, BYTE SEARCH

*	WORD SEARCH LOOP

SLOOP:	MOV	A,M		;GET A CHARACTER
	CMP	C		;TEST
	INX	H		;MOV TO NEXT CHAR
	JRLC	NEXT,RNZ	;NO MATCH
	MOV	A,M
	CMP	B		;TEST HIGH BYTE
NEXT:	DCX	H		;BACK UP TO WORD START
	CRLC	FOUND,RZ	;FOUND MATCH
	INX	H		;SKIP TO NEXT POSITION
	CRL	CPHD		;TEST FOR END
	JRLC	SLOOP,RNC	;LOOP UNTIL END
	JRL	MLOOP		;GET NEXT INPUT

*	BYTE SEARCH LOOP

SLOOP1:	MOV	A,M		;GET A CHARACTER
	CMP	C		;TEST
	CRLC	FOUND,RZ	;PRINT ADDRESS IF MATCH
	INX	H		;SKIP TO NEXT BYTE
	CRL	CPHD		;TEST FOR END
	JRLC	SLOOP1,RNC	;LOOP UNTIL END
	JRL	MLOOP		;ELSE, GET NEXT INPUT

*	FOUND MATCH, PRINT ADDRESS

FOUND:	PUSH	H		;SAVE REGISTERS
	PUSH	D
	PUSH	B
	MVI	E,13
	MVI	C,CONOUT
	CALL	BDOS		;PRINT CR
	MVI	E,10
	MVI	C,CONOUT
	CALL	BDOS		;PRINT LF
	POP	B		;RESTORE REGISTERS
	POP	D
	POP	H
	MOV	A,H		;GET HIGH BYTE
	CRL	PBYTE		;PRINT IT
	MOV	A,L		;GET LOW BYTE
PBYTE:	PUSH	PSW		;SAVE BYTE
	RLC			;MOVE HIGH NIBBLE DOWN
	RLC
	RLC
	RLC
	ANI	0FH		;ISOLATE IT
	CRL	PNIB		;PRINT IT
	POP	PSW		;GET BYTE
	ANI	0FH		;ISOLATE LOW NIBBLE
PNIB:	ADI	90H		;"A" OR GREATER SETS CARRY
	DAA
	ACI	40H		;ADJUST
	DAA
	PUSH	B		;SAVE REGISTERS
	PUSH	D
	PUSH	H
	MOV	E,A		;CHARACTER TO E
	MVI	C,CONOUT
	CALL	BDOS		;PRINT CHARACTER
	POP	H		;RESTORE REGISTERS
	POP	D
	POP	B
	RET

*	COMPARE HL TO DE, SET CARRY IF HL > DE

CPHD:	MOV	A,H
	ORA	L
	STC
	RZ			;DON'T ALLOW WRAP-AROUND
	MOV	A,E
	SUB	L		;SUBTRACT
	MOV	A,D
	SBB	H		;SUBTRACTION DETERMINES
	RET			; RESULT

*	EVALUATE INPUT NUMBERS

RDNUM:	MVI	C,3		;GET THREE NUMBERS
RDNUMA:	LXI	H,0		;CLEAR HL
RDNUM0:	LDAX	D		;GET A CHARACTER
	INX	D
RDNUM1:	MOV	B,A		;SAVE IT
	CRL	BIN		;CONVERT TO BINARY
	JRLC	RDNUM2,RC	;NOT A NUMBER
	DAD	H		;MOVE LAST ENTRY
	DAD	H		;OVER 4 PLACES
	DAD	H
	DAD	H
	ORA	L
	MOV	L,A		;ADD LATEST ENTRY
	JRL	RDNUM0		;GET ANOTHER ENTRY
RDNUM2:	XTHL			;SWAP RETURN ADDR, HL
	PUSH	H		;REPLACE RETURN ADDR
	MOV	A,B		;GET LAST ENTRY
	CPI	','		;COMMA?
	JRLC	RDNUM3,RZ	;YES
RDNUMX:	MOV	A,B		;ELSE, GET DELIMITER
	POP	H		;GET RETURN ADDRESS
	PUSH	PSW		;PUT DELIMITER ON STACK
	PUSH	H		;RESTORE RETURN ADDRESS
	ORA	A		;CLEAR CARRY
	DCR	C		;ENOUGH NUMBERS?
	RZ			;YES, RETURN OK
	STC			;ELSE, MARK ERROR
	RET			;AND RETURN
RDNUM3:	DCR	C		;COUNT THIS NUMBER
	JRLC	RDNUMA,RNZ	;LOOP IF NOT LAST
	INR	C		;FIX C
	JRL	RDNUMX		;ELSE, EXIT

*	CONVERT BINARY TO ASCII

BIN:	SUI	'0'
	RC			;LESS THAN "0"
	ADI	'0'-'G'
	RC			;GREATER THAN "F"
	ADI	6		;PROCESS "A" - "F"
	JRLC	BIN0,RP
	ADI	7
	RC			;":" THROUGH "@"
BIN0:	ADI	10		;ADJUST
	ORA	A		;CLEAR CARRY
	RET

*	EXIT TO DDT

EXIT:	LRPR	H,USRSTAK	;GET USER'S STACK
	SPHL			;SET IT
	POP PSW!POP B!POP D!POP H	;RESTORE REGISTERS
	RST	7		;RETURN TO DDT

*	DATA AREA

PROMPT	DB	13,10,'S:$'
USRSTAK	DW	0
INBUF	DB	20,0
	DS	20+32
STACK	DB	0

	END	START
T	7		;RETURN TO DDT

*	DATA AREA

PROMPT	DB	13,10,'S:$'
USRSTAK	DW	0
INBUF	DB	20,0
	DS	20+32
STACK	DB	0

	END