;	Copyright(C) 1985, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	     This computer software and documentation 
;	are provided with RESTRICTED RIGHTS.  Use,
;	duplication or disclosure by the Government is
;	subject to restrictions as set forth in the
;	governing Rights in Technical Data and Computer
;	Software clause -- subdivision (b)(3)(B) of DAR
;	7-104.9(a) (May 1981) or subdivision (b)(3)(ii)
;	of DOD FAR Supp 252.227-7013 (May 1981).
;
;
;***	DEFZ204 - Define Z-204 Multiport I/O Board
;
;	DEFZ204 defines the port assignments and interrupt
;	addressing for the Z-204 Multiport I/O Board
;

Z204BASE	=	060H			; Base port address for Z204

;	Base addresses for the individual I/O chips

Z204EP2A	=	Z204BASE+0		; 2661 chip #1
Z204EP2B	=	Z204BASE+4		; 2661 chip #2
Z204BRCA	=	Z204BASE+8		; Baud rate for 8274 #1
Z204BRCB	=	Z204BASE+12		; Baud rate for 8274 #2
Z204INTA	=	Z204BASE+16		; 8259a interrupt acknowledge
Z204PIC		=	Z204BASE+20		; 8259a control port
Z204PPI		=	Z204BASE+24		; Parallel port #1 and #2
Z204MPSC	=	Z204BASE+28		; 8274 ports #1 and #2

;	Interrupt values from Z204INTA port

ZEA_RX		=	0			; EPCI #1 Rx ready
ZEB_RX		=	1			; EPCI #2 Rx ready
ZEA_TX		=	2			; EPCI #1 Tx ready
ZEB_TX		=	3			; EPCI #2 Tx ready
ZPPI_RX		=	4			; Parallel Rx ready
ZPPI_TX		=	5			; Parallel Tx ready
ZMPSC_RTX	=	6			; 8274 general interrupt

;	Interrupt values from the 8274 for ZMPSC_RTX

ZMPSC_BTX	=	0			; Channel B Tx ready
ZMPSC_BES	=	1			; EXT/Status change on B
ZMPSC_BRX	=	2			; Channel B Rx ready
ZMPSC_BSC	=	3			; Channel B special condition
ZMPSC_ATX	=	4			; Channel A Tx ready
ZMPSC_AES	=	5			; EXT/Status change on A
ZMPSC_ARX	=	6			; Channel A Rx ready
ZMPSC_ASC	=	7			; Channel A special condition

;	8259a Generates interrupts on this vector
;
;	NOTE: The interrupted device is identified by trapping the
;	following interrupt. The interrupt routine should poll the
;	8259a at Z204_PIC register OCW3 to determine which of the
;	devices listed above generated the interrupt. If the result
;	is a ZMPSC_RTX then the 8274 should be polled with to determine
;	which of the specific 8274 interrupts has occured. A non-specific
;	EOI should be issued to the 8259 at the end of the interrupt
;	routine at port Z204_PIC register OCW2

Z204_INTVEC	=	048H			; Interrupt vector location
