; DPATH - data path
; (C) Copyright Gordon Buchanan, 1985

	
	page	60,132



	include	struct.asm

	

all	segment
	assume	cs:all, ds:all, es:all, ss:all
		
		
		
overc	equ	"'"			;drive override character



	org	005ch			;put data in fcb
	
dosvec	dd	?			;dos int vector

axsave	dw	?
bxsave	dw	?
dxsave	dw	?
dssave	dw	?
essave	dw	?
sssave	dw	?
spsave	dw	?
	
flagret	dw	?
axret	dw	?

temp	dw	?
debugf	db	?			;debug flag
onflag	db	?			;on/off flag

	org	0080h
cmdline	db	128 dup (?)
stack:



	org	0100h
dpath:
	jmp	init			;skip to init routine

	

	db	13,10
inimsg:
marker	db	'DPATH '
markerl	equ	$-marker
vers	db	'1.40'
versl	equ	$-vers
	db	'  (C) Copyright Gordon Buchanan, 1985',13,10
inimsgl	equ	$-inimsg
	db	26

dpvec	db	0a8h			;dpath address vector
delayc	dw	1500h			;debug delay count

starts	db	16 dup (0)		;debug start string
	org	starts
	db	10			;length
	db	27,'j'			;save cursor position
	db	27,'Y  '		;HOME cursor
	db	27,'K'			;clear line
	db	27,'p'			;inverse video
	org	starts+16

mids	db	16 dup (0)		;debug middle string
	org	mids
	db	4			;length
	db	13,10			;next line
	db	27,'K'			;clear line
	org	mids+16

ends	db	16 dup (0)		;debug end string
	org	ends
	db	4			;length
	db	27,'q'			;normal video
	db	27,'k'			;restore cursor position
	org	ends+16

usrdrv	db	?			;drive on search file
defdrv	db	?			;default drive
curdir	db	'\',64 dup (?)		;current directory
altdir	db	128 dup (?)		;search directory list



dosaisr:				;alternate entry point (call 5)
	pop	ax
	pop	ax
	pop	cs: temp
	pushf
	cli
	push	ax
	push	cs: temp
	mov	ah,cl

	if@	cl,a,24h
	    mov	al,0
	    iret
	endif@
	
dosisr:
	if@	<cs: onflag>,ne,0
	    cmp	ah,0fh			;fcb open command?
	    je	dosi0
	    
	    cmp	ah,3dh			;file handle open?
	    je	dosi0
	    
	    cmp	ah,23h			;get file size?
	    je	dosi0
	    
	    if@ ah,eq,11h		;search for first fcb?
		call iswildfcb		;only if no wildcard characters
		jnz dosi0
	    
	    elseif@ ah,eq,4eh		;search for first
		call iswild		;only if no wildcard characters
		jnz dosi0

	    elseif@ ah,eq,4bh		;load and execute
		cmp al,3		;load subfunction
		je dosi0
	    
	    endif@
	    endif@
	    endif@
	    
	endif@
	
	jmp	cs: dosvec		;let dos do it

dosi0:	
	sti				;enable interrupts
	mov	cs: dssave,ds		;save ds
	
	push	cs			;setup our ds
	pop	ds

	mov	sssave,ss		;save stack
	mov	spsave,sp
	
	push	cs			;setup our stack
	pop	ss
	mov	sp,offset stack

	push	cx
	push	dx
	push	si
	push	di
	
	mov	axsave,ax		;save regs
	mov	bxsave,bx
	mov	dxsave,dx
	mov	essave,es

	mov ah,19h			;get default drive
	int 21h
	mov defdrv,al

	call getdrv			;get drive from user command

; The following code performs an intitial search on
; the default drive in the current directory.
; If this search is not desired, then comment it out.
	
	mov ah,0eh			;switch to user drive
	mov dl,usrdrv
	int 21h
	
	if@ debugf,ne,0
	    call debug			;do debug print
	    call showcd
	endif@
	
	call	tryfunct		;try and open the file
	if@ nc
	    jmp exit			;skip if no error
	endif@

; End of initial search code.

	mov ah,47h			;get current directory
	mov si,offset curdir+1
	mov dl,0
	int 21h
	    
	mov bx,offset altdir		;point at search directory list

	while <byte ptr [bx]>,ne,0
	    mov al,usrdrv			;get drive from user command
	    mov dl,[bx+1]			;get select drive

	    if@ dl,ae,80h			;if drive override
		and dl,7fh
		mov al,dl
	    else@
		if@ al,eq,07fh			;if default user drive
		    mov al,dl			;user drive <- select drive
		endif@
		
		if@ dl,eq,07fh			;if default select drive
		    mov dl,al			;select drive <- user drive
		endif@
	    endif@
	    
	    if@ al,eq,dl			;do only if user = select
		if@ dl,eq,07fh			;if default then use default
		    mov dl,defdrv
		endif@

		mov ah,0eh			;select drive
		int 21h

		mov ah,47h			;get current directory
		mov si,offset curdir+1
		mov dl,0
		int 21h
		
		if@ <byte ptr [bx+2]>,ne,0	;directory entry not null
		    mov ah,3bh			;set directory to next entry
		    lea dx,[bx+2]
		    int 21h
		else@
		    clc
		endif@
	    
		if@ c				;no directory found
		    if@ debugf,ne,0
			call debug
			call showtry
		    endif@
		
		else@				;directory changed ok
		    if@ debugf,ne,0
			call debug
			call showcd
		    endif@
		    
		    call tryfunct		;try and open the file there
		    jnc loopex			;skip if no error
		
		    mov ah,3bh			;restore directory
		    mov dx,offset curdir
		    int 21h
		endif@
	    endif@
	
	    mov al,[bx]			;get entry length
	    xor ah,ah
	    add	bx,ax			;point at next directory entry
	endw
	    
loopex:
	mov ah,3bh			;back to staring directory
	mov dx,offset curdir
	int 21h
	    
exit:
	mov ah,0eh			;back to starting disk
	mov dl,defdrv
	int 21h
	
	call restdrv			;restore drive in user FCB

	pop 	di
	pop 	si
	pop	dx
	pop	cx

	mov	ss,sssave		;restore stack
	mov	sp,spsave
	
	pop	ax			;return ip
	pop	bx			;return cs
	pop	es			;return flags
	push	flagret			;insert function return flags
	push	bx			;restore cs
	push	ax			;restore ip
	
	mov	ax,axret		;return ax value
	
	mov	bx,bxsave		;restore regs
	mov	es,essave
	mov	ds,dssave
	iret



iswildfcb:
	push ax
	push cx
	push di
	push es
	
	mov ax,ds
	mov es,ax
	mov di,dx
	
	if@ <es: byte ptr [di]>,eq,0ffh		;extended fcb
	    add di,7				;move past extension
	endif@
	
	inc di					;skip drive
	mov cx,11				;# bytes in file name
	mov al,'?'				;looking for wild card chars
	repne scasb
	
	pop es
	pop di
	pop cx
	pop ax
	ret



iswild:
	push ax
	push si
	
	mov si,dx
	
	repeat
	    lodsb			;get a byte from file name
	    
	    cmp al,'?'			;return z if '?'
	    je iwex
	
	    cmp al,'*'			;return z if '*'
	    je iwex
	until al,eq,0			;loop until end of name
	
	inc al				;return nz
	
iwex:
	pop si
	pop ax
	ret



getdrv:
	mov di,dxsave				;get file offset
	mov es,dssave				;get file segment
	
	if@ <byte ptr axsave+1>,be,24h		;non xenix call
	    if@ <es: byte ptr [di]>,eq,0ffh	;extended FCB
		add di,7			;move past extension
	    endif@
	    
	    mov al,es: [di]			;get drive number
	    mov byte ptr es: [di],0		;set drive number to default
	
	else@					;xenix type call
	    if@ <es: byte ptr [di+1]>,eq,':'	;if drive designator
		mov al,es: [di]			;get drive letter
		call tupper
		sub al,'A'-1			;convert to number
		add di,2			;skip drive designator
		mov dxsave,di
	    else@				;no drive designator
		xor al,al			;indicate default drive
	    endif@
	endif@
		
	dec al					;7F=default, 0=A, 1=B ...
	and al,7fh
	mov usrdrv,al				;save drive value
	ret



restdrv:
	mov di,dxsave				;get file offset
	mov es,dssave				;get file segment
	
	if@ <byte ptr axsave+1>,be,24h		;non xenix call
	    if@ <es: byte ptr [di]>,eq,0ffh	;extended FCB
		add di,7			;move past extension
	    endif@
	    
	    mov al,usrdrv			;get user drive
	    inc al				;0=default, 1=A, 2=B ...
	    and al,7fh
	    
	    stosb				;put back original drive
	endif@
	ret



drvmsg	db	'__'
drvmsgl equ	$-drvmsg

drvprt:
	if@ al,ae,80h				;if override
	    mov byte ptr drvmsg+1,overc
	    and al,7fh
	    if@ al,eq,7fh			;if default
		mov al,'@'-'A'			;print drive as @
	    endif@
	else@
	    mov byte ptr drvmsg+1,':'
	endif@
	
	if@ al,ne,07fh
	    add al,'A'
	    mov drvmsg,al
	    mov dx,offset drvmsg
	    mov cx,drvmsgl
	    call prtmsg
	endif@
	ret


	
pathprt:				;es:dx points at ASCIIZ path name	
	mov cx,0ffffh			;start count
	mov di,dx
	xor al,al			;search for 0
	repne scasb
	not cx				;calc length

	mov ax,es			;set ds = es
	mov ds,ax
	call prtmsg			;print the path name
	mov ax,cs			;restore ds
	mov ds,ax
	ret



showm	db	'     - '
showml	equ	$-showm
scdd	db	'\',64 dup (?)

showcd:
	mov dx,offset mids+1		;print separater
	mov cl,mids
	xor ch,ch
	call prtmsg
	
	mov dx,offset showm		;print start message
	mov cx,showml
	call prtmsg
	
	mov ah,19h			;get current drive
	int 21h
	call drvprt			;display it
	
	mov ah,47h			;get current directory
	mov si,offset scdd+1
	mov dl,0
	int 21h
	
	mov dx,offset scdd		;print the cd
	mov ax,ds
	mov es,ax
	call pathprt

	mov dx,offset ends+1		;print exit message
	mov cl,ends
	xor ch,ch
	call prtmsg
	
	call delay			;do a short wait
	ret
	


trym	db	'no directory '
tryml	equ	$-trym

showtry:
	mov dx,offset mids+1		;print separater
	mov cl,mids
	xor ch,ch
	call prtmsg
	
	mov dx,offset showm		;print start message
	mov cx,showml
	call prtmsg
	
	mov dx,offset trym		;print can't find message
	mov cx,tryml
	call prtmsg
	
	mov ah,19h			;get current drive
	int 21h
	call drvprt			;display it

	lea dx,[bx+2]			;address of directory
	mov ax,ds
	mov es,ax
	call pathprt			;display it

	mov dx,offset ends+1		;print exit message
	mov cl,ends
	xor ch,ch
	call prtmsg
	
	call delay			;do a short wait
	ret
	


debugm	db	'['
debugmc	dw	?
	db	'] - '
debugml equ	$-debugm
debugmf	db	15 dup (?)
	
debug:
	mov	dx,offset starts+1	;print start message
	mov	cl,starts
	xor	ch,ch
	call	prtmsg
	
	mov	al,byte ptr axsave+1	;funtion code
	call	htoa			;convert to ascii
	xchg	al,ah			;MSB first
	mov	debugmc,ax		;put in debug message
	mov	dx,offset debugm	;print message
	mov	cx,debugml
	call	prtmsg

	if@ <byte ptr axsave+1>,be,24h	;fcb call
	    mov si,dxsave		;fcb offset
	    mov di,offset debugmf	;print file name offset
	    mov dx,di			;save offset
	    mov ds,dssave		;fcb segment
	    mov ax,cs
	    mov es,ax			;print file segment
	    
	    if@ <byte ptr [si]>,eq,0ffh	;extended fcb
		add si,7		;point past extension
	    endif@

	    lodsb			;get drive number
	    if@ al,ne,0
		add al,'A'-1		;convert to letter
		stosb			;put in output string
		mov al,':'		;put ':' in output string
		stosb
	    endif@
	    
	    mov	cx,8			;move file name
	    rep movsb
	    mov al,'.'			;insert period
	    stosb
	    mov	cx,3			;move extension
	    rep movsb
	    xor al,al			;mark end of string
	    stosb
	
	    mov ax,cs			;restore ds
	    mov ds,ax
	    
	else@
	    mov es,dssave
	    mov dx,dxsave
	endif@
	
	call	pathprt			;print the file name
	ret



delay:
	mov	ax,delayc		;do a short delay
	repeat
	    mov	cx,40h
	    repeat
		dec	cx
	    until z
	    dec	ax
	until z
	ret



tupper:
	if@ al,ae,'a'
	    if@ al,be,'z'
		sub al,'a'-'A'
	    endif@
	endif@
	ret



htoa:
	mov	ah,al
	shr	al,1
	shr	al,1
	shr	al,1
	shr	al,1
	call	htoan
	xchg	al,ah
	
htoan:
	and	al,0fh
	add	al,90h
	daa
	adc	al,40h
	daa
	ret
	


prtmsg:
	push	bx
	mov	ah,40h			;print message
	mov	bx,2			;write to std error
	int	21h
	pop	bx
	ret



tryfunct:
	push	bx
	push	ds
	
	mov	ax,axsave
	mov	bx,bxsave
	mov	dx,dxsave
	mov	es,essave
	mov	ds,dssave

	pushf				;do call to dos (fake int 21h)
	cli
	call	cs: dosvec
	
	pop	ds
	pop	bx
	
	pushf				;save returned flags and ax value
	pop	flagret
	mov	axret,ax

	mov	ah,byte ptr axsave+1	;get funtion code

	if@ ah,be,24h			;not xenix operation
	    if@ al,eq,0ffh
		stc			;error
	    else@
		clc			;no error
	    endif@
	
	else@				;xenix operation
	    test byte ptr flagret,00000001b	;test carry in return flags
	    if@ z
		clc			;don't try again
	    else@
		if@ ah,eq,4eh		;find first function
		    if@ al,eq,18	;no more files error
			stc		;try again
		    else@		;other error
			clc		;don't try again
		    endif@
		
		else@			;other xenix calls
		    if@ al,eq,2		;file not found error
			stc		;try again
		    else@		;other error
			clc		;don't try again
		    endif@
		endif@
	    endif@
	endif@
	ret
	
endres:



wvmsg	db	'!!! This version of DPATH is not the same as the '
	db	'one currently in memory !!!',13,10
wvmsgl	equ	$-wvmsg
	


init:
	mov	ah,35h			;get dpath address vector
	mov	al,dpvec
	int	21h

	mov	si,offset marker	;offset of marker in ds and es
	mov	di,si
	mov	cx,markerl		;marker length
	repe cmpsb			;compare data to our marker
	jcxz	noinstall		;skip if dpath already resident

	mov	ah,35h			;get msdos interrupt vector
	mov	al,21h
	int	21h

	mov	word ptr dosvec,bx	;save vector
	mov	word ptr dosvec+2,es

	mov	debugf,0		;debug off
	mov	onflag,1		;dpath on
	mov	altdir,0		;no path
	    
	mov dx,offset inimsg		;print init message
	mov cx,inimsgl
	call prtmsg

	mov	ax,ds			;path and flags in ds
	mov	es,ax
	call	pcline			;process command line
	call	status			;show path and flags
	
	mov	ah,25h			;install our address vector
	mov	al,dpvec
	mov	dx,offset dosisr
	int	21h

	mov	ah,25h			;install our msdos interrupt vector
	mov	al,21h
	mov	dx,offset dosisr
	int	21h

	xor	ax,ax			;take over dos aux entry
	mov	es,ax
	mov	es: word ptr 0c1h,offset dosaisr
	mov	es: word ptr 0c3h,cs

	mov	ah,31h			;exit and remain resident
	xor	al,al
	mov	dx,offset endres	;last needed address
	shr	dx,1			;calc number of paragraphs (addr/16)
	shr	dx,1
	shr	dx,1
	shr	dx,1
	inc	dx			;+1 for fractions
	int	21h			;exit and remain resident
	
noinstall:				;es has dpath segment
	mov si,offset vers		;check version number
	mov di,si
	mov cx,versl
	repe cmpsb
	
	if@ cxz				;correct version
	    call pcline			;process command line
	    call status			;display path and flags
	    
	else@				;wrong version
	    mov dx,offset wvmsg		;print wrong version message
	    mov cx,wvmsgl
	    call prtmsg
	endif@    
	
	mov ah,4ch			;exit
	xor al,al
	int 21h



pcline:
	mov si,offset cmdline+1		;index into command line
	mov bl,[si-1]			;get line length
	xor bh,bh
	mov [bx+si],bh			;mark end of line with 0
	
	call getc
	if@ al,ne,0			;skip if 0
	    if@ al,eq,'/'		;set flags only, if /
		call ungetc
		call setflags
	    else@
		if@ al,ne,'='		;skip leading =
		    call ungetc
		endif@
	    
		call setpath
		call setflags
	    endif@
	endif@
	ret


	
backc	db	0ffh

getc:					;get a non-ctrl and non-blank char
	mov al,backc
	if@ al,ne,0ffh
	    mov backc,0ffh
	else@
	    repeat
		lodsb
		and al,7fh
		cmp al,0
		je getcexit
	    until al,a,' '
	endif@
getcexit:
	ret



ungetc:					;backup a char in input
	mov backc,al
	ret



isdrivec:				;@,A-Z,a-z allowed as drive
	call tupper
	if@ al,ae,'@'
	    if@ al,be,'Z'
		stc
	    else@
		clc
	    endif@
	else@
	    clc
	endif@
	ret



ispathc:				;'0;/' not allowed in path
	if@ al,eq,0
	    clc
	elseif@ al,eq,'/'
	    clc
	elseif@ al,eq,';'
	    clc
	else@
	    stc
	endif@
	endif@
	endif@
	ret



setpath:
	mov di,offset altdir			;di is path list
	
	repeat
	    call getc
	    mov ah,al				;save char
	    
	    call ispathc
	    jnc sploop				;loop if not path char
	    
	    mov bx,di				;save start addr of path entry
	    inc di				;skip length byte
	    
	    mov al,07fh				;set drive byte to default
	    stosb
	    
	    mov al,ah				;restore char
	    call isdrivec
	    if@ c				;if char is a drive letter
		call getc
		if@ al,eq,':'			;if next char is :
		    mov al,ah			;get drive letter
		    call tupper
		    sub al,'A'			;convert to number
		    and al,7fh			;@=7F, A=0, B=1 ...
		    dec di			;point back at drive byte
		    stosb			;put in path entry
		    call getc
		elseif@ al,eq,overc		;if next char is override
		    mov al,ah			;get drive letter
		    call tupper
		    sub al,'A'			;convert to number
		    or al,80h			;@=FF, A=80, B=81 ...
		    dec di			;point back at drive byte
		    stosb			;put in path entry
		    call getc
		else@				;no drive specifier
		    call ungetc			;put back second char
		    mov al,ah			;restore first
		endif@
		endif@
	    endif@
	    
	    call ispathc
	    while c				;while char is in path name
		call tupper
		stosb				;put char in path entry
		call getc
		call ispathc
	    endw
	    
	    mov ah,al				;save char
	    xor al,al				;mark end of path entry
	    stosb
	    
	    mov cx,di				;calc entry length
	    sub cx,bx
	    mov es: [bx],cl			;set length byte
sploop:
	until ah,ne,';'
	
	mov al,ah				;restore char
	call ungetc				;back up last char
	
	xor al,al				;mark end of path list
	stosb
	ret


	
setflags:
	call getc
	while al,ne,0			;skip to 0 or /
	    cmp al,'/'
	    je sf1
	    call getc
	endw
	
sf1:
	while al,ne,0			;loop while not 0
	    call tupper			;convert to upper case
		
	    if@ al,eq,'-'		;off
		mov es: onflag,0
	    
	    elseif@ al,eq,'+'		;on
		mov es: onflag,1
		
	    elseif@ al,eq,'D'		;debug
		mov es: debugf,1
		
	    elseif@ al,eq,'N'		;no debug
		mov es: debugf,0
	    
	    endif@
	    endif@
	    endif@
	    endif@
	    
	    call getc
	endw
	    
setfexit:
	call ungetc
	ret
	


smsg	db	'DPATH = '
smsgl	equ	$-smsg
scmsg	db	'; '
scmsgl	equ	$-scmsg
semsg	db	' '
semsgl	equ	$-semsg
crmsg	db	13,10
crmsgl	equ	$-crmsg
offmsg	db	'/-'
offmsgl	equ	$-offmsg
dmsg	db	'/D'
dmsgl	equ	$-dmsg

status:
	mov dx,offset smsg
	mov cx,smsgl
	call prtmsg
	
	mov si,offset altdir
	
	while <es: byte ptr [si]>,ne,0
	    mov al,es: [si+1]
	    call drvprt
	    
	    lea dx,[si+2]
	    mov cl,es: [si]
	    sub cl,3
	    xor ch,ch
	    
	    mov ax,es
	    mov ds,ax
	    call prtmsg
	    mov ax,cs
	    mov ds,ax
	  
	    mov al,es: [si]
	    xor ah,ah
	    add si,ax
	    
	    if@ <es: byte ptr [si]>,ne,0
		mov dx,offset scmsg
		mov cx,scmsgl
		call prtmsg
	    endif@
	endw

	mov dx,offset semsg			;print end message
	mov cx,semsgl
	call prtmsg
	
	if@ <es: onflag>,eq,0	
	    mov dx,offset offmsg
	    mov cx,offmsgl
	    call prtmsg
	endif@
	    
	if@ <es: debugf>,ne,0
	    mov dx,offset dmsg
	    mov cx,dmsgl
	    call prtmsg
	endif@
	
	mov	dx,offset crmsg
	mov	cx,crmsgl
	call	prtmsg
	ret



all	ends
	end	dpath
