;Reverse ruler program for 25th line
;
;	For Z-DOS only
;	This program clears the 25th line and sets up a ruler
;	in reverse video for text editing.
;
;	Created 4-29-83 by W. M. Adney
;
;Modification Date	Description
;	N/A
;
	.XLIST
INCLUDE DEFASCII.ASM
INCLUDE DEFMS.ASM
	.LIST

PGMSEG	SEGMENT
	ASSUME CS:PGMSEG,SS:PGMSEG,DS:PGMSEG,ES:NOTHING

ESC	EQU	1BH	;Escape function
;
	ORG	100H

MAIN:	MOV	DX,OFFSET CLS		;CLEAR THE SCREEN
	CALL	SENDLINE
	MOV	DX,OFFSET CURPOS	;SAVE THE CURSOR POSITION
	CALL	SENDLINE
	MOV	DX,OFFSET ENABLE25	;ENABLE THE 25TH LINE
	CALL	SENDLINE
	MOV	DX,OFFSET BEGIN25	;BEGINNING OF 25TH LINE
	CALL	SENDLINE
	MOV	DX,OFFSET RVIDEO	;ENTER REVERSE VIDEO
	CALL	SENDLINE
	MOV	DX,OFFSET LINE25	;25TH LINE DISPLAY
	CALL	SENDLINE
	MOV	DX,OFFSET RVIDEND	;EXIT REVERSE VIDEO
	CALL	SENDLINE
;MOV	DX,OFFSET DISABL25		;DISABLE 25TH LINE
;CALL	SENDLINE
	MOV	DX,OFFSET CURSAV	;RETURN CURSOR TO SAVED POSITION
	CALL	SENDLINE
	INT	DOSI_TERM		;RETURN TO Z-DOS
;
;*****************
;*  SUBROUTINES  *
;*****************
;
SENDLINE:	MOV	AH,DOSF_OUTSTR	;Z-DOS PRINT STRING FUNCTION
	INT	DOSI_FUNC		;CALL Z-DOS TO PRINT LINE
	RET
;
;****************
;* Escape Codes *
;****************
;
CLS:	DB	ESC,'E','$'		;Escape E - clear screen
CURPOS:	DB	ESC,'j','$'		;Save cursor position
ENABLE25:	DB	ESC,'x','1','$'	;Enable 25th line
BEGIN25:	DB	ESC,'Y','8',' ','$'	;Begin line 25
RVIDEO:		DB	ESC,'p','$'	;Enter reverse video
LINE25:	DB	'1...+...10....+...20....+...30....+...40'
	DB	'....+...50....+...60....+...70....+...80$'
RVIDEND:	DB	ESC,'q','$'	;Exit reverse video
DISABL25:	DB	ESC,'y','1','$'	;Disable 25th line
CURSAV:	DB	ESC,'k','$'	;Return cursor to saved position

PGMSEG	ENDS
	END	MAIN	;END OF PROGRAM
