/**** dumpdir - display a diskette directory in hex on the screen
*
*	Programmer: Darron J Shaffer
*
*       Company:    SigmaSoft & Systems
*                   17000 Dallas Parkway, #207
*                   Dallas, Texas 75248
*
*	Date:	    July 3, 1987
*
*	Notes:	    Written under contract with William Adney for use
*		    in Heath Company MS-DOS course.
*
*		    This program is intended to compile under Microsoft C
*		    version 4.0.
*
*                   This program will not properly display a directory sector
*                   which contains deleted file entries.
*/


char    *notice[] =
        {
                    " Written by Darron J Shaffer \n",
                    "  SigmaSoft & Systems \n",
                    "  17000 Dallas Parkway, #207 \n",
                    "  Dallas, Texas 75248 \n"
        };

#define LINT_ARGS

#include    <stdio.h>
#include    <dos.h>
#include    <ctype.h>
#include    <string.h>
#include    "diskinfo.h"

char	dir_buffer[512];    /* buffer for working dir */
int	drive = 0;	    /* drive number to use: default is A: */

void	readdir();
void	showdir();
void	check_disk();

main(argc,argv)
int	argc;
char	*argv[];
{
    if ( argc>2 )	/* valid # of arguments? */
    {
	printf("\nUsage: dumpfat [d:]\n");
	exit(1);
    }
    if ( argc==2 )	/* do we have a drive name? */
    {
	/* process the drive name */

	    /* is the drive name valid? */
	if ( strlen(argv[1])!=2 || !isalpha(argv[1][0]) || argv[1][1]!=':' )
	{
	    printf("\nError: Invalid drive name.\n");
	    exit(1);
	}
	drive = toupper(argv[1][0]) - 'A';  /* convert drive to numeric */
    }

    /* now have processed any argument - get to work */

    check_disk();   /* check for proper type of disk */
    readdir();	    /* read in the directory */
    showdir();	    /* and display it */

    return 0;	    /* no errors */
}

/**** readdir - read the directory off of the disk
*/

void	readdir()
{
    union REGS	regs;	    /* register image for int86 function */

    /* set up for sector read */
    regs.h.al = drive;
    regs.x.cx = 1;		    /* read only one sector */
    regs.x.dx = 5;		    /* read logical sector one */
    regs.x.bx = (int) dir_buffer;   /* read into working buffer (ds correct) */

    int86(0x25,&regs,&regs);	/* go do the read */

    if ( regs.x.cflag )
    {
	printf("\nError: Can't read specified disk.\n");
	exit(1);
    }
}

/**** showdir - display the directory
*/

void	showdir()
{
    int     column,line,    /* loop indexes */
	    i,		    /* loop index */
	    attrib;	    /* attribute byte */

    printf("\n\t\tHexadecimal Directory Display\n");

    printf("\n     0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 ");
    printf("\n    -------------------------------------------------+");
    printf("---------------   ADLSHR");

    for ( line=0; line < 16; line++ )
    {
	printf("\n%2d: ",line);

	for ( column=0; column<16; column++ )
	    printf("%02X ", dir_buffer[line*16+column] & 0xff);
	printf(" |  ");

	if ( (line & 1)==0 )
	{
	    /* first line of an entry */
	    printf("%11.11s   ",dir_buffer+line*16);
	    if ( dir_buffer[line*16] )	    /* don't display if empty */
	    {
		attrib = dir_buffer[line*16 + 11];
		for ( i=7; i>=0; --i )
		    if ( (attrib >> i) & 1 )
			putchar('1');
		    else
			putchar('0');
	    }
	}
	else
	{
	    /* second line of an entry */
	    if ( dir_buffer[line*16-16] )   /* don't display if empty */
		printf(" First = %03X",*((int *) (dir_buffer+line*16+0x0a)));
	}
    }
}

/**** check_disk - check to make sure disk if proper format
*
*   This routine operates by checking the number of clusters on the disk.
*   This number is the most unique single parameter of the many types of
*   disk formats.  (Even the 'Media Descriptor' may have the same value from
*   hard disk partitions to floppy diskettes.)
*
*/

void check_disk()
{
    struct DISKINFO info;

    info = diskinfo(drive+1);

    if ( info.total_clusters != 354 )
    {
	printf("\nError: Wrong Type of Disk.\n");
	exit(1);
    }
}

