	TITLE	Z-100 Emulation for Z-150 and IBM PC
	page	,120
;
;
;	Z-100 Emulation for IBM PC or Zenith Z-150
;
;	Author: R. A. Metz			Date: 1/25/84
;
;	MODIFIED BY P. SWAYNE, HUG  16-MAY-84  24-MAY-84
;		TABS PROCESSED HERE, NULLS IGNORED, ESC y1 ADDED,
;		GRAPHIC CHARACTERS CHANGED
;	MODS DONE 23-SEP-84 TO 11-OCT-84
;		NO LONGER USES INTERRUPTS 61H, 62H, OR 63H
;		OPTIONAL Z-150 MODE PROVIDES ALL H19 GRAPHICS
;		ESC-E ON 25TH LINE CLEARS ONLY 25TH LINE
;		ADDED ESC-x5, ESC-y5
;		ADDED ESC-Z IDENTIFY
;		ADDED LOCAL PROCESSING OF SYS FUNC. 12, FLUSH BUFFER
;		ADDED KEY PAD SHIFT CAPABILITY (ESC-x6, y6, t, u)
;	FINAL REVISION  22-OCT-84
;
;	This program will provide for the IBM PC or Z-150 an environment
;	similar to a Zenith Z-100 such that certain software
;	written specifically for the Z-100 may run in the Z-150.
;	Any software written for the Z-100 which does not access
;	the Z-100 hardware or screen memory, BIOS routines, ROM, or
;	use any of the un-emulated features of the Z-100 (see below)
;	should run on the Z-150 or IBM PC using this emulator.
;
;	PC BIOS interrupts 10H (CRT I/O) and 16H (Keyboard I/O) are
;	preprocessed by this program to let the PC console be treated
;	as a Z-19 terminal in the same manner as the Z-100 console.
;
;	Caution:  This program may or may not function in conjunction with
;	other programs which themselves pre-empt INTs 10H or 16H (e.g. the 
;	IRMA software).
;
;	For the IBM PC (or Zenith Z-150) to emulate the Z-100 keyboard and
;	CRT operation, certain compromises had to be made due to differences
;	in hardware.  Most of the Z-100 escape sequences are emulated, but 
;	some could not be due to hardware limitations.  The Z-100 keyboard
;	was mapped to the PC keyboard, but with limitations due to physical
;	differences.  The following describe the actual escape sequence
;	processing and keyboard mapping:
;
;	Escape sequences emulated are as follows:
;
;	A - cursor up         	B - cursor down
;	C - cursor right	D - cursor left
;	E - clear		H - cursor home
;	J - erase to end scrn	K - erase to end of line
;	Y - cursor address	p - reverse video
;	q - normal video	j - save cursor
;	k - restore cursor	n - cursor report
;	z - reset		x - set modes
;	y - reset modes		F - graphics on
;	G - graphics off 	I - reverse index
;	L - insert line		M - delete line
;	N - delete chr		O - exit insert mode
;	@ - enter insert mode	b - erase to top
;	l - erase current line  o - erase to beginning of line
;	m - set colors   	i - Zenith identify
;	v - wrap at eol		w - discard at eol
;	Z - VT52 identify
;
;	escape sequences not implemented are:
;
;	x1	- enable 25th line (25th line always enabled)
;		  (y1 just erases 25th line)
;	x2 & y2 - enable/disable key click (always on)
;	x3 & y3 - enable/disable hold screen mode (not supported)
;	x7 & y7 - enter/exit alt keypad mode (not supported)
;	x; & y; - cursor blink on/off (cursor always blinking)
;	x< & y< - enable/disable keyboard autorepeat (always enabled)
;	x@ & y@ - enable/disable keybaord up/down mode (not supported)
;	#	- transmit page
;	]	- transmit 25th line
;	^	- transmit current line
;	=	- enter alt keypad mode
;	>	- exit alt keypad mode
;	rx	- mod baud rate
;	{ & }   - enable/disable keyboard (always enabled)
;
;
;  Z-150 to Z-100 (Z-19) key equivalences are as follows:
;
;	Z-100 key		Z-150 key
;	---------		----------
;
;	cursor keys		cursor keys
;	alphanumerics		alphanumerics
;	SHIFT-alpha		SHIFT-alpha
;	CTRL-alpha		CTRL-alpha
;	F0			CTRL-F10
;	F1			F1
;	F2			F2
;	F3			F3
;	F4			F4
;	F5			F5
;	F6			F6
;	F7			F7
;	F8			F8
;	F9			F9
;	F10			F10
;	F11			CTRL-F1
;	F12			CTRL-F2
;	SHIFT-F0		ALT-F10
;	SHIFT-F1		SHIFT-F1
;	SHIFT-F2		SHIFT-F1
;	SHIFT-F3		SHIFT-F1
;	SHIFT-F4		SHIFT-F1
;	SHIFT-F5		SHIFT-F1
;	SHIFT-F6		SHIFT-F1
;	SHIFT-F7		SHIFT-F1
;	SHIFT-F8		SHIFT-F1
;	SHIFT-F9		SHIFT-F1
;	SHIFT-F10		SHIFT-F10
;	SHIFT-F11		ALT-F1
;	SHIFT-F12		ALT-F2
;	ENTER (KEYPAD)		INS *
;	DEL			DEL
;	HOME			HOME
;	HELP			ALT-1
;	BREAK			ALT-2
;	I CHR			ALT-3
;	D CHR			ALT-4
;	INS LINE		ALT-5
;	DEL LINE		ALT-6 
;
;	* When key expansion on the Z-100 is turned off, the keypad
;	ENTER key produces a different code from the RETURN key.  When
;	you run programs that turn off keyboard expansion and ask you
;	to press the ENTER key, you can use the INS key to get the
;	desired result.
;
	SUBTTL	DEFINITIONS
	PAGE

TRUE	EQU	-1
FALSE	EQU	NOT TRUE
Z150	EQU	TRUE			;IF TRUE, ASSEMBLES FOR Z-150 USE
					;IF FALSE, ASSEMBLES FOR IBM
SDOT	EQU	2			;CODE FOR SINGLE DOT MODE

ZEM	SEGMENT
	ASSUME	CS:ZEM,DS:ZEM,ES:ZEM,SS:ZEM

	ORG	100H
START:	JMP	BEGIN
;
;     Z-100 TO Z-150 GRAPHIC CHR XLAT TABLE
;	ONLY LOCS 5EH TO 7EH ARE PRESENT    
;
GRPHCHR	LABEL	BYTE
	IF	Z150
	db	0DEh	; ^		;THESE VALUES ARE VALID ON A
	db	0DFh	; _		;Z-150 TYPE COMPUTER ONLY, AND
	db	0E0h	; `		;PRODUCE H19 GRAPHICS
	db	0E1h	; a
	db	0E2h	; b
	db	0E3h	; c
	db	0E4h	; d
	db	0E5h	; e
	db	0E6h	; f
	db	0E7h	; g
	db	0E8h	; h
	db	0E9h	; i
	db	0EAh	; j
	db	0EBh	; k
	db	0ECh	; l
	db	0EDh	; m
	db	0EEh	; n
	db	0EFh	; o
	db	0F0h	; p
	db	0F1h	; q
	db	0F2h	; r
	db	0F3h	; s
	db	0F4h	; t
	db	0F5h	; u
	db	0F6h	; v
	db	0F7h	; w
	db	0F8h	; x
	db	0F9h	; y
	db	0FAh	; z
	db	0FBh	; {
	db	0FCh	; |
	db	0FDh	; }
	db	0FEh	; ~
	db	07Fh	; DEL
	ELSE
	db	0f9h	; ^		;THESE VALUES ARE VALID FOR
	db	0dbh	; _		;ANY IBM COMPATIBLE COMPUTER,
	db	0b3h	; `		;AND PRODUCE APPROXIMATE H19
	db	0c4h	; a		;GRAPHICS
	db	0c5h	; b
	db	0bfh	; c
	db	0d9h	; d
	db	0c0h	; e
	db	0dah	; f
	db	0f1h	; g
	db	01ah	; h
	db	0b1h	; i
	db	0f6h	; j
	db	019h	; k
	db	0dah	; l
	db	0bfh	; m
	db	0d9h	; n
	db	0c0h	; o
	db	0dfh	; p
	db	0deh	; q
	db	0dbh	; r
	db	0c2h	; s
	db	0b4h	; t
	db	0c1h	; u
	db	0c3h	; v
	db	058h	; w
	db	02fh	; x
	db	05ch	; y
	db	0dfh	; z
	db	0dch	; {
	db	0ddh	; |
	db	0deh	; }
	db	014h	; ~
	db	07Fh	; del
	ENDIF
;
EXPTBL	LABEL	BYTE			;KEYBOARD EXPANSION TABLE
;
;	4-BYTES PER ENTRY CONTAINING KEY EXPANSION STRING
;	NULL TERMINATES ENTRY
;
;	NON-EXTENDED Z-150 KEYBOARD CODES ARE PASSED
;	DIRECTLY TO THE CALLER.
;	EXTENDED CODES ARE EXPANDED USING THIS TABLE IN
;	KEYBOARD EXPANSION MODE.
;
	DB	0,0,0,0		;00
	DB	0,0,0,0		;01
	DB	0,0,0,0		;02
	DB	0,0,0,0		;03
	DB	0,0,0,0		;04
	DB	0,0,0,0		;05
	DB	0,0,0,0		;06
	DB	0,0,0,0		;07
	DB	0,0,0,0		;08
	DB	0,0,0,0		;09
	DB	0,0,0,0		;0A
	DB	0,0,0,0		;0B
	DB	0,0,0,0		;0C
	DB	0,0,0,0		;0D
	DB	0,0,0,0		;0E
	DB	0,0,0,0		;0F
	DB	0,0,0,0		;10
	DB	0,0,0,0		;11
	DB	0,0,0,0		;12
	DB	0,0,0,0		;13
	DB	0,0,0,0		;14
	DB	0,0,0,0		;15
	DB	0,0,0,0		;16
	DB	0,0,0,0		;17
	DB	0,0,0,0		;18
	DB	0,0,0,0		;19
	DB	0,0,0,0		;1A
	DB	0,0,0,0		;1B
	DB	0,0,0,0		;1C
	DB	0,0,0,0		;1D
	DB	0,0,0,0		;1E
	DB	0,0,0,0		;1F
	DB	0,0,0,0		;20
	DB	0,0,0,0		;21
	DB	0,0,0,0		;22
	DB	0,0,0,0		;23
	DB	0,0,0,0		;24
	DB	0,0,0,0		;25
	DB	0,0,0,0		;26
	DB	0,0,0,0		;27
	DB	0,0,0,0		;28
	DB	0,0,0,0		;29
	DB	0,0,0,0		;2A
	DB	0,0,0,0		;2B
	DB	0,0,0,0		;2C
	DB	0,0,0,0		;2D
	DB	0,0,0,0		;2E
	DB	0,0,0,0		;2F
	DB	0,0,0,0		;30
	DB	0,0,0,0		;31
	DB	0,0,0,0		;32
	DB	0,0,0,0		;33
	DB	0,0,0,0		;34
	DB	0,0,0,0		;35
	DB	0,0,0,0		;36
	DB	0,0,0,0		;37
	DB	0,0,0,0		;38
	DB	0,0,0,0		;39
	DB	0,0,0,0		;3A
	DB	1BH,'S',0,0	;3B  -  F1
	DB	1BH,'T',0,0	;3C  -  F2
	DB	1BH,'U',0,0	;3D  -  F3
	DB	1BH,'V',0,0	;3E  -  F4
	DB	1BH,'W',0,0	;3F  -  F5
	DB	1BH,'P',0,0	;40  -  F6
	DB	1BH,'Q',0,0	;41  -  F7
	DB	1BH,'R',0,0	;42  -  F8
	DB	1BH,'0I',0  	;43  -  F9
	DB	1BH,'0J',0  	;44  -  F10
	DB	0,0,0,0     	;45
	DB	0,0,0,0     	;46
	DB	1BH,'H',0,0	;47  -  HOME
	DB	1BH,'A',0,0	;48  -  CURS UP
	DB	0,0,0,0    	;49  
	DB	0,0,0,0		;4A
	DB	1BH,'D',0,0	;4B  -  CURS LFT
	DB	0,0,0,0		;4C
	DB	1BH,'C',0,0	;4D  -  CURS RT
	DB	0,0,0,0		;4E
	DB	0,0,0,0		;4F
	DB	1BH,'B',0,0	;50  -  CURS DWN
  	DB	0,0,0,0		;51
	DB	0DH,0,0,0	;52  -  ICHR  -  ENTER
	DB	07FH,0,0,0	;53  -  DEL
	DB	1BH,'1A',0  	;54  -  S(F1)
	DB	1BH,'1B',0  	;55  -  S(F2)
	DB	1BH,'1C',0  	;56  -  S(F3)
	DB	1BH,'1D',0  	;57  -  S(F4)
	DB	1BH,'1E',0  	;58  -  S(F5)
	DB	1BH,'1F',0  	;59  -  S(F6)
	DB	1BH,'1G',0  	;5A  -  S(F7)
	DB	1BH,'1H',0  	;5B  -  S(F8)
	DB	1BH,'1I',0  	;5C  -  S(F9)
	DB	1BH,'1J',0  	;5D  -  S(F10)
	DB	1BH,'0K',0  	;5E  -  F11  -  CTL(F1)
	DB	1BH,'0L',0  	;5F  -  F12  -  CTL(F2)
	DB	0,0,0,0		;60
	DB	0,0,0,0		;61
	DB	0,0,0,0		;62
	DB	0,0,0,0		;63
	DB	0,0,0,0		;64
	DB	0,0,0,0		;65
	DB	0,0,0,0		;66
	DB	1BH,'J',0,0	;67  -  F0      -  CTL(F10)
	DB	1BH,'1K',0  	;68  -  S(F11)  -  ALT(F1)
	DB	1BH,'1L',0  	;69  -  S(F12)  -  ALT(F2)
	DB	0,0,0,0		;6A
	DB	0,0,0,0		;6B
	DB	0,0,0,0		;6C
	DB	0,0,0,0		;6D
	DB	0,0,0,0		;6E
	DB	0,0,0,0		;6F
	DB	0,0,0,0		;70
	DB	1BH,'E',0,0	;71  -  S(F0)    -  ALT(F10)
	DB	0,0,0,0		;72
	DB	0,0,0,0		;73
	DB	0,0,0,0		;74
	DB	0,0,0,0		;75
	DB	0,0,0,0		;76
	DB	0,0,0,0		;77
	DB	1BH,'~',0,0	;78  -  HELP  -  ALT(1)
	DB	1BH,'|',0,0	;79  -  BREAK -  ALT(2)
	DB	1BH,'@',0,0	;7A  -  I CHR -  ALT(3)
	DB	1BH,'N',0,0	;7B  -  D CHR -  ALT(4)
	DB	1BH,'L',0,0	;7C  -  INS LINE  -  ALT(5)
	DB	1BH,'M',0,0	;7D  -  DEL LINE -  ALT(6)
	DB	0,0,0,0		;7E
	DB	0,0,0,0		;7F
;
NOEXPTBL	LABEL	BYTE	;KEYBOARD EXPANSION TABLE
;
;	4-BYTES PER ENTRY CONTAINING KEY EXPANSION STRING
;	NULL TERMINATES ENTRY
;
;	NON-EXTENDED Z-150 KEYBOARD CODES ARE PASSED
;	DIRECTLY TO THE CALLER.
;	EXTENDED CODES ARE EXPANDED USING THIS TABLE IN
;	KEYBOARD EXPANSION MODE DISABLED.
;
	DB	0,0,0,0		;00
	DB	0,0,0,0		;01
	DB	0,0,0,0		;02
	DB	0,0,0,0		;03
	DB	0,0,0,0		;04
	DB	0,0,0,0		;05
	DB	0,0,0,0		;06
	DB	0,0,0,0		;07
	DB	0,0,0,0		;08
	DB	0,0,0,0		;09
	DB	0,0,0,0		;0A
	DB	0,0,0,0		;0B
	DB	0,0,0,0		;0C
	DB	0,0,0,0		;0D
	DB	0,0,0,0		;0E
	DB	0,0,0,0		;0F
	DB	0,0,0,0		;10
	DB	0,0,0,0		;11
	DB	0,0,0,0		;12
	DB	0,0,0,0		;13
	DB	0,0,0,0		;14
	DB	0,0,0,0		;15
	DB	0,0,0,0		;16
	DB	0,0,0,0		;17
	DB	0,0,0,0		;18
	DB	0,0,0,0		;19
	DB	0,0,0,0		;1A
	DB	0,0,0,0		;1B
	DB	0,0,0,0		;1C
	DB	0,0,0,0		;1D
	DB	0,0,0,0		;1E
	DB	0,0,0,0		;1F
	DB	0,0,0,0		;20
	DB	0,0,0,0		;21
	DB	0,0,0,0		;22
	DB	0,0,0,0		;23
	DB	0,0,0,0		;24
	DB	0,0,0,0		;25
	DB	0,0,0,0		;26
	DB	0,0,0,0		;27
	DB	0,0,0,0		;28
	DB	0,0,0,0		;29
	DB	0,0,0,0		;2A
	DB	0,0,0,0		;2B
	DB	0,0,0,0		;2C
	DB	0,0,0,0		;2D
	DB	0,0,0,0		;2E
	DB	0,0,0,0		;2F
	DB	0,0,0,0		;30
	DB	0,0,0,0		;31
	DB	0,0,0,0		;32
	DB	0,0,0,0		;33
	DB	0,0,0,0		;34
	DB	0,0,0,0		;35
	DB	0,0,0,0		;36
	DB	0,0,0,0		;37
	DB	0,0,0,0		;38
	DB	0,0,0,0		;39
	DB	0,0,0,0		;3A
	DB	097H,0,0,0 	;3B  -  F1
	DB	098H,0,0,0 	;3C  -  F2
	DB	099H,0,0,0 	;3D  -  F3
	DB	09AH,0,0,0 	;3E  -  F4
	DB	09BH,0,0,0 	;3F  -  F5
	DB	09CH,0,0,0  	;40  -  F6
	DB	09DH,0,0,0 	;41  -  F7
	DB	09EH,0,0,0 	;42  -  F8
	DB	09FH,0,0,0  	;43  -  F9
	DB	0A0H,0,0,0  	;44  -  F10
	DB	0,0,0,0     	;45
	DB	0,0,0,0     	;46
	DB	0A9H,0,0,0 	;47  -  HOME
	DB	0A5H,0,0,0 	;48  -  CURS UP
	DB	0,0,0,0    	;49  
	DB	0,0,0,0		;4A
	DB	0A8H,0,0,0 	;4B  -  CURS LFT
	DB	0,0,0,0		;4C
	DB	0A7H,0,0,0 	;4D  -  CURS RT
	DB	0,0,0,0		;4E
	DB	0,0,0,0		;4F
	DB	0A6H,0,0,0 	;50  -  CURS DWN
  	DB	0,0,0,0		;51
	DB	08DH,0,0,0 	;52  -  ENTER  -  INS
	DB	07FH,0,0,0	;53  -  DEL
	DB	0D7H,0,0,0  	;54  -  S(F1)
	DB	0D8H,0,0,0  	;55  -  S(F2)
	DB	0D9H,0,0,0  	;56  -  S(F3)
	DB	0DAH,0,0,0  	;57  -  S(F4)
	DB	0DBH,0,0,0  	;58  -  S(F5)
	DB	0DCH,0,0,0  	;59  -  S(F6)
	DB	0DDH,0,0,0  	;5A  -  S(F7)
	DB	0DEH,0,0,0  	;5B  -  S(F8)
	DB	0DFH,0,0,0  	;5C  -  S(F9)
	DB	0E0H,0,0,0  	;5D  -  S(F10)
	DB	0A1H,0,0,0  	;5E  -  F11  -  CTL(F1)
	DB	0A2H,0,0,0  	;5F  -  F12  -  CTL(F2)
	DB	0,0,0,0		;60
	DB	0,0,0,0		;61
	DB	0,0,0,0		;62
	DB	0,0,0,0		;63
	DB	0,0,0,0		;64
	DB	0,0,0,0		;65
	DB	0,0,0,0		;66
	DB	096H,0,0,0 	;67  -  F0      -  CTL(F10)
	DB	0E1H,0,0,0  	;68  -  S(F11)  -  ALT(F1)
	DB	0E2H,0,0,0  	;69  -  S(F12)  -  ALT(F2)
	DB	0,0,0,0		;6A
	DB	0,0,0,0		;6B
	DB	0,0,0,0		;6C
	DB	0,0,0,0		;6D
	DB	0,0,0,0		;6E
	DB	0,0,0,0		;6F
	DB	0,0,0,0		;70
	DB	0D6H,0,0,0 	;71  -  S(F0)    -  ALT(F10)
	DB	0,0,0,0		;72
	DB	0,0,0,0		;73
	DB	0,0,0,0		;74
	DB	0,0,0,0		;75
	DB	0,0,0,0		;76
	DB	0,0,0,0		;77
	DB	095H,0,0,0 	;78  -  HELP  -  ALT(1)
	DB	0AAH,0,0,0 	;79  -  BREAK -  ALT(2)
	DB	0A3H,0,0,0 	;7A  -  I CHR -  ALT(3)
	DB	0E3H,0,0,0 	;7B  -  D CHR -  ALT(4)
	DB	0A4H,0,0,0 	;7C  -  INS LINE  -  ALT(5)
	DB	0E4H,0,0,0	;7D  -  DEL LINE -  ALT(6)
	DB	0,0,0,0		;7E
	DB	0,0,0,0		;7F

;	SHIFTED KEYPAD TABLE

SHPDTBL	LABEL	BYTE
	DB	1BH,'L'			;IL
	DB	1BH,'B'			;DOWN
	DB	1BH,'M'			;DL
	DB	1BH,'D'			;LEFT
	DB	1BH,'H'			;HOME
	DB	1BH,'C'			;RIGHT
	DB	1BH,'@'			;IC
	DB	1BH,'A'			;UP
	DB	1BH,'N'			;DC

SCREEN_VECT	DW	OFFSET SCREEN_IDLE	;DEFAULT VECTOR
;
INT10V	DD	0			;INT 10 VECTOR
INT16V	DD	0			;INT 16 VECTOR
INT21V	DD	0			;INT 21 VECTOR
;
KBDFIF	DW	OFFSET FIF
	DW	OFFSET FIFE		;KEYBOARD TYPE-AHEAD FIFO
KBDFIF1	DW	OFFSET FIF
KBDFIF2	DW	OFFSET FIF
;
FIF	DB	64 DUP (?)		;TYPE-AHEAD BUFFER
FIFE	DB	0
;
;	Z-100 CURRENT STATE
;
ZSTATE	LABEL	BYTE
LFONCR	DB	0			;LF ON CR MODE FLAG
CRONLF	DB	0			;CR ON LF MODE FLAG
KEYEXP	DB	0			;KEYBOARD EXPANSION MODE FLAG
INSMOD	DB	0			;INSERT MODE FLAG
REVFLG	DB	0			;REVERSE VIDEO FLAG
GRAFLG	DB	0			;GRAPHICS MODE FLAG
WRPFLG	DB	0			;WRAP AT EOL MODE FLAG
FATTR	DB	0			;FOREGROUND ATTR
BATTR	DB	0			;BACKGROUND ATTR
SAV_ROW	DB	0		
SAVCUR	DW	0	
CURS_SAV DW	0
PADFLG	DB	0			;SHIFTED KEYPAD FLAG
CURTYP	DW	707H			;CURSOR TYPE
;
	DB	100 DUP (?)
STACK:
	DB	0
;
	SUBTTL	Z-100 ESCAPE SEQUENCE PROCESSING
	PAGE
;
;	PROCESS TTY I/O EMULATING A Z-100 CONSOLE
;
SMART_TERM:
	CMP	BYTE PTR CS:TGLFLG,0	;ZEM ON?
	JZ	SMARTX			;NO, EXIT
	CMP	AH,14			;TTY I/O?
	JE	TEST_ESC		; YES - PROCESS ESCAPE SEQUENCES
SMARTX:	JMP	DWORD PTR CS:INT10V	;NO - LET NORMAL CODE PROCESS

;	TEST FOR ESCAPE SEQUENCES, CONTROL CHARS, ETC., AND PROCESS
;	ACCORDINGLY

TEST_ESC:
	STI
	CLD
	PUSH	ES
	PUSH	DS
	PUSH	DX
	PUSH	CX			;SAVE ALL REGS
	PUSH	BX
	PUSH	DI
	MOV	DI,CS
	MOV	DS,DI
	MOV	ES,DI
	JMP	WORD PTR SCREEN_VECT	;JUMP TO PROCESSING ROUTINE

;	NORMAL CHARACTER PROCESSING ROUTINE

SCREEN_IDLE:
	CMP	AL,1BH			;ESCAPE?
	JNE	PASS_ON			; NO - PASS ON
	JMP	DO_ESC			; YES - FURTHER PROCESSING NECESSARY
PASS_ON:OR	AL,AL			;NULL?
	JNZ	PASS1
	JMP	SCREEN_RET		;IF SO, RETURN
PASS1:	CMP	AL,8			;BACK SPACE?
	JNZ	PASS2			;NO
	JMP	DOLFT			;ELSE, BACK UP CURSOR
PASS2:	CMP	AL,' '			;CONTROL CHAR?
	JB	CTLOUT
	CMP	GRAFLG,0		;GRAPHICS MODE?
	JE	SCREEN_OUT		; NO - NORMAL
	CMP	AL,5EH			; YES - GRAPHICS CHR?
	JB	SCREEN_OUT
	CMP	AL,7EH		
	JA	SCREEN_OUT
	SUB	AL,5EH			;REMOVE ASCII OFFSET
	MOV	BX,OFFSET GRPHCHR
	XLAT				;TRANSLATE TO IBM/Z-150 GRAPHIC CODE
SCREEN_OUT:
	CMP	INSMOD,0		;INSERT MODE?
	JE	NOINS			;NO
	PUSH	AX
 	CALL	SHFTR			;ELSE, SHIFT LINE OVER 1 CHR
	POP	AX
NOINS:	MOV	AH,9			;WRITE CHAR W/ATTRIBUTE FUNCTION
	MOV	BL,FATTR		;GET FOREGROUND ATTRIBUTE
	OR	BL,BATTR		;AND BACKGROUND ATTR.
	MOV	BH,0			;WRITE CHR W/ ATTRIBUTE
	MOV	CX,1			;WRITE ONE CHAR
	INT	10H
	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURSOR LOCATION
	CMP	DL,79			;COL 80?
	JE	CHKWRP			; YES - SEE IF TO WRAP
	JMP	DORT			;MOVE CURSOR OVER
CHKWRP:	CMP	WRPFLG,0		;WRAP?
	JE	SCREEN_RET		;NO
	CALL	WRTCRX			;ELSE DO CR
	CALL	WRTLFX			;AND LF
	JMP	SCREEN_RET

;	PROCESS CONTROL CHARACTERS

CTLOUT:	CMP	AL,0DH			;CHECK FOR CR OR LF
	JE	WRT_CR
	CMP	AL,0AH
	JE	WRT_LF
	CMP	AL,9			;TAB?
	JNZ	SCREEN_OUT		;NOT CR, LF, OR TAB
	JMP	TAB			;PROCESS TAB
WRT_CR:	CALL	WRTCRX			;DO THE CR
	CMP	LFONCR,0		;CR - DO LF TOO?
	JE	SCREEN_RET		; NO
	CALL	WRTLFX			;DO FL
	JMP	SHORT SCREEN_RET	;AND RETURN
WRT_LF:	CALL	WRTLFX			;DO LF
	CMP	CRONLF,0		;LF - DO CR TOO?
	JE	SCREEN_RET		; NO
	CALL	WRTCRX			;DO CR

;	RETURN TO SCREEN OUTPUT CALLER

SCREEN_RET:
	POP	DI
	POP	BX
	POP	CX			;RESTORE REGS
	POP	DX
	POP	DS
	POP	ES
	IRET				;RETURN FROM INTERRUPT

;	PROCESS ESCAPE CODES

DO_ESC:	MOV	SCREEN_VECT,OFFSET FIND_CODE	;CODE IS NEXT CHR
	JMP	SCREEN_RET

FIND_CODE:
	MOV	SCREEN_VECT,OFFSET SCREEN_IDLE	;RESET VECT TO IDLE STATE
	CMP	AL,'@'			;LESS THAN "@"?
	JC	SCREEN_RET		;IF SO, IGNORE
	CMP	AL,'z'+1		;MORE THAN "z"?
	JNC	SCREEN_RET		;IF SO, IGNORE
	XOR	AH,AH			;AX = ESC. CODE
	MOV	BX,AX			;BX = ESC. CODE
	SHL	BX,1			;MPY BY 2
	JMP	WORD PTR (CODETABLE-(2*'@'))[BX]	;ENTER ESC SEQ PROCESSOR
;
CODETABLE:				;ESC SEQUENCE PROCESSOR TABLE
	DW	OFFSET INSON		;@
	DW	OFFSET DOUP		;A
	DW	OFFSET DODWN		;B
	DW	OFFSET DORT		;C
	DW	OFFSET DOLFT		;D
	DW	OFFSET DOCLR		;E
	DW	OFFSET GRAFON		;F
	DW	OFFSET GRAFOFF		;G
	DW	OFFSET DOHOME		;H
	DW	OFFSET REVIND		;I
	DW	OFFSET ERSEOS		;J
	DW	OFFSET ERSEOL		;K
	DW	OFFSET INSLIN		;L
	DW	OFFSET DELLIN		;M
	DW	OFFSET DELCHR		;N
	DW	OFFSET INSOFF		;O
	DW	OFFSET IGNORE		;P
	DW	OFFSET IGNORE		;Q
	DW	OFFSET IGNORE		;R
	DW	OFFSET IGNORE		;S
	DW	OFFSET IGNORE		;T
	DW	OFFSET IGNORE		;U
	DW	OFFSET IGNORE		;V
	DW	OFFSET IGNORE		;W
	DW	OFFSET IGNORE		;X
	DW	OFFSET DOADR		;Y
	DW	OFFSET IDVT52		;Z
	DW	OFFSET IGNORE		;[
	DW	OFFSET IGNORE		;\
	DW	OFFSET IGNORE		;]
	DW	OFFSET IGNORE		;^
	DW	OFFSET IGNORE		;_
	DW	OFFSET IGNORE		;`
	DW	OFFSET IGNORE		;a
	DW	OFFSET ERSTOP		;b
	DW	OFFSET IGNORE		;c
	DW	OFFSET IGNORE		;d
	DW	OFFSET IGNORE		;e
	DW	OFFSET IGNORE		;f
	DW	OFFSET IGNORE		;g
	DW	OFFSET IGNORE		;h
	DW	OFFSET ZIDENT		;i
	DW	OFFSET SAVCRS		;j
	DW	OFFSET RSTCRS		;k
	DW	OFFSET ERSLIN		;l
	DW	OFFSET SETCOLOR		;m
	DW	OFFSET CRSRPT		;n
	DW	OFFSET ERSBEG		;o
	DW	OFFSET SETRV		;p
	DW	OFFSET SETNV		;q
	DW	OFFSET IGNR1		;r
	DW	OFFSET IGNORE		;s
	DW	OFFSET SHPAD		;t
	DW	OFFSET USHPAD		;u
	DW	OFFSET WRPON		;v
	DW	OFFSET WRPOFF		;w
	DW	OFFSET SETMOD		;x
	DW	OFFSET RESETMOD		;y
	DW	OFFSET ZRESET		;z

;	RESET TO Z-100 POWER UP STATE

ZRESET:	CALL	SCREEN_INIT		;INITIALIZE SCREEN
	JMP	SCREEN_RET

;	ENTER GRAPHICS MODE

GRAFON:	MOV	GRAFLG,0FFH		;SET GRAPHIC MODE FLAG
	JMP	SCREEN_RET

;	EXIT GRAPHICS MODE

GRAFOFF:MOV	GRAFLG,0		;CLEAR GRAPHIC FLAG
	JMP	SCREEN_RET

;	ENTER INSERT MODE

INSON:	MOV	INSMOD,0FFH
	JMP	SCREEN_RET

;	EXIT INSERT MODE

INSOFF:	MOV	INSMOD,0
	JMP	SCREEN_RET

;	TURN WRAP ON

WRPON:	MOV	WRPFLG,0FFH
	JMP	SCREEN_RET

;	TURN WRAP OFF

WRPOFF:	MOV	WRPFLG,0
	JMP	SCREEN_RET

;	DO REVERSE INDEXING

REVIND:	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURS LOC
	CMP	DH,0			;LINE 1?
	JNE	DOUPJ			; NO - DO CURSOR UP
	MOV	AX,701H			; YES - SCROLL DOWN
	MOV	CX,0
	MOV	DH,23
	MOV	DL,79
	MOV	BH,FATTR
	OR	BH,BATTR
	INT	10H
	JMP	SCREEN_RET
DOUPJ:	JMP	DOUP

;	INSERT A LINE

INSLIN:	MOV	AH,3
	MOV	BH,0
	INT	10H			;CURRENT LOC
	CMP	DH,23
	JGE	ERSLINJ
	MOV	AX,0701H		;SCROLL DOWN FROM CURRENT LINE
DO_SCROLL:
	MOV	CX,DX			;START AT CURRENT LINE
	MOV	CL,0			;COL. 0
	MOV	DH,23			;TO PAGE BOTTOM
	MOV	DL,79		
	CALL	GETATT			;GET ATTRIBUTES FOR BLANK SPACE
	INT	10H
	MOV	AH,3
	MOV	BH,0
	INT	10H
	XOR	DL,DL
	JMP	SETCURS

;	DELETE A LINE

DELLIN:	MOV	AH,3
	MOV	BH,0
	INT	10H			;CURRENT LOC
	MOV	AX,0601H		;SCROLL UP FROM CURRENT LINE
	CMP	DH,23			;BOTTOM OF SCREEN?
	JL	DO_SCROLL		;IF NOT, SCROLL
ERSLINJ:JMP	ERSLIN			;ELSE, ERASE LINE

;	DELETE CHARACTER

DELCHR:	CALL	SHFTL			;SHIFT LINE OVER 1 CHR
	JMP	SCREEN_RET

;	ERASE TO TOP OF SCREEN

ERSTOP:	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURRENT CURSOR LOC
	CMP	DH,0
	JE	ERSBEG			;JUST ERASE LINE BEG. IF ON LINE 1
	MOV	CX,0
	MOV	DL,79
	DEC	DH
	CALL	GETATT			;GET ATTRIBUTES
	MOV	AX,0600H		;ERASE LINE-1 TO TOP
	INT	10H
	JMP	SHORT ERSBEG

;	ERASE LINE

ERSLIN:	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURRENT LOC
	MOV	CX,DX
	MOV	CL,0
	MOV	DL,79
	MOV	AX,0600H		;SCROLL REGION (SINGLE LINE) CLEAR
	CALL	GETATT
	INT	10H
	JMP	SCREEN_RET

;	DELETE 25TH LINE

DLIN25:	MOV	AX,0600H
	MOV	CX,24*256
	MOV	DX,24*256+79
	MOV	BX,0
	INT	10H			;ERASE 25TH LINE
	JMP	SCREEN_RET

;	ERASE BEGINNING OF LINE

ERSBEG:	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURRENT LOC
	CMP	DL,0
	JE	ERSBEG_DON		;DO NOTHING IF AT COL 1
	MOV	CX,DX
	MOV	CL,0
	MOV	AX,0600H		;SCROLL CLEAR (TO BEG OF CUR LINE)
	CALL	GETATT
	INT	10H
ERSBEG_DON:
	JMP	SCREEN_RET

;	SET CHARACTER COLORS

SETCOLOR:
	MOV	SCREEN_VECT,OFFSET GETFGND
	JMP	SCREEN_RET
GETFGND:
	MOV	SCREEN_VECT,OFFSET GETBKGND
	AND	AL,7			;REMOVE ASCII
	MOV	FATTR,AL		;SAVE FOREGROUND COLOR
	JMP	SCREEN_RET
GETBKGND:
	MOV	SCREEN_VECT,OFFSET SCREEN_IDLE
	AND	AL,7
	MOV	CL,4
	SHL	AL,CL
	MOV	BATTR,AL		;SAVE BACKGROUND COLOR
	JMP	SCREEN_RET

;	IDENTIFY AS Z-100 WITH COLOR

ZIDENT:	MOV	SCREEN_VECT,OFFSET GOT_IDENT_CTL
	JMP	SCREEN_RET
GOT_IDENT_CTL:
	MOV	SCREEN_VECT,OFFSET SCREEN_IDLE
	CMP	AL,'0'			;MUST BE ESC-i-0
	JE	DO_ZIDENT
	JMP	SCREEN_RET
DO_ZIDENT:
	MOV	BX,OFFSET KBDFIF
	MOV	AL,1BH			;ESC
	CALL	PTFIFO
	MOV	AL,'i'			;'i'
	CALL	PTFIFO
	MOV	AL,'E'			;'E', Z-100
	CALL	PTFIFO
	MOV	AL,'3'			;'3', COLOR CHIPS INSTALLED
	CALL	PTFIFO
	MOV	AL,'B'			;'B', 64K CHIPS?
	CALL	PTFIFO
	JMP	SCREEN_RET

;	IDENTIFY AS VT52

IDVT52:	MOV	BX,OFFSET KBDFIF
	MOV	AL,1BH
	CALL	PTFIFO			;INSERT ESC
	MOV	AL,'/'
	CALL	PTFIFO			;INSERT "/"
	MOV	AL,'K'
	CALL	PTFIFO			;INSERT "K"
	JMP	SCREEN_RET

;	SET OPERATING MODE

SETMOD:	MOV	SCREEN_VECT,OFFSET GOT_MOD_CHR
	JMP	SCREEN_RET
GOT_MOD_CHR:
	MOV	SCREEN_VECT,OFFSET SCREEN_IDLE
	MOV	BX,OFFSET MOD_TBL
	JMP	MODE_VECT

;	RESET OPERATING MODE

RESETMOD:
	MOV	SCREEN_VECT,OFFSET GOT_RMOD_CHR
	JMP	SCREEN_RET
GOT_RMOD_CHR:
	MOV	SCREEN_VECT,OFFSET SCREEN_IDLE
	MOV	BX,OFFSET RMOD_TBL
MODE_VECT:
	CMP	BYTE PTR [BX],0		;END OF TABLE?
	JNE	CHK_BYTE		;NO, CHECK NEXT ENTRY
	JMP	SCREEN_RET		;ELSE, IGNORE SEQUENCE
CHK_BYTE:
	CMP	AL,[BX]			;FOUND CHAR IN TABLE
	JE	DOIT_TOIT		;YES, EXECUTE ROUTINE
	ADD	BX,3			;ELSE, MOVE TO NEXT ENTRY
	JMP	MODE_VECT		;TRY IT
DOIT_TOIT:
	JMP	WORD PTR 1[BX]		;JUMP TO ROUTINE

;	TABLE OF SET FUNCTIONS

MOD_TBL DB	'4'
	DW	OFFSET BLKCURS
	DB	'5'
	DW	OFFSET CUROFF
	DB	'6'
	DW	OFFSET SHPAD
	DB	'8'
	DW	OFFSET SLFONCR
	DB	'9'
	DW	OFFSET SCRONLF
	DB	'?'
	DW	OFFSET SKEYEXP
	DB	0

;	TABLE OF RESET FUNCTIONS

RMOD_TBL:
	DB	'1'
	DW	OFFSET DLIN25
	DB	'4'
	DW	OFFSET UNDCURS
	DB	'5'
	DW	OFFSET CURON
	DB	'6'
	DW	USHPAD
	DB	'8'
	DW	OFFSET RLFONCR
	DB	'9'
	DW	OFFSET RCRONLF
	DB	'?'
	DW	OFFSET RKEYEXP
	DB	0

;	SET BLOCK CURSOR

BLKCURS:MOV	AH,1
	MOV	CH,0
	MOV	CL,7
	MOV	CURTYP,CX		;SAVE CURSOR TYPE
	INT	10H
	JMP	SCREEN_RET

;	SET UNDERLINE CURSOR

UNDCURS:MOV	AH,1
	MOV	CH,7
	MOV	CL,7
	MOV	CURTYP,CX		;SAVE CURSOR TYPE
	INT	10H
	JMP	SCREEN_RET

;	TURN CURSOR OFF

CUROFF:	MOV	CX,2020H
	MOV	AH,1
	INT	10H			;TURN CURSOR OFF
	JMP	SCREEN_RET

;	TURN CURSOR ON

CURON:	MOV	CX,CURTYP		;GET CURRENT CURSOR TYPE
	MOV	AH,1
	INT	10H			;SET IT
	JMP	SCREEN_RET

;	SET SHIFTED KEYPAD

SHPAD:	MOV	BYTE PTR PADFLG,1	;FLAG KEYPAD SHIFTED
	JMP	SCREEN_RET

;	UNSHIFT KEYPAD

USHPAD:	MOV	BYTE PTR PADFLG,0	;FLAG KEYPAD UNSHIFTED
	JMP	SCREEN_RET

;	SET LF ON CR

SLFONCR:MOV	LFONCR,0FFH
	JMP	SCREEN_RET

;	SET CR ON LF

SCRONLF:MOV	CRONLF,0FFH
	JMP	SCREEN_RET

;	SET EXPANDED KEY MODE

SKEYEXP:MOV	KEYEXP,0
	JMP	SCREEN_RET

;	REMOVE LF ON CR

RLFONCR:MOV	LFONCR,0
	JMP	SCREEN_RET

;	REMOVE CR ON LF

RCRONLF:MOV	CRONLF,0
	JMP	SCREEN_RET

;	REMOVE KEY EXPANSION

RKEYEXP:MOV	KEYEXP,0FFH
	JMP	SCREEN_RET

;	IGNORE A SEQUENCE

IGNR1:	MOV	SCREEN_VECT,OFFSET IGNR_RTN
	JMP	SCREEN_RET
IGNR_RTN:
	MOV	SCREEN_VECT,OFFSET SCREEN_IDLE
IGNORE:	JMP	SCREEN_RET

;	DIRECT CURSOR ADDRESSING

DOADR:	MOV	SCREEN_VECT,OFFSET GOT_ROW
	JMP	SCREEN_RET
GOT_ROW:MOV	SAV_ROW,AL		;SAVE ROW
	MOV	SCREEN_VECT,OFFSET GOTCOL
	JMP	SCREEN_RET
GOTCOL:	MOV	SCREEN_VECT,OFFSET SCREEN_IDLE
	MOV	DH,SAV_ROW		;GET THE ROW
	MOV	DL,AL			;PUT THE COLUMN IN DL
	SUB	DX,'  '			;CONVERT TO 0 BASE
SETCURS:MOV	AH,2
	MOV	BH,0
	INT	10H			;SET CURSOR POSITION CALL
SCREEN_RETJ:
	JMP	SCREEN_RET

;	MOVE CURSOR UP

DOUP:	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURRENT POS
	CMP	DH,24
	JE	SCREEN_RETJ		;DON'T MOVE IF IN 25TH LINE
	DEC	DH
	CMP	DH,0
	JGE	SETCURS
	JMP	SCREEN_RET		;DON'T ALLOW TO GO OFF SCREEN

;	MOVE CURSOR DOWN

DODWN:	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	INC	DH			;INCREMENT LINE NO.
	CMP	DH,23			;BOTTOM LINE OR ABOVE?
	JLE	SETCURS
	JMP	SCREEN_RET		;PASSED BOTTOM LINE, EXIT

;	PROCESS TABS

TAB:	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURSOR POSITION
	ADD	DL,8
	AND	DL,0F8H			;MOVE TO NEXT TAB STOP
	JMP SHORT DORT1

;	MOVE CURSOR TO RIGHT

DORT:	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	INC	DL			;MOVE CURSOR OVER
DORT1:	CMP	DL,79			;END OF LINE
	JLE	SETCURS
	JMP	SCREEN_RET

;	MOVE CURSOR TO LEFT

DOLFT:	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	DEC	DL			;BACK UP CURSOR
	CMP	DL,0			;BEGINNING OF LINE?
	JGE	SETCURS
	JMP	SCREEN_RET

;	HOME CURSOR

DOHOME:	MOV	DX,0
	JMP	SETCURS

;	CLEAR SCREEN

DOCLR:	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURSOR POSITION
	CMP	DH,24			;ON 25TH LINE?
	JNZ	NOTBL			;NO
	JMP	DLIN25			;ELSE, CLEAR BOTTOM LINE
NOTBL:	MOV	AX,600H
	CALL	GETATT			;GET ATTRIBUTE FOR BLANK SCREEN
	MOV	CX,0			;ERASE LINES 1-24,COLS 1-80
	MOV	DH,23
	MOV	DL,79
	INT	10H
	JMP	DOHOME

;	ERASE TO END OF LINE

ERSEOL:	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	MOV	AX,600H
	CALL	GETATT			;GET ATTRIBUTES
	MOV	CX,DX			;START AT CURRENT POS.
	MOV	DL,79			;CLEAR TO END OF LINE
	INT	10H
	JMP	SCREEN_RET

;	ERASE TO END OF SCREEN

ERSEOS:	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	MOV	AX,600H			;ERASE EOL FIRST
	CALL	GETATT
	MOV	CX,DX
	MOV	DL,79
	MOV	SAVCUR,CX
	INT	10H
	MOV	CX,SAVCUR
	MOV	DH,23
	MOV	DL,79
	CMP	CH,23			;BOTTOM LINE?
	JE 	ERS_RET			;IF SO, DONE
	INC	CH
	XOR	CL,CL
	MOV	AX,600H			;ELSE, ERASE FROM LINE+1 TO BOTTOM
	CALL	GETATT
	INT	10H
ERS_RET:JMP	SCREEN_RET

;	SAVE CURSOR POSITION

SAVCRS:	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURSOR POSITION
	MOV	CURS_SAV,DX		;SAVE IT
	JMP	SCREEN_RET

;	RESTORE CURSOR TO SAVED POSITION

RSTCRS:	MOV	DX,CURS_SAV
	JMP	SETCURS

;	CURSOR POSITION REPORT

CRSRPT:	MOV	BX,OFFSET KBDFIF
	MOV	AL,1BH			;ESC
	CALL	PTFIFO
	MOV	AL,'Y'			;'Y'
	CALL	PTFIFO
	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURRENT POSITION
	MOV	BX,OFFSET KBDFIF
	MOV	AL,DH
	ADD	AL,' '			;ROW
	CALL 	PTFIFO
	MOV	AL,DL			;COL
	ADD	AL,' '
	CALL	PTFIFO
	JMP	SCREEN_RET

;	SET REVERSE VIDEO

SETRV:	CMP	REVFLG,0
	JNE	REV_RET			;DO NOTHING IF IN REV MODE
	MOV	REVFLG,0FFH
REVERSE_IT:
	MOV	AL,FATTR		;GET ATTRIBUTES
	MOV	AH,BATTR
	MOV	CL,4
	SHR	AH,CL			;REVERSE THEM
	SHL	AL,CL
	MOV	BATTR,AL		;SAVE REVERSED ATTRIBUTES
	MOV	FATTR,AH
REV_RET:JMP	SCREEN_RET

;	SET NORMAL VIDEO

SETNV:	CMP	REVFLG,0
	JE	REV_RET			;DO NOTHING IF IN NRM VIDEO
	MOV	REVFLG,0
	JMP	REVERSE_IT
;
;	SUBROUTINE TO SHIFT CHARACTERS IN THE CURRENT LINE OVER
;	1 POSITION TO THE RIGHT FROM THE CURRENT CURSOR COLUMN.
;	THIS HAS THE EFFECT OF OPENING A SPACE TO INSERT A CHARACTER.
;	CHARACTERS PREVIOUSLY IN COLUMN 80 ARE LOST.
;
SHFTR:	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURRENT CURSOR LOC
	MOV	AL,DH
	MOV	CL,0A0H
	MUL	CL
	MOV	BX,AX			;CALC VIDEO MEM ADDRESS
	XOR	DH,DH
	SHL	DX,1
	MOV	SI,78*2
	MOV	DI,79*2
	PUSH	DS
	MOV	AX,0B800H
	MOV	DS,AX			;POINT DS AT VIDEO RAM
SHFTR_LP:
	CMP	DI,DX
	JE	SHFTR_RET
	MOV	AX,[BX+SI]
	MOV	[BX+DI],AX
	DEC	DI
	DEC	DI
	DEC	SI
	DEC	SI
	JMP	SHFTR_LP
SHFTR_RET:
	POP	DS
	RET
;
;	SUBROUTINE TO SHIFT CHARACTERS IN THE CURRENT LINE OVER
;	1 POSITION TO THE LEFT FROM THE CURRENT CURSOR COLUMN.
;	THIS HAS THE EFFECT OF DELETING A CHARACTER.
;	BLANKS ARE MOVED INTO COLUMN 80.
;
SHFTL:	MOV	AH,3
	MOV	BH,0
	INT	10H			;GET CURRENT CURSOR LOC
	MOV	AL,DH
	MOV	CL,0A0H
	MUL	CL
	MOV	BX,AX			;CALC VIDEO MEM ADDRESS
	XOR	DH,DH
	SHL	DX,1
	MOV	DI,DX
	LEA	SI,[DI+2]
	PUSH	DS
	MOV	AX,0B800H
	MOV	DS,AX
	MOV	AX,[BX+DI]
SHFTL_LP:
	CMP	SI,80*2
	JE	SHFTL_RET
	MOV	AX,[BX+SI]
	MOV	[BX+DI],AX
	INC	DI
	INC	DI
	INC	SI
	INC	SI
	JMP	SHFTL_LP
SHFTL_RET:
	MOV	AL,' '
	MOV	[BX+DI],AX
	POP	DS
	RET

;	WRITE CR, LF

WRTLFX:	MOV	AH,3			;GET CURS POS
	MOV	BH,0
	INT	10H
	MOV	AL,0AH
	CMP	DH,23			;IF LINE# < 24 THEN NORMAL LF
	JL	NORCR
	JE	SCROL24			;IF LINE# = 24 THEN SCROLL 1-24
	RET				;IF LINE# = 25 THEN IGNORE LF
SCROL24:CALL	GETATT			;GET ATTRIBUTE
	MOV	AX,601H
	MOV	CX,0
	MOV	DX,23*256+79
	INT	10H
	RET
NORCR:	INC	DH			;MOVE CURSOR TO NEXT LINE
	MOV	AH,2
	INT	10H
	RET

WRTCRX:	MOV	BH,0
	MOV	AH,3
	INT	10H			;GET CURSOR POSITION
	MOV	DL,0			;MOVE TO FIRST COL.
	MOV	AH,2
	INT	10H			;SET CURSOR THERE
	RET

;	GET ATTRIBUTE FOR FILLING BLANK SPACE

GETATT:	MOV	BH,FATTR 
	OR	BH,BATTR
	CMP	BYTE PTR REVFLG,0	;REVERSE VIDEO?
	JZ	NOTRV			;NO
	MOV	BL,0			;ELSE, REVERSE ATTRIBUTES
	MOV	CL,4
	SHR	BX,CL
	OR	BH,BL
NOTRV:	RET
;
	SUBTTL	KEYBOARD I/O
	PAGE
;
;	PROCESS KEYBOARD CHARACTERS, EMULATING THE Z-100 KEYBOARD
;
TGLFLG	DB	1			;ZEM ON/OFF TOGGLE FLAG
	DB	'ZM'			;IDENTIFIER
KBD_PROCESS:
	CMP	BYTE PTR CS:TGLFLG,0	;ZEM ON?
	JZ	KBDX			;NO, LET SYSTEM DO CALL
	CMP	AH,1			;LOOK?
	JE	LOOK_CHR
	CMP	AH,0
	JE	GET_CHR			;GET?
KBDX:	JMP	DWORD PTR CS:INT16V

;	LOOK FOR CHARACTER IN FIFO.  RETURN CHAR IF THERE, AND
;	RETURN Z FLAG IF NOT.

LOOK_CHR:
	STI
	CLD
	PUSH	ES
	PUSH	DS
	PUSH	CX			;SAVE ALL REGS
	PUSH	BX
	PUSH	SI
	MOV	SI,CS
	MOV	DS,SI
	MOV	ES,SI
;
LOOK_CHR_2:
	PUSH	AX
	MOV	BX,OFFSET KBDFIF
	CALL	LKFIFO
	JNC	LOOK_KBD
	MOV	AH,0
	CMP	AH,1			;SET NZ
	POP	SI			;TRASH SAVED AX
	JMP	SHORT KBD_RET
;
LOOK_KBD:
	MOV	AH,1
	CALL	INCHAR			;LET BIOS DO CALL
	JZ	KBD_RETA		; RTN IF NO CHR
	MOV	AH,0
	CALL	INCHAR			; IF GOT ONE - READ IT
	CALL	XLAT_CHR		; XLAT AND PUT IN FIFO
	POP	AX
	JMP	LOOK_CHR_2		;THEN LOOK FOR IT IN FIFO

;	GET CHARACTER FROM FIFO OR KEYBOARD IF FIFO EMPYT.  DECODE
;	KEYBOARD CHARACTERS DEPENDING ON Z-100 MODE SET.  IF EXPANDED
;	MODE, FOLLOWING CHARACTER(S) OF ESC SEQUENCE ARE PLACED IN
;	FIFO.

GET_CHR:STI
	CLD
	PUSH	ES
	PUSH	DS
	PUSH	CX			;SAVE ALL REGS
	PUSH	BX
	PUSH	SI
	MOV	SI,CS
	MOV	DS,SI
	MOV	ES,SI
;
GET_CHR_2:
	PUSH	AX
	MOV	BX,OFFSET KBDFIF
	CALL	GTFIFO			;CHR IN FIFO?
	JC	GET_CHR_3		; YES - RETURN WITH IT
	MOV	AH,0
	CALL	INCHAR			;READ A CHAR FROM KEYBOARD
	CALL	XLAT_CHR		;TRANSLATE IT
	POP	AX
	JMP	GET_CHR_2
GET_CHR_3:
	POP	SI			;TRASH SAVED AX
GETRET:	POP	SI
	POP	BX
	POP	CX			;RESTORE REGS
	POP	DS
	POP	ES
	IRET	 			;RETURN FROM INT
;
KBD_RETA:
	POP	AX
KBD_RET:
	POP	SI
	POP	BX
	POP	CX			;RESTORE REGS
	POP	DS
	POP	ES
;	RET	2			;RETURN FROM INT (DISCARD SAVED FLAGS)
	DB	0CAH,2,0

;	TRANSLATE CHARACTER TO Z-100 EQUIVALENT

XLAT_CHR:
	CMP	AL,0
	JE	MUST_XLAT
	MOV	BX,OFFSET KBDFIF	;POINT TO FIFO
	CMP	BYTE PTR PADFLG,0	;PAD SHIFTED
	JZ	NOTPAD			;NO
	CMP	BYTE PTR KEYEXP,0	;KEYBOARD EXPANDED?
	JNZ	NOTPAD			;NO
	CMP	AH,71			;CHAR FROM KEYPAD?
	JC	NOTPAD			;NO
	CMP	AH,82
	JNC	NOTPAD
	CMP	AL,'1'			;CHARACTER IN RANGE?
	JC	NOTPAD			;NO
	XOR	AH,AH			;ELSE, MAKE AX=CHAR
	SUB	AL,'1'			;CONVERT TO 0 BASE
	SHL	AX,1			;MPY BY 2
	MOV	SI,OFFSET SHPDTBL	;POINT TO KEYPAD TABLE
	ADD	SI,AX			;ADD OFFSET FOR KEY
	LODSB				;GET FIRST CHAR OF SEQUENCE
	CALL	PTFIFO			;PUT IT IN FIFO
	LODSB				;GET NEXT CHAR
NOTPAD:	CALL	PTFIFO			;PLACE CHR IN FIFO
	RET
MUST_XLAT:
	CMP	AH,7FH
	JLE	XLAT_INRANG		;IGNORE EXPANSION CODES > 7FH
	RET
XLAT_INRANG:
	MOV	AL,AH			;PUT SCAN CODE IN AL
	MOV	AH,0			;AX = CODE
	SHL	AX,1
	SHL	AX,1			;MUL. BY 2
	MOV	BX,AX
	CMP	KEYEXP,0		;KEYBOARD EXPANSION MODE?
	JE	EXPADR			; YES
	LEA	SI,NOEXPTBL[BX]		; NO - USE UNEXPANDED TABLE
	JMP	SHORT MOVFIF
EXPADR:	LEA	SI,EXPTBL[BX]
MOVFIF:	MOV	BX,OFFSET KBDFIF
	MOV	CX,4			;4 BYTES MAX
EXPLP:	LODSB				;GET BYTE FROM TABLE
	CMP	AL,0			;END OF ENTRY?
	JE	XLAT_CHR_RET
	CALL	PTFIFO
	LOOP	EXPLP
XLAT_CHR_RET:
	RET
;
	SUBTTL	MISC. SUBROUTINES
	PAGE
;
;	SCREEN_INIT - INITIALIZE SCREEN
;
SCREEN_INIT:
	CLD
	MOV	DI,OFFSET ZSTATE
	MOV	CX,15
	MOV	AL,0			;CLEAR STATE FLAGS
	REP	STOSB
	MOV	FATTR,7
	MOV	CURTYP,707H		;SET DEFAULT CURSOR
	MOV	AH,0
	MOV	AL,3			;80X25 COLOR
	INT	10H
	MOV	AH,1
	MOV	CH,7			;SINGLE UNDERLINE CURSOR
	MOV	CL,7
	INT	10H
	MOV	AH,5
	MOV	AL,0			;ACTIVE PAGE IS 0
	INT	10H
	MOV	AX,600H
	MOV	BH,FATTR
	OR	BH,BATTR
	MOV	CX,0
	MOV	DH,24			;CLEAR SCREEN
	MOV	DL,79
	INT	10H
	MOV	AH,2
	MOV	DX,0			;HOME CURSOR
	MOV	BH,0
	INT	10H
	IF	Z150
	MOV	DX,3DAH
	MOV	AL,SDOT
	OUT	DX,AL			;SET SINGLE DOT MODE
	ENDIF
	RET
;
;	GTFIFO	- GET A CHARACTER FROM FIFO
;
;	BX POINTS TO FIFO CONTROL BLOCK
;	CHARACTER RETURNED IN AL
;	CARRY SET IF CHARACTER PRESENT
;
GTFIFO:	PUSH	SI
	MOV	SI,4[BX]		;CURRENT OUTPUT POINTER
	CMP	SI,6[BX]		;OUT=IN?
	JE	GTF_EMPTY		; YES - FIFO EMPTY
	LODSB
	CMP	SI,2[BX]		; CHECK FOR WRAP
	JLE 	GTF_NOWRP
	MOV	SI,[BX]
GTF_NOWRP:
	MOV	4[BX],SI		;UPDATE OUTPUT POINTER
	STC
	POP	SI
	RET
GTF_EMPTY:
	CLC
	POP	SI
	RET
;
;	PTFIFO	- PUT A CHARACTER IN A FIFO
;
;	BX POINTS TO FIFO CONTROL BLOCK
;	CHARACTER TO PUT IN AL
;	CARRY SET ON FIFO FULL
;
PTFIFO:	PUSH	DI
	MOV	DI,6[BX]
	STOSB
	CMP	DI,2[BX]		;CHECK FOR WRAP
	JLE	PTF_NOWRP
	MOV	DI,[BX]
PTF_NOWRP:
	CMP	DI,4[BX]		;CHECK FOR FULL
	JE	PTF_FULL
	MOV	6[BX],DI
	CLC
	POP	DI
	RET
PTF_FULL:
	STC
	POP	DI
	RET
;
;	LKFIFO	-  CHECK FOR CHARACTER IN FIFO
;		CARRY SET IF CHARACTER PRESENT
;		FIRST CHARACTER IN FIFO RETURNED IN AL
;
LKFIFO:	PUSH	SI
	MOV	SI,4[BX]		;OUTPUT POINTER
	CMP	SI,6[BX]		; = INPUT POINTER?
	JE	LKEMPTY			;  YES - EMPTY
	LODSB				;  NO - GET CHARACTER
	STC				;       INDICATE CHR HERE
	POP	SI
	RET
LKEMPTY:
	CLC
	POP	SI
	RET

;	GET CHARACTER OR STATUS FROM KEYBOARD, BYPASSING ZEM CHECKS

INCHAR:	PUSH	DS
	PUSH	BX
	XOR	BX,BX
	MOV	DS,BX			;PUT DS IN BOTTOM SEG.
	MOV	BX,16H*4		;POINT TO INPUT VECTOR
	MOV	WORD PTR [BX],OFFSET KBDX	;ALTER TO BYPASS ZEM
	INT	16H			;MAKE CALL TO BIOS
	MOV	WORD PTR [BX],OFFSET KBD_PROCESS	;FIX VECTOR
	POP	BX
	POP	DS
	STI
	RET

;	CHECK SYSTEM CALLS HERE FOR THE FLUSH TYPE-AHEAD FUNCTION
;	FLUSH OUR OWN TYPE-AHEAD IF NEEDED.

SYS_PROCESS:
	CMP	AH,0CH			;FLUSH FUNCTION?
	JNZ	SYSX			;NO
	CMP	BYTE PTR CS:TGLFLG,0	;ZEM ON?
	JZ	SYSX			;NO, EXIT
	MOV	WORD PTR CS:KBDFIF1,OFFSET FIF	;ELSE, FLUSH TYPE-AHEAD
	MOV	WORD PTR CS:KBDFIF2,OFFSET FIF
SYSX:	JMP	DWORD PTR CS:INT21V	;AND EXIT TO SYSTEM

ENDCOD:					;END OF RESIDENT CODE
;
	SUBTTL 	LINKAGE CODE
	PAGE

;	SET UP VECTORS AND LEAVE ZEMULATOR IN MEMORY

BEGIN:	MOV	AH,15
	INT	10H			;READ VIDEO STATE
	CMP	AH,15			;AH CHANGED?
	JNZ	GDSYS			;YES, GOOD SYSTEM
	MOV	DX,Offset BSMSG
	MOV	AH,9
	INT	21H			;ELSE, SAY "BAD SYSTEM"
	INT	20H			;AND EXIT
GDSYS:	XOR	AX,AX
	MOV	DS,AX			;POINT TO BOTTOM SEGMENT
	MOV	SI,16H*4		;POINT TO INT 16 VECTOR
	PUSH	SI			;SAVE ADDRESS
	LES	DI,DWORD PTR [SI]	;GET ROUTINE ADDRESS
	CMP	WORD PTR ES:-2[DI],'MZ'	;TEST FOR ZEM ALREADY IN
	JZ	ITSIN
	MOV	DI,OFFSET INT16V	;SAVE VECTOR HERE
	PUSH	CS
	POP	ES			;PUT ES HERE
	CLD
	MOVSW				;MOVE VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET KBD_PROCESS	;ALTER VECTOR TO HERE
	MOV	2[SI],CS
	MOV	SI,10H*4		;POINT TO INT 10 VECTOR
	PUSH	SI
	MOV	DI,OFFSET INT10V	;PUT IT HERE
	MOVSW
	MOVSW				;MOVE VECTOR
	POP	SI
	MOV	WORD PTR [SI],OFFSET SMART_TERM	;ALTER VECTOR
	MOV	2[SI],CS
	MOV	SI,21H*4		;POINT TO INT 21 VECTOR
	PUSH	SI
	MOV	DI,OFFSET INT21V	;PUT IT HERE
	MOVSW
	MOVSW				;MOVE VECTOR
	POP	SI
	MOV	WORD PTR [SI],OFFSET SYS_PROCESS	;ALTER VECTOR
	MOV	2[SI],CS
	PUSH	CS
	POP	DS			;FIX DS
	CALL	SCREEN_INIT		;**INITIALIZE SCREEN**
	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;SIGN ON
	MOV	DX,OFFSET ENDCOD+1	;TERMINATE AND STAY RESIDENT
	INT	27H
ITSIN:	PUSH	CS
	POP	DS			;ENSURE DS IS HERE
	MOV	DX,OFFSET INMSG
	MOV	AH,9
	INT	21H			;SAY "ZEM ALREADY IN"
	INT	20H			;AND EXIT

SIGNON	DB	13,10,'ZEMulator Z-100 Environment Emulator, Version 1.0$'
INMSG	DB	'ERROR -- ZEMulator already installed.$'
BSMSG	DB	13,10
	DB	'ERROR -- Incompatible computer system.  '
	DB	'Can',27H,'t run ZEMulator.$'
;
ZEM	ENDS
	END	START
            