 	Title	MS-DOS 2.x Menu System
	page	,132
;
;	MS-DOS 2.x Menu System  -  Main Program
;
;	Author: R. A. Metz		Date: 10/10/83
;
;	MODIFIED BY P. SWAYNE, HUG  07-NOV-84  29-JAN-85
;		MENU.MNU FILE CONTAINS IBM GRAPHIC CHARACTERS, WHICH
;			 ARE TRANSLATED TO Z-100 CHARACTERS, IF NECESSARY.
;		AUTOMATICALLY DETERMINES COMPUTER TYPE (100 OR 150)
;		FOR Z-150 OPERATION, RETAINS MODE AND CURSOR TYPE,
;			AND RESTORES THEM UPON ENTRY TO USER FUNCTION.
;		REPORTS CORRECT DRIVE ON CHANGE PROMPT.
;
;	This is the main program of the MS-DOS 2.x menu system
;	which runs either on a Z-150 (or IBM PC) or a Zenith Z-100.
;  	It is meant that this program be invoked from the 
;	Autoexec.bat file upon system boot.  It will then remain
;	active forever (a means is provided to get out of the 
;	menu system but this means will not be generally known
;	to the user community).
;
;	Other pieces of this system are as follows:
;
;	"MENU.MNU"	- file containing the menu to be displayed
;			  upon system start.  Each disk (or directory) 
;			  containing programs to be run under the menu system 
;			  should also contain a MENU.MNU file.
;	"MENU.RAW"  	- file containing menu definitions.  This file
;			  is edited by the user with a text editor to
;			  produce the definitions for a given menu.
;			  The resulting file is processed by the program
;			  MAKMENU.COM to produce a menu file of type
;			  MENU.MNU.
;	"MAKMENU.COM"  -  Program to create a menu file (e.g. MENU.MNU)
;			  from a definition file (e.g. MENU.RAW).
;
;	"AUTOEXEC.BAT"  - Sets up the environment necessary to run the 
;			  menu system and executes the menu program.
;			  Normally done in AUTOEXEC.BAT are:
;				1) - Copy COMMAND.COM to a memory disk
;				     for faster execution (optional).
;				2) - Set COMSPEC, PATH, and BASE parameters
;				     in the environment.
;				     Set COMSPEC if COMMAND.COM is moved to
;				     a memory disk.  PATH must be set as its
;				     value is used to get all program files.
;				     BASE is normally set only in winchester
;				     systems (see below).
;				3) - Set the current directory to the proper
;				     value if required.
;				4) - Load all memory resident features:
;				     print screen utilities, print spooler,
;				     proper display fonts, communications
;				     programs, etc.
;				5) - Get system time and date.
;				6) - Execute the menu program.
;
;			  Note:  For a simple automatic menu driven system,
;			  such as a game disk, only item 6 is needed in the
;			  AUTOEXEC.BAT file.
;
;	The format of a menu file and a menu definition file are 
;	explained elsewhere in the menu system source and
;	documentation.
;
;	This program will read the menu file (MENU.MNU upon invocation),
;	display the menu mask expanding any graphic characters present
;	in the image, highlight (reverse video) the first field, and 
;	await operator input.  Only certain keys on the keyboard are
;	active (all else is ignored):
;
;     	   Help or F1      -  Display the help information associated
;			      with the current highlighted entry.
;			      When the operator is finished reading
;			      the info, he presses any key to return
;			      to the menu.
;      	   Cursor up/down  -  Move the highlighted field forward or
;	          rt/lft      backward.
;	   Return or Enter -  Select the highlighted entry.
;	   Home		   -  If an environment parameter 'BASE'
;			      exists, its value will be a disk/directory
;			      pathname which will be the 'home base'  
;			      directory.  The disk/directory is then
;			      switched to as in code 5 below.  This base
;			      directory will normally contain a menu
;			      containing type 5 command entries which
;			      route control to separate directories 
;			      containing individual applications systems.
;			      If the 'BASE' parameter does not exist, a
;			      diskette-based system is assumed and
;	          	      the operator is asked to insert a system
;			      disk in drive A and to press any key
;			      to continue.  When the key is pressed,
;			      the menu file "MENU.MNU" is read and 
;			      displayed.  This is to allow for 
;			      changing program disks in a diskette-
;			      based system without exiting the menu.
;
;	Upon selection of a menu item, the command information from
;	the menu file is processed.  This information defines the 
;	operation to be taken upon item selection.  Any of 4 things
;	occur at this point depending on the command type code for the
;	item:
;
;       Code =  0 - The item is a sub-menu.  In this case, the command
;		    field contains the name of a sub-menu file.  This 
;		    file is read and the menu defined in that file is 
;		    displayed.
;		1 - The item is a program name (COM or EXE file).  The 
;		    command field contains the program name (including
;		    extension) followed by any parameters required.  This 
;		    program loads and executes the requested program.
;		    When that program terminates, this program is re-entered
;		    and the current menu is re-displayed.
;		    The original default disk/directory is used to access
;		    the program file and the specified program name must
;		    not include the disk/directory pathname.
;		2 - The item is a command line.
;		    COMMAND.COM is loaded and the command line is passed
;		    to it for execution.  When the command is processed and 
;		    COMMAND.COM returns control to this program, the
;		    user is prompted to type return to return to the 
;		    menu.  This is to allow the user to observe any
;		    information displayed by the command before the
;		    re-displayed menu wipes out the screen.
;		3 - The item is a manual entry request.  The command field
;		    is ignored.  The screen is blanked and a prompt is 
;		    issued.  The command field of the command line entered
;		    by the user is checked to see if a corresponding file
;		    with a .COM or .EXE extension exists.  If so, the line
;		    is processed as in type 1 above, otherwise the command
;		    line is passed to COMMAND.COM for processing as in
;		    type 2 above.  When control returns, the prompt is 
;		    re-issued.  If the user types a return only (null command
;		    line), the current menu is re-displayed.
;		4 - This code is exactly like code 1 above except that the
;		    disk/directory pathname is explicitly stated so programs
;		    in other directories may be accessed.
;		5 - This is a special code used to internally switch
;		    default disk/directories.  Used primarily in a
;		    Winchester disk environment, this code allows the
;		    equivalent of switching program diskettes by switching
;		    to different program directories.  The command line for 
;		    this type code contains the full pathname of the 
;		    disk/directory to become the new system default.
;
;	Code is included in this program to process keyboard/CRT I/O
;	from/to either an IBM PC or equivalent (e.g. Zenith Z-150), or
;	a Zenith Z-100.  The first byte in the menu file determines
;	which of the 2 computers is being used.
;	This program will run without modification on either system.
;
	subttl	data and buffers
	page
HICODE	EQU	0FH			; HI-LIGHTING CODE WHEN USED ON
;					; A Z-150.  USE 0FH FOR INTENSE WHITE,
;					; OR 70H FOR REVERSE VIDEO.
include macros.asm
dummy	segment	at 0			; define offsets in menu image
;
ent	struc				; menu item entry structure
dislin	dw	0			; offset to display line
cmdlin	dw	0			; offset to command line
hlpinfo	dw	0			; offset to help info
ent	ends
;
	org	0
line24	label	byte
;
	org	2
menu_buf	label	byte
					; THIS BYTE RESERVED
	org	3
n	label	byte			; # items in menu
	org	4
item	label	ent  			; 1st menu entry is here
dummy	ends
;
	prog_header	menu
;
	mov	sp,offset BA.stack
	push	ax			; adjust stack pointer
	jmp	begin
;
;	data and buffers
;
menufcb	db	33 dup (0)		; active menu fcb
progfcb	db	33 dup (0)
progname	db	30 dup (?)	; program name string
;
cmd_buf		db	128 dup (?)	; command line buffer
cmd_buf_2       db	128 dup (?)
cmd_line	db	128 dup (?)
swcnt		equ	3
swch_msg	db	'/C '		; xqt cmd line swtch (COMMAND.COM)
cur_dir		db	64 dup (0)	; default directory
path_parm	db	64 dup (0)	; 'PATH' parm
comspec_parm	db	32 dup (0)	; 'COMSPEC' parm
		db	0
base_parm	db	32 dup (0)	; 'BASE' parm
;
prog_blk	label	word		; program loader block
	dw	0			; environment address
	dw	buf,0			; line buffer address
	dw	fcb1,0			; 1st fcb parm address
	dw	fcb2,0			; 2nd fcb parm address
;
cmd_blk		label	word		; COMMAND.COM prog load block
	dw	0
	dw	cmd_buf,0
	dw	fcb1,0
	dw	fcb2,0
;
DISTYPE		DB	0		; DISPLAY TYPE
CURTYPE		DW	607H		; CURSOR TYPE
current_type	db	0
spsave		dw	0
save_int	dw	0
systyp		db	"Z"
GRPHFLG		DB	0
typset		db	0
menu_mem	dw	0
res_flag	db	0
env_mem		dw	0
;
basemenu	db	0,"MENU    MNU"
;
com	db	'COM'
exe	db	'EXE'
path	db	5,'PATH='
comspec	db	8,'COMSPEC='
base	db	5,'BASE='
curlin	db	0			; current menu line #   
line_24	db	"7 "			; screen address - line 24
;
;	Intrinsic command table
;
intrinsic	label byte
	db	4,'DIR '  
	db	4,'DEL '  
	db	5,'COPY ' 
	db	4,'CLS ' 
	db	5,'DATE ' 
	db	5,'TIME ' 
	db	6,'ERASE ' 
	db	5,'TYPE ' 
	db	4,'VER ' 
	db	4,'VOL ' 
	db	4,'REN ' 
	db	7,'RENAME ' 
	db	6,'RMDIR ' 
	db	6,'MKDIR ' 
	db	3,'MD ' 
	db	3,'RD ' 
	db	0
;
;   messages
;
cr	equ	0dh
lf	equ	0ah
IDSTR	DB	27,'Z',13,'  ',13,'$'

badmenu	db	cr,lf,"Menu file not found."
	db	cr,lf,lf,"If you are operating with a diskette"
	db	cr,lf,"system, ensure that a diskette con-"
	db	cr,lf,"taining the proper menu file is in"
	db	cr,lf,"drive "
CUR_DISK1	DB	"A:."
	db	cr,lf,lf,"Hit the SPACE bar when ready."
	db	cr,lf,lf,"Else hit RETURN to abort.$"

progerr	db	cr,lf,"Program load error - $"
waitkey	db	cr,lf
waitmsg	db	"Type any key to return to the menu...$"
DSKMSG	DB	"Ensure that the correct disk is in drive "
CUR_DISK	DB	"A:."		; DEFAULT DISK
	db	cr,lf,"Type any key to continue...$"
allocer	db	cr,lf,'Memory allocation error.$'
bad_version	db	cr,lf
	db	"Bad DOS version - must be 2.0 or better."
lfmsg	db	cr,lf,"$"
;
abend	db	cr,lf
	db	'Error in loading COMMAND.COM.$'
;
end_msg	db	cr,lf,lf
	db	'Menu program terminated.'
	db	cr,lf,'$'
warn_msg	db	cr,lf
	db	'Warning - at least one program executed during this'
	db	cr,lf
	db	'session has remained in memory.  Memory has been'
	db	cr,lf
	db	'fragmented.  Any program which is to remain memory'
	db	cr,lf
	db	'resident should be included in the AUTOEXEC.BAT file'
	db	cr,lf
	db	'for loading after boot.'
	db	cr,lf,'$'
;
	subttl	code section - initialize
	page
begin:
	get_ver				; get DOS version
	cmp	al,2
	jae	vers_ok			; must be 2.00 or better
	display bad_version
	int	20h
exit_menu:
	cmp	menu_mem,0
	je	no_mem_ret
	mov	es,menu_mem
	svc	49h			; free mem block if allocated
no_mem_ret:
	cmp	env_mem,0
	je	no_env_mem
	mov	es,env_mem
	svc	49h			; free env mem if any
no_env_mem:
	mov	ax,0
	mov	es,ax
	mov	ax,save_int		; restore int 68h trap
	mov	es:01a0h,ax
	cmp	res_flag,0		; see if any progs remained in mem
	je	disp_end		;  none
	display	warn_msg		; warn user about prog remaining resident
disp_end:
	display	end_msg
	sys_term 0			; exit to DOS

vers_ok:DISPLAY	IDSTR			; ASK TERMINAL TYPE
	MOV	CX,50			; SET A COUNTER
WFCHR:	MOV	AH,0BH
	INT	21H			; TEST FOR REPLY
	OR	AL,AL
	JNZ	Z100			; SYSTEM IS Z-100
	LOOP	WFCHR			; ELSE, TRY AGAIN
	MOV	Byte Ptr systyp,'I'	; TIMED OUT, IT'S A Z-150
	CALL	GETCON			; GET CONSOLE DATA
	JMP	SHORT GOTTYP
Z100:	MOV	Byte Ptr systyp,'Z'	; IT'S A Z-100
GOTTYP:	MOV	AX,0C00H
	INT	21H			; FLUSH INPUT BUFFER
	mov	ax,0
	mov	es,ax			; see if already here
	mov	ax,es:01a0h
	cmp	ax,'MU'
	jne	menu_begin
	sys_term 0			; terminate if already in mem
menu_begin:
	mov	save_int,ax
	mov	word ptr es:01a0h,'MU'	; mark menu here
;
	mov	ax,ds
	mov	es,ax
	mov	prog_blk[4],ax		; segment fixups - prog_blk
	mov	prog_blk[8],ax
	mov	prog_blk[12],ax
	mov	cmd_blk[4],ax
	mov	cmd_blk[8],ax
	mov	cmd_blk[12],ax
;
	mov	bx,offset BA.endcod
	mov	cl,4
	shr	bx,cl
	inc	bx			; free mem behind me
	svc	4ah			
;
	mov	bx,8
	svc	48h			; get 128 bytes for child's env
	jnc	got_env_mem
	jmp	mem_alloc_err
got_env_mem:
	mov	env_mem,ax
	mov	prog_blk,ax		; set addr to prog parm blks
	mov	cmd_blk,ax
	mov	si,env_seg
	mov	di,ax
	call	cpy_env			; copy my environment to it
;
reset_menu_system:
	current_disk
	ADD	AL,'A'			; ADD ASCII
	mov	cur_disk,al		; SET current disk
	MOV	CUR_DISK1,AL
;
	mov	si,offset cur_dir
	mov	dl,0
	svc	47h			; get current directory
;
	mov	si,offset path
	mov	bx,offset path_parm
	call	get_env_parm		; get 'PATH' parm
;
	mov	si,offset comspec
	mov	bx,offset comspec_parm
	call	get_env_parm		; get 'COMSPEC' parm
;
	mov	si,offset base
	mov	bx,offset base_parm
	call	get_env_parm		; get 'BASE' parm
;
menu_reset:
	push	ds			; ensure es=ds
	pop	es
	mov	si,offset basemenu
	mov	di,offset menufcb
	mov	cx,12
	rep	movsb			; base menu is current menu
;
newmenu:
	cmp	menu_mem,0		; any mem to free?
	je	opn_mnu_fil		;  no
	mov	es,menu_mem		;  yes - free it
	svc	49h
	jc	mem_alloc_err
	mov	menu_mem,0
opn_mnu_fil:
	open    menufcb			; open menu file
	cmp	al,0
	je	menuok
mnuerr:
	call	screen_xit		; clear screen
	display badmenu			; ask user to put in proper program disk
	dir_console_in
	cmp	al,0dh
	jne	newmenu			; if not cr - try the open again
	jmp	exit_menu
menuok:
	mov	bx,word ptr menufcb+16
	add	bx,2
	mov	cl,4
	shr	bx,cl			; calc mem needed
	inc	bx
	svc	48h			; allocate mem required for memu file
	jnc	read_menu
mem_alloc_err:
	display allocer			; allocation error - abort
	jmp	exit_menu
;
read_menu:
	mov	menu_mem,ax		; save allocated mem address
	push	ds
	mov	ds,ax
	mov	es,ax
	set_dta	menu_buf		; set dta to allocated block
	pop	ds
;
	mov	ax,word ptr menufcb+16
	mov	word ptr menufcb+14,ax	; set recsiz=filsiz
	mov	menufcb+32,0
	read_seq menufcb		; read menu file
	cmp	al,1
	je	mnuerr			; error if no data
	mov	ax,word ptr line_24
	mov	word ptr es:line24,ax
;
	subttl	Display menu & decode input
	page
display_first:
	mov	curlin,0		; current menu item=0
display_current:
	call	display_menu		; display the menu
display_item:
	call	screen_reverse
	call	item_display		; select current item
	call	screen_normal
read_key:
	dir_console_in			; read a character from keyboard
	cmp	systyp,"Z"		; decoded by cpu type
	jne	decode_ibm
	mov	bx,offset zkey		; Z-100 key table
chklp:
	cmp	al,[bx]	
	jne	chknxt
	mov	ax,1[bx]		; vector to processor
	jmp	ax			; enter processor routine
chknxt:
	add	bx,3
	cmp	byte ptr [bx],0		; check for end of table
	je	read_key		; ignore if at end
	jmp	chklp
;
decode_ibm:
	cmp	al,0			; extended code present?
	je	ibm_ext
	cmp	al,0dh			; cr?
	jne	read_key		;  no - ignore
	jmp	docr			;  yes - select entry
ibm_ext:
	dir_console_in			; read extended code
	mov	bx,offset ikey  	; IBM key table
	jmp	chklp
;
zkey	label	byte			; Z-100 key table
	db	0a5h			; cursor up
	dw	offset doup
	db	0a6h			; cursor down
	dw	offset dodwn
	db	0a7h			; cursor right
	dw	offset dodwn
	db	0a8h			; cursor left
	dw	offset doup
	db	0a9h			; home
	dw	offset dohome
	db	0dh			; return
	dw	offset docr
	db	08dh			; enter
	dw	offset docr
	db	095h			; help
	dw	offset dohelp
	db	097h			; F1
	dw	offset dohelp
	db	0e0h			; s(F10)
	dw	offset getout
	db	0			; end of table
;
ikey	label	byte			; IBM PC code table
	db	72			; cursor up
	dw	offset doup
	db	80			; cursor down
	dw	offset dodwn
	db	77			; cursor right
	dw	offset dodwn
	db	75			; cursor left
	dw	offset doup
	db	71			; home
	dw	offset dohome
	db	59			; F1
	dw	offset dohelp
	db	84			; s(F1)
	dw	offset dohelp
	db	93			; s(F10)
	dw	offset getout
	db	0			; end of table
;
	subttl	Keystroke processors
	page
;
;	Getout  -  special menu exit
;
getout:					; shift F10
	call	screen_xit
	jmp	exit_menu
;
;	highlight previous item
;
doup:					; cursor up/left
	call	item_display		; current item to normal display
	dec	curlin
	jl 	doup_wrap
	jmp	display_item
doup_wrap:				; wrap to last entry
	mov	al,es:n
	dec	al
	mov	curlin,al
	jmp	display_item
;
;	highlight next item
;
dodwn:					; cursor down/right
	call	item_display		; current item to normal
	inc	curlin
	mov	al,es:n			; check for wrap
	dec	al
	cmp	al,curlin
	jb	dodwn_wrap
	jmp	display_item
dodwn_wrap:				; wrapped - go to top
	mov	curlin,0
	jmp	display_item
;
;	change program disks
;
dohome:					; home
	cmp	base_parm,0		; is 'BASE' parm present?
	je	req_newdisk		;  no - request disk change
	mov	si,offset base_parm
	push	ds
	pop	es			; es=ds
	call	swap_dir		; switch to base directory
	jmp	reset_menu_system
req_newdisk:
	call	screen_init		; clear screen
	display	dskmsg			; ask for disk change 
	dir_console_in			; wait for keystroke
	jmp	menu_reset		; go display base menu
;
;	display help info - current item
;
dohelp:					; help/F1
	call	screen_init		; clear screen first
	call	item_display_1		; display item name w/o address
	DISPLAY	LFMSG			; CRLF AFTER ITEM
	call	item_addr		; get addr of item entry
	mov	si,es:[bx].hlpinfo
	add	si,offset menu_buf
display_help:
	mov	al,es:[si]
	inc	si
	cmp	al,0
	je	help_wait		; check for end of msg
	display_chr 	al		; echo chr to screen
	jmp	display_help
help_wait:				; display wait msg
	mov	bx,offset line24
	call	screen_addr		; address line 24
	display waitmsg			; display wait msg
	dir_console_in			; wait for keyboard entry
	jmp	display_current		; re-display current menu
;
;	select current item
;
docr:					; return/enter
	call	item_addr		; get addr of item entry
	mov	si,es:[bx].cmdlin	; address of command
	add	si,offset menu_buf
	mov	al,es:[si]		; command type
	inc	si
	mov	current_type,al
	and	al,7
	mov	ah,0
	shl	ax,1			; cvt to word offset
	mov	bx,ax
	mov	di,offset cmd_line
	push	ds
	push	es			; swap ds/es
	pop	ds
	pop	es
	mov	ah,0
docr_lincpy:
	lodsb				; copy command line to local segment
	stosb
	cmp	al,0
	jne	docr_lincpy
	cmp	ah,0			; copy 2 ASCII strings
	jne	lincpy_done
	inc	ah
	jmp	docr_lincpy
lincpy_done:
	push	es			; ds=es=cs
	pop	ds
	mov	si,offset cmd_line
	jmp	word ptr cmdtbl[bx]
;
cmdtbl:	
	dw	offset submenu		; command is a sub menu
	dw	offset loadprog		; command is a program 
	dw	offset xline		; execute command line
	dw	offset manmode		; manual mode
	dw	offset loadset		; explicit program request
	dw	offset swap     	; swap disk/directories
	dw	offset display_current
	dw	offset display_current
;
; 	process sub-menu
;
submenu:
	call	chg_default		; set requested default disk/dir
	MOV	DI,OFFSET MENUFCB	; COMMAND IS SUB-MENU FILE
	MOV	AX,2902H
	INT	21H			; SO PARSE NAME
	jmp	newmenu			; process it
;
;	process manual mode command
;
manmode:
	call	chg_default		; set requested default disk/dir
	call	screen_xit 		; clear the screen
manloop:
	MOV	SP,OFFSET BA.STACK	; FIX STACK
	DISPLAY	LFMSG			; NEW LINE
	current_disk			; get current default disk
	add	al,"A"			; prompt character
	display_chr	al		; display it
	display_chr	">"
	display_chr	">"
;
	MOV	DX,OFFSET MANLOOP
	MOV	AX,2523H
	INT	21H			; SET CONTROL-C EXIT
	get_string	126,buf
	display	lfmsg
	cmp	buf+1,0			; null entry returns to menu
	jne	chk_execom
	call	reset_default		; reset to original defaults
	jmp	display_current
chk_execom:				; check for exe of com file
	mov	si,offset buf
	mov	di,offset cmd_buf
	mov	cx,80h			; copy to cmd_buf
	rep	movsb
	mov	di,offset progfcb
	mov	cx,33
	mov	al,0			; clear progfcb
	rep	stosb
;
	parse	cmd_buf+2,progfcb
	cmp	progfcb+1,' '		; was progname entered?
	jne	locfile			;  yes - try to find program file
	cmp	progfcb,0		;  no - reset default drive
	je	manloop
	dec	progfcb
	select_disk	progfcb
	jmp	manloop			;  or xqt command type codes
;
locfile:
	push	si
	mov	si,offset intrinsic
loc_intrnal:				; check for intrinsic command
	mov	di,offset progfcb+1
	lodsb
	cmp	al,0
	je	chk_for_file		; no match - find COM or EXE file
	mov	cl,al
	xor	ch,ch
	mov	dx,0
loc_loop:
	lodsb
	cmp	al,[di]
	je	loc_nxtchr
	inc	dx
loc_nxtchr:
	inc	di
	loop	loc_loop
	cmp	dx,0
	je	cmdx			; match - command.com executes it
	jmp	loc_intrnal
;
chk_for_file:
	set_dta	cmd_buf_2
chk_pfile:
	mov	di,offset progfcb+9
	mov	si,offset com		; check for .com file
	mov	cx,3
	rep	movsb
	search_first	progfcb
	cmp	al,0
	je	do_prog
	mov	si,offset exe
	mov	di,offset progfcb+9
	mov	cx,3
	rep	movsb			; check for .exe file
	search_first	progfcb
	cmp	al,0
	je	do_prog
cmdx:
	pop	dx
	jmp	xcmd			; neither - let command.com execute it
do_prog:
	pop	dx
	mov	di,offset progname
	mov	si,offset progfcb	; build pathname at progname
	lodsb
	add	al,'@'
	stosb				; drive letter
	mov	al,':'
	stosb				; ':'
	mov	cx,8
cpy_pname:
	lodsb
	cmp	al,' '			; name field
	je	set_ext
	stosb
	loop	cpy_pname
set_ext:
	mov	al,'.'
	stosb				; '.'
	mov	si,offset progfcb+9
	mov	cx,3
	rep	movsb			; extension
	mov	al,0
	stosb				; null terminator
;
	call	prog_xqt
exit_manual:
	CALL	GETCON			; GET CONSOLE DATA
	cmp	current_type,'3'
	jne	wait_inp
	jmp	manloop			; if in manual mode - remain so
wait_inp:
	display	waitkey
	call	reset_default		; reset to original defaults
	dir_console_in			; wait for key-in before menu display
	jmp	display_current
;
xcmd:
	call	cmd_xqt			; load COMMAND.COM to execute it
	jmp	exit_manual
;
;	execute command line
;
xline:
	call	chg_default		; set to requested default disk/dir
	call	screen_xit		; clear the screen
	mov	buf,7eh
	mov	buf+1,-1  
	mov	di,offset buf+2
xline_copy:
	lodsb
	stosb
	inc	buf+1			; bump chr count
	cmp	al,0dh			; copy command line to buf
	jne	xline_copy
	jmp	xcmd      		; load command.com to execute it
;
;	command line is an explicit program name
;
loadset:
	call	set_prog		; init for prog load
	jmp	prog_copy		; bypass 'PATH' copy
;
;	command line is a program name
;
loadprog:
	call	set_prog
	push	si
	mov	si,offset path_parm
path_copy:				; copy current environment path to cmd line
	lodsb
	cmp	al,0
	je	path_done
	stosb
	jmp	path_copy
path_done:
	mov	al,'\'			; ensure '\' separator exists
	dec	di
	cmp	al,es:[di]
	je	path_sep_ok
	inc	di
	mov	es:[di],al
path_sep_ok:
	inc	di
	pop	si
prog_copy:
	lodsb				; copy program name to progname
	cmp	al,' '			;  (space is separator)
	je	name_fin
	cmp	al,0dh			;  -or cr-
	je	name_fin
	stosb
	jmp	prog_copy
name_fin:
	dec	si			; leave si pointing to separator
	mov	al,0			; 0 is string terminator
	stosb
;
	mov	dx,si			; save parm addr
	call	prog_xqt
	PUSHF
	CALL	GETCON			; GET CONSOLE VALUES LEFT
	POPF
	jc	wait_inpj 		; if error pause for key-in
	call	reset_default		; reset default disk/dir
	jmp	display_current
wait_inpj:
	jmp	wait_inp
;
;	command line is a 'swap' command to switch disk/directories
;
swap:
	call	chg_default		; dummy call to skip front part of command
	call	swap_dir
	jmp	reset_menu_system
;
	subttl	Subroutines
	page
set_prog	proc	near
	call	chg_default		; set requested default disk/dir
	call	screen_xit		; clear screen
;
	mov	di,offset fcb1
	mov	cx,0a4h			; clear header
	mov	al,0
	rep	stosb
;
	mov	di,offset progname
	ret
set_prog	endp
;
prog_xqt	proc	near		; load & xqt program
;
;	dx points to parameters
;	pathname of program at progname
;
	mov	si,dx
	MOV	DI,OFFSET FCB1		; POINT TO FCB1
	MOV	AX,2900H
	INT	21H			; PARSE FIRST PARAMETER
	MOV	DI,OFFSET FCB2
	MOV	AX,2900H
	INT	21H			; PARSE SECOND PARAMETER
noparms:
	mov	si,dx
	mov	di,offset buf+1		; copy parm list to buf
	mov	buf,0
parmcpy:
	lodsb
	cmp	al,cr			; stop at cr
	je	cpyfin
	stosb
	inc	buf
	jmp	parmcpy
cpyfin:
	stosb				; put cr in buffer
;
	MOV	DX,OFFSET PROG_XQTX
	MOV	AX,2523H
	INT	21H			; SET CONTROL-C EXIT
	mov	spsave,sp
	mov	dx,offset progname
	mov	bx,offset prog_blk	; execute the program
	mov	al,0
	svc	4bh
PROG_XQTX:
	CLI
	mov	bx,cs
	mov	ds,bx
	mov	es,bx			; restore segment regs
	mov	ss,bx
	mov	sp,spsave
	STI
	jc	prog_err
	svc	4dh			; get child's rtn code
	cmp	ah,3			; see if prog stayed in mem
	jne	prog_xqt_rtn
	inc	res_flag		; it did - set resident flag
prog_xqt_rtn:
	clc
	ret				; return 
prog_err:
	display progerr    		; load error - display msg
	stc				;  ensure error flag set
	ret
prog_xqt	endp
;
;	cmd_xqt		-  load command.com to execute the
;			   command in buf
;
cmd_xqt	proc	near	
	mov	di,offset cmd_line
	mov	si,offset comspec_parm
cmdx_cpyspec:
	lodsb				; copy COMSPEC to command line
	stosb
	cmp	al,0
	je	cmdx_cpyswtch
	inc	cmd_buf
	jmp	cmdx_cpyspec
;
cmdx_cpyswtch:
	mov	di,offset cmd_buf+1
	mov	cl,swcnt
	mov	cmd_buf,cl
	xor	ch,ch
	mov	si,offset swch_msg	; /C switch to command line
	rep	movsb
	mov	si,offset buf+1
	lodsb
	mov	cl,al
	add	cmd_buf,al
	mov	ch,0
	inc	cx			; include CR at end
	rep	movsb			; build command file buffer
	xor	al,al 
	stosb
;
	mov	di,offset fcb1
	mov	cx,0a4h
	rep	stosb			; clear header
;
	MOV	DX,OFFSET CMD_XQTX
	MOV	AX,2523H
	INT	21H			; SET CONTROL-C EXIT
	mov	spsave,sp
	mov	dx,offset cmd_line	; pathname of COMMAND.COM
	mov	bx,offset cmd_blk
	mov	al,0
	svc	4bh			; load and execute command.com
CMD_XQTX:
	CLI
	mov	bx,cs
	mov	ds,bx
	mov	es,bx			; restore seg regs
	mov	ss,bx
	mov	sp,spsave
	STI
	jc	load_err
;
	ret				; return from cmd_xqt
;
load_err:
	display	abend			; handle error - fatal
	jmp	exit_menu
;
cmd_xqt	endp
;
;
;	item_addr		- get address of item entry in menu header
;
;	calling sequence:
;
;	(loc curlin contains the item #)
;	CALL	ITEM_ADDR
;
;	register bx will contain the entry address on return
;
item_addr	proc	near
	mov	al,size item
	mul	curlin
	mov	bx,offset item
	add	bx,ax
	ret
item_addr	endp
;
;	item_display	- display an item at item's address
;
;	calling sequence:
;
;	CALL	ITEM_DISPLAY 		; item # in curlin
;
;	no registers are preserved
;
item_display	proc	near
	call	item_addr		; get address of item
	mov	si,es:[bx].dislin	; address of display info
	lea	bx,es:menu_buf[si]
	call	screen_addr		; 1st 2 bytes are item's addr
	call	item_display_1		; now display text
	ret
item_display	endp
;
;	item_display_1		- display item text
;
;	calling sequence:
;
;	CALL	ITEM_DISPLAY_1		; item # in curlin
;
;	no registers are preserved
;
item_display_1	proc	near
	call	item_addr		; get item's address
	mov	si,es:[bx].dislin	; addr of display info
	add	si,offset menu_buf+2	; skip over address
disloop:
	mov	al,es:[si]
	inc	si
	cmp	al,0			; null terminates string
	je	itm_dis_ret
	mov	dl,al
	call	screen_out
	jmp	disloop
itm_dis_ret:
	ret
item_display_1	endp
;
	subttl 	Screen I/O routines
	page
;
;	Miscellaneous subroutines for the MS-DOS 2.x menu program.
;
;
;	reset default disk/dir after command execution
;
reset_default	proc	near
	mov	al,cur_disk
	sub	al,'A'
	select_disk al			; reset current drive
	mov	dx,offset cur_dir
	svc	3bh			; reset current directory
	ret
reset_default	endp
;
;	change default disk/directory 
;
chg_default	proc	near		; 
	cmp	byte ptr [si],0		; return if no default specified
	je	chg_def_eof
	cmp	byte ptr 1[si],':'	; check for ne disk ID
	jne	chg_def_dir
	lodsb	
	sub	al,'A'
	select_disk al			; set requested default disk
	lodsb
	cmp	byte ptr [si],0
	je	chg_def_eof
chg_def_dir:
	mov	dx,si
	svc	3bh			;  then change default
chg_def_eof:
	lodsb				; find end of string
	cmp	al,0
	jne	chg_def_eof
chg_def_ret:
	ret
chg_default	endp
;
;	swap disk/directories (permanent)
;
;	Called with si pointing to ASCII string with new disk/directory
;	name.
;
;
swap_dir	proc	near
	push	si
swap_dir_ckcr:				; cvt any cr's in string to nul
	lodsb
	cmp	al,0
	je	swap_dir_eos
	cmp	al,0dh
	jne	swap_dir_ckcr
	dec	si
	xor	al,al
	mov	[si],al
swap_dir_eos:
	pop	si
	push	si
	call	chg_default		; chg default disk/directory
	mov	di,offset path
	mov	si,env_mem
	call	del_env_parm		; delete PATH env parm
	mov	si,offset path
	mov	di,env_mem
	pop	bx
	call	add_env_parm		; add PATH parm - val is new disk/dir
	ret
swap_dir	endp
;
;	delete an environment parameter
;
;	called with:
;		si=environment addr
;		di=parameter name address (byte count+string)
;
del_env_parm	proc	near
	mov	cl,[di]
	inc	di
	push	ds
	mov	ds,si
	xor	si,si
	xor	ch,ch
	push	cx
	push	di
del_env_parm_find:
	pop	di
	pop	cx
	push	cx
	push	di
	cmp	byte ptr [si],0		; end of list?
	je	none_to_del
	push	si
	rep	cmpsb			; is this th one?
	je	do_parm_del		;  yes
	pop	si
find_parm_end:				;  no - find end of this parm
	lodsb
	cmp	al,0
	jne	find_parm_end
	jmp	del_env_parm_find
do_parm_del:
	lodsb
	cmp	al,0			; find begin of nxt parm
	jne	do_parm_del
	pop	bx			; begin addr
	pop	ax
	pop	ax			; clean up stack
	push 	es
	push	ds
	pop	es			; es=ds
	mov	di,bx
compress:
	lodsb
	stosb	
	cmp	al,0			; end of env list?
	je	del_done   		;  yes - finished
compress_1:
	lodsb
	stosb
	cmp	al,0
	jne	compress_1
	jmp	compress
none_to_del:
	pop	ax
	pop	ax			; exit - no parm to delete
	pop	ds
	ret
del_done:
	pop	es
	pop	ds			; exit - deletion complete
	ret
del_env_parm	endp
;
;	add an environment parameter
;
;	called with:
;
;		di=environment address
;		si=parameter name (byte count+string)
;		bx=parameter value address (ASCII string)
;
add_env_parm	proc	near
	push	es
	mov	es,di
	xor	di,di
find_env_end:
	mov	al,es:[di]
	cmp	al,0
	je	found_env_end
	inc	di
find_env_end1:
	mov	al,es:[di]
	inc	di
	cmp	al,0
	jne	find_env_end1
	jmp	find_env_end
found_env_end:
	lodsb
	mov	cl,al
	xor	ch,ch
	rep	movsb			; copy parm name to env
	mov	si,bx
cpy_parm_val:
	lodsb
	stosb
	cmp	al,0
	jne	cpy_parm_val
	stosb				; new end of env
;
	pop	es
	ret
add_env_parm	endp
;
;	cpy_env - copy environment parms
;
;		on entry - si=seg addr of source env
;			   di=seg addr of dest env
;
;		ax,si,di are trashed
;
cpy_env	proc	near			; copy environment parms
	push	ds
	push	es			; save seg regs
	mov	ds,si
	mov	es,di
	xor	si,si
	mov	di,si
cpy_env_1:
	lodsb
	cmp	al,0
	je	cpy_env_3
	stosb
cpy_env_2:
	lodsb
	stosb
	cmp	al,0
	jne	cpy_env_2
	jmp	cpy_env_1
cpy_env_3:
	stosb
	pop	es
	pop	ds
	ret
cpy_env	endp
;
;	get_env_parm - get an environment parameter
;
;		si=parm name address (byte count+string)
;		bx=addr of buffer to contain value
;
;	on return - parm (if found) is in buffer and di
;		    points to nxt chr after it.
;
get_env_parm	proc	near		; get an environment parameter
	push	ds
	lodsb
	mov	cl,al
	xor	ch,ch			; cx = byte count of parm name
	push	cx
	push	si
	mov	ds,env_mem		; env addr
	mov	si,0
find_parm:
	pop	di
	pop	cx
	push	cx
	push	di
	cmp	byte ptr [si],0		; end of environment list?
	je	no_parm			;  yes - no parm to copy
	push	si
	rep	cmpsb			; requested identifier?
	je	copy_parm
	pop	si
eos_loop:				;  no - find end of ASCII string
	lodsb
	cmp	al,0
	jne	eos_loop
	jmp	find_parm
copy_parm:
	pop	ax			; trash start of parm
	mov	di,bx
copy_parm_loop:
	lodsb
	CMP	AL,';'
	JNZ	NOTSEMI
	XOR	AL,AL			; END ON ";"
NOTSEMI:stosb
	cmp	al,0
	jne	copy_parm_loop
	dec	di
no_parm:
	pop	si
	pop	cx			; restore regs
	pop	ds
	ret
get_env_parm	endp
;
;
;	display_menu		display the curren menu image
;
display_menu	proc	near
	call	screen_init		; clear the screen first
	mov	si,offset menu_buf+128	; address of menu image
display_loop:
	mov	al,es:[si]
	inc	si
	cmp	al,0
	je	dis_menu_rtn		; null terminates menu image
	OR	AL,AL			; TEST FOR GRAPHIC CHARACTER
	JS	display_menu_graphic
	CMP	SYSTYP,"Z"		; Z-100?
	JNZ	NOTZ100			; NO
	CMP	BYTE PTR GRPHFLG,0	; GRAPHIC MODE?
	JZ	NOTZ100			; NO
	MOV	BYTE PTR GRPHFLG,0	; ELSE, KILL IT
	PUSH	AX			; SAVE CHAR
	DISPLAY	ZOTGRPH			; AND GET OUT OF GRAPHIC MODE
	POP	AX
NOTZ100:display_chr	al		; neither - xfer to screen
	jmp	display_loop
;
dis_menu_rtn:
	CMP	SYSTYP,"Z"		; Z-100?
	JNZ	RTN1			; NO
	DISPLAY	ZOTGRPH			; ELSE, EXIT GRAPHIC MODE
RTN1:	ret
;
display_menu_graphic:
	cmp	systyp,"Z"		; Z-100?
	JZ	GRAPHIC_Z		;  YES
	JMP	SHORT NOTZ100		;  ELSE, JUST DISPLAY CHARACTER
GRAPHIC_Z:
	CMP	BYTE PTR GRPHFLG,0	; IN GRAPHIC MODE?
	JNZ	GRMODE			; YES, JUST DISPLAY CHAR
	MOV	BYTE PTR GRPHFLG,1	; ELSE, SET IT
	PUSH	AX			; SAVE CHAR
	display	zingrph			;  SET Z-100 to graphic mode
	POP	AX
GRMODE:	SUB	AL,0B3H			; REMOVE CHARACTER BIAS
	MOV	BX,OFFSET GRXTBL	; POINT TO GRAPHIC XLAT TABLE
	CMP	AL,0D9H-0B3H		; CHAR OUT OF TABLE?
	JC	INTABL			; NO
	MOV	BX,OFFSET GRXTBL1	; ELSE, USE SECOND TABLE
	SUB	AL,0D9H-0B3H		; REMOVE EXTRA BIAS
INTABL:	XLAT				; GET EQUIVALENT H19 CHAR
	DISPLAY_CHR	AL		; DISPLAY CHARACTER
	JMP	SHORT DISPLAY_LOOP
;
zingrph	db	1bh,"F$"	; Z-100 enter graphics mode
zotgrph	db	1bh,"G$"	; Z-100 exit graphics mode
;
;	IBM TO H19 GRAPHIC TRANSLATE TABLE

GRXTBL	DB	'`'
	DB	't'
	DB	0			;B5 THRU BE = 0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	'c'
	DB	'e'
	DB	'u'
	DB	's'
	DB	'v'
	DB	'a'
	DB	'b'
GRXTBL1	DB	'd'
	DB	'f'
display_menu	endp

;	GETCON - GET CONSOLE DATA (PC ONLY)

GETCON	PROC	NEAR
	cmp	systyp,"Z"		; Z-100?
	jne	GETCON1			;  no - IBM PC
	ret
GETCON1:MOV	AH,3
	INT	10H			; GET CURSOR TYPE
	MOV	AX,CX
	AND	AX,1F1FH		; TEST IF ON
	JZ	CNOTON			; CURSOR NOT ON
	MOV	CURTYPE,CX		; ELSE, SAVE IT
CNOTON:	MOV	AH,15
	INT	10H			; READ DISPLAY TYPE
	MOV	DISTYPE,AL		; SAVE DISPLAY TYPE
	RET
GETCON	ENDP
;
;	screen_init 	- initialize screen for menu
;
;	calling sequence:
;
;		CALL SCREEN_INIT
;
;	no registers are preserved
;
screen_init	proc	near		; initialize the screen for a menu
	mov	es,menu_mem
	cmp	systyp,"Z"		; Z-100?
	jne	init_ibm		;  no - IBM PC
	display zinit			; initialize Z-100
	ret
zinit	db	1bh,'E'			; clear
	db	1bh,'x1'		; enable 25th line
	db	1bh,'Y8 '		; 25th line address
	db	1bh,'K'			; erase it
	db	1bh,'Y  '		; top of screen address
	db	1bh,'x5'		; cursor off
	db	1bh,'y?'		; key expansion off
	db	'$'
;
init_ibm:				; init IBM PC screen
	MOV	AX,100*256
	INT	10H			; SET NORMAL SCROLL
	MOV	AL,DISTYPE
	CMP	AL,7			; MONOCHROME CARD?
	JZ	MONCRD			; YES
	MOV	AX,3			; ELSE, FORCE MODE 3 FOR NOW
	INT	10H
MONCRD:	mov	ah,1
	MOV	CX,2020H
	int	10h			;  (effectively turns cursor off)
	mov	ah,2
	mov	dx,0			; cursor to top of screen
	mov	bh,0
	int	10h
	mov	ax,500H			; active page 0
	int	10h
	mov	ah,6
	mov	al,0			; clear screen
	mov	bh,07h
	mov	cx,0			;  top left
	MOV	DX,23*256+79		;  BOTTOM RIGHT
	int	10h
	ret
screen_init	endp
;
;	screen_xit      -  reset screen for entry to selected programs
;
;	calling sequence:
;
;		CALL	SCREEN_XIT
;
;	no registers are preserved
;
screen_xit	proc	near
	cmp	systyp,"Z"		; Z-100?
	jne	xit_ibm			;  no - IBM PC
	display zxit			; sent control to Z-100
screen_xit_ret:
	ret
zxit	db	1bh,'E'			; clear screen
	db	1bh,'y5'		; cursor on
	db	1bh,'x?'		; enable key expansion
	db	1bh,'G'			; graphic mode off
	db	1bh,'q'			; normal video
	db	'$'
;
xit_ibm:				; reset IBM PC screen
	mov	ah,6
	mov	al,0			; clear screen
	mov	bh,07h
	mov	cx,0
	mov	dh,23
	mov	dl,79
	int	10h
	mov	ah,2			; cursor home
	mov	dx,0
	mov	bh,0
	int	10h
	XOR	AH,AH
	MOV	AL,DISTYPE		; GET DISPLAY TYPE
	INT	10H
	mov	ah,1
	MOV	CX,CURTYPE		; GET CURSOR TYPE
	int	10h
	jmp	screen_xit_ret
screen_xit	endp
	page
;
;	screen_addr		-  address crt
;
;	calling sequence:
;	
;	LEA	BX,ADRCHR		; bx points to 2-chr screen addr (" "=0)
;	CALL	SCREEN_ADDR
;
;	no registers are preserved
;
screen_addr	proc	near
	cmp	systyp,"Z"		; Z-100?
	jne	addr_ibm		;  no
	display zaddr			; screen address command
	display_chr 	es:[bx]		; row addr
	display_chr	es:1[bx]	; col addr
	ret
zaddr	db	1bh,'Y$'		; z-100 screen address command
;
addr_ibm:				; set IBM PC screen address
	mov	dh,es:[bx]		; row
	mov	dl,es:1[bx]		; col
	sub	dx,"  "			; adjust to binary nums
	mov	ah,2
	mov	bh,0
	int	10h
	ret
screen_addr	endp
	page
;
;	screen_reverse		- set reverse video display
;
;	calling sequence:
;
;	CALL	SCREEN_REVERSE
;
;	no registers are preserved
;
screen_reverse	proc	near
	cmp	systyp,"Z"		; Z-100?
	jne	reverse_ibm		;  no
	display	zrev
	ret
zrev	db	1bh,'p$'		; enter reverse video mode
;
reverse_ibm:				; set PC in hi-light mode
	mov	byte ptr vid_ibm,HICODE	; video attribute
	ret
vid_ibm	db	07h			; IBM PC video attribute
;				  default = normal (white on black)
screen_reverse	endp
	page
;
;	screen_normal		-  set screen to normal display
;
;	calling sequence:
;
;	CALL	SCREEN_NORMAL
;
;	no registers are preserved
;
screen_normal	proc	near
	cmp	systyp,"Z"		; Z-100?
	jne	normal_ibm		;  no
	display	znorm
	ret
znorm	db	1bh,'q$'		; set Z-100 to normal video display
;
normal_ibm:				; set IBM PC to normal video
	mov	vid_ibm,07h
	ret
screen_normal	endp
	page
;
;	screen_out		-  write a character to the screen
;
;	calling sequence:
;
;	MOV	DL,CHR			; chr in reg dl
;	CALL	SCREEN_OUT
;
;	no registers are preserved (SI,DI do not change)
;
screen_out	proc	near
	cmp	systyp,"Z"		; Z-100?
	jne	out_ibm			;  no
	svc	2			;  yes - just send chr to screen
	ret
;
out_ibm:				; IBM PC character output
	mov	al,dl
	cmp	al,0dh 			; ignore cr
	je	out_ibm_ret
	cmp	al,0ah			; perform lf function
	je	out_ibm_lf
	mov	ah,9
	mov	cx,1			; write 1 chr
	mov	bh,0
	mov	bl,vid_ibm		; set video attr 
	int	10h
	mov	ah,3
	mov	bh,0
	int	10h			; read current cursor pos
	inc	dl			; inc col pos
	cmp	dl,80
	jne	out_ibm_set
	mov	dl,0			; wrap at 80
	inc	dh
	cmp	dh,24
	jne	out_ibm_set		; wrap lines at 24
	mov	dh,0
out_ibm_set:
	mov	ah,2
	int	10h			; set new cursor pos
out_ibm_ret:
	ret
out_ibm_lf:
	mov	ah,3			; read cursor position
	mov	bh,0
	int	10h
	inc	dh			; inc row
	cmp	dh,24
	jne	out_ibm_nowrap
	mov	dh,0
out_ibm_nowrap:
	mov	dl,0			; set col = 0
	mov	ah,2
	int	10h
	ret
screen_out	endp
;
;	Stack Space
BA:
SBUFF	STRUC
	db	256 dup (?)
stack 	db	?
;
endcod 	db	?
SBUFF	ENDS
;
menu	ends
	end	start
           