	PAGE	,132
	TITLE	MICROSOFT WORD PRINT PATCHER
;	WRDPATCH -- MICROSOFT WORD PRINT PATCHER
;
;	THIS PROGRAM PATCHES MICROSOFT WORD SO THAT PRINTER
;	OUTPUT GOES THROUGH THE DOS, INSTEAD OF GOING
;	DIRECTLY TO THE BIOS.
;
;	BY P. SWAYNE, HUG  21-MAY-85

;	DEFINITIONS

PCHADR	EQU	1F64H-256		;PATCH AREA
PCHSIZ	EQU	512			;PATCH AREA SIZE
OPENF	EQU	0FH			;OPEN FILE
CLOSEF	EQU	10H			;CLOSE FILE
SETDTA	EQU	1AH			;SET DTA ADDRESS
READF	EQU	27H			;READ FILE (RANDOM BLK.)
WRITEF	EQU	28H			;WRITE FILE (RANDOM BLOCK)

CODE	SEGMENT
	ASSUME  CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG     5CH
FCB	LABEL   BYTE                    ;DEFAULT FCB ADDRESS
	ORG     100H

START:  MOV     DX,OFFSET SIGNON
	MOV     AH,9
	INT     21H                     ;PRINT SIGNON
	CMP     BYTE PTR FCB+1,' '      ;TEST FOR ARGUMENT
	JNZ     GOTARG                  ;GOT ONE
	MOV     DX,OFFSET EXPL
	MOV     AH,9
	INT     21H                     ;ELSE, EXPLAIN PROGRAM
	INT     20H
GOTARG: MOV     DI,OFFSET FCB+32        ;POINT TO RECORD COUNTERS
	XOR     AX,AX
	CLD
	MOV	CX,3
	REP	STOSW			;CLEAR RECORD COUNTERS
	MOV	DX,OFFSET FCB
	MOV	AH,OPENF
	INT	21H			;OPEN FILE
	INC	AL
	JNZ	OPENED			;OPEN OK
FILERR:	MOV	DX,OFFSET NOFILE
	MOV	AH,9
	INT	21H			;ELSE, SAY "NO FILE"
	INT	20H
OPENED:	MOV	WORD PTR FCB+14,1	;SET RECORD SIZE TO 1
	MOV	DX,OFFSET BUFFER
	MOV	AH,SETDTA
	INT	21H			;SET DTA TO BUFFER
	MOV	WORD PTR FCB+33,PCHADR	;START READING FILE HERE
	MOV	CX,PCHSIZ		;COUNT OF BYTES TO READ
	MOV	DX,OFFSET FCB
	MOV	AH,READF
	INT	21H			;READ FROM FILE
	OR	AL,AL
	JNZ	FILERR			;FILE ERROR
	MOV	AL,0CDH			;GET "INT" CODE
	MOV	DI,OFFSET BUFFER
	MOV	CX,PCHSIZ		;SEARCH ENTIRE PATCH AREA
SEARCH1:REPNZ	SCASB			;SEARCH FOR "INT"
	JNZ	NOPCH			;NOT FOUND
	CMP	BYTE PTR [DI],17H	;INT 17H?
	JNZ	SEARCH1			;NO, KEEP LOOKING
	CMP	WORD PTR 1[DI],0E480H	;VERIFY PATCH
	JZ	PATCH			;THIS IS IT
NOPCH:	MOV	DX,OFFSET NPMSG
	MOV	AH,9
	INT	21H			;ELSE, SAY "NO PATCH DONE"
	INT	20H
PATCH:	SUB	DI,3			;POINT TO PATCH ADDRESS
	MOV	CX,8
	MOV	SI,OFFSET PATCH1	;POINT TO PATCH
	REP	MOVSB			;MAKE THE PATCH
	MOV	WORD PTR FCB+33,PCHADR	;RESET RECORD ADDRESS
	MOV	CX,PCHSIZ		;COUNT OF BYTES TO WRITE
	MOV	DX,OFFSET FCB
	MOV	AH,WRITEF
	INT	21H			;WRITE TO FILE
	OR	AL,AL
	JZ	PCHOK			;WRITE OK
WRERR:	MOV	DX,OFFSET BADWR
	MOV	AH,9
	INT	21H			;SAY "NO WRITE"
	INT	20H
PCHOK:	MOV	DX,OFFSET FCB
	MOV	AH,CLOSEF
	INT	21H			;CLOSE FILE
	INC	AL
	JZ	WRERR			;ERROR IN CLOSING
	MOV	DX,OFFSET DONE
	MOV	AH,9
	INT	21H			;ELSE, SAY "DONE"
	INT	20H			;AND EXIT

;	PATCH TO BE INSERTED INTO MICROSOFT WORD

PATCH1:	MOV	DL,AL
	MOV	AH,5
	INT	21H
	NOP
	JMP	PATCH1			;ONLY JMP USED, NOT DEST.

;	MESSAGES

SIGNON	DB	13,10,'MICROSOFT WORD Print Patching Utility'
	DB	13,10,10,'$'
EXPL	DB	'To use this program, enter',13,10,10
	DB	'  WRDPATCH d:WORD.COM',13,10,10
	DB	'where d: is a drive designation, and',13,10
	DB	'WORD.COM is the file to patch.$'
NOFILE	DB	'ERROR -- No file, or read error.$'
NPMSG	DB	'Proper code not found, no patch done.$'
BADWR	DB	'ERROR -- Disk write problem.$'
DONE	DB	'MICROSOFT WORD successfully patched.$'

BUFFER	LABEL	BYTE			;BUFFER STARTS HERE

CODE	ENDS
	END	START
                                                                                            