;	DIR19 - CP/M DIRECTORY PROGRAM
;
;	THIS DIRECTORY PROGRAM MAKES USE OF SPECIAL FEATURES OF
;	THE H/Z19 TERMINAL (OR COMPATABLE COMPUTERS) TO PRODUCE
;	AN EASY-TO-READ DIRECTORY LISTING.
;
;	BY P. SWAYNE, HUG  25-JAN-83
;
;	THIS PROGRAM WAS BUILT UP FROM THE SDIR PROGRAM
;		by Keith Petersen, W8SDZ
;
;	PRINTS A 4-WIDE DIRECTORY, SORTED ALPHABETICALLY
;
;	A>DIR19 FILENAME.TYP
;
;	or just
;
;	A>DIR19
;
;	ALLOWS '*' OR '?' "WILD CARD" SPECIFICATIONS
;	DRIVE NAME BY ALSO BE SPECIFIED
;
;	YOU CAN ALSO SPECIFY A USER NUMBER AFTER THE DRIVE
;	AND/OR FILE SPECIFICATION, AS IN THIS EXAMPLE
;
;	A>DIR19 A: 5    (SHOW FILES ON USER 5)
;
;	YOU CAN ALSO SPECIFY THAT THE DIRECTORY NOT BE
;	ALPHABETIZED, BY ENTERING "N" AFTER THE DRIVE,
;	NAME, OR USER NUMBER
;
;	A>DIR19 A: N
;	A>DIR19 *.BAS N
;	A>DIR19 B:*.COM 10N  (NO SPACE AFTER USER NO.)
;
TRUE	EQU	0FFFFH
FALSE	EQU	NOT TRUE

H19	EQU	TRUE 		;ASSEMBLE FOR HEATH EQUIPMENT
;				;OTHERWISE, ASSEMBLES FOR VT52
HRUN	EQU	FALSE		;ASSEMBLE FOR USE WITH HRUN
;
;	TO ASSEMBLE FOR HRUN, LOAD THE HEX FILE WITH DDT
;	THEN ENTER
;	-M2278,2900,100
;	-G0
;	A>SAVE 7 DIR19.ABS

	IF	NOT HRUN
	ORG	100H
	ENDIF
	IF	HRUN
	ORG	2278H
	DB	0FFH,0
	DW	START
	DW	ORDER-START
	DW	START
	ENDIF
START	MVI	C,FDMA
	LXI	D,80H
	CALL	BDOS		;SET DEFAULT DMA
	IF	HRUN
	LXI	H,FCB+1		;POINT TO FCB
	MVI	A,' '		;GET A SPACE
	MVI	B,11		;SET COUNTER
DIRLP	MOV	M,A		;CLEAR FCB AREA
	INX	H
	DCR	B
	JNZ	DIRLP
	XRA	A		;GET A ZERO
	MVI	B,21		;SET A COUNTER
DIRLP1	MOV	M,A		;CLEAR REST OF FCB
	INX	H
	DCR	B
	JNZ	DIRLP1
	MVI	A,' '
	STA	6DH		;MARK FCB2 EMPTY
	MVI	A,1		;ASSUME DRIVE SY0:
	STA	FCB		;SET IT UP
	LXI	H,0
	DAD	SP		;FIND STACK
	MOV	A,L
	CPI	200Q		;HAS IT CHANGED?
	JZ	RUNDIR		;NO, RUN DIRECTORY
DIR1	MOV	A,M		;GET A CHARACTER
	CPI	' '		;SPACE
	JNZ	DIR1A		;NO
	INX	H
	JMP	DIR1		;SKIP SPACES
DIR1A	INX	H		;MOVE OVER POSSIBLE DEVICE
	INX	H
	INX	H
	MOV	A,M		;GET CHARACTER
	CPI	':'		;DEVICE SPECIFIED?
	JNZ	DIR2		;NO
	DCX	H		;BACK UP TO UNIT
	MOV	A,M		;GET IT
	SUI	'0'-1		;MAKE IT 1-N
	STA	FCB		;PUT IT IN FCB
	INX	H
	INX	H		;SKIP COLON
	JMP	DIR4
DIR2	DCX	H		;BACK UP TO BEGINNING OF NAME
	DCX	H
	DCX	H
DIR4	MOV	A,M		;GET FIRST NAME CHARACTER
	ORA	A		;IS IT ZERO
	JZ	RUNDIR		;THEN PRINT ALL OF DIRECTORY
	MVI	C,8		;SET A COUNTER
	LXI	D,FCB+1	;PUT NAME HERE
DIR5	ORA	A		;END OF ENTRY?
	JZ	DIR7		;YES
	CPI	'*'		;WILD CARD NAME?
	JZ	DIR6		;YES
	CPI	'.'		;END OF NAME?
	JZ	DIR7		;YES
	STAX	D		;ELSE, STORE CHARACTER
	INX	D		;INCREMENT POINTERS
	INX	H
	MOV	A,M		;GET NEXT CHARACTER
	DCR	C		;DECREMENT COUNTER
	JNZ	DIR5
	JMP	DIR7
DIR6	MVI	A,'?'		;GET A QUESTION MARK
	STAX	D		;FILL NAME WITH THEM
	INX	D
	DCR	C
	JNZ	DIR6+2
	INX	H		;SKIP OVER "*"
DIR7	INR	C
DIR8	DCR	C		;SET FLAGS
	JZ	DIR9
	MVI	A,' '		;ELSE, FILL NAME
	STAX	D
	INX	D
	JMP	DIR8
DIR9	MOV	A,M		;GET NEXT CHARACTER
	CPI	'.'		;PERIOD?
	MVI	C,3		;SET A COUNTER
	JNZ	DIR12		;NOT A PERIOD
	INX	H		;ELSE, SKIP PERIOD
DIR10	MOV	A,M		;GET A CHARACTER
	ORA	A		;END OF ENTRY?
	JZ	DIR12		;YES
	CPI	'*'		;WILD CARD EXT.?
	JZ	DIR11		;YES
	STAX	D		;ELSE, STORE CHARACTER
	INX	D		;INCREMENT POINTERS
	INX	H
	DCR	C		;DECREMENT COUNTER
	JNZ	DIR10
	JMP	RUNDIR		;DONE, RUN THE DIRECTORY
DIR11	MVI	A,'?'		;FILL EXT WITH "?"
	STAX	D
	INX	D
	DCR	C
	JNZ	DIR11+2
	INX	H		;SKIP OVER "*"
DIR12	INR	C
DIR13	DCR	C		;SET FLAGS
	JZ	RUNDIR		;RUN DIRECTORY IF DONE
	MVI	A,' '
	STAX	D		;FILL EXT. WITH SPACES
	INX	D
	JMP	DIR13
RUNDIR
	ENDIF
	IF	NOT HRUN
	LXI	H,0
	DAD	SP		;FIND STACK
	LXI	SP,STACK	;SET NEW ONE
	PUSH	H		;SAVE OLD ONE
	ENDIF
	CALL	TYPTX
	DB	27,'E'+80H	;CLEAR SCREEN
	MVI	A,'?'
	STA	FCB+12		;PUT "?" IN EXTENT POS.
	MVI	E,0FFH
	MVI	C,GUSER
	CALL	BDOS		;GET CURRENT USER CODE
	STA	USER		;SAVE IT
	LXI	H,6DH		;GET FCB2 FIRST CHAR
	MOV	A,M
	CPI	' '		;ANY USER CODE
	JZ	NOUSER		;NO
	CPI	'N'		;NO ALPHABETIZE?
	JNZ	DECIN		;NO, CHECK FOR NUMBER
	MVI	A,1
	STA	NFLAG		;ELSE, MARK NO ALPHA
	JMP	NOUSER
DECIN	MVI	C,0		;GET A ZERO
DLOOP	MOV	A,M		;GET A CHARACTER
	CPI	'N'		;NO ALPHA?
	JNZ	DLOOP1		;NO, NORMAL OUTPUT
	MVI	A,1
	STA	NFLAG		;MARK NO ALPHA
	JMP	GOTUSR		;GOT USER NOW
DLOOP1	SUI	'0'		;REMOVE ASCII
	JC	GOTUSR		;WE GOT A USER NO.
	CPI	10		;MORE THAN 9
	JNC	NOUSER		;YES, BAD ENTRY
	INX	H		;INCREMENT POINTER
	MOV	D,A		;SAVE ENTRY
	MOV	A,C		;GET LAST ENTRY
	ADD	A		;* 2
	MOV	B,A		;SAVE IT
	ADD	A		;* 4
	ADD	A		;* 8
	ADD	B		;PLUS N*2 = N*10
	ADD	D		;ADD CURRENT ENTRY
	MOV	C,A		;STORE RESULT
	JMP	DLOOP		;GET ANOTHER DIGIT
GOTUSR	MOV	E,C		;IN E
	MVI	C,GUSER
	CALL	BDOS		;SET NEW USER CODE
NOUSER	MVI	C,GDISK
	CALL	BDOS		;GET CURRENT DISK
	STA	CURDSK		;SAVE CURRENT DISK
	LXI	H,FCB		;GET FCB ADDRESS
	MOV	A,M		;GET DISK WE'RE USING
	DCR	A		;MAKE IT 0-N
	JP	SEL		;NOT USING DEFAULT DISK
	LDA	CURDSK		;ELSE, GET IT
SEL	MOV	E,A		;IN E
	INR	A		;MAKE IT 1-N
	STA	LFCB		;PUT IT IN LABEL FCB
	MVI	C,SELECT
	CALL	BDOS		;SELECT DISK
	LXI	D,LFCB
	MVI	C,FOPEN
	CALL	BDOS		;TRY TO OPEN LABEL FILE
	INR	A
	JZ	NOLAB
	MVI	C,FREAD
	LXI	D,LFCB
	CALL	BDOS		;READ LABEL FILE
	ORA	A
	JNZ	NOLAB		;BAD LABEL FILE
	CALL	TYPTX
	IF	HRUN
	DB	'Disk S','Y'+80H
	ENDIF
	IF	NOT HRUN
	DB	'Disk',' '+80H
	ENDIF
	LDA	LFCB		;GET DRIVE CODE
	IF	NOT HRUN
	ADI	40H		;MAKE IT ASCII
	ENDIF
	IF	HRUN
	ADI	2FH
	ENDIF
	CALL	TYPE		;PRINT IT
	CALL	TYPTX
	DB	': ','#'+80H
	LXI	D,82H
	CALL	WRCON		;PRINT VOL. NO.
	CALL	TYPTX
	DB	' Label:',' '+80H
	LXI	D,83H
FLAB	LDAX	D
	CPI	'"'		;FIND LABEL
	INX	D
	JNZ	FLAB
	CALL	WRCON		;PRINT LABEL
	JMP	SIZE
NOLAB	CALL	TYPTX
	IF	HRUN
	DB	'Directory of disk S','Y'+80H
	ENDIF
	IF	NOT HRUN
	DB	'Directory of disk',' '+80H
	ENDIF
	LDA	LFCB
	IF	HRUN
	ADI	2FH
	ENDIF
	IF	NOT HRUN
	ADI	40H
	ENDIF
	CALL	TYPE
	CALL	TYPTX
	DB	':'+80H
SIZE	CALL	BORDER
	MVI	C,GDPB
	CALL	BDOS
	INX	H
	INX	H		;MOVE TO BLOCK SHIFT
	MOV	A,M		;GET IT
	DCR	A
	DCR	A
	DCR	A		;MAKE IT START AT ZERO
	PUSH	PSW		;SAVE IT
	INX	H		;MOVE TO DISK SIZE
	INX	H
	INX	H
	MOV	E,M		;PUT IT IN DE
	INX	H
	MOV	D,M
	INX	D		;ADD 1
	XCHG
	SHLD	DSIZE		;SAVE DISK SIZE
	XCHG
	INX	H		;MOVE TO ALLOCATION
	INX	H
	INX	H
	MOV	A,M		;GET IT
	STA	ALLOC		;SAVE IT
	POP	PSW		;GET BLOCK SHIFT (-3)
	LXI	H,1		;HL = 1 K
	ORA	A		;SET FLAGS
	JZ	SIZE1		;GOT BLOCK SIZE
BLKLP	DAD	H		;DOUBLE BLOCK SIZE
	DCR	A		;IS THIS IT
	JNZ	BLKLP		;NO, DOUBLE AGAIN
SIZE1	MOV	A,L
	STA	BSIZE		;SAVE BLOCK SIZE FOR LATER
	PUSH	H		;SAVE BLOCK SIZE
	MVI	C,GALLOC
	CALL	BDOS		;GET ALLOCATION MAP
	POP	D		;DE = BLOCK SIZE
SIZE2	MVI	B,8		;8 BITS PER BYTE
	MOV	A,M		;GET A BYTE
	PUSH	H		;SAVE MAP ADDRESS
SIZE3	RAL			;TEST FOR A BIT
	JC	SIZE4		;IT IS SET
	LHLD	FREE		;INCREMENT FREE SPACE
	DAD	D
	SHLD	FREE
	JMP	SIZE5
SIZE4	LHLD	USED		;INCREMENT USED SPACE
	DAD	D
	SHLD	USED
SIZE5	LHLD	DSIZE		;GET DISK SIZE
	DCX	H		;SUBTRACT THIS GROUP
	SHLD	DSIZE
	PUSH	PSW		;SAVE MAP BYTE
	MOV	A,H
	ORA	L		;DONE WITH DISK?
	JZ	SIZE6		;IF SO, LEAVE
	POP	PSW		;ELSE RESTORE MAP BYTE
	DCR	B		;DONE WITH BYTE?
	JNZ	SIZE3		;NO, TEST ANOTHER BIT
	POP	H		;ELSE, GET MAP ADDRESS
	INX	H		;INCREMENT IT
	JMP	SIZE2		;GET NEXT BYTE
SIZE6	POP	PSW		;RESTORE PSW
	POP	H		;AND HL
	XCHG			;HL = BLOCK SIZE
	CALL	CHL		;COMPLEMENT IT
	XCHG			;PUT RESULT IN DE
	LHLD	USED		;GET USED SPACE
	LDA	ALLOC		;AND ALLOCATION VECTOR
	RAL			;TEST FOR A BIT
	JNC	SIZE8		;NONE SET, NO ALLOCATED SPACE
SIZE7	DAD	D		;SUBTRACK A BLOCK
	RAL			;TEST FOR A BIT
	JC	SIZE7		;IT WAS SET, SUBTRACT BLOCK
SIZE8	SHLD	USED		;SAVE UPDATED USED SPACE
START1	LXI	H,FCB+1
	MOV	A,M
	CPI	' '
	JNZ	GOTFCB
;NO FCB - MAKE FCB ALL '?'
	MVI	B,11		;FN+FT COUNT
QLOOP	MVI	M,'?'		;STORE '?' IN FCB
	INX	H
	DCR	B
	JNZ	QLOOP
;LOOK UP THE FCB IN THE DIRECTORY
GOTFCB	MVI	C,FSRCHF 	;GET 'SEARCH FIRST' FNC
	LXI	D,FCB		;GET FCB ADDRESS
	CALL	BDOS		;READ FIRST
	INR	A		;WERE THERE ANY?
	JNZ	SOME		;GOT SOME
	JMP	BOTTOM
;
;READ MORE DIRECTORY ENTRIES
MOREDIR	MVI	C,FSRCHN	;SEARCH NEXT
	LXI	D,FCB
	CALL	BDOS		;READ DIR ENTRY
	INR	A		;CHECK FOR END (0FFH)
	JZ	SPRINT		;NO MORE - SORT & PRINT
;POINT TO DIRECTORY ENTRY 
SOME	DCR	A		;UNDO PREV 'INR A'
	ANI	3		;MAKE MODULUS 4
	ADD	A		;MULTIPLY...
	ADD	A		;..BY 32 BECAUSE
	ADD	A		;..EACH DIRECTORY
	ADD	A		;..ENTRY IS 32
	ADD	A		;..BYTES LONG
	LXI	H,81H		;POINT TO BUFFER
;				;(SKIP TO FN/FT)
	ADD	L		;POINT TO ENTRY
	MOV	L,A		;SAVE (CAN'T CARRY TO H)
	PUSH	H		;SAVE ADDRESS
	LXI	D,11
	DAD	D		;SKIP TO EXTENT NO.
	MOV	A,M		;GET IT
	POP	H		;RESTORE ADDRESS
	ORA	A		;ZERO EXTENT?
	JZ	MOVEN		;YES, MOVE FILE NAME
	LDA	COUNT		;ELSE, GET FILE COUNT
	ORA	A		;FIRST FILE?
	JZ	MOVEN		;YES
	MOV	B,A		;COUNT IN B
	MVI	C,11		;GET COMPARE COUNT
	LXI	D,TABLE		;POINT TO TABLE
FIND	PUSH	B		;SAVE REGISTERS
	PUSH	D
	PUSH	H
COMP	LDAX	D
	CMP	M		;COMPARE ENTRIES
	JNZ	NOCOMP
	INX	D
	INX	H
	DCR	C
	JNZ	COMP		;CONTINUE FOR CHAR COUNT
NOCOMP	POP	H		;RESTORE REGISTERS
	POP	D
	POP	B
	JZ	REPLACE		;FOUND MATCH, REPLACE ENTRY
	PUSH	H
	XCHG			;HL = TABLE ADDRESS
	LXI	D,15
	DAD	D		;MOVE TO NEXT ENTRY
	XCHG
	POP	H
	DCR	B		;DECREMENT COUNT
	JNZ	FIND		;TRY AGAIN
	JMP	MOVEN		;NO MATCH, NEW ENTRY
REPLACE	PUSH	H		;SAVE NEW ENTRY ADDR
	PUSH	D		;AND OLD ONE
	LXI	B,11
	DAD	B		;MOVE TO NEW EXTENT NO.
	MOV	A,M		;GET IT
	POP	H		;GET OLD ENTRY
	PUSH	H		;SAVE AGAIN
	DAD	B		;MOVE TO ITS EXTENT NO.
	CMP	M		;COMPARE
	POP	D		;RESTORE REGISTERS
	POP	H
	JC	SKIPRP		;OLD BIGGER, SKIP REPLACEMENT
	MVI	B,15		;MOVE 15 CHARACTERS
REP1	MOV	A,M		;GET A CHARACTER
	STAX	D		;MOVE IT TO TABLE
	INX	H
	INX	D		;INCREMENT POINTERS
	DCR	B		;DECREMENT COUNTER
	JNZ	REP1		;CONTINUE UNTIL DONE
SKIPRP	JMP	MOREDIR		;GET ANOTHER ENTRY

;MOVE ENTRY TO TABLE

MOVEN	XCHG			;ENTRY TO DE
	LHLD	NEXTT		;NEXT TABLE ENTRY TO HL
	MVI	B,15		;ENTRY LENGTH
TMOVE	LDAX	D		;GET ENTRY CHAR
	MOV	M,A		;STORE IN TABLE
	INX	D
	INX	H
	DCR	B		;MORE?
	JNZ	TMOVE
	SHLD	NEXTT		;SAVE UPDATED TABLE ADDR
	LDA	COUNT		;GET PREV COUNT
	INR	A
	STA	COUNT
	JMP	MOREDIR
;
;SORT AND PRINT
SPRINT	LDA	COUNT		;INIT THE ORDER TABLE
	STA	PCOUNT		;SAVE FOR PRINTING
	LDA	NFLAG
	ORA	A		;NO ALPHABETIZING WANTED?
	JNZ	DONE		;YES, SKIP SORT
	LXI	H,ORDER
	LXI	D,TABLE
	LXI	B,15		;ENTRY LENGTH
BLDORD	MOV	M,E		;SAVE LO ORD ADDR
	INX	H
	MOV	M,D		;SAVE HI ORD ADDR
	INX	H
	XCHG			;TABLE ADDR TO HL
	DAD	B		;POINT TO NEXT ENTRY
	XCHG
	DCR	A		;MORE?
	JNZ	BLDORD		;..YES
	LDA	COUNT		;GET COUNT
	STA	SCOUNT		;SAVE AS # TO SORT
	DCR	A		;ONLY 1 ENTRY?
	JZ	DONE		;..YES, SO SKIP SORT
SORT	XRA	A		;GET A ZERO
	STA	SWITCH		;SHOW NONE SWITCHED
	LDA	SCOUNT		;GET COUNT
	DCR	A		;USE 1 LESS
	STA	TEMP		;SAVE # TO COMPARE
	STA	SCOUNT		;SAVE HIGHEST ENTRY
	JZ	DONE		;EXIT IF NO MORE
	LXI	H,ORDER		;POINT TO ORDER TABLE
SORTLP	CALL	COMPR		;COMPARE 2 ENTRIES
	CM	SWAP		;SWAP IF NOT IN ORDER
	INX	H		;BUMP ORDER
	INX	H		;..TABLE POINTER
	LDA	TEMP		;GET COUNT
	DCR	A
	STA	TEMP
	JNZ	SORTLP		;CONTINUE
;ONE PASS OF SORT DONE
	LDA	SWITCH		;ANY SWAPS DONE?
	ORA	A
	JNZ	SORT
;SORT IS ALL DONE - PRINT ENTRIES
DONE	LXI	H,ORDER
	SHLD	NEXTT
	MVI	C,20		;ZERO A COUNTER
	LDA	NFLAG
	ORA	A		;DIRECTORY SORTED?
	JZ	ENTRY		;YES
	LXI	H,TABLE-15
	SHLD	NEXTT		;ELSE, PUT TABLE IN NEXTT
;
;PRINT AN ENTRY

ENTRY:	LDA	NFLAG
	ORA	A		;DIRECTORY SORTED?
	JZ	ENTRY1		;YES
	LHLD	NEXTT		;ELSE, GET ENTRY ADDRESS
	LXI	D,15
	DAD	D		;ADD 15
	SHLD	NEXTT		;UPDATE POINTER
	XCHG			;DE = ADDRESS
	JMP	ENTRY2
ENTRY1	LHLD	NEXTT		;GET ORDER TABLE POINTER
	MOV	E,M		;GET LO ADDR
	INX	H
	MOV	D,M		;GET HI ADDR
	INX	H
	SHLD	NEXTT		;SAVE UPDATED TABLE POINTER
ENTRY2	LHLD	COLADR		;GET COLUMN MOVER STRING
	CALL	TYPTX1		;PRINT IT
	XCHG			;TABLE ENTRY TO HL
	PUSH	H		;SAVE ENTRY ADDRESS
	MVI	B,8		;FILE NAME LENGTH
	CALL	TYPEIT		;TYPE FILENAME
	CALL	PERIOD		;PERIOD AFTER FN
	MVI	B,3		;GET THE FILETYPE
	CALL	TYPEIT
	POP	H		;GET NAME ADDRESS
	LXI	D,11
	DAD	D		;MOVE TO EXTENT NO.
	MOV	A,M		;GET IT
	PUSH	H		;SAVE EXTENT ADDRESS
	MOV	L,A
	MVI	H,0		;HL = EXTENT NO.
	DAD	H		;MULTIPLY BY 16
	DAD	H
	DAD	H
	DAD	H
	POP	D		;GET EXTENT ADDRESS
	INX	D		;MOVE TO RECORD COUNT
	INX	D
	INX	D
	LDAX	D		;GET IT
	ADI	7		;ADD 7
	RRC			;DIVIDE BY 8
	RRC
	RRC
	ANI	00011111B	;NOW, IT EQUALS K'S
	PUSH	PSW		;SAVE IT
	LDA	BSIZE		;GET BLOCK SIZE
	DCR	A		;SUBTRACT 1
	MOV	B,A		;RESULT IN B
	POP	PSW		;GET RECORD COUNT (IN K'S)
	ADD	B		;ADD (BSIZE-1)
	PUSH	PSW		;SAVE RESULT
	MOV	A,B		;GET BSIZE-1
	CMA			;COMPLEMENT IT
	MOV	B,A		;RESULT IN B
	POP	PSW		;GET COUNT-(BSIZE-1)
	ANA	B		;ROUND OFF TO GROUP SIZE
	ADD	L		;ADD TO HL
	MOV	L,A
	JNC	NOCARRY
	INR	H		;ADD CARRY
NOCARRY	LXI	D,SPACES	;POINT TO SPACES
	PUSH	D		;SAVE ON STACK
	LXI	D,10
	CALL	CPHD		;LESS THAN 10 FILES?
	JC	PSIZE		;YES, PRINT SIZE
	POP	D
	INX	D		;NO, REMOVE 1 SPACE
	PUSH	D
	LXI	D,100
	CALL	CPHD		;LESS THAN 100 FILES
	JC	PSIZE		;YES
	POP	D
	INX	D		;NO, REMOVE 1 SPACE
	PUSH	D
	LXI	D,1000		;LESS THAN 1000 FILES?
	CALL	CPHD
	JC	PSIZE		;YES
	POP	D
	INX	D		;NO, REMOVE 1 SPACE
	JMP	PSIZE+1		;PRINT SIZE
PSIZE	POP	D		;GET NO. OF SPACES
	XCHG			;HL = SPACES
	CALL	TYPTX1		;PRINT THEM
	XCHG
	CALL	DECOUT		;PRINT FILE SIZE
	MVI	A,'K'
	CALL	TYPE		;ADD "K"
	CALL	CR		;PRINT CRLF
;SEE IF MORE ENTRIES
	LDA	COUNT
	DCR	A
	STA	COUNT		;DECREMENT COUNT
	JZ	BOTTOM		;NO MORE FILES TO PRINT
	LDA	COUNTP		;GET PRINT COUNT
	INR	A		;INCREMENT IT
	STA	COUNTP
	CPI	80		;80 FILES PRINTED?
	JNZ	PMORE		;NO, PRINT MORE
	CALL	TYPTX
	DB	27,'Y73Press RETURN to see more files..','.'+80H
WAICR	MVI	C,RDCHR
	CALL	BDOS
	CPI	3		;ABORT?
	JZ	BOTTOM		;YES, QUIT EARLY
	CPI	0DH
	JNZ	WAICR		;WAIT FOR CR
	XRA	A
	STA	COUNTP		;CLEAR PRINT COUNTER
	STA	COLNO		;AND COLUMN NO.
	CALL	BORDER		;ERASE SCREEN, PRINT NEW BORDER
	LXI	H,COL1
	SHLD	COLADR		;UPDATE COLUMN ADDRESS
	MVI	C,20		;SET COUNTER
	JMP	ENTRY		;PRINT MORE FILES
PMORE	DCR	C		;DECREMENT COLUMN COUNTER
	JNZ	ENTRY		;MORE TO PRINT
	CALL	TYPTX
	DB	27,'Y"',' '+80H	;RETURN TO PAGE TOP
	MVI	C,20		;SET COUNTER
	LDA	COLNO		;ELSE GET COLUMN NUMBER
	INR	A		;INCREMENT IT
	STA	COLNO
	LXI	H,COL2		;ASSUME COLUMN 2
	DCR	A		;TEST FOR IT
	JZ	SETCOL		;YES
	LXI	H,COL3		;ASSUME COLUMN 3
	DCR	A
	JZ	SETCOL
	LXI	H,COL4		;ELSE, IT'S COLUMN 4
SETCOL	SHLD	COLADR
	JMP	ENTRY		;PRINT MORE
;
PERIOD	MVI	A,'.'
;
;TYPE CHAR IN A
TYPE	PUSH	B
	PUSH	D
	PUSH	H
	PUSH	PSW
	MOV	E,A
	MVI	C,DCIO
	CALL	BDOS
	POP	PSW
	POP	H
	POP	D
	POP	B
	RET
;
WRCON	MVI	C,PRINT
	JMP	BDOS
;
TYPEIT	MOV	A,M
	ORA	A		;TEST FOR HI BIT
	JP	TYPEIT1		;NONE THERE
	PUSH	PSW		;SAVE CHARACTER
	CALL	TYPTX
	DB	27,'p'+80H
	POP	PSW
TYPEIT1	ANI	7FH		;STRIP PARITY BIT
	CALL	TYPE
	CALL	TYPTX
	DB	27,'q'+80H
	INX	H
	DCR	B
	JNZ	TYPEIT
	RET
;
CR	MVI	A,0DH
	CALL	TYPE
	MVI	A,0AH
	CALL	TYPE
	RET
;
;COMPARE ROUTINE FOR SORT
COMPR	PUSH	H		;SAVE TABLE ADDR
	MOV	E,M		;LOAD LO
	INX	H
	MOV	D,M		;LOAD HI
	INX	H
	MOV	C,M
	INX	H
	MOV	B,M
;BC, DE NOW POINT TO ENTRIES TO BE COMPARED
	XCHG
CMPLP	LDAX	B
	CMP	M
	INX	H
	INX	B
	JZ	CMPLP
	POP	H
	RET			;COND CODE TELLS ALL
;
;SWAP ENTRIES IN THE ORDER TABLE
SWAP	MVI	A,1
	STA	SWITCH		;SHOW A SWAP WAS MADE
	MOV	C,M
	INX	H
	PUSH	H		;SAVE TABLE ADDR+1
	MOV	B,M
	INX	H
	MOV	E,M
	MOV	M,C
	INX	H
	MOV	D,M
	MOV	M,B
	POP	H
	MOV	M,D
	DCX	H		;BACK POINTER TO CORRECT LOC'N
	MOV	M,E
	RET

;BOTTOM - PRINT DISK SPACE DATA

BOTTOM	CALL	TYPTX
	DB	27,'Y7','3'+80H
	LDA	PCOUNT		;GET FILE COUNT
	MOV	L,A
	MVI	H,0		;IN HL
	CALL	DECOUT		;PRINT COUNT
	CALL	TYPTX
	DB	' Files.  Used =',' '+80H
	LHLD	USED		;GET USED SPACE
	CALL	DECOUT		;PRINT IT
	CALL	TYPTX
	DB	'K.  Free =',' '+80H
	LHLD	FREE
	CALL	DECOUT		;PRINT FREE SPACE
	CALL	TYPTX
	DB	'K.',27,'Y6',' '+80H
;
;EXIT - ALL DONE 

EXIT	LDA	CURDSK		;GET CURRENT DISK
	MOV	E,A
	MVI	C,SELECT
	CALL	BDOS		;SET DEFAULT DISK
	LDA	USER
	MOV	E,A
	MVI	C,GUSER
	CALL	BDOS		;SET CURRENT USER
	IF	NOT HRUN
	POP	H		;RESTORE STACK
	SPHL
	RET			;TO CP/M
	ENDIF
	IF	HRUN
	CALL	195EH		;$TYPTX
	DB	27,'Fa',27,'G'+80H
	XRA	A
	DB	0FFH,0		;SCALL .EXIT
	ENDIF

;DECOUT - PRINT HL IN DECIMAL

DECOUT	PUSH	B
	PUSH	D
	PUSH	H		;SAVE REGISTERS
	LXI	B,-10		;RADIX FOR CONVERSION
	LXI	D,-1
DX	DAD	B		;DIVIDE BY 10
	INX	D
	JC	DX
	LXI	B,10
	DAD	B
	XCHG			;DE = DIGIT, HL = NUMBER/10
	MOV	A,H
	ORA	L		;DONE?
	CNZ	DECOUT		;CALL RECURSIVELY UNTIL DONE
	MOV	A,E		;GET CHARACTER TO PRINT
	ADI	'0'		;ADD ASCII BIAS
	CALL	TYPE		;PRINT IT
	POP	H		;RESTORE REGISTERS
	POP	D
	POP	B
	RET

;	CHL - COMPLEMENT HL

CHL	MOV	A,H
	CMA
	MOV	H,A
	MOV	A,L
	CMA
	MOV	L,A
	INX	H
	RET

;	CPHD - CPMPARE HL TO DE

CPHD	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	RET

;	TYPTX - TYPE TEXT FOLLOWING CALL

TYPTX	XTHL			;GET ADDRESS OF TEXT
	CALL	TYPTX1
	XTHL
	RET
TYPTX1	MOV	A,M
	ANI	7FH
	CALL	TYPE
	CMP	M
	INX	H
	JZ	TYPTX1
	RET

;	BORDER - PRINT A GRAPHIC CHARACTER BORDER FOR FILES

BORDER	CALL	TYPTX
	IF	H19
	DB	27,'Y! ',27,'J',27,'F'+80H
	ENDIF
	IF	NOT H19
	DB	27,'Y! ',27,'J'+80H
	ENDIF
	MVI	B,4
BORD1	CALL	TYPTX
	IF	H19
	DB	'aaaaaaaaaaaaaaaaaa','a'+80H
	ENDIF
	IF	NOT H19
	DB	'------------------','-'+80H
	ENDIF
	DCR	B
	JZ	BORD2
	IF	H19
	MVI	A,'s'
	ENDIF
	IF	NOT H19
	MVI	A,'-'
	ENDIF
	CALL	TYPE
	JMP	BORD1
BORD2	MVI	B,20
BORD3	CALL	CR
	CALL	TYPTX
	IF	H19
	DB	9,9,'   `',9,9,'       `',9,9,'   ','`'+80H
	ENDIF
	IF	NOT H19
	DB	9,9,'   |',9,9,'       |',9,9,'   ','|'+80H
	ENDIF
	DCR	B
	JNZ	BORD3
	CALL	CR
	MVI	B,4
BORD4	CALL	TYPTX
	IF	H19
	DB	'aaaaaaaaaaaaaaaaaa','a'+80H
	ENDIF
	IF	NOT H19
	DB	'------------------','-'+80H
	ENDIF
	DCR	B
	JZ	BORD5
	IF	H19
	MVI	A,'u'
	ENDIF
	IF	NOT H19
	MVI	A,'-'
	ENDIF
	CALL	TYPE
	JMP	BORD4
BORD5	CALL	TYPTX
	IF	H19
	DB	27,'G',27,'Y"',' '+80H
	ENDIF
	IF	NOT H19
	DB	27,'Y"',' '+80H
	ENDIF
	RET

;
USER	DB	0		;CURRENT USER NO.
CURDSK	DB	0		;CURRENT DISK
NFLAG	DB	0		;NO ALPHABETIZE FLAG
NEXTT	DW	TABLE		;NEXT TABLE ENTRY
COUNT	DB	0		;ENTRY COUNT
PCOUNT	DB	0		;COUNT TO PRINT
SCOUNT	DB	0		;# TO SORT
SWITCH	DB	0		;SWAP SWITCH FOR SORT
DSIZE	DW	0		;DISK SIZE
USED	DW	0		;USED SPACE
FREE	DW	0		;FREE SPACE
ALLOC	DB	0		;ALLOCATION VECTOR
BSIZE	DB	0		;BLOCK SIZE
COUNTP	DB	0		;PRINT COUNTER
SPACES	DB	'   ',' '+80H
COLNO	DB	0		;COLUMN NUMBER
COLADR	DW	COL1		;COLUMN MOVER ADDRESS
COL1	DB	80H
COL2	DB	9,9,27,'C',27,'C',27,'C',27,'C'+80H
COL3	DB	9,9,9,9,9+80H
COL4	DB	9,9,9,9,9,9,9,27,'C',27,'C',27,'C',27,'C'+80H
LFCB	DB	0,'IDENT   SYS',0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
ORDER	DS	512		;ORDER TABLE (ROOM FOR LOTS OF NAMES)
TEMP	DS	1		;SAVE DIR ENTRY
	DS	64
STACK	EQU	$		;LOCAL STACK
TABLE	EQU	$		;READ ENTRIES IN HERE
;
; BDOS EQUATES
;
RDCHR	EQU	1		;READ CHAR FROM CONSOLE
WRCHR	EQU	2		;WRITE CHR TO CONSOLE
DCIO	EQU	6		;DIRECT CONSOLE I/O
PRINT	EQU	9		;PRINT CONSOLE BUFF
CONST	EQU	11		;CHECK CONS STAT
SELECT	EQU	14		;SELECT DISK
FOPEN	EQU	15		;0FFH=NOT FOUND
FCLOSE	EQU	16		;   "	"
FSRCHF	EQU	17		;   "	"
FSRCHN	EQU	18		;   "	"
ERASE	EQU	19		;NO RET CODE
FREAD	EQU	20		;0=OK, 1=EOF
FWRTE	EQU	21		;0=OK, 1=ERR, 2=?, 255=NO DIR SPC
FMAKE	EQU	22		;255=BAD
FREN	EQU	23		;255=BAD
GDISK	EQU	25		;GET CURRENT DISK
FDMA	EQU	26
GALLOC	EQU	27		;GET ALLOCATION ADDRESS
GDPB	EQU	31		;GET DISK PARAMETER ADDRESS
GUSER	EQU	32		;GET/SET USER CODE
BDOS	EQU	5
FCB	EQU	5CH
;
	END	START
N ADDRESS
GDPB	EQU	31		;GE