;*****		     
;
;	COPYDOS -- List, Dump, and Move Z-DOS files
;			
;	Glenn F. Roberts	2/22/84
;	Version	1.1
;
;	MODIFIED BY P. SWAYNE, HUG  14-MAY-84
;
;	This program runs on the H/Z-100 series computers
;	and requires two DS/DD 5-1/4" disk drives.  Drive
;	A: must be logged in with a DS disk before this
;	program is executed.  Drive A: is always assumed
;	to contain a Z-DOS formatted disk and drive B: to
;	contain a CP/M formatted disk.  More help is avail-
;	able from the documentation or via the HELP key.
; 

	ORG	100H
;
;	Memory addresses
;
BOOT	EQU	0000H		;Warm boot address
BIOSPG	EQU	0002H		;Page where BIOS resides
BDOS	EQU	0005H		;BDOS entry address
TICCNT	EQU	000BH		;TIC counter
;
;	BDOS equates
;
CONIN	EQU	01H		;Single char input from CON:
TYPEF	EQU	02H		;write to console
DIRCIO	EQU	06H		;Direct console I/O
PRINTF	EQU	09H 		;print string
RDSTR	EQU	0AH		;read string from console buffer
RCS	EQU	0BH		;Read console status (char ready?)
RESET	EQU	0DH		;RESET DISK SYSTEM
SLD	EQU	0EH		;Select Logical Disk
CLOSE	EQU	10H		;close a file
SEARCH	EQU	11H		;search directory for first file
SRCHN	EQU	12H		;search directory for next file
ERAFIL	EQU	13H		;erase (delete) a file
WRITE	EQU	15H		;write sequential record
CREATE	EQU	16H		;create a file
SETDMA	EQU	1AH		;set DMA address
GCDD	EQU	19H		;Get Current Default Disk
RLDD	EQU	25H		;Reset logical disk drive
GETDPB	EQU	1FH		;Get Disk Parameter Block
;
;	Offsets in BIOS page
;	
BISLDK	EQU	1BH		;Select	disk
BISTRK	EQU	1EH		;Select	track
BISSEC	EQU	21H		;Select	sector
BISDMA	EQU	24H		;Set DMA address
BIREAD	EQU	27H		;Read 128 byte sector
BICLRB	EQU	3FH		;Clear buffers for drive
;
;	ASCII equates
;
CNTLC	EQU	03H		;Control-C
CR	EQU	0DH		;Carriage return
LF	EQU	0AH		;Line feed
ESC	EQU	1BH		;ESCape
BEL	EQU	07H		;BELL (cntl-g)
TAB	EQU	09H		;Horizontal TAB
CNTLZ	EQU	1AH		;Z-DOS EOF in text files
F1KEY	EQU	'S'		;f1 = ESC + 'S'
F2KEY	EQU	'T'		;f2 = ESC + 'T'
F3KEY	EQU	'U'		;f3 = ESC + 'U'
F4KEY	EQU	'V'		;f4 = ESC + 'V'
F5KEY	EQU	'W'		;f5 = ESC + 'W'
F6KEY	EQU	'P'		;f6 = ESC + 'P'
HLPKEY	EQU	'~'		;Help = ESC + '~'
;
;	Misc. equates
;
CPMSIZ	EQU	128		;CP/M sector size (bytes)
BDOSER	EQU	0FFH		;Error return code from BDOS
DIRWID	EQU	6		;no. of dir entries to list per line
FNTICS	EQU	2		;no. of tics used to detect Fn key
DSBLSH	EQU	04H		;Block shift for DS CP/M 5-1/4"
DSBLMA	EQU	0FH		;Block mask for DS CP/M 5-1/4"
;
;	Z-DOS file structure equates
;
ZDSSIZ	EQU	512		;Z-DOS sector size (bytes)
SBOOT	EQU	1		;1st sector is boot sector
SFAT1	EQU	2		;2nd sector is FAT #1
SFAT2	EQU	3		;3rd sector is FAT #2
SDIR	EQU	4		;4th sector is directory start
DS548	EQU	0FFH		;FAT entry for DS, 5.25" 48TPI
SS548	EQU	0FEH		;FAT entry for SS, 5.25" 48TPI
ZDLCLU	EQU	0FF8H		;last cluster marker
DIRELN	EQU	32		;directory entry length (bytes)
OCLUS	EQU	26		;offset in entry to cluster # (bytes)
OFSIZE	EQU	28		;offset in entry to file size (bytes)
DENTRY	EQU	0E5H		;denotes deleted file entry
LENTRY	EQU	0		;denotes last file entry in directory
FATSIZ	EQU	1		;FAT size (sectors)
FNLEN	EQU	11		;File name length (characters)
FLNAM	EQU	8		;Length of name part (characters)
FLEXT	EQU	3		;Length of extension part (characters)
SSSPC	EQU	1		;Single sided: sectors per cluster
SSFSIZ	EQU	4		;Single sided: directory size (sectors)
SSFMAX	EQU	ZDSSIZ/DIRELN*SSFSIZ	;SS: max directory entries
DSSPC	EQU	2		;Double sided: sectors per cluster
DSFSIZ	EQU	7		;Double sided: directory size (sectors)
DSFMAX	EQU	ZDSSIZ/DIRELN*DSFSIZ	;DS: max directory entries
;
;	Main Program
;
START:	LXI	SP,STACK	;Use our own stack
	LXI	D,INTRO
	CALL	TYPTX		;PRINT INTRO
GCDRV:	LXI	D,MCDRV
	CALL	TYPTX		;PROMPT FOR CP/M DRIVE
	MVI	C,CONIN
	CALL	BDOS		;GET IT
	CPI	3
	JZ	EXIT2		;CONTROL-C, EXIT
	CPI	13		;DEFAULT?
	JZ	GZDRV
	ANI	5FH		;CAPITALIZE
	SUI	'A'		;REMOVE ASCII+1
	JC	GCDRV		;BAD ENTRY
	CPI	16
	JNC	GCDRV		;BAD ENTRY
	INR	A		;MAKE DRIVE NO. START WITH 1
	STA	CDRV1		;AND STORE NO.
	STA	CDRV2
	ADI	'@'		;ADD BACK ASCII
	STA	CDRV3		;AND SET UP MSG
GZDRV:	LXI	D,MZDRV
	CALL	TYPTX		;PROMPT FOR Z-DOS DRIVE
	MVI	C,CONIN
	CALL	BDOS		;GET IT
	CPI	3
	JZ	EXIT2		;CONTROL-C, EXIT
	CPI	13		;CR?
	JZ	GOTDRV
	ANI	5FH		;CAPITALIZE
	SUI	'A'		;REMOVE ASCII+1
	JC	GZDRV		;BAD ENTRY
	CPI	16
	JNC	GZDRV		;BAD ENTRY
	STA	ZDRV1		;STORE RESULT
	STA	ZDRV2
	INR	A		;MAKE DRIVE 1-N
	STA	ZFCB		;SET UP ZDOS DRIVE FCB
	ADI	'@'		;ADD BACK ASCII
	STA	ZDRV3		;AND SET UP MSGS
	MOV	B,A
	LDA	CDRV3		;GET CP/M DRIVE
	CMP	B		;COMPARE WITH Z-DOS
	JNZ	GOTDRV		;NOT SAME, GO ON
	LXI	D,SAMMSG
	CALL	TYPTX		;ELSE, ERROR
	JMP	GCDRV		;AND TRY AGAIN
	STA	ZDRV4

;	DRIVES SELECTED -- ASK FOR CP/M DISK IN Z-DOS DRIVE

GOTDRV:	LXI	D,INSMSG
	CALL	TYPTX
WAICR:	MVI	C,CONIN
	CALL	BDOS
	CPI	13		;CR?
	JNZ	WAICR		;IF NOT, WAIT
	MVI	C,RESET
	CALL	BDOS		;RESET DISK SYSTEM
	LXI	D,ZFCB
	MVI	C,SEARCH
	CALL	BDOS		;SEARCH DIRECTORY ON DISK IN Z-DOS DRIVE

	MVI	C,GCDD		;get current disk drive
	CALL	BDOS		;via BDOS
	STA	CURDRV		;save it for later
	MVI	E,0		;select disk 0=A:
ZDRV1	EQU	$-1
	MVI	C,SLD		;Select Logical Disk
	CALL	BDOS		;via BDOS
	MVI	C,GETDPB	;Get Disk Parameter Block
	CALL	BDOS		;via BDOS
	INX	H		;(HL) = disk parameter block
	INX	H		;increment to block shift
	MOV	A,M		;A = Block Shift for A: disk
	CPI	DSBLSH		;Double Sided ?
	JNZ	BADCPM		;NO, must abort
	INX	H		;(HL) = block mask
	MOV	A,M		;A = Block Mask for A: disk
	CPI	DSBLMA		;Double Sided ?
	JZ	BEGIN		;YES, ok to continue
;
; --- Block Shift & Mask don't match double sided values
;
BADCPM:	LXI	D,NOTDS		;Message: A: is not double sided
	CALL	TYPTX		;report the error and
	JMP	GCDRV		;then restart.
;
;	Print introduction message and command prompt
;
BEGIN:	LXI	D,INTRO		;Print intro message
	CALL	TYPTX		;on console
	LXI	D,PROMPT	;Print prompt message
	CALL	TYPTX		;on 25th line
;
;	Main command loop - read function key
;
GETCMD:	CALL	RCDISK		;Always reset the CP/M disk
	LXI	D,CMDPR		;Print command prompt
	CALL	TYPTX		;on console
	CALL	RDKEY		;read key, possibly fn key
	JC	DOFN		;'C' --> function key
	CPI	CNTLC		;control-C --> abort
	JZ	EXIT
;
; --- Illegal key hit
;
BADKEY:	CALL	BEEP		;ring bell
	JMP	GETCMD		;and return to main loop
;
;	Process a function key
;
DOFN:	CPI	F1KEY		;F1 ?
	JNZ	CHKF2		;NO, jump
;
; --- F1 key --> Directory of Z-DOS disk
;
DOF1:	LXI	D,F1MSG		;print command
	CALL	TYPTX
	CALL	SHDIR		;show directory
	JMP	GETCMD		;and jump to command loop.
;
CHKF2:	CPI	F2KEY		;F2 key ?
	JNZ	CHKF3		;NO, jump
;
; --- F2 key --> Directory of CP/M disk
;
DOF2:	LXI	D,F2MSG		;print command
	CALL	TYPTX
	CALL	SHCDIR		;show CP/M directory
	JMP	GETCMD		;and return to command level
;
CHKF3:	CPI	F3KEY		;F3 key ?
	JNZ	CHKF4		;NO, jump
;
; --- F3 key --> Type a file in ASCII
;
DOF3:	LXI	D,F3MSG		;print command
	CALL	TYPTX
	CALL	TYPFIL		;Type a Z-DOS file
	JMP	GETCMD		;not yet implemented
;
CHKF4:	CPI	F4KEY		;F4 key ?
	JNZ	CHKF5		;NO, jump
;
; --- F4 key --> Dump a file in hex
DOF4:	LXI	D,F4MSG		;print command
	CALL	TYPTX
	CALL	DMPFIL		;Dump a Z-DOS file in hex
	JMP	GETCMD		;not yet implemented	
;
CHKF5:	CPI	F5KEY		;F5 key ?
	JNZ	CHKF6		;NO, jump
;
; --- F5 key --> Copy a file
;
DOF5:	LXI	D,F5MSG		;print command
	CALL	TYPTX
	CALL	MOVFIL		;Move file from Z-DOS to CP/M
	JMP	GETCMD		;and jump to command loop.
;
CHKF6:	CPI	F6kEY		;F6 key ?
	JNZ	CHKHLP		;NO, jump
;
; --- F6 key --> Exit to CP/M
;
EXIT:	LXI	D,F6MSG		;print command
	CALL	TYPTX
	LXI	D,REPSYS
	CALL	TYPTX		;PROMPT FOR REPLACEMENT OF SYSTEM DISK
DOF61:	CALL	READCH		;read any character
	JZ	DOF61		;loop 'til key hit
	CPI	13		;CR?
	JNZ	DOF61		;IF NOT, WAIT
EXIT1:	LXI	D,RSTCON	;reset console
	CALL	TYPTX
EXIT2:	LDA	CURDRV		;A = current drive at start
	MOV	E,A		;reset it as the current drive
	MVI	C,SLD		;Select Logical Drive
	CALL	BDOS		;via BDOS
	MVI	C,RESET
	CALL	BDOS		;RESET DISK SYSTEM
	JMP	BOOT		;and jump to warm boot
;
CHKHLP:	CPI	HLPKEY		;HELP key ?
	JNZ	BADKEY		;NO, must be bad key
	LXI	D,HLPMSG	;YES, print help message
	CALL	TYPTX
	JMP	GETCMD		;and loop back to command level.

;
;	SHCDIR -- Show CP/M directory
;
;	ENTRY:	None
;
;	EXIT:	None
;
;	USES:	All
;
SHCDIR:	LXI	D,CDIRTX	;Print intro message
	CALL	TYPTX
	LXI	D,CPMBUF	;(DE) = DMA buffer
	MVI	C,SETDMA	;Set DMA address
	CALL	BDOS		;via BDOS
	LXI	H,CFILE		;point to file name in FCB
	MVI	C,FNLEN		;C = length of file name
SHCD1:	MVI	M,'?'		;fill with "?"
	INX	H		;point to next
	DCR	C		;count chars
	JNZ	SHCD1		;and loop 'til done
	LXI	H,FCB
	CALL	ZROFCB		;zero tail of FCB
	LXI	D,FCB		;(DE) = FCB
	MVI	C,SEARCH	;look for match entry
	CALL	BDOS		;via BDOS
	CPI	BDOSER		;error return ?
	MVI	B,DIRWID	;(prepare B in case not)
	JNZ	SHCD2		;NO error, continue
;
; --- No files on CP/M disk
;
	LXI	D,NOFILE	;print "No Files" message
	CALL	TYPTX		;on console
	RET			;and return
;
; --- Print a file name
;
SHCD2:	RLC			;A = A * 2
	RLC			;*4
	RLC			;*8
	RLC			;*16
	RLC			;*32
	LXI	H,CPMBUF	;(HL) = DMA buffer
	CALL	DADA		;(HL) = matched entry
	INX	H		;skip over user no.
	CALL	PRTENT		;print the entry
	MVI	A,' '		;then print a blank
	CALL	PCHAR
	DCR	B		;count entries on line
	JNZ	SHCD3		;not time for wrap around yet
	MVI	B,DIRWID	;wrap around
	CALL	CRLF
SHCD3:	MVI	C,SRCHN		;search for next match
	PUSH	B		;save line counter
	CALL	BDOS		;via BDOS
	POP	B		;restore line counter
	CPI	BDOSER		;error return ?
	JNZ	SHCD2		;NO, loop
	MOV	A,B		;done. check if we need
	CPI	DIRWID		;a trailing CR/LF
	CNZ	CRLF		;YES, print one
	RET			;and return

;
;	TYPFIL -- Type a Z-DOS file on the console
;		  (terminate listing when a control-Z
;		   is encountered.)
;
;	ENTRY:	None
;
;	EXIT:	None
;
;	USES:	All
;
TYPFIL:	CALL	OPENZ		;"Open" a Z-DOS file
	RC			;return if failed
	CALL	CRLF		;PRINT CR, LF
	CALL	CLRBUF		;clear type-ahead buffer
	LHLD	ZENTRY		;(HL) = directory entry
	CALL	GETSIZ		;BC = no. of 128 byte sectors
TYLOOP:	MOV	A,C		;check if BC = 0
	ORA	B
	RZ			;if so, return
	MVI	C,RCS		;read console status
	CALL	BDOS
	ORA	A		;set flags
	JNZ	CLRBUF		;if key hit quit
	CALL	RDZ128		;else read 128 bytes of file
	DCX	B		;and count down sector
	CNC	DMPASC		;No 'C' --> dump sector in ASCII
	JNC	TYLOOP		;loop 'til 'C' return
	RET

;
;	DMPASC -- "Dump" a sector in ASCII
;
;	ENTRY:	(HL) = buffer
;
;	EXIT:	'C' set if EOF marker found
;
;	USES:	A, F
;
DMPASC:	PUSH	B		;save registers
	PUSH	D
	PUSH	H
	MVI	B,CPMSIZ	;B = byte counter
DMPAS1:	MOV	A,M		;fetch a byte
	INX	H		;point to next
	CPI	CNTLZ		;EOF ?
	PUSH	PSW		;save flags
	CNZ	PCHAR		;NO, print the character
	POP	PSW		;get back flags
	STC			;set 'C' in case EOF found
	JZ	DMPAS2		;EOF --> quit
	DCR	B		;Not EOF, count byte
	JNZ	DMPAS1		;and loop 'til done
	ORA	A		;clear 'C', normal return
DMPAS2:	POP	H		;restore registers
	POP	D
	POP	B
	RET			;and return

;
;	DMPFIL -- "Dump" a file on console in hex
;
;	ENTRY:	None
;
;	EXIT:	None
;
;	USES:	All
;
DMPFIL:	CALL	OPENZ		;"Open" a Z-DOS file
	RC			;return if failed
	CALL	CLRBUF		;clear type-ahead buffer
	LHLD	ZENTRY		;(HL) = directory entry
	CALL	GETSIZ		;BC = no. of 128 byte sectors
DMLOOP:	MOV	A,C		;check if BC = 0
	ORA	B
	RZ			;if so, return
	MVI	C,RCS		;read console status
	CALL	BDOS
	ORA	A		;set flags
	JNZ	CLRBUF		;if key hit then quit
	CALL	RDZ128		;else read 128 bytes of file
	DCX	B		;and count down sector
	CNC	DMPHEX		;No 'C' --> dump sector in HEX
	JNC	DMLOOP		;loop 'til 'C' return
	RET

;
;	DMPHEX -- Dump a sector on console in hex
;
;	ENTRY:	(HL) = sector to dump
;
DMPHEX:	PUSH	B		;save registers
	PUSH	D
	PUSH	H
	MVI	B,8		;8 lines of hex
DMP1:	CALL	CRLF		;output a CR/LF
	MVI	C,16		;16 hex bytes per line
	PUSH	H		;save address of this line
DMP2:	MOV	A,M		;fetch a byte
	INX	H		;and point to next
	CALL	PHEX		;print it in hex
	MVI	A,' '		;and space to separate
	CALL	PCHAR		;from next byte
	DCR	C		;count bytes on line
	JNZ	DMP2		;and loop 'til done
;
; --- Line printed in hex, now in ASCII in rt. margin
;
	MVI	C,4		;print 4 blanks
DMP3:	MVI	A,' '		;to separate ASCII
	CALL	PCHAR
	DCR	C
	JNZ	DMP3
	XTHL			;save HL, get old HL
	MVI	C,16		;print 16 characters
DMP4:	MOV	A,M		;fetch a character
	INX	H		;and point to next
	CALL	PPRINT		;print if printable
	DCR	C		;count down chars
	JNZ	DMP4		;and loop 'til done
;
; --- Print next line
;
	POP	H		;get back HL
	DCR	B		;count down lines
	JNZ	DMP1		;and loop 'til done
	POP	H		;restore registers
	POP	D
	POP	B
	RET

;
;	PPRINT -- Print char or graphics representation
;
;	ENTRY:	A = any byte from 0-255
;
PPRINT:	PUSH	B		;use B for temp storage
	MOV	B,A		;save A for now
	ANI	10000000B	;test 8th bit
	JP	PPRIN1		;not set, jump
;
; --- 8th bit set, print in reverse video
;
	MVI	A,'p'		;ESC 'p' --> reverse
	CALL	DOESC
PPRIN1:	MOV	A,B		;get back char
	ANI	01111111B	;and clear 8th bit
	CPI	' '		;control char ?
	JC	PPRIN2		;YES, jump
	CPI	127		;DEL char ?
	JZ	PPRIN3		;YES, jump
;
; --- Normal ASCII char, print it
;
	CALL	PCHAR		;print the char
	JMP	PPRIN5		;and jump to check for reverse
;
; --- Control character, remap it
;
PPRIN2:	ADI	'^'		;add offset to printable
	JMP	PPRIN4		;and jump
;
; --- DEL character, remap it down to '~'
;
PPRIN3:	DCR	A		;map DEL to '~'
;
; --- Print A as a graphics character
;
PPRIN4:	PUSH	PSW		;save A for now
	MVI	A,'F'		;ESC 'F' --> enter graphics mode
	CALL	DOESC
	POP	PSW		;re-fetch char
	CALL	PCHAR		;print the graphics char
	MVI	A,'G'		;ESC 'G' --> exit graphics mode
	CALL	DOESC
;
; --- Turn off reverse video if set
;
PPRIN5:	MOV	A,B		;get original byte
	ANI	10000000B	;check 8th bit
	JP	PPRIN6		;jump if not set
	MVI	A,'q'		;ESC 'q' --> exit reverse video
	CALL	DOESC
PPRIN6:	POP	B		;restore B
	RET			;and return

;
;	DOESC -- Output an ESCape sequence
;
DOESC:	PUSH	PSW		;save 2nd char of sequence
	MVI	A,ESC		;print an ESCape
	CALL	PCHAR
	POP	PSW		;restore 2nd byte
	JMP	PCHAR		;and jump to print it

;
;	PHEX -- Print a byte in hex
;
PHEX:	PUSH	PSW		;save for now
	RRC
	RRC
	RRC
	RRC			;rotate to lower 4 bits
	CALL	PRTNIB		;print nibble
	POP	PSW		;get back original
	CALL	PRTNIB		;and print nibble
	RET

;
;	PRTNIB -- Print a nibble on console
;
PRTNIB:	ANI	00001111B	;mask lower nibble
	ADI	'0'		;convert to ASCII
	CPI	'9'+1		;'C' set if decimal digit
	JC	PCHAR		;YES, just print it
	ADI	'A'-('9'+1)	;NO, convert to HEX A-F
	JMP	PCHAR		;then print it

;
;
;	OPENZ -- "Open" a Z-DOS file
;
;	ENTRY:	None
;
;	EXIT:	None
;
;	USES:	All
;
OPENZ:	CALL	RZDISK		;Reset the Z-DOS disk
	JNC	OPENZ1		;No 'C' --> disk ok
;
; --- Not a Z-DOS disk, set 'C' and return
;
	LXI	D,BADDSK	;type error message
	CALL	TYPTX		;on console
	STC			;'C' --> file not open
	RET
;
; --- OK, Z-DOS disk, clear buffers
;
OPENZ1:	CALL	CLRBUF		;clear type-ahead buffer
	LXI	D,FNMSG		;Print file prompt message
	CALL	TYPTX		;on console
	LXI	H,ZFILE		;(HL) = buffer for file
	CALL	GFNAME		;get the file name
;
; --- If NULL line entered, cancel the operation
;
	JNC	OPENZ2		;NO 'C', continue
	LXI	D,MOVCAN	;notify of cancellation
	CALL	TYPTX
	STC			;'C' --> file not opened
	RET			;and return
OPENZ2:	LXI	D,ZFILE		;(DE) = file name
	LXI	H,DIRECT	;(HL) = directory table
	MVI	C,DSFMAX	;C = max directory entries
	CALL	FFNAME		;Find the file name
	JNC	OPENZ3		;No 'C', then file was found
;
; --- Print error message, no file
;
	LXI	D,BADMSG	;print error message
	CALL	TYPTX
	STC			;'C' --> file not opened
	RET			;and return
;
; --- All's OK, set up cluster and sector indices
;
OPENZ3:	SHLD	ZENTRY		;Save pointer to Z-DOS file
	MVI	A,OCLUS		;add offset to 1st cluster
	CALL	DADA
	MOV	E,M		;load 1st cluster
	INX	H		;into the
	MOV	D,M		;DE register
	XCHG			;then switch to HL
	SHLD	NXTCLU		;and store it.
	LDA	SPC		;A = sectors per cluster
	RLC			;*2
	RLC			;*4 
	STA	NXTSEC		;to force a read 1st time
	XRA	A		;clear 'C', file's open
	RET

;
;	MOVFIL -- Move a file from Z-DOS to CP/M
;
;	ENTRY:	None
;
;	EXIT:	None
;
;	USES:	All
;
MOVFIL:	CALL	OPENZ		;"Open" a Z-DOS file
	RC			;'C' set --> can't open one
;
; --- Source file ok, set up for CP/M
;
	LXI	H,FCB		;(HL) = FCB
	CALL	ZROFCB		;zero out tail part
	LXI	D,ZFILE		;Make the default
	LXI	H,CFILE		;CP/M file name be
	MVI	A,FNLEN		;the same as Z-DOS
	CALL	MOVE		;file name.
;
; --- Get CP/M destination
;
FLOOP:	LXI	D,FNMSG2	;Prompt for name of
	CALL	TYPTX		;CP/M file destination
	LXI	H,ZFILE		;print default file
	CALL	PRTENT		;in prompt
	MVI	A,'>'		;then closing bracket
	CALL	PCHAR
	MVI	A,' '		;and blank
	CALL	PCHAR
	LXI	H,CFILE		;store answer in FCB
	CALL	GFNAME		;read the answer
	MVI	C,SEARCH	;search for the
	LXI	D,FCB		;file name via
	CALL	BDOS		;the BDOS
	CPI	BDOSER		;check if failed to find
	JZ	CREFIL		;if so, jump
	LXI	D,FEXIST	;else warn that file
	CALL	TYPTX		;already exists and
	CALL	YESNO		;is ok to delete (Y/N) ?
	RC			;NO --> return
;
; --- Delete the old file first
;
	MVI	C,ERAFIL	;erase the file
	LXI	D,FCB
	CALL	BDOS		;via the BDOS
;
; --- Create new CP/M file
;
CREFIL:	LXI	H,CFILE		;first check if the file name
	CALL	CHKNAM		;has any illegal characters
	JNC	CREF1		;if not, then continue
;
; --- File name has illegal characters
;
	LXI	D,BADNAM	;inform user that the name
	CALL	TYPTX		;is illegal
	RET			;and return
CREF1:	MVI	C,CREATE	;create a new CP/M file
	LXI	D,FCB
	CALL	BDOS
	CPI	BDOSER		;check for full disk
	JNZ	CPYFIL		;jump if not full
	LXI	D,DIRFUL	;else warn that dir
	CALL	TYPTX		;is full and leave loop
	RET			;and return
;
; --- Both files set up, now move the file
;
CPYFIL:	LHLD	ZENTRY		;get pointer to Z-DOS entry
	CALL	GETSIZ		;then get no. of sectors in BC
;
; --- Read sectors and write them to CP/M file
;
LOOP:	MOV	A,C		;check if
	ORA	B		;sector count = 0
	JZ	NOMORE		;if so, move is done
	CALL	RDZ128		;else read a sector
	DCX	B		;and count down sectors
	JC	NOMORE		;'C' set by RDZ128 --> EOF
	PUSH	B		;save the count
	XCHG			;DE = data address
	MVI	C,SETDMA	;Set the DMA address
	CALL	BDOS		;via the BDOS
	MVI	C,WRITE		;then request a sequential
	LXI	D,FCB		;write operation
	CALL	BDOS		;via the BDOS
	POP	B		;restore sector counter
	ORA	A		;check for A=0
	JZ	LOOP		;OK, keep looping
;
; --- The CP/M disk has become full !
;
DSKFUL:	MVI	C,CLOSE		;close the file 
	LXI	D,FCB
	CALL	BDOS
	LXI	D,BADMOV	;then inform user that
	CALL	TYPTX		;move failed
	RET			;and return
;
; --- Normal end of move operation
;
NOMORE:	MVI	C,CLOSE
	LXI	D,FCB		;close the file
	CALL	BDOS
	LXI	D,GOODMV	;then inform the user that
	CALL	TYPTX		;move succeeded
	RET			;and return

;
;	CHKNAM -- Check if name contains any
;		  illegal characters.
;
;	ENTRY:	(HL) = file name
;
;	EXIT:	'C' set if illegal chars found
;
;	USES:	A, F
;
CHKNAM:	PUSH	B		;save registers
	PUSH	D
	PUSH	H
	MVI	B,FNLEN		;B = length of file name
CHKN1:	MVI	C,TEND-TBEG	;C = length of table
	LXI	D,TBEG		;(DE) = table of illegal chars
CHKN2:	LDAX	D		;load char from table
	CMP	M		;compare with char from name
	JZ	CHKN3		;equal ? if so, illegal
	INX	D		;else point to next table entry
	DCR	C		;count down in table
	JNZ	CHKN2		;and loop 'til table searched
	INX	H		;point to next char in name
	DCR	B		;and count down in name
	JNZ	CHKN1		;and loop 'til name searched
	XRA	A		;clear A and 'C' flag
	JMP	CHKN4		;and jump to exit
CHKN3:	STC			;error return --> 'C' set
CHKN4:	POP	H		;restore registers
	POP	D
	POP	B
	RET
;
; --- table of illegal characters
;
TBEG	DB	'<>.,;:=?*[]'
TEND:

;
;	RCDISK -- Reset CP/M disk in B:
;
RCDISK:	PUSH	B		;save registers
	PUSH	D
	PUSH	H
	LXI	D,0002H		;Bit map, reset B:
CDRV1	EQU	$-2
	MVI	C,RLDD		;Reset Logical Disk Drive
	CALL	BDOS		;via BDOS
	POP	H
	POP	D
	POP	B
	RET

;
;	ZROFCB -- Zero tail part of FCB
;
;	ENTRY:	(HL) = FCB
;
;	USES:	A,C,H,L,F
;
ZROFCB:	MVI	A,FCBEXT-FCB	;A = offset to part to zero fill
	CALL	DADA		;add to HL
	MVI	C,FCBEND-FCBEXT	;zero out last part of FCB
ZROF1:	MVI	M,0		;zero a byte
	INX	H		;point to next
	DCR	C		;count bytes as we go
	JNZ	ZROF1		;and loop 'til done.
	RET

;
;	RZDISK -- Reset the Z-DOS disk
;
;	ENTRY:	None
;
;	EXIT:	'C' set if not a Z-DOS disk or if
;		    unable to read this Z-DOS format
;
;	USES:	All
;
RZDISK:	MVI	C,0		;Looking at drive 0 (=A:)
ZDRV2	EQU	$-1
	MVI	E,1		;1 --> Not first access
	MVI	L,BISLDK	;select the drive
	CALL	BIOS		;via the BIOS
	MVI	L,BICLRB	;then clear the buffers
	CALL	BIOS		;via the BIOS
;
; --- Load the File Allocation Table (FAT)
;
	LXI	B,FATSIZ	;# sectors to read
	LXI	D,SFAT1		;read FAT #1
	LXI	H,FAT		;into FAT buffer area
	CALL	READ		;read the FAT.
;
; --- 2nd and 3rd bytes in FAT should both be 0FFH
;
	LHLD	FAT+1		;Load HL = bytes 2 & 3
	MOV	A,L		;A = 2nd byte
	ANA	H		;AND it with 3rd byte
	CPI	0FFH		;answer = 255 ?
	STC			;set 'C' in case not
	RNZ			;return with error if not
;
; --- Determine if it is Double Single or Illegal
;
	LDA	FAT		;get first byte in FAT
	CPI	DS548		;Double Sided 5.25" 48 TPI ?
	JZ	DBLSID		;YES, jump
	CPI	SS548		;Single Sided 5.25" 48 TPI ?
	STC			;'C' in case error
	RNZ			;NO, error
;
; --- Initialize tables for single sided
;
SNGSID:	MVI	A,SSFSIZ	;Directory size
	STA	DIRSIZ
	MVI	A,SSFMAX	;Max # of files
	STA	MAXF
	MVI	A,SSSPC		;Sectors per cluster
	STA	SPC
	JMP	LDDIR
;
; --- Initialize tables for double sided
;
DBLSID:	MVI	A,DSFSIZ	;Directory size
	STA	DIRSIZ
	MVI	A,DSFMAX	;Max # of files
	STA	MAXF
	MVI	A,DSSPC		;Sectors per cluster
	STA	SPC
;
; --- Load the directory
;
LDDIR:	LDA	DIRSIZ		;A = # sectors in directory
	MOV	C,A
	MVI	B,0		;BC = directory size
	LXI	D,SDIR		;DE = directory starting sector
	LXI	H,DIRECT	;HL = buffer address
	CALL	READ		;read the directory sectors
	LDA	MAXF		;A = max # of directory entries
	MOV	C,A		;C = max # of directory entries
	CALL	SRTDIR		;sort the directory
	XRA	A		;Clear 'C'
	RET			;and return

;
;	SRTDIR -- Sort the directory in memory
;
;	ENTRY:	(HL) = directory buffer area
;		C = Max # of directory entries
;
;	USES:	A,B,C,F
;
SRTDIR:	PUSH	B		;save registers
	PUSH	D
	PUSH	H
SORT1:	MOV	E,L		;DE = HL
	MOV	D,H
	MOV	B,C		;B = count for DE register
	DCR	C		;count down # of entries
	JZ	SORT4		;done? if so exit
	MOV	A,M		;fetch 1st byte of entry
	CPI	LENTRY		;is it the last one ?
	JZ	SORT4		;if so, exit
;
; --- Use DE to point to comparative entry
;
SORT2:	PUSH	H		;save HL
	LXI	H,DIRELN	;HL = directory entry length
	DAD	D		;HL = DE + DIRELN
	XCHG			;DE = DE + DIRELN
	POP	H		;restore HL
;
; --- See if comparative register is last
;
	DCR	B		;count down DE
	JZ	SORT3		;YES, jump to next HL
	LDAX	D		;look at first byte
	CPI	LENTRY		;is this last entry ?
	JZ	SORT3		;YES, jump to next HL
;
; --- Compare the two strings
;
	PUSH	B		;save BC for now
	MVI	C,FNLEN		;C = length of file name
	CALL	STRCMP		;compare (DE) with (HL)
	MVI	C,DIRELN	;C = length of directory entry
	CC	STSWAP		;'C' set --> swap the entries
	POP	B		;get back our BC
	JMP	SORT2		;and loop ...
;
; --- Increment HL to point to next entry
;
SORT3:	LXI	D,DIRELN	;DE = directory entry length
	DAD	D		;HL = HL + DIRELN
	JMP	SORT1		;and continue outer loop ...
;
; --- directory sorted, restore registers
;
SORT4:	POP	H
	POP	D
	POP	B
	RET

;
;	STRCMP -- Compare two strings
;
;	ENTRY:	(HL) = 1st string
;		(DE) = 2nd string
;		C = string length
;
;	EXIT:	'C' set if string 2 < string 1
;		'Z' set if strings are equal
;
;	USES:	A,C,F
;
STRCMP:	PUSH	D		;save registers
	PUSH	H
STRC1:	LDAX	D		;fetch char from string 2
	CMP	M		;compare with string 1
	JNZ	STRC2		;not equal? if so done
	INX	D		;else point to next char
	INX	H		;in both strings
	DCR	C		;and count down chars
	JNZ	STRC1		;looping 'til done
STRC2:	POP	H		;done, restore registers
	POP	D
	RET			;and return

;
;	STSWAP -- Swap strings
;
;	ENTRY:	(HL) = first string
;		(DE) = second string
;		C = string lengths
;
;	USES:	A,B,C,F
;
STSWAP:	PUSH	D		;save registers
	PUSH	H
STSW1:	MOV	B,M		;save char from 1st string
	LDAX	D		;fetch char from 2nd string
	MOV	M,A		;store it in 1st string
	MOV	A,B		;get char from 1st string
	STAX	D		;and store in 2nd string
	INX	H		;point to next in 1st
	INX	D		;point to next in 2nd
	DCR	C		;count chars
	JNZ	STSW1		;and loop 'til done ...
	POP	H		;restore registers
	POP	D
	RET			;and return

;
;	RDZ128 -- Read a Z-DOS 128 byte sector
;
;	ENTRY:	None
;
;	EXIT:	(HL) = 128 byte sector
;		'C' set if EOF marker found
;
;	USES:	A,F,D,E,H,L
;
RDZ128:	LXI	H,NXTSEC	;(HL) = next sector count
	LDA	SPC		;A = sectors per cluster
	RLC			;*2
	RLC			;*4
	CMP	M		;compare with count
	JNZ	PTNEXT		;else just point to next
;
; --- Read a new cluster
;
	LHLD	NXTCLU		;HL = next cluster no.
	XCHG			;DE = cluster no.
	LXI	H,ZDLCLU	;check if EOF marker
	CALL	HLCPDE
	JC	ZDEOF		;EOF --> jump
	LXI	H,CLUSTR	;(HL) = cluster address
	CALL	RDCLUS		;read a cluster
	LXI	H,FAT		;(HL) = FAT
	CALL	NXTFAT		;get next cluster no.
	XCHG			;HL = next cluster
	SHLD	NXTCLU		;store it
	XRA	A		;reset sector number within
	STA	NXTSEC		;cluster
PTNEXT:	LXI	H,NXTSEC	;point to sector number
	MOV	A,M		;A = next sector
	INR	M		;increment the sector no.
	LXI	H,CLUSTR	;(HL) = cluster
	LXI	D,CPMSIZ	;offset to add to cluster addr.
	ORA	A		;check if 0; clear 'C'
PTLOOP:	RZ			;if so, then we're done
	DAD	D		;else add one offset
	DCR	A		;and count down
	JMP	PTLOOP		;and loop 'til done
;
ZDEOF:	STC			;'C' --> EOF found
	RET

;
;	GETSIZ -- Get the size of a Z-DOS file via
;		  the 4 byte entry in the directory
;
;	ENTRY:	(HL) = the directory entry
;
;	EXIT:	BC = No. of 128 byte sectors in file
;		(NOTE: This assumes file is smaller
;			than approx. 8 megabytes)
;
;	USES:	B,C,A,F
;
GETSIZ:	PUSH	D		;save registers
	PUSH	H
;
; --- Load 4 bytes into DE, BC
;
	MVI	A,OFSIZE	;offset to file size
	CALL	DADA		;(HL) = file size (4 bytes)
	MOV	A,M		;get lowest order byte
	PUSH	PSW		;and save for later
	MOV	C,M		;load low 2 bytes
	INX	H
	MOV	B,M		;into BC
	INX	H
	MOV	E,M		;and upper 2 bytes
	INX	H
	MOV	D,M		;into DE
;
; --- Shift 4 bytes right 7 bits (divide by 128)
;
	MVI	L,7		;L = counter, shift 7 bits RT
GSZ1:	MOV	A,D		;Shift highest byte
	ANA	A		;(clear 'C' first)
	RAR			;right 1 bit
	MOV	D,A		;and save it
	MOV	A,E		;shift next byte
	RAR	
	MOV	E,A		;right 1
	MOV	A,B
	RAR			;then next byte
	MOV	B,A
	MOV	A,C		;and finally the
	RAR			;4th byte
	MOV	C,A
	DCR	L		;count the bits
	JNZ	GSZ1		;and loop 'til done
	POP	PSW		;get back least sig.
	POP	H		;restore other reg's.
	POP	D
;
; --- Check if multiple of 128, if not, add 1 sector
;
	ANI	01111111B	;any of 7 low bits set ?
	RZ			;no, OK then we're done.
	INX	B		;yes, must read 1 more sector
	RET

;
;	SHDIR -- List Z-DOS directory on screen
;
;	ENTRY:	None
;
;	EXIT:	None
;
;	USES:	All
;
SHDIR:	CALL	RZDISK		;first reset Z-DOS disk
	JNC	SHL0		;no 'C' --> OK to proceed
	LXI	D,BADDSK	;prompt to replace disk
	CALL	TYPTX
	RET
SHL0:	LXI	D,DIRTXT	;First print a
	CALL	TYPTX		;message about directory

	MVI	B,DIRWID	;Printing DIRWID entries per line
	LDA	MAXF		;A = max # of entries
	MOV	C,A		;C = max # of entries
	LXI	H,DIRECT	;as stored in DIRECTory

SHL1:	MOV	A,M		;Fetch first char of entry
	CPI	DENTRY		;deleted entry	?	
	JZ	SHL2		;skip deleted entries
	CPI	LENTRY		;last entry ?
	JZ	SHL3		;quit if no more
	CALL	PRTENT		;print directory entry
	MVI	A,' '		;and separate from next
	CALL	PCHAR		;entry with a blank
	DCR	B		;count down entries on line
	JNZ	SHL2		;if not done yet then continue
	MVI	B,DIRWID	;else reset counter
	CALL	CRLF		;print CR/LF at end of line
SHL2:	MVI	A,DIRELN	;Increment HL to point to
	CALL	DADA		;the next directory entry.
	DCR	C		;Count down number of entries
	JNZ	SHL1		;and loop 'til count down done

SHL3:	MOV	A,B		;A = width counter
	CPI	DIRWID		;was it just reset ?
	CNZ	CRLF		;if not ,print a CR/LF at end
	RET			;return...

;
;	PRTENT -- Print a directory entry
;
;	ENTRY:	(HL) = file name as stored in FCB
;
;	USES:	A, F
;
PRTENT:	PUSH	B		;Save BC
	PUSH	H		;and HL registers
	MVI	C,FNLEN+1	;Name length + '.'
	MVI	B,FLNAM		;length of name part
PRTE1:	MOV	A,M		;get a character
	INX	H		;and point to next
	CPI	' '		;if it is blank
	JZ	PRTE2		;then don't print it
	CALL	PCHAR		;else print it and
	DCR	C		;count no of printed chars
PRTE2:	DCR	B		;count chars in name part
	JNZ	PRTE1		;and loop 'til done
	MVI	A,'.'		;then print a '.'
	CALL	PCHAR		;to separate extension
	DCR	C		;and count printed char
	MVI	B,FLEXT		;length of extension
PRTE3:	MOV	A,M		;get a character
	INX	H		;and point to next
	CALL	PCHAR		;print the char
	DCR	C		;count printed char
	DCR	B		;count char in extension
	JNZ	PRTE3		;until extension done
	INR	C		;increment 1 in case done
PRTE4:	DCR	C		;count down
	JZ	PRTE5		;until done
	MVI	A,' '		;else pad with blanks
	CALL	PCHAR
	JMP	PRTE4		;and loop ...
PRTE5:	POP	H		;restore registers
	POP	B
	RET

;
;	NXTFAT -- Look up next FAT cluster from	current	one
;
;	ENTRY:	DE = FAT cluster No.
;		HL = FAT address
;
;	EXIT:	DE = next FAT cluster No.
;
NXTFAT:	MOV	A,E		;Save lower 8 bits of
	PUSH	PSW		;cluster number	on stack
	PUSH	H		;save FAT address
	MOV	H,D		;HL = DE
	MOV	L,E
	DAD	H		;HL = 2*N 
	DAD	D		;HL = 3*N 
	XCHG			;DE = 3*N
	MVI	A,1		;shift DE right	1  
	CALL	SHRDE		;DE = (3*N) div	2
	POP	H		;Restore HL = FAT address
	DAD	D		;add DE	= offset
	MOV	E,M		;Fetch 2 bytes from FAT
	INX	H		;into DE
	MOV	D,M
	POP	PSW		;Get back lower	8 bits of 
	ANI	00000001B	;entry.	Was N ODD?
	JZ	CLEVEN		;NO, even -- Jump
;
; --- Odd numbered cluster
;
CLODD:	MVI	A,4		;Right shift the answer
	CALL	SHRDE		;by 4 bits, then
	RET			;return
;
; --- Even numbered cluster
;
CLEVEN:	MOV	A,D		;Mask out the answer
	ANI	00001111B	;to 12 bits
	MOV	D,A		;then
	RET			;return

;
;	RDCLUS -- Read cluster 
;
;	ENTRY:	DE = Cluster No. from FAT
;		HL = Buffer address to read into
;
;	USES:	A, F
;
RDCLUS:	PUSH	B		;Save registers
	PUSH	D
	PUSH	H		;HL register pairs

	DCX	D		;DE = N	- 1
	DCX	D		;DE = N - 2 (1st cluster is #2)
	LXI	H,SDIR		;skip boot, FAT1, FAT2
	LDA	DIRSIZ		;A = directory size
	CALL	DADA		;add offset for directory
	LDA	SPC		;Sectors per channel
	MOV	C,A		;BC = sectors per channel
	MVI	B,0
RDCLU1:	DAD	D		;add in (N - 2)
	DCR	A		;count down
	JNZ	RDCLU1
;
; --- Remap sectoring if single sided
;
	LDA	SPC		;look at sectors per cluster
	CPI	SSSPC		;to see if Z-DOS disk is SS or DS
	JNZ	RDCLU2		;if not, jump
;
; --- Single sided, kludge to remap sectoring like DS/DD
;
	MOV	E,L
	MOV	D,H		;DE = Sector # = S
	DCX	D		;DE = (S-1)
	MVI	A,11111000B	;map out lower 3 bits
	ANA	E		;in DE
	MOV	E,A		;DE = ((S-1) div 8)*8
	DAD	D		;HL = S + ((S-1) div 8)*8
RDCLU2:	XCHG			;DE = starting sector
	POP	H		;restore buffer address
	CALL	READ		;read the cluster
	POP	D		;restore DE register
	POP	B
	RET			;and return

;
;	GFNAME -- Get file name, blank filled, upper case
;		(NOTE: if user types CR then nothing is
;		 inserted into buffer, i.e. default stays
;		 and 'C' is set).
;
;	ENTRY:	HL = address for result
;
;	EXIT:	'C' set if NULL line entered
;
GFNAME:	PUSH	H		;save address
	MVI	C,RDSTR		;read string from console
	LXI	D,FNBUFF	;into buffer
	CALL	BDOS		;via BDOS
	LXI	H,FBCHR		;(HL) = character string
	LDA	FBACT		;A = no. of chars read
	ORA	A		;'Z' --> just hit CR
	JNZ	GFN2		;if not, then continue 
	POP	H		;else restore HL
	STC			;'C' --> NULL line
	RET			;and return now.
;
GFN2:	CALL	DADA		;point past end of string
	MVI	M,0		;put NULL terminator
	LXI	H,FBCHR		;(HL) = character string
	POP	D		;(DE) = address for result
	MVI	C,FLNAM		;File name
	CALL	GETTOK		;get name token
	CPI	'.'		;was there a decimal?
	JNZ	GFN1		;NO, skip next isn
	INX	H		;YES, move past decimal
GFN1:	MVI	C,FLEXT		;Extension
	CALL	GETTOK		;get extension token
	ORA	A		;clear 'C' for normal return
	RET			;and exit.
;
; --- Buffers for file name
;
FBULEN	EQU	FNLEN+2		;leave 2 extra chars to be friendly
FNBUFF:
FBMAX	DB	FBULEN		;max answer length
FBACT	DB	0		;returned actual length
FBCHR	DS	FBULEN		;actual buffer
	DB	0		;string terminator

;
;	FFNAME -- Find file name
;
;	ENTRY:	(HL) = directory table
;		(DE) = file name to find
;		C = no. of entries in table
;
;	EXIT:	(HL) = directory entry
;		'C' cleared if found, set if not
;
FFNAME:	PUSH	H		;save HL 
	PUSH	D		;and DE
	MVI	B,FNLEN		;# chars to match
FFN1:	LDAX	D		;fetch first character
	CMP	M		;and compare with table
	JNZ	FFN2		;No match, jump
	INX	D		;up pointers
	INX	H
	DCR	B		;count characters
	JNZ	FFN1		;and loop
;
; --- successful match
;
	POP	D
	POP	H		;restore registers
	XRA	A		;clear 'C'
	RET
;
; --- no match yet, keep trying
;
FFN2:	POP	D
	POP	H		;restore registers
	MVI	A,DIRELN	;increment HL to next
	CALL	DADA		;entry
	DCR	C		;count down entries
	JNZ	FFNAME		;and try all over again
;
; --- looked at all entries and failed
;
	STC			;set 'C' for failure
	RET

;
;	GETTOK -- Get file token (name or extension)
;
;	ENTRY:	(HL) = input string (NULL terminated)
;		(DE) = result
;
GETTOK:	MOV	A,M		;fetch character
	ORA	A		;set 'Z' flag
	JZ	GET1		;jump if end
	CPI	'.'		;at a decimal?
	JZ	GET1		;YES, jump
	CALL	MLU		;map character to upper case
	STAX	D		;and store in result
	INX	D		;increment source and
	INX	H		;destination pointers
	DCR	C		;count down
	JNZ	GETTOK		;and loop 'til done

GET2:	MOV	A,M		;fetch next char
	ORA	A		;is it NULL ?
	RZ			;YES, done
	CPI	'.'		;is it decimal?
	RZ			;YES, done
	INX	H		;else loop 'til
	JMP	GET2		;NULL or decimal.

GET1:	PUSH	PSW		;save last character
	MVI	A,' '		;fill rest with blanks
GET3:	STAX	D		;store a blank
	INX	D		;point to next
	DCR	C		;count down
	JNZ	GET3		;and loop 'til done
	POP	PSW		;get back character
	RET			;and return

;
;	READ --	Read a Z-DOS sector
;
;	ENTRY:	BC = No. of sectors to read
;		DE = Starting sector [1..640]
;		HL = Buffer address
;
READ:	PUSH	B		;Save registers
	PUSH	D
	PUSH	H

	DCX	D		;Put in	range [0..639]

RDL1:	PUSH	B		;Save sector counter
	PUSH	D		;and sector number

	MOV	A,E		;A = sector
	ANI	00000111B	;MOD 8
	RLC			;*2
	RLC			;*2
	INR	A		;A = (A	* 4) + 1
	MOV	C,A		;C = 128 byte sector No.  

	MVI	A,3		;Divide	sector by
	CALL	SHRDE		;8 to get DE = Track No.

	MVI	B,ZDSSIZ/CPMSIZ	;Reading 4 128 byte sectors
RDL2:	CALL	RDSECT		;Read a	128 byte sector
	MVI	A,CPMSIZ	;increment the DMA address
	CALL	DADA		;by 128	bytes
	INR	C		;point to next 128 byte	sector
	DCR	B		;count down sectors
	JNZ	RDL2		;until 4 are read

	POP	D		;Restore 512 byte sector number
	INX	D		;and increment it
	POP	B		;Restore 512 byte sector counter
	DCX	B		;and decrement it
	MOV	A,B		;Check if count	is now 0
	ORA	C		;if not	then
	JNZ	RDL1		;continue with outer loop

	POP	H		;restore registers ...
	POP	D
	POP	B
	RET			;and RETurn ...

;
;	SHRDE -- Shift DE right	by A bits
;		 (divide by 2**A)
;
;	ENTRY:	DE = 16	bit word to shift
;		A = No.	of positions to	shift
;
SHRDE:	PUSH	B		;Save BC
	MOV	C,A		;C = No. of bits to shift
	INR	C		;fix for first pass
SHR1:	DCR	C		;count down
	JZ	SHR2		;done ?
	MOV	A,D		;A = upper 8 bits
	ANA	A		;clear 'C'
	RAR			;rotate	into 'C' 
	MOV	D,A		;and store back	in D
	MOV	A,E		;A = lower 8 bits
	RAR			;rotate, include 'C'
	MOV	E,A		;and store back	in E
	JMP	SHR1		;and loop 'til done
SHR2:	POP	B		;then restore BC
	RET			;and return

;
;	RDSECT -- Read absolute	128 byte sector
;
;	ENTRY:	C = Sector [1..32]
;		DE = Track [0..79]
;		HL = DMA address
;		(Disk must have	been
;		 selected through BIOS already)
;
;	EXIT:	A and flags are	as returned from BIOS
;		read operation.
;
;	USES:	A, F
;
RDSECT:	PUSH	B		;Save registers
	PUSH	D
	PUSH	H

	PUSH	H		;Save DMA address
	PUSH	B		;Save Sector number
	PUSH	D		;Save Track number
;
;	Select track
;
	POP	B		;BC = Track number
	MVI	L,BISTRK	;Request set track
	CALL	BIOS		;via BIOS
;
;	Select sector
;
	POP	B		;Restore BC = Sector
	MVI	B,0		;Mask out top 8	bits
	MVI	L,BISSEC	;Request set sector
	CALL	BIOS		;via BIOS
;
;	Set DMA	address
;
	POP	B		;Restore BC = address
	MVI	L,BISDMA	;Request set DMA
	CALL	BIOS		;via BIOS
;
;	Read the sector
;
	MVI	L,BIREAD	;Request sector	read
	CALL	BIOS		;via BIOS

	POP	H		;Restore registers
	POP	D
	POP	B

	RET


;	TYPTX -- Type text string on console.
;
;	ENTRY:	(DE) = text string (with '$' terminator)
;
TYPTX:	PUSH	B
	PUSH	H
	MVI	C,PRINTF
	CALL	BDOS
	POP	H
	POP	B
	RET

;
;	CLRBUF -- Clear type-ahead buffer
;
;	Used before calling BDOS to read a string.
;	Cleans up any garbage left from single character
;	I/O operations
;
;	ENTRY:	None
;
;	USES:	A, F
;
CLRBUF:	PUSH	B		;Save registers
	PUSH	D
	PUSH	H
CLRB1:	MVI	C,RCS		;Read console status
	CALL	BDOS		;via BDOS
	ORA	A		;set 'Z' flag
	JZ	CLRB2		;and return if no chars left
	MVI	C,CONIN		;else read a char
	CALL	BDOS		;via BDOS
	JMP	CLRB1		;and see if any more
CLRB2:	POP	H		;restore registers
	POP	D
	POP	B
	RET			;and return

; 
;	READCH -- Read a character from	the console
;		  if no	character ready, return A = 00H.
;		  Character is not to be echoed to the
;		  console.
;
;	EXIT:	A = character read or 00H if none 
;
READCH:	PUSH	B		;Save registers
	PUSH	D
	PUSH	H
	MVI	E,0FFH		;request input function
	MVI	C,DIRCIO	;Direct Console I/O
	CALL	BDOS		;via BDOS
	ORA	A		;set 'Z' flag
	POP	H		;restore registers
	POP	D
	POP	B
	RET			;return

;
;	RDKEY -- Read function key or regular key
;
;	Reads a key from the console.   If a function
;	key is hit the 'C' is set and the second
;	character of the ESCape sequence is read and
;	returned.
;
RDKEY:	CALL	READCH		;Read a character
	JZ	RDKEY		;wait 'til key hit
	CPI	ESC		;ESCape ?
	JZ	HAVESC		;YES, jump
	ORA	A		;clear 'C'
	RET			;and return
HAVESC:	MVI	A,FNTICS	;Wait for some time
	CALL	DELAY		;to pass on TICCNT
	CALL	READCH		;See if char ready
	STC			;set 'C' in case there is
	RNZ			;if not NULL then return
	MVI	A,ESC		;NO, just an ESCape
	ORA	A		;clear 'C'
	RET			;and return

;
;	YESNO -- Read Y for YES or N for NO
;		(default is No)
;
;	ENTRY:	None
;
;	USES:	A,D,E,F
;
YESNO:	CALL	READCH		;read char, no echo
	JZ	YESNO		;loop 'til char there
	CALL	MLU		;must be upper case
	CPI	'Y'		;'YES' ?
	JZ	HAVEY		;jump if so
	CPI	'N'		;'NO' ?
	JZ	HAVEN		;jump if so
	CPI	CR		;CR --> default ?
	JZ	HAVEN		;if so, treat same as NO
;
; --- Not Y, N, or CR, ring bell and repeat
;
	CALL	BEEP		;ring bell
	JMP	YESNO		;and repeat
HAVEY:	LXI	D,ECHOY		;echo the Y as 'YES'
	CALL	TYPTX
	XRA	A		;clear 'C'
	RET			;and return
HAVEN:	LXI	D,ECHON		;echo the N as 'NO'
	CALL	TYPTX
	STC			;set 'C' --> answer was NO
	RET			;and return

;
;	DELAY -- Wait for a certain no. of clock ticks
;
;	ENTRY:	A = # of ticks to wait
;
;	USES:	A, F
;
DELAY:	PUSH	H		;Save HL register
	LXI	H,TICCNT	;(HL) = tic counter
	ADD	M		;add time to A
DLLOOP:	CMP	M		;time up yet ?
	JNZ	DLLOOP		;NO, loop
	POP	H		;YES, restore HL
	RET			;and return

;
;	HLCPDE -- Compare HL with DE
;
HLCPDE:	MOV	A,H
	CMP	D
	RNZ
	MOV	A,L
	CMP	E
	RET

;
;	MOVE -- Non overlapping move routine
;
;	ENTRY:	(DE) = source text
;		(HL) = destination
;		A = # bytes to move
;
;	USES:	D,E,A,F,H,L
;
MOVE:	PUSH	B		;Save BC reg.
	MOV	C,A		;use C as counter
	INR	C		;up 1 for 1st pass
MV1:	DCR	C		;count down
	JZ	MV2		;done ?
	LDAX	D		;load byte from source
	MOV	M,A		;store it in destination
	INX	D		;point to next source
	INX	H		;point to next destination
	JMP	MV1		;and loop
MV2:	POP	B		;done. restore BC
	RET			;and return

;
;	DADA --	Double add A to	HL
;
;	EXIT:	HL = HL	+ 0,A
;
DADA:	ADD	L
	MOV	L,A
	RNC
	INR	H
	RET


;	MLU -- Map lower to upper
;
MLU:	CPI	'a'
	RC
	CPI	'z'+1
	RNC
	SUI	'a'-'A'
	RET

;	PCHAR -- print a character on console
;
PCHAR:	PUSH	H
	PUSH	D
	PUSH	B
	MVI	C,TYPEF
	MOV	E,A
	CALL	BDOS
	POP	B
	POP	D
	POP	H
	RET

;
;	CRLF -- Output a CR and LF
;
CRLF:	MVI	A,CR
	CALL	PCHAR
	MVI	A,LF
	CALL	PCHAR
	RET

;
;	BEEP -- Output a BEL character
;
BEEP:	MVI	A,BEL
	CALL	PCHAR
	RET

;	BIOS - Make a direct call to BIOS
;
;	ENTRY:	L = call offset
;
BIOS:	PUSH	PSW
	LDA	BIOSPG
	MOV	H,A
	POP	PSW
	PCHL

;
;	Text messages
;
INTRO	DB	CR,LF,ESC,'E',TAB,TAB		;first master reset
	DB	'**** Z-DOS to CP/M-85 File Transfer Program ****'
	DB	CR,LF,TAB,TAB
	DB	'		 Version 1.1'
	DB	CR,LF,LF,'$'
MCDRV	DB	13,10,'Enter drive to be used for CP/M disks: <B:> $'
MZDRV	DB	13,10,'Enter drive to be used for Z-DOS disks: <A:> $'
SAMMSG	DB	ESC,'E',CR,LF,BEL
	DB	'*** Destination and source drives cannot '
	DB	'be the same.',CR,LF,'$'
INSMSG	DB	13,10,10
	DB	'Insert a double sided CP/M disk into the Z-DOS '
	DB	'drive, and hit RETURN.$'
NOTDS	DB	ESC,'E',CR,LF,BEL
	DB	'Before this program can read Z-DOS disks, '
	DB	'it must log on to a double sided',CR,LF
	DB	'CP/M disk in the drive you selected for '
	DB	'Z-DOS disks.',CR,LF,'$'
PROMPT	DB	ESC,'x1'	;enable 25th line
	DB	ESC,'j'		;save cursor position
	DB	ESC,'Y8 '	;goto 25th line
	DB	ESC,'p'		;reverse video
	DB	'HELP',27,'q Help  ',27,'pF1',27,'q Z-DOS Dir  ',27,'pF2'
	DB	27,'q CP/M Dir  ',27,'pF3',27,'q View  ',27,'pF4',27
	DB	'q Dump  ',27,'pF5',27,'q Copy  ',27,'pF6',27,'q Exit'
	DB	ESC,'k'		;restore cursor position
	DB	'$'		;end of message
DIRTXT	DB	CR,LF,'Directory of Z-DOS disk:'  
	DB	CR,LF,LF,'$'
CDIRTX	DB	CR,LF,'Directory of CP/M disk:'
	DB	CR,LF,LF,'$'
NOFILE	DB	'No Files',CR,LF,'$'
FNMSG	DB	CR,LF,'Enter source (Z-DOS) file name: $'
FNMSG2	DB	CR,LF,'Enter destination (CP/M) file name: <$'
MOVCAN	DB	CR,LF,BEL,'*** Command cancelled ***$'
FEXIST	DB	CR,LF,BEL,'*** That file already exists, '
	DB	'OK to delete it (Y/N) ? <N> $'
DIRFUL	DB	CR,LF,BEL,'*** Insufficient space on CP/M disk, '
	DB	'replace it and try again ***$'
BADNAM	DB	CR,LF,'*** CP/M file name contains illegal '
	DB	'characters ***$'
BADMOV	DB	CR,LF,BEL,'*** The CP/M disk is full, only part of the file '
	DB	'was moved ***$'
GOODMV	DB	CR,LF,'*** File copied successfully ***$'
BADMSG	DB	CR,LF,BEL,'*** No file by that name on Z-DOS disk.  '
	DB	'Check DIRectory ***$'
BADDSK	DB	CR,LF,BEL,'*** Place a Z-DOS disk in drive '
ZDRV3	DB	'A: ***$'
REPSYS	DB	ESC,'y1',ESC,'E',BEL
	DB	'Ensure that a CP/M system disk is in drive A:, '
	DB	'and hit RETURN.$'
RSTCON	DB	ESC,'z$'	;reset console to start-up
CMDPR	DB	CR,LF,'Command: $'
F1MSG	DB	'Z-DOS DIR$'
F2MSG	DB	'CP/M DIR$'
F3MSG	DB	'VIEW$'
F4MSG	DB	'DUMP$'
F5MSG	DB	'COPY$'
F6MSG	DB	'EXIT$'
ECHON	DB	'NO$'
ECHOY	DB	'YES$'
HLPMSG	DB	ESC,'E',CR,LF,TAB,'This program is used to move files'
	DB	' from Z-DOS formatted disks to',CR,LF,TAB
	DB	'CP/M formatted disks.  The Z-DOS disk '
	DB	'is  assumed to be in drive ',CR,LF,TAB
ZDRV4	DB	'A: and the CP/M disk is assumed'
	DB	' to be  in drive '
CDRV3	DB	'B:.  The disk in',CR,LF,TAB
	DB	'either drive may be  changed'
	DB	' whenever the  "Command ?" prompt is',CR,LF,TAB
	DB	'shown.',CR,LF,LF,TAB
	DB	'Commands are issued using the function'
	DB	' keys.  These keys perform',CR,LF,TAB
	DB	'the following functions:',CR,LF,LF,TAB,TAB
	DB	'<F1> - List the files on the Z-DOS disk',CR,LF,TAB,TAB
	DB	'<F2> - List the files on the CP/M disk',CR,LF,TAB,TAB
	DB	'<F3> - Type a Z-DOS file on the screen',CR,LF,TAB,TAB
	DB	'<F4> - Dump a Z-DOS file on the screen in hex',CR,LF,TAB,TAB
	DB	'<F5> - Copy a Z-DOS file to the CP/M disk',CR,LF,TAB,TAB
	DB	'<F6> - Exit back to the CP/M command level',CR,LF,TAB,TAB
	DB	'HELP - Print this message',CR,LF
	DB	LF,LF,'$'
;
;	Buffers & working storage
;
MAXF	DB	0		;Max # of dir entries
DIRSIZ	DB	0		;# of sectors in file directory
SPC	DB	0		;# of sectors per cluster
NXTSEC	DB	0		;pointer to sector within cluster
ZENTRY	DW	0		;address of Z-DOS file entry
NXTCLU	DW	0		;cluster pointer for FAT
CURDRV	DB	0		;Storage for current drive no.
FCB:
CDRV2	DB	2		;disk B: is CP/M disk
CFILE	DS	FNLEN		;store CP/M file name here
FCBEXT	DB	0
	DB	0,0
	DB	0
	DB	0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0
	DB	0
	DW	0
	DB	0
FCBEND:
ZFCB	DB	0,'???????????',0,0,0,0
CPMBUF	DS	CPMSIZ		;DMA buffer for CP/M file op's
FAT	DS	FATSIZ*ZDSSIZ	;File allocation table buffer
DIRECT	DS	DSFSIZ*ZDSSIZ	;Z-DOS directory buffer area (sectors)
CLUSTR	DS	DSSPC*ZDSSIZ	;Cluster read buffer
ZFILE	DS	FNLEN		;Buffer for Z-DOS file name

	DS	64		;Stack space
STACK:

	END
