	TITLE PRINTEK Printer Mode Setup
	PAGE	,132
;
;	PRINTEK Printer Mode Setup Program
;
;	Author: R. A. Metz		Date: 1/24/83
;
;
;	This program is invoked by: 'PRINTEK <string>'
;	Where <string> is a list of one-character commands
;	from the following set:
;
;	N  -  Normal character printing
;	E  -  Enhanced character printing (double width)
;	D  -  Draft mode (200 cps)
;	1  -  Quality print font 1
;	2  -  Quality print font 2
;	S  -  Small characters (16.7 cpi)
;	M  -  Medium characters (13.3 cpi)
;	L  -  Large characters (12 cpi)
;	X  -  Xtra large characters (10 cpi)
;	P  -  Proportional character spacing
;	F  -  Fixed character spacing
;	6  -  6 lpi
;	8  -  8 lpi
;
;
;	For information on use of this program, execute it with
;	no parameters and an explaination will be displayed on
;	the CRT.
;
;
	PAGE
PGMSEG	SEGMENT
	ASSUME 	CS:PGMSEG,DS:PGMSEG,SS:PGMSEG,ES:NOTHING
	ORG	80H
COUNT	DB	0
BUFFER	DB	127 DUP (?)
CR	EQU	0DH
LF	EQU	0AH
START:
	JMP	BEGIN
;
;
MENU	DB	CR,LF
	DB	'This program is invoked by: "PRINTEK <string>"'
	DB	CR,LF
	DB	'Where <string> is a list of one-character commands'
	DB	CR,LF
	DB	'from the following set:'
	DB	CR,LF,LF
	DB	'  N - Normal characters'
	DB	CR,LF
	DB	'  E - Enhanced (double width) characters'
	DB	CR,LF
	DB	'  D - Draft mode (200 cps)'
	DB	CR,LF
	DB	'  1 - Quality print font 1'
	DB	CR,LF
	DB	'  2 - Quality print font 2'
	DB	CR,LF
	DB	'  S - Small characters (16.7 cpi)'
	DB	CR,LF
	DB	'  M - Medium characters (13.3 cpi)'
	DB	CR,LF
	DB	'  L - Large characters (12 cpi)'
	DB	CR,LF
	DB	'  X - Xtra large characters (10cpi)'
	DB	CR,LF
	DB	'  P - Proportional character spacing'
	DB	CR,LF
	DB	'  F - Fixed character spacing'
	DB	CR,LF
	DB	'  6 - 6 lpi'
	DB	CR,LF
	DB	'  8 - 8 lpi'
	DB	CR,LF,'$'
;
;
BEGIN:
	MOV	CL,BYTE PTR COUNT	;# Characters in cmd line
	CMP	CL,0
	JNE	DO_MOD
	MOV	DX,OFFSET MENU		; Display instructions
	MOV	AH,9			; on entry w/ no parms
	INT	21H
	INT	20H
DO_MOD:
	MOV	CH,0
	MOV	BX,OFFSET BUFFER	;Address of cmd line buffer
CLOOP:
	MOV	AL,[BX]			;Get a character
	INC	BX
	CMP	AL,40H			; Alpha?
	JLE	DO_IT			;  No - no upper-case mask
	AND	AL,5FH			;Ensure upper case
DO_IT:
	CALL	PROCESS			;Process it
	LOOP	CLOOP
RTN:
	INT	20H			;Return to Z-DOS
;
PROCESS	PROC	NEAR
	PUSH	CX
	PUSH	BX
	MOV	BX,OFFSET CTBL		;Command table
CHECKIT:
	CMP	AL,[BX]
	JE	DOIT			;Search table for match
NXTC:
	ADD	BX,3			;Next entry
	CMP	BX,OFFSET ENDTBL
	JNE	CHECKIT
PROC_RET:
	POP	BX			;Return after processing or
	POP	CX			; if no match (ignore cmd)
	RET
;
DOIT:
	MOV	SI,1[BX]		;Address of command string
PRTLP:
	MOV	DL,[SI]
	INC	SI
	CMP	DL,0FFH			;Check for end of string
	JE	PROC_RET		;Return at end 
	MOV	AH,5			;Print character from string
	INT	21H
	JMP	PRTLP
;
CTBL:					;Command table:
	DB	'N'
	DW	NORMAL			;Normal print
	DB	'E'
	DW	ENHANCE			;Enhanced print
	DB	'D'
	DW	DRAFT			;200 cps
	DB	'1'
	DW	Q1			;Quality font 1
	DB	'2'
	DW	Q2			;Quality font 2
	DB	'P'			;Proportional
	DW	PROPORT
	DB	'F'			;Fixed
	DW	FIXED
	DB	'S'
	DW	SMALL			;16.7 cpi
	DB	'M'
	DW	MED			;13.3 cpi
	DB	'L'	
	DW	LARGE			;12
	DB	'X'
	DW	XLRG			;10 CPI
	DB	'6'
	DW	LPI6			;6 lpi
	DB	'8'
	DW	LPI8			;8 lpi
ENDTBL:
;
NORMAL:
	DB	0FH,0FFH
ENHANCE:
	DB	0EH,0FFH
DRAFT:
	DB	1BH,'[10m',0FFH
Q1:
	DB	1BH,'[30m',0FFH
Q2:
	DB	1BH,'[40m',0FFH
SMALL:
	DB	1BH,'[4w',0FFH
MED:
	DB	1BH,'[3w',0FFH
LARGE:
	DB	1BH,'[2w',0FFH
XLRG:
	DB	1BH,'[1w',0FFH
PROPORT:
	DB	1BH,'[>h',0FFH
FIXED:
	DB	1BH,'[>l',0FFH
LPI6:
	DB	1BH,'[1x',0FFH
LPI8:
	DB	1BH,'[2x',0FFH
;
PROCESS	ENDP
PGMSEG	ENDS
	END	START
