;************************************************************************
;*									*
;*			    Automatic Time-Date 			*
;*	   Sets System Time and Date from Hayes Chronograph clock.	*
;*									*
;*	   (c)1984 By: Larry D. Wakeford	 Date 01/26/84		*
;*									*
;************************************************************************

	TITLE	ATD.COM :  Automatic Time-Date

	PAGE	,132

	.XLIST
INCLUDE DEFASCII.ASM
INCLUDE DEFMS.ASM
INCLUDE DEFEP2.ASM
INCLUDE DEFCONFG.ASM
	.LIST


PGMSEG	SEGMENT
	ASSUME	CS:PGMSEG,SS:PGMSEG,DS:PGMSEG,ES:PGMSEG

	ORG	100H			; Start of TPA

BEGIN:
	JMP	SHORT MAIN		; Skip over copyright

	DB	'ATD - (C) Copyright 1984 by Larry D. Wakeford'

MAIN:					;Begin main program

;
; Initialize serial port B - 1200 baud, 1SB, 8 characters
;

	XOR	AL,AL			;turn off the port
	OUT	ZSERB+EPCMD,AL
	IN	AL,ZSERB+EPCMD		;reset mode reg ptr
	MOV	AL,EPSB1+EPCL8+EPA16X	;set mode reg one
	OUT	ZSERB+EPMODE,AL
	MOV	AL,EPMR2A+EPB120	;set mode reg two
	OUT	ZSERB+EPMODE,AL
	MOV	AL,EPNORM+EPRTS+EPRESE+EPRXEN+EPDTR
	OUT	ZSERB+EPCMD,AL		;set command register
	OUT	ZSERB+EPCMD,AL
	IN	AL,ZSERB+EPDATA 	;clear port input
	IN	AL,ZSERB+EPDATA

;
; Set Time and Date seperators
;

	MOV	SI,OFFSET SET_TS	;point time seperator
	MOV	CX,6			;send six characters
	CALL	OUTSTR			;send to chronograph

	MOV	SI,OFFSET SET_DS	;point date seperator
	MOV	CX,6			;send six characters
	CALL	OUTSTR			;send to chronograph

;
; Read Time and set system time clock
;
	MOV	SI,OFFSET RDTIME	;point read time string
	MOV	CX,5			;length of string to send
	CALL	OUTSTR			;read time to IN_BUF
	MOV	CH,IN_BUF		;CH = MSD of hour
	SUB	CH,30H			;remove ASCII bias
	MOV	AL,10			;AL = multipler
	IMUL	CH			;AL = Tens of hour
	MOV	CH,IN_BUF+1		;CH = LSD of hour
	SUB	CH,30H
	ADD	CH,AL			;CH = hours
	MOV	AL,IN_BUF+8		;if CR then 24 hour format
	CMP	AL,CC_CR
	JZ	SHORT NO_ADJ
	CMP	AL,'A'			;Test for am Hours
	JNZ	SHORT PM_HRS		;if not then have pm Hours
	CMP	CH,12			;check for 12 Hr. am adjustment
	JNZ	SHORT NO_ADJ		;if not 12am then no adjustment
	SUB	CH,12			;else convert to 24 Hour format
	JMP	SHORT NO_ADJ		;continue with clock setting
PM_HRS:
	CMP	CH,12			;check for 12 Hr. pm
	JZ	SHORT NO_ADJ		;if 12pm then no adjustment
	ADD	CH,12			;else convert to 24 hour format
NO_ADJ:
	MOV	CL,IN_BUF+3		;CL = MSD of minute
	SUB	CL,30H
	MOV	AL,10
	IMUL	CL
	MOV	CL,IN_BUF+4		;CL = LSD of minute
	SUB	CL,30H
	ADD	CL,AL			;CL = minutes
	MOV	DL,IN_BUF+6		;DL = MSD of seconds
	SUB	DL,30H
	MOV	AL,10
	IMUL	DL
	MOV	DL,IN_BUF+7		;DL = LSD of seconds
	SUB	DL,30H
	ADD	AL,DL
	MOV	DH,AL			;DH = seconds
	XOR	DL,DL			;clear DL
	MOV	AH,DOSF_STIME		;set system time
	INT	DOSI_FUNC
	LEA	SI,IN_BUF		;move Time to CTIME
	LEA	DI,CTIME
	MOV	CX,9
	REP	MOVSB

;
; Read Date and set system date
;
	MOV	SI,OFFSET RDDATE	;point read date string
	MOV	CX,5
	CALL	OUTSTR			;read date to IN_BUF
	MOV	AH,IN_BUF		;AH = MSD of year
	SUB	AH,30H
	MOV	AL,10			;AL = multipler
	IMUL	AH			;AL = tens digit of year
	MOV	AH,IN_BUF+1		;AH = LSD of year
	SUB	AH,30H
	ADD	AL,AH			;AL = last two year digits
	XOR	AH,AH			;clear AH register
	MOV	CX,1900 		;CX = century
	ADD	CX,AX			;CX = complete year value
	MOV	AH,IN_BUF+3		;AH = MSD of month
	SUB	AH,30H
	MOV	AL,10
	IMUL	AH			;AL = tens digit of month
	MOV	DH,IN_BUF+4		;DH = LSD of month
	SUB	DH,30H
	ADD	DH,AL			;DH = month (1-12)
	MOV	AH,IN_BUF+6		;AH = MSD of day
	SUB	AH,30H
	MOV	AL,10
	IMUL	AH			;AL = tens digit of day
	MOV	DL,IN_BUF+7		;DL = LSD of day
	SUB	DL,30H
	ADD	DL,AL			;DL = day (1-31)
	MOV	AH,DOSF_SDATE		;set system date
	INT	DOSI_FUNC
	LEA	SI,IN_BUF+3		;move Date to CDATE
	LEA	DI,CDATE
	MOV	CX,5
	REP	MOVSB
	LEA	SI,IN_BUF		;move year to CDATE msg
	LEA	DI,CDATE+8
	MOV	CX,2
	REP	MOVSB

;
; Read weekday and store at current day.
;
	MOV	SI,OFFSET RDWDAY	;point read weekday string
	MOV	CX,5
	CALL	OUTSTR
	XOR	BX,BX			;clear BX
	MOV	BL,IN_BUF		;BL = weekday code
	SUB	BL,30H			;remove ASCII bias
	MOV	AL,9			;adjust weekday code
	IMUL	BL
	LEA	SI,MON			;SI points start day table
	ADD	SI,AX			;add weekday address offset
	LEA	DI,CDAY 		;move to location CDAY
	MOV	CX,9			;set move count
	REP	MOVSB			;make move


;
; Print system Date and Time to display.
;

	MOV	DX,OFFSET MESG1 	;print Date/Time display
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC

;
; Open TIME.LOG file and read last access Time/Date
;

	MOV	DX,OFFSET DBUFF 	;set disk transfer address
	MOV	AH,DOSF_SDIOA
	INT	DOSI_FUNC
	MOV	DX,OFFSET FCB		;Open TIME.LOG file
	MOV	AH,DOSF_OPFILE
	INT	DOSI_FUNC
	INC	AL			;if AL=FF then NO Time.Log
	JZ	NOFILE
	MOV	AH,DOSF_SEQREAD 	;read Time.Log file
	INT	DOSI_FUNC
	LEA	SI,DBUFF		;get day from disk buffer
	LEA	DI,LDAY
	MOV	CX,9
	REP	MOVSB
	MOV	SI,OFFSET DBUFF+9	;get date form disk buffer
	LEA	DI,LDATE
	MOV	CX,10
	REP	MOVSB
	MOV	SI,OFFSET DBUFF+19	;get time from disk buffer
	LEA	DI,LTIME
	MOV	CX,9
	REP	MOVSB
	MOV	DX,OFFSET MESG2 	;print Last Date/Time display
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	DX,OFFSET FCB		;close Time.Log file
	MOV	AH,DOSF_CLFILE
	INT	DOSI_FUNC
	MOV	DX,OFFSET FCB		;delete Time.Log file
	MOV	AH,DOSF_DEFILE
	INT	DOSI_FUNC

NOFILE: MOV	DX,OFFSET FCB		;create Time.Log file
	MOV	AH,DOSF_CRFILE
	INT	DOSI_FUNC
	CALL	WRFILE			;write day/date/time to it
	INT	DOSI_TERM		;exit program

;
; Write current day/date/time to Time.Log file
;

WRFILE: LEA	SI,CDAY 		;put day into disk buffer
	LEA	DI,DBUFF
	MOV	CX,9
	REP	MOVSB
	LEA	SI,CDATE		;put date into disk buffer
	MOV	DI,OFFSET DBUFF+9
	MOV	CX,10
	REP	MOVSB
	LEA	SI,CTIME		;put time into disk buffer
	MOV	DI,OFFSET DBUFF+19
	MOV	CX,9
	REP	MOVSB
	MOV	BP,OFFSET FCB		;point to start FCB
	XOR	AL,AL			;clear AL
	MOV	[BP]+FCB_CURBLK,AL	;zero current block
	MOV	[BP]+FCB_CURREC,AL	;zero current record
	MOV	DX,OFFSET FCB		;write current day/date/time
	MOV	AH,DOSF_SEQWRITE
	INT	DOSI_FUNC
	MOV	DX,OFFSET FCB		;close Time.Log file
	MOV	AH,DOSF_CLFILE
	INT	DOSI_FUNC
	MOV	DX,OFFSET LPOS		;position cursor
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	RET				;return to caller


;
; I/O routine for Hayes Chronograph clock
;

OUTSTR:
	MOV	DL,[SI] 		;get character
	MOV	AH,DOSF_AUXOUT		;send to chronograph
	INT	DOSI_FUNC
	INC	SI			;point next character
	LOOP	OUTSTR
	MOV	DI,OFFSET IN_BUF	;point to input buffer
	MOV	CX,10			;longest responce string
INSTR:
	MOV	AH,DOSF_AUXIN		;get character from chronograph
	INT	DOSI_FUNC
	MOV	[DI],AL 		;store char. in IN_BUF
	INC	DI			;point to next location
	CMP	AL,0DH			;char = CR ?
	LOOPNE	INSTR			;keep going until <CR> or CX=0
	RET				;return to caller


RDTIME	DB	'ATRT',CC_CR		;commands for chronograph
RDDATE	DB	'ATRD',CC_CR
RDWDAY	DB	'ATRW',CC_CR
SET_TS	DB	'ATVT:',CC_CR
SET_DS	DB	'ATVD/',CC_CR

MON	DB	'Monday   '		;Weekday strings
TUE	DB	'Tuesday  '
WED	DB	'Wednesday'
THU	DB	'Thursday '
FRI	DB	'Friday   '
SAT	DB	'Saturday '
SUN	DB	'Sunday   '

MESG1	DB	CC_ESC,'E',CC_ESC,'x5',CC_ESC,'Y+)'
	DB	'Current System Date -> '
CDAY	DB	'xxxxxxxxx, '
CDATE	DB	'xx/xx/19xx. Time -> '
CTIME	DB	'xx:xx:xx $'

MESG2	DB	CC_ESC,'Y-)'
	DB	'Last access Date    -> '
LDAY	DB	'xxxxxxxxx, '
LDATE	DB	'xx/xx/19xx. Time -> '
LTIME	DB	'xx:xx:xx '
LPOS	DB	CC_ESC,'Y5 ',CC_ESC,'y5$'

FCB	DB	0,'TIME    LOG',25 DUP(0)

IN_BUF	DB	10 DUP(32)
	DB	'$'

DBUFF	DB	?

PGMSEG	ENDS
	END	BEGIN
u^&Ê&6:30 rÊˀtK rÊˀ