		title   cvtnum: convert 16-bit bin number to ascii and blank 0's
		page    ,96
	subttl  Program Documentation
;
;       cvt_num - convert number and blank leading zeros.
;
;       cvt_num version 1 revision 2 of 5/20/84
;
;       Copyright (c) 1984 by   David A. Wallace
;                               146 Westford St.
;                               Chelmsford,  Ma.
;                                       01824
;
;       Released with PRINTL Version 4.04
;
;       This function converts the 16-bit binary number in DX into a 5-character
;       ascii string (pointed to by DI).  It suppresses leading zeros, replacing
;       them with blanks.  NOTE:  this routine assumes that the value in DX is
;       to be interpreted as an UNSIGNED integer (rage of 0 to 65535).
;
		subttl  Definitions
		.xlist
		include b:defascii.asm
		include b:defms.asm
		.list
		subttl  Code
		page
prog            segment byte public 'PROG'
		assume  cs:prog,ds:prog,es:prog,ss:prog
		public  cvt_num
;       CVT_NUM - Convert number in DX to a 5-digit ASCII string (leading
;                    zeros are replaced with spaces) in the area pointed to
;                    by DI.
;
;       Entry:  DX = number to convert
;               DI -> buffer
;       Exit:   none
;       Uses:   DX,DI
;
CVT_NUM:
		PUSH    AX
		PUSH    BX
		PUSH    CX
		PUSH    SI
		MOV     CX,5
		MOV     AL,' '
		REP STOSB
		MOV     CX,5
		MOV     AX,DX
		MOV     BX,10
		DEC     DI
		STD
CVNL:
		SUB     DX,DX
		DIV     BX
		ADD     DL,'0'
		XCHG    AX,DX
		STOSB
		XCHG    AX,DX
		OR      AX,AX
		JZ      CVNX
		LOOP    CVNL
CVNX:
		CLD
		POP     SI
		POP     CX
		POP     BX
		POP     AX
		RET

prog            ends
		end     cvt_num


N: