PAGE ,132

	TITLE SCDMPOK2 - SCREEN DUMP UTILITY
;              Version 3.0   30-Dec-84

;	for Okidata Microline Series Printers
 
;	Written by Les Bordelon - All Rights Reserved

;	SCDMP reproduces Graphics and Text data from the screen of
;	the Zenith Z-100 series system for print out using an
;	Okidata Microline 82/83/84 and 92/93 printers in bit-image
;	graphics mode.  On receipt of an interrupt-5 (generated by
;	entering <SHFT-F12>) VRAM is enabled and the screen printing
;	is performed.  If COLOR is set to true, then entering a <B>
;	for blue, <R> for red, or <G> for green immediately after
;	the <SHFT-F12> will select the VRAM bank to be printed.  If
;	no character is entered the green bank is default.  If COLOR
;	is set to false, only the green bank can be dumped.  Two
;	densities of print are selectable.  Entering a <N> for
;	normal or <H> for high density immediately after the color
;	or <SHFT-F12> will select print density.  Normal density is
;	the default.  Approximately two seconds is allowed before
;	the program assumes the default settings.  Press <ESC>
;	during printing of the screen to abort the dump.

;	Credits:  Zenith Data Systems 	      - Interrupt-5 routine (PSC)
;		  Digital Information Systems - Original Graphic Routines

;	Definitions 

BIOS_SEG SEGMENT AT 40H 			;bios location
	ORG 3*3
  BIOS_CONOUT	LABEL FAR			;console output
	ORG 4*3
  BIOS_PRINT	LABEL FAR			;printer output 
BIOS_SEG ENDS

;  	If monitor version = 1, then change ORG to 0290H or the 25th
;		line will not be printed.

MTR_D_SEG SEGMENT AT 0				;ROM monitor data
	ORG	0292H
  MTR_VERP	DB ?				;vertical position of cursor
MTR_D_SEG ENDS

IPAGE_SEG SEGMENT AT 0				;the interrupt area page
	ORG	03FEH
  MTR_DS	LABEL WORD			;location of Monitor ds value
IPAGE_SEG ENDS


FALSE	=	0
TRUE	=	NOT FALSE

;	Set COLOR to TRUE if all three banks of VRAM installed

COLOR	=	TRUE

CODE	SEGMENT BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	100H

;*****************ENTRY POINT******************

BEGIN:
	JMP	NEAR PTR START


CHECK	DB	'SCREEN DUMP  VERSION 3.0'	;identification message
CHECKLN EQU	24				;message length

;************INTERRUPT_5 HANDLER***************

INT_5:
	PUSH	DS				;save previous data segment
	PUSH	AX

	MOV	CS:INT_SP,SP
	MOV	CS:INT_SS,SS			;save previous stack

	MOV	AX,CS
	MOV	SS,AX				;set local stack
	MOV	SP,OFFSET INT_STACK

	STI					;now allow interrupts

	PUSH	ES
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI

	MOV	DS,AX
	MOV	ES,AX				;set up new segments

	MOV	AL,'G'				;set defaults - VRAM bank
	MOV	CLRFLG,AL
	MOV	AL,'N'				; print density
	MOV	DENFLG,AL
	MOV	CNT,00				; and bit shift count

	CALL	INT_SIZE			;size screen
	CALL	INT_SCRN			;process the screen

	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	ES

	CLI					;INTs off while messing around
	MOV	AX,INT_SP
	MOV	SP,AX
	MOV	AX,INT_SS			;restore original stack
	MOV	SS,AX

	POP	AX
	POP	DS
	IRET					;back to bios

INT_SS	DW	0				;saved stack values
INT_SP	DW	0

INT_CX	DW	0				;current X location
INT_CY	DW	0				;current Y location
MYCHR	DW	0				;character at position
MYLINE	DB	82 DUP (?)			;line buffer
LINES	DW	24D				;minimum lines

	DW	128 DUP (?)

INT_STACK LABEL NEAR				;internal stack

;*****************SIZE SCREEN******************

;	INT_SIZE checks to see if the 25th line is enabled. If
;	it is, LINES is modified to be 25, so all lines are
;	printed


INT_SIZE:
	MOV	WORD PTR LINES,24		;assume not
	MOV	SI,OFFSET INT_SIZA		;print first line
	CLI					;don't interrupt me now
	CALL	INT_PLINE			;output line
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX				;get data segment
	MOV	DS,DS:[MTR_DS]
	MOV	AL,DS:[MTR_VERP]		;AL = horiz. position of cursor
	POP	DS
	PUSH	AX
	MOV	SI,OFFSET INT_SIZB		;put cursor back
	CALL	INT_PLINE			;output line
	STI
	POP	AX
	CMP	AL,24
	JNZ	INT_SIZ1			;if not on 24th line

;	Cursor moved to 25th line, must be enabled

	INC	WORD PTR LINES

INT_SIZ1:
	RET

INT_SIZA LABEL	NEAR
	DB	01BH,'j'			;save cursor
	DB	01BH,'Y',25+31,1+31		;go here
	DB	-1				;end of message

INT_SIZB LABEL	NEAR
	DB	01BH,'k'			;restore cursor
	DB	-1

INT_PLINE:
	MOV	AL,BYTE PTR [SI]		;get character
	INC	SI				;bump for next time
	CMP	AL,-1
	JZ	INT_PLIN1			;if end of text
	PUSH	SI
	CALL	FAR PTR BIOS_CONOUT		;output it
	POP	SI
	JMP	SHORT INT_PLINE 		;do next

INT_PLIN1:
	RET


SCN_LN	DW	0
CUR_RO	DW	0
COL_INR DW	0
CLRFLG	DB	0
DENFLG	DB	0

;************VIDEO ADDRESS TABLE***************

ROW_DAT DW	00				;base of table
L24	DW	50176D
L23	DW	48128D
L22	DW	46080D
L21	DW	44032D
L20	DW	41984D
L19	DW	39936D
L18	DW	37888D
L17	DW	35840D
L16	DW	33792D
L15	DW	31744D
L14	DW	29696D
L13	DW	27648D
L12	DW	25600D
L11	DW	23552D
L10	DW	21504D
L09	DW	19456D
L08	DW	17408D
L07	DW	15360D
L06	DW	13312D
L05	DW	11264D
L04	DW	09216D
L03	DW	07168D
L02	DW	05120D
L01	DW	03072D
L00	DW	01024D
ETAB	DW	0000

;***************END TO TABLE*********************

ADDR_1	DW	0000
ADDR_2	DW	0000
G_CHR1	DB	00
G_CHR2	DB	00
CNT	DB	00

;***INT_SCRN - INTERRUPT TIME SCREEN PROCESSOR***

INT_SCRN:
	MOV	AX,0A78H			;video port =11110000 enabled
	OUT	0D8H,AL
	CALL	DE_LAY1				;delay for first input
	CALL	GET_ARG				;determine character input

IF COLOR
	CALL	DE_LAY2				;delay for second input 
	CALL	GET_ARG				;determine character input
	JMP	GET_BANK			;select bank to dump
ELSE
	JMP	G_BANK				;dump green bank only
ENDIF

DE_LAY1:
	MOV	BX,200D 			;initialize delay loop 1

DE_LAY2:
	MOV	CX,1000D			;initialize delay loop 2

DL3:	DEC	CX				;delay loop 1
	IN	AL,0F5H				;check for char avail
	TEST	AL,01H
	JZ	DL4				;no, continue
	IN	AL,0F4H 			;else get char
	JMP	DL5
DL4:	CMP	CX,0
	JG	DL3
	DEC	BX				;delay loop 2
	CMP	BX,0
	JG	DE_LAY2
DL5:	RET

GET_ARG:
	AND	AL,0DFH				;force to upper case
	CMP	AL,'B'				;check for 'B'
	JNE	GA1				;nope
	MOV	CLRFLG,AL			;set color flag for blue
	JMP	GA3	
GA1:	CMP	AL,'R'				;check for 'R'	
	JNE	GA2				;nope
	MOV	CLRFLG,AL			;set color flag for red
	JMP	GA3
GA2:	CMP	AL,'H'				;check for 'H'
	JNE	GA3				;nope
	MOV	DENFLG,AL			;set density flag for high
GA3:	RET

GET_BANK:
	CMP	CLRFLG,'B'			;if flag -> B, dump blue
	JE	B_BANK
	CMP	CLRFLG,'R'			;if flag -> R, dump red
	JE	R_BANK

G_BANK: 					;green vram bank
	MOV	AX,0E000H			;select location E000H
	JMP	GO_PSC

R_BANK: 					;red vram bank
	MOV	AX,0D000H			;select location D000H
	JMP	GO_PSC

B_BANK: 					;blue vram bank
	MOV	AX,0C000H			;select location C000H

GO_PSC: 					;OKIDATA graphics routine
	MOV	ES,AX				;set up seg
	MOV WORD PTR COL_INR,79D		;init col =79
	MOV WORD PTR CUR_RO,24D 		;init row =24 -->max lines
	MOV WORD PTR SCN_LN,0			;init scan line =0
	CMP	DENFLG,'N'			;check density flag for normal	
	JE	GP1
	MOV	AL,1DH				;set to compressed for high	
	CALL	NEAR PTR CPRN
GP1:	MOV	BX,03D				;set top page margin
	CALL	PRLF				;print line feeds
	CALL	NEAR PTR MODE_G 		;graphics mode
	CALL	NEAR PTR PRSPC			;print spaces (to center)
	JMP	ROW2

;*********CHARACTER PRINT - CPRN***************

CPRN:
	CALL	FAR PTR BIOS_PRINT		;character print function
	RET


;*********PRINT SPACES ROUTINE*****************

PRSPC:
	CMP	LINES,25			;if 25 lines
	JB	PRSPC1				;pad with spaces
	CMP	DENFLG,'N'
	JNE	PR1
	MOV	BX,15D				;15 spaces, normal density
	JMP	PSC1
PR1:	MOV	BX,58D				;58 spaces, high density

PSC1:
	MOV	AL,00H				;print spaces 
	CALL	CPRN				;spaces+graphics
	DEC	BX				
	CMP	BX,0
	JG	PSC1				;continue as needed
	RET

PRSPC1:
	CMP	DENFLG,'N'			;check density flag for normal
	JNE	PS1
	MOV	BX,24D				;if 24 lines
	JMP	PSC1				;24 spaces, normal density
PS1:	MOV	BX,72D
	JMP	PSC1				;72 spaces, high density

;*********PRINT LINE FEED ROUTINE**************

PRLF:
	MOV	AL,0AH				;print <LF>
	CALL	CPRN
	DEC	BX
	CMP	BX,0
	JG	PRLF				;continue as needed
	RET


;******MODE_G - SENDS GRAPHICS TO PRINTER******

MODE_G:
	MOV	AX,0000H			;clear AX reg
	MOV	AL,03H				;graphics mode
	CALL	NEAR PTR CPRN
	RET					;back to calling

;****DO_BYTE - READ THE VRAM AND SEND TO PRN***

DO_BYTE:
	CMP	COL_INR,-01H			;check if last column done
	JG	DB1				;no, continue
	MOV	G_CHR1,00			;else, get remaining part of
	JMP	DB2				; last column byte
DB1:	MOV	BX,WORD PTR ADDR_1		;current address
	MOV	AL,BYTE PTR ES:[BX]		;byte pointed by cur addr
	CMP	COL_INR,79D			;check if first column
	JE	DB3				;yes, skip previous
	MOV	G_CHR1,AL			;else, store it
DB2:	MOV	BX,WORD PTR ADDR_2		;previous column address
	MOV	AL,BYTE PTR ES:[BX]		;byte pointed by prev addr
	MOV	G_CHR2,AL			;store it
	CALL	SHFT_BIT			;re-align bits
DB3:	ADD	AL,128D 			;add 128 so all are printed
	CALL	NEAR PTR CPRN			;print twice for full-
	CALL	NEAR PTR CPRN			;screen effect
	CMP	DENFLG,'N'			;check density flag for normal
	JE	DB4
	CALL	NEAR PTR CPRN			;print one more time for high
DB4:	CMP	AL,03D				;check for grap char = 3
	JNE	DB5
	CALL	NEAR PTR CPRN			;print two more times
	CALL	NEAR PTR CPRN			;so all are printed
	CMP	DENFLG,'N'			;check density flag for normal
	JE	DB5
	CALL	NEAR PTR CPRN			;print one more time for high
DB5:	INC	SCN_LN				;count scan line done
	CMP	COL_INR,-01H
	JE	DB6
	MOV	BX,WORD PTR ADDR_1		;current address
	ADD	BX,128D 			;adjust for scan line
	MOV	WORD PTR ADDR_1,BX		;and save addr
	CMP	COL_INR,79D			;check if first column
	JE	DB7
DB6:	MOV	BX,WORD PTR ADDR_2		;previous column address
	ADD	BX,128D 			;adjust for scan line
	MOV	WORD PTR ADDR_2,BX		;and save addr
DB7:	CMP	SCN_LN,9			;have we done all 9
	JGE	ROW				;all done
	JMP	NEAR PTR DO_BYTE		;less than 8 done

;**********ROW - LOOP FOR EACH ROW*************

ROW:
	MOV	SCN_LN,0			;init scan line again
	DEC	CUR_RO				;count row done
	CMP	LINES,25			;if 25 lines
	JB	ROW24

	CMP	CUR_RO,-1H			;test all lines done
	JE	DO_COL				;do next col 
	JMP	ROW2

ROW24:
	CMP	CUR_RO,0			;if 24 lines, test all done
	JZ	DO_COL				;do next col

ROW2:	
	MOV	AX,CUR_RO			;else more rows
	MOV	BX,OFFSET ROW_DAT		;table start

LNS:						;return tgt
	CMP	COL_INR,-01H			;check if past last column
	JE	LNS1	
	ADD	BX,AX				;R_ADDR=ROW_DAT+CUR_RO
	ADD	BX,AX				;--times two
	MOV	AX,WORD [BX]			;get actual address
	MOV	BX,AX				;swap it back
	MOV	AX,COL_INR			;get current column
	ADD	BX,AX				;C_ADDR=R_ADDR+COL_INR
	SUB	BX,1024D			;adjust table for reverse
	MOV	WORD PTR ADDR_1,BX		;save it at ADDR_1

	CMP	COL_INR,79D			;check if initial column
	JE	LNS2				;do next row

	MOV	AX,CUR_RO			;else get previous column byte
	MOV	BX,OFFSET ROW_DAT		;table start

LNS1:						;return tgt
	ADD	BX,AX				;R_ADDR=ROW_DAT+CUR_RO
	ADD	BX,AX				;--times two
	MOV	AX,WORD [BX]			;get actual address
	MOV	BX,AX				;swap it back
	MOV	AX,COL_INR			;get current column
	INC	AX				;change to previous column
	ADD	BX,AX				;C_ADDR=R_ADDR+COL_INR+1
	SUB	BX,1024D			;adjust table for reverse
	MOV	WORD PTR ADDR_2,BX		;save it at ADDR_2
LNS2:	JMP	NEAR PTR DO_BYTE		;do next row


;*DO_COL - INCREMENT COLUMN AT END OF EACH ROW*

DO_COL:
	MOV	AL,03H
	CALL	NEAR PTR CPRN			;terminate line with
	MOV	AL,0EH
	CALL	NEAR PTR CPRN			;graphics <CR/LF>

	IN	AL,0F5H				;check for char avail
	TEST	AL,01H
	JZ	DC1				;no, continue
	IN	AL,0F4H 			;poll the keyboard port
	CMP	AL,01BH 			 
	JE	DC5				;if port -><ESC> then quit

DC1:	CMP	CNT,06				;check for 7th pass
	JE	DC2				;if so, don't decrement
	DEC	COL_INR 			;else, decrement column
	CMP	CNT,07				;check for 8th pass
	JE	DC3				;if yes, reset counter
DC2:	INC	CNT				;else, increment counter
	JMP	DC4
DC3:	MOV	CNT,00				;counter reset to 1
DC4:	CMP	COL_INR,-02H			;are all done?
	JG	NEAR PTR CON_CL 		;if no --> continue 
DC5:	JMP	NEAR PTR FINI			;else we are done

CON_CL:
	MOV	CUR_RO,24D			;reset max rows =24
	MOV	AX,0000H        		;do next col
	CALL	PRSPC				
	JMP	NEAR PTR ROW2

;************SHFT_BIT - REALIGN BITS***********

SHFT_BIT:
	CMP	CNT,00				;check for first pass
	JNE	SB1				;if not, continue
	MOV	AL,G_CHR1			;else dump current column only
	JMP	SB5
SB1:	CMP	CNT,07				;check for eighth pass
	JNE	SB2				;if not, continue
	MOV	AL,G_CHR1
	SHR	AL,1				;else, shift current column
	JMP	SB5				; left 1 bit for dump
SB2:	MOV	AL,G_CHR2			;get previous column byte
	MOV	CL,08				;determine shift
	SUB	CL,CNT
SB3:	SHR	AL,CL				;shift right by 9-CNT bits
	MOV	G_CHR2,AL			;store it
	MOV	AL,G_CHR1			;get current column byte
	MOV	CL,CNT
SB4:	SHL	AL,CL				;shift left by CNT bits
	OR	AL,G_CHR2			;OR re-aligned bytes
SB5:	RET


;*************FINISH - ALL DONE****************

FINI:						;reset printer
	MOV	AL,03H				;turn off graphics
	CALL	NEAR PTR CPRN
	MOV	AL,02H				;<3> <2>
	CALL	NEAR PTR CPRN
	MOV	AL,1EH				;reset to default
	CALL	NEAR PTR CPRN
	MOV	AL,12D				;set to bottom of page
	CALL	NEAR PTR CPRN
	MOV	AL,0DH
	CALL	NEAR PTR CPRN
	RET

;*******MARK END OF RESIDENT PORTION***********

INT_END LABEL	NEAR

;*************MAIN ENTRY POINT*****************


START:
	MOV	AX,00H				;check to see if already
	MOV	ES,AX				; installed.
	MOV	SI,5*4				;si points to interrupt
	MOV	ES,ES:WORD PTR [SI+2]
	MOV	SI,OFFSET CHECK 		;get ID message
	MOV	DI,SI
	MOV	CX,CHECKLN			;get length
	REPE	CMPSB				;compare
	JNZ	SETUP				;not installed

	MOV	DX,OFFSET MESG2 		;already installed
	MOV	AH,09H				;get message and function
	INT	21H				;print message
	INT	20H				;exit

SETUP:
	MOV	SP,OFFSET INT_STACK		;good place for it
	PUSH	DS

	XOR	AX,AX
	MOV	DS,AX				;clear DS

	MOV	SI,5*4				;SI points to interrupt
	CLI

	MOV	WORD PTR [SI],OFFSET INT_5
	MOV	WORD PTR [SI+2],CS		;set my interrupt vector

	STI
	POP	DS

	MOV	DX,OFFSET MESG1 		;get signon message address
	MOV	AH,09H				;get function code
	INT	21H				;print message

	MOV	DX,OFFSET INT_END		;LWA of resident portion
	INT	27H

MESG1	DB	13,10,'SCREEN DUMP  Version 3.0  30-Dec-84',13,10,
	DB	'Printer:  Okidata Microline Series ',13,10,10,
	DB	'Installed and ready...',13,10,10,
	DB	'To dump screen, type:   <SHIFT-F12>[X]',

IF COLOR
	DB	'[Y]',
ENDIF

	DB	,13,10,10,

IF COLOR
	DB	'  where [X = <G>reen  or <B>lue or <R>ed bank]',13,10,
	DB	'   and  [Y = <N>ormal or <H>igh density]', 
ELSE
	DB	'  where [X = <N>ormal or <H>igh density]',
ENDIF

	DB	13,10,10,'To abort dump during printing, type:   <ESC>',
	DB	13,10,10,'$'

MESG2	DB	13,10,7,'SCREEN DUMP already installed!',
	DB	13,10,10,'$'

CODE	ENDS
	END	BEGIN
