	TITLE	INTERACTIVE CODE TRANSLATOR (ICT)
	PAGE	,132
;	ICT - INTERACTIVE CODE TRANSLATOR
;
;	THIS PROGRAM TRANSLATES 8080 ASSEMBLY CODE INTO
;	8088 ASSEMBLY CODE.
;
;	TO USE ICT, ENTER
;
;	A>ICT d:FILENAME.TYP [d:]
;
;	WHERE d: IS A DRIVE DESIGNATION, AND [d:] IS AN
;	OPTIONAL OUTPUT DRIVE (IF DIFFERENT FROM THE INPUT
;	DRIVE
;
;	BY P. SWAYNE, HUG  08-MAR-85  11-APR-85
;
;	COPYRIGHT (C) 1985 BY HEATH USERS' GROUP
;
;	DEFINITIONS
;
M	EQU	Byte Ptr 0[BX]
CONIN	EQU	1			;CONSOLE INPUT
CONOUT	EQU	2			;CONSOLE OUTPUT
LSTOUT	EQU	5			;LST OUTPUT
DCIO	EQU	6			;DIRECT CONSOLE I/O
OPENF	EQU	15			;OPEN FILE
CLOSEF	EQU	16			;CLOSE FILE
DELETF	EQU	19			;DELETE FILE
READF	EQU	20			;READ FILE (SEQUENTIAL)
WRITEF	EQU	21			;WRITE FILE (SEQ)
MAKEF	EQU	22			;MAKE FILE
SETDMA	EQU	26			;SET DMA ADDRESS

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	5CH
FCB	LABEL	BYTE
	ORG	6CH
FCB2	LABEL	BYTE
	ORG	100H
;
;	GET ARGUMENT AND OPEN FILES
;
START:	CALL	TYPTX
	DB	13,10,'ICT -- Interactive Code Translator'
	DB	', V 1.0  (by PS:)',13,10
	DB	"Copyright (C) 1985 by Heath Users' Group."
	DB	13,10+80H
	MOV	SI,(Offset FCB)+1	;POINT TO FCB NAME AREA
	MOV	AL,[SI]			;GET FIRST CHARACTER
	CMP	AL,' '			;SPACE?
	JZ	NOFILE			;YES, NO FILE
	JMP	GOTARG			;ELSE, ASSUME ARGUMENT
NOFILE:	CALL	TYPTX
	DB	13,10,'To use this program, enter',13,10,10
	DB	'  ICT [i:]FILENAME[.EXT] [o:]',13,10,10
	DB	'The input drive [i:], output drive [o:], and',13,10
	DB	'the file name extension [.EXT] are optional.',13,10
	DB	'The extension is assumed to be .A80 if none is',13,10
	db	'supplied.'
	DB	13,10+80H
	JMP	EXIT			;EXIT
GOTARG:	DEC	SI			;BACK UP TO FCB START
	MOV	DI,(Offset OUTFCB)	;POINT TO OUTPUT FCB
	MOV	CX,9			;MOVE 9 CHARACTERS
	CLD
	REP	MOVSB			;MOVE THE CHARACTERS
	MOV	DI,Offset FCB+12
	MOV	CX,22
	XOR	AL,AL
	REP	STOSB			;CLEAR FCB AFTER NAME
	MOV	BX,(Offset FCB)+9	;POINT TO EXTENSION AREA
	MOV	AL,M
	CMP	AL,' '			;NO EXTENSION?
	JNZ	GOTEXT			;EXTENSION THERE
	MOV	M,'A'			;ELSE, INSERT "A80"
	INC	BX
	MOV	M,'8'
	INC	BX
	MOV	M,'0'
GOTEXT:	MOV	AL,Byte Ptr FCB2	;GET OPTIONAL OUTPUT DRIVE
	OR	AL,AL			;ANY SPECIFIED?
	JZ	NODRV			;NO
	MOV	Byte Ptr OUTFCB,AL	;ELSE, PUT IN OUTPUT FCB
NODRV:	MOV	SI,Offset FCB
	MOV	DI,Offset OUTFCB
	MOV	CX,12
	REPZ	CMPSB			;COMPARE FCB'S
	JNZ	NOTEQU			;FILES NOT THE SAME
	MOV	Word Ptr OUTFCB+10,'88'	;ELSE, RENAME OUTPUT
NOTEQU:	MOV	DX,Offset FCB
	MOV	AH,OPENF
	INT	21H			;TRY TO OPEN INPUT FILE
	INC	AL			;GOOD OPEN?
	JNZ	GOODOP			;YES
	CALL	TYPTX
	DB	13,10,'ERROR - Input file cannot be found.',13,10+80H
	JMP	EXIT
GOODOP:	MOV	Word Ptr FCB+14,Offset (BA.RDBUFE-BA.RDBUF) ;SET REC. SIZE
	MOV	DX,(Offset OUTFCB)
	MOV	AH,OPENF
	INT	21H			;TRY TO OPEN OUTPUT FILE
	INC	AL
	JZ	MAKEIT			;NO FILE THERE, MAKE NEW
	MOV	DX,(Offset OUTFCB)
	MOV	AH,DELETF
	INT	21H			;DELETE FILE
MAKEIT:	MOV	DX,(Offset OUTFCB)
	MOV	AH,MAKEF
	INT	21H			;MAKE OUTPUT FILE
	INC	AL			;GOOD MAKE
	JNZ	TRAN			;YES
	CALL	TYPTX
	DB	13,10,'ERROR - Directory full.',13,10+80H
	JMP	EXIT
;
;	MAIN LOOP - TRANSLATE CODE
;
TRAN:	CALL	TYPTX
	DB	13,10,'(1) Direct translation.  '
	DB	'(2) Interactive translation','.'+80H
	MOV	BX,Offset CHMSG
	CALL	TYPTX1			;PROMPT FOR CHOICE
	MOV	AH,1
	INT	21H			;GET CHOICE
	SUB	AL,'1'			;REMOVE ASCII+1
	JC	TRAN			;BAD ENTRY
	CMP	AL,2
	JNC	TRAN			;ENTRY TOO BIG
	MOV	Byte Ptr ICFLG,AL	;SAVE CHOICE
	CALL	TYPTX
	DB	13,10,10+80H
	MOV	Byte Ptr BA.COMM,0	;CLEAR COMMENT LINE
	MOV	SI,Offset DEFLIN	;POINT TO "M" DEFINITION
	JMP	MLOOP17			;PUT IT IN THE OUTPUT
MLOOP:	MOV	Word Ptr COLADR,0	;CLEAR COLON ADDRESS
	CALL	GETLIN			;GET LINE FROM INPUT
	MOV	Word Ptr INPOS,0	;CLEAR INPUT POSITION
	JNB	MLOOP1	
	JMP	FINISH			;END OF FILE, FINISH UP
MLOOP1:	INC	Word Ptr LINES		;COUNT THIS LINE
	MOV	SI,(Offset BA.INLIN)	;POINT TO INPUT LINE
	MOV	DI,(Offset BA.OUTLIN)	;AND OUTPUT LINE
	CALL	SOS			;GET FIRST CHARACTER
	CMP	AL,'*'			;STAR COMMENT?
	JNZ	MLOOP2
	MOV	AL,';'
	MOV	[SI],AL			;REPLACE "*" WITH ";"
MLOOP2:	CMP	AL,';'			;COMMENT?
	JNZ	MLOOP4			;NO
MLOOP3:	PUSH	DI			;PREPARE FOR POP
	JMP	MLOOP29			;PASS LINE UNCHANGED
MLOOP4:	CALL	TESTC			;TEST CHARACTER
	JB	MLOOP3			;CR, EMPTY LINE
	MOV	SI,(Offset BA.INLIN)
	MOV	AL,[SI]			;GET FIRST CHAR ON LINE
	CALL	TESTC			;TEST IT
	PUSHF				;SAVE FLAGS
	PUSH	SI			;SAVE POINTERS
	PUSH	DI
	CLD
COMLP:	LODSB				;GET A CHARACTER
	CMP	AL,13			;END OF LINE
	JZ	COMLP5			;NO COMMENT
	CMP	AL,27H			;QUOTE?
	JNZ	COMLP2			;NO
COMLP1:	LODSB
	CMP	AL,13
	JZ	COMLP5			;PREVENT DISASTER
	CMP	AL,27H	
	JNZ	COMLP1			;SKIP TO NEXT QUOTE
	JMP	COMLP
COMLP2:	CMP	AL,';'			;COMMENT DELIMITER?
	JZ	COMLP3			;YES, FOUND COMMENT
	JMP	COMLP			;ELSE, KEEP LOOKING
COMLP3:	MOV	Byte Ptr -1[SI],13	;END LINE HERE
	MOV	DI,Offset BA.COMM	;SAVE COMMENT HERE
COMLP4:	STOSB				;SAVE COMMENT CHARACTER
	CMP	AL,13			;END OF COMMENT?
	JZ	COMLP5			;YES
	LODSB				;ELSE, GET ANOTHER CHARACTER
	JMP	COMLP4
COMLP5:	POP	DI			;RESTORE POINTERS
	POP	SI
	POPF				;RESTORE FLAGS
	JZ	MLOOP8			;SPACE OR TAB, FIND ARGUMENT
	MOV	Byte Ptr MUCFLG,0	;CANCEL CAPITALIZATION
	CALL	SKIPLAB			;SKIP LABEL AND PUT IT IN OUTPUT
	MOV	BX,DI
	DEC	BX			;POINT TO LAST CHAR IN LABEL
	MOV	DH,M			;GET LAST CHAR IN LABEL
	MOV	AL,[SI]			;GET NEXT CHARACTER
	CMP	AL,13			;CR?
	JNZ	MLOOP6
	CMP	DH,':'			;COLON IN LABEL?
	JZ	MLOOP5
	MOV	AL,':'
	STOSB				;IF NOT, PUT ONE IN
MLOOP5:	INC	Word Ptr XLINES		;COUNT AS TRANSLATED LINE
	JMP	MLOOP22			;LINE COMPLETE
MLOOP6:	CMP	DH,':'			;COLON?
	JZ	MLOOP7			;YES
	INC	BX			;ELSE, FIX POINTER TO IT
	CMP	DL,7			;7 CHARS IN LABEL?
	JZ	MLOOP7			;YES
	MOV	AL,' '
	STOSB				;ELSE, PUT SPACE FOR POS. COLON
MLOOP7:	MOV	Word Ptr COLADR,BX	;SAVE PLACE FOR COLON
	MOV	Byte Ptr [BX],' '	;REMOVE COLON, FOR NOW
MLOOP8:	MOV	AL,9
	STOSB				;PUT TAB IN OUTPUT
	CALL	SOS			;SKIP TABS/SPACES IN INPUT
	CMP	AL,13			;CR?
	JNZ	MLOOP9	
	JMP	MLOOP22			;YES, EMPTY LINE
MLOOP9:	PUSH	DI			;SAVE OUTPUT POINTER
	MOV	DI,(Offset BA.OPCODE)	;GET OPCODE BUFFER
	MOV	Byte Ptr MUCFLG,1	;TURN CAPITALIZATION ON
	CALL	SKIPLAB			;PUT OPCODE IN BUFFER
	CALL	SOS			;SKIP OVER TABS/SPACES
	CMP	AL,13			;CR?
	JZ	MLOOP10			;YES, TRANSLATE OPCODE
	CMP	AL,'!'			;MULTI-STATEMENT LINE?
	JNZ	MLOOP11			;NO
MLOOP10:JMP	MLOOP15			;TRANSLATE OPCODE
MLOOP11:MOV	AL,9
	STOSB				;FOLLOW OPCODE WITH TAB
	PUSH	SI			;SAVE POINTERS
	PUSH	DI
	MOV	AH,4
	MOV	DI,Offset REGTBL	;POINT TO REGISTER ONLY OPCODES
	MOV	SI,Offset BA.OPCODE	;AND CURRENT OPCODE
	MOV	CX,Offset REGEND-REGTBL
	CALL	INSTR			;SEARCH FOR SPECIAL CODE
	POP	DI
	POP	SI
	JNZ	MLOOP12			;NOT REGISTER ONLY OPCODE
	CALL	SKIPLAB			;PUT IN SECOND PART OF OPCODE
	CALL	SOS			;SKIP SPACES
	JMP	SHORT MLOOP15		;NOW LOOK FOR COMPLETED OPCODE
MLOOP12:PUSH	SI
	PUSH	DI
	MOV	AH,4
	MOV	DI,Offset RITBL		;POINT TO REG/IMED OPCODES
	MOV	SI,Offset BA.OPCODE
	MOV	CX,Offset RIEND-RITBL
	CALL	INSTR			;SEARCH FOR SPECIAL CODE
	POP	DI
	POP	SI
	JNZ	MLOOP14			;NOT REG/IMED
MLOOP13:LODSB				;GET NEXT CHARACTER
	CALL	MUC			;MAKE UPPER CASE
	STOSB				;SAVE IT
	CMP	AL,','			;COMMA?
	JZ	MLOOP14			;YES, DONE
	JMP	MLOOP13
MLOOP14:
;
;	SKIP OVER ARGUMENT IN INPUT, AND TRANLATE IT
;	INTO A FORM WHERE "@" REPLACES THE VARIABLE PART
;	OF THE ARGUMENT.
;
SKIPARG:MOV	AL,'@'			;INSERT "@" IN BUFFER
	STOSB
	PUSH	DI			;SAVE OUTPUT BUFFER
	MOV	DI,(Offset BA.ARG)	;PUT REAL ARGUMENT HERE
SKIPA1:	LODSB				;GET A CHARACTER
	CALL	TESTC			;TEST IT
	JC	SKIPA3			;END OF ARGUMENT
	CMP	AL,27H			;QUOTE?
	JNZ	SKIPA2			;NO
SKIPQT:	STOSB				;ELSE, STORE IT
	LODSB				;GET NEXT CHAR
	CMP	AL,13
	JZ	SKIPA3			;PREVENT DISASTER
	CMP	AL,27H			;NEXT QUOTE?
	JNZ	SKIPQT			;SKIP TO IT
	STOSB				;STORE QUOTE
	JMP	SKIPA1
SKIPA2:	CMP	AL,'!'			;MULTI-STATEMENT?
	JZ	SKIPA3			;YES, DONE
	STOSB				;ELSE, STORE CHARACTER
	JMP	SKIPA1
SKIPA3:	DEC	DI			;MOV TO LAST CHARACTER
	MOV	AL,[DI]			;GET IT
	CALL	TESTC			;TEST IT
	JZ	SKIPA3			;BACK UP PAST SPACES, TABS
	INC	DI
	MOV	Byte Ptr [DI],0		;TERMINATE ARGUMENT
	POP	DI			;RESTORE OUTPUT BUFFER
;
;	AT THIS POINT, WE SHOULD HAVE THE OPCODE AND
;	TRANSLATED ARGUMENT IN THE BUFFER "OPCODE".
;	THE REAL ARGUMENT IS STORED AT "ARG" FOR LATER
;	INSERTION INTO THE OUTPUT LINE
;
MLOOP15:MOV	AL,[SI]			;GET LAST CHARACTER
	CMP	AL,'!'			;MULTI STATEMENT LINE?
	JNZ	MLNMS			;NO
	MOV	Byte Ptr [SI],9		;ELSE, REPLACE ! WITH TAB
	MOV	Word Ptr INPOS,SI	;SAVE POSITION
MLNMS:	XOR	AL,AL
	STOSB				;ZERO END OF OPCODE/ARGUMENT
	MOV	DI,(Offset OPCODES)	;POINT TO OPCODES
	MOV	SI,(Offset BA.OPCODE)	;AND OUR OPCODE
	MOV	CX,(Offset OPEND)-(Offset OPCODES)	;SEARCH THIS AREA
	CALL	COUNT			;COUNT CHARACTERS IN OPCODE
	CALL	SEARCH			;SEARCH FOR OPCODE
	JZ	MLOOP18			;FOUND IT
	CALL	PERROR			;SAY "LINE NOT TRANSLATED"
	MOV	Word Ptr COLADR,0	;ZERO COLON ADDRESS
	INC	Word Ptr ELINES		;COUNT ERROR LINES
MLOOP16:MOV	Byte Ptr BA.COMM,0	;DELETE SAVED COMMENT
	MOV	SI,(Offset BA.INLIN)	;POINT TO INPUT LINE
	POP	DI			;FIX STACK
MLOOP17:MOV	DI,(Offset BA.OUTLIN)	;POINT TO OUTPUT LINE
	JMP	SHORT MLOOP19		;PASS THE LINE UNCHANGED
MLOOP18:MOV	SI,DI			;POINT SI TO FOUND OPCODE
	POP	DI			;GET OUTPUT ADDRESS
	INC	Word Ptr XLINES		;COUNT TRANSLATED LINES
MLOOP19:LODSB				;GET A CHARACTER
	OR	AL,AL			;END OF OPCODE?
	JZ	MLOOP22			;YES, FINISHED
	CMP	AL,1			;FINISH ON 1, ALSO
	JZ	MLOOP22
	CMP	AL,7			;CHOICE?
	JC	MLOOP25			;YES
	CMP	AL,13			;CR?
	JZ	MLOOP22			;YES, FINISHED
	CMP	AL,'@'			;DUMMY ARGUMENT?
	JNZ	MLOOP20			;NO
	CALL	INSARG			;ELSE, REPLACE WITH REAL ARGUMENT
	JMP	MLOOP19			;KEEP GOING
MLOOP20:STOSB				;STORE CHARACTER
	CMP	AL,'_'			;GENERATED LABEL?
	JNZ	MLOOP19			;NO
	MOV	BX,Word Ptr LABNO	;ELSE, GET LABEL NUMBER
	XOR	Byte Ptr LABFLG,1	;TIME TO INCREMENT NO.?
	JZ	MLOOP21			;NO
	INC	BX			;ELSE, ADD 1
MLOOP21:MOV	Word Ptr LABNO,BX	;UPDATE NO.
	INC	Byte Ptr DECFLG		;FIX DECOUT ROUTINE
	CALL	DECOUT			;OUTPUT THE NUMBER
	DEC	Byte Ptr DECFLG
	JMP	MLOOP19			;FINISH THE LINE
MLOOP22:MOV	AL,13
	STOSB				;PUT IN CR
	MOV	AL,10
	STOSB				;AND LF
	MOV	SI,Word Ptr COLADR	;GET POSSIBLE COLON ADDRESS
	MOV	BX,SI
	CMP	SI,0			;POSSIBLE COLON?
	JZ	MLOOP24			;NO
MLOOP23:LODSB				;ELSE, LOOK FOR NEXT CHARACTER
	CALL	TESTC
	JZ	MLOOP23
	CMP	AL,'D'+80H		;DB, DW?
	JZ	MLOOP24			;YES
	CMP	AL,'E'+80H		;EQU?
	JZ	MLOOP24
	CMP	AL,'='+80H		;=?
	JZ	MLOOP24
	MOV	Byte Ptr [BX],':'	;ELSE, PUT COLON AFTER LABEL
MLOOP24:CALL	PUTLIN			;OUTPUT COMPLETED LINE
	JMP	MLOOP			;GET ANOTHER LINE
MLOOP25:CMP	Byte Ptr ICFLG,0	;IN INTERACTIVE MODE?
	JZ	MLOOP19			;NO, USE DEFAULT
	SUB	AL,2			;ELSE, START CHOICE AT 0
	XOR	AH,AH
	SHL	AX,1
	MOV	BX,AX			;BX POINTS TO PLACE IN CHOICE TABLE
	MOV	BX,CHTBL[BX]		;GET CHOICE MSG. ADDR.
	MOV	CL,[BX]			;GET NO. OF CHOICES
	INC	BX
MLOOP26:PUSH	BX			;SAVE START OF MSG.
	CALL	TYPTX1			;PRINT MSG.
	MOV	BX,Offset CHMSG
	CALL	TYPTX1			;PROMPT FOR CHOICE
	MOV	AH,1
	INT	21H			;GET CHOICE
	POP	BX			;RESTORE MESSAGE ADDR.
	SUB	AL,'1'			;REMOVE ASCII+1
	JC	MLOOP26			;BAD ENTRY
	CMP	AL,CL
	JNC	MLOOP26			;ENTRY TOO BIG
	MOV	CL,AL			;CHOICE TO CL
	CALL	TYPTX
	DB	13,10+80H		;CRLF AFTER CHOICE
	OR	CL,CL			;FIRST ENTRY WANTED?
	JZ	MLOOP28			;YES
	XOR	CH,CH
MLOOP27:LODSB
	OR	AL,AL			;LOOK FOR NEXT CHOICE
	JNZ	MLOOP27
	LOOP	MLOOP27			;UNTIL PROPER CHOICE FOUND
MLOOP28:JMP	MLOOP19			;CHOICE FOUND, USE IT
MLOOP29:INC	Word Ptr PLINES		;COUNT PASSED LINES
	JMP	MLOOP16
;
;	FINISHED - FLUSH OUTPUT BUFFER AND CLOSE FILES
;
FINISH:	MOV	DI,Word PTr WRPTR	;GET WRITE POINTER
;	MOV	AL,1AH
;	STOSB				;PUT IN EOF
	MOV	CX,Offset BA.WRBUFE
	SUB	CX,DI			;GET CHARS LEFT IN BUFFER
	MOV	AL,1AH
	REP	STOSB			;ZERO REST OF BUFFER
	MOV	DX,(Offset BA.WRBUF)
	MOV	AH,SETDMA
	INT	21H			;SET DMA TO OUTPUT BUFFER
	MOV	DX,(Offset OUTFCB)
	MOV	AH,WRITEF
	INT	21H			;WRITE LAST BUFFER FULL
	OR	AL,AL			;GOOD WRITE
	JZ	FIN1	
	JMP	WRERR			;NO
FIN1:	MOV	DX,(Offset OUTFCB)
	MOV	AH,CLOSEF		;ELSE, CLOSE OUTPUT FILE
	INT	21H
	INC	AL			;GOOD CLOSE?
	JNZ	FIN2	
	JMP	WRERR			;NO
FIN2:	CALL	TYPTX
	DB	13,10,'Translation complete.',13,10,10
	DB	'Lines in source:',89H
	MOV	BX,Word Ptr LINES
	CALL	DECOUT			;PRINT LINES INPUT
	CALL	TYPTX
	DB	13,10,'Translated lines:',89H
	MOV	BX,Word Ptr XLINES
	CALL	DECOUT			;PRINT LINES TRANSLATED
	CALL	TYPTX
	DB	13,10,'Comment/empty lines:',89H
	MOV	BX,Word Ptr PLINES
	CALL	DECOUT			;PRINT LINES PASSED
	CALL	TYPTX
	DB	13,10,'Untranslatable lines:',89H
	MOV	BX,Word Ptr ELINES
	CALL	DECOUT
	CALL	TYPTX
	DB	13,10+80H
EXIT:	INT	20H			;RETURN TO DOS
;
;	SUBROUTINES
;
;	GETLIN - GET A LINE FROM THE INPUT FILE
;
GETLIN:	MOV	BX,(Offset BA.INLIN)	;PUT LINE HERE
	MOV	SI,Word Ptr INPOS	;GET INPUT POSITION
	CMP	SI,0			;DO NEW LINE?
	JNZ	GETLIN4			;NO, SOME LEFT ON OLD ONE
GETLIN1:CALL	RDCHR			;READ CHARACTER FROM FILE
	JNB	GETLIN2	
	RET				;END OF FILE
GETLIN2:CMP	Byte Ptr ICFLG,0	;INTERACTIVE MODE?
	JZ	GETLIN3			;NO
	CALL	SCOUT			;ELSE, ECHO LINE
GETLIN3:MOV	M,AL			;STORE CHARACTER
	INC	BX			;INCREMENT POINTER
	CMP	AL,10			;END OF LINE?
	JNZ	GETLIN1			;NO, CONTINUE
	RET
GETLIN4:MOV	AX,SI
	SUB	AX,BX			;GET COUNT INTO LINE
	MOV	CX,134			;SIZE OF INPUT LINE
	SUB	CX,AX			;GET COUNT TO MOVE
	MOV	DI,BX			;POINT TO INPUT LINE
	REP	MOVSB			;MOVE LINE DOWN
	RET
;
;	PUTLIN - PUT A LINE IN THE OUTPUT FILE
;
PUTLIN:	MOV	BX,(Offset BA.OUTLIN)	;PUT LINE HERE
	MOV	Byte Ptr CURPOS,0	;ZERO CURSOR POSITION
PUTLIN1:MOV	AL,M			;GET A CHARACTER
	PUSH	AX			;SAVE IT
	AND	AL,7FH
	CMP	AL,13			;END OF A LINE?
	POP	AX
	JNZ	PUTLIN5			;NO
	CMP	Byte Ptr BA.COMM,0	;ANY COMMENT?
	JZ	PUTLIN5			;NO
	MOV	AL,Byte Ptr CURPOS	;GET CURSOR POSITION
	MOV	CX,3
	SHR	AL,CL			;FIND TAB STOP
	MOV	CL,5
	SUB	CL,AL			;CL = TABS TO COMMENT
	JA	PUTLIN2			;TABS OK
	MOV	CL,1			;ELSE, USE ONE TAB
PUTLIN2:MOV	AL,9
	PUSH	CX
	CALL	WRCHR			;STORE A TAB
	POP	CX
	LOOP	PUTLIN2			;UNTIL DONE
	MOV	SI,Offset BA.COMM	;POINT TO COMMENT
PUTLIN3:LODSB				;GET A CHARACTER
	CMP	AL,13			;END OF COMMENT
	JZ	PUTLIN4			;YES
	CALL	WRCHR			;ELSE, WRITE CHARACTER
	JMP	PUTLIN3
PUTLIN4:MOV	Byte Ptr BA.COMM,0	;CLEAR COMMENT
PUTLIN5:CMP	AL,9			;TAB?
	JNZ	PUTLIN6			;NO
	ADD	Byte Ptr CURPOS,8
	AND	Byte Ptr CURPOS,0F8H	;ELSE, FIX TAB STOP
	JMP	SHORT PUTLIN7
PUTLIN6:INC	Byte Ptr CURPOS		;COUNT CHARACTER
PUTLIN7:CALL	WRCHR			;WRITE CHARACTER
	INC	BX			;INCREMENT POINTER
	CMP	AL,10			;END OF LINE?
	JNZ	PUTLIN1			;NO, CONTINUE
	RET
;
;	PERROR - PRINT MESSAGE FOR ERROR LINE
;
PERROR:	CMP	Byte Ptr ICFLG,0	;INTERACTIVE MODE?
	JZ	PER1			;NO
	CALL	TYPTX
	DB	'*** ABOVE LINE NOT TRANSLATED ***',13,10+80H
PER1:	RET
;
;	RDCHR - READ A CHARACTER FROM THE INPUT FILE
;
RDCHR:	PUSH	BX			;SAVE BX
	MOV	DX,(Offset BA.RDBUF)	;POINT TO READ BUFFER
	MOV	BX,Word Ptr RDPTR	;GET READ POINTER
	CMP	BX,DX			;COMPARE BX TO DX
	JNZ	RDCHR2			;NOT EQUAL, GET CHARACTER FROM FILE
	MOV	BX,(Offset BA.RDBUF)	;PUT DATA HERE
	CALL	READFIL			;READ FROM FILE
	JNB	RDCHR1			;GOOD READ
	MOV	M,1AH			;MARK END
RDCHR1:	MOV	BX,(Offset BA.RDBUF)	;POINT TO READ BUFFER
	MOV	Word Ptr RDPTR,BX	;SET UP READ POINTER
RDCHR2:	MOV	CH,M			;GET CHARACTER
	INC	BX			;INCREMENT POINTER
	MOV	Word Ptr RDPTR,BX	;UPDATE IT
	XCHG	BX,DX			;POINTER TO DX
	MOV	BX,(Offset BA.RDBUFE)	;POINT TO END OF BUFFER
	CMP	BX,DX			;AT END?
	JNZ	RDCHR3			;NO
	MOV	BX,(Offset BA.RDBUF)	;ELSE, RESET POINTER
	MOV	Word Ptr RDPTR,BX
RDCHR3:	POP	BX			;RESTORE BX
	MOV	AL,CH			;GET CHARACTER
	CMP	AL,1AH			;END?
	JZ	RDCHR4			;YES
	OR	AL,AL			;ELSE, CLEAR CARRY
	RET
RDCHR4:	STC				;MARK END
	RET
;
;	WRCHR - WRITE CHARACTER TO FILE
;
WRCHR:	PUSH	BX			;SAVE BX
	PUSH	AX			;SAVE CHARACTER TO WRITE
	MOV	DX,(Offset BA.WRBUFE)	;GET END OF WRITE BUFFER
	MOV	BX,Word Ptr WRPTR	;GET WRITE POINTER
	CMP	BX,DX			;TIME TO WRITE?
	JNZ	WRCHR1			;NO
	MOV	DX,(Offset BA.WRBUF)	;POINT TO WRITE BUFFER
	MOV	AH,SETDMA
	INT	21H			;SET DMA HERE
	MOV	DX,(Offset OUTFCB)	;GET OUTPUT FCB
	MOV	AH,WRITEF
	INT	21H			;WRITE ONE RECORD
	OR	AL,AL			;GOOD WRITE?
	JZ	WRCHR0			;YES
WRERR:	CALL	TYPTX
	DB	13,10,"ERROR - Can't write output.",13,10+80H
	JMP	EXIT
WRCHR0:	CLD				;FIX DIR. FLAG
	MOV	BX,(Offset BA.WRBUF)
	MOV	Word Ptr WRPTR,BX	;SET WRITE POINTER
WRCHR1:	POP	AX			;GET CHARACTER TO WRITE
	PUSH	AX			;SAVE AGAIN
	AND	AL,7FH			;STRIP HIGH BIT
	MOV	M,AL			;PUT IT IN BUFFER
	INC	BX			;INCREMENT POINTER
	MOV	Word Ptr WRPTR,BX	;SAVE IT
	POP	AX			;RESTORE CHARACTER
	POP	BX			;RESTORE BX
	RET
;
;	READFIL - READ DISK FILE
;
;	ENTRY:
;	BX = ADDRESS TO READ INTO
;	CX = NUMBER OF BYTES TO READ
;
;	EXIT:
;	CY = 1 IF END OR ERROR, AND
;	BX = NEXT FREE BYTE

READFIL:MOV	CX,Offset (BA.RDBUFE-BA.RDBUF)	;GET BUFFER SIZE
	MOV	DX,Offset FCB		;POINT TO FCB
	XCHG	BX,DX			;DE = ADDRESS
	MOV	AH,SETDMA
	CALL	CBDOS			;SET DMA ADDRESS
	XCHG	BX,DX			;DE = FCB
	MOV	AH,READF
	CALL	CBDOS			;READ A RECORD
	ADD	BX,CX			;POINT TO END OF RECORD
	OR	AL,AL			;TEST RESULT OF READ
	JZ	READX			;GOOD READ
	CMP	AL,3			;PARTIAL RECORD
	JZ	READ1			;YES
	SUB	BX,CX			;ELSE, BACK UP TO RECORD START
	STC				;MARK END
READX:	RET
READ1:	MOV	DI,BX
	XOR	AL,AL			;FILE FILLED WITH ZEROS
	STD
	REPZ	SCASB			;SEARCH FOR NON-ZERO
	INC	DI
	INC	DI			;POINT TO AFTER LAST CHAR
	MOV	BX,DI
	CLD				;FIX DIR. FLAG
	STC				;MARK END
	RET
;
;	SKIPLAB - SKIP OVER LABEL OR OPCODE, PUTTING IT IN BUFFER
;
SKIPLAB:MOV	DL,0			;CLEAR A COUNTER
SKIPL1:	LODSB				;GET A CHARACTER
	CALL	TESTC			;TEST FOR SPACE, TAB, OR CR
	JNZ	SKIPL2
SKIPLX:	DEC	SI			;POINT TO LAST CHAR
	RET
SKIPL2:	CMP	AL,'!'			;EXCLAIMATION?
	JZ	SKIPLX			;IF SO, EXIT
	CMP	Byte Ptr MUCFLG,0	;CAPITALIZE?
	JZ	SKIPL3			;NO
	CALL	MUC			;ELSE, DO IT
SKIPL3:	STOSB				;STORE CHARACTER
	INC	DL			;COUNT IT
	JMP	SKIPL1			;DO MORE
;
;	MUC -- MAP TO UPPER CASE
;
MUC:	CMP	AL,'a'			;LESS THAN "a"?
	JC	MUCX			;YES
	CMP	AL,'z'+1		;MORE THAN "z"?
	JNC	MUCX			;YES
	AND	AL,5FH			;ELSE, CAPITALIZE
MUCX:	RET
;
;	SOS - SKIP OVER SPACES
;
SOS:	LODSB				;GET A CHARACTER
	CMP	AL,' '
	JZ	SOS			;SKIP SPACES
	CMP	AL,9
	JZ	SOS			;SKIP TABS
	DEC	SI			;POINT TO LAST CHAR
	RET
;
;	INSARG - INSERT SAVED ARGUMENT INTO OUTPUT
;
INSARG:	PUSH	SI			;SAVE SI
	MOV	SI,(Offset BA.ARG)	;ARGUMENT IS HERE
	PUSH	SI
	PUSH	DI
	MOV	DI,Offset BDOS		;POINT TO "BDOS"
	MOV	CX,12
	MOV	AH,5
	CALL	INSTR			;CHECK FOR "BDOS"
	POP	DI
	POP	SI
	JNZ	INSARG1			;NOT THERE
	MOV	Byte Ptr [SI],'M'	;ELSE, CHANGE TO "MDOS"
INSARG1:LODSB				;GET A CHARACTER
	OR	AL,AL			;END?
	JZ	INSARG2			;YES, EXIT
	STOSB				;STORE CHARACTER
	JMP	INSARG1			;LOOP UNTIL DONE
INSARG2:POP	SI			;RESTORE BX
	RET
;
;	COUNT - COUNT CHARACTERS IN OPCODE
;	COUNT RETURNED IN AH
;
COUNT:	PUSH	SI			;SAVE DI
	MOV	AH,0			;CLEAR COUNTER
	MOV	SI,(Offset BA.OPCODE)
COUNT1:	LODSB				;GET A CHARACTER
	OR	AL,AL			;END OF OPCODE?
	JZ	COUNT2			;YES, EXIT
	INC	AH			;ELSE, COUNT THE CHARACTER
	JMP	COUNT1			;COUNT MORE
COUNT2:	INC	AH			;ADD TRAILING ZERO
	POP	SI
	RET
;
;	TESTC - TEST CHARACTER
;	RETURN Z IF SPACE OR TAB
;	RETURN C AND Z IF CR
;	RETURN NZ IF NONE OF ABOVE
;
TESTC:	CMP	AL,' '			;SPACE?
	JZ	TESTCX
	CMP	AL,9			;TAB?
	JZ	TESTCX
	CMP	AL,13			;CR?
	STC				;ASSUME YES
	JZ	TESTCX
	CMC				;NO MATCH, CLEAR CARRY
TESTCX:	RET
;
;	DECOUT - PRINT BX IN DECIMAL
;	THIS IS A TRICKY ROUTINE THAT MAKES USE OF THE
;	STACK TO STORE DECODED DIGITS.

DECOUT:	PUSH	CX
	PUSH	DX
	PUSH	BX			;SAVE REGISTERS
	MOV	CX,10			;RADIX FOR CONVERSION
	MOV	DX,0
	MOV	AX,BX
	DIV	CX			;DIVIDE BY 10
	MOV	BX,AX			;ANSWER TO BX (DX [REMAINDER] = DIGIT)
	CMP	BX,0			;DONE?
	JZ	DEC1	
	CALL	DECOUT			;CALL RECURSIVELY UNTIL DONE
DEC1:	MOV	AL,DL			;GET CHARACTER TO PRINT
	ADD	AL,'0'			;ADD ASCII BIAS
	CMP	Byte Ptr DECFLG,0	;OUTPUT TO SCREEN?
	JZ	DEC2			;YES
	STOSB				;ELSE, OUTPUT TO MEMORY
	JMP	SHORT DEC3
DEC2:	CALL	SCOUT			;PRINT IT
DEC3:	POP	BX			;RESTORE REGISTERS
	POP	DX
	POP	CX
	RET
;
;	TYPTX - TYPE TEXT UNTIL PARITY BIT SET
;
TYPTX:	MOV	BP,SP			;GET TEXT ADDR
	XCHG	BX,[BP]
	CALL	TYPTX1
	MOV	BP,SP
	XCHG	BX,[BP]
	RET
TYPTX1:	MOV	AL,M
	AND	AL,7FH
	CALL	SCOUT
	CMP	AL,M
	LAHF
	INC	BX
	SAHF
	JZ	TYPTX1
	RET
;
;	SCOUT - OUTPUT CHARACTER
;
SCOUT:	PUSH	AX
	PUSH	CX
	PUSH	DX
	PUSH	BX
	MOV	DL,AL
	MOV	AH,CONOUT
	INT	21H
	POP	BX
	POP	DX
	POP	CX
	POP	AX
	RET
;
;	SEARCH - SEARCH FOR OPCODE IN TABLE
;
;	DI = OPCODE TABLE
;	SI = OPCODE TO FIND
;	CX = LENGTH OF TABLE
;	AH = LENGTH OF OPCODE
;
SEARCH:	CLD
SEARCH0:OR	CX,CX			;SEARCHED TOO FAR?
	JZ	SEARCHX			;YES
	JNS	SEARCH1
SEARCHX:XOR	AL,AL
	INC	AL			;SET NZ
	RET				;RETURN IF NOT FOUND
SEARCH1:MOV	AL,[SI]
	CMP	AL,[DI]			;IN THE RIGHT PART OF THE TABLE?
	JZ	INSTR			;YES, SEARCH FOR THE OPCODE
	MOV	AL,1
	REPNZ	SCASB			;FIND END OF DEFINITION
	JMP	SEARCH0			;AND TEST FOR RIGHT PLACE

;	INSTR - SEARCH FOR ITEM IN TABLE
;
;	DI = TABLE
;	SI = ITEM TO FIND
;	CX = LENGTH OF TABLE
;	AH = LENGTH OF ITEM
;
;	RETURNS Z FLAG IF FOUND, WITH BX = END OF ITEM
;
INSTR:	MOV	BL,AH
	XOR	BH,BH			;BX = SUBSTRING LENGTH
	SUB	CX,BX			;SUBTRACT SUB LENGTH FROM STR LENGTH
INSTR0:	PUSH	DI			;SAVE REGISTERS
	PUSH	SI
	PUSH	CX
	MOV	CX,BX			;GET SUB LENGTH
	REPZ	CMPSB			;COMPARE STRINGS
	POP	CX
	POP	SI
	POP	DI
	JZ	INSTR1			;FOUND IT
	MOV	AL,1
	REPNZ	SCASB			;FIND NEXT TABLE ENTRY
	OR	CX,CX			;END OF TABLE?
	JNZ	INSTR0
	OR	AL,AL			;ELSE, SET NZ
	RET				;AND RETURN
INSTR1:	ADD	DI,BX			;MOVE TO END OF STRING
	XOR	AL,AL			;SET ZERO
	RET
;
;	CALL BDOS WITH REGISTERS SAVED
;
CBDOS:	PUSH	CX
	PUSH	DX
	PUSH	BX
	INT	21H
	POP	BX
	POP	DX
	POP	CX
	RET
;
OPCODES	LABEL	BYTE			;OPCODE TABLES START HERE
;
	DB	'ACI	@',0
	DB	'ADC	AL,@',1
	DB	'ADC	A',0
	DB	'ADC	AL,AL',1
	DB	'ADC	B',0
	DB	'ADC	AL,CH',1
	DB	'ADC	C',0
	DB	'ADC	AL,CL',1
	DB	'ADC	D',0
	DB	'ADC	AL,DH',1
	DB	'ADC	E',0
	DB	'ADC	AL,DL',1
	DB	'ADC	H',0
	DB	'ADC	AL,BH',1
	DB	'ADC	L',0
	DB	'ADC	AL,BL',1
	DB	'ADC	M',0
	DB	'ADC	AL,M',1
	DB	'ADD	A',0
	DB	'ADD	AL,AL',1
	DB	'ADD	B',0
	DB	'ADD	AL,CH',1
	DB	'ADD	C',0
	DB	'ADD	AL,CL',1
	DB	'ADD	D',0
	DB	'ADD	AL,DH',1
	DB	'ADD	E',0
	DB	'ADD	AL,DL',1
	DB	'ADD	H',0
	DB	'ADD	AL,BH',1
	DB	'ADD	L',0
	DB	'ADD	AL,BL',1
	DB	'ADD	M',0
	DB	'ADD	AL,M',1
	DB	'ADI	@',0
	DB	'ADD	AL,@',1
	DB	'ANA	A',0
	DB	'AND	AL,AL',1
	DB	'ANA	B',0
	DB	'AND	AL,CH',1
	DB	'ANA	C',0
	DB	'AND	AL,CL',1
	DB	'ANA	D',0
	DB	'AND	AL,DH',1
	DB	'ANA	E',0
	DB	'AND	AL,DL',1
	DB	'ANA	H',0
	DB	'AND	AL,BH',1
	DB	'ANA	L',0
	DB	'AND	AL,BL',1
	DB	'ANA	M',0
	DB	'AND	AL,M',1
	DB	'ANI	@',0
	DB	'AND	AL,@',1
	DB	'CALL	@',0
	DB	'CALL	@',1
	DB	'CC	@',0
	DB	'JNC	L_',8DH,8AH,9
	DB	'CALL	@',8DH,8AH,'L_:',1
	DB	'CM	@',0
	DB	'JNS	L_',8DH,8AH,9
	DB	'CALL	@',8DH,8AH,'L_:',1
	DB	'CMA',0
	DB	'NOT	AL',1
	DB	'CMC',0
	DB	'CMC',1
	DB	'CMP	A',0
	DB	'CMP	AL,AL',1
	DB	'CMP	B',0
	DB	'CMP	AL,CH',1
	DB	'CMP	C',0
	DB	'CMP	AL,CL',1
	DB	'CMP	D',0
	DB	'CMP	AL,DH',1
	DB	'CMP	E',0
	DB	'CMP	AL,DL',1
	DB	'CMP	H',0
	DB	'CMP	AL,BH',1
	DB	'CMP	L',0
	DB	'CMP	AL,BL',1
	DB	'CMP	M',0
	DB	'CMP	AL,M',1
	DB	'CNC	@',0
	DB	'JC	L_',8DH,8AH,9
	DB	'CALL	@',8DH,8AH,'L_:',1
	DB	'CNZ	@',0
	DB	'JZ	L_',8DH,8AH,9
	DB	'CALL	@',8DH,8AH,'L_:',1
	DB	'CP	@',0
	DB	'JS	L_',8DH,8AH,9
	DB	'CALL	@',8DH,8AH,'L_:',1
	DB	'CPE	@',0
	DB	'JNP	L_',8DH,8AH,9
	DB	'CALL	@',8DH,8AH,'L_:',1
	DB	'CPI	@',0
	DB	'CMP	AL,@',1
	DB	'CPO	@',0
	DB	'JP	L_',8DH,8AH,9
	DB	'CALL	@',8DH,8AH,'L_:',1
	DB	'CZ	@',0
	DB	'JNZ	L_',8DH,8AH,9
	DB	'CALL	@',8DH,8AH,'L_:',1
	DB	'DAA',0
	DB	'DAA',1
	DB	'DAD	B',0
	DB	2,'LAHF',8DH,8AH,9,'ADD	BX,CX',8DH,8AH,9	;
	DB	'RCR	SI,1',8DH,8AH,9,'SAHF',8DH,8AH,9
	DB	'RCL	SI,1',0
	DB	'ADD	BX,CX',1
	DB	'DAD	D',0
	DB	2,'LAHF',8DH,8AH,9,'ADD	BX,DX',8DH,8AH,9	;
	DB	'RCR	SI,1',8DH,8AH,9,'SAHF',8DH,8AH,9
	DB	'RCL	SI,1',0
	DB	'ADD	BX,DX',1
	DB	'DAD	H',0
	DB	2,'LAHF',8DH,8AH,9,'ADD	BX,BX',8DH,8AH,9	;
	DB	'RCR	SI,1',8DH,8AH,9,'SAHF',8DH,8AH,9
	DB	'RCL	SI,1',0
	DB	'ADD	BX,BX',1
	DB	'DAD	SP',0
	DB	2,'LAHF',8DH,8AH,9,'ADD	BX,SP',8DH,8AH,9	;
	DB	'RCR	SI,1',8DH,8AH,9,'SAHF',8DH,8AH,9
	DB	'RCL	SI,1',0
	DB	'ADD	BX,SP',1
	DB	'DCR	A',0
	DB	'DEC	AL',1
	DB	'DCR	B',0
	DB	'DEC	CH',1
	DB	'DCR	C',0
	DB	'DEC	CL',1
	DB	'DCR	D',0
	DB	'DEC	DH',1
	DB	'DCR	E',0
	DB	'DEC	DL',1
	DB	'DCR	H',0
	DB	'DEC	BH',1
	DB	'DCR	L',0
	DB	'DEC	BL',1
	DB	'DCR	M',0
	DB	'DEC	M',1
	DB	'DCX	B',0
	DB	3,'LAHF',8DH,8AH,9,'DEC	CX',8DH,8AH,9		;FOUR CHOICES
	DB	'SAHF',0					;SAVE/RES
	DB	'LAHF',8DH,8AH,9,'DEC	CX',0			;SAVE
	DB	'DEC	CX',8DH,8AH,9,'SAHF',0			;RES
	DB	'DEC	CX',1					;NONE
	DB	'DCX	D',0
	DB	3,'LAHF',8DH,8AH,9,'DEC	DX',8DH,8AH,9		;
	DB	'SAHF',0
	DB	'LAHF',8DH,8AH,9,'DEC	DX',0
	DB	'DEC	DX',8DH,8AH,9,'SAHF',0
	DB	'DEC	DX',1
	DB	'DCX	H',0
	DB	3,'LAHF',8DH,8AH,9,'DEC	BX',8DH,8AH,9		;
	DB	'SAHF',0
	DB	'LAHF',8DH,8AH,9,'DEC	BX',0
	DB	'DEC	BX',8DH,8AH,9,'SAHF',0
	DB	'DEC	BX',1
	DB	'DCX	SP',0
	DB	3,'LAHF',8DH,8AH,9,'DEC	SP',8DH,8AH,9		;
	DB	'SAHF',0
	DB	'LAHF',8DH,8AH,9,'DEC	SP',0
	DB	'DEC	SP',8DH,8AH,9,'SAHF',0
	DB	'DEC	SP',1
	DB	'DB	@',0
	DB	'D'+80H,'B	@',1
	DB	'DI',0
	DB	'CLI',1
	DB	'DS	@',0
	DB	'D'+80H,'B	@ DUP (?)',1
	DB	'DW	@',0
	DB	'D'+80H,'W	OFFSET (@)',1
	DB	'EI',0
	DB	'STI',1
	DB	'END',0
	DB	8DH,8AH,'CODE	ENDS',8DH,8AH,9
	DB	'END',1
	DB	'END	@',0
	DB	8DH,8AH,'CODE	ENDS',8DH,8AH,9
	DB	'END	@',1
	DB	'EQU	@',0
	DB	'E'+80H,'QU	@',1
	DB	'HLT',0
	DB	'HLT',1
	DB	'IN	@',0
	DB	'IN	AL,@',1
	DB	'INR	A',0
	DB	'INC	AL',1
	DB	'INR	B',0
	DB	'INC	CH',1
	DB	'INR	C',0
	DB	'INC	CL',1
	DB	'INR	D',0
	DB	'INC	DH',1
	DB	'INR	E',0
	DB	'INC	DL',1
	DB	'INR	H',0
	DB	'INC	BH',1
	DB	'INR	L',0
	DB	'INC	BL',1
	DB	'INR	M',0
	DB	'INC	M',1
	DB	'INX	B',0
	DB	3,'LAHF',8DH,8AH,9,'INC	CX',8DH,8AH,9		;FOUR CHOICES
	DB	'SAHF',0
	DB	'LAHF',8DH,8AH,9,'INC	CX',0
	DB	'INC	CX',8DH,8AH,9,'SAHF',0
	DB	'INC	CX',1
	DB	'INX	D',0
	DB	3,'LAHF',8DH,8AH,9,'INC	DX',8DH,8AH,9		;
	DB	'SAHF',0
	DB	'LAHF',8DH,8AH,9,'INC	DX',0
	DB	'INC	DX',8DH,8AH,9,'SAHF',0
	DB	'INC	DX',1
	DB	'INX	H',0
	DB	3,'LAHF',8DH,8AH,9,'INC	BX',8DH,8AH,9		;
	DB	'SAHF',0
	DB	'LAHF',8DH,8AH,9,'INC	BX',0
	DB	'INC	BX',8DH,8AH,9,'SAHF',0
	DB	'INC	BX',1
	DB	'INX	SP',0
	DB	3,'LAHF',8DH,8AH,9,'INC	SP',8DH,8AH,9		;
	DB	'SAHF',0
	DB	'LAHF',8DH,8AH,9,'INC	SP',0
	DB	'INC	SP',8DH,8AH,9,'SAHF',0
	DB	'INC	SP',1
	DB	'JC	@',0
	DB	4,'JNC	L_',8DH,8AH,9				;COND. JMPS
	DB	'JMP	@',8DH,8AH,'L_:',0
	DB	'JC	@',1
	DB	'JE	@',0
	DB	4,'JNE	L_',8DH,8AH,9				;
	DB	'JMP	@',8DH,8AH,'L_:',0
	DB	'JE	@',1
	DB	'JM	@',0
	DB	4,'JNS	L_',8DH,8AH,9				;
	DB	'JMP	@',8DH,8AH,'L_:',0
	DB	'JS	@',1
	DB	'JMP	@',0
	DB	4,'JMP	@',0
	DB	'JMP	SHORT @',1
	DB	'JNC	@',0
	DB	4,'JC	L_',8DH,8AH,9				;
	DB	'JMP	@',8DH,8AH,'L_:',0
	DB	'JNC	@',1
	DB	'JNE	@',0
	DB	4,'JE	L_',8DH,8AH,9				;
	DB	'JMP	@',8DH,8AH,'L_:',0
	DB	'JNE	@',1
	DB	'JNZ	@',0
	DB	4,'JZ	L_',8DH,8AH,9				;
	DB	'JMP	@',8DH,8AH,'L_:',0
	DB	'JNZ	@',1
	DB	'JP	@',0
	DB	4,'JS	L_',8DH,8AH,9				;
	DB	'JMP	@',8DH,8AH,'L_:',0
	DB	'JNS	@',1
	DB	'JPE	@',0
	DB	4,'JNP	L_',8DH,8AH,9				;
	DB	'JMP	@',8DH,8AH,'L_:',0
	DB	'JP	@',1
	DB	'JPO	@',0
	DB	4,'JP	L_',8DH,8AH,9				;
	DB	'JMP	@',8DH,8AH,'L_:',0
	DB	'JNP	@',1
	DB	'JZ	@',0
	DB	4,'JNZ	L_',8DH,8AH,9				;
	DB	'JMP	@',8DH,8AH,'L_:',0
	DB	'JZ	@',1
	DB	'LDA	@',0
	DB	'MOV	AL,BYTE PTR @',1
	DB	'LDAX	B',0
	DB	'MOV	SI,CX',8DH,8AH,9
	DB	'MOV	AL,[SI]',1
	DB	'LDAX	D',0
	DB	'MOV	SI,DX',8DH,8AH,9
	DB	'MOV	AL,[SI]',1
	DB	'LHLD	@',0
	DB	'MOV	BX,WORD PTR @',1
	DB	'LXI	B,@',0
	DB	'MOV	CX,OFFSET (@)',1
	DB	'LXI	D,@',0
	DB	'MOV	DX,OFFSET (@)',1
	DB	'LXI	H,@',0
	DB	'MOV	BX,OFFSET (@)',1
	DB	'LXI	SP,@',0
	DB	'MOV	SP,OFFSET (@)',1
	DB	'MOV	A,A',0
	DB	'MOV	AL,AL',1
	DB	'MOV	A,B',0
	DB	'MOV	AL,CH',1
	DB	'MOV	A,C',0
	DB	'MOV	AL,CL',1
	DB	'MOV	A,D',0
	DB	'MOV	AL,DH',1
	DB	'MOV	A,E',0
	DB	'MOV	AL,DL',1
	DB	'MOV	A,H',0
	DB	'MOV	AL,BH',1
	DB	'MOV	A,L',0
	DB	'MOV	AL,BL',1
	DB	'MOV	A,M',0
	DB	'MOV	AL,M',1
	DB	'MOV	B,A',0
	DB	'MOV	CH,AL',1
	DB	'MOV	B,B',0
	DB	'MOV	CH,CH',1
	DB	'MOV	B,C',0
	DB	'MOV	CH,CL',1
	DB	'MOV	B,D',0
	DB	'MOV	CH,DH',1
	DB	'MOV	B,E',0
	DB	'MOV	CH,DL',1
	DB	'MOV	B,H',0
	DB	'MOV	CH,BH',1
	DB	'MOV	B,L',0
	DB	'MOV	CH,BL',1
	DB	'MOV	B,M',0
	DB	'MOV	CH,M',1
	DB	'MOV	C,A',0
	DB	'MOV	CL,AL',1
	DB	'MOV	C,B',0
	DB	'MOV	CL,CH',1
	DB	'MOV	C,C',0
	DB	'MOV	CL,CL',1
	DB	'MOV	C,D',0
	DB	'MOV	CL,DH',1
	DB	'MOV	C,E',0
	DB	'MOV	CL,DL',1
	DB	'MOV	C,H',0
	DB	'MOV	CL,BH',1
	DB	'MOV	C,L',0
	DB	'MOV	CL,BL',1
	DB	'MOV	C,M',0
	DB	'MOV	CL,M',1
	DB	'MOV	D,A',0
	DB	'MOV	DH,AL',1
	DB	'MOV	D,B',0
	DB	'MOV	DH,CH',1
	DB	'MOV	D,C',0
	DB	'MOV	DH,CL',1
	DB	'MOV	D,D',0
	DB	'MOV	DH,DH',1
	DB	'MOV	D,E',0
	DB	'MOV	DH,DL',1
	DB	'MOV	D,H',0
	DB	'MOV	DH,BH',1
	DB	'MOV	D,L',0
	DB	'MOV	DH,BL',1
	DB	'MOV	D,M',0
	DB	'MOV	DH,M',1
	DB	'MOV	E,A',0
	DB	'MOV	DL,AL',1
	DB	'MOV	E,B',0
	DB	'MOV	DL,CH',1
	DB	'MOV	E,C',0
	DB	'MOV	DL,CL',1
	DB	'MOV	E,D',0
	DB	'MOV	DL,DH',1
	DB	'MOV	E,E',0
	DB	'MOV	DL,DL',1
	DB	'MOV	E,H',0
	DB	'MOV	DL,BH',1
	DB	'MOV	E,L',0
	DB	'MOV	DL,BL',1
	DB	'MOV	E,M',0
	DB	'MOV	DL,M',1
	DB	'MOV	H,A',0
	DB	'MOV	BH,AL',1
	DB	'MOV	H,B',0
	DB	'MOV	BH,CH',1
	DB	'MOV	H,C',0
	DB	'MOV	BH,CL',1
	DB	'MOV	H,D',0
	DB	'MOV	BH,DH',1
	DB	'MOV	H,E',0
	DB	'MOV	BH,DL',1
	DB	'MOV	H,H',0
	DB	'MOV	BH,BH',1
	DB	'MOV	H,L',0
	DB	'MOV	BH,BL',1
	DB	'MOV	H,M',0
	DB	'MOV	BH,M',1
	DB	'MOV	L,A',0
	DB	'MOV	BL,AL',1
	DB	'MOV	L,B',0
	DB	'MOV	BL,CH',1
	DB	'MOV	L,C',0
	DB	'MOV	BL,CL',1
	DB	'MOV	L,D',0
	DB	'MOV	BL,DH',1
	DB	'MOV	L,E',0
	DB	'MOV	BL,DL',1
	DB	'MOV	L,H',0
	DB	'MOV	BL,BH',1
	DB	'MOV	L,L',0
	DB	'MOV	BL,BL',1
	DB	'MOV	L,M',0
	DB	'MOV	BL,M',1
	DB	'MOV	M,A',0
	DB	'MOV	M,AL',1
	DB	'MOV	M,B',0
	DB	'MOV	M,CH',1
	DB	'MOV	M,C',0
	DB	'MOV	M,CL',1
	DB	'MOV	M,D',0
	DB	'MOV	M,DH',1
	DB	'MOV	M,E',0
	DB	'MOV	M,DL',1
	DB	'MOV	M,H',0
	DB	'MOV	M,BH',1
	DB	'MOV	M,L',0
	DB	'MOV	M,BL',1
	DB	'MVI	A,@',0
	DB	'MOV	AL,@',1
	DB	'MVI	B,@',0
	DB	'MOV	CH,@',1
	DB	'MVI	C,@',0
	DB	'MOV	CL,@',1
	DB	'MVI	D,@',0
	DB	'MOV	DH,@',1
	DB	'MVI	E,@',0
	DB	'MOV	DL,@',1
	DB	'MVI	H,@',0
	DB	'MOV	BH,@',1
	DB	'MVI	L,@',0
	DB	'MOV	BL,@',1
	DB	'MVI	M,@',0
	DB	'MOV	M,@',1
	DB	'NOP',0
	DB	'NOP',1
	DB	'ORA	A',0
	DB	'OR	AL,AL',1
	DB	'ORA	B',0
	DB	'OR	AL,CH',1
	DB	'ORA	C',0
	DB	'OR	AL,CL',1
	DB	'ORA	D',0
	DB	'OR	AL,DH',1
	DB	'ORA	E',0
	DB	'OR	AL,DL',1
	DB	'ORA	H',0
	DB	'OR	AL,BH',1
	DB	'ORA	L',0
	DB	'OR	AL,BL',1
	DB	'ORA	M',0
	DB	'OR	AL,M',1
	DB	'ORG	@',0
	DB	5,8DH,8AH,'CODE	SEGMENT',8DH,8AH,9		;
	DB	'ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE'
	DB	8DH,8AH,9,'ORG	5',8DH,8AH
	DB	'MDOS	LABEL	NEAR'
	DB	8DH,8AH,9,'ORG	@',0
	DB	'ORG	@',1
	DB	'ORI	@',0
	DB	'OR	AL,@',1
	DB	'OUT	@',0
	DB	'OUT	@,AL',1
	DB	'PCHL',0
	DB	'JMP	BX',1
	DB	'POP	B',0
	DB	'POP	CX',1
	DB	'POP	D',0
	DB	'POP	DX',1
	DB	'POP	H',0
	DB	'POP	BX',1
	DB	'POP	PSW',0
	DB	6,'POP	AX',8DH,8AH,9,'XCHG	AL,AH'		;
	DB	8DH,8AH,9,'SAHF',0
	DB	'POP	AX',0
	DB	'POPF',1
	DB	'PUSH	B',0
	DB	'PUSH	CX',1
	DB	'PUSH	D',0
	DB	'PUSH	DX',1
	DB	'PUSH	H',0
	DB	'PUSH	BX',1
	DB	'PUSH	PSW',0
	DB	6,'LAHF',8DH,8AH,9,'XCHG	AL,AH',8DH,8AH,9	;
	DB	'PUSH	AX',8DH,8AH,9,'XCHG	AL,AH',0
	DB	'PUSH	AX',0
	DB	'PUSHF',1
	DB	'RAL',0
	DB	'RCL	AL,1',1
	DB	'RAR',0
	DB	'RCR	AL,1',1
	DB	'RC',0
	DB	'JNC	L_',8DH,8AH,9,'RET',8DH,8AH
	DB	'L_:',1
	DB	'RET',0
	DB	'RET',1
	DB	'RLC',0
	DB	'ROL	AL,1',1
	DB	'RM',0
	DB	'JNS	L_',8DH,8AH,9,'RET',8DH,8AH
	DB	'L_:',1
	DB	'RNC',0
	DB	'JC	L_',8DH,8AH,9,'RET',8DH,8AH
	DB	'L_:',1
	DB	'RNZ',0
	DB	'JZ	L_',8DH,8AH,9,'RET',8DH,8AH
	DB	'L_:',1
	DB	'RP',0
	DB	'JS	L_',8DH,8AH,9,'RET',8DH,8AH
	DB	'L_:',1
	DB	'RPE',0
	DB	'JNP	L_',8DH,8AH,9,'RET',8DH,8AH
	DB	'L_:',1
	DB	'RPO',0
	DB	'JP	L_',8DH,8AH,9,'RET',8DH,8AH
	DB	'L_:',1
	DB	'RRC',0
	DB	'ROR	AL,1',1
	DB	'RST	0',0
	DB	'INT	0',1
	DB	'RST	1',0
	DB	'INT	1',1
	DB	'RST	2',0
	DB	'INT	2',1
	DB	'RST	3',0
	DB	'INT	3',1
	DB	'RST	4',0
	DB	'INT	4',1
	DB	'RST	5',0
	DB	'INT	5',1
	DB	'RST	6',0
	DB	'INT	6',1
	DB	'RST	7',0
	DB	'INT	7',1
	DB	'RZ',0
	DB	'JNZ	L_',8DH,8AH,9,'RET',8DH,8AH
	DB	'L_:',1
	DB	'SBB	A',0
	DB	'SBB	AL,AL',1
	DB	'SBB	B',0
	DB	'SBB	AL,CH',1
	DB	'SBB	C',0
	DB	'SBB	AL,CL',1
	DB	'SBB	D',0
	DB	'SBB	AL,DH',1
	DB	'SBB	E',0
	DB	'SBB	AL,DL',1
	DB	'SBB	H',0
	DB	'SBB	AL,BH',1
	DB	'SBB	L',0
	DB	'SBB	AL,BL',1
	DB	'SBB	M',0
	DB	'SBB	AL,M',1
	DB	'SBI	@',0
	DB	'SBB	AL,@',1
	DB	'SET	@',0
	DB	'='+80H,'	@',1
	DB	'SHLD	@',0
	DB	'MOV	WORD PTR @,BX',1
	DB	'SPHL',0
	DB	'MOV	SP,BX',1
	DB	'STA	@',0
	DB	'MOV	BYTE PTR @,AL',1
	DB	'STAX	B',0
	DB	'MOV	SI,CX',8DH,8AH,9
	DB	'MOV	[SI],AL',1
	DB	'STAX	D',0
	DB	'MOV	SI,DX',8DH,8AH,9
	DB	'MOV	[SI],AL',1
	DB	'STC',0
	DB	'STC',1
	DB	'SUB	A',0
	DB	'SUB	AL,AL',1
	DB	'SUB	B',0
	DB	'SUB	AL,CH',1
	DB	'SUB	C',0
	DB	'SUB	AL,CL',1
	DB	'SUB	D',0
	DB	'SUB	AL,DH',1
	DB	'SUB	E',0
	DB	'SUB	AL,DL',1
	DB	'SUB	H',0
	DB	'SUB	AL,BH',1
	DB	'SUB	L',0
	DB	'SUB	AL,BL',1
	DB	'SUB	M',0
	DB	'SUB	AL,M',1
	DB	'SUI	@',0
	DB	'SUB	AL,@',1
	DB	'XCHG',0
	DB	'XCHG	BX,DX',1
	DB	'XRA	A',0
	DB	'XOR	AL,AL',1
	DB	'XRA	B',0
	DB	'XOR	AL,CH',1
	DB	'XRA	C',0
	DB	'XOR	AL,CL',1
	DB	'XRA	D',0
	DB	'XOR	AL,DH',1
	DB	'XRA	E',0
	DB	'XOR	AL,DL',1
	DB	'XRA	H',0
	DB	'XOR	AL,BH',1
	DB	'XRA	L',0
	DB	'XOR	AL,BL',1
	DB	'XRA	M',0
	DB	'XOR	AL,M',1
	DB	'XRI	@',0
	DB	'XOR	AL,@',1
	DB	'XTHL',0
	DB	'MOV	BP,SP',8DH,8AH,9
	DB	'XCHG	BX,[BP]',1
OPEND	LABEL	BYTE			;END OF OPCODE TABLES

;	TABLE OF CODES WITH REGISTER ONLY ARGUMENTS

REGTBL	DB	'ADC',9,1
	DB	'ADD',9,1
	DB	'ANA',9,1
	DB	'CMP',9,1
	DB	'DAD',9,1
	DB	'DCR',9,1
	DB	'DCX',9,1
	DB	'INR',9,1
	DB	'INX',9,1
	DB	'LDAX',1
	DB	'MOV',9,1
	DB	'ORA',9,1
	DB	'POP',9,1
	DB	'PUSH',1
	DB	'RST',9,1
	DB	'SBB',9,1
	DB	'STAX',1
	DB	'SUB',9,1
	DB	'XRA',9,1
	DB	0
REGEND	LABEL	BYTE

;	TABLE OF CODES WITH REGISTER AND IMMEDIATE ARGUMENTS

RITBL	DB	'LXI',9,1
	DB	'MVI',9,1
	DB	0
RIEND	LABEL	BYTE

;	"BDOS" STRING

BDOS	DB	'BDOS',0,1
	DB	'bdos',0,1
;
;	CHOICE PROMPTS
;
CHTBL	DW	Offset DADMSG
	DW	Offset DCXMSG
	DW	Offset JMPMSG
	DW	Offset ORGMSG
	DW	Offset POPMSG

DADMSG	DB	2,13,10,'(1) Affect carry only.  '
	DB	'(2) Affect all flags','.'+80H
DCXMSG	DB	4,13,10,'(1) Save and restore flags.  '
	DB	'(2) Save flags.',13,10
	DB	'(3) Restore flags.  (4) INC or DEC only','.'+80H
JMPMSG	DB	2,13,10,'(1) Long jump.  '
	DB	'(2) Short jump','.'+80H
ORGMSG	DB	2,13,10,'(1) Program origin.  '
	DB	'(2) Other origin','.'+80H
POPMSG	DB	3,13,10,'(1) Accumulator and flags.  '
	DB	'(2) Accumulator only.  (3) Flags only','.'+80H
CHMSG	DB	13,10,7,'Your choice: ',' '+80H
;
;	DATA AREA
;
ICFLG	DB	0			;INTERACTIVE FLAG
INPOS	DW	0			;INPUT POSITION
RDPTR	DW	(Offset BA.RDBUF)	;READ POINTER
WRPTR	DW	(Offset BA.WRBUF)	;WRITE POINTER
LINES	DW	0			;LINES INPUT
XLINES	DW	0			;LINES TRANSLATED
PLINES	DW	0			;LINES PASSED
ELINES	DW	0			;LINES UNTRANSLATED
LABNO	DW	0			;GENERATED LABEL NUMBER
LABFLG	DB	0			;LABEL NO. CONTROL FLAG
DECFLG	DB	0			;DECIMAL OUTPUT CONTROL FLAG
MUCFLG	DB	0			;UPPER CASE MAPPING FLAG
CURPOS	DB	0			;CURSOR POSITION
COLADR	DW	0			;COLON ADDRESS
DEFLIN	DB	'M	EQU	BYTE PTR 0[BX]',0
	DB	8 DUP (0)
OUTFCB	DB	0,'        ASM'
	DB	24 DUP (0)
BA	LABEL	BYTE			;BUFFER AREA
BUFF	STRUC
INLIN	DB	134 DUP (?)		;INPUT LINE
OUTLIN	DB	180H DUP (?)		;OUTPUT LINE (MAY BE QUITE LARGE)
OPCODE	DB	80 DUP (?)		;OPCODE MATCH STRING
COMM	DB	80 DUP (?)		;SAVED COMMENT
ARG	DB	80 DUP (?)		;SAVED ARGUMENT
WRBUF	DB	128 DUP (?)		;WRITE BUFFER
WRBUFE	DB	?			;WRITE BUFFER END
RDBUF	DB	1024 DUP (?)		;READ BUFFER STARTS HERE
RDBUFE	DB	?			;SIZE OF READ BUFFER
BUFF	ENDS
CODE	ENDS
	END	START
                                                        