	TITLE 	COLOR Command
	PAGE	,132
;
;	COLOR Command
;
;	This command acts just like the BASIC COLOR command
;	except that it is accessible from MS-DOS.
;
;	For information on its use, enter the color command
;	with no parameters and an explaination will be displayed
;	on the CRT.
;
;	BY P. SWAYNE, HUG  26-SEP-84
;	BASED ON R. METZ'S Z-100 COLOR PROGRAM

COLOR	SEGMENT
	ASSUME	DS:COLOR,CS:COLOR,SS:COLOR,ES:COLOR
	ORG	80H
BFR:
	ORG	100H
START:
	JMP	BEGIN
;
FGR	DB	'7'			;Default foreground color=white
BGR	DB	'0'			;Default background color=black
;
CR	EQU	0DH
LF	EQU	0AH
;
MENU	DB	CR,LF
	DB	'This command acts just like the BASIC "COLOR"'
	DB	CR,LF
	DB	'command.  It is invoked by: "COLOR fgr[,bgr]"'
	DB	CR,LF
	DB	'Where fgr and bgr are color specifications for'
	DB	CR,LF
	DB	'foreground and background colors respectively.'
	DB	CR,LF
	DB	'If bgr is ommitted, it defaults to 0.  Colors '
	DB	CR,LF
	DB	'are as follows:'
	DB	CR,LF,LF
	DB	'  0 - black      4 - red'
	DB	CR,LF
	DB	'  1 - blue       5 - magenta'
	DB	CR,LF
	DB	'  2 - green      6 - yellow'
	DB	CR,LF
	DB	'  3 - cyan       7 - white'
	DB	CR,LF,'$'
;
BEGIN:
	MOV	SI,OFFSET BFR
	MOV	CH,0
	MOV	CL,[SI]
	INC	SI
	CMP	CL,0			;Check for parameter entry
	JNE	DOCOLOR
	MOV	DX,OFFSET MENU		;Display instructions on no
	MOV	AH,9			; parameter entry
	INT	21H
	INT	20H
DOCOLOR:
	MOV	DI,OFFSET FGR
	CLD
GTLUP:
	CMP	DI,OFFSET MENU		;Done after 2 colors
	JZ	SET_COLOR
	LODSB				;GET A CHARACTER
	CMP	AL,'0'		
	JL	LUP			;Ignore chrs lt '0'
	CMP	AL,'7'
	JG	LUP			;Ignore chrs gt '7'
	AND	AL,0FH			;REMOVE ASCII
	STOSB				;SAVE ENTRY
LUP:
	LOOP	GTLUP
SET_COLOR:
	MOV	BH,BGR
	MOV	CL,4
	SHL	BH,CL			;BACKGROUND COLOR TO HI BITS
	OR	BH,FGR			;INSERT FOREGROUND COLOR
	MOV	AX,600H			;FUNC. 6, CLEAR SCREEN
	MOV	CX,0
	MOV	DX,24*256+79		;CX, DX = COORDINATES
	INT	10H			;CLEAR SCREEN, SET NEW COLORS
;
	INT	20H			;Return to MS-DOS
;
COLOR	ENDS
	END	START
                                                              