	PAGE	,132
	TITLE	ALPHABETICAL SORTER FOR ASCII FILES
;	STL	'   WILLIAM W. MOSS - 29 JULY, 1979'
;
; SORTS ASCII FILES ALPHABETICALLY USING SHELL-METZNER SORT ROUTINE
;
;	CP/M VERSION BY PATRICK SWAYNE  25-NOV-80  15-DEC-80
;
;	Z-DOS/MS-DOS VERSION BY P. SWAYNE  13-MAR-85
;
; CP/M BDOS ADDRESSES
;
INBUF 	EQU	80H			;DEFAULT DMA ADDRESS
;
; CP/M BDOS FUNCTIONS
;
CONIN 	EQU	1			;READ CONSOLE INTO A
CONOUT 	EQU	2			;WRITE CONSOLE FROM E
PRINTF 	EQU	9			;PRINT FUNCTION
OPEN 	EQU	15			;OPEN FILE
CLOSE 	EQU	16			;CLOSE FILE
FIND 	EQU	17			;FIND FILE IN DIRECTORY
DELETE 	EQU	19			;DELETE FILE
READ 	EQU	20			;READ FILE
WRITE 	EQU	21			;WRITE FILE
MAKE 	EQU	22			;MAKE FILE DIRECTORY ENTRY
;
; OTHER DEFFINITIONS
;
M	EQU	BYTE PTR 0[BX]
CR 	EQU	0DH			;CARRIAGE RETURN
LF 	EQU	0AH			;LINE FEED
;
; START HERE
;
	
CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	5
MDOS	LABEL	NEAR
	ORG	6
HIGHM	LABEL	NEAR
	ORG	5CH
FCB1	LABEL	NEAR
	ORG	6CH
FCB2	LABEL	NEAR
	ORG	100H

START:	MOV	SP,OFFSET (STAK)
	MOV	DX,OFFSET (HEADER)
	CALL	TYPTX			;PRINT SIGN-ON
	MOV	AL,BYTE PTR FCB1+1
	CMP	AL,' '			;CHECK IF INPUT FILE ENTERED
	JZ	TPINST			;PRINT INSTRUCTIONS IF NOT
	MOV	AL,BYTE PTR FCB2+1
	CMP	AL,' '			;CHECK IF OUTPUT FILE ENTERED
	JNZ	START0			;SKIP IF IT IS
TPINST:	MOV	DX,OFFSET (INST)
	CALL	TYPTX			;PRINT INSTRUCTIONS
	INT	20H			;EXIT
START0:	MOV	CL,16			;MOVE 2ND FILE NAME TO DFCB
	MOV	DX,OFFSET (FCB2)	;POINT TO FILE NAME
	MOV	BX,OFFSET (DFCB)	;WHERE TO MOVE IT
MFCB:	MOV	SI,DX
	MOV	AL,[SI]
	INC	DX
	MOV	M,AL
	INC	BX
	DEC	CL
	JNZ	MFCB
	XOR	AL,AL
	MOV	BYTE PTR DFCB+32,AL	;CLEAR CURRENT RECORD
	MOV	BYTE PTR FCB1+32,AL	;IN INPUT, TOO
;
; OPEN FILES
;
	MOV	DX,OFFSET (FCB1)
	MOV	CL,OPEN
	CALL	MDOS			;OPEN SOURCE FILE
	INC	AL			;GOOD OPENING?
	JNZ	OPENS
	MOV	DX,OFFSET (NOSORC)
	CALL	TYPTX			;PRINT "NO SOURCE FILE"
	INT	20H			;EXIT
OPENS:	MOV	DX,OFFSET (DFCB)
	MOV	CL,FIND
	CALL	MDOS			;LOOK FOR SOURCE FILE
	INC	AL			;DOES FILE ALREADY EXIST?
	JZ	OPENS0			;NO, CONTINUE
	MOV	DX,OFFSET (FEXIST)
	CALL	TYPTX			;PRINT "FILE ALREADY EXISTS"
	CALL	SCIN			;GET RESPONSE
	AND	AL,5FH			;CONVERT LOWER CASE TO UPPER
	CMP	AL,'Y'			;WANT TO DELETE?
	JZ	L_1			;EXIT
	INT	20H
L_1:
	MOV	DX,OFFSET (CRLF)
	CALL	TYPTX			;PRINT CRLF
	MOV	DX,OFFSET (DFCB)
	MOV	CL,DELETE
	CALL	MDOS			;DELETE THE FILE
OPENS0:	MOV	DX,OFFSET (DFCB)
	MOV	CL,MAKE
	CALL	MDOS			;OPEN SOURCE FILE
	INC	AL
	JNZ	OPEN0			;OPENING OK
	MOV	DX,OFFSET (NODIR)
	CALL	TYPTX
	INT	20H			;NO DIRECTORY SPACE, EXIT
OPEN0:	MOV	BX,OFFSET (INBUF+128)	;HL = LWA+1 OF FILE BUFFER
	MOV	WORD PTR BUFADD,BX	;FLAGS 'GETC' TO READ FIRST RECORD
;
; MAIN PROGRAM
;
PROGRM:	MOV	BX,OFFSET (STRTAB)
	MOV	DX,OFFSET (0)
NXTSTR:	PUSH	BX
	MOV	CL,0
	INC	BX
NXTCHR:	CALL	GETC
	JZ	POINT
	CMP	AL,CR
	JZ	EOS			;IF END OF STRING
	CALL	MEMCHK			;EXCEEDED UPPER RAM LIMIT?
	INC	CL			;COUNT CHARACTERS IN STRING
	JZ	TOOLNG			;IF > 255 CHARACTERS
	MOV	M,AL
	INC	BX
	JMP	SHORT NXTCHR
TOOLNG:	CALL	GETC			;SKIP TO
	CMP	AL,CR			;END
	JNZ	TOOLNG			;OF STRING
	DEC	CL			;C = 255
EOS:	OR	CL,CL
	JZ	NULSTR
	MOV	BP,SP			;GET ADDR OF STRING START-1
	XCHG	BX,[BP]
	MOV	M,CL			;INSERT SIZE OF STRING
	INC	DX			;DE = COUNT OF STRINGS IN TABLE
NULSTR:	POP	BX
	CALL	GETC			;GET LF FROM END OF LINE
	JMP	SHORT NXTSTR

; CONSTRUCT A POINTER TABLE FOR THE STRING DATA TABLE.
; STRUCTURE AS FOLLOWS:
;	BEGIN AT ('POINTA').
;	EACH TWO BYTE DATA ITEM IS THE ADDRESS OF THE START OF DATA
;	FOR EACH STRING IN THE STRING DATA TABLE.

POINT:	XCHG	BX,DX
	MOV	WORD PTR VARN,BX	;= NUMBER OF STRINGS TO SORT
	ADD	BX,BX			;BX = SPACE REQUIRED FOR POINTER TABLE
	POP	DX			;DX = END OF STRING TABLE
	ADD	BX,DX			;BX = END OF REQUIRED DATA SPACE
	CALL	MEMCHK
	XCHG	BX,DX
	MOV	M,0			;MARK END OF STRTAB WITH 0 
	INC	BX
	MOV	WORD PTR POINTA,BX
	MOV	DI,BX			;DI POINTS TO TABLE
	MOV	BX,OFFSET (STRTAB)
	XOR	CH,CH
	CLD
NXTLBL:	MOV	CL,M
	OR	CL,CL			;END OF STRTAB?
	JZ	SMSORT
	MOV	AX,BX
	STOSW				;STORE ADDRESS OF STRING
	INC	BX
	ADD	BX,CX			;POINT TO NEXT STRING
	JMP	SHORT NXTLBL

; SHELL-METZNER STRING SORTING ROUTINE
;	ENTRY:  'VARN' = NUMBER OF STRINGS TO BE SORTED
;		('POINTA') = START OF POINTER TABLE
;		   POINTER TABLE MADE UP OF A SERIES OF 16 BIT ADDRESSES
;		   POINTING TO THE POSITION IN THE DATA TABLE FOR EACH
;		   OF THE ITEMS TO BE SORTED.
;		DATA TABLE STRUCTURE:
;		   FIRST BYTE = LENGTH OF STRING
;		   FOLLOWING BYTES = STRING CHARACTERS
;		   BYTES BEYOND SPECIFIED LENGTH ARE IGNORED
;	EXIT:	POINTER TABLE REARRANGED TO POINT TO STRINGS IN ALPHABETICAL ORDER.
;		STRING DATA TABLE IS UNCHANGED.
;		'VARN' = NUMBER OF STRINGS SORTED. (UNCHANGED)
;		'VARM' = 0.

SMSORT:	MOV	BX,WORD PTR VARN
	CMP	BX,2			;2 OR MORE STRINGS?
	JNB	SORT1			;YES
	JMP	PRINT			;ELSE NO SORT NEEDED!
SORT1:	MOV	WORD PTR VARM,BX
SETM:	MOV	BX,WORD PTR VARM
	SHR	BX,1
	MOV	WORD PTR VARM,BX	;VARM = VARM / 2 
	CMP	BX,0
	JNZ	NOTEND	
	JMP	PRINT			;IF END OF SORT
NOTEND:	MOV	BX,1
	MOV	WORD PTR VARJ,BX	;VARJ = 1
	MOV	BX,WORD PTR VARN
	MOV	DX,WORD PTR VARM
	SUB	BX,DX
	MOV	WORD PTR VARK,BX	;VARK = SCOUNT - VARM
SETI:	MOV	BX,WORD PTR VARJ
	MOV	WORD PTR VARI,BX	;VARI = VARJ
SETL:	MOV	BX,WORD PTR VARI
	MOV	DX,WORD PTR VARM
	ADD	BX,DX
	MOV	WORD PTR VARL,BX	;VARL = VARI + VARM
	CALL	SYMVAL			;BX = START OF DATA POINTED BY VARL
	PUSH	BX
	MOV	BX,WORD PTR VARI
	CALL	SYMVAL
	POP	SI
	MOV	AL,[SI]			;AL = COUNT FOR STRING (VARL)
	MOV	CL,M			;CL = COUNT FOR STRING (VARI)
	CMP	AL,CL			;CY SET IF LEN(VARI) > LEN(VARL)
	PUSHF				;SAVE CY
	JNC	COMP
	MOV	CL,AL			;USE LENGTH OF SHORTER STRING
COMP:	XOR	CH,CH			;CX = STRING LENGTH
	MOV	DI,BX			;SI AND DI POINT TO START OF STRINGS
	INC	SI
	INC	DI			;POINT TO START OF STRINGS
	REPZ	CMPSB			;COMPARE THE STRINGS
	JNZ	NOMACH			;NO MATCH
	POPF				;STRINGS MATCH, ARRANGE BY LENGTH
	JMP	SHORT NOMACH1
NOMACH:	POP	BX			;DISCARD FLAGS
NOMACH1:JNB	SETJ			;IF NO REARRANGEMENT REQUIRED

; SWITCH THE POINTER ADDRESS AT (VARI) WITH THAT AT (VARL)

	MOV	BX,WORD PTR VARI
	CALL	TABADD
	PUSH	BX			;STACK = POINTER DATA FOR (VARI)
	MOV	BX,WORD PTR VARL
	CALL	TABADD			;BX = POINTER DATA FOR (VARL)
	POP	SI
	MOV	AX,[SI]
	MOV	DX,[BX]
	MOV	[SI],DX
	MOV	[BX],AX

; SWITCH COMPLETED

	MOV	BX,WORD PTR VARI
	MOV	DX,WORD PTR VARM
	SUB	BX,DX
	MOV	WORD PTR VARI,BX	;VARI = VARI - VARM
	DEC	BX
	JS	SETJ	
	JMP	SETL			;IF VARI >= 1
SETJ:	MOV	BX,WORD PTR VARJ
	INC	BX
	MOV	WORD PTR VARJ,BX	;VARJ = VARJ + 1
	MOV	DX,WORD PTR VARK
	SUB	DX,BX
	JNB	SETJ0	
	JMP	SETM			;IF VARJ > VARK
SETJ0:	JMP	SETI

; TABADD -- FIND LOCATION OF DATA POINTER IN TABLE
;	ENTRY: BX = INTEGER VALUE ( 1 -> N )
;	EXIT:  BX = ADDR OF TWO BYTE DATA POINTER ( FOR INPUT VALUE )

TABADD:	DEC	BX			;START AT ZERO
	SHL	BX,1			;BX = [(ORIGINAL BX) - 1] * 2
	MOV	DX,WORD PTR POINTA
	ADD	BX,DX
	RET

; SYMVAL -- FIND DATA RELATED TO INPUT INTEGER VALUE IN ARRAY
;	ENTRY: BX = INTEGER VALUE ( 1 -> N ) POINTING TO DATA ARRAY
;	EXIT:  BX = FWA STRING DATA FOR THAT VALUE

SYMVAL:	CALL	TABADD
	MOV	BX,[BX]
	RET

; SORTING COMPLETED - WRITE OUT RESULT

PRINT:	MOV	BX,WORD PTR VARN
	CALL	DECOUT			;PRINT NUMBER OF STRINGS SORTED
	MOV	DX,OFFSET (MSGF)
	CALL	TYPTX
	MOV	BX,OFFSET (INBUF)
	MOV	WORD PTR BUFADD,BX
PR1:	MOV	DX,WORD PTR VARN	;DX = NUMBER OF STRINGS SORTED
	MOV	BX,WORD PTR VARM	;VARM = 0 ON EXIT FROM SMSORT
	INC	BX
	MOV	WORD PTR VARM,BX	;CURRENT POINTER ARRAY POSITION
	SUB	DX,BX
	JC	OUTDON			;IF ALL STRINGS HAVE BEEN WRITTEN
	CALL	SYMVAL
	MOV	CL,M
PR2:	INC	BX
	MOV	AL,M
	CALL	WRITEC
	DEC	CL
	JNZ	PR2
	MOV	AL,CR
	CALL	WRITEC
	MOV	AL,LF			;LINE FEED
	CALL	WRITEC
	JMP	SHORT PR1
OUTDON:	MOV	AL,1AH
	CALL	WRITEC			;WRITE END OF FILE
OUTDO0:	CMP	WORD PTR BUFADD,OFFSET (INBUF)
	JZ	QUIT
	MOV	AL,1AH			;FILL WITH EOF'S
	CALL	WRITEC
	JMP	SHORT OUTDO0
QUIT:	MOV	DX,OFFSET (DFCB)
	MOV	CL,CLOSE
	CALL	MDOS			;CLOSE OUTPUT FILE
	INC	AL			;ALL OK?
	JZ	QUITW
	INT	20H
QUITW:	MOV	DX,OFFSET (WPRO)
	CALL	TYPTX			;PRINT "CHECK WRITE PROTECT"
	INT	20H

;	SUBROUTINES

;	CONSOLE I/O THROUGH BDOS

SCIN:	PUSH	BX			;SINGLE CHARACTER INPUT
	PUSH	DX
	PUSH	CX
	MOV	CL,CONIN
	CALL	MDOS
	POP	CX
	POP	DX
	POP	BX
	RET

TYPTX:	PUSH	BX			;TYPE TEXT AT (DE)
	PUSH	CX
	MOV	CL,PRINTF
	CALL	MDOS
	POP	CX
	POP	BX
	RET
;
; FILE I/O ROUTINES
;
GETC:	PUSH	BX
	MOV	BX,WORD PTR BUFADD
	CMP	BX,OFFSET (INBUF+128)	;FILE BUFFER EMPTY?
	JNZ	GETC1			;IF YES
	CALL	NEWREC
GETC1:	MOV	AL,M
	CMP	AL,1AH			;END OF FILE MARKER
	JZ	GEXIT			;FIRST ^Z BYTE MARKS EOF
	INC	BX
	MOV	WORD PTR BUFADD,BX
GEXIT:	POP	BX
	RET
NEWREC:	PUSH	CX
	PUSH	DX
	MOV	DX,OFFSET (FCB1)
	MOV	CL,READ
	CALL	MDOS			;READ ONE RECORD
	POP	DX
	POP	CX
	MOV	BX,OFFSET (INBUF)	;ASSUME NORMAL READ
	CMP	AL,1			;END OF FILE?
	JNZ	NOEND
	MOV	BX,OFFSET (DEOF)	;POINT TO DUMMY EOF
NOEND:	RET

WRITEC:	PUSH	BX
	MOV	BX,WORD PTR BUFADD
	MOV	M,AL
	INC	BX
	CMP	BX,OFFSET (INBUF+128)
	JNZ	WRITC1
	CALL	NEWRIT
WRITC1:	MOV	WORD PTR BUFADD,BX
	POP	BX
	RET
NEWRIT:	PUSH	DX
	PUSH	CX
	MOV	DX,OFFSET (DFCB)
	MOV	CL,WRITE
	CALL	MDOS			;WRITE ONE RECORD
	OR	AL,AL			;WRITE OK?
	JZ	WEXIT
	MOV	DX,OFFSET (OUTSP)
	CALL	TYPTX			;PRINT "OUT OF DISK SPACE"
	INT	20H
WEXIT:	POP	CX
	POP	DX
	MOV	BX,OFFSET (INBUF)
	RET

; CHECK FOR EXCEEDING LIMIT OF USER RAM
;	ENTRY:	HL = ADDRESS TO BE CHECKED
;	EXIT:	RETURNS TO PROGRAM IF IN BOUNDS.
;		ABORTS IF OUT OF BOUNDS.
;	USES:	F

MEMCHK:	CMP	BX,WORD PTR HIGHM	;COMPARE BX WITH HIGH MEMORY
	JNC	L_5			;WE ARE LOWER
	RET
L_5:	MOV	DX,OFFSET (MSGE)
	CALL	TYPTX
	INT	20H

;	DECOUT - PRINT BX IN DECIMAL
;	THIS IS A TRICKY ROUTINE THAT MAKES USE OF THE
;	STACK TO STORE DECODED DIGITS.

DECOUT:	PUSH	CX
	PUSH	DX
	PUSH	BX			;SAVE REGISTERS
	MOV	CX,10			;RADIX FOR CONVERSION
	MOV	DX,0
	MOV	AX,BX
	DIV	CX			;DIVIDE BY 10
	MOV	BX,AX			;ANSWER TO BX (DX [REMAINDER] = DIGIT)
	CMP	BX,0			;DONE?
	JZ	DEC1	
	CALL	DECOUT			;CALL RECURSIVELY UNTIL DONE
DEC1:	ADD	DL,'0'			;ADD ASCII BIAS
	MOV	CL,CONOUT
	CALL	MDOS			;PRINT IT
	POP	BX			;RESTORE REGISTERS
	POP	DX
	POP	CX
	RET

; DATA SPACE:

HEADER	DB	CR,LF
	DB	'HUG Shell-Metzner Sort Program, V 1.0',CR,LF,LF,'$'
INST	DB	'To use this program, enter',CR,LF,LF
	DB	'  HSORT d:SRCEFILE.EXT d:DESTFILE.EXT',CR,LF,LF
	DB	'where SRCEFILE is the file to be sorted',CR,LF
	DB	'DESTFILE is the output file name, and d:',CR,LF
	DB	'is a drive designation, if necessary.',CR,LF,'$'
NOSORC	DB	'ERROR - File not found.',CR,LF,'$'
FEXIST	DB	'Output file already exists.  '
	DB	'Want to delete it? (Y or N) $'
NODIR	DB	'ERROR - No directory space.',CR,LF,'$'
OUTSP	DB	'ERROR - No disk space.',CR,LF,'$'
WPRO	DB	'ERROR - Unable to close output file.  '
	DB	'Check write protect.',CR,LF,'$'
MSGE	DB	7,'ERROR - Not enough memory.',CR,LF,'$'
MSGF	DB	' Strings sorted.  '
	DB	'Writing result to file.',CR,LF,'$'
CRLF	DB	CR,LF,'$'
	DB	256 DUP (?)
STAK 	EQU	$
DFCB	DB	33 DUP (0)		;DESTINATION FILE NAME
DEOF	DB	1AH			;DUMMY END OF FILE
BUFADD	DB	2 DUP (?)		;FILE BUFFER POINTER
POINTA	DW	0			;POINTER TABLE ADDRESS
VARI	DW	0			;SORT VARIABLES
VARJ	DW	0
VARK	DW	0
VARL	DW	0
VARM	DW	0
VARN	DW	0
STRTAB 	EQU	$			;MUST BE LAST LABEL IN LIST
	
CODE	ENDS
	END	START
                                       