;
;	Macro Definitions
;
.xlist
;
;	program beginning
;
prog_header	macro	p_name
p_name	segment byte public
	assume	cs:p_name,ds:p_name,ss:p_name,es:p_name
	org	2ch
env_seg	label	word
	org	5ch
fcb1	label	byte
	org	6ch
fcb2	label	byte
	org	80h
buf	label	byte
	org	100h
start:
		endm
;
;	sub-program header
;
sub_header	macro	p_name
p_name	segment byte public
	assume	cs:p_name,ds:p_name,ss:p_name,es:p_name
		endm
;
;	program terminate 
;
sys_term	macro	rtn_code
	mov	al,rtn_code	
	mov	ah,4ch
	int	21h		
		endm
;
;	system call
;
svc		macro	code
	mov	ah,code
	int	21h
		endm
;
;	Z-100 screen address
;
addr		macro	row,col
	db	1bh,'Y'	
	db	' '+row-1
	db	' '+col-1
		endm
;
;	read keyboard and echo
;
read_kbd_echo	macro
	mov	ah,1
	int	21h
		endm
;
;	display character on crt
;
display_chr	macro	char
	mov	dl,char
	mov	ah,2
	int	21h
		endm
;
;	Aux input
;
aux_in		macro
	mov	ah,3
	int	21h
		endm
;
;	aux output
;
aux_out		macro	char
	mov	dl,char
	mov	ah,4
	int	21h
		endm
;
;	print character
;
print_char	macro	char
	mov	dl,char
	mov	ah,5
	int	21h
		endm 
;
;	direct console i/o
;
dir_console	macro	switch
	mov	dl,switch
	mov	al,6
	int	21h
		endm
;
;	direct console input
;
dir_console_in	macro
	mov	ah,7
	int	21h
		endm
;
;	read keyboard
;
read_kbd	macro
	mov	ah,8
	int	21h
		endm
;
;	display string
;
display		macro	string
	mov	dx,offset string
	mov	ah,9
	int	21h
		endm
;
;	read buffered keyboard input
;
get_string	macro	limit,string
	mov	dx,offset string
	mov	byte ptr string,limit
	mov	ah,0ah
	int	21h
		endm
;
;	check keyboard status
;
check_kbd	macro
	mov	ah,0bh
	int	21h
		endm
;
;	select disk
;
select_disk	macro	disk
	mov	dl,disk
	mov	ah,0eh
	int	21h
		endm
;
;	open file
;
open		macro	fcb
	mov	dx,offset fcb
	mov	ah,0fh
	int	21h	
		endm
;
;	close file
;
close		macro	fcb
	mov	dx,offset fcb
	mov	ah,10h
	int	21h
		endm
;
;	search for first
;
search_first	macro	fcb
	mov	dx,offset fcb
	mov	ah,11h
	int	21h
		endm
;
;	search for next entry
;
search_next	macro	fcb
	mov	dx,offset fcb
	mov	ah,12h
	int	21h
		endm
;
;	delete file
;
delete		macro 	fcb
	mov	dx,offset fcb
	mov	ah,13h
	int	21h
		endm
;
;	sequential file read
;
read_seq	macro	fcb
	mov	dx,offset fcb
	mov	ah,14h
	int	21h
		endm
;
;	sequential file write
;
write_seq	macro	fcb
	mov	dx,offset fcb
	mov	ah,15h
	int	21h
		endm
;
;	create a file
;
create		macro	fcb
	mov	dx,offset fcb
	mov	ah,16h
	int	21h
		endm
;
;	rename a file
;
rename		macro	fcb
	mov	dx,offset fcb
	mov	ah,17h
	int	21h
		endm
;
;	get current disk
;
current_disk	macro
	mov	ah,19h
	int	21h
		endm
;
;	set disk transfer address
;
set_dta		macro	buffer
	mov	dx,offset buffer
	mov	ah,1ah
	int	21h
		endm
;
;	random file read
;
read_ran	macro	fcb
	mov	dx,offset fcb
	mov	ah,21h
	int	21h
		endm
;
;	rendom file write
;
write_ran	macro	fcb
	mov	dx,offset fcb
	mov	ah,22h
	int	21h
		endm
;
;	get file size
;
file_size	macro	fcb
	mov	dx,offset fcb
	mov	ah,23h
	int	21h
		endm
;
;	set relative record number
;
set_relrec	macro	fcb
	mov	dx,offset fcb
	mov	ah,24h
	int	21h
		endm
;
;	set interrupt vector
;
set_vect	macro	int,seg_addr,offset_addr
	push	ds
	mov	ax,seg_addr
	mov	ax,ds
	mov	dx,offset_addr
	mov	al,int
	mov	ah,25h
	int	21h
	pop	ds
		endm
;
;	random block read
;
read_block	macro	fcb,count,rec_size
	mov	dx,offset fcb
	mov	cx,count
	mov	word ptr fcb[14],rec_size
	mov	ah,27h
	int	21h
		endm
;
;	random block write
;
write_block	macro	fcb,count,rec_size
	mov	dx,offset fcb
	mov	cx,count
	mov	word ptr fcb[14],rec_size
	mov	ah,28h
	int	21h
		endm
;
;	parse file name
;
parse		macro	string,fcb,flags
    ifnb <string>
	mov	si,offset string
    endif
	mov	di,offset fcb
    ifnb <flags>
	mov	al,flags
    else
	mov	al,0
    endif
  	mov	ah,29h
	int	21h
		endm
;
;	get date
;
get_date	macro
	mov	ah,2ah
	int	21h
		endm
;
;	set date
;
set_date	macro	year,month,day
	mov	cx,year
	mov	dh,month
	mov	dl,day
	mov	ah,2bh
	int	21h
		endm
;
;	get time
;
get_time	macro
	mov	ah,2ch
	int	21h
		endm
;
;	set time
;
set_time	macro	hour,minute,second,hun
	mov	ch,hour
	mov	cl,minute
	mov	dh,second
	mov	cl,hun
	mov	ah,2dh
	int	21h
		endm
;	get disk transfer address
;
get_dta		macro
	mov	ah,2fh
	int	21h
		endm
;
;	get dos version
;
get_ver		macro
	mov	ah,30h
	int	21h
		endm
;
;	keep process
;
keep_process	macro	rtn_code
	mov	ah,31h
	mov	al,rtn_code
	int	21h
		endm
;
;	get interrupt vector
;
get_vect	macro	int
	mov	al,int
	mov	ah,35h
	int	21h
		endm
;
.list

		endm
;
;	set time
;
set_time	macro	hour,minute,second,hun
	mov	ch,hour
	mov	cl,minute
	mov	dh,second