/*	SEE	Version 2,	Revision 7				*/
/*									*/
/*	Compiled using C88 Version 1.2					*/
/*									*/
/*			    Program Description 			*/
/*									*/
/*	This program displays text on a Z-110 system, stopping whenever */
/*	a screen is filled.  Define statements (below) set the lengh	*/
/*	and width of the screen; cursor movement and screen clear is	*/
/*	handled in functions and a special function does a getcahr but	*/
/*	without echoing.						*/
/*									*/
/*	The program is patterned (loosely) after the Unix MORE command, */
/*	but it lacks most of the sophistications of the Unix version.	*/
/*									*/
/*	RETURN		next line.					*/
/*	SPACE		next screen.					*/
/*	r or R		rewind to start of file.			*/
/*	q or Q		quit.						*/
/*	S		skip a screen.					*/
/*	H or h		Help						*/
/*	N or n		Display file name				*/
/*	=		Display current line number			*/
/*	m		Mark the current screen 			*/
/*	g		Goto marked place or return from it		*/


#define TRUE	1
#define FALSE	0
#define FOREVER 1
#include <stdio.h>

#define LENGTH	22
#define WIDTH	80

/*	The following are definitions for the 9 legal functions:	*/

#define FUN_CR	1
#define FUN_SP	2
#define FUN_Q	3
#define FUN_S	4
#define FUN_H	5
#define FUN_N	6
#define FUN_EQ	7
#define FUN_M	8
#define FUN_G	9
#define FUN_R	10


main (argc, argv)
    int argc;
    int argv[];
{
    int fnc, i, j, k, count, lnum, skip, markwk, mark, marked, home, folds;
    FILE *ifc;
    char c, line[132];


    if (argc != 2)
    {
	puts (argv[0]);
	puts (" (Version 2 Rev 7 of 01/29/85):\n");
	puts ("Incorrect usage.\nUsage is:\n");
	puts (argv[0]);
	puts (" filename\n");
	exit (1);
    }
    fnc = FUN_R;
    skip = FALSE;
    marked = FALSE;
    while (FOREVER)	/*	R:	*/
    {
	lnum = 0;
	folds = 0;
	ifc = fopen (argv[1], "r");
	if (ifc == 0)
	{
	    puts (argv[0]);
	    puts (" unable to open ");
	    puts (argv[1]);
	    puts (" for read.\n");
	    exit(1);
	}
	count = LENGTH;
	while (FOREVER) /*	A:	*/
	{
	    folds = 0;
	    markwk = lnum;
	    while (FOREVER)	/*	AA:	*/
	    {
		j = 0;
		while (j < count)
		{
		    if (skip == FALSE) putchar('\n');
		    k = 1;
		    while ((c = getc(ifc)) != EOF)
		    {
			if (c == '\n')
			{
			    ++lnum;
			    break;
			}
			if (c == '\t') k = 8 * (k / 8) + 8;
			else if ((c >= ' ') & (c <= '~')) k++;
			if (c == '\014')
			{
			    if (skip == FALSE) puts ("^L\n");
			    ++lnum;
			    j = count;
			    break;
			}
			else if (skip == FALSE) putchar(c);
			if (k == (WIDTH - 1))	    /*	    Wrap line	    */
			{
			    c = getc(ifc);
			    if (c == EOF) break;
			    if (c == '\n')
			    {
				++j;
				++lnum;
				break;
			    }
			    else
			    {
				++folds;
				if (skip == FALSE) putchar (c);
				if (c == '\t') k = 8 * (k / 8) + 8;
				else if ((c >= ' ') & (c <= '~')) k++;
				if (j >= count) break;
			    }
			}
		    }
		    if (c == EOF) break;
		    ++j;
		}
		if (c != EOF)
		{
		    l25on();
		    curpos(25,1);
		    while (FOREVER)	/*	GG:	*/
		    {
			if (skip == FALSE)
			{
			    vidrev();
			    puts ("-- More --");
			    vidnorm();
			}
			fnc = 0;
			while (fnc == 0)	/*	G:	*/
			{
			    if (skip == FALSE) c = getnoec();
			    else
			    {
				skip = FALSE;
				c = ' ';    /*	    Force a screen display  */
			    }
			    if ((c == 'Q') | (c == 'q'))
			    {
				fclose (ifc);
				curpos (24,1);
				l25off();
				putchar ('\n');
				exit(0);
				break;
			    }
			    else if (c ==  'm')
			    {
				marked = TRUE;
				mark = markwk;
				fnc = 0;
			    }
			    else if (c == 'g')
			    {
				if (marked == FALSE)
				{
				    putchar ('\007');
				    fnc = 0;
				}
				else
				{
				    if (markwk == mark)
				    {
					i = skpfwd (ifc, lnum, home);
					j = home;
				    }
				    else
				    {
					home = markwk;
					i = skpfwd (ifc, lnum, mark);
					j = mark;
				    }
				    if (i < 0)
				    {
					fclose (ifc);
					ifc = fopen (argv[1], "r");
					lnum = 0;
					i = skpfwd (ifc, lnum, j);
					if (i < 0)
					{
					    l25off();
					    cls();
					 puts ("Can't find place.  Goodbye!\n");
					    fclose (ifc);
					    exit (1);
					}
				    }
				    lnum = j;
				    curpos (24,1);
				    l25off();
				    count = LENGTH;
				    cls();
				    putchar ('\n');
				    fnc = FUN_G;
				}
			    }
			    else if ((c == 'S') | (c == 's'))
			    {
				skip = TRUE;
				count = LENGTH;
				curpos (24,1);
				l25off();
				fnc = FUN_S;
			    }
			    else if (c == ' ')
			    {
				count = LENGTH;
				curpos (24,1);
				l25off();
				fnc = FUN_SP;
			    }
			    else if (c == '=')
			    {
				puts ("\t\t\t\t\t");
				itoa (lnum);
				putchar ('\r');
				fnc = FUN_EQ;
			    }
			    else if ((c == 'n') | (c == 'n'))
			    {
				puts ("\t\t\t");
				puts (argv[1]);
				putchar ('\r');
				fnc = FUN_N;
			    }
			    else if ((c == 'h') | (c == 'H'))
			    {
				l25off();
				cls();
			      puts ("SEE Version 2 Revision 7 of 01/29/85\n\n");
				puts ("\t\t\tCommands\n\n");
				puts ("RETURN\t\tDisplay one more line\n");
				puts ("SPACE\t\tDisplay one more screen\n");
				puts ("=\t\tDisplay current line number\n");
				puts ("H or h\t\tHelp -- print this list\n");
				puts ("N or n\t\tDisplay file name\n");
				puts ("Q or q\t\tQuit\n");
				puts ("R or r\t\tRewind to start of file\n");
				puts ("S\t\tSkip one screen\n");
			      puts ("g\t\tGoto or return from marked screen\n");
				puts ("m\t\tMark screen\n");
				l25on();
				curpos(25,1);
				fnc = FUN_H;
			    }
			    else if (c == '\n')
			    {
				count = 1;
				curpos (24,1);
				l25off();
				markwk = lnum - 22 + folds;
				fnc = FUN_CR;
			    }
			    else if ((c == 'R') | (c == 'r'))
			    {
				fclose (ifc);
				count = LENGTH;
				l25off();
				cls();
				putchar ('\n');
				fnc = FUN_R;
			    }
			    else
			    {
				putchar('\007');
				fnc = 0;
			    }

			}	/*	G	*/

		    if ((fnc == FUN_R) | (fnc == FUN_SP) | (fnc == FUN_G) |
			(fnc == FUN_S) | (fnc == FUN_CR) | (fnc == EOF)) break;

		    }		/*	GG	*/

		}
		else fnc = EOF;
		if ((fnc == FUN_R) | (fnc == FUN_SP) | (fnc == FUN_G) |
		    (fnc == FUN_S) | (fnc == EOF)) break;

	    }	/*	AA	*/

	    if ((fnc == EOF) | (fnc == FUN_R)) break;

	}	/*	A	*/

	if (fnc == EOF) break;

    }		/*	R	*/

    fclose (ifc);
    putchar ('\n');
    l25off();
    exit(0);
}


getnoec()
{
#asm
	MOV	AH,0CH		; Put the console into
	MOV	AL,08H		;   RAW character input
	INT	021H		;   mode.
	MOV	DL,AL		
	MOV	DH,0
	CMP	DX,0DH
	JNE	@_@A
	MOV	DX,0AH
@_@A:
#endasm
}


skpfwd (chan, curlin, tolin)
    int curlin, tolin;
    FILE *chan;
{


    if (curlin == tolin) return (0);
    if (curlin < tolin)
    {
	while (curlin != tolin) if (getc(chan) == '\n') curlin++;
	return(0);
    }
    else return (-1);	/* must rewind to get to desired line. */
}


cls()
{

/*	Home and Clear screen	*/

    puts ("\r\033H\033E");
    return;
}


l25off()
{

/*	Turn off 25-th line	*/

    puts ("\r\033y1");
    return;
}


l25on()
{

/*	Turn on line 25 	*/

    puts ("\r\033x1");
    return;
}


curpos (line, column)
    int line, column;
{

/*	Position cursor to line and column	*/

    puts ("\r\033Y");
    putchar ((line - 1 + ' '));
    putchar ((column - 1 + ' '));
    return;
}


vidrev()
{

/*	Set reverse video	*/

    puts ("\033p");
    return;
}


vidnorm()
{

/*	Set normal video	*/

    puts ("\033q");
    return;
}


puts (s)
    char *s;
{
    while (*s) putchar(*s++);
    return;
}


itoa (n)
    int n;
{
    int i, j, l, s;

    if (n < 0)
    {
	putchar ('-');
	n = -n;
    }
    l = 10000;
    s = 0;
    j = n;
    while (l > 1)
    {
	i = j / l;
	if ((i) | (s))
	{
	    s = 1;
	    putchar (('0' + i));
	}
	j = n % l;
	l = l / 10;
    }
    putchar (('0' + j));
    return;
}
