	PAGE	,132
	TITLE	COMPILED QUICKBASIC PROGRAM FIXER
;	FIXCB -- COMPILED QUICKBASIC PROGRAM FIXER
;
;	THIS PROGRAM PATCHES COMPILED QUICKBASIC PROGRAMS
;	SO THAT THEY WILL WORK WITH ZPC
;
;	BY P. SWAYNE, HUG  13-MAR-86

;	DEFINITIONS

PCHADR	EQU	0			;PATCH AREA
OPENF	EQU	0FH			;OPEN FILE
CLOSEF	EQU	10H			;CLOSE FILE
SETDTA	EQU	1AH			;SET DTA ADDRESS
READF	EQU	27H			;READ FILE (RANDOM BLK.)
WRITEF	EQU	28H			;WRITE FILE (RANDOM BLOCK)

CODE	SEGMENT
	ASSUME  CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	6
BUFSIZ	LABEL	WORD
	ORG     5CH
FCB	LABEL   BYTE                    ;DEFAULT FCB ADDRESS
	ORG     100H

START:  MOV     DX,OFFSET SIGNON
	MOV     AH,9
	INT     21H                     ;PRINT SIGNON
	CMP     BYTE PTR FCB+1,' '      ;TEST FOR ARGUMENT
	JNZ     GOTARG                  ;GOT ONE
	MOV     DX,OFFSET EXPL
	MOV     AH,9
	INT     21H                     ;ELSE, EXPLAIN PROGRAM
	INT     20H
GOTARG: MOV     DI,OFFSET FCB+32        ;POINT TO RECORD COUNTERS
	XOR     AX,AX
	CLD
	MOV	CX,3
	REP	STOSW			;CLEAR RECORD COUNTERS
	MOV	DX,OFFSET FCB
	MOV	AH,OPENF
	INT	21H			;OPEN FILE
	INC	AL
	JNZ	OPENED			;OPEN OK
FILERR:	MOV	DX,OFFSET NOFILE
	MOV	AH,9
	INT	21H			;ELSE, SAY "NO FILE"
	INT	20H
PCHSIZ	DW	0			;STORE PATCH SIZE HERE
OPENED:	MOV	WORD PTR FCB+14,1	;SET RECORD SIZE TO 1
	MOV	DX,OFFSET BUFFER
	MOV	AH,SETDTA
	INT	21H			;SET DTA TO BUFFER
	MOV	WORD PTR FCB+33,PCHADR	;START READING FILE HERE
	MOV	CX,BUFSIZ		;GET BUFFER SIZE
	SUB	CX,OFFSET BUFFER	;REMOVE PROGRAM SPACE
	MOV	DX,OFFSET FCB
	MOV	AH,READF
	INT	21H			;READ FROM FILE
	CMP	AL,2
	JNC	FILERR			;FILE ERROR
	MOV	PCHSIZ,CX		;STORE FILE HERE
	MOV	DI,OFFSET BUFFER
	MOV	AL,0BBH			;PREPARE TO SEARCH FOR PATCH CODE
SCODLP:	REPNZ	SCASB			;SEARCH FOR IT
	JNZ	NOPCH			;NOT FOUND
	CMP	ES:WORD PTR [DI],50FH	;IS THIS IT?
	JNZ	SCODLP
	CMP	ES:BYTE PTR 6[DI],74H
	JNZ	SCODLP
	JMP	SHORT PATCH		;CODE FOUND, PATCH IT
NOPCH:	MOV	DX,OFFSET NPMSG
	MOV	AH,9
	INT	21H			;ELSE, SAY "NO PATCH DONE"
	INT	20H
PATCH:	MOV	ES:BYTE PTR 6[DI],0EBH	;MAKE THE PATCH
	MOV	ES:WORD PTR 16[DI],9090H
	MOV	AL,88H			;PREPARE TO SEARCH FOR NEXT PATCH
SCODLP1:REPNZ	SCASB			;SEARCH FOR IT
	JNZ	NOPCH			;NOT FOUND
	CMP	ES:WORD PTR [DI],0F1EH	;IS THIS IT?
	JNZ	SCODLP1
	CMP	ES:BYTE PTR 2[DI],5
	JNZ	SCODLP1
PATCH1:	DEC	DI			;BACK UP TO PATCH AREA
	MOV	AX,9090H
	STOSW				;MAKE THE PATCH
	STOSW
	MOV	WORD PTR FCB+33,PCHADR	;RESET RECORD ADDRESS
	MOV	CX,PCHSIZ		;COUNT OF BYTES TO WRITE
	MOV	DX,OFFSET FCB
	MOV	AH,WRITEF
	INT	21H			;WRITE TO FILE
	OR	AL,AL
	JZ	PCHOK			;WRITE OK
WRERR:	MOV	DX,OFFSET BADWR
	MOV	AH,9
	INT	21H			;SAY "NO WRITE"
	INT	20H
PCHOK:	MOV	DX,OFFSET FCB
	MOV	AH,CLOSEF
	INT	21H			;CLOSE FILE
	INC	AL
	JZ	WRERR			;ERROR IN CLOSING
	MOV	DX,OFFSET DONE
	MOV	AH,9
	INT	21H			;ELSE, SAY "DONE"
	INT	20H			;AND EXIT

;	MESSAGES

SIGNON	DB	13,10,'Compiled QuickBASIC Program Patcher, V. 1.0'
	DB	13,10,10,'$'
EXPL	DB	'This program fixes compiled QuickBASIC programs',13,10
	DB	'(compiled with the /O option) so that they can',13,10
	DB	'be used with ZPC.',13,10,10
	DB	'To use this program, enter',13,10,10
	DB	'  FIXQB d:prog.EXE',13,10,10
	DB	'where d: is a drive designation, and',13,10
	DB	'prog.EXE is the program to patch.',13,10,'$'
NOFILE	DB	7,'ERROR -- No file, or read error.$'
NPMSG	DB	7,'Proper code not found, no patch done.$'
BADWR	DB	7,'ERROR -- Disk write problem.$'
DONE	DB	'Your program was successfully patched.',13,10,'$'

BUFFER	LABEL	BYTE			;BUFFER STARTS HERE

CODE	ENDS
	END	START
