   	TITLE	HELPSCRN.ASM - 1 NOV 1986


;       A PROGRAM TO ALLOW PLACEMENT OF A USER GENERATED MESSAGE IN THE
; 	UPPER 32K OF VIDEO RAM ON THE ZENITH Z-100 AND SUBSEQUENT DISPLAY
;	OF THAT MESSAGE AT ANY TIME DURING EXECUTION OF ANY PROGRAM BY
;	STRIKING A "TOGGLE" KEY (HELP or SHIFT-HELP KEY)--
;
;		Concept and original routines by Dennis L. Myers MD
;		Major enhancements, many routines, and optimization of code
;		by George E. Crawford MD

;		   	VERSION 1.01
;	(all released versions are labeled as 1.0x ---
;	 revised, complete version 1.01 for HUG is dated 1 NOV 86)



;	PROTOTYPE COMPLETED:                       JAN 86
;	FINAL VERSION COMPLETED:                   MAY 86
;	FINAL HUG VERSION COMPLETED:		 1 NOV 86


;	PROGRAM OVERVIEW: 
;		The program has several modules.  A section of resident code
;	is defined that replaces the standard DOS keyboard interrrupt handler
;	and checks each key input for a user-defined key (HELP or SHIFT-HELP).
;	If the keystroke is the "toggle key", a routine is executed
;	that "toggles" the screen between lower & upper video ram on the Z-100.

;	        A section of non-resident code executes once (only) at the first
;       invocation of the program (with the proper Switch), and tells DOS
;       about the new keyboard handler & loads the handler into memory.

;              Other sections of non-resident code are invoked using various  
;	switches to allow the generation, editing, storage to disk, or loading
;	to upper video memory of user defined "help screen" messages.

;	       Console output is driven via MONITOR routines (NOT MS-DOS
;	INT 21H ouput functions) since speed is desired. Because we do NOT
;	use the MS-DOS functions, all string & character output requires
;	a "delimiter" at the end of the byte values to be output. MS-DOS
;	uses the $ character to mark the end of strings.. we use the number 0
;       (NOT ASCII 0... i.e. we use ASCIZ structure)

;	       H-19 Escape codes are used to output control codes to the
;	console.

;	       The routines that "toggle" displaying or writing to upper
;	and lower 32k of video ram are somewhat complex.  Reading the video
;	logic section in the Z-100 technical manual makes understanding them
;	easier.  Note that a major problem when using these routines is the
;	"over-writing" of upper 32K video ram caused by a screen "scroll"  
;	occuring when the cursor is advanced DOWNWARD from the 24th line. 
;	This movement is controlled  from "deep in the heart" of the operating
;       system-hardware interface.  Since the timing of the occurrance of
;	this event is unpredictable from program to program, the upper 32K
;	video memory values (in our situation, the user defined "Help Screen"
;	message) must be re-written to upper 32K videeo memory after EVERY
;	scroll from the 24th line--since scrolling from line 24 "pushes" the
;	discarded text that "rolls off" the top of the screen into the upper
;	32K video ram, screwing up anything that lives there!). The user can
;	"force" a re-write at any time by striking the current toggle key
;	twice in succession... just in case situations arise (especially
;	with "speed-up" mods, etc.) whereby our interrupt is not serviced.
;
;	The program requires a Z-100 computer with version 2.5 (or higher)
;	monitor ROM, and 64k video chips.  Color is not required. It will
;	run under Z-DOS (MS-DOS V.I) or MS-DOS V.II.  It has not been tested
;	but should run under MS-DOS V.III. It will NOT work with LOTUS 1-2-3
;	or other programs that place the keyboard in the EVENT-DRIVEN mode.

;	The program works with the IBM-PC emulator ZPC by Pat Swayne... just
;	remember to use the "SHIFT-HELP" key as the toggle key, since ZPC
;	uses the HELP key.  The toggle key remains active even when ZPC is
;	in the PC mode. However, the program itself is NOT IBM compatible.
;	Therefore, be sure the system is in the Z-100 mode whenever the
;	program is invoked.  The program has not been tested, but should work
;	with both the GEMINI & EASY-PC boards when they are in the Z-100 mode.

;	           FIRST LETS DEFINE SOME DOS EQUATES             
;
;	MS-DOS Interrupt 21H Function Codes...
;
@EXIT		EQU	 0	;terminate program
@CHROUT		EQU	 2	;write character to screen
@KEYIN		EQU      7 	;read keyboard into AL with no echo
@CKEYIN		EQU	12	;clear buffer, execute function in AL
@DISKSET 	EQU     13	;disk system reset
@OPEN1		EQU	15	;open file (Z-DOS)
@SHUT1	        EQU	16	;shut file (Z-DOS)
@SEQ_RD         EQU	20	;sequential read (Z-DOS) 
@SEQ_WR	        EQU	21	;sequential write (Z-DOS)
@CREATE1        EQU	22	;create file (Z-DOS)
@CURDSK	        EQU	25	;get current disk
@SETDTA         EQU	26	;set disk transfer addr
@SETINT         EQU	37	;set interrupt
@GETVER		EQU	48	;get DOS version number
@CREATE2	EQU	60	;create a DOS 2 file
@OPEN2		EQU	61	;DOS 2 file opening
@SHUT2		EQU	62	;DOS 2 file closing
@READ2		EQU	63	;DOS 2 file reading
@WRITE2		EQU	64	;DOS 2 file writing
;
;                  Other DOS Equates
;
ESC		EQU     1BH	;escape code
SPC 		EQU	20H	;ascii space 
CR  		EQU     0DH    	;carriage return
LF		EQU	0AH	;line feed  character
;
;
;		PROGRAM SPECIFIC EQUATES

LOWER   EQU	0	;flag current video ram as lower (program) 32k
UPPER	EQU	1	;flag current video ram as upper (helpscreen) 32k
INT_UKBA EQU	50H	;IO.SYS value for standard keyboard interrupt
VID_PORT EQU	0D8H	;address of video port
GR_PLANE	EQU	0E000H  ;start address of green video plane
WRAP		EQU	0C830H	;byte that mapping wraps to in 32K chips
;

;		 	... END OF EQUATES ...



;	the following "hard jump" lets us get by without INCLUDE 'ing
;	DEF_MTR.ASM in our code.  The jump location is specified as
;	stable by IO.SYS documentation, so it shouldn't move in later
;	issues of MS-DOS for the Z-100...

;	the jump gets us to the screen output routine in the MONITOR ROM
;	(which is copied at BOOT from the monitor ROM to some location in 
;	high RAM).  This routine allows FAST writing to the screen...


MTRSEG	SEGMENT AT 0FE01H	;MTR-100 ROM Segment
	ORG	19H		;Offset to output routine
MTRSCRT LABEL	FAR		;Smart Terminal Emulator
MTRSEG	ENDS
;
;	We will need the address of our keyboard interrupt routine so we
;	can tell DOS where to jump to at keyboard interrupt time. Then
;	we will be jumping from our keyboard interrupt servicing routine
;	(defined later) back to the DOS keyboard interrupt--we also need to 
;	"save" the DOS address we will be jumping back to...         

INTSEG	SEGMENT AT 00H		;Interrupt Segment
	ORG	4*50H		;Offset to keyboard interrupt
INT_KB	LABEL	FAR		;Pointer to keyboard interrupt
DOS_KB	LABEL	FAR		;Dummy label for jump

;	The following "hard" memory location is defined in the source code
;	for the Data Degment of the Monitor-100. The exact location is
;	in upper Ram, having been copied from ROM at Boot.  This location is
;	semi-volatile in that it is specific for the version of ROM.  We 
;	require a ROM version >2.5...
 	
;	Strictly speaking, this is not good programming, since we are accessing
;	locations by absolute addresses instead of variable names.  However, 
;	we need the values in these variables, & there is no access defined 
;	for them (as there is for several ROM routines as described in 
;	DEF_MTR.ASM). For this reason, it would not help us to INCLUDE 
;	DEF_MTR.ASM (as we could for the screen output routine)...

;	IO.SYS guarantees for us that for future versions of Z-100 MS-DOS,
;	the actual address (offset, segment) of the START of the Data
;	Segment of MONITOR routines (after the MONITOR code has been copied
;	to upper RAM at Boot) is contained in the double word
;	(offset,segment) beginning at 03FCH.  We only need the segment,
;	since the MONITOR ROM code gives us the absolute offset into the
;	Data Segment of the variables we need. Again, further versions of
;	the MONITOR should keep the segment value in the same location,
;	but we have NO guarantee that our absolute offsets for variables
;	won't move...


	ORG	03FEH
MTR_DS	LABEL WORD	; Location that contains monitor DS value
INTSEG	ENDS
;
;                  LETS DEFINE SOME MACROS
;
; This is a real handy macro used for most interrupt 21H calls to DOS
;
IF1
DOSCALL MACRO       FUNC,PARM1
.xcref
F_C =       FUNC
IFNB <PARM1>
IF F_C EQ 2 OR (F_C GE 4 AND F_C LE 6) OR F_C EQ 14 OR F_C EQ 46
    MOV     DL,PARM1
ELSE
    MOV     DX,OFFSET PARM1
ENDIF
ENDIF
	MOV	AH,FUNC
	INT	21H
.cref
	ENDM
ENDIF
;


;	We need a simple macro to output text to the screen -- this is it!

TEXT	MACRO STRING
	PUSH	SI
	LEA	SI,STRING ; remember, STRING must end with byte value 0!
	CALL	WRITE     ; output to console via IO.SYS (BIOS) MONITOR routine
	POP	SI
	ENDM

;
;	MORE EQUATES-- THESE ARE USED WHEN LOADING THE RESIDENT CODE

;
HELPID		EQU	4214H   ;just a word to look for
HELP_CHR 	EQU	95H	;code for help key
SHIFT_HELP 	EQU 	0D5H	;code for shifted help key
VERN		EQU	'1'	;HELPSCRN version number
MODN		EQU	'0'	;HELPSCRN modification number
EXIT		EQU	20H	;Normal termination
MSDOS		EQU	21H	;System functions
EXITR		EQU	27H	;Terminate & stay resident
;

;******************* RESIDENT CODE STARTS HERE ***************************

;
CODE    SEGMENT PARA PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE ;keep everthing in one segment
	ORG 100H ; this will be COM file-- save room for PSP required by DOS

START:	JMP INTERRUPTER	 ; move to execute "Master Program" (non-resident) code
;	(this jump helps keep the length of the resident code short...
;	less than 3000 bytes)
;
; ************ "NEW" KEYBOARD INTERRUPT HANDLING ROUTINE BEGINS HERE *********

KEY_INTRUPT:       		; near label for our interrupt handler
	JMP	KEY_CHK		;Jump past data (modified)
				;it might be better to install and uninstall
				;it, but this is more interesting (idea stolen
				;from SPEEDUP.ASM)
	EVEN

;               RESIDENT DATA AREA STARTS HERE

FINDID  DW	?		;ID byte
SELFID	DB	'HELPSCRN - Version ',VERN,'.',MODN,0 ;"Signature" string 
SELFLN	EQU	$-SELFID	;length of signature string
ACT_FL	DB	1		;Active/inactive flag (1/0) 
CRSR_HOME DB    ESC,'H',0	;home cursor
CRSR_25 DB      ESC,'Y8 ',0	;move cursor to line 25, col 1
SAVE_CUR DB	ESC,'j',0	;save cursor position
RE_CUR	DB	ESC,'k',0       ;restore cursor position 
HLP_MSG DB	ESC,'E'		;clear screen and home cursor
	DB      23*84 DUP (' ') ;location of resident memory text buffer
	DB	0		;terminator
OLD_VID DW      -1		;start address for video refresh
				;(initial value is impossible-will force a write
				;to upper 32k video ram first time thru (see
				;CHK_SCROLL)
LAST_KEY_FLAG DB 0		;flag for keystroke prior to one being serviced
				;(0=valid keystroke, 1=toggle key)
				;since the last toggle key was encountered
FILENAME DB     8 DUP (' '),0 	;filename of our helpscreen file
BLANK_BNR DB    80 DUP(' '),0   ;blank banner
FILENAME_LEAD DB 29 DUP(' '),'Help Screen For ',0 ;filename lead-in
HELP_SCREEN DB	LOWER		;flag for whether help screen active
BLK_COLOR DB    ESC,'m70',0	;escape sequence for white on black
OUR_COLOR DB    ESC,'m71',0     ;escape sequence for white on blue  
OLD_COLOR DB    ESC,'m'		;escape sequence to reset colors
HOLD_FORE DB    ?		;sytem foreground color when interrupted
HOLD_BACK DB    ?		;system background color when interrupted
	  DB    0		;terminator
ENTER_REV DB	ESC,'p',0	;escape sequence to enter reverse video mode
NRML_VIDEO DB	ESC,'q',0	;escape sequence to set normal video
LINE_25_ON DB	ESC,'x1',0	;escape sequence to enable line 25 (status line)
LINE_25_OFF DB	ESC,'y1',0	;escape sequence to disable line 25

CRSR_ON DB	ESC,'y5',0	;escape sequence to turn cursor on
CRSR_OFF DB	ESC,'x5',0	;escape sequence to turn cursor off

GRAPHICS_ON DB  ESC,'F',0	;escape sequence to enter graphics mode
GRAPHICS_OFF DB ESC,'G',0	;escape sequence to exit graphics mode

;		Flags for system state when interrupted...

REV_VID_FLAG DW ?	; 0=normal video
LINE_25_FLAG DB ?	; 0=line 25 disabled
GRAPHICS_FLAG DB ?	; 0=text mode
CURSOR_FLAG DB ?	; 0=cursor not displayed (off)

          

;                     END OF RESIDENT DATA

;
; The "guts" of our interrupt handler begins here.  Our handler checks to see
; if the key just struck was our "toggle" key (either HELP or SHIFT-HELP as
; defined earlier by other code) --If the key was NOT the toggle AND the lower
; 32k video is the "current screen" then the keystroke is passed through
; unaltered back to the system. If the key was NOT the toggle AND the upper
; 32k video (the HELP SCREEN) is the "current screen" the keystroke is burned.
; If the key WAS the toggle then the screen is toggled. The routine is optimized
; ... all conditional jumps are executed only if the help screen is on, or a
; help key is entered, thus making it even faster.  If the helpscrn routine
; is inactivated, the jump to KEY_CHK is modified to make it a jump directly
; to the DOS_JMP, making it as fast as possible.
;
KEY_CHK: 			;AL has keystroke just entered, AH should be 0..
	PUSHF			;if it is not "toggle" key, only flags altered
TOG_KEY: CMP	AL,HELP_CHR	;was the keystroke our "toggle" key?
				;(HELP, or SHIFT-HELP if "/+" switch active)
				;note that code is directly modified!
	JE	HELP_ROUT	;if it was the "toggle" chr, go do our routine
	CMP	BYTE PTR CS:HELP_SCREEN,UPPER  ;see if help screen active
	JE	KEY_DISCARD     ;if help screen active, go discard keystroke
	POPF			;restore flags
;
;	The help screen is not being displayed, and the key was not the
;	key defined as the "toggle" key, so "save" the keystroke, and just
;	exit by "jumping back" to the standard DOS keyboard interrupt handler
;	(the DOS keyboard interrupt will be executed AFTER our interrupt..
;	it checks to see if AH has a value other than 0.  If so, the keystroke
;	is ignored.  If the value of AH is 0, the keystroke stored in AL is
;	"passed on" as a valid keystroke...)
;
	MOV	BYTE PTR CS:LAST_KEY_FLAG,0 ;flag this as valid keystroke
DOSJMP: JMP	DOS_KB		;Modified at installation time 
;
KEY_DISCARD:   
        MOV 	AH,0FFH	; now, burn the keystroke by making AH other than zero
	POPF		; restore flags
	JMP	DOSJMP  ; and "jump back" to the standard DOS handler
;
HELP_ROUT:       		; near label for our interrupt handler
				;(come here if keystroke was the "toggle" chr)
                  
	PUSH	BP		;save 'em all!
	PUSH	SI
	PUSH	DI
	PUSH 	DX
	PUSH	CX
	PUSH	BX
	PUSH	DS     		                                        
	PUSH	ES
;
	PUSH	CS
	POP	DS				;set DS seg 
;
	CMP	HELP_SCREEN,UPPER		;help screen on?
	JE	SCRN_ON				;if so, go turn it off
;
;	(help screen not being displayed, and "toggle" chr was just entered)


	CALL	GET_FLAGS			;save current system parameters
	CALL	CHK_SCROLL			;check for scroll
	MOV     BYTE PTR HELP_SCREEN,UPPER	;now, flag upper 32k as on
	CALL 	SCRN_TOGGLE             	;after flagging, toggle
						;display to upper 32K 				
	MOV	LAST_KEY_FLAG,1			;flag this keystroke as a 
						;toggle key
	JMP	EXIT_INTRUPT			;go to exit
;
;
SCRN_ON: MOV BYTE PTR HELP_SCREEN,LOWER	        ;flag upper 32k as off
	CALL	SCRN_TOGGLE			;toggle screen to lower 32K   

EXIT_INTRUPT:         
	MOV	AH,0FFH				;burn this keystroke

	POP ES                                  ;restore 'em all!
	POP DS				                                   
	POP BX
	POP CX
	POP DX
	POP DI
	POP SI
	POP BP
	POPF	            	; restore flags
	JMP	DOSJMP		;exit by "jumping back" to DOS interrupt handler
;

SCRN_TOGGLE:            ;routine to toggle display between lower & upper 32K
	CLI		;we should avoid interrupts during this job
	MOV AL,0CH	;point to correct register (MSB of video refresh
			;address) of CRT-C video controller
	OUT 0DCH,AL	;put that value in pointer register of CRT-C
	IN AL,0DDH	;read the current MSB of video refresh address
	XOR AL,08H	;toggle between values (low->high or high->low)
	OUT 0DDH,AL	;place new value back as MSB of video refresh start
			;address
	STI		;we're done, re-enable interrupts
	RET

;

GET_FLAGS:

;		*** FIRST GET PARAMETERS FROM MONITOR DATA SEGMENT***

;	It may seem inefficient to save parameters BEFORE we know for sure that
;	a "re-write" is even necessary..but the value of one of the parameters
;	(graphics mode) determines partially if a re-write is necessary, and
;	we need to save the 25th line status, since we turn line 25 on for
;	our display...

	MOV	AX,SEG MTR_DS	;get segment of variable that
				;holds segment address of MONITOR Data Seg
	MOV	ES,AX		;make ES that segment so we can get to it
	MOV	AX,WORD PTR ES:MTR_DS ;put seg address of MONITOR Data Seg in AX
	MOV	ES,AX	        ;ES now set to MONITOR Data Segment
	MOV	SI,02A1H	;absolute offset of value of foreground color
				;(FORE) in MONITOR Data Segment
	MOV	AL,ES:[SI]      ;get value of forground color
	MOV	HOLD_FORE,AL	;save it
	ADD	HOLD_FORE,'0'	;"un-bias" the value (convert to ASCII)
	INC	SI		;next byte in MONITOR Data SEG is background color
	MOV	AL,ES:[SI]      ;get value of background color
	MOV	HOLD_BACK,AL	;save it
	ADD	HOLD_BACK,'0'	;as above 
	MOV	SI,02D3H	;absolute offset in MONITOR Data Seg of flag
				;for cursor on or off
	MOV	AL,ES:[SI]	;get "cursor on" flag
	MOV	CURSOR_FLAG,AL	;save it
	ADD	SI,2		;absolute offset in MONITOR Data Seg of flag
				;for graphics mode on or off
 	MOV 	AL,ES:[SI]	;get "graphics mode" flag
	MOV	GRAPHICS_FLAG,AL ;save it
	ADD	SI,3		;absolute offset in MONITOR Data Seg of flag
				;for reverse video on or off 
	MOV	AX,WORD PTR ES:[SI] ;get "reverse video" value (its a word)
	MOV	REV_VID_FLAG,AX	;save it
	ADD	SI,3		;absolute offset in MONITOR Data Seg of flag
				;for 25th line on or off
	MOV	AL,ES:[SI]	;get "25th line enabled" flag
	MOV	LINE_25_FLAG,AL	;save it
	RET



CHK_SCROLL:

;		**** Now check for scrolling***
;	We assume that a scroll has NOT occurred if the MSB of the video
;	refresh address has not changed. If it has changed, we force a
;	"re-write" to upper video ram of our banners and HELP message, since
;	a scroll from lower 32k video shifts data (the display that "rolls
;	up and off the screen" into upper video ram, violating our messsage.
;	We also force a re-write (even if no scrolling has occurred) if the
;	interrupted program was in the graphics mode, since graphics mode can
;       allow unfetered writes to any of the video planes....

	MOV 	AL,0CH	     ;point to correct register (MSB of video refresh
  			     ;address) of CRT-C video controller
	OUT 	0DCH,AL	     ;put that value in pointer register of CRT-C
	IN 	AL,0DDH	     ;read the current MSB of video refresh address
	MOV	AH,AL	     ;put it in AH
	MOV 	AL,0DH	     ;point to correct register (LSB of video refresh
			     ;address) of CRT-C video controller
	OUT 	0DCH,AL	     ;put that value in pointer register of CRT-C
	IN 	AL,0DDH	     ;read the current MSB of video refresh address
			     ;address
	CMP	AX,OLD_VID   ;is it the same as the old video address?
	JNE     UPDATE       ;a scroll has occurred-go re-write the help screen

;		***No scrolling occurred--now see if we're in GRAPHICS mode

	CMP	GRAPHICS_FLAG,0 ;is interrupted program in graphics mode?
	JNE	UPDATE       ;if flag not 0, interrupted program was in graphics
			     ;mode--We re-write screen even if no scroll has 
			     ;occurred...
			     ;(graphics mode can allow separate writes to the
			     ;three video planes--we insure fidelity of our
			     ;upper 32K video by re-writing EVERY time we find
			     ;the interrupted program in graphics mode)

;	now see if our handler has seen a valid keystroke since the last time
;	a toggle was encountered...

	CMP	LAST_KEY_FLAG,0  ;has a valid key been entered?
	JNE	UPDATE		 ;no, there have been two toggles in a row
				 ;... user forced update


	JMP     CHK_SCROLL_X ;no scrolling-no graphics-no forced update

UPDATE: MOV	OLD_VID,AX   ;scroll has occurred, or we're in graphics mode 
			     ;update video start address
        TEXT	SAVE_CUR     ;save the current cursor position
	CALL	WRITE_TOGGLE ;toggle writing to upper 32K video ram
	TEXT    GRAPHICS_OFF ;be sure we're in text mode before our write
			     ;(in case the interrupted program was in graphics
		             ;mode ...this guarantees our "write" will be to
			     ;the upper 32k of ALL THREE video planes, & avoids
			     ;our writing our message with graphics character
			     ;set)
	TEXT	OUR_COLOR    ;white on blue, please
	CMP	REV_VID_FLAG,0 ;was interrupted program in reverse video?
	JE 	REV_VID_NO   ;if value not 0, then program was in rev video
	TEXT	NRML_VIDEO     ;exit reverse video mode
REV_VID_NO: 
        TEXT	HLP_MSG	     ;"re-write" message
	TEXT    CRSR_HOME    ;home cursor
	TEXT	ENTER_REV    ;enter reverse video mode
	TEXT    BLANK_BNR    ;blank out line one banner
	TEXT    CRSR_HOME    ;home cursor
	TEXT    FILENAME_LEAD    ;write our lead in for file name
	TEXT	FILENAME     ;write current filename
	TEXT    NRML_VIDEO   ;exit reverse video
	TEXT    LINE_25_ON   ;enable line 25
        TEXT	CRSR_25	     ;move to line 25, col 1
	TEXT	BLK_COLOR    ;change background to black
	TEXT	BLANK_BNR    ;blank out line 25 banner             
			     ;we must over-write the 25th line,
			     ;since the interrupted program could have 25th
			     ;line enabled, which may have "rolled" data into
			     ;upper 32k video line 25...we print a line of
			     ;"black" spaces so line 25 will look the same
		             ;whether or not line 25 is enabled


FINIS:
;	**Re-Write complete... now we clean up & reset system parameters**

	CMP	LINE_25_FLAG,0 ;was line 25 on in interrupted program?
	JNE      REV_VID     ;yes, just leave it on 
	TEXT    LINE_25_OFF  ;no, turn line 25 off        
REV_VID:CMP REV_VID_FLAG,0   ;was reverse video on in interrupted program?
	JE       RES_CUR     ;no, just leave it off
	TEXT	ENTER_REV    ;yes, turn reverse video on 
RES_CUR : TEXT  RE_CUR	     ;restore the old cursor position
        CMP	CURSOR_FLAG,0 ;was the cursor on in the interrupted program?
	JE	CURSOR_NO    ;no,go turn cursor off       
	TEXT	CRSR_ON	     ;yes, turn cursor on       
	JMP	GRAPHICS_CHECK
CURSOR_NO: TEXT CRSR_OFF     ;turn cursor off            
GRAPHICS_CHECK:
	CMP	GRAPHICS_FLAG,0 ;was interrupted program in graphics mode?
	JE	LAST_STEP	;no, stay in text mode
	TEXT	GRAPHICS_ON	;yes, restore graphics mode
LAST_STEP: TEXT OLD_COLOR    ;restore the interrupted program's colors         
	CALL    WRITE_TOGGLE ;toggle writing back to lower 32K video ram
	
CHK_SCROLL_X:
	RET	             
;
WRITE_TOGGLE PROC               ; routine to "toggle" writing between lower
			        ; and upper 32k of video ram
	CLI			; disable interrupts
        IN AL,0DAH		; read video ram write start address from PIA
				; 6821 video write address latch
	ADD AL,080H		; add # required to move between low & high
				; write start addresses (a very complex video
				; mapping takes place in the video mapping
				; module, and 80H is half the distance of 64K
				; video ram after mapping)              
	OUT 0DAH,AL		; place new video ram write start address back.
	                	; video ram write start address (as calculated
	                        ; by the 6821 PIA video latch) is now toggled
				; by 32k (higher or lower)
	STI			; enable interrupts
	RET
WRITE_TOGGLE ENDP
;
; The write procedure is called by the text macro.  This could have all
; been in the macro, and would be slightly faster, but the program would also
; be longer (in bytes).  It is done this way to allow parameter passing, but
; still keep the program as small as possible.
;
WRITE	PROC                    
	PUSHF			;monitor routines clobber everything
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	ES
	PUSH	BP
CHRLP:
	LODSB			;get next character
	CMP	AL,0		;is it the end?
				;(text strings MUST terminate with byte value 0)
	JE	CHRX		;go to exit
	PUSH	DS		;save DS and SI for later
	PUSH	SI		
	CLD			;Clear direction flag
	CALL	MTRSCRT 	;Write character (IO.SYS, here we come!)
	POP	SI
	POP	DS		;restore needed registers
	JMP	CHRLP		;get the next one
;
CHRX:
	POP	BP              ;restore everything
	POP	ES
	POP	DI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	POPF
	RET
WRITE	ENDP
;
END_RES	EQU $

;****************(END OF RESIDENT CODE)*************************************
;
;                  NON-RESIDENT DATA AREA STARTS HERE

VIDEO_PORT DB	?		;"old" video port value
SRCH_FL	DB	0		;0 not in, 1 its in but inactive, 2 in and up
FLAG	DB	0		;bit 0 for /E, 1 for /A, 2 for /D, 3 for /+
				;ie FLAG = 3 implies /E and /A
        DB	'*'             ;just a marker for start of TITLE_AREA-- see
				;section that strips drive & path off filename
				;contained in TITLE_AREA & then writes the
				;"bare" filename to the resident area under
				;variable FILENAME... (not to be confused with
				;section that strips switches from filename
				;entered at command line & then copies it
				;(drives, paths, & all) to TITLE_AREA)

TITLE_AREA DB	41 DUP (0)	;place to put title of file 
;
CLS     DB   ESC,'E',0   	;clear screen & home
;
FCB	     DB	0,8 DUP (' '),'HLP'   ;local file control block for Z-DOS
				;(we add our extension now... filename will be
				;variable)

	     DB	24 DUP (0)

;	various messages (including H-19 escape sequences) follow...

BEEP	     DB 7,0		;ring the bell
AUTO_WRAP DB	ESC,'v',0	;turn on wrap at end of line
AUTO_WRAP_OFF DB ESC,'w',0	;turn off wrap at end of line
INSTALL_MSG  DB ' By DL Myers & GC Crawford Installed OK...',CR,LF,LF,0
FOUND_MSG    DB ' By DL Myers & GC Crawford Is Resident',CR,LF,0
TOGGLE_MSG   DB CR,LF,' The Help Screen Message Is Now In Upper Video Ram ...'
             DB CR,LF,'    *** To Display The HELP-SCREEN, Strike The ',0
HELP_KEY_MSG DB 'HELP Key ***',CR,LF,LF,0
SHIFTED_KEY  DB      'SHIFTED HELP (SHIFT-HELP) Key ***',CR,LF,LF,0
USE_OLD_FILE DB CR,LF,'  HELP-SCREEN File Name Missing Or Invalid In Command Line...',CR,LF
	     DB '  (A File Currently Exists In Upper Video Ram And Has Been Re-activated)',CR,LF,0
FILE_ERR     DB CR,LF,LF,'A FATAL DATA INPUT ERROR OCCURRED WHILE EXECUTING HELPSCRN--'
	     DB CR,LF,'   (Comments Below Refer To The Command Line Shown Above)'
	     DB CR,LF,LF,' One Of The Following Events Caused The Problem:',CR,LF
             DB LF,'    * The /A switch was set with a missing or invalid filename at the command'
	     DB CR,LF,'      line and there was not a HELP-SCREEN already present in upper video ram'
	     DB CR,LF,'                   OR'
	     DB CR,LF,'      The /A switch was set with a valid filename preceeding it, but the file'
             DB CR,LF,'      could not be found on the specified drive and there was not a'
	     DB CR,LF,'      HELP-SCREEN already present in upper video ram'
	     DB CR,LF,LF,'    * The /E switch was set with an invalid filename preceeding it'
	     DB CR,LF,LF,' HELPSCRN PROGRAM ABORTED...',CR,LF,0
DISK_WRITE_OK DB CR,LF,LF,' HELP-SCREEN MESSAGE SUCCESSFULLY WRITTEN TO SPECIFIED DISK...',CR,LF,0
DISK_FULL DB CR,LF,LF,' DISK FULL... Active File Cannot Be Written To Disk In Drive ',0
DF1	  DB CR,LF,' Place Another Disk In Drive NOW IF Re-try Desired... '         
	  DB CR,LF,' (WARNING! Replace Only With A BLANK Formatted Disk! Under Certain '
	  DB CR,LF,' Circumstances The Directory Of The Replacement Disk Could Be Harmed '
	  DB CR,LF,' Or Files Could Be Over-written!) ',CR,LF,0          
CREAT_ER DB CR,LF,LF,'UNABLE TO CREATE FILE UNDER MS-DOS V.II USING NAME & PATH IN COMMAND LINE',CR,LF
         DB '(the value in AX is '
ERR_CODE DB SPC,SPC,')',CR,LF,'HELPSCRN PROGRAM ABORTED...',CR,LF,0
CREAT_ER1 DB CR,LF,LF,'UNABLE TO CREATE FILE UNDER Z-DOS (MS-DOS V.I) USING NAME IN COMMAND LINE',CR,LF
	  DB '(the value in AL is '
ERR_CODE1 DB SPC,')',CR,LF,'HELPSCRN PROGRAM ABORTED...',CR,LF,0
BAD_RD	DB	CR,LF,LF,'THE HELPSCREEN FILE ENTERED AT THE COMMAND LINE ABOVE EXISTS ON THE SPECIFIED',CR,LF
        DB      'DRIVE, BUT A FATAL DISK READ ERROR OCCURRED. HELPSCRN PROGRAM ABORTED...',CR,LF,0
BAD_FILE DB	CR,LF,LF,'THE HELPSCREEN FILE ENTERED AT THE COMMAND LINE ABOVE EXISTS ON THE SPECIFIED'
         DB     CR,LF,'DRIVE, BUT EITHER HAS IMPROPER CHARACTERS (CARRIAGE RETURNS) PRESENT, OR',CR,LF
	 DB     'IS NOT OF THE LENGTH (1840 BYTES) REQUIRED. HELPSCRN PROGRAM ABORTED...',CR,LF,0

; If "HELPSCRN" with no arguments is entered on the command line, the 
; following self documenting message is output to the screen.
;
SELF_DOC1	DB ESC,'E'	;clear screen, home cursor
	DB	LF
	DB	'	HELPSCRN.COM (Version 1.01) - 28 SEP 1986',CR,LF,CR,LF
	DB	'            by DL Myers & GC Crawford       ',CR,LF,CR,LF
	DB	'This program allows the creation, editing or display of "HELP" messages.  ',CR,LF
	DB	'Messages are displayed when a "toggle" key (HELP or SHIFT-HELP) is struck.  ',CR,LF
	DB	'The help screen message is stored in the upper 32K of video ram',CR,LF
	DB	'of the Zenith Z-100 computer.  Therefore, the message is instantaneously',CR,LF
	DB	'available and does not alter the contents of the lower 32K ("program")   ',CR,LF
	DB	'video ram. Striking the "toggle" key again while the help message is being',CR,LF
	DB	'displayed toggles back to the main program.',CR,LF,LF
	DB	'This program requires Z-DOS (MS-DOS V.I) or MS-DOS (V.II), 64K video ram',CR,LF
	DB	'chips, and V 2.5 or greater ROM. It does not require color capability.',CR,LF              ,CR,LF
	DB	'The program is memory resident.  It may be activated, deactivated, and the',CR,LF
	DB	'message may be changed after loading.  It may be used in a batch file before',CR,LF
	DB	'loading a program, or in a autoexec.bat file.  ',CR,LF,LF
	DB	'******************* Press any key for more *****************************',CR,LF,CR,LF,0
SELF_DOC2	DB	ESC,'E'      
	DB	'Command line syntax is: HELPSCRN [[d:]filename] [/A][/D][/E][/+]',CR,LF,LF
	DB	'The filename is the name of the help message file to be created, edited, ',CR,LF
	DB	'or placed in memory as the help message.  An extension of "HLP" is assumed.',CR,LF,LF
	DB	'MS-DOS V.II paths are supported. Switch functions are:',CR,LF,LF
	DB	'/E - create a new, or edit an existing, help message and store the result',CR,LF
	DB	'back to the file filename.hlp.  This switch may be combined with /A.',CR,LF,CR,LF
	DB	'/A - activate the help message function (& install resident program if not',CR,LF
        DB      'already installed). The file specified at the command line is placed in',CR,LF
	DB	'upper video memory.  If no file is specified, and the program',CR,LF
	DB	'is already resident, it is re-activated with the "old" message.  Otherwise,',CR,LF
	DB	'an error message is returned.  May be combined with /+.',CR,LF,CR,LF
	DB	'/D - deactivate the help function.  The program remains in memory but is',CR,LF
	DB	'inactive.',CR,LF,LF
	DB	'/+ - The normal toggle switch is the "help" key.  Some programs also use',CR,LF
	DB	'this key.  To allow the normal program help key function, /+ makes the',CR,LF
	DB	'toggle key the shifted help key.',CR,LF,0
ONLY32	DB	CR,LF,'SYSTEM HAS ONLY 32K VIDEO CHIPS, HELPSCRN INSTALLATION ABORTED...',CR,LF,0
BADVER	DB	CR,LF,'SYSTEM MONITOR VERSION LESS THAN 2.5, HELPSCRN INSTALLATION ABORTED...',CR,LF,0
EDIT_TIT DB 3 DUP (' '),'HELPSCRN EDITING MODULE',5 DUP(' '),'ACTIVE FILENAME --> ',0
EDIT_MSG DB ESC,'Y',24H,34H 
	DB ' WELCOME TO THE EDIT MODULE OF HELPSCRN!',CR,LF,LF
	DB ' The active filename shown above was entered at the HELPSCRN command line.  If' 
	DB CR,LF
	DB ' the file exists on the specified drive, you will be editing it.  Otherwise,'
	DB CR,LF
	DB ' you will be creating a new file under that name.  THESE KEYS ARE ACTIVE:'
	DB CR,LF,LF
	DB ' 1. The ARROW, TAB, HOME, and RETURN keys work as you would expect'
	DB CR,LF
	DB ' 2. The unshifted DCHR/ICHR key toggles the overwrite/insert character mode'
	DB CR,LF
	DB '    (The Insert Character Mode is noted by a BLOCK cursor)'
	DB CR,LF
	DB ' 3. The shifted DCHR/ICHR key deletes the character at the cursor'
	DB CR,LF
	DB ' 4. The DELETE key deletes the character at the cursor'
	DB CR,LF
	DB ' 5. The shifted DEL LINE/INS LINE deletes the line containing the cursor'
	DB CR,LF
	DB ' 6. The unshifted DEL LINE/INS LINE inserts a line at the position of the cursor'
	DB CR,LF
	DB ' 7. Holding down the control key and pressing the "E" key exits the editor'
	DB CR,LF
	DB '    and saves the text on the screen to the file (new or old) you specified'
	DB CR,LF
	DB '    by entering a FILENAME at the command line of HELPSCRN'
	DB CR,LF,LF
	DB '      (STRIKE ANY KEY TO BEGIN EDITING OLD FILE OR CREATING NEW FILE)' 
	DB 0
TURN_OFF DB	'           ... The HELP-SCREEN Is Now Deactivated ...',CR,LF,LF,0
ALREADY_OFF DB  CR,LF,' The HELP-SCREEN Has ALREADY Been Deactivated...',CR,LF,LF,0

CURS_LFT  DB    ESC,'D',0	;move cursor to left
CURS_RGT  DB    ESC,'C',0	;move cursor right
CURS_UP   DB    ESC,'A',0	;move cursor up
CURS_DWN  DB	ESC,'B',0	;move cursor down
CURS_NML  DB	ESC,'y4',0	;set normal cursor
CURS_BLK  DB	ESC,'x4',0	;set block cursor
RUB_OUT	  DB	ESC,'N',0	;delete character
MSG_25	  DB    ' MESSAGE TEXT INPUT MODE... CTRL-E to save screen when ready (CTRL-C to abort)  ',0
READ_ERR_MSG DB CR,LF,LF,' HAVING TROUBLE READING (GETTING FILE ALLOCATION TABLE) WHEN '
             DB CR,LF,' PREPARING TO WRITE THE ACTIVE FILE TO DISK ',0
UNFIX_MSG DB    CR,LF,LF,' HELPSCRN ABORTED DUE TO FATAL ERROR WHEN WRITING TO SPECIFIED DISK ',0
WP_DISK  DB	CR,LF,LF,' CANNOT WRITE FILE... WRITE-PROTECTED DISK IN DRIVE ',0
WP1	 DB     CR,LF,' Please Remove Tab Prior To Re-Try... '        
	 DB     CR,LF,' (WARNING! Replacing Disk With Another Not Advised! Under Certain '
         DB     CR,LF,' Circumstances, The Directory Of The Replacement Disk Could Be Harmed '
	 DB     CR,LF,' Or Files Could Be Over-written! If Absolutely Necessary, Replace Only '
	 DB     CR,LF,' With A BLANK Formatted Disk!) ',CR,LF,0
RE_TRY_MSG DB   CR,LF,' Should We (A) ABORT Or (R) RE-TRY? -->',CR,LF,0
CURS_LINE_2  DB	ESC,'Y','! ',0	;move cursor back to line 1,column 0 without erasing
				;NOTE: This is EDIT SCREEN home (line 2,col 1)
IN_SPC	  DB	ESC,'@ ',ESC,'O',ESC,'D',0 ;insert a space in display and restore
IN_LINE   DB    ESC,'L',0	;insert line
DEL_LINE  DB	ESC,'M',0	;delete line
DIS_KEY	  DB	ESC,'y?',0	;disable keyboard expansion
EN_KEY	  DB	ESC,'x?',0	;enable keyboard expansion
;
; we need to set up a couple of variables, also

INSERT_FLAG DB	0		;flag for overwrite/insert mode
				;(0=overwrite;1=insert)
INT_KBS	DW	?		;DOS keyboard interrupter (from IO.SYS)
PATHNAME DW	0		;pointer to pathname on command line
				;(used by MS-DOS V II)

;		END OF NON-RESIDENT DATA


;
; THE FOLLOWING ROUTINE IS THE "MASTER PROGRAM" EXECUTED WHENEVER THE 
; PROGRAM IS CALLED VIA THE SYSTEM COMMAND LINE
;
INTERRUPTER:
	CALL	HARDWARE_CHK	;see if hardware is appropriate
	CALL	SEARCH		;set SRCH_FL if interrupter is already resident
	CALL	SWITCH		;sets switch flags based on command line
	CALL	GET_FILE	;look for file
	JNC	CHK_ER		;error on file read?
	JMP	NL_EXIT		;error on file read, exit	
CHK_ER:	TEST	FLAG,1		;edit requested?
	JZ	CHK_ACT		;nope
	CALL	EDIT		;call edit routine
	JC	NL_EXIT		;Control-C entered
CHK_ACT: TEST	FLAG,2		;activation requested?
	JZ	CHK_DEACT	;no
	CALL	ACTIVATE	;do it
CHK_DEACT:
	TEST	FLAG,4	        ;deactivation requested?
	JZ	CHK_DOC		;no, see if any flags entered
	CALL	DEACTIVATE	;wipe it out
CHK_DOC:TEST	FLAG,7		;were any of the flags set?
	JNZ	DONE		;yes, exit to dos
	TEXT	SELF_DOC1	;display self documenting message
	DOSCALL	@KEYIN		;wait for keystroke
	TEXT	SELF_DOC2	;display rest of self documenting message
DONE:	CMP	SRCH_FL,0	;was it resident?
	JNE	NL_EXIT		;yes, normal exit
	TEST	FLAG,2		;activation requested?
	JZ	NL_EXIT		;no, leave
	MOV	DX,OFFSET END_RES	;exit and remain resident
	INT	EXITR
NL_EXIT:
	DOSCALL	@EXIT		;normal non-resident exit



; ************** END OF MASTER PROGRAM *****************************





;
ACTIVATE:
	CMP	SRCH_FL,0	;not in ?
	JNE	ACT_X		;its in already, skip installation
	CALL	INSTALL		;put it in
ACT_X:	CALL	SET_ON		;activate resident program
	CALL	SET_TOG		;set toggle key & tell 'em which one it is
	RET	
;
INSTALL:
;
;	Modify JMP instruction to keyboard interrupt
;
	MOV	AX,SEG INTSEG	;Interrupt segment address
	MOV	ES,AX		;ES = MS-DOS ISR segment
	MOV	BX,OFFSET INT_KB     ;Pointer to DOS keyboard handler
	MOV	AX,ES:[BX]	     ;AX = offset of keyboard handler
	MOV	WORD PTR DOSJMP+1,AX ;Store offset in JMP instruction
	MOV	AX,ES:[BX+2]	     ;AX = segment of keyboard handler
	MOV	WORD PTR DOSJMP+3,AX ;store segment in JMP instruction
;
;	Install our routine in interrupt location
;
	MOV	AX,CS
	MOV	DS,AX		        ;DS:DX = our entry address
	MOV	AL,50H			;number of keyboard interrupt
	DOSCALL	@SETINT,KEY_INTRUPT	;set old interrupt to our entry
	TEXT	SELFID
	TEXT    INSTALL_MSG
	RET
;
SEARCH:    			;finds program, if resident, sets SRCH_FL and
				;places segment of resident program in INT_KBS
;
	XOR	BX,BX		; Start at segment 0
	MOV	AX,HELPID	; Get self id word
	MOV	FINDID,AX	; And put it in its slot
;
; This routine prevents finding the program in a ramdisk,etc.
;
BLKLOOP:
	INC	BX		; Increment segment number
	MOV	ES,BX		; Set segment
	CMP	AX,ES:FINDID	; Is this HELPSCRN?
	JNE	BLKLOOP 	; HELPSCRN not found in this segment
	MOV	CX,DS		; Get this program's segment number
	CMP	BX,CX		; Have we found this copy?
	JE	NOTRES		; Yes - take not found exit
	MOV	SI,offset SELFID ;set code offset
	MOV	DI,SI
	MOV	CX,SELFLN	; Get length of self id
	REPE	CMPSB		; See if rest is here
	JNE	BLKLOOP 	; Search unsuccessful
	MOV	SRCH_FL,1	; Set found flag
	TEXT	SELFID		; Print the good news
	TEXT	FOUND_MSG
	MOV	SI,OFFSET ACT_FL ;see if resident copy is active
	CMP	BYTE PTR ES:[SI],0
	JE	NOTRES
	MOV	SRCH_FL,2	;in and active
NOTRES: MOV	INT_KBS,ES	; store segment
	RET
;
SET_ON:	CMP	SRCH_FL,1	;is it in and inactive
	JNE	ON_X		;no, we're done
	MOV	SRCH_FL,2	;flag it on
	MOV	AX,INT_KBS	;get segment of resident program
	MOV	ES,AX		;put it in ES
	MOV	ES:ACT_FL,1	;flag it on
	MOV	DI,OFFSET KEY_INTRUPT  ;get offset of starting jump
	MOV	AX,(OFFSET KEY_CHK-OFFSET KEY_INTRUPT-3)
	MOV	ES:[DI+1],AX	;modify it
ON_X:	RET

;
; This section modifies code in our interrupter which checks for the "toggle"
; key, changing the compare instruction to check for the "SHIFT-HELP" key
; value instead of the "HELP" key value
;
SET_TOG: TEXT	TOGGLE_MSG		;print toggle lead-in message
	MOV	AX,INT_KBS		;get segment of resident program
	MOV	ES,AX			;put it in ES
	MOV	BX,OFFSET TOG_KEY	;get location of toggle key check
	TEST	FLAG,8			;shifted help requested?
	JZ	NO_SHFT			;no
	TEXT	SHIFTED_KEY             ;tell 'em its the SHIFT-HELP key
	MOV	AL,0D5H			;shifted help code
	JMP	TOG_X			;go modify code directly
NO_SHFT: TEXT	HELP_KEY_MSG            ;tell 'em its the HELP key
	MOV	AL,95H			;unshifted help code
TOG_X:  MOV     ES:[BX+1],AL		;modify compare code directly
	RET
;
;	this routine deactivates the toggle (but interrupter stays resident)

DEACTIVATE:
;
	CMP	SRCH_FL,1		;are we resident, but inactive?
	JE	OFF_X1			;yes, nothing to do
	TEXT	TURN_OFF		;advise on turn-off
	MOV	AX,INT_KBS		;get segment of resident program
	MOV	ES,AX			;put it in ES
	MOV	ES:ACT_FL,0		;flag program off
	MOV	DI,OFFSET KEY_INTRUPT	;modify initial jump instruction
	MOV	AX,(OFFSET DOSJMP-OFFSET KEY_INTRUPT-3)
	MOV	WORD PTR ES:[DI+1],AX	
	JMP     OFF_X			;return
OFF_X1: TEXT    ALREADY_OFF		;tell 'em its already off!	
OFF_X:	RET
;
; This section looks at the command line for switches ("/" characters), and sets 
; "FLAG" accordingly...
;
SWITCH: MOV	BX,80H			;point at number of command line bytes
	XOR	CX,CX			;zero cx
	MOV	CL,[BX]			;get number of bytes
	JCXZ	SW_X            	;no bytes, go to end of this routine
CMD_LP:	INC	BX			;point at next byte
	CMP	BYTE PTR [BX],'/'	;is it the switch character
	JNE	CMD_LPX			;no, go to end of loop
	OR	BYTE PTR [BX+1],20H	;force character to lower case
	CMP	BYTE PTR [BX+1],'e'	;is it an e?
	JNE	NOT_E			;no
	OR	FLAG,1			;set proper bit
	JMP	CMD_LPX			;go to end of loop
NOT_E:  CMP	BYTE PTR [BX+1],'a'	;is it an a?
	JNE	NOT_A			;no
	OR	FLAG,2			;set proper bit
	JMP	CMD_LPX			;go to end of loop
NOT_A:  CMP	BYTE PTR [BX+1],'d'	;is it an d?
	JNE	NOT_D			;no
	OR	FLAG,4			;set proper bit
	JMP	CMD_LPX			;go to end of loop
NOT_D:  CMP	BYTE PTR [BX+1],'+'	;is it an +?
	JNE	CMD_LPX			;no
	OR	FLAG,8			;set proper bit
CMD_LPX:
	LOOP  	CMD_LP			;go check next byte


;	this section copies the filename entered at the MS-DOS command 
;	line to our buffer (TITLE_AREA), stripping off leading spaces
;    	& trailing switches, then appends our extension .HLP followed by 
;	the ASCIZ terminator 0.  Disk and path specificatons remain
;	intact. We use the filename so created (TITLE_AREA) for subsequent
;	disk I/O under MS-DOS V II. 

	MOV	SI,80H			;point at start of command line
SK_SP:	INC	SI			;move to next byte 
	CMP	BYTE PTR [SI],SPC	;have we reached first non-blank chr?
	JZ	SK_SP			;no, keep looking

FIRST_CHR:				;yes, get ready to write our buffer
	MOV	BX,OFFSET TITLE_AREA	;the start of our filename buffer
MOVE_CHR:
	CMP	BYTE PTR [SI],'/'	;reached delimiter?
	JE	DELIM			;yes
	CMP	BYTE PTR [SI],SPC	;reached delimiter?
	JE	DELIM			;yes
	MOV	AL,BYTE PTR [SI]
	MOV	BYTE PTR [BX],AL	;move character to our buffer
	INC	SI			 
	INC	BX
	JMP	MOVE_CHR		;loop to continue search

DELIM:	MOV	BYTE PTR [BX],'.'	;add extension to filename in buffer
	INC	BX
	MOV	BYTE PTR [BX],'H'
	INC	BX
	MOV	BYTE PTR [BX],'L'	
	INC	BX
	MOV	BYTE PTR [BX],'P'
	INC	BX
	MOV	BYTE PTR [BX],0  	;put in ASCIZ terminator (NUL) 

	MOV	PATHNAME,OFFSET TITLE_AREA	;start of our filename
						;(we use it for path in
						;DOS-2 Disk I/O's)
	JMP	Z_DOS_FCB			;oops, we almost forgot...
SW_X:	RET

Z_DOS_FCB:	;we have to build a file control block for Z-DOS.
		;We don't use the default one at 5CH since there may be
		;more than one parameter passed. Note that we don't have to
		;add the extension .HLP or a terminator (0) since we have
		;already placed the extension in the proper location when
		;we defined our file control block (variable FCB)...

	MOV	SI,OFFSET FCB		;start of our FCB
	MOV	BX,5CH			;start of FCB in PSP
FCB_LP: MOV	AL,BYTE PTR [BX]	;get chr in PSP's FCB
	MOV	BYTE PTR [SI],AL	;put it in our FCB
	CMP	BX,64H			;moved all 9 (drive + filename)?
	JE	SW_X			;yes, let's quit
	INC	SI    			;no, increment & loop to get another
	INC	BX
	JMP	FCB_LP
;
GET_FILE:
; this routine looks to see if a file name was entered on the command line.
; if no file name was entered or an invalid filename was entered and:
;   /E was asked for, an error message is generated. (NOTE: a filename is
;      considered valid if found and appropriate in size, and contains
;      no carriage returns. If a valid filename is entered but the file
;      is not found on the current drive, it is assumed that a new file is
;      to be created using that valid filename)
;   /A was asked for, and helpscrn is not already resident, an error message
;      is generated.  If helpscrn is resident, the file currently present in
;      upper video ram is re-activated.
;
; if a file name was supplied and exists, it is read in to TEXT_BUF to 
; be edited or placed in memory.  If /E was not requested, it also places the 
; new text in memory.  There is a idiosyncracy, the last character on line
; 23 will not be displayed in the edit mode, but it is still intact and can 
; be edited, if desired.
;
	TEST	FLAG,3		;if neither E nor A asked for, we are done
	JNZ	NEED_FILE	;
	CLC			;we use the carry flag for error exits
	RET
NEED_FILE:
;
	PUSH	CS		;an easy way to set segment registers
	POP	ES		;make sure ES is this segment
;
; first, lets put blanks in text_buf (our text transfer buffer)
;
	MOV	AL,SPC
	MOV	CX,23*80	;number of bytes in buffer
	MOV	DI,OFFSET TEXT_BUF
REP	STOSB
	MOV	AL,0		;and put in terminator
	STOSB
;
;	we need to know the operating system version since we will use
;	a File Control Block for Z-DOS disk I/O (read), & File Handles for
;	MS-DOS V.II disk I/O (read)
;
	DOSCALL	@GETVER		;get DOS version number
	CMP	AL,1		;ZDOS?
	JLE	ZDOS		;do it with MS-DOS  V.I calls
	JMP	DOS2		;do it the easy way via MS-DOS V.II



;	this routine opens disk files for I/O under Z-DOS

ZDOS:	DOSCALL	@SETDTA,TEXT_BUF	;set data transfer area
	DOSCALL	@OPEN1,FCB		;try opening the file
	CMP	AL,0			;success (al=0)
	JE	FILE_FD			;yes
	TEST	FLAG,1			;edit asked for?
	JNZ	NEW			;yes, we will create it later
	CMP	SRCH_FL,0		;is it resident?
	JNZ	RES_X			;if so, we don't need a file
	TEXT	FILE_ERR		;tell 'em we can't find the file
	JMP	NAME_ERR		;then take error exit     
RES_X:	TEXT    USE_OLD_FILE		;tell em' name missing or invalid
					;(a message is in upper 32K ) 
NEW:    CLC
	RET				;we are done
FILE_FD:
	CMP	WORD PTR FCB[10H],23*80 ;is it the right size?
	JZ	GOOD_SZ                 ;yes, go on
	DOSCALL @SHUT1,FCB		;no, first shut the file
	TEXT	BAD_FILE		;then tell 'em the file stinks
	JMP	NAME_ERR		;and take error exit  
GOOD_SZ: MOV	WORD PTR FCB[0EH],23*80 ;set record size to 23*80
	MOV	WORD PTR FCB[20H],0	;set current record to 0
	DOSCALL	@SEQ_RD,FCB		;get text
	PUSH	AX			;save status flag (AL) for read
	DOSCALL	@SHUT1,FCB		;close file 
	POP	AX			;restore status flag for read
	CMP	AL,0			;if zero, no error on read
	JZ	RD_OK			;read ok
	TEXT	BAD_RD			;inform of error getting file
	JMP	NAME_ERR		;take error exit
RD_OK:	LEA	DI,TEXT_BUF		;point at new text
	MOV	AL,CR			;look for carriage return
	MOV	CX,23*80		;number of bytes to check
REPNE	SCASB				;check for carriage returns
	JNZ	OK_FILE			;none found, size & chrs conform to
					;HELP SCREEN file parameters
	TEXT	BAD_FILE		;tell 'em parameters wrong
	JMP	NAME_ERR		;take error exit
OK_FILE:
	TEST	FLAG,1			;edit called for?
	JNZ	PLAN_EDIT		;yes, we can compress it later
	CALL 	COMPRESS		;else, put it in resident area
PLAN_EDIT:
	CLC
	RET
NAME_ERR:
	JMP	NL_EXIT			;exit to DOS

;	this routine opens disk files for I/O under MS-DOS V.II

DOS2:
	MOV	DX,PATHNAME		;point at pathname
	MOV	AL,0			;open for read only
	DOSCALL	@OPEN2			;attempt to open
	JNC	FILE_FD2		;success
	TEST	FLAG,1			;edit asked for?
	JZ	NO_EDIT
	JMP	NEW			;yes, we will create it later
NO_EDIT: CMP	SRCH_FL,0		;is it resident?
	JZ	NOT_RES         	;no
	JMP	RES_X			;yes, we don't need a file
NOT_RES: TEXT	FILE_ERR		;tell 'em we can't find the file
         JMP	NAME_ERR		;then take error exit

FILE_FD2:
	MOV	BX,AX			;put handle in place
	MOV	CX,2000			;attempt to read 2000 bytes
	DOSCALL	@READ2,TEXT_BUF		;do it
	PUSH	AX			;save status flag (AL) for read
	DOSCALL	@SHUT2			;close the file
	POP	AX			;restore status flag for read
	CMP	AX,23*80		;appropriate number of bytes to read
	JNZ	READ_NOT_OK		;if not the same, no
	JMP	RD_OK			;yes
READ_NOT_OK:
	DOSCALL	@SHUT2			;first close the file
	TEXT	BAD_FILE		;tell 'em the file size stinks
	JMP	NAME_ERR		;then take error exit
 


COMPRESS:
;
; This routine takes the contents of the text buffer and compresses it
; by deleting all blank lines and the leading and terminal spaces in each
; line, using direct cursor addressing inplace of line feeds and spaces.  This
; will generally reduce the amount of text to be written substantially.  The
; result is placed in the resident buffer "HLP_MSG"
;
	PUSH	CS
	POP	ES			;make sure ES is in our segment
	PUSH	BX			;temporary storage
	LEA	SI,TEXT_BUF		;point at text buffer
;
; Note here we set up a temporary buffer. The space between the
; end of the program and the stack at the top of the 64K program segment is
; not used, and if you use part of it as is done here (and with TEXT_BUF)
; you can use large buffers with no increase in program size, as would
; happen with ordinary definitions of data areas
;

; first we need to blank out the temporary buffer with spaces
; its maximum size is 84 chrs x 23 lines + 1 (terminator)
; (worst case scenerio--screen is filled with text (80chrs x 23 lines),
; thus is not compressable, leaving us with 4 extra bytes required per line for
; direct cursor addressing that does nothing)

	MOV	AL,SPC
	MOV	CX,23*84  
	INC	CX			 ;size of our temporary buffer
	MOV	DI,OFFSET TEXT_BUF+23*80 ;address of our temporary buffer
REP	STOSB				 ;fill with blanks

; now we will compress TEXT_BUF, puting the result in the temporary buffer

	MOV	DI,OFFSET TEXT_BUF+23*80 ;set up buffer at end of TEXT_BUF
	MOV	CX,23			;do 23 lines
LINE_LP: PUSH	CX			;save CX
	MOV	CX,80			;80 characters per line
	MOV	BX,0			;column number
NXT_CHR:
	CMP	BYTE PTR [SI],' '	;is it a space?
	JNE	MV_LN
	INC	SI			;check next character
	DEC	CX			;keep cx in sync
	INC	BX			;column counter
	JCXZ	BLK_LN			;all spaces, check next line	
	JMP	NXT_CHR			;get next character
MV_LN:
	MOV	AL,ESC			;direct cursor positioning
	STOSB				;save it in buffer
	MOV	AL,'Y'	
	STOSB
	MOV	AL,20H+24		;last line+1 (start writing line 2)
	POP	CX			;retrieve number of lines processed
	SUB	AL,CL			;calculate current line number
	PUSH	CX			;save number of lines processed again 
	STOSB
	MOV	AL,BL			;current column
	ADD	AL,20H			;20H is column 0
	STOSB				
	MOV	CX,80 			;maximum number of bytes to move
	SUB	CX,BX			;subtract current column number
REP	MOVSB				;move remaining bytes
NXT_LN:	MOV	AL,SPC			;get a space
	MOV	CX,80			;80 bytes in a line
	DEC	DI			;point at last byte in line
	STD				;go backwards
REPE	SCASB				;look for last character in line
	INC	DI			;point at first of terminal spaces
	INC	DI
	CLD				;go forward again
BLK_LN:	POP	CX			;restore line counter
	LOOP	LINE_LP			;go do next line
;
; get rid of terminal spaces in last line
;
	MOV	AL,SPC			;get a space
	MOV	CX,80			;80 bytes in a line
	DEC	DI			;point at last byte in line
	STD				;go backwards
REPE	SCASB				;look for last character in line
	INC	DI			;point at first of terminal spaces
	INC	DI
	CLD				;go forward again
	MOV	AL,0
	STOSB				;terminator
;
; now we download the contents of the buffer into the resident area
;
	MOV	AX,INT_KBS		;get segment of resident message
	MOV	ES,AX			;put it in ES
	MOV	DI,OFFSET HLP_MSG	;offset of resident message
	INC	DI                      ;skip over ESC
	INC	DI			;skip over E
	MOV	SI,OFFSET TEXT_BUF[23*80] ;the address of our buffer
	MOV	CX,84*23		;maximum size of message
MOV_LP: LODSB				;get next byte
	STOSB				;store it in resident buffer
;
; note: lodsb retrieves a byte(word) from DS:SI and puts it in AL(AX)
;       stosb puts the byte(word) in AL(AX) into the location ES:DI
;
	CMP	AL,0		;did we reach terminator
	LOOPNE	MOV_LP		;yes, we are done

	MOV     DI,OFFSET OLD_VID ;offset of "old" video refresh address 
	MOV     AX,-1		;-1 is our "impossible video refresh value" that
				;forces a "upper video ram update"
	STOSW			;put -1 in the variable OLD_VID  
	


;	the message has now moved to our buffer in the resident area...
;	We also need to move the "bare" filename to the resident area to 
;	use in our HELP SCREEN heading. Unlike the heading for the EDIT module
;	(where we display all drive & path specs so the user will know exactly
;	where the file will be written to), we want ONLY the simple filename.
;	So, first we strip the filename of paths, drive specs, etc, and
;       delete the extension (.HLP).  We do this by working backward from 
;	the end of the complete filename stored in TITLE_AREA...


;	we must find end of name (denoted by the period before the extension)

	MOV	SI,OFFSET TITLE_AREA ;start of the filename

NAME_SEARCH:
	MOV     AL,BYTE PTR [SI]     ;put chr in AL
	CMP     AL,'.'		     ;reached delimiter?
	JE	END_FILENAME         ;yes, go on
	INC	SI	
	JMP	NAME_SEARCH

END_FILENAME:
;       now we search backwards for start of filename

	DEC     SI		     ;move back one chr (past the period)
	MOV     BX,1		     ;chr counter           

START_FILENAME:       		    
	CMP	BX,9		     ;counted 8 chrs yet?
	JE      MOVE_FILENAME	     ;yes, we're done
	MOV	AL,BYTE PTR [SI]     ;put chr in AL
	CMP	AL,'\'		     ;delimiter?
	JE      MOVE_FILENAME        ;yes, we're done
        CMP     AL,':'		     ;delimiter?
	JE      MOVE_FILENAME        ;yes, we're done
	CMP	AL,'*'		     ;are we at start of TITLE_AREA?
				     ;(in case the name is simple
				     ;(without drive or paths) AND is less
				     ;than 8 chrs long
	JE	MOVE_FILENAME 	     ;yes, we're done

	        DEC SI
		INC BX
	JMP     START_FILENAME


MOVE_FILENAME:
;	now we move the filename to our resident area

	INC     SI		     ;bump SI past the delimiter, 9th chr,
				     ;or the '*' denoting start of TITLE_AREA
	DEC	BX		     ;& take one off of chr count

;	SI now is start of "bare" filename, which is BX chrs long

	MOV	DI,OFFSET FILENAME   ;filename storage area in resident code

MOVE_FILENAME_CHRS:
	CMP	BX,0		     ;all chrs moved?
	JE	NAME_MOVED	     ;yes, go on
        LODSB	                     ;put chr in AL
	CMP	AL,97		     ;is it lower case?
	JGE     MAP_CASE	     ;yes, go map case
	JMP	MOVE_IT		     ;go, just move chr
MAP_CASE:SUB    AL,32		     ;map case
MOVE_IT:STOSB			     ;move the character into the resident area
	DEC	BX		     ;chr counter
	JMP	MOVE_FILENAME_CHRS   ;loop to get another character

NAME_MOVED:            
	MOV     AL,0
	STOSB                        ;tack on the delimiter to name in res area

	POP 	BX	             ; restore BX
	RET



;	this routine sets us up for the TEXT EDITOR...
;
EDIT:         			
TEXT    OUR_COLOR		;make background blue--easy on the eyes!
TEXT    CLS			;clear & home screen
TEXT    CRSR_ON 		;escape sequence to turn cursor on
TEXT	DIS_KEY			;disable keyboard expansion
TEXT	ENTER_REV		;reverse video
TEXT	BLANK_BNR		;print a blank banner on line one
TEXT	CRSR_HOME		;home cursor
TEXT	EDIT_TIT		;display edit title
TEXT	TITLE_AREA		;print name of current file
TEXT	NRML_VIDEO		;normal video
TEXT    LINE_25_ON		;enable display of 25th line
TEXT	EDIT_MSG		;display message of edit options
	MOV	AL,@KEYIN	;read with no echo
	DOSCALL	@CKEYIN		;clear keyboard buffer and wait for key stroke
;
; A bit of a kludge here.  If we print the whole buffer the screen will scroll
; and mess up our display.  What we will do is to save the last byte, and 
; put a 0 in its place so that the last byte will not be printed.  If auto
; wrap was not on, you could print it all, but it would be more complex, 
; because you would have to print it in 80 byte pieces.
;
	MOV	SI,(OFFSET TEXT_BUF+23*80-1) ;point at the last byte
	MOV	AL,0			     ;put 0 in al
	XCHG	AL,BYTE PTR [SI]	     ;swap al and last byte
	PUSH	AX			     ;save al (and ah)
TEXT	CURS_LINE_2                          ;cursor to first column, 2nd line
TEXT	AUTO_WRAP		;turn on auto wrap
TEXT	TEXT_BUF		;write out current contents
TEXT	AUTO_WRAP_OFF		;turn off auto wrap
	POP	AX		;retrieve saved byte in AL
	MOV	SI,(OFFSET TEXT_BUF+23*80-1) ;point at last byte again
	XCHG	AL,BYTE PTR [SI] ;put saved byte back in place
	CALL	WRITE		;write last byte
TEXT    CRSR_25                 ;move cursor to 25th line
TEXT    ENTER_REV		;reverse video
TEXT    MSG_25			;write abbreviated instructions to line 25
TEXT    NRML_VIDEO		;restore normal video
TEXT	CURS_NML		;be sure normal cursor is on
TEXT	CURS_LINE_2		;put cursor back to 1,0 position (see below)
;



; ***************** TEXT EDITOR BEGINS HERE ************************


        MOV BX,0		;BX to hold cursor line position (0-22)
				;(relative to physical line two)
	MOV SI,0		;SI to hold cursor column position (0-79)
				;(same as true map)
;
;	The text input & saving loop is entered with the cursor at physical
;	line two & column one on the video screen.  This position co-incides
;	with logical line 1 and column 0 of the text video map used by the Z-100
;	since that map calls (24) lines 0-23 and (80) columns 0-79. It will
;	co-incide with logical line 0, column 0 in our map.
;
;	The loop stores text characters in a 23 x 80 array, since we can only
;	write 23 lines because we used physical line one for a banner.
;	The loop address values are in fact "offsets" from the cursor starting
;	position--in our case physical line two, column 1 of the screen.
;       The BX register holds the line offset & the SI register the column.
;	For example, when we are "writing" to physical line 24 (the lowest
;	line we can write to since line 25 is not enabled), BX will equal
;	22. Do not confuse our use of offsets (which will be from physical
;	line two) with absolute offsets that map the Z-100 scheme (ie, BX
;	would be 0 in our map, but 1 in a true map of the video screen).

;	The loop consists of (1) getting a keystroke from the keyboard buffer,
;	(2) seeing if the keystroke is an allowed control character
;	or printable character,
;	(3) printing the character if it is a printable character,
;	(4) saving the character at the appropriate element address in the
;	test saving buffer if it is a printable character,
;	(5) executing the proper move (both on screen & in the text buffer
;	element address markers) if the character is a control character,
;       (6) looping to get another character.
;	The loop is exited by CTRL-E
;	CTRL-C aborts the program.

TEXT_IN: DOSCALL @KEYIN		;DOS read keyboard-no echo; CTRL-C disabled
	CMP AL,03H		;look for control-C
	JNE CHK_E		;it's not, check for next special entry
	JMP CNT_C		;control-C exit
CHK_E:	CMP AL,05H		;check for CTRL-E... our flag to end text input
	JNE GO_ON3       	;no, keep processing this character
	JMP WRITE_CONSOLE	;yes, exit the loop


;	this section tests for control characters and any other       
;	characters that are not printable

GO_ON3:	
        CMP AL,0A5H 		;check for up arrow
	JNE NOT_UP
	JMP UP_AROW		;key was up arrow
NOT_UP:	CMP AL,0A6H 		;check for down arrow
	JNE NOT_DWN
	JMP DWN_AROW		;key was down arrow
NOT_DWN: CMP AL,0A8H 		;check for left arrow
	JNE NOT_LFT
	JMP LFT_AROW		;key was left arrow 
NOT_LFT: CMP AL,0A7H 		;check for right arrow
	JNE NOT_RGT
	JMP RGT_AROW		;key was right arrow 
NOT_RGT:
	CMP AL,0E4H		;shifted del line/ins line
	JNE NOT_D_LINE		;not delete line
	JMP D_LINE		;delete a line
NOT_D_LINE:
	CMP AL,0A4H		;unshifted del line/ins line
	JNE NOT_I_LINE		;not insert line
	JMP INS_LINE		;insert a line
NOT_I_LINE:
	CMP AL,0E3H		;shifted dchr/ichr 
	JNE NOT_D_CHR		;not delete character
	JMP DEL_KEY		;delete a character
NOT_D_CHR:
	CMP AL,0A3H		;unshifted dchr/ichr line
	JNE NOT_ICHR		;not insert character
	JMP MODE_TOGGLE         ;go toggle between overwrite & insert mode
NOT_ICHR:
	CMP AL,0DH      	;check for carriage return
	JE RET_KEY		;key was the return key
	CMP AL,08H		;check for backspace key
	JNE NOT_BK
	JMP BKSP_KEY		;key was backspace key
NOT_BK:	CMP AL,7FH		;check for delete key
	JNE NOT_DEL
	JMP DEL_KEY		;key was delete key
NOT_DEL:
	CMP AL,0A9H     	;check for home key
	JNE NOT_HOME		              
	JMP HOME_KEY		;key was home key

NOT_HOME:
	CMP AL,09H		;check for tab key
	JNE NOT_TAB
	JMP TAB_KEY		;key was tab key
NOT_TAB:
        CMP AL,20H		;lower ascii limit for printable characters
	JL TEXT_IN		;ignore all other ascii values < 20 Hex
	CMP AL,7EH		;upper ascii limit for printable characters
	JG TEXT_IN		;ignore all ascii values > 7E Hex


;     	if we make it here, the character in AL should be printable!
;	this routine handles the printable character by placing it in
;	our text buffer, moves the cursor to the right, and updates
;	the corresponding markers for the cursor location in the 
;	text buffer...

CHRS:   CMP INSERT_FLAG,0	;are we in insert character mode?
       	JE MODE_FIXED   	;no, everthing's ok--go on            
	JMP INSERT_MODE		;yes, go move characters to right of cursor
MODE_FIXED:
	PUSH BX			;save the current line number
	PUSH AX			;save the keyboard stroke (in AL)
      	MOV AX,80		;multiplyer to calculate element #
				;(80 columns per line)
	MUL BX			;80 x line # =element # at START of current line
				;NOTE-AX x BX = doubleword, placed in DX & AX..
				;but highest value we will see is (+) 1840--
				;fits in AX alone
	MOV BX,AX               ;put that value in BX
	POP AX			;restore current keystroke
       	MOV TEXT_BUF[BX][SI],AL ;save the printable character just entered
	POP BX			;restore current line number
				;in the message text buffer at the current
				;line & column position
	MOV DL,AL		;prepare to output character to console
	MOV AH,02H		;DOS function to output to console
	INT 21H			;its done!
	CMP SI,79		;is cursor already at right hand margin?
	JE NEXT1		;yes, don't increment counter  
	INC SI			;no, increment column counter
				;(cursor moves right via IO.SYS with Funct 02H- 
				;so we don't have to move it to right....
				;but we DO have to update our markers that keep
				;the cursor position & the co-incident element
				;position in our buffer array in sync)
NEXT1:	JMP TEXT_IN		;get another character

;	this section handles the return key

RET_KEY: CMP BX,22		;were we at bottom of screen? (physical line 24)
	 JE NEXT2		;yes, keep us at bottom line
	 INC BX			;no, move cursor line holder down one
         TEXT CURS_DWN		;move cursor down one
NEXT2:   CMP SI,0               ;see if cursor at left margin    
	 JE END_LOOP		;at left margin already?
	 TEXT CURS_LFT		;no,move cursor one to left
	 DEC SI			;and decrease column position by one
	 JMP NEXT2		;then loop to do it until at left margin (SI=0)
END_LOOP: JMP TEXT_IN		;get another character

;	this section handles the backspace key

BKSP_KEY: CMP SI,0		;already at left margin?
	JNE NOT_MAR
	JMP LFT_MAR		;yes, just move on
NOT_MAR: DEC SI			;no-decrement column counter
	TEXT CURS_LFT		;and move cursor one space to left
	JMP TEXT_IN		;get another character
;

; this section handles the delete key..
; The routine uses the appropriate escape sequence to modify the display, and
; fixes the text_buffer by copying each letter one to the left, and 
; putting a space at the end
;
DEL_KEY:
	PUSH	AX		;save affected registers
	PUSH	BX
	PUSH	CX
	PUSH	DX
	TEXT	RUB_OUT		;delete key
	MOV	CX,80		;number of characters in a line
	SUB	CX,SI	;number of characters to right of cursor to move
	MOV	SI,80		;point to end of line
	MOV	AX,80	;prepare to multiply by number of letters in line
	MUL	BX		;calculate offset of start of line
	MOV	BX,AX		;put it in BX
	MOV	AL,SPC		;get space for end of line		
DEL_LP: DEC	SI		;move back one character
	XCHG	AL,TEXT_BUF[BX][SI] ;swap current character with AL
	LOOP	DEL_LP		;do rest of line
	POP	DX
	POP	CX
	POP	BX
	POP	AX		;restore registers
	JMP	TEXT_IN         ;get another character
;

; 	this section handles the home key

HOME_KEY: TEXT CURS_LINE_2	;move cursor to top of EDIT SCREEN
	MOV     BX,0		;reset line counter to 0
	MOV	SI,0		;reset column counter to 0
	JMP	TEXT_IN		;get another character


; 	this section handles tab movements to col 8,16,24,32,40,48,56,64,72

TAB_KEY: MOV AX,8		;our tab marker
CHECK:	CMP SI,AX		;is cursor less than tab being tested?
	JGE NEXT_TAB		;no, increment counter
TAB_LP:	CMP SI,AX		;is cursor at a tab?
	JNE TAB_LP1		;no, move along to right
	JMP TEXT_IN		;yes, get another character
TAB_LP1: INC SI			;move our cursor column marker to right
	TEXT CURS_RGT		;and move the cursor
	JMP TAB_LP		;and loop
NEXT_TAB: CMP AX,72	        ;are we to last usable tab (col 72)?
	JE LAST_TAB		;yes, go handle that special case
	ADD AX,8		;no, increment our marker to next tab
	JMP CHECK		;and go check that tab
LAST_TAB:
	CMP SI,79		;are we at last column to right?
	JNE LAST_LOOP 		;no, increment to column 79
	JMP TEXT_IN		;yes, get another character
LAST_LOOP: 
	INC SI			;move column marker 
	TEXT CURS_RGT		;move cursor to right
	JMP LAST_TAB		;loop

;	this section toggles the character mode between overwrite & insert

MODE_TOGGLE:
	CMP INSERT_FLAG,0	;are we in overwrite mode?
	JE  TOGGLE1		;yes, go toggle to insert mode
	MOV INSERT_FLAG,0	;no, so toggle flag to overwrite mode
	TEXT CURS_NML  		;& set cursor to normal to let 'em know
	JMP TEXT_IN		;get another character
TOGGLE1: MOV INSERT_FLAG,1	;toggle flag to insert mode
	TEXT CURS_BLK  		;& set cursor to block to let 'em know
	JMP TEXT_IN		;get another character


;	this section handles movement with arrow keys


UP_AROW: CMP BX,0		;already on line number 0? (physical line 2)
	JE TOP_SCRN		;yes, just move on
	DEC BX			;no-decrement our line counter
	TEXT CURS_UP		;and move cursor one line up
TOP_SCRN: JMP TEXT_IN		;get another character

DWN_AROW: CMP BX,22		;already at bottom of screen? (physical line 24)
	JE BTM_SCRN		;yes, just move on
	INC BX			;no-increment our line counter
	TEXT CURS_DWN		;and move cursor one line down
BTM_SCRN: JMP TEXT_IN		;get another character

LFT_AROW:  CMP SI,0		;already at left margin?
	JE LFT_MAR		;yes, just move on
	DEC SI			;no-decrement column counter
	TEXT CURS_LFT		;and move cursor one space left
LFT_MAR: JMP TEXT_IN		;get another character

RGT_AROW: CMP SI,79		;already at right margin?
	JE RGT_MAR		;yes, move on
	INC SI			;no-increment column counter
	TEXT CURS_RGT		;and move cursor one space right
RGT_MAR: JMP TEXT_IN		;get another character
;

; This section deletes a line by using escape sequence, and then copying
; each byte in buffer beyond current line to 80 bytes (one line) earlier,
; finally putting a line of spaces in 23rd line
;
D_LINE:
	TEXT	DEL_LINE	;escape sequence to delete line from display
	PUSH	AX
	PUSH	BX		;save affected registers
	PUSH	CX
	PUSH	DI
	PUSH	CS	
	POP	ES		;set es register
	PUSH	BX		;save line number
	MOV	AX,22		;maximum line number
	SUB	AX,BX		;subtract current line number
	MOV	BX,80		;bytes in a line
	MUL	BL		;calculate number of bytes to move
	MOV	CX,AX		;put in cx
	POP	BX		;retrive line number
	MOV	AX,80		;bytes in a line
	MUL	BL		;offset of start of current line
	ADD	AX,OFFSET TEXT_BUF  ;offset of start of buffer
	MOV	DI,AX		;point at start of current line
	ADD	AX,80		;start of following line
	MOV	SI,AX		;position to get bytes from
	CLD			;go forwards
	JCXZ	BLANK_L		;no bytes to move, blank last line
REP	MOVSB			;move bytes
BLANK_L:
	MOV	AL,SPC		;get ascii space
	MOV	CX,80		;bytes in line
REP	STOSB			;put spaces in inserted line
	MOV	SI,0		;cursor reset to first column
	POP	DI
	POP	CX		;restore registers
	POP	BX
	POP	AX
	JMP	TEXT_IN
;
;    	this section gets ready to handle printable characters entered
;	with the editor in the insert mode. The text is moved one position
;	to the right of the cursor, and a space is put in where the cursor
;	is. 

INSERT_MODE:
	CMP	SI,79		;are we already at right margin?
	JNE	ICHR 		;no, go insert chr & move text to right
	JMP	MODE_FIXED	;yes, nothing to do
ICHR:	TEXT	IN_SPC		;put a space in the display
	PUSH	SI
	PUSH	CX
	PUSH	BX		;save affected registers
	PUSH	AX
	MOV	AX,80		;bytes in a line
	MOV	CX,80		;bytes in a line
	SUB	CX,SI		;number of bytes to move
	MUL	BL		;calculate offset of current line
	MOV	BX,AX		;put in BX
	MOV	AL,SPC		;put space in buffer
ICHR_LP:
	XCHG	AL,TEXT_BUF[BX][SI] ;save current byte to put in next slot
	INC	SI		;point at next byte
	LOOP	ICHR_LP		;do next one
	POP	AX
	POP	BX		;restore registers
	POP	CX
	POP	SI
	JMP	MODE_FIXED
;

; This section inserts a line by using the appropriate escape sequence, then
; copies each line downstream 80 bytes
;
INS_LINE: 
	TEXT	IN_LINE		;insert line in display
	PUSH	DI
	PUSH	CX		;save affected registers
	PUSH	AX
	PUSH	BX
	PUSH	CS
	POP	ES		;set ES register
	MOV	AX,22		;maximum line number
	SUB	AX,BX		;number of lines affected
	MOV	BX,80		;bytes in a line
	MUL	BL		;bytes to be moved
	MOV	CX,AX		;put in cx
	MOV	AX,(OFFSET TEXT_BUF+80*22-1) ;address of end of 22nd line
	MOV	SI,AX		;point to it (source)
	ADD	AX,80		;end of 23rd line
	MOV	DI,AX		;destination
	STD			;go backwards
	JCXZ	ZERO_LN		;no bytes to move, zero line
REP	MOVSB			;mov the bytes
ZERO_LN:
	MOV	CX,80		;bytes in a line
	MOV	AL,SPC		;get ascii space
REP	STOSB			;fill it with spaces
	CLD
	MOV	SI,0		;cursor resets to first column
	POP	BX
	POP	AX
	POP	CX		;restore affected registers
	POP	DI
	JMP	TEXT_IN


; this routine is reached by a CTRL-E...
; the file in our buffer is written to disk, the system is restored,
; & we exit...

;
WRITE_CONSOLE:			;clean up, put in resident, write file
	TEXT	BLK_COLOR	;white chrs on black background
	TEXT	LINE_25_OFF	;disable line 25
	TEXT	CURS_NML	;be sure cursor is set to normal
	TEXT	CLS	 	;clear screen & home cursor
	TEXT	EN_KEY		;enable keyboard
	TEST	FLAG,2		;activation called for ?
	JZ	EDIT_ONLY	;no, do not put in residence
	CALL	COMPRESS	;put in resident

EDIT_ONLY:
;
; This routine writes the file just created or edited, using the drive
; and filename passed at the command line...

; First we will ensure that the specified drive is legit, and the disk is
; ready to write to by reading and writing the first logical sector. If so,
; we will write the HELP SCREEN to disk...

; (we will use the end of our text buffer as a scratch buffer for the
; read & write tests)

;
	MOV	AL,FCB			;get drive number
	CMP	AL,0			;default?
	JNE	NOT_DEF_DSK		;no
	DOSCALL	@CURDSK			;get current disk
	INC	AL
	MOV	BYTE PTR FCB,AL
NOT_DEF_DSK:
	DOSCALL	@DISKSET		;flush buffers
	MOV	AL,BYTE PTR FCB
	DEC	AL			;a=0,b=1,etc
	MOV	CX,1			;read one sector
	MOV	DX,0			;read first sector
	MOV	BX,OFFSET TEXT_BUF+23*80 ;point at buffer
	INT	25H			;absolute disk read
	JNC	TRY_WRITE
	POPF
	TEXT  	READ_ERR_MSG		;tell 'em about it
       	MOV	DL,FCB			;get number of drive 
	ADD	DL,40H			;change to letter
	DOSCALL	@CHROUT			;print disk drive letter
	TEXT	ENTER_REV		;set reverse video
	TEXT	RE_TRY_MSG		;see if they want to try read again
	TEXT    NRML_VIDEO		;set normal video
ASK_KEY: MOV	AL,@KEYIN		
	DOSCALL	@CKEYIN			;wait for input
	AND	AL,0DFH			;force to upper case
	CMP	AL,'R'			;retry requested
	JE	NOT_DEF_DSK
	CMP	AL,'A'			;abort request
	JE	ABORT_IT		;neither of allowed responses
	TEXT	BEEP
	JMP	ASK_KEY
ABORT_IT:
	JMP	NL_EXIT			;otherwise exit

TRY_WRITE:
	
;	this routine tests for ability to write to the specified disk by
;	trying to write what was read in the absolute read test above back
;	to the same sector.  If not successful, the cause of the failure
;	is checked. Retry is allowed only for write-protect error...

	POPF
REWRITE: DOSCALL @DISKSET		;reset system disk status
        MOV	AL,FCB			;get drive number
	DEC	AL			;adjust it
	MOV	CX,1			;write one sector
	MOV	DX,0			;write first sector
	MOV	BX,OFFSET TEXT_BUF+23*80 ;point at buffer
	INT	26H			;absolute disk write
	JNC	WRITE_SUCCESS		;it worked! go write to disk
	POPF
	CMP	AL,0			;was error write-protect?
	JNE	UNK_ERR			;no, go exit for fatal write error
	TEXT	WP_DISK			;inform write protected
	MOV	DL,FCB			;get number of drive
	ADD	DL,40H			;change to letter
	DOSCALL @CHROUT			;print drive letter
	TEXT	WP1			;more info
	TEXT    ENTER_REV		;set reverse video
	TEXT	RE_TRY_MSG		;ask for decision
	TEXT	NRML_VIDEO		;set normal video
ASK_KEY2: MOV	AL,@KEYIN		
	DOSCALL	@CKEYIN			;wait for input
	AND	AL,0DFH			;force to upper case
	CMP	AL,'R'			;? retry requested
	JNE	NOT_R			;no, go check for abort request
	JMP	NOT_DEF_DSK		;yes, start over with read attempt
NOT_R:	CMP	AL,'A'			;abort request
	JE	ABORT_IT		;neither of allowed responses
	TEXT	BEEP
	JMP	ASK_KEY2
UNK_ERR: TEXT	UNFIX_MSG		;unknown errors are fatal
	JMP	ABORT_IT

;	we come here if the disk can be written to successfully...

WRITE_SUCCESS:
	POPF
	DOSCALL @DISKSET		;reset system disk status
	DOSCALL	@GETVER			;get DOS version
	CMP	AL,1
	JLE	ZDOS1			;its ZDOS
	JMP	ITS_DOS2		;its MS-DOS V.II


;	in the following write routines, note that we use the CREATE
;	function.  If the file does not exist on the specified drive,
;	CREATE will create it and open it for writing. If it does exist,
;	CREATE will erase the old file, & then re-open for writing.
;	This approach guarantees that we will not be concatonating old
;	files inadventently, or trashing disk directories...

;	this routine writes our file to disk under Z-DOS (MS-DOS V.I)

ZDOS1:	DOSCALL	@SETDTA,TEXT_BUF	;set data transfer area
	DOSCALL	@CREATE1,FCB		;create if new, open if exits
	CMP	AL,0			;check for success
	JZ	GOT_IT
	JMP	CREAT_ERR1		;failed
GOT_IT:	MOV	WORD PTR FCB[0EH],23*80 ;set record size to 23*80
	MOV	WORD PTR FCB[20H],0	;set current record to 0
	DOSCALL	@SEQ_WR,FCB	;write the help message to disk
	JMP	WRITE_OK1       ;go on
RE_TRY1:
	TEXT	ENTER_REV	;reverse video
	TEXT	RE_TRY_MSG	;see if they want to try again
	TEXT    NRML_VIDEO
ASK_KEY1: MOV	AL,@KEYIN
	DOSCALL @CKEYIN		;wait for input
	AND	AL,0DFH		;force to upper case
	CMP	AL,'R'		;retry requested
	JNE	NOT_RE1		;no, check for abort request
	JMP     NOT_DEF_DSK     ;yes, start over with new disk    
NOT_RE1: CMP	AL,'A'		;abort requested?
	JNE	BAD_KEY1	;neither of allowed responses
	JMP	NL_EXIT		;terminate program
BAD_KEY1: TEXT BEEP
	JMP	ASK_KEY1
WRITE_OK1:
	CMP	AL,1		;disk full error?
	JNE     GOOD_WRITE1     ;no, go on
	DOSCALL @SHUT1,FCB      ;close the partially written file
	TEXT 	DISK_FULL       ;tell 'em about it
	MOV	DL,FCB		;get drive number
	ADD	DL,40H		;convert to letter
	DOSCALL	@CHROUT		;print drive letter
	TEXT	DF1		;more info
	JMP	RE_TRY1     	;see if they want to try again    
GOOD_WRITE1:
	DOSCALL @SHUT1,FCB	;close the file
	TEXT    DISK_WRITE_OK   ;tell em' the helpscreen message written ok
	CLC
	RET


;	this routine intercepts a CTRL-C abort out of the edit routine,
;	allowing us to reset system parameters before returning to DOS


CNT_C:  TEXT	BLK_COLOR	;restore regular screen
	TEXT	LINE_25_OFF	;disable line 25
	TEXT	CURS_NML	;set normal cursor
	TEXT	CLS		;clear screen & home cursor
	TEXT	EN_KEY		;enable keyboard
CNT_C_X: STC
	RET	

;	these routines handle exits caused by file creation errors that
;	occurred when trying to write our file to disk...


CREAT_ERR:			;file creation error under MS-DOS VII
	ADD	AX,'0'		;un-bias the error code (convert to ASCII)
	MOV	SI,OFFSET ERR_CODE ;our error code storage location
	MOV  	WORD PTR [SI],AX ;put the error code value in the "middle" 
				;of our error message string
	MOV	BYTE PTR [SI+1],SPC ;we have to "fix" the byte corresponding to
				;AH, since AX will have a number small enough
				;to make AH=0... and that 0 will terminate our
				;output string!!! We'll put a space in its place
	TEXT	CREAT_ER	;tell 'em about it
	JMP	CNT_C_X

CREAT_ERR1:            		;file creation error under Z-DOS
	ADD	AL,'0'		;un-bias the error code (convert to ASCII)
	MOV	SI,OFFSET ERR_CODE1 ;our error code storage location
	MOV	BYTE PTR [SI],AL ;put the error code value in the "middle"
				;of our error messsage string
	TEXT	CREAT_ER1	 ;tell 'em about it
	JMP	CNT_C_X
;


;	this routine writes our file to disk under MS-DOS V.II

ITS_DOS2:
	MOV	DX,PATHNAME		;point to pathname
	MOV	CX,0			;ordinary file
	DOSCALL	@CREATE2		;create if new, open if old
	JC	CREAT_ERR		;failed
GOT_IT2: MOV	BX,AX               	;put handle in place
	MOV	CX,23*80		;bytes to write
	DOSCALL	@WRITE2,TEXT_BUF	;write the help message to disk
	JMP	WRITE_OK2		;go on
RE_TRY2:
	TEXT	ENTER_REV		;reverse video
	TEXT	RE_TRY_MSG		;see if they want to try again
	TEXT	NRML_VIDEO
ASK_KEY3: MOV AL,@KEYIN
	DOSCALL @CKEYIN			;wait for input
	AND	AL,0DFH			;force to upper case
	CMP	AL,'R'			;retry requested?
	JNE	NOT_RE2			;no, check for abort request
	JMP	NOT_DEF_DSK             ;yes, start over with new disk   
NOT_RE2: CMP	AL,'A'			;is it abort request?
	JNE	BAD_KEY2		;neither of allowed responses
	DOSCALL @DISKSET		;reset system disk status
	JMP	NL_EXIT			;terminate program
BAD_KEY2: TEXT BEEP
	JMP	ASK_KEY3
WRITE_OK2:
	CMP	AX,23*80		;disk full error?
	JE	GOOD_WRITE2		;no, go on 
	DOSCALL @SHUT2			;close the file
    	TEXT	DISK_FULL               ;tell 'em about it
	MOV	DL,FCB			;get drive number
	ADD	DL,40H			;convert to letter
	DOSCALL @CHROUT			;print drive letter
	TEXT	DF1			;more info
	JMP	RE_TRY2                 ;see if they want to try again
GOOD_WRITE2:
	DOSCALL	@SHUT2			;close file
	TEXT    DISK_WRITE_OK   ;tell 'em the helpscreen message written ok
	CLC
	RET
;
HARDWARE_CHK:
;
; This routine checks to see if the monitor version is 2.5 or greater,
; and if the green video plane has 64K chips
;
	PUSH	ES			;save registers used
	PUSH	AX
	PUSH	BX

	IN	AL,VID_PORT	        ;enable video port
	MOV	VIDEO_PORT,AL		;save old value
	MOV	AL,01111000B		;write to all planes
	OUT	VID_PORT,AL	


;	This part tests for 64K chips by seeing if the next address
;       value above 32K wraps back... if it doesn't (ie different for start
;	of video ram & for 32K above start), then chips must be 64K...
;	If they do, we check to make sure they aren't 64k chips that happen
;	by chance to have the same value by changing the value in the
;	first byte of upper 32K. If the value of the first byte of lower
;	32k changes to the new value, then "wrapping" has occurred, and the
;	chips must be 32K...

	MOV	AX,GR_PLANE		;get green video segment
	MOV	ES,AX			;make ES that segment
	MOV	BX,0			;point to first byte of video plane
	MOV	AH,ES:[BX]		;get byte value at start of plane
	MOV	BX,WRAP			;point to first byte, upper 32K
	MOV	AL,ES:[BX]		;get that value
	CMP	AH,AL           	;should be same if 32k chips installed
	JNE     X_64			;they're not equal--64K present
	INC	BYTE PTR ES:[BX]	;increment byte on page 2
	MOV	AL,BYTE PTR ES:[BX]	;& get it
	MOV	BX,0
	MOV	AH,ES:[BX]		;now get the value in first byte page 1
	CMP	AH,AL			;should be different if 64K chips
	JNE	X_64

;	32k chips are present, lets boogie out

	MOV	AL,VID_PORT
	OUT	VID_PORT,AL		;restore old video port value
	TEXT	ONLY32			;tell 'em they got 32k chips
	POP	BX
	POP	AX
	POP	ES
	JMP     NL_EXIT			;and exit

X_64:	MOV	AL,VID_PORT	
	OUT	VID_PORT,AL		;restore old video port value
;

;	this routine checks for version of MONITOR ROM...

	MOV	AX,SEG MTR_DS	;get segment of variable in DEFMTR.ASM that
				;holds address of MONITOR Data Segment
	MOV	ES,AX		;make ES that segment so we can get to it
	MOV	AX,WORD PTR ES:MTR_DS ;put address of MONITOR Data Seg in AX
	MOV	ES,AX		;ES now set to MONITOR Data Segment
	MOV	BX,5		;absolute offset of value BCD MONITOR ver #
	CMP	BYTE PTR ES:[BX],25H ;version 2.5 or greater ROM?
	JGE	HARD_X		;yes, we're ok
	TEXT	BADVER		;tell 'em they've got low version ROM
	POP	BX
	POP	AX
	POP	ES
	JMP	NL_EXIT		;and abort
HARD_X: POP	BX
	POP	AX
	POP	ES
	RET


; Same old buffer trick. Putting it at the end of the file does not
; increase the size of the COM file on disk, but it can
; still be used for a large buffer.  
;
TEXT_BUF DB 0                 ;buffer for text screen (23 x 80)
;
;	Bet you thought you would never see the end.... but here it is!

CODE	ENDS
	END START
