	PAGE	,132
	TITLE	HEPSET
;	HEPSET -- HEPCAT FEATURE SETTING PROGRAM
;	THIS PROGRAM IS USED TO ALTER CERTAIN PARAMETERS
;	OF THE HEPCAT PROGRAM WHILE IT IS RESIDENT IN MEMORY.
;	TO USE THIS PROGRAM, ENTER
;
;	HEPSET cp<,cp,cp...>
;
;	WHERE c IS A PARAMETER CODE, AND p IS THE PARAMETER VALUE.
;
;	BY PATRICK SWAYNE, HUG SOFTWARE ENGINEER  07-MAY-87
;	COPYRIGHT (C) PATRICK SWAYNE 1987.  ALL RIGHTS RESERVED.

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	MOV	SI,80H			;POINT TO PARAMETER STRING
	CLD
	LODSB				;GET COUNT
	XOR	AH,AH			;MAKE IT A WORD
	MOV	CX,AX			;COUNT TO CX
	CALL	SOS			;SKIP SPACES
	JNZ	GOTARG			;WE HAVE ARGUMENTS
EXPL:	MOV	DX,OFFSET EXPMSG
	CALL	PMSG			;PRINT EXPLAINATION
	INT	20H			;AND QUIT
GETARG:	CALL	GETNC			;GET NEXT CHARACTER
	JZ	DONE			;JUST SPACES LEFT, DONE
GOTARG:	CMP	AL,','			;COMMA?
	JNZ	NOTCOM			;NO
DOLOOP:	LOOP	GETARG			;ELSE, TRY AGAIN
DONE:	MOV	DX,OFFSET PARSET
	CALL	PMSG			;SAY "PARAMETERS SET"
	INT	20H
NOTCOM:	CMP	AL,'A'			;SET ANGLE?
	JNZ	NOTANG			;NO
	PUSH	AX			;SAVE "A"
	CALL	GETNCC			;GET NEXT CHARACTER AND COUNT IT
	JZ	EXPL			;SHOULD HAVE BEEN A PARAMETER
	MOV	BH,1			;ASSUME DEGREES
	MOV	BL,AL			;CHARACTER TO BL
	CMP	BL,'D'			;DEGREES?
	JZ	GOTDEG			;YES
	MOV	BH,0			;ELSE, SET FLAG FOR RADIANS
	CMP	BL,'R'			;CHECK FOR IT
	JNZ	EXPL			;BAD PARAMETER
GOTDEG:	JMP	XCMD			;EXECUTE COMMAND
NOTANG:	CMP	AL,'R'			;SET RADIX?
	JNZ	NOTRAD			;NO
	PUSH	AX			;SAVE CHARACTER
	CALL	GETNCC			;GET PARAMETER
	JZ	EXPLJ			;WASN'T ONE
	MOV	DI,OFFSET RADIXES	;POINT TO RADIXES
	PUSH	CX
	MOV	CX,10			;TEN OF THEM
	REPNZ	SCASB			;LOOK FOR THE ONE ENTERED
	JNZ	EXPLJ			;NOT FOUND
	MOV	BX,9			;RADIX COUNT -1
	SUB	BL,CL			;GET RADIX NUMBER
	POP	CX
	CMP	AL,'8'			;BASE 8?
	JNZ	RADN8			;NO
	CALL	GETNCC			;CHECK NEXT CHARACTER
	JZ	EXPLJ
	CMP	AL,','			;COMMA?
	JZ	XCMD
	CMP	AL,'S'			;SPLIT OCTAL
	JNZ	EXPLJ			;NO
	INC	BX			;ELSE, NEXT RADIX
XCMD:	MOV	DL,0			;NOT FIXED PT.
XCMD1:	POP	AX			;RESTORE CODE
	MOV	AH,0F7H
	INT	21H			;EXECUTE COMMAND
	JMP	DOLOOP			;MOVE ON
RADN8:	CMP	AL,'1'			;DECIMAL OR HEX?
	JNZ	RADN10			;NO
	CALL	GETNCC			;ELSE, GET NEXT CHARACTER
	JZ	EXPLJ
	CMP	AL,'0'			;BASE 10?
	JZ	XCMD			;YES
	INC	BX			;ASSUME BASE 16
	CMP	AL,'6'			;TEST FOR BASE 16
	JZ	XCMD			;IT IS
EXPLJ:	JMP	EXPL			;ELSE, EXPLAIN
RADN10:	CMP	AL,'F'			;FIXED/FLOATING?
	JNZ	XCMD			;IF NOT, DONE
	CALL	GETNCC			;GET NEXT CHAR
	CMP	AL,','			;COMMA?
	JZ	XCMD			;IF SO, DONE
	SUB	AL,'0'			;REMOVE ASCII
	JB	EXPLJ			;BAD NUMBER
	CMP	AL,8
	JA	EXPLJ			;TOO BIG
	INC	AL			;ADD DP
	MOV	DL,AL			;POSITION TO DL
	JMP	XCMD1			;WE'RE DONE
NOTRAD:	CMP	AL,'C'			;SET COLORS?
	JNZ	NOTCOL			;NO
	PUSH	AX
	CALL	GETNCC			;GET FOREGROUND COLOR
	JZ	EXPLJ
	CALL	HEX2BIN			;CONVERT NUMBER
	JC	EXPLJ			;BAD ONE
	MOV	BL,AL
	CALL	GETNCC			;GET BACKGROUND COLOR
	JZ	EXPLJ
	CALL	HEX2BIN			;CONVERT
	JC	EXPLJ
	MOV	BH,AL			;BX = COLORS
	JMP	XCMD
NOTCOL:	CMP	AL,'K'			;SET KEYBOARD?
	JNZ	NOTKEY			;NO
	PUSH	AX
	CALL	GETNCC
	JZ	EXPLJ
	MOV	BL,0			;ASSUME NON-PROTECT
	CMP	AL,'N'			;IS IT?
	JZ	XCMDJ			;YES
	MOV	BL,1			;ASSUME PROTECT
	CMP	AL,'P'			;IS IT?
	JZ	XCMDJ			;YES
	MOV	BL,2			;ASSUME SUPER PROTECT
	CMP	AL,'S'			;IS IT?
	JNZ	EXPLJ			;IF NOT, ERROR
XCMDJ:	JMP	XCMD
NOTKEY:	CMP	AL,'T'			;SET TOP LINE?
	JNZ	EXPLJ			;NO, BAD ENTRY
	PUSH	AX
	CALL	GETNCC			;GET NUMBER
	JZ	EXPLJ
	SUB	AL,'0'			;REMOVE ASCII
	JB	EXPLJ
	CMP	AL,1
	JA	EXPLJ
	MOV	BL,AL
	JMP	XCMDJ

;	PRINT MESSAGES

PMSG:	MOV	AH,9
	INT	21H
	RET

;	GET NEXT CHARACTER, SKIPPING SPACES BEFORE IT

GETNC:	LODSB				;GET CHARACTER
SOS:	MOV	AL,[SI]			;GET A CHARACTER
	CALL	MUC			;CAPITALIZE
	CMP	AL,' '			;SPACE?
	JNZ	SOSX			;NO
	INC	SI			;ELSE, BUMP POINTER
	LOOP	SOS			;TRY AGAIN
SOSX:	OR	CX,CX			;TEST COUNT
	RET
GETNCC:	CALL	GETNC			;GET NEXT CHARACTER
	JZ	GETNCX
	DEC	CX			;COUNT IT
GETNCX:	RET

;	MAP LOWER CASE TO UPPER

MUC:	CMP	AL,'a'			;LESS THAN "a"?
	JB	MUCX			;YES
	CMP	AL,'z'+1		;MORE THAN "z"?
	JNB	MUCX			;YES
	AND	AL,5FH			;ELSE, CAPITALIZE
MUCX:	RET

;	CONVERT ASCII HEX TO BINARY

HEX2BIN:SUB	AL,'0'			;REMOVE ASCII
	JB	HEX2X			;BAD ENTRY
	ADD	AL,'0'-'G'
	JC	HEX2X			;WAS MORE THAN F
	ADD	AL,6
	JNS	HEX2B0			;WAS A-F
	ADD	AL,7
	JC	HEX2X			;WAS :-@
HEX2B0:	ADD	AL,10			;ADJUST
	OR	AL,AL			;CLEAR CARRY
HEX2X:	RET
	
;	DATA AREA

RADIXES	DB	'2','4','8','8','1','1','F','F','S','E'

EXPMSG	DB	13,10,'HEPCAT Parameter Setting Program, version 1.0',13,10
	DB	'To use this program, enter',13,10,10
	DB	'  HEPSET xx[,xx,xx...]',13,10,10
	DB	'where xx is one of the following:',13,10,10
	DB	'	AD	set angle measurement to degrees.',13,10
	DB	'	AR	set angle measurement to radians.',13,10
	DB	'	Rn	set radix to n, where n is 2, 4, 8, 8S (split'
	DB	13,10
	DB	'		octal), 10, 16, Fn (fixed point with n (2-8)'
	DB	13,10
	DB	'		places after the decimal), F (floating point),'
	DB	13,10
	DB	'		S or E (scientific or engineering notation).'
	DB	13,10
	DB	'	Cfb	set foreground color to f and background color'
	DB	13,10
	DB	'		to b, where f and b are hex numbers (0-F).',13,10
	DB	'	KN	set keyboard non-protected mode.',13,10
	DB	'	KP	set keyboard protect mode.',13,10
	DB	'	KS	set keyboard super protect mode.',13,10
	DB	'	Tn	set top line of window to line n, where n is 0'
	DB	13,10
	DB	'		or 1.',13,10,10
	DB	'Angle and radix settings take effect only if used before'
	DB	13,10
	DB	'HEPCAT has been popped up the first time after loading.$'
PARSET	DB	'HEPCAT parameters set.$'

CODE	ENDS
	END	START
