	TITLE	KEYMAP CONFIGURATION PROGRAM
	PAGE	,132
;	KEYCON - CONFIGURATION PROGRAM FOR KEYMAP
;
;	THIS PROGRAM CONFIGURES THE KEYMAP PROGRAM, ALLOWING THE
;	USER TO INSERT HIS/HER DESIRED OUTPUTS FOR EACH MAPPED KEY.
;
;	BY P. SWAYNE, HUG  27-JAN-84
;	Z-150 VERSION  26-SEP-84
;	COPYRIGHT (C) 1984 BY HEATH USERS' GROUP

;	DEFINITIONS

M	EQU	Byte Ptr 0[BX]		;MEMORY POINTER
CONOUT	EQU	2			;CONSOLE OUTPUT
LSTOUT	EQU	5			;LST OUTPUT
DCIN	EQU	7			;DIRECT CONSOLE INPUT
TYPEF	EQU	9			;TYPE STRING
LINPUT	EQU	10			;LINE INPUT
OPENF	EQU	15			;OPEN FILE
CLOSEF	EQU	16			;CLOSE FILE
DELETF	EQU	19			;DELETE FILE
READF	EQU	20			;READ FILE (SEQUENTIAL)
WRITEF	EQU	21			;WRITE FILE (SEQ)
MAKEF	EQU	22			;MAKE FILE
SETDMA	EQU	26			;SET DMA ADDRESS

CONF	SEGMENT
	ASSUME	CS:CONF,DS:CONF,ES:CONF,SS:CONF
	ORG	100H

;	START BY GETTING NAME OF KEYMAP FILE TO WORK ON

CONFIG:	MOV	AX,CS
	MOV	DS,AX			;SET UP SEGMENT REGISTERS
	MOV	ES,AX
	MOV	SS,AX
	MOV	SP,Offset STACK		;SET STACK
	MOV	DX,(Offset CONMSG)	;PRINT CONFIG MESSAGE
	CLD				;CLEAR DIRECTION FLAG
	CALL	PMSG
	MOV	AL,15			;ALLOW 14 CHARACTERS
	CALL	RDCON			;READ FILE NAME
	JNZ	GOTNAM
	JMP	EXIT			;GUESS HE DON'T WANT TO DO IT

;	READ IN THE KEYMAP FILE

GOTNAM:	MOV	Byte Ptr [DI],0		;TERMINATE NAME
	MOV	SI,DX			;POINT TO INPUT FILE NAME
	MOV	DI,Offset CFCB		;PUT IT HERE
	MOV	AH,29H
	MOV	AL,1000B		;USE DEFAULT EXTENSION
	INT	21H			;PARSE FILE NAME
	MOV	DX,(Offset CBUF)	;POINT TO CONFIG BUFFER
	MOV	AH,SETDMA
	INT	21H			;SET DMA THERE
	MOV	DX,(Offset CFCB)	;POINT TO KEYMAP FILE NAME
	MOV	AH,OPENF
	INT	21H			;TRY TO OPEN KEYMAP.COM
	INC	AL
	OR	AL,AL
	JNZ	OPENED			;OPENED OK
	MOV	DX,(Offset OPMSG)
	CALL	PMSG			;PRINT "CAN'T FIND KEYMAP"
	JMP	EXIT			;EXIT TO MS-DOS
OPENED:	MOV	DX,(Offset CFCB)
	MOV	BX,DX
	MOV	AX,16[BX]		;GET FILE SIZE
	MOV	14[BX],AX		;USE AS RECORD SIZE
	MOV	RECSIZ,AX		;ALSO, SAVE SIZE
	MOV	AH,READF
	INT	21H			;READ THE FILE
	OR	AL,AL			;TEST READ OPERATION
	JZ	GDREAD			;OK
	MOV	DX,Offset BADRD
	CALL	PMSG			;ELSE, SAY "BAD READ"
	JMP	EXIT			;AND EXIT

;	ASK FOR STATUS LINE MESSAGE

GDREAD:	MOV	DX,(Offset BLINEM)
	CALL	PMSG			;ASK FOR BOTTOM LINE
	MOV	AL,5
	CALL	RDCON			;GET REPLY
	JZ	NOSTLN			;NO STATUS LINE
	LODSB				;GET ENTRY
	AND	AL,5FH			;CAPITALIZE
	CMP	AL,'Y'			;YES?
	JZ	STATLN
NOSTLN:	MOV	BX,(Offset CBUF)+(Offset BLMSG)
	MOV	M,0			;CLEAR STATUS LINE MESSAGE
	JMP	NBLINE			;NO BOTTOM LINE

;	GET STATUS LINE MESSAGE

STATLN:	MOV	DX,(Offset PRMSG)
	CALL	PMSG			;PROMPT FOR ENTRIES
	MOV	BX,(Offset CBUF)+(Offset BLMSG)+2
	PUSH	BX			;BX POINTS TO MSG BUFFER
	MOV	CL,1			;SET A COUNTER
GELP:	MOV	DX,(Offset ENMSG)
	CALL	PMSG			;PRINT "ENTER"
	MOV	AL,CL
	CMP	AL,10			;COUNT LESS THAN 10?
	JB	LT10			;YES
	MOV	DL,'1'
	MOV	AH,CONOUT
	INT	21H			;ELSE PRINT "1"
	MOV	AL,CL
	SUB	AL,10
LT10:	MOV	DL,AL
	ADD	DL,'0'			;ADD ASCII TO COUNT
	MOV	AH,CONOUT
	INT	21H			;PRINT COUNT
	MOV	DX,Offset ENMSG1
	CALL	PMSG			;PRINT COLON PROMPT
	MOV	AL,7
	CALL	RDCON			;GET REPLY
	JZ	SKIP			;NULL ENTRY, SKIP IT
	MOV	CH,AL			;GET CHAR COUNT OF ENTRY
	PUSH	CX			;SAVE IT
	MOV	CX,6
	MOV	DI,BX
	MOV	AL,' '			;GET A SPACE
	REP	STOSB			;CLEAR OLD ENTRY
	POP	CX			;RESTORE COUNT
	CALL	MOVE			;MOVE ENTRY INTO BUFFER
SKIP:	POP	BX
	ADD	BX,8			;UPDATE POINTER
	PUSH	BX
	INC	CL
	CMP	CL,11			;DONE?
	JNZ	GELP			;IF NOT, LOOP
	POP	BX			;FIX STACK
	CALL	CRLF			;PRINT CR, LF
	CALL	CRLF			;AGAIN
	MOV	AH,15
	INT	10H			;GET ACTIVE PAGE
	MOV	AH,8
	INT	10H			;GET CURRENT ATTRIBUTE
	MOV	BL,AH			;IN BL
	MOV	AH,3
	INT	10H			;GET CURSOR POSITION
	MOV	SI,(Offset CBUF)+(Offset BLMSG)	;POINT TO MSG.
	MOV	CX,80			;WRITE 80 CHARACTERS
	CLD				;ENSURE FORWARD STRING DIRECTION
PBLP:	LODSB				;GET A CHARACTER
	PUSH	CX			;SAVE COUNTER
	PUSH	SI			;SAVE POINTER
	PUSH	DX			;SAVE CURSOR POSITION
	PUSH	AX			;SAVE CHARACTER
	MOV	AH,2
	INT	10H			;SET CURSOR POSITION
	POP	AX			;GET CHARACTER
	POP	DX
	INC	DL			;UPDATE POSITION
	PUSH	DX
	AND	BL,7			;ASSUME NORMAL VIDEO
	OR	AL,AL			;TEST CHARACTER
	JNS	NORVID			;IT'S NORMAL
	OR	BL,8			;ELSE, SET INVERSE VIDEO
	AND	AL,7FH			;STRIP MARKER BIT
NORVID:	MOV	CX,1			;WRITE 1 CHARACTER
	MOV	AH,9
	INT	10H			;WRITE CHARACTER
	POP	DX
	POP	SI
	POP	CX
	LOOP	PBLP			;LOOP UNTIL DONE
	CALL	CRLF
	MOV	AX,9*256+' '		;FUNC. 9, SPACE
	MOV	CX,1
	INT	10H			;PRINT SPACE TO RESET ATTRIBUTE
	MOV	DX,(Offset OKM)
	CALL	PMSG			;ASK FOR OK
	MOV	AL,5
	CALL	RDCON			;GET REPLY
	JZ	NBLINE			;IT'S OK
	LODSB				;GET REPLY
	AND	AL,5FH
	CMP	AL,'N'			;NO?
	JNZ	NBLINE	
	JMP	STATLN			;NOT OK

;	ASK FOR ALTERNATE SELECT KEY

NBLINE:	CALL	CRLF
GETFSK:	MOV	DX,(Offset ASKEYM)
	CALL	PMSG			;PRINT "ENTER FS KEY"
	MOV	AH,DCIN
	INT	21H			;GET 1ST CHARACTER
	CMP	AL,13			;CR?
	MOV	DL,0			;ASSUME IT IS
	JZ	NGOTFSK			;IT IS, NO ALTERNATE KEY
	OR	AL,AL			;FIRST CHARACTER NULL?
	JNZ	GETFSK			;IF NOT, START OVER
	MOV	DX,Offset NULMSG	;ELSE, PRINT "NULL"
	CALL	PMSG
	MOV	AH,DCIN
	INT	21H			;GET NEXT CHARACTER
	CMP	AL,';'			;TEST FOR VALID KEY
	JC	GETFSK
	CMP	AL,'q'+1
	JNC	GETFSK
	MOV	DL,AL			;SAVE IT
	MOV	AH,CONOUT
	INT	21H			;PRINT IT
	MOV	AH,DCIN
	INT	21H			;GET 3RD CHARACTER
	CMP	AL,13			;CR?
	JNZ	GETFSK			;IF NOT, START OVER
NGOTFSK:MOV	Byte Ptr CBUF+ASKEY,DL	;SAVE KEY ENTERED
	OR	DL,DL			;TEST KEY
	JZ	NGOTFS1			;SKIP MARKING OF KEY
	MOV	BX,(Offset MAPTBL)+(Offset CBUF)	;POINT TO MAP TABLE
	SUB	DL,';'			;REMOVE ASCII FROM FUNC. KEY
	ADD	DL,DL			;DOUBLE IT
	MOV	DH,0
	ADD	BX,DX			;BX POINTS TO TABLE ENTRY
	MOV	BX,[BX]			;BX = MAPPED STRING
	MOV	DX,(Offset CBUF)-256
	ADD	BX,DX			;CORRECT FOR LOADED PROGRAM
	OR	M,80H			;SET 8TH BIT (MARK FS KEY)

;	NOW, ENTER THE KEY RESPONSES THEMSELVES

NGOTFS1:MOV	DX,(Offset KEYM)
	CALL	PMSG			;PRINT "ENTER KEYS"
	MOV	BX,(Offset KEYS)
	MOV	Word Ptr KEYMPTR,BX	;SET KEY MESSAGE POINTER
	MOV	BX,(Offset HOME)+(Offset CBUF)
	MOV	Word Ptr RESPTR,BX	;SET RESPONSE POINTER
	MOV	Byte Ptr COUNT,50	;SET COUNTER TO 50 KEYS
GETKLP:	CALL	CRLF			;PRINT CRLF
	MOV	BX,Word Ptr KEYMPTR	;GET KEY MESSAGE POINTER
	CALL	PMSG1			;PRINT PROMPT
	MOV	Word Ptr KEYMPTR,BX	;UPDATE POINTER
	CALL	OPPAR			;PRINT OPEN PARENTHESES
	MOV	BX,Word Ptr RESPTR	;GET RESPONSE POINTER
	MOV	AL,M			;GET FIRST CHARACTER
	ADD	AL,AL			;SHIFT LEFT
	JNB	GETKLPA			;NOT ALTERNATE RESP. KEY
	ROR	AL,1			;FIX CHARACTER
	MOV	M,AL			;REPLACE IT
	MOV	DX,(Offset ALRESM)
	CALL	PMSG			;SAY "ALTERNATE KEY"
	JMP	SHORT GETKLPB
GETKLPA:CALL	PMSG1			;PRINT CURRENT KEY RESPONSE
GETKLPB:CALL	CLPAR			;PRINT CLOSING PARENTHESES
	MOV	AL,21			;ALLOW 20 CHARACTERS
	CALL	RDCON			;INPUT RESPONSE
	JZ	NOCHG			;NO CHANGE
	MOV	Byte Ptr [DI],255	;TERMINATE ENTRY
	MOV	BX,Word Ptr RESPTR	;PUT RESPONSE HERE
	MOV	CH,21			;MOVE 21 CHARACTERS
	CALL	MOVE
	MOV	Word Ptr RESPTR,BX	;UPDATE POINTER
	JMP	SHORT INRCNT		;INCREMENT COUNT
NOCHG:	ADD	Word Ptr RESPTR,21
INRCNT:	CMP	Byte Ptr COUNT,41	;DONE 10 KEYS?
	JNZ	NOT10			;NO
	CALL	CRLF			;ELSE, SKIP A LINE
NOT10:	DEC	Byte Ptr COUNT		;DECREMENT COUNT
	JNZ	GETKLP			;NOT DONE, CONTINUE
	MOV	AL,Byte Ptr CBUF+ASKEY	;GET ALTERNATE RESP. KEY
	OR	AL,AL			;WANT ALTERNATE KEYS?
	JZ	ASKTGL			;NO, ASK ABOUT TOGGLE
	MOV	DX,(Offset ALKEYM)
	CALL	PMSG			;PRINT "ENTER FUNCTION KEYS"
	MOV	BX,(Offset KEYS)
	MOV	Word Ptr KEYMPTR,BX	;SET KEY MESSAGE POINTER
	MOV	BX,(Offset XHOME)+(Offset CBUF)
	MOV	Word Ptr RESPTR,BX	;SET RESPONSE POINTER
	MOV	Byte Ptr COUNT,50	;SET COUNTER
GETKLP1:CALL	CRLF			;PRINT CRLF
	MOV	BX,Word Ptr KEYMPTR	;GET KEY MESSAGE POINTER
	CALL	PMSG1			;PRINT PROMPT
	MOV	Word Ptr KEYMPTR,BX	;UPDATE POINTER
	CALL	OPPAR			;PRINT OPEN PARENTHESES
	MOV	BX,Word Ptr RESPTR	;GET RESPONSE POINTER
	CALL	PMSG1			;PRINT CURRENT KEY RESPONSE
	CALL	CLPAR			;PRINT CLOSING PARENTHESES
	MOV	AL,21			;ALLOW 20 CHARACTERS
	CALL	RDCON			;INPUT RESPONSE
	JZ	NOCHG1			;NO CHANGE
	MOV	Byte Ptr [DI],255	;TERMINATE ENTRY
	MOV	BX,Word Ptr RESPTR	;PUT RESPONSE HERE
	MOV	CH,21			;MOVE 21 CHARACTERS
	CALL	MOVE
	MOV	Word Ptr RESPTR,BX	;UPDATE POINTER
	JMP	SHORT INRCNT1		;INCREMENT COUNT
NOCHG1:	ADD	Word Ptr RESPTR,21
INRCNT1:CMP	Byte Ptr COUNT,41	;DONE 10 KEYS?
	JNZ	NOT101			;NO
	CALL	CRLF			;ELSE, SKIP A LINE
NOT101:	DEC	Byte Ptr COUNT		;DECREMENT COUNT
	JNZ	GETKLP1			;NOT DONE, CONTINUE

;	GET ON/OFF TOGGLE CODE

ASKTGL:	MOV	DX,(Offset TGLKM)
	CALL	PMSG			;ASK FOR TOGGLE CODE
	MOV	AL,5
	CALL	RDCON			;GET ANSWER
	MOV	AL,'^'-'@'		;ASSUME DEFAULT
	JZ	STGLK			;DEFAULT TOGGLE KEY WANTED
	LODSB				;GET ANSWER
	AND	AL,1FH			;MAKE IT A CONTROL CODE
STGLK:	MOV	Byte Ptr CBUF+TGLK,AL	;STORE TOGGLE CODE

;	GET OFF LINE TOGGLE CODE

GOFFLK:	MOV	DX,(Offset OFLNKM)
	CALL	PMSG			;ASK FOR OFF LINE CODE
	MOV	AL,5
	CALL	RDCON			;GET ANSWER
	MOV	AL,'\'-'@'		;ASSUME DEFAULT
	JZ	SOFLNK			;DEFAULT OFF LINE KEY WANTED
	LODSB				;GET ANSWER
	AND	AL,1FH			;MAKE IT A CONTROL CODE
SOFLNK:	MOV	Byte Ptr CBUF+OFFLNK,AL	;STORE OFF LINE CODE

;	NOW, WRITE THE PATCHED KEYMAP TO DISK

WRITE:	CALL	CRLF
	MOV	DI,Offset FCBX		;POINT TO FCB AFTER FILE TYPE
	XOR	AL,AL			;CLEAR AL
	MOV	CX,33-12		;CLEAR THIS MUCH
	REP	STOSB			;CLEAR FCB
	MOV	DX,Offset CFCB
	MOV	AH,DELETF
	INT	21H			;DELETE OLD KEYMAP
	MOV	DX,(Offset CFCB)
	MOV	AH,MAKEF
	INT	21H			;MAKE NEW ENTRY
;	MOV	DX,Offset CFCB
;	MOV	AH,OPENF
;	INT	21H			;OPEN KEYMAP FILE
	MOV	BX,DX			;BX = FCB
	MOV	AX,RECSIZ
	MOV	Word Ptr 14[BX],AX	;PUT RECORD SIZE IN FCB
	MOV	AH,WRITEF
	MOV	DX,(Offset CFCB)
	INT	21H			;WRITE A SECTOR
	MOV	AH,CLOSEF
	MOV	DX,(Offset CFCB)
	INT	21H			;CLOSE FILE
	MOV	DX,(Offset DONEMSG)
	CALL	PMSG			;PRINT "DONE"
EXIT:	MOV	AH,0
	INT	21H			;RETURN TO MS-DOS

;	SUBROUTINES

;	MESSAGE PRINTERS

CRLF:	MOV	DX,(Offset CRLFM)
	JMP	SHORT PMSG
OPPAR:	MOV	DX,(Offset OPPARM)
	JMP	SHORT PMSG
CLPAR:	MOV	DX,(Offset CLPARM)
PMSG:	MOV	AH,TYPEF
	INT	21H			;PRINT MESSAGE
	RET

;	PRINT MESSAGE AT (BX) UNTIL 255 FOUND.  EXPAND CONTROL
;	CHARACTERS TO "^"+CHAR.

PMSG1:	MOV	AL,M			;GET CHARACTER
	INC	BX			;INCREMENT POINTER
	CMP	AL,255			;END OF MESSAGE?
	JNZ	PMSG2	
	RET				;YES
PMSG2:	CMP	AL,' '			;LESS THAN SPACE?
	JNB	PABLE			;NO, PRINTABLE
	OR	AL,AL			;NULL?
	JNZ	NOTESCP			;NO
	MOV	DX,Offset NULMSG	;ELSE, PRINT "NULL"
	CALL	PMSG
	JMP	SHORT PMSG1		;PRINT NEXT CHARACTER
NOTESCP:PUSH	AX			;ELSE, SAVE CHARACTER
	MOV	DL,'^'
	MOV	AH,CONOUT
	INT	21H			;PRINT "^"
	POP	AX			;RESTORE CHARACTER
	ADD	AL,'@'			;ADD ASCII
PABLE:	MOV	DL,AL
	MOV	AH,CONOUT
	INT	21H			;PRINT CHARACTER
	JMP	SHORT PMSG1		;PRINT NEXT CHARACTER

;	READ A LINE FROM THE CONSOLE
;	UPON EXIT, DX, SI = START OF ENTRY AND DI = END OF ENTRY

RDCON:	MOV	Byte Ptr INBUF,AL	;SET IN COUNT
	MOV	DX,(Offset INBUF)	;POINT TO CONSOLE BUFFER
	MOV	AH,LINPUT
	PUSH	DX			;SAVE ADDRESS
	INT	21H			;READ CONSOLE BUFFER
	POP	DX
	INC	DX
	MOV	SI,DX			;GET COUNT
	LODSB
	MOV	DX,SI			;DX, SI = START
	MOV	DI,DX			;DI = START
	MOV	AH,0
	ADD	DI,AX			;ADD COUNT TO DX
	OR	AL,AL			;FLAG Z IF NO INPUT
	RET

;	MOVE CH BYTES FROM DX TO BX 

MOVE:	MOV	SI,DX			;GET A CHARACTER
	MOV	AL,[SI]
	CMP	AL,'^'			;CONTROL CHARACTER?
	JNZ	MOVE1			;NO
	INC	DX			;ELSE, SKIP "^"
	MOV	SI,DX			;GET NEXT CHARACTER
	MOV	AL,[SI]
	AND	AL,5FH			;CAPITALIZE
	SUB	AL,'@'			;MAKE IT A CONTROL CHARACTER
MOVE1:	MOV	M,AL			;MOVE IT IN
	INC	DX
	INC	BX			;INCREMENT POINTERS
	DEC	CH			;DECREMENT COUNTER
	JNZ	MOVE			;LOOP UNTIL DONE
	RET

;	DATA AREA

CONMSG	DB	13,10,'Z-150 KEYMAP Function Key Mapper, '
	DB	'Version 1.0 Configuration Utility',13,10,10
	DB	'Enter the name of the KEYMAP program you want '
	DB	'to configure: $'
BLINEM	DB	13,10,10,'Do you want an on-screen prompt?'
	DB	' (Y or N -- RETURN = N) $'
ASKEYM	DB	13,10
	DB	'Press the key you want to use for alternate '
	DB	'response select, then RETURN.',13,10
	DB	'(Or, RETURN only to disable alternate response): $'
KEYM	DB	13,10,10
	DB	'Enter the response for each key when prompted.'
	DB	13,10
	DB	'The current response will be shown in parentheses.'
	DB	13,10,'$'
ALKEYM	DB	13,10,10
	DB	'Enter the alternate response for each key when '
	DB	'prompted.',13,10,'$'
ALRESM	DB	'** ALTERNATE RESPONSE KEY **$'
KEYS	DB	'HOME',255,'UP ARROW',255,'PAGE UP',255,'LEFT ARROW',255
	DB	'RIGHT ARROW',255,'END',255,'DOWN ARROW',255,'PAGE DOWN',255
	DB	'INSERT',255,'DELETE',255
	DB	'F1',255,'F2',255,'F3',255,'F4',255,'F5',255,'F6',255
	DB	'F7',255,'F8',255,'F9',255,'F10',255
	DB	'SHIFT-F1',255,'SHIFT-F2',255,'SHIFT-F3',255
	DB	'SHIFT-F4',255,'SHIFT-F5',255,'SHIFT-F6',255,'SHIFT-F7',255
	DB	'SHIFT-F8',255,'SHIFT-F9',255,'SHIFT-F10',255
	DB	'CTRL-F1',255,'CTRL-F2',255,'CTRL-F3',255
	DB	'CTRL-F4',255,'CTRL-F5',255,'CTRL-F6',255,'CTRL-F7',255
	DB	'CTRL-F8',255,'CTRL-F9',255,'CTRL-F10',255
	DB	'ALT-F1',255,'ALT-F2',255,'ALT-F3',255
	DB	'ALT-F4',255,'ALT-F5',255,'ALT-F6',255,'ALT-F7',255
	DB	'ALT-F8',255,'ALT-F9',255,'ALT-F10',255
TGLKM	DB	13,10,10
	DB	'Enter on/off toggle code. (RETURN = Control-^) $'
OFLNKM	DB	13,10,10
	DB	'Enter off line toggle code. (RETURN = Control-\) $'
CRLFM	DB	13,10,'$'
OPPARM	DB	' ($'
CLPARM	DB	'): $'
NULMSG	DB	'NULL-$'
PRMSG	DB	13,10,10,'Enter messages for each key as prompted.'
	DB	13,10,'$'
ENMSG	DB	13,10,'Enter message for F$'
ENMSG1	DB	': $'
OKM	DB	13,10
	DB	'Does this look OK? (Y or N -- RETURN = Y) $'
DONEMSG	DB	13,10,'KEYMAP configuration completed.',13,10,'$'
OPMSG	DB	13,10,'ERROR - Can',27H,'t find your KEYMAP program.',13,10,'$'
BADRD	DB	13,10,'ERROR - Can',27H,'t read your KEYMAP program.',13,10,'$'

RECSIZ	DW	0			;KEYMAP FILE RECORD SIZE
KEYMPTR	DW	0			;KEY MESSAGE POINTER
RESPTR	DW	0			;RESPONSE POINTER
COUNT	DB	0			;COUNTER
CFCB	DB	0,'KEYMAP  COM'
FCBX	DB	0,0,0,0
	DB	16 DUP (0)
	DB	0,0,0,0
INBUF	DB	28 DUP (0)		;INPUT BUFFER
	DB	256 DUP (?)		;STACK SPACE
STACK:
CBUF:					;CONFIG BUFFER

;	CONSTANTS IN THE KEYMAP PROGRAM

MAPTBL	EQU	3
HOME	EQU	171H-100H
XHOME	EQU	59AH-100H
BLMSG	EQU	0A33H-100H
ASKEY	EQU	0A27H-100H
TGLK	EQU	0A29H-100H
OFFLNK	EQU	0A2AH-100H
CONF	ENDS
	END	CONFIG
                                                                                     