	TITLE	ZEMULATOR CONTROL PROGRAM
	PAGE	,132
;	SETZEM -- ZEMULATOR CONTROL PROGRAM
;
;	THIS PROGRAM IS USED TO ENABLE AND DISABLE THE ZEMULATOR
;	PROGRAM.  TO DISABLE IT, ENTER
;
;	SETZEM OFF
;
;	TO ENABLE IT, ENTER
;
;	SETZEM
;
;	TO PERMANENTLY DISABLE IT, ENTER
;
;	SETZEM U
;
;	BY P. SWAYNE, HUG  22-OCT-84

TRUE	EQU	-1
FALSE	EQU	NOT TRUE
Z150	EQU	TRUE			;IF TRUE, FULL Z-19 GRAPHICS
					;IF FALSE, WORKS ON IBM
SDOT	EQU	2			;CODE FOR SINGLE DOT MODE

CMDBUF	EQU	80H			;COMMAND BUFFER
INT10V	EQU	539H			;INT 10H VECTOR STORED HERE
ZSTATE	EQU	58EH			;EMULATED TERMINAL STATE FLAGS

SETZ	SEGMENT
	ASSUME	CS:SETZ,DS:SETZ,ES:SETZ,SS:SETZ
	ORG	100H

START:	XOR	AX,AX
	MOV	DS,AX			;POINT TO BOTTOM SEGMENT
	MOV	SI,16H*4		;POINT TO INT 16 VECTOR
	LES	DI,DWORD PTR [SI]	;GET ROUTINE ADDRESS
	CMP	WORD PTR ES:-2[DI],'MZ'	;TEST FOR ZEM ALREADY IN
	PUSH	CS
	POP	DS			;FIX DS
	JNZ	NOTIN			;ZEM NOT LOCATED
	MOV	SI,OFFSET CMDBUF	;POINT TO COMMAND BUFFER
	CLD				;SET FORWARD DIRECTION
	LODSB				;GET CHAR COUNT
	OR	AL,AL			;ANY ENTRY?
	JZ	SETON			;NO, TURN ON
SOB:	LODSB				;ELSE, GET NEXT CHAR
	CMP	AL,' '			;SPACE?
	JZ	SOB			;YES, SKIP SPACES
	AND	AL,5FH			;CAPITALIZE
	CMP	AL,'O'			;OFF?
	JZ	SETOFF			;YES
	CMP	AL,'U'			;UNLOAD?
	JZ	UNLOAD			;YES
SETON:	CALL	TGLON			;ELSE, TOGGLE ZEM ON
EXIT:	INT	20H			;AND EXIT
SETOFF:	CALL	TGLOFF			;TOGGLE ZEM OFF
	INT	20H			;AND EXIT
NOTIN:	MOV	DX,OFFSET NOTMSG
	MOV	AH,9
	INT	21H			;SAY "ZEM NOT IN"
	INT	20H

;	UNLOAD ZEM

UNLOAD:	CALL	TGLOFF			;TOGGLE ZEM OFF
	PUSH	ES
	POP	DS			;PUT DS IN ZEM SEGMENT
	XOR	AX,AX
	MOV	ES,AX			;PUT ES AT BOTTOM
	MOV	SI,OFFSET INT10V	;POINT TO INT 10H ADDRESS
	MOV	DI,10H*4		;IT GOES HERE
	MOVSW				;MOVE IT IN
	MOVSW
	MOV	DI,16H*4		;POINT TO INT 16H  ADDRESS
	MOVSW				;MOVE IT IN
	MOVSW
	MOV	DI,21H*4		;POINT TO INT 21H ADDRESS
	MOVSW				;MOVE IT IN
	MOVSW
	INT	20H			;EXIT

;	TOGGLE ZEM ON

TGLON:	MOV	BYTE PTR ES:-3[DI],1	;FLAG ZEM ON
	MOV	DI,OFFSET ZSTATE
	MOV	CX,15
	MOV	AL,0			;CLEAR STATE FLAGS
	REP	STOSB
	MOV	BYTE PTR ES:-8[DI],7	;SET FOREGROUND ATTRIBUTE
	MOV	WORD PTR ES:[DI],707H	;SET DEFAULT CURSOR
	MOV	AH,0
	MOV	AL,3			;80X25 COLOR
	INT	10H
	MOV	AH,1
	MOV	CH,7			;SINGLE UNDERLINE CURSOR
	MOV	CL,7
	INT	10H
	MOV	AH,5
	MOV	AL,0			;ACTIVE PAGE IS 0
	INT	10H
	MOV	AX,600H
	MOV	BH,7			;DEFAULT ATTRIBUTE
	MOV	CX,0
	MOV	DH,24			;CLEAR SCREEN
	MOV	DL,79
	INT	10H
	MOV	AH,2
	MOV	DX,0			;HOME CURSOR
	MOV	BH,0
	INT	10H
	IF	Z150
	MOV	DX,3DAH
	MOV	AL,SDOT
	OUT	DX,AL			;SET SINGLE DOT MODE
	ENDIF
	RET

;	TOGGLE ZEM OFF

TGLOFF:	MOV	BYTE PTR ES:-3[DI],0	;FLAG ZEM OFF
	MOV	AH,1
	MOV	CH,6			;SET DOUBLE UNDERLINE CURSOR
	MOV	CL,7
	INT	10H
	MOV	AH,5
	MOV	AL,0			;ACTIVE PAGE IS 0
	INT	10H
	MOV	AX,600H
	MOV	BH,7
	MOV	CX,0
	MOV	DH,24			;CLEAR SCREEN
	MOV	DL,79
	INT	10H
	MOV	AH,2
	MOV	DX,0			;HOME CURSOR
	MOV	BH,0
	INT	10H
	IF	Z150
	MOV	DX,3DAH
	MOV	AL,0
	OUT	DX,AL			;SET DOUBLE DOT MODE
	ENDIF
	RET

NOTMSG	DB	13,10,'ERROR -- ZEMulator cannot be located.$'
SETZ	ENDS
	END	START
                                                                                                    