; BIN2HEX
;
; Utility to convert .COM or other binary files
; to Intel HEX format.
;
; by P. Swayne, HUG    24-Jul-81
;	Adapted from IHEX from 885-1089
;	MS-DOS TRANSLATION 01-DEC-87
;	THIS VERSION IS MS-DOS 1 COMPATIBLE

M	EQU	BYTE PTR 0[BX]
CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	5CH
FCB	LABEL	BYTE			;DEFINE FCB
	ORG	80H
DTA	LABEL	BYTE			;DEFINE DTA
	ORG	100H
START:	CMP	FCB+1,' '		;ANY ARGUMENT?
	JNZ	GOTARG			;YES
	MOV	DX,OFFSET EXPL
	MOV	AH,9
	INT	21H			;ELSE, EXPLAIN PROGRAM
	INT	20H			;AND EXIT
GOTARG:	MOV	CX,9
	MOV	SI,OFFSET (FCB)		;FCB
	MOV	DI,OFFSET (DFCB)	;DESTINATION FCB
	CLD
	REP	MOVSB			;COPY FILE NAME
	MOV	AL,BYTE PTR FCB+9	;CHECK TYPE
	CMP	AL,20H			;IS THERE ONE?
	JNZ	GOTTYP			;IF SO, CONTINUE
	MOV	WORD PTR FCB+9,'OC'
	MOV	BYTE PTR FCB+11,'M'	;STORE "COM" AS TYPE
GOTTYP:	MOV	AL,FCB+16		;GET POSSIBLE DESTINATION DRIVE
	OR	AL,AL			;GOT ONE
	JZ	NODRIVE			;NO
	MOV	DFCB,AL			;ELSE, STORE IN DEST. FCB
NODRIVE:CMP	FCB+17,' '		;TEST FOR SPECIFIED ADDRESS
	JZ	NOADDR			;NONE
	MOV	SI,OFFSET FCB+17
	CALL	HEXIN			;ELSE, GET IT
	MOV	STADR,BX		;SAVE IT
	MOV	OUTADR,BX		;HERE, TOO
NOADDR:	MOV	DX,OFFSET (FCB)		;FCB
	MOV	AH,15			;OPEN
	INT	21H			;OPEN INPUT FILE
	INC	AL
	JNZ	GDFILE			;OPEN OK
	MOV	AH,9
	MOV	DX,OFFSET (NOINFL)
	INT	21H
	INT	20H			;RETURN TO CP/M
GDFILE:	MOV	FCB+32,0		;CLEAR CURRENT RECORD
	MOV	AX,WORD PTR FCB+16	;GET FILE SIZE
	MOV	WORD PTR FCB+14,AX	;SAVE AS RECORD SIZE
	ADD	AX,OFFSET RDBUFF	;ADD SIZE TO BUFFER START
	MOV	RDEND,AX		;SAVE AS END ADDRESS
	MOV	DX,OFFSET RDBUFF
	MOV	AH,1AH
	INT	21H			;SET DTA TO READ BUFFER
	MOV	DX,OFFSET (FCB)		;FCB
	MOV	AH,20			;READ INPUT FILE
	INT	21H
	OR	AL,AL
	JZ	GOODRD			;READ OK
	MOV	DX,OFFSET NOREAD
	MOV	AH,9
	INT	21H			;SAY "CAN'T READ"
	INT	20H
GOODRD:	MOV	DX,OFFSET DTA
	MOV	AH,1AH
	INT	21H			;SET DTA TO NORMAL ADDRESS
	MOV	DX,OFFSET (DFCB)
	MOV	AH,19			;DELETE
	INT	21H
	MOV	DX,OFFSET (DFCB)
	MOV	AH,22
	INT	21H			;OPEN OUTPUT FILE
	CMP	AL,0FFH			;OK?
	JNZ	TRANST
	MOV	DX,OFFSET (NODIR)
	MOV	AH,9
	INT	21H
	INT	20H

; PREPARE FOR TRANSLATION

TRANST:	MOV	WORD PTR DFCB+14,1	;SET WRITE RECORD SIZE TO 1 BYTE

; Start a hex record.

TRAN:	XOR	AL,AL
	MOV	BYTE PTR CHKSUM,AL
	MOV	DI,OFFSET DTA
	MOV	AL,':'			;INSERT RECORD START MARK
	STOSB
	MOV	WPTR,DI			;UPDATE WRITE POINTER

; Calculate and output record length.

CHEOF:	MOV	AX,RPTR			;GET READ POINTER
	CMP	AX,RDEND		;AT END OF FILE?
	JZ	TRAN04			;IF SO, FINISH
	CALL	GET16			;GET 16 BYTES
	MOV	AL,CH			;COUNT TO AL
TRAN01:	CALL	OBYTE			;Output length

; Output address pointer.

	MOV	BX,WORD PTR OUTADR
	MOV	AL,BH
	CALL	OBYTE			;Output msb's
	MOV	AL,BL
	CALL	OBYTE			;and lsb's

; OUTPUT DATA TYPE.

	XOR	AL,AL
	CALL	OBYTE

; Output data bytes.

	MOV	SI,OFFSET (BUFF16)
TRAN02:	LODSB				;GET A BYTE
	CALL	OBYTE			;Output byte
	INC	WORD PTR OUTADR		;Increment file address

; Check byte count.

	DEC	CH			;COUNT BYTE
	JNZ	TRAN02			;NOT DONE

; Finish up the data record with checksum.

TRAN03:	MOV	AL,BYTE PTR CHKSUM
	CALL	OBYTE			;Output the checksum
	CALL	WRTREC			;WRITE THE RECORD
	JMP	TRAN			;and send another record

; Output the ending record.

TRAN04:	XOR	AL,AL
	CALL	OBYTE			;Show "last record"
	MOV	BX,STADR		;GET START ADDRESS
	MOV	AL,BH
	CALL	OBYTE			;Output start addr msb's
	MOV	AL,BL
	CALL	OBYTE			;and lsb's
	MOV	AL,1
	CALL	OBYTE			;Show end-of-file
	MOV	AL,BYTE PTR CHKSUM
	CALL	OBYTE			;and checksum
	CALL	WRTREC			;WRITE THE RECORD

; Close the files

TRAN05:	MOV	DX,OFFSET (COMPL)
	MOV	AH,9
	INT	21H
	MOV	DX,OFFSET (DFCB)
	MOV	AH,16			;CLOSE
	INT	21H			;CLOSE OUTPUT FILE
	INT	20H			;RETURN TO CP/M

; Subroutine to Output one BYTE. Adds to checksum and
; converts to hex.
;	Input	   (A) = Byte to move
;		(WPTR) = hex destination address
;	Output	(WPTR) = Next address

OBYTE:	MOV	CL,AL
	SUB	BYTE PTR CHKSUM,AL	;UPDATE CHECKSUM

; Convert msb's to hex.

	MOV	AL,CL
	AND	AL,11110000B
	RCR	AL,1
	RCR	AL,1
	RCR	AL,1
	RCR	AL,1
	CALL	CONHEX
	MOV	DI,WORD PTR WPTR	;GET WRITE POINTER
	STOSB				;Move a nibble
	MOV	AL,CL
	AND	AL,00001111B
	CALL	CONHEX
	STOSB				;Move another nibble
	MOV	WPTR,DI			;UPDATE POINTER
	RET

;	WRITE OUTPUT RECORD

WRTREC:	MOV	DI,WPTR			;GET WRITE POINTER
	MOV	AL,0DH
	STOSB				;STORE A CR
	MOV	AL,0AH
	STOSB				;STORE A LF
	SUB	DI,OFFSET DTA		;CALCULATE RECORD SIZE
	MOV	CX,DI			;SIZE TO CX
	MOV	DX,OFFSET DFCB
	MOV	AH,28H			;USE RANDOM BLOCK WRITE FUNCTION
	INT	21H
	OR	AL,AL			;GOOD WRITE?
	JNZ	BADWRT			;NO
	RET				;ELSE, RETURN
BADWRT:	MOV	DX,OFFSET NOWRIT
	MOV	AH,9
	INT	21H
	INT	20H			;RETURN TO CP/M

; Subroutine to convert a 4-bit nibble to
; ASCII hex

CONHEX:	ADD	AL,90H
	DAA
	ADC	AL,40H
	DAA
	RET

; Get 16 (or all remaining) bytes from input file
; Store them in a special buffer.  CH = bytes input.

GET16:	MOV	DI,OFFSET (BUFF16)	;POINT TO 16-BYTE BUFFER
	MOV	SI,WORD PTR RPTR	;AND TO READ BUFFER
	MOV	CH,0			;CLEAR A COUNTER
GETLP:	CMP	SI,RDEND		;AT END OF FILE?
	JZ	GETEND			;YES
	LODSB				;GET A BYTE
	STOSB				;STORE IT
	INC	CH
	CMP	CH,16			;16 BYTES READ?
	JNZ	GETLP
GETEND:	MOV	WORD PTR RPTR,SI	;UPDATE READ POINTER
	RET

;	INPUT ASCII HEX NUMBERS. SI POINTS TO STRING.
;	RESULT IN BX.

HEXIN:	XOR	BX,BX			;CLEAR ACCUMULATOR
HEXLP:	LODSB				;GET DIGIT
	SUB	AL,'0'			;REMOVE ASCII
	JC	HEXEND			;LESS THAN "0"
	ADD	AL,'0'-'G'
	JC	HEXEND			;MORE THAN "F"
	ADD	AL,6			;TEST FOR A-F
	JNS	HEXOK			;DIGIT IS A-F
	ADD	AL,7			;TEST FOR 0-9
	JC	HEXEND			;DIGIT OUT OF RANGE
HEXOK:	ADD	AL,10			;ELSE, ADJUST
	PUSH	AX			;SAVE DIGIT
	MOV	AX,BX
	MOV	DX,16
	MUL	DX			;MULTIPLY ACCUMULATOR BY 16
	MOV	BX,AX
	POP	AX
	OR	BL,AL			;ADD IN LATEST DIGIT
	JMP	HEXLP			;GET ANOTHER ONE
HEXEND:	RET

; Buffer areas and variables.

EXPL	DB	13,10,'To use this program, enter',13,10,10
	DB	'  BIN2HEX filespec [d:][start addr]',13,10,10
	DB	'where d: is the destination drive (if not',13,10
	DB	'the source drive), and start addr is',13,10
	DB	'the start address (if not 100H).',13,10,'$'
NOINFL 	DB	13,10,"Can't find input file.$"
NODIR 	DB	13,10,'No directory space.$'
NOREAD 	DB	13,10,"Can't read input file.$"
NOWRIT 	DB	13,10,"Can't write output file.$"
COMPL 	DB	13,10,'Conversion complete.',13,10,'$'

DFCB 	DB	0			;Destination filename buffer
	DB	'        HEX'
	DB	0,0,0,0,0,0,0,0
	DB	12H DUP (0)
RPTR 	DW	OFFSET RDBUFF		;Read Pointer
RDEND	DW	0			;END OF FILE READ
WPTR 	DW	0			;Write Pointer
CHKSUM 	DB	0			;Checksum accumulator
BUFF16 	DB	16 DUP (?)		;Buffer for 16 bytes
STADR	DW	100H			;STARTING ADDRESS OF FILE
OUTADR 	DW	100H			;OUTPUT ADDRESS POINTER
RDBUFF	LABEL	NEAR			;READ BUFFER START

CODE	ENDS
	END	START
