	PAGE	,132
;	D.COM - MS-DOS DIRECTORY PROGRAM
;
;	THIS DIRECTORY PROGRAM MAKES USE OF BLOCK GRAPHICS TO
;	PRODUCE AN EASY-TO-READ DIRECTORY LISTING.
;
;	BY P. SWAYNE, HUG  25-JAN-83
;
;	SHELL-METZNER SORT FROM HUG SORTER BY W. MOSS
;
;	Z-DOS VERSION BY P. SWAYNE  13-DEC-83
;	Z-150 MODS  17-MAY-84  02-JUN-84
;	VERSION 2 (FOR MS-DOS 2 AND ABOVE)  12-FEB-87
;	VERSION 2.1  21-DEC-87
;
;	THIS PROGRAM WAS BUILT UP FROM THE SDIR PROGRAM
;		by Keith Petersen, W8SDZ
;
;	PRINTS A 4-WIDE DIRECTORY, SORTED ALPHABETICALLY
;
;	A:D pathname[/s]
;
;	or just
;
;	A>D[/s]
;
;	WHERE s IS AN OPTIONAL SWITCH AS FOLLOWS:
;
;	SWITCH		ACTION
;	H		SHOW HELP
;	N		DO NOT ALPHABETIZE
;	S		SHOW SYSTEM/HIDDEN FILES AND FLAGS (EX. ARCHIVE)
;	A		SHOW ALL FILES AND FLAGS (INC. ARCHIVE)
;	D		SHOW ONLY DIRECTORY NAMES
;
;	YOU CAN COMBINE THE N SWITCH WITH ANY OF THE OTHERS
;
FGC	EQU	7			;FOREGROUND COLOR
BGC	EQU	0			;BACKGROUND COLOR
HFGC	EQU	0			;HIGHLIGHT FOREGROUND COLOR
HBGC	EQU	7			;HIGHLIGHT BACKGROUND COLOR
;
;	SYSTEM EQUATES
;
RDCHR	EQU	8			;READ CHAR FROM CONSOLE
SELECT	EQU	0EH			;SELECT DISK
SFFO	EQU	11H			;SEARCH FOR FIRST (OLD)
SFF	EQU	4EH			;SEARCH FOR FIRST
SFN	EQU	4FH			;SEARCH FOR NEXT
GDISK	EQU	25			;GET CURRENT DISK
GALLOC	EQU	27			;GET ALLOCATION ADDRESS
VER	EQU	48			;GET MS-DOS VERSION
DFREE	EQU	54			;GET DRIVE FREE SPACE
DMA	EQU	80H			;DEFAULT DMA ADDRESS

M	EQU	Byte Ptr 0[BX]		;DEFINE MEMORY REGISTER

ROM	SEGMENT AT 0FE01H		;Z-100 ROM SEGMENT
	ORG	19H
ROMOUT	LABEL	FAR			;DEFINE ROM OUTPUT
ROM	ENDS

CODE	SEGMENT
	ASSUME CS:CODE,SS:CODE,DS:CODE,ES:CODE
	ORG	100H

START:	JMP	SHORT BEGIN
DFATTR	DB	(BGC SHL 4)+FGC		;DEFAULT ATTRIBUTE
HIATTR	DB	(HBGC SHL 4)+HFGC	;HIGHLIGHT ATTRIBUTE
BEGIN:	MOV	AH,VER
	INT	21H			;CHECK VERSION
	CMP	AL,2			;2.0?
	JNB	VEROK			;OK
	INT	20H			;ELSE, EXIT
VEROK:	MOV	BX,0FFH			;INITIALIZE A POINTER
FNDMEM:	DEC	BH			;MOVE DOWN ONE PAGE
	MOV	AL,[BX]			;GET DATA THERE
	INC	BYTE PTR [BX]		;TRY TO CHANGE MEMORY
	CMP	AL,[BX]			;SEE IF IT CHANGED
	PUSHF
	DEC	BYTE PTR [BX]		;FIX MEMORY
	POPF
	JZ	FNDMEM			;NO CHANGE, NOT MEMORY
	CLI
	PUSH	CS
	POP	SS			;PUT SS HERE
	MOV	SP,BX			;SET STACK TO TOP OF MEMORY
	STI
	SUB	BX,512			;SUBTRACT STACK SPACE
	MOV	MEMLIM,BX		;SAVE AS MEMORY LIMIT
	MOV	AL,DFATTR
	MOV	ATTR,AL			;SET ATTR
	AND	AL,77H			;REMOVE INTENSITY, ETC.
	MOV	AH,AL			;COPY TO AH
	MOV	CL,4
	SHR	AH,CL			;SHIFT HIGH NIBBLE DOWN
	AND	AL,0FH			;ISOLATE LOW
	MOV	BX,OFFSET COLTBL
	XCHG	AL,AH
	XLAT				;TRANSLATE COLORS TO Z-100 VALUES
	XCHG	AL,AH
	XLAT
	ADD	AX,3030H		;MAKE IT ASCII
	MOV	ZATTR,AX		;SET Z-100 COLORS
	OR	AH,80H			;SET HI BIT ON BACKGROUND
	MOV	WORD PTR ZATTR1,AX	;OTHER Z-100 COLOR PLACE
	MOV	AL,HIATTR
	AND	AL,77H
	MOV	AH,AL			;COPY TO AH
	MOV	CL,4
	SHR	AH,CL			;SHIFT HIGH NIBBLE DOWN
	AND	AL,0FH			;ISOLATE LOW
	XCHG	AL,AH
	XLAT				;TRANSLATE COLORS TO Z-100 VALUES
	XCHG	AL,AH
	XLAT
	ADD	AX,3030H		;MAKE IT ASCII
	OR	AH,80H
	MOV	WORD PTR ZHATTR,AX	;SET Z-100 HIGHLIGHT COLORS
	MOV	AX,40H
	MOV	DS,AX
	MOV	SI,0
	MOV	AL,[SI]			;GET FIRST BIOS RAM BYTE
	PUSH	CS
	POP	DS			;FIX DS
	CMP	AL,0E9H			;Z-100?
	JZ	Z100			;YES
	MOV	BYTE PTR CTYPE,0	;IT'S PC
	CALL	IBMRST			;RESET SCREEN
	JMP	SHORT NZ100
Z100:	CALL	TYPTX
	DB	27,'m'
ZATTR	DW	3137H			;SET COLORS
	DB	27,'E'+80H		;CLEAR SCREEN
NZ100:	MOV	BYTE PTR FLAGS,11H	;SHOW NORMAL, R/O, DIR
	MOV	WORD PTR BA.PATH,0	;CLEAR PATH STORAGE AREA
	MOV	WORD PTR BA.PATH2,0	;AND SECOND PATH AREA
	CLD				;CLEAR DIR. FLAG
	MOV	SI,OFFSET DMA		;POINT TO INPUT ARG.
	LODSB				;GET COUNT
	OR	AL,AL			;ANY ARGUMENT?
	JNZ	GOTARG			;YES
	MOV	BYTE PTR [SI],0		;ELSE, CLEAR ARGUMENT
	MOV	BX,1			;SET COUNT TO 1
	MOV	BYTE PTR WCFLG,1	;FLAG WILD CARDS
	JMP	PRSARG			;AND CONTINUE
GOTARG:	XOR	AH,AH			;IN AX
	MOV	BX,AX			;IN BX, TOO
	MOV	CX,AX			;ALSO CX
	MOV	BYTE PTR [BX.SI],0	;ZERO END OF STRING
	MOV	DI,SI			;POINTER TO DI
	MOV	AL,' '
	REPZ	SCASB			;LOOK FOR NON-SPACE
	DEC	DI			;POINT TO IT
	INC	CX			;FIX COUNT
	INC	CX			;INCLUDE ENDING ZERO IN COUNT
	MOV	BX,CX			;SAVE IN BX
	MOV	SI,DI			;SAVE POINTER, TOO
	MOV	AL,'/'			;NOW, LOOK FOR SWITCHES
	REPNZ	SCASB
	JNZ	PRSARG			;NONE FOUND
	MOV	BYTE PTR -1[DI],0	;KILL SWITCH CHARACTER
	SUB	BX,CX			;FIX COUNT
CHKFLG:	MOV	AL,[DI]			;GET FIRST SWITCH CHARACTER
	CMP	AL,0			;END OF SWITCHES?
	JZ	PRSARG			;YES
	AND	AL,5FH			;CAPITALIZE
	CMP	AL,'H'			;HELP?
	JNZ	CHKNA			;NO, CHECK FOR "N"
	JMP	DOHELP			;ELSE, SHOW HELP
CHKNA:	CMP	AL,'N'			;NO ALPHABETIZE?
	JNZ	CHKSYS			;NO, CHECK FOR "S" FLAG
	MOV	Byte Ptr NFLAG,1	;ELSE, SET NO SORT FLAG
	JMP	SHORT CHKNXT		;CHECK NEXT FLAG
CHKSYS:	CMP	AL,'S'			;SEE SYSTEM FILES?
	JNZ	CHKALL			;NO
	MOV	BYTE PTR FLAGS,0FFH
	JMP	SHORT CHKNXT		;CHECK NEXT FLAG
CHKALL:	CMP	AL,'A'			;SHOW ALL FLAGS?
	JNZ	CHKDIR			;NO
	INC	Byte Ptr CHAFLG		;AND MARK CHECKING ALL
	MOV	BYTE PTR FLAGS,0FFH
	JMP	SHORT CHKNXT
CHKDIR:	CMP	AL,'D'			;SHOW DIRECTORY FILES
	JNZ	PRSARG			;NO
	MOV	Byte Ptr FLAGS,10H	;ELSE, LOOK ONLY FOR DIR NAMES
CHKNXT:	INC	DI			;INCREMENT POINTER
	JMP	SHORT CHKFLG		;AND CHECK FOR MORE FLAGS
PRSARG:	CMP	BX,1			;GOT AN ARGUMENT?
	JZ	NOARG			;IF NOT, SKIP SPACE CHECK
	PUSH	SI
	ADD	SI,BX			;POINT TO END
	DEC	SI			;BACK UP TO LAST CHAR
	DEC	SI
SOES:	MOV	AL,[SI]			;GET LAST CHARACTER
	CMP	AL,' '			;SPACE?
	JNZ	NOTSP			;NO
	MOV	BYTE PTR [SI],0		;ELSE, ZERO IT OUT
	DEC	SI			;BACK UP
	DEC	BX			;COUNT IT
	CMP	BX,1			;USED UP CHARACTERS?
	JNZ	SOES			;IF NOT, TRY AGAIN
NOTSP:	POP	SI
NOARG:	MOV	ARGCNT,BX		;SAVE ARGUMENT COUNT
	MOV	DI,OFFSET BA.PATH2	;STORE PATH HERE
	PUSH	SI			;SAVE SOURCE POINTER
	MOV	CX,BX			;GET COUNT
	REP	MOVSB			;MOVE PATH
	POP	SI			;RESTORE POINTER
	MOV	DI,OFFSET BA.PATH	;STORE PATH HERE
	MOV	WORD PTR -2[DI],0	;CLEAR BEFORE
	PUSH	DI			;SAVE LOCATION
	MOV	CX,BX			;GET COUNT
	REP	MOVSB			;MOVE PATH
	POP	DI
	PUSH	DI			;SAVE POINTER
	MOV	CX,BX			;GET COUNT
	MOV	AL,'?'			;LOOK FOR "?"
	REPNZ	SCASB
	POP	DI
	JNZ	NOQUES			;NOT FOUND
	JMP	SHORT WCFND		;ELSE, FLAG IT
NOQUES:	MOV	CX,BX
	MOV	AL,'*'
	PUSH	DI
	REPNZ	SCASB			;LOOK FOR "*"
	POP	DI
	JNZ	NOSTAR			;NOT FOUND
WCFND:	MOV	BYTE PTR WCFLG,1	;FLAG WILD CARD FOUND
NOSTAR:	ADD	DI,BX			;POINT TO END
	DEC	DI
	DEC	DI			;POINT TO LAST CHARACTER
	MOV	AL,[DI]			;GET IT
	CMP	BX,1			;IS COUNT 1
	JZ	NOSPEC			;IF SO, NEED FILESPEC
	CMP	AL,'.'			;ENDS WITH "."
	JZ	GOTSPEC			;IF SO, SPEC. OK
	CMP	AL,'\'			;ENDS WITH DIR NAME?
	JZ	NOSPEC			;IF SO, NEED FILESPEC
	CMP	AL,':'			;ENDS WITH DRIVE NAME?
	JZ	NOSPEC			;NEED FILESPEC
	PUSH	DI			;ELSE, SAVE MARKER
	MOV	CX,3			;SET A COUNTER
CKWCLP:	DEC	DI			;BACK UP
	CMP	BYTE PTR [DI],'.'	;PERIOD?
	JZ	GOTPER			;YES
	LOOP	CKWCLP
	POP	DI
	JMP	SHORT NOESP		;NO PERIOD, NEED END SPEC.
GOTPER:	POP	DI
	JMP	SHORT GOTSPEC		;PERIOD FOUND, SPEC. OK
NOESP:	INC	DI
	MOV	WORD PTR [DI],'*.'	;ELSE, ADD ".*"
	MOV	BYTE PTR 2[DI],0
	JMP	SHORT GOTSPEC		;WE HAVE A FILESPEC
NOSPEC:	INC	DI			;POINT PAST LAST CHAR
NOSPEC1:MOV	WORD PTR [DI],'.*'	;INSERT "*.*"
	MOV	WORD PTR 2[DI],'*'
GOTSPEC:MOV	AH,GDISK
	INT	21H			;GET CURRENT DISK
	MOV	CURDSK,AL		;SAVE IT
	MOV	SI,OFFSET BA.PATH2	;POINT TO PATH
	CMP	BYTE PTR 1[SI],':'	;DRIVE SPECIFIED?
	JNZ	SEL			;NO, USE CURRENT
	MOV	AL,[SI]			;ELSE, GET SPECIFIED DRIVE
	AND	AL,5FH			;CAPITALIZE
	SUB	AL,'A'			;REMOVE ASCII
SEL:	MOV	DL,AL			;SAVE IN DL
	INC	AL			;MAKE IT 1-N
	MOV	Byte Ptr DLFCBDR,AL	;SAVE IN DISK LABEL FCB
	CALL	TYPTX
	DB	'Drive',' '+80H
	MOV	AL,DL
	ADD	AL,'A'			;MAKE DRIVE ASCII
	CALL	TYPEC			;PRINT DRIVE
	CALL	TYPTX
	DB	':, Search path:',' '+80H
	CMP	BYTE PTR 1[SI],':'	;DRIVE IN PATH?
	JNZ	PPATH			;NO
	INC	SI			;ELSE, SKIP IT
	INC	SI
PPATH:	CMP	BYTE PTR [SI],0		;ANY PATH?
	JNZ	PPATH1			;YES
	MOV	BX,OFFSET NOPATH
	CALL	TYPTX1			;ELSE, SAY NO PATH
	JMP	SHORT PATHE
PPATH1:	LODSB				;GET A CHARACTER
	OR	AL,AL
	JZ	PATHE			;END OF PATH
	CALL	TYPEC			;ELSE, PRINT CHAR
	JMP	PPATH1
PATHE:	MOV	DX,(Offset DLFCB)
	MOV	AH,SFFO
	INT	21H			;SEARCH FOR LABEL
	INC	AL			;GOT ONE?
	JZ	SIZEX			;NO LABEL
GOTLAB:	CALL	TYPTX
	DB	', Label:',' '+80H
	MOV	SI,88H			;POINT TO LABEL
	MOV	CX,11			;CHAR COUNT
PRTLAB:	LODSB				;GET A CHARACTER
	PUSH	SI
	CALL	TYPEC			;PRINT IT
	POP	SI
	LOOP	PRTLAB			;LOOP UNTIL DONE

;	GET DISK SPACE, FREE SPACE

SIZEX:	MOV	DL,DLFCBDR		;GET SELECTED DRIVE
	DEC	DL			;MAKE IT 0-BASED
	MOV	AH,SELECT
	INT	21H			;SELECT DISK
	CALL	BORDER
	PUSH	DS
	MOV	AH,GALLOC
	INT	21H			;GET ALLOCATION TABLE ADDRESS
	MOV	AH,0
	XCHG	CX,DX			;PUT BLOCKS IN CX, BYTES IN DX
	MUL	DX			;COMPUTE MIN. BLOCK SIZE
	POP	DS
	MOV	Word Ptr BSIZE,AX	;SAVE BLOCK SIZE
	MOV	AH,DFREE
	XOR	DL,DL
	INT	21H			;ELSE, GET FREE SPACE FROM SYSTEM
	MOV	AX,BX			;IN AX
OLDVER:	MOV	Word Ptr FREE,AX	;AND FREE BLOCK COUNT
	SUB	DX,AX			;COMPUTE ALLOCATED USE
	MOV	Word Ptr ALLOC,DX	;AND SAVE IT

;LOOK UP THE SPECIFIED PATH AND FILESPEC

GETFST:	MOV	AH,SFF			;GET 'SEARCH FIRST' FNC
	MOV	DX,OFFSET BA.PATH	;GET PATH ADDRESS
	MOV	CL,FLAGS		;GET DESIRED FLAGS
	XOR	CH,CH			;IN CX
	CMP	BYTE PTR WCFLG,0	;WILD CARDS SPECIFIED?
	JNZ	GETFST1			;YES
	CMP	CL,10H			;LOOKING FOR DIR NAMES?
	JZ	GETFST1			;IF SO, DO IT
	MOV	CL,0FFH			;ELSE, LOOK FOR SPECIFIC FILE
	MOV	DX,OFFSET BA.PATH2	;ENSURE NO WILD CARDS
	INT	21H			;LOOK FOR IT
	MOV	BYTE PTR WCFLG,1	;PREVENT LOOP
	JC	GETFST			;NOTHING FOUND
	MOV	SI,OFFSET DMA+21
	TEST	BYTE PTR [SI],10H	;IS ENTRY A DIR NAME?
	JZ	GETFST			;NO, IT'S A REAL FILE
	MOV	SI,OFFSET BA.PATH	;ELSE, POINT TO PATH
	MOV	BX,ARGCNT		;GET ARGUMENT COUNT
	DEC	BX			;BACK UP TO LAST CHAR
	MOV	WORD PTR [BX.SI],'*\'	;ADD "\*.*"
	MOV	WORD PTR 2[BX.SI],'*.'
	MOV	BYTE PTR 4[BX.SI],0
	JMP	GETFST			;AND TRY AGAIN
GETFST1:INT	21H			;LOOK FOR SPEC
	JNC	SOME			;GOT SOME
	JMP	BOTTOM
;
;READ MORE DIRECTORY ENTRIES

MOREDIR:MOV	AH,SFN			;SEARCH NEXT
	MOV	CL,FLAGS		;GET DESIRED FLAGS
	XOR	CH,CH			;IN CX
	MOV	DX,OFFSET BA.PATH
	INT	21H			;READ DIR ENTRY
	JNC	SOME	
	JMP	SPRINT			;NO MORE - SORT & PRINT

;POINT TO DIRECTORY ENTRY 

SOME:	MOV	SI,OFFSET DMA+30	;POINT TO NAME
	MOV	DI,OFFSET FNAME		;EXPAND IT HERE
	MOV	CX,11			;GET A COUNTER
UPN:	LODSB				;GET A CHARACTER
	OR	AL,AL			;END OF NAME?
	JZ	CLEND			;IF SO, CLEAR END
	CMP	AL,'.'			;EXTENSION MARKER?
	JZ	GOTEX			;IF SO, PROCESS EXTENSION
	STOSB				;ELSE, STORE CHARACTER
	LOOP	UPN			;UNTIL ALL DONE
	JMP	SHORT UPNDN		;DONE WITH NAME (SHOULDN'T GET HERE)
GOTEX:	SUB	CX,3			;8 CHARACTERS IN NAME
	JZ	DOEX			;AND ALL WERE USED
	MOV	AL,' '
	REP	STOSB			;ELSE, CLEAR REST OF NAME
DOEX:	MOV	CX,3			;COUNTER FOR EXTENSION
UPEX:	LODSB				;GET A CHARACTER
	OR	AL,AL			;END OF EXT.?
	JZ	CLEND			;IF SO, CLEAR END
	STOSB				;ELSE, STOER CHARACTER
	LOOP	UPEX			;UNTIL DONE
	JMP	SHORT UPNDN		;DONE
CLEND:	MOV	AL,' '
	REP	STOSB			;CLEAR REST OF NAME
UPNDN:	MOV	SI,OFFSET DMA+21	;POINT TO FILE INFO
	MOV	BX,OFFSET FNAME		;AND TO NAME
	MOV	WORD PTR 13[BX],0	;CLEAR DIR MARKER
	MOV	AL,[SI]			;GET ATTRIBUTE BITS
	TEST	AL,10H			;DIRECTORY NAME?
	JZ	NOTDIR			;NO
	MOV	WORD PTR 13[BX],0FFFFH	;ELSE MARK ENTRY
	JMP	SHORT MRKFLG		;MARK FLAG
NOTDIR:	CMP	Byte Ptr FLAGS,10H	;CHECKING ONLY DIRECTORIES?
	JZ	MOREDIR			;IF SO, SKIP THIS ENTRY
	JMP	SHORT TSTNRM
MRKFLG:	CMP	Byte Ptr FLAGS,10H	;ONLY DIRECTORIES?
	JZ	NOTEXT			;YES, NO FLAGS
TSTNRM:	CMP	BYTE PTR FLAGS,11H	;NORMAL VIEW?
	JZ	NOTEXT			;NO FLAGS HERE, TOO
	CMP	AL,20H			;ARCHIVE ONLY?
	JNZ	NOT20H			;NO
	CMP	Byte Ptr CHAFLG,0	;DISPLAYING ALL?
	JZ	NOTEXT			;NO, SKIP THIS ENTRY
NOT20H:	PUSH	BX			;SAVE POINTER
ATLP:	SHR	AL,1			;TEST FOR AN ATTRIBUTE BIT
	JNC	NOAT			;NONE IN THIS PLACE
	OR	M,80H			;ELSE, MARK IT
NOAT:	INC	BX			;INCREMENT POINTER
	OR	AL,AL			;DONE WITH BITS?
	JNZ	ATLP			;IF NOT, LOOP
	POP	BX			;ELSE, RESTORE POINTER
NOTEXT:	MOV	AX,5[SI]		;GET FILE SIZE
	MOV	11[BX],AX		;PUT IT HERE
	CMP	WORD PTR 13[BX],0FFFFH	;DIR ENTRY?
	JZ	MOVEN
	MOV	AX,7[SI]		;MOVE HIGH WORD, TOO
	AND	AX,3FFFH		;MASK FILE SIZE TO 30 BITS
	MOV	13[BX],AX

;MOVE ENTRY TO TABLE

MOVEN:	MOV	AX,CS
	MOV	ES,AX			;PUT ES HERE
	MOV	SI,BX			;PUT ENTRY ADDR IN SI
	MOV	DI,Word Ptr NEXTT	;PUT NEXT TABLE ENTRY IN DI
	CMP	DI,WORD PTR MEMLIM	;SPACE USED UP?
	JNB	SPRINT			;IF SO, PRINT NOW
	MOV	CX,15			;MOVE 15 CHARACTERS
	REP	MOVSB			;MOVE THE ENTRY
	MOV	Word Ptr NEXTT,DI	;UPDATE TABLE ADDRESS
	INC	Word Ptr COUNT		;INCREMENT COUNT
	JMP	MOREDIR
;
;SORT AND PRINT

SPRINT:	CMP	Word Ptr COUNT,0	;ANY FILES?
	JNZ	SPRINT1			;YES
	JMP	BOTTOM			;ELSE, DONE
SPRINT1:CMP	Byte Ptr NFLAG,0	;NO ALPHABETIZING WANTED?
	JZ	DOSORT			;NO, DO SORT
	JMP	DONE			;ELSE, DONE
DOSORT:	MOV	BX,OFFSET BA.ORDER	;INITIALIZE POINTERS
	MOV	DX,OFFSET BA.TABLE
	MOV	CX,15			;ENTRY LENGTH

;BUILD ORDER TABLE

BLDORD:	MOV	AX,Word Ptr COUNT	;GET COUNT OF FILES
BLDORD1:MOV	Word Ptr [BX],DX	;SAVE ORD ADDR
	INC	BX
	INC	BX
	ADD	DX,CX			;POINT TO NEXT ENTRY
	DEC	AX			;MORE?
	JNZ	BLDORD1			;..YES
	MOV	Word Ptr NEXTT,Offset BA.ORDER	;SET TABLE POINTER
	MOV	AX,Word Ptr COUNT	;GET COUNT
	MOV	Word Ptr SCOUNT,AX	;SAVE AS # TO SORT
	DEC	AX			;ONLY 1 ENTRY?
	JNZ	SORT			;NO, DO SORT
	JMP	DONE			;ELSE, DONE

; SHELL-METZNER STRING SORTING ROUTINE
;	ENTRY:  'SCOUNT' = NUMBER OF STRINGS TO BE SORTED
;		('NEXTT') = START OF POINTER TABLE
;		   POINTER TABLE MADE UP OF A SERIES OF 16 BIT ADDRESSES
;		   POINTING TO THE POSITION IN THE DATA TABLE FOR EACH
;		   OF THE ITEMS TO BE SORTED.
;	EXIT:	POINTER TABLE REARRANGED TO POINT TO STRINGS IN ALPHABETICAL ORDER.
;		STRING DATA TABLE IS UNCHANGED.
;		'SCOUNT' = NUMBER OF STRINGS SORTED. (UNCHANGED)
;		'VARM' = 0.

SORT:	MOV	BX,Word Ptr SCOUNT
	MOV	Word Ptr VARM,BX
SETM:	MOV	BX,Word Ptr VARM
	SHR	BX,1
	MOV	Word Ptr VARM,BX	;VARM = VARM / 2 
	CMP	BX,0
	JNZ	NOTEND	
	JMP	DONE			;IF END OF SORT
NOTEND:	MOV	BX,1
	MOV	Word Ptr VARJ,BX	;VARJ = 1
	MOV	BX,Word Ptr SCOUNT
	MOV	DX,Word Ptr VARM
	SUB	BX,DX
	MOV	Word Ptr VARK,BX	;VARK = SCOUNT - VARM
SETI:	MOV	BX,Word Ptr VARJ
	MOV	Word Ptr VARI,BX	;VARI = VARJ
SETL:	MOV	BX,Word Ptr VARI
	MOV	DX,Word Ptr VARM
	ADD	BX,DX
	MOV	Word Ptr VARL,BX	;VARL = VARI + VARM
	CALL	SYMVAL			;BX = START OF DATA POINTED BY VARL
	PUSH	BX
	MOV	BX,Word Ptr VARI
	CALL	SYMVAL
	POP	SI
	MOV	CL,15			;*GET STRING LENGHT
	DEC	BX			;*PRE-DECREMENT POINTERS
	DEC	SI			;*
SCOMP:	INC	BX
	INC	SI			;BX & SI POINT TO START OF LABEL STRINGS
	MOV	AL,[SI]
	AND	AL,7FH			;STRIP ATT. BIT
	MOV	AH,M
	AND	AH,7FH
	CMP	AL,AH			;COMPARE STRINGS
	JNZ	NOMACH			;IF NO MATCH
	DEC	CL
	JNZ	SCOMP
NOMACH:	JNB	SETJ			;IF NO REARRANGEMENT REQUIRED

; SWITCH THE POINTER ADDRESS AT (VARI) WITH THAT AT (VARL)

	MOV	BX,Word Ptr VARI
	CALL	TABADD
	PUSH	BX			;STACK = POINTER DATA FOR (VARI)
	MOV	BX,Word Ptr VARL
	CALL	TABADD			;BX = POINTER DATA FOR (VARL)
	POP	SI
	MOV	AX,[SI]
	MOV	DX,[BX]
	MOV	[SI],DX
	MOV	[BX],AX

; SWITCH COMPLETED

	MOV	BX,Word Ptr VARI
	MOV	DX,Word Ptr VARM
	SUB	BX,DX
	MOV	Word Ptr VARI,BX	;VARI = VARI - VARM
	DEC	BX
	JS	SETJ	
	JMP	SETL			;IF VARI >= 1
SETJ:	MOV	BX,Word Ptr VARJ
	INC	BX
	MOV	Word Ptr VARJ,BX	;VARJ = VARJ + 1
	MOV	DX,Word Ptr VARK
	SUB	DX,BX
	JNB	SETJ0	
	JMP	SETM			;IF VARJ > VARK
SETJ0:	JMP	SETI

; TABADD -- FIND LOCATION OF DATA POINTER IN TABLE
;	ENTRY: BX = INTEGER VALUE ( 1 -> N )
;	EXIT:  BX = ADDR OF TWO BYTE DATA POINTER ( FOR INPUT VALUE )

TABADD:	DEC	BX			;START AT ZERO
	SHL	BX,1			;BX = [(ORIGINAL BX) - 1] * 2
	MOV	DX,Word Ptr NEXTT
	ADD	BX,DX
	RET

; SYMVAL -- FIND DATA RELATED TO INPUT INTEGER VALUE IN ARRAY
;	ENTRY: BX = INTEGER VALUE ( 1 -> N ) POINTING TO DATA ARRAY
;	EXIT:  BX = FWA STRING DATA FOR THAT VALUE

SYMVAL:	CALL	TABADD
	MOV	BX,[BX]
	RET

;SORT IS ALL DONE - PRINT ENTRIES

DONE:	MOV	CL,20			;SET A COUNTER
	CMP	Byte Ptr NFLAG,0	;DIRECTORY SORTED?
	JZ	ENTRY			;YES
	MOV	BX,OFFSET BA.TABLE-15
	MOV	Word Ptr NEXTT,BX	;ELSE, PUT TABLE IN NEXTT
;
;PRINT AN ENTRY

ENTRY:	CMP	Byte Ptr NFLAG,0	;DIRECTORY SORTED?
	JZ	ENTRY1			;YES
	MOV	BX,Word Ptr NEXTT	;ELSE, GET ENTRY ADDRESS
	ADD	BX,15			;ADD 15
	MOV	Word Ptr NEXTT,BX	;UPDATE POINTER
	XCHG	BX,DX			;DX = ADDRESS
	JMP	SHORT ENTRY2
ENTRY1:	MOV	BX,Word Ptr NEXTT	;GET ORDER TABLE POINTER
	MOV	DX,Word Ptr [BX]	;GET ADDRESS
	INC	BX
	INC	BX
	MOV	Word Ptr NEXTT,BX	;SAVE UPDATED TABLE POINTER
ENTRY2:	MOV	BX,Word Ptr COLADR	;GET COLUMN MOVER STRING
	CALL	TYPTX1			;PRINT IT
	XCHG	BX,DX			;TABLE ENTRY TO BX
	PUSH	BX			;SAVE ENTRY ADDRESS
	MOV	CH,8			;FILE NAME LENGTH
	CALL	TYPEIT			;TYPE FILENAME
	CALL	PERIOD			;PERIOD AFTER FN
	MOV	CH,3			;GET THE FILETYPE
	CALL	TYPEIT
	CMP	WORD PTR 2[BX],0FFFFH	;DIR ENTRY?
	JNZ	NOTDE			;NO
	MOV	BX,OFFSET DIR
	MOV	CH,6
	CALL	TYPEIT			;ELSE, MARK DIR
	JMP	ICNT
NOTDE:	MOV	AX,[BX]			;GET FILE SIZE LOW
	ADD	Word Ptr USED,AX	;UPDATE USED SPACE
	PUSH	AX			;SAVE SIZE LOW
	MOV	AX,2[BX]
	ADC	Word Ptr USEDH,AX
	POP	BX			;GET SIZE LOW IN BX
	MOV	DX,(Offset SPACES)	;POINT TO SPACES
	CMP	AX,0			;HUGE FILE?
	JZ	SMFILE			;NO
	ADD	DX,4			;ELSE, ELIMINATE SOME SPACES
	JMP	SHORT PSIZE		;AND PRINT SIZE
SMFILE:	CMP	BX,10			;LESS THAN 10 BYTES?
	JB	PSIZE			;YES, PRINT SIZE
	INC	DX			;NO, REMOVE 1 SPACE
	CMP	BX,100			;LESS THAN 100 BYTES?
	JB	PSIZE			;YES
	INC	DX			;NO, REMOVE 1 SPACE
	CMP	BX,1000			;LESS THAN 1000 BYTES?
	JB	PSIZE			;YES
	INC	DX			;NO, REMOVE 1 SPACE
	CMP	BX,10000		;LESS THAN 10000 BYTES?
	JB	PSIZE			;YES
	INC	DX			;NO, REMOVE 1 SPACE
PSIZE:	XCHG	BX,DX			;BX = SPACES
	PUSH	AX			;SAVE SIZE HIGH
	CALL	TYPTX1			;PRINT SPACES
	POP	AX
	XCHG	BX,DX
	PUSH	CX
	CALL	DDECOUT			;PRINT FILE SIZE
	POP	CX
ICNT:	CALL	CR			;PRINT CRLF

;SEE IF MORE ENTRIES

	INC	Word Ptr PCOUNT		;INCREMENT PRINT COUNT
	DEC	Word Ptr COUNT		;DECREMENT COUNT
	JNZ	SMORE	
	JMP	BOTTOM			;NO MORE FILES TO PRINT
SMORE:	MOV	AL,Byte Ptr COUNTP	;GET PRINT COUNT
	INC	AL			;INCREMENT IT
	MOV	Byte Ptr COUNTP,AL
	CMP	AL,80			;80 FILES PRINTED?
	JNZ	PMORE			;NO, PRINT MORE
	CALL	TYPTX
	DB	27,'Y73Press Return for more files, Esc to quit..','.'+80H
	CMP	BYTE PTR CTYPE,0	;IBM?
	JNZ	WAICR			;NO
	MOV	BH,0
	MOV	AH,2
	MOV	DX,23*256+62
	INT	10H			;POS. CURSOR
WAICR:	MOV	AH,RDCHR
	INT	21H
	CMP	AL,27			;ABORT?
	JNZ	WAICR1	
	JMP	BOTTOM			;YES, QUIT EARLY
WAICR1:	CMP	AL,0DH
	JNZ	WAICR			;WAIT FOR CR
	XOR	AL,AL
	MOV	Byte Ptr COUNTP,AL	;CLEAR PRINT COUNTER
	MOV	Byte Ptr COLNO,AL	;AND COLUMN NO.
	CALL	BORDER			;ERASE SCREEN, PRINT NEW BORDER
	MOV	BX,(Offset COL1)
	MOV	Word Ptr COLADR,BX	;UPDATE COLUMN ADDRESS
	MOV	CL,20			;SET COUNTER
	JMP	ENTRY			;PRINT MORE FILES
PMORE:	DEC	CL			;DECREMENT COLUMN COUNTER
	JZ	PMORE1	
	JMP	ENTRY			;MORE TO PRINT
PMORE1:	CALL	TYPTX
	DB	27,'Y"',' '+80H		;RETURN TO PAGE TOP
	MOV	CL,20			;SET COUNTER
	MOV	AL,Byte Ptr COLNO	;ELSE GET COLUMN NUMBER
	INC	AL			;INCREMENT IT
	MOV	Byte Ptr COLNO,AL
	MOV	BX,(Offset COL2)	;ASSUME COLUMN 2
	DEC	AL			;TEST FOR IT
	JZ	SETCOL			;YES
	MOV	BX,(Offset COL3)	;ASSUME COLUMN 3
	DEC	AL
	JZ	SETCOL
	MOV	BX,(Offset COL4)	;ELSE, IT'S COLUMN 4
SETCOL:	MOV	Word Ptr COLADR,BX
	JMP	ENTRY			;PRINT MORE
;
PERIOD:	MOV	AL,'.'
;
;TYPE CHAR IN A

TYPEC:	PUSH	CX
	PUSH	DX
	PUSH	BX
	PUSHF
	PUSH	AX
	CMP	BYTE PTR CTYPE,0	;TEST COMPUTER TYPE
	JNZ	TYPEC1			;Z100
	CALL	IBMOUT			;ELSE, CALL IBM OUTPUT
	JMP	TYPECX
TYPEC1:	MOV	AH,LSTCHR		;GET LAST CHARACTER
	MOV	LSTCHR,AL		;UPDATE IT
	CMP	AH,1BH			;LAST CHAR ESCAPE?
	JNZ	TYPEC3			;NO
	CMP	AL,'p'			;SET REV. VID?
	JNZ	TYPEC2			;NO
	CALL	TYPTX
	DB	'm'
ZHATTR	DB	'0','3'+80H
	JMP	SHORT TYPECX
TYPEC2:	CMP	AL,'q'			;SET NORMAL VIDEO?
	JNZ	TYPEC3			;NO
	CALL	TYPTX
	DB	'm'
ZATTR1	DB	'7','1'+80H
	JMP	SHORT TYPECX
TYPEC3:	PUSH	SI
	PUSH	DI
	PUSH	ES			;SAVE THESE
	CLD				;MUST BE CLEARED!
	CALL	ROMOUT			;LET ROM DO OUTPUT
	POP	ES
	POP	DI
	POP	SI
TYPECX:	POP	AX
	POPF
	POP	BX
	POP	DX
	POP	CX
	RET
;
TYPEIT:	MOV	AL,M
	OR	AL,AL			;TEST FOR HI BIT
	JNS	TYPEIT1			;NONE THERE
	PUSH	AX			;SAVE CHARACTER
	CALL	TYPTX
	DB	27,'p'+80H
	POP	AX
	AND	AL,7FH			;STRIP PARITY BIT
	CALL	TYPEC
	CALL	TYPTX
	DB	27,'q'+80H
	INC	BX
	DEC	CH
	JNZ	TYPEIT
	RET
TYPEIT1: CALL	TYPEC
	INC	BX
	DEC	CH
	JNZ	TYPEIT
	RET
;
CR:	MOV	AL,0DH
	CALL	TYPEC
	MOV	AL,0AH
	CALL	TYPEC
	RET

;BOTTOM - PRINT DISK SPACE DATA

BOTTOM:	CALL	TYPTX
	DB	27,'Y7','3'+80H
	MOV	Byte Ptr COMFLG,1	;TELL DDECOUT TO USE COMMAS
	MOV	BX,Word Ptr PCOUNT	;GET FILE COUNT
	MOV	AX,0
	CALL	DDECOUT			;PRINT COUNT
	CALL	TYPTX
	DB	' Files. ',' '+80H
	MOV	BX,Word Ptr USED	;GET USED SPACE
	MOV	AX,Word Ptr USEDH
	CALL	DDECOUT			;PRINT IT
	CALL	TYPTX
	DB	' ','('+80H
	MOV	AX,Word Ptr ALLOC	;GET ALLOCATED SPACE
	MOV	CX,Word Ptr BSIZE	;AND BLOCK SIZE
	MUL	CX			;COMPUTE ALLOCATED BYTES
	MOV	BX,AX			;LOW TO BX
	MOV	AX,DX			;HIGH TO AX
	CALL	DDECOUT			;PRINT ALLOCATED SPACE
	CALL	TYPTX
	DB	') Used. ',' '+80H
	MOV	AX,Word Ptr FREE	;GET FREE SPACE
	MOV	CX,Word Ptr BSIZE	;AND BLOCK SIZE
	MUL	CX			;COMPUTE FREE BYTES
	MOV	BX,AX			;LOW WORD TO BX
	MOV	AX,DX			;HIGH WORD TO AX
	CALL	DDECOUT			;PRINT FREE SPACE
	CALL	TYPTX
	DB	' Free.',27,'Y6',' '+80H
;
;EXIT - ALL DONE 

EXIT:	MOV	AL,Byte Ptr CURDSK	;GET CURRENT DISK
	MOV	DL,AL
	MOV	AH,SELECT
	INT	21H			;SET DEFAULT DISK
EXIT0:	CMP	BYTE PTR CTYPE,0	;IBM?
	JNZ	EXIT1			;NO
	MOV	AH,2
	MOV	BH,0
	MOV	DX,22*256		;ROW 22, COL 0
	INT	10H
EXIT1:	INT	20H			;RETURN TO Z-DOS

;	DDECOUT - PRINT 32 BIT NO. IN AX,BX IN DECIMAL
;	AX = HIGH WORD, BX = LOW WORD

DDECOUT: MOV	SI,0			;CLEAR ZERO SUPPRESS FLAG
	MOV	CX,3B9AH
	MOV	DX,0CA00H		;CX,DX = 1,000,000,000
	CALL	DIVPR			;DIVIDE AND PRINT
	CALL	COMMA			;PRINT A COMMA (IF NO. PRINTED)
	MOV	CX,5F5H
	MOV	DX,0E100H		;CX,DX = 100,000,000
	CALL	DIVPR
	MOV	CX,98H
	MOV	DX,9680H		;CX,DX = 10,000,000
	CALL	DIVPR
	MOV	CX,0FH
	MOV	DX,4240H		;CX,DX = 1,000,000
	CALL	DIVPR
	CALL	COMMA
	MOV	CX,1
	MOV	DX,86A0H		;CX,DX = 100,000
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,10000		;CX,DX = 10000
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,1000			;CX,DX = 1000
	CALL	DIVPR
	CALL	COMMA
	MOV	CX,0
	MOV	DX,100			;CX,DX = 100
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,10			;CX,DX = 10
	CALL	DIVPR
	MOV	AL,BL			;GET ONES DIGIT
	ADD	AL,'0'			;ADD ASCII
	JMP	TYPEC			;PRINT IT AND RETURN
DIVPR:	MOV	DI,-1			;SET A COUNTER
DIVPR1:	INC	DI			;INCREMENT COUNTER
	SUB	BX,DX			;SUBTRACT DIVISOR
	SBB	AX,CX
	JNB	DIVPR1			;REPEAT UNTIL OVERFLOW
	ADD	BX,DX			;ADD DIVISOR BACK IN ONCE
	ADC	AX,CX
	PUSH	AX			;SAVE AX
	MOV	AX,DI			;GET COUNTER (WHICH IS DIGIT)
	ADD	AL,'0'			;ADD ASCII OFFSET
	CMP	SI,0			;CKECK ZERO FLAG
	JNZ	DIVPR2			;PASSED LEADING ZEROS, PRINT NO.
	CMP	AL,'0'			;IS NO. ZERO?
	JZ	DIVPR3			;IF SO, EXIT
	INC	SI			;ELSE, FLAG ZEROS PASSED
DIVPR2:	CALL	TYPEC			;PRINT NO.
DIVPR3:	POP	AX			;RESTORE AX
	RET
COMMA:	CMP	SI,0			;ANY NUMBERS PRINTED?
	JZ	COMMA1			;NO
	CMP	Byte Ptr COMFLG,0	;COMMAS WANTED?
	JZ	COMMA1			;NO
	PUSH	AX
	MOV	AL,','			;ELSE, PRINT COMMA
	CALL	TYPEC
	POP	AX
COMMA1:	RET

;	TYPTX - TYPE TEXT FOLLOWING CALL

TYPTX:	MOV	BP,SP			;GET ADDRESS OF TEXT
	XCHG	BX,[BP]
	CALL	TYPTX1
	MOV	BP,SP
	XCHG	BX,[BP]
	RET
TYPTX1:	MOV	AL,M
	AND	AL,7FH
	CALL	TYPEC
	CMP	AL,M
	PUSHF
	INC	BX
	POPF
	JZ	TYPTX1
	RET

;	BORDER - PRINT A GRAPHIC CHARACTER BORDER FOR FILES

BORDER:	CALL	TYPTX
	DB	27,'Y! ',27,'J',27,'F'+80H
	MOV	CH,4
BORD1:	CALL	TYPTX
	DB	'aaaaaaaaaaaaaaaaaa','a'+80H
	DEC	CH
	JZ	BORD2
	MOV	AL,'s'
	CALL	TYPEC
	JMP	BORD1
BORD2:	MOV	CH,20
BORD3:	CALL	CR
	CALL	TYPTX
	DB	9,9,'   `',9,9,'       `',9,9,'   ','`'+80H
	DEC	CH
	JNZ	BORD3
	CALL	CR
	MOV	CH,4
BORD4:	CALL	TYPTX
	DB	'aaaaaaaaaaaaaaaaaa','a'+80H
	DEC	CH
	JZ	BORD5
	MOV	AL,'u'
	CALL	TYPEC
	JMP	BORD4
BORD5:	CALL	TYPTX
	DB	27,'G',27,'Y"',' '+80H
	RET

;	SHOW HELP

DOHELP:	CALL	TYPTX
	DB	'HUG columnizing, alphabetizing directory program, v 2.1'
	DB	13,10
	DB	'To use this program, enter',13,10,10
	DB	'  D <pathname></switches>',13,10,10
	DB	'where <pathname> is an optional pathname in the form',13,10
	DB	'accepted by the DOS DIR command, and </switches> are',13,10
	DB	'optional switches:',13,10,10
	DB	'  H		Help -- show this information',13,10
	DB	'  N		do Not alphabetize',13,10
	DB	'  S		Show all files and flags except archive',13,10
	DB	'  A		show All files and flags',13,10
	DB	'  D		show only Directory names',13,10,10
	DB 	'You can use the N switch with the S, A, or D switches',13,10
	DB	'(eg. D A:/NS).  Flags are indicated by highlighting a',13,10
	DB	'character position in the filename as follows:',13,10,10
	DB     '	      FILENAME.EXT',13,10
	DB	"  Read Only"
	DB	27,"Faaad````eaaa",27,"GArchive (A switch only)",13,10
	DB	"  Hidden"
	DB	27,"Faaaaaaad``eaaaa",27,"GDirectory Name",13,10
	DB	"  System"
	DB	27,"Faaaaaaaadeaaaaa",27,"GDisk Labe",'l'+80H
	JMP	EXIT0			;EXIT

;	Z19 CODE TO IBM TRANSLATOR -- WITH THANKS TO BOB METZ

IBMOUT:	JMP	WORD PTR IBMJMP
IBMOUT1:AND	AL,7FH
	CMP	AL,1BH			;ESCAPE?
	JNZ	CRT_OUT			;NO, NORMAL CHAR
	MOV	WORD PTR IBMJMP,OFFSET FIND_CODE	;ELSE, FIND CODE NEXT
IBMRET:	RET				;AND IGNORE ESC

CRT_OUT:OR	AL,AL			;NUL?
	JZ	IBMRET			;IF SO, RETURN
	CMP	AL,9			;TAB?
	JNZ	CRTOT1
	JMP	TAB			;IF SO, PROCESS IT HERE
CRTOT1:	CMP	AL,' '			;LET WRT TTY DO CONTROL
	JB	WRT_TTY
	CMP	BYTE PTR GRAFLG,0	;GRAPHICS MODE?
	JE	SCREEN_OUT		; NO - NORMAL
	CMP	AL,5EH			; YES - GRAPHICS CHR?
	JB	SCREEN_OUT
	CMP	AL,7EH		
	JA	SCREEN_OUT
	SUB	AL,5EH
	MOV	BX,OFFSET IBMGRPH
	XLAT
SCREEN_OUT:
	PUSH	ES
	PUSH	DI
	PUSH	AX			;SAVE CHARACTER
	MOV	AX,MEMADR
	MOV	ES,AX
	MOV	AL,BYTE PTR CURPOS+1	;GET ROW
	XOR	AH,AH			;IN AX
	MOV	CL,80
	MUL	CL			;MPY BY 80
	MOV	CL,BYTE PTR CURPOS
	XOR	CH,CH
	ADD	AX,CX			;ADD COLUMN
	SHL	AX,1			;2 BYTES/CHAR
	MOV	DI,AX			;POSITION TO DI
	POP	AX			;GET CHARACTER
	MOV	AH,ATTR			;ATTRIBUTE TO AH
	STOSW				;STORE CHARACTER
	POP	DI
	POP	ES
;	MOV	AH,9
;	MOV	BL,ATTR
;	MOV	BH,0			;WRITE CHR W/ ATTRIBUTE
;	MOV	CX,1
;	INT	10H
	JMP	DORT			;MOVE CURSOR OVER
WRT_TTY:CMP	AL,0DH			;CR?
	JNZ	NOTCR
	MOV	BYTE PTR CURPOS,0	;ELSE, ZERO COLUMN
	RET
NOTCR:	CMP	AL,0AH			;LF?
	JNZ	NOTLF
	INC	BYTE PTR CURPOS+1	;INCREMENT ROW
	RET
NOTLF:	MOV	AH,14			; WRITE TTY TO SCREEN
	MOV	BL,ATTR 
	MOV	BH,0
	INT	10H
	RET
;
FIND_CODE:
	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	MOV	BX,OFFSET CODETABLE
FIND_LP:CMP	BYTE PTR [BX],0		;END OF TABLE?
	JNE	CHKIT			; NO
	RET				; YES - IGNORE ESC SEQUENCE
CHKIT:	CMP	AL,[BX]	
	JE	PROCESSIT
	ADD	BX,3			;NOT THIS ENTRY - CHECK NXT
	JMP	FIND_LP
PROCESSIT:
	JMP	WORD PTR 1[BX]		;ENTER ESC SEQ PROCESSOR

;	ESCAPE SEQUENCE PROCESSORS

;	RESET SCREEN

IBMRST:	MOV	AL,BYTE PTR DFATTR
	MOV	BYTE PTR ATTR,AL	;RESET ATTRIBUTE
	MOV	BYTE PTR GRAFLG,0	;GRAPHIC MODE OFF
	MOV	AH,15
	INT	10H			;READ DISPLAY TYPE
	CMP	AL,7			;MONO?
	JNZ	COLOR			;NO, COLOR
	MOV	MEMADR,0B000H		;ELSE, FIX VIDEO MEMORY ADDRESS
	JMP	SHORT MODEOK		;MODE SHOULD BE ALREADY SET
COLOR:	CMP	AL,2			;MODE 2?
	JZ	CKPG			;YES
	CMP	AL,3			;MODE 3
	JNZ	MAKM3			;NO, MAKE IT 3
CKPG:	CMP	BH,0			;PAGE 0?
	JZ	MODEOK			;IF SO, MODE IS OK
MAKM3:	MOV	AX,3			;ELSE, FORCE MODE 3
	INT	10H
MODEOK:	MOV	AX,600H
	MOV	BH,ATTR			;GET ATTRIBUTE
	MOV	CX,0
	MOV	DH,24			;CLEAR SCREEN
	MOV	DL,79
	INT	10H
	JMP	DOHOME

GRAFON:	MOV	BYTE PTR GRAFLG,1	;GRAPHIC MODE ON
	RET
GRAFOF:	MOV	BYTE PTR GRAFLG,0	;GRAPHIC MODE OFF
	RET

;	CURSOR ADDRESSING

DOADR:	MOV	WORD PTR IBMJMP,OFFSET GETROW	;NEXT CHAR IS ROW
	RET
GETROW:	MOV	SAV_ROW,AL			;SAVE ROW
	MOV	WORD PTR IBMJMP,OFFSET GETCOL	;NEXT CHAR IS COLUMN
	RET
GETCOL:	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	MOV	DH,SAV_ROW
	MOV	DL,AL				;AL = COLUMN
	SUB	DX,'  '			;CONVERT TO 0 BASE
SETCURS:MOV	CURPOS,DX
	RET
;
DOUP:	MOV	DX,CURPOS		;GET CURSOR POSITION
DOUP1:	DEC	DH
	CMP	DH,0
	JAE	SETCURS
	INC	DH			;DON'T ALLOW TO GO OFF SCREEN
	JMP SHORT SETCURS
;
DODWN:	MOV	DX,CURPOS		;CURSOR DOWN
DODWN1:	INC	DH
	CMP	DH,23
	JBE	SETCURS
	MOV	AL,10			;LET TTY I/O DO SCROLL
	JMP	WRT_TTY
;
TAB:	MOV	DX,CURPOS		;PROCESS TABS
	ADD	DL,8
	AND	DL,0F8H			;MOV TO NEXT TAB STOP
	JMP SHORT DORT1
;
DORT:	MOV	DX,CURPOS		;CURSOR RIGHT
	INC	DL
DORT1:	CMP	DL,79
	JBE	SETCURS
	MOV	DL,0 
	JMP SHORT DODWN1
;
DOHOME:	MOV	DX,0			;HOME CURSOR
	JMP	SETCURS
;
DOCLR:	MOV	AX,600H			;CLEAR SCREEN
	MOV	BH,ATTR
	MOV	CX,0			;ERASE LINES 1-24,COLS 1-80
	MOV	DH,23
	MOV	DL,79
	INT	10H
	MOV	WORD PTR CURPOS,0
	JMP SHORT DOHOME
;
ERSEOS:	MOV	DX,CURPOS		;ERASE TO END OF SCREEN
	MOV	AH,2
	MOV	BH,0
	INT	10H			;SET CURSOR
	MOV	AX,600H
	MOV	BH,ATTR			;ERSEOL FIRST
	MOV	CX,DX
	MOV	DL,79
	PUSH	CX			;SAVE CURSOR POSITION
	INT	10H
	POP	CX
	MOV	DH,23
	MOV	DL,79
	CMP	CH,23
	JE 	ERS_RET
	INC	CH
	MOV	AX,600H
	MOV	BH,ATTR
	INT	10H
ERS_RET:RET
;
DOREV:	MOV	AL,HIATTR
	MOV	BYTE PTR ATTR,AL	;REV. VIDEO
	RET
;
DONRM:	MOV	AL,DFATTR
	MOV	BYTE PTR ATTR,AL	;NOR. VIDEO
	RET

IBMJMP	DW	IBMOUT1			;JUMP INTO CODE
MEMADR	DW	0B800H			;VIDEO MEMORY ADDRESS
CURPOS	DW	0			;CURSOR POSITION
GRAFLG	DB	0			;GRAPHICS MODE FLAG
ATTR	DB	(BGC SHL 4)+FGC		;DEFAULT ATTRIBUTE
SAV_ROW	DB	0			;SAVED ROW POSITION
;
CODETABLE:				;ESC SEQUENCE PROCESSOR TABLE
	DB	'Y'
	DW	OFFSET DOADR
	DB	'E'
	DW	OFFSET DOCLR
	DB	'F'
	DW	OFFSET GRAFON
	DB	'G'
	DW	OFFSET GRAFOF
	DB	'J'
	DW	OFFSET ERSEOS
	DB	'A'
	DW	OFFSET DOUP
	DB	'B'
	DW	OFFSET DODWN
	DB	'C'
	DW	OFFSET DORT
	DB	'H'
	DW	OFFSET DOHOME
	DB	'p'
	DW	OFFSET DOREV
	DB	'q'
	DW	OFFSET DONRM
	DB	'z'
	DW	OFFSET IBMRST
	DB	0			;END OF TABLE
;
;      Z-100 to IBM PC graphic chr xlat table
;	only locs 5eh to 7eh are present    
;
IBMGRPH	LABEL	BYTE
	db	0f9h	; ^
	db	0dbh	; _
	db	0b3h	; `
	db	0c4h	; a
	db	0c5h	; b
	db	0bfh	; c
	db	0d9h	; d
	db	0c0h	; e
	db	0dah	; f
	db	0f1h	; g
	db	01ah	; h
	db	0b0h	; i
	db	0f6h	; j
	db	019h	; k
	db	0dah	; l
	db	0bfh	; m
	db	0d9h	; n
	db	0c0h	; o
	db	0dfh	; p
	db	0deh	; q
	db	0dbh	; r
	db	0c2h	; s
	db	0b4h	; t
	db	0c1h	; u
	db	0c3h	; v
	db	058h	; w
	db	02fh	; x
	db	05ch	; y
	db	0dfh	; z
	db	0dch	; {
	db	0ddh	; |
	db	0deh	; }
	db	014h	; ~
	db	0dbh	; del

;	DATA AREA
;
CTYPE	DB	1			;COMPUTER TYPE -- PRESET TO Z-100
LSTCHR	DB	0			;LAST CHARACTER
CURDSK	DB	0			;CURRENT DISK
NFLAG	DB	0			;NO ALPHABETIZE FLAG
WCFLG	DB	0			;WILD CARD FLAG
ARGCNT	DW	0			;ARGUMENT COUNT
MEMLIM	DW	0			;MEMORY LIMIT
NEXTT	DW	OFFSET BA.TABLE		;NEXT TABLE ENTRY
COUNT	DW	0			;ENTRY COUNT
PCOUNT	DW	0			;COUNT TO PRINT
SCOUNT	DW	0			;# TO SORT
VARI	DW	0			;SORT VARIABLES
VARJ	DW	0
VARK	DW	0
VARL	DW	0
VARM	DW	0
USED	DW	0			;USED SPACE
USEDH	DW	0			;USED SPACE (HIGH WORD)
FREE	DW	0			;FREE SPACE
ALLOC	DW	0			;ALLOCATED SPACE
BSIZE	DW	0			;BLOCK SIZE
COMFLG	DB	0			;COMMA FLAG
COUNTP	DB	0			;PRINT COUNTER
FLAGS	DB	0FFH			;ATTRIBUTES FOR S SWITCH
CHAFLG	DB	0			;CHECK ALL FLAG
COLTBL	DB	0,1,4,5,2,3,6,7
NOPATH	DB	'<none','>'+80H
SPACES	DB	'    ',' '+80H
COLNO	DB	0			;COLUMN NUMBER
COLADR	DW	(Offset COL1)		;COLUMN MOVER ADDRESS
COL1	DB	80H
COL2	DB	9,9,27,'C',27,'C',27,'C',27,'C'+80H
COL3	DB	9,9,9,9,9+80H
COL4	DB	9,9,9,9,9,9,9,27,'C',27,'C',27,'C',27,'C'+80H
DIR	DB	' ','<'+80H,'D'+80H,'I'+80H,'R'+80H,'>'+80H
FNAME	DB	15 DUP (0)		;TEMP. STORAGE FOR NAME
TEMP	DW	0			;TEMP. STORAGE FOR SORT
DLFCB	DB	0FFH,0,0,0,0,0,8	;DISK LABEL FCB
DLFCBDR	DB	0,'???????????',0,0,0,0
BA:
BUFF	STRUC
	DB	16 DUP (?)		;SPACE FOR DLFCB
PATH	DB	128 DUP (?)		;STORE PATH HERE
PATH2	DB	128 DUP (?)		;HERE, TOO (FOR PRINTING PATH)
ORDER	DB	4096 DUP (?)		;ORDER TABLE (ROOM FOR 2048 NAMES)
TABLE	DB	?			;READ ENTRIES IN HERE
BUFF	ENDS
;
CODE	ENDS
	END	START
