title	HUG File Manager V 2.2
	page	,132
;
;	HUG File Manager Version 2.2 for MS-DOS 2.0 OR ABOVE
;
;			Z-100/Z-150 version
;
;	BY P. SWAYNE, HUG, AND R. A. METZ  29-MAR-85  04-APR-85
;	MODIFIED FOR DIRECT VIDEO MEMORY ACCESS (V 2.2) 26-APR-89
;	SPACE CHECK WITH CHANGE DISK OPTION ADDED 07-JUL-89
;
;	BASED ON THE ORIGINAL HFM (FILEMGMT) BY R. A. METZ
;
;	This program operates in a manner similar to the Microsoft
;	Multiplan spreadsheet program in that a command line is
;	Displayed at the bottom of the screen.  Operation of that 
;	command line parallels that of Multiplan's command 
;	line.  The main screen area is used for directory
;	Display and display of requested file data.
;	Full support exists for MS-DOS 2.0 tree-structured
;	Directories.
;
;	This program utilizes the escape sequences as processed
;	by the Z-100 for control of the screen.  In order for this
;	program to operate on an IBM PC or Zenith Z-150, a Z-100
;	emulator such as that provided in IBMZ100.COM must be active.
;
;
;	Commands currently implemented are:
;
;	Copy	Copy selected file.  The user is prompted to
;		enter the name of the destination file/device.
;	Direct.	Directory Maintenance.  The user is prompted to
;		select Make or Remove, and then is asked for the
;		name of a directory to make or remove.
;	Erase	Erase file.  The user is asked for confirmation
;		before actually erasing the selected file.
;	Flag	Mark file with a flag.  If Copy or Delete are then
;		used, the marked files will be acted upon, instead
;		of the highlighted file.
;	Help	Use of this utility is explained.
;	Listhex	The selected file is displayed in Hex and ASCII.
;	Moredir	If there are more files than fit on the screen, this
;		command will show the next screen.  If used while the
;		last screen of files are showing, the first files are
;		re-displayed.
;	Newdisk	The user is prompted for a disk id to become the
;		new default.  When entered, a list of the sub-directory
;		files in the current directory of that disk is displayed
;		and the user is prompted to enter the name of a sub-
;		Directory to become the new current directory.  A
;		carriage return response will cause retention of the
;		current disk/directory.  A new directory display is
;		then presented.
;	Print	The PRINT utility program is invoked to place the
;		selected file on the MS-DOS print spool.
;	Quit	Quit this program.
;	Rename	Rename file.  The user is prompted for a new
;		file name and the selected file is renamed.
;	Sort	The directory is sorted alphabetically and displayed
;		in that form.  This is the normal condition at startup.
;	Type	The selected file is displayed on the screen.
;	Unsort	The directory is unsorted and the files are displayed
;		in their natural order.
;	Wildcrd.Wildcard Specification.  The user is prompted for a
;		wildcard specification that determines which files
;		are shown on the screen.
;
;	Note:  For proper operation of the Print command, the utility
;	program PRINT.COM must be present in the current PATH directory.
;
HICODE	EQU	1FH			; HIGHLIGHTING CODE WHEN USED ON
;					; A Z-150.  USE 0FH FOR INTENSE WHITE,
;					; OR 70H FOR REVERSE VIDEO.
ADDR	MACRO	ROW,COL
	DB	27,'Y',31+ROW,31+COL
	ENDM

FGC	EQU	7			;FOREGROUND COLOR
BGC	EQU	1			;BACKGROUND COLOR
HFGC	EQU	0			;HIGHLIGHT FOREGROUND COLOR
HBGC	EQU	3			;HIGHLIGHT BACKGROUND COLOR
;
BIOS	SEGMENT AT 40H
	ORG	0
JMPTBL	LABEL	BYTE			;DEFINE Z-100 JUMP TABLE
	ORG	3
ZKSTAT	LABEL	FAR			;Z-100 KEY STATUS
	ORG	6
ZKEY	LABEL	FAR			;Z-100 KEY INPUT
BIOS	ENDS

ROM	SEGMENT AT 0FE01H		;Z-100 ROM SEGMENT
	ORG	19H
ROMOUT	LABEL	FAR			;DEFINE ROM OUTPUT
ROM	ENDS

HFM	SEGMENT
	ASSUME	CS:HFM,DS:HFM,ES:HFM,SS:HFM
	ORG	2CH
ENV_SEG	LABEL	WORD
	ORG	5CH
FCB1	LABEL	BYTE
	ORG	6CH
FCB2	LABEL	BYTE
	ORG	80H
BUF	LABEL	BYTE
	ORG	100H

START:	JMP	BEGIN
;
DFATTR	DB	(BGC SHL 4)+FGC		;DEFAULT ATTRIBUTE
HIATTR	DB	(HBGC SHL 4)+HFGC	;HIGHLIGHT ATTRIBUTE
SPSAVE	DW	0
CUR_CMD	DW	4
CUR_ENT	DW	0
MAX_ENT	DW	0
MEMTOP	DW	0			; MEMORY TOP
FILECNT	DW	0			; FILE COUNT
PAGECNT	DW	0			; PAGE FILE COUNT
CURTYPE	DW	0			; CURSOR TYPE (Z-150)
DISTYPE	DB	0			; DISPLAY TYPE (Z-150)
TTYPE	DB	0			; TERMINAL TYPE (Z-100 OR Z-150)
MOREFLG	DB	0			; MORE FILES FLAG
VARI	DW	0			; SORT VARIABLES
VARJ	DW	0
VARK	DW	0
VARL	DW	0
VARM	DW	0
SORTFLG	DB	1			; SORT FLAG
FLAGCNT	DB	0			; COUNT OF FILES FLAGGED
FLG2FLG	DB	0			; FILES FLAGGED INDICATOR
TFCNT	DW	0			; TEMP. FILE COUNT
DESTDRV	DB	0			; DESTINATION DRIVE
CUR_ADR	DW	0			; CURRENT FILE ADDRESS
FREE_L	DW	0			; DISK FREE SPACE LOW
FREE_H	DW	0			; DISK FREE SPACE HIGH
FLAG_L	DW	0			; FLAGGED FILE BYTES LOW
FLAG_H	DW	0			; FLAGGED FILE BYTES HIGH
LINECNT	DB	0			; LINE COUNT FOR TYPE
LABFLAG	DB	0			; DISK LABEL FLAG
DATSAVE	DW	0			; SAVED FILE DATE
TIMSAVE	DW	0			; SAVED FILE TIME
ZEROPOS	DW	0			; ZERO POSITION ADDRESS
INHAND	DW	0			; INPUT FILE HANDLE
OUTHAND	DW	0			; OUTPUT FILE HANDLE
EOFFLG	DB	0			; END OF FILE FLAG
CUR_DISK	DB	'A'
CUR_DIR	DB	64 DUP (0)
DLFCB	DB	0FFH,0,0,0,0,0,8	; DISK LABEL FCB
DLFCBDR	DB	0
DLFCBN	DB	'???????????',0,0,0,0
	DB	17 DUP (0)
DLFCBX:
;
CMD_LINE_TBL	LABEL	WORD
	DW	OFFSET ccmd
	DW	OFFSET dcmd
	DW 	OFFSET ecmd
	DW	OFFSET FCMD
	DW	OFFSET hcmd
	DW	OFFSET ICMD
	DW	OFFSET lcmd
	DW	OFFSET MCMD
	DW	OFFSET ncmd
	DW	OFFSET pcmd
	DW	OFFSET QCMD
	DW	OFFSET rcmd
	DW	OFFSET SCMD
	DW	OFFSET tcmd
	DW	OFFSET UCMD
	DW	OFFSET WCMD
;
NCMDS	EQU	16
MAX_CMD	EQU	15
;
ccmd	LABEL	BYTE
	ADDR	23,10
    	DB	'Copy$'
dcmd	LABEL	BYTE
	ADDR	23,15
    	DB	'Directory$'
ecmd	LABEL	BYTE
	ADDR	23,25
    	DB	'Erase$'
FCMD	LABEL	BYTE
	ADDR	23,31
	DB	'Flag$'
hcmd	LABEL	BYTE
	ADDR	23,36
	DB	'Help$'
ICMD	LABEL	BYTE
	ADDR	23,41
	DB	'ID$'
lcmd	LABEL	BYTE
	ADDR	23,44
    	DB	'Listhex$'
MCMD	LABEL	BYTE
	ADDR	23,52
	DB	'Morefiles$'
ncmd	LABEL	BYTE
	ADDR	23,62
    	DB	'Newdisk$'
pcmd	LABEL	BYTE
	ADDR	24,10
    	DB	'Print$'
QCMD	LABEL	BYTE
	ADDR	24,16
	DB	'Quit$'
rcmd	LABEL	BYTE
	ADDR	24,21
    	DB	'Rename$'
SCMD	LABEL	BYTE
	ADDR	24,28
	DB	'Sort$'
tcmd	LABEL	BYTE
	ADDR	24,33
    	DB	'Type$'
UCMD	LABEL	BYTE
	ADDR	24,38
	DB	'Unsort$'
WCMD	LABEL	BYTE
	ADDR	24,45
	DB	'Wildcard$'
;
;	messages
;
cr	EQU	0dh
lf	EQU	0ah
esc	EQU	1bh
;
BADVERSION	DB	cr,lf
		DB	'Incorrect DOS version.$'
BADMEM		DB	CR,LF
		DB	'Not enough memory to run this program.$'
;
INIT_MSG	DB	esc,'E'		; clear screen
		DB	esc,'x1'	; enable 25th line
		DB	'$'
;
REV_MSG	DB	esc,'p$'
NRM_MSG	DB	esc,'q$'
;
FLG_MSG	DB	8,'*$'
;
xit_MSG:
	ADDR	25,1
	DB	esc,'K'
	ADDR	1,1
	DB	esc,'E'
CUR_ON:
	DB	esc,'y5'
	DB	'$'
;
INIT_PROMPT	LABEL	BYTE
		ADDR	24,1
		DB	ESC,'K'
		ADDR	23,1
		DB	esc,'K'
		DB	esc,'y5'
		DB	'$'

MSG_PROMPT	DB	27,'Y',24+31,1+31
		DB	27,'K'
		DB	27,'Y',23+31,1+31
		DB	27,'K$'
;
INIT_CMD_LINE	LABEL	BYTE
		ADDR	24,1
		DB	ESC,'K'
		ADDR	23,1
		DB	esc,'K'
		DB	esc,'x5'
		DB	'Command: '
		DB	'$'
;
DIR_HDR		LABEL	BYTE
		ADDR	1,1
		DB	ESC,'pHUG File Manager',ESC,'q'
		DB	' Version 2.2'
		ADDR	3,1
		DB	'Contents of Directory $'

LAB_MSG		LABEL	BYTE
		ADDR	1,44
		DB	'Disk label: '
DISKLAB		DB	'           $'
NONE		DB	'(none)     '

FSPC_MSG	LABEL	BYTE
		ADDR	2,44
		DB	'Flagged file bytes:           '
		ADDR	2,64
		DB	'$'

FREE_MSG	LABEL	BYTE
		ADDR	25,59
		DB	'Free space:           '
		ADDR	25,71
		DB	'$'

SIZ_MSG		LABEL	BYTE
		ADDR	25,38
		DB	'File size:        '
		ADDR	25,49
		DB	'$'

MORE_DIR	LABEL	BYTE
		ADDR	21,71
		DB	'MORE'
		ADDR	22,71
		DB	'FILES..$'
;
SUBDIR_HDR	LABEL	BYTE
		ADDR	1,1
		DB	ESC,'pHUG File Manager',ESC,'q'
		DB	' Version 2.0'
		ADDR	3,1
		DB	'Subdirectories in Directory $'
;
SEL_DISP	LABEL	BYTE
		DB	ESC,'x1'
		ADDR	25,1
		DB	'Current selection:             '
		ADDR	25,20
		DB	'$'
;
NO_FIL_MSG	LABEL	BYTE
		ADDR	6,1
		DB	'No files in directory!!$'
;
NO_SUBFIL_MSG	LABEL	BYTE
		DB	7,'$'
;
DEL_ERR_MSG	DB	'Sorry - cannot erase file $'
;
REN_ERR_MSG	DB	'File rename error!$'
;
READ_ERR_MSG	DB	7,'  Error - cannot read file.$'

WRIT_ERR_MSG	DB	7,'  Error - cannot write file.$'

NO_SPACE	DB	7,13,10,'No space left on disk.$'
CH_DISK		DB	' Change disk? (Y/N) $'
REP_DISK	DB	13,10,'Replace the disk, and press Return.$'
TRY_COPY	DB	13,10,'Retrying copy...$'
FILE_EX		DB	7,'  File exists, delete? (Y/N) $'
;
PROG_ERR_MSG	DB	'Program load error!$'
;
DIR_ERR_MSG	DB	'Directory file error - directory not changed!$'
;
FILE_ERR_MSG	DB	'Error - no file selected!$'
;
DEST_FILE_REQ	LABEL	BYTE
		DB	'Enter destination file pathname: $'
;
CONFIRM_REQ	LABEL	BYTE
		DB	'OK to erase current file? (Y/N) $'
;
CONFIRM_REQ1	LABEL	BYTE
		DB	'OK to erase flagged file(s)? (Y/N) $'
;
ERASING		DB	27,'Y',24+31,1+31
		DB	'Erasing selected file(s)...$'
;
DIR_TYPE_REQ	LABEL	BYTE
		DB	'Do you want to Make or Remove '
		DB	'a directory? (M/R) $'
;
DIR_NAM_REQ	LABEL	BYTE
		DB	'Enter directory name: $'
;
NEW_ID_REQ	LABEL	BYTE
		DB	'Enter new disk label: $'
;
NEW_NAME_REQ	LABEL	BYTE
		DB	'Enter new file name: $'
;
NEW_DISK_REQ	LABEL	BYTE
		DB	'New default drive: $'
;
PRINT_REQ	LABEL	BYTE
		DB	'Use PRINT.COM? (Y/N) $'
;
NEW_DIR_REQ	LABEL	BYTE
		ADDR	24,1
		DB	ESC,'K'
		ADDR	23,1
		DB	'New current directory: $'
;
WILD_CARD_REQ	LABEL	BYTE
		DB	'Enter wildcard specification: $'
;
CLR_SCREEN	LABEL BYTE
		ADDR	1,1
		DB	esc,'E'		; erase all
		ADDR	25,1
		DB	esc,'K'		; ERASE 25TH LINE
		ADDR	1,1
		DB	'$'
;
hlp_vct		DW	chlp
		DW	dhlp
		DW	ehlp
		DW	FHLP
		DW	hhlp
		DW	IHLP
		DW	lhlp
		DW	MHLP
		DW	nhlp
		DW	phlp
		DW	QHLP
		DW	rhlp
		DW	SHLP
		DW	thlp
		DW	UHLP
		DW	WHLP
;
;	help message text
;
CHLP	DB 9,'Copy File',CR,LF,LF
 DB 9,'When you are prompted for a destination file  pathname,  type  in',CR,LF
 DB 9,'a normal MS-DOS destination  (drive designation  and/or directory',CR,LF
 DB 9,'path and/or filename).   The selected file will then be copied to',CR,LF
 DB 9,'the specified destination.  If any files have been Flagged, those',CR,LF
 DB 9,'files  will  be  copied  instead of the currently selected (high-',CR,LF
 DB 9,'lighted) file.',CR,LF,LF
 DB 9,'If the  file name is omitted from the destination path name,  the',CR,LF
 DB 9,'source file name will be used.  If the last part of the path name',CR,LF
 DB 9,'is a directory name,  the last character should  be  a  backslash',CR,LF
 DB 9,'(\).   If you are copying flagged files, the path name should not',CR,LF
 DB 9,'include a file name.',CR,LF,LF
 DB 9,'If  you  copy  files to a non-disk device  (CON, PRN, etc.),  you',CR,LF
 DB 9,'should NOT put a colon at the end of the name (as in CON:).$'

DHLP	DB 9,'Directory Maintenance',CR,LF,LF
 DB 9,'After you select this command, you will be asked to type M if you',CR,LF
 DB 9,'want to make a new directory,  or R if you want to remove  an old',CR,LF
 DB 9,'one.   Then  you  will be prompted for the name of the directory,',CR,LF
 DB 9,'and HFM will add it to or remove it from the current directory or',CR,LF
 DB 9,'specified path.$'

EHLP	DB 9,'Erase File',CR,LF,LF
 DB 9,'You will be asked for  confirmation  to erase the selected (high-',CR,LF
 DB 9,'lighted) or Flagged file(s).  If you type Y, the selected file(s)',CR,LF
 DB 9,'will be erased.$'

FHLP	DB 9,'Flag File',CR,LF,LF
 DB 9,'The selected file is marked with a flag.  An asterisk (*) is dis-',CR,LF
 DB 9,'played on the screen before the file name to  indicate  that  the',CR,LF
 DB 9,'file has been flagged.   After you have used this command to mark',CR,LF
 DB 9,'file(s),  the Copy and Erase  commands will operate on the marked',CR,LF
 DB 9,'file(s) instead of the currently selected (highlighted) file.  If',CR,LF
 DB 9,'the selected file already has a flag set when you use  this  com-',CR,LF
 DB 9,'mand,  it will be removed.   The  file sizes of all flagged files',CR,LF
 DB 9,'are added together and displayed at the top of the screen.',CR,LF,LF
 DB 9,'To  remove the flags from all flagged files at once,  use the Un-',CR,LF
 DB 9,'sort command,  followed  by the Sort command if you want the dir-',CR,LF
 DB 9,'ectory sorted.$'

HHLP	DB 9,'HUG File Manager',CR,LF,LF
 DB 9,'The HUG File Manager supports the following operations: copy, re-',CR,LF
 DB 9,'name,  erase,  type (on the screen), list in  hex,  print,  label',CR,LF
 DB 9,'disks,  change  the default disk or directory, create  or  remove',CR,LF
 DB 9,'directories,  sort or unsort the directory display,  and  specify',CR,LF
 DB 9,'the displayed directory via wildcards.  HFM displays the  default',CR,LF
 DB 9,'directory  from the default disk on the screen, with one  of  the',CR,LF
 DB 9,'entries  highlighted.  The indicator (highlighted entry)  may  be',CR,LF
 DB 9,'moved using the four arrow keys on the keyboard.  If the  indica-',CR,LF
 DB 9,'tor  is  at the last entry in a column, the down arrow  key  will',CR,LF
 DB 9,'move  it to the top of the next column.  If the indicator  is  at',CR,LF
 DB 9,'the  last entry on the page, the down arrow will move it  to  the',CR,LF
 DB 9,'first  entry.   The up arrow key works similarly.  The  HOME  key',CR,LF
 DB 9,'moves the indicator directly to the first entry.',CR,LF,LF
 DB 9,'Near the bottom of the screen is a command line containing a list',CR,LF
 DB 9,'of  available commands, with one of them highlighted.  A  command',CR,LF
 DB 9,'may selected by typing the first character of the command, or  by',CR,LF
 DB 9,'moving the highlighted command with the SPACE, TAB, or  BACKSPACE',CR,LF
 DB 9,'keys and selecting it with the RETURN or ENTER key.  Specific in-',CR,LF
 DB 9,'formation  about each command may be obtained by pressing the  F1',CR,LF
 DB 9,'key with the desired command highlighted.$'

IHLP	DB 9,'Change/Create Disk ID',CR,LF,LF
 DB 9,'You  will  be  prompted for a new disk identification label to be',CR,LF
 DB 9,'placed on the currently selected disk.   The label on the disk is',CR,LF
 DB 9,'shown at the top right corner of the screen.$'

LHLP	DB 9,'List File in Hex',CR,LF,LF
 DB 9,'The file you have selected is displayed on  the  screen  in  both',CR,LF
 DB 9,'hexadecimal  (hex)  and  ASCII,  with 16 bytes per line.   In the',CR,LF
 DB 9,'ASCII (text) field,  printable characters that have the high  bit',CR,LF
 DB 9,'set are shown highlighted.  The listing will pause every 16 lines',CR,LF
 DB 9,'256 bytes).  Type Control-C to exit before the end is reached, or',CR,LF
 DB 9,'any other key to continue.$'

MHLP	DB 9,'More Files',CR,LF,LF
 DB 9,'If  there  are more files in a directory than can be displayed on',CR,LF
 DB 9,'the screen,  the words MORE FILES will appear in the lower  right',CR,LF
 DB 9,'corner.   This command can then be used to display the additional',CR,LF
 DB 9,'files.   If you use this command when the screen shows the end of',CR,LF
 DB 9,'the directory, the beginning will be re-displayed.',CR,LF,LF
 DB 9,'If all the files can be displayed at once,  this  command  is not',CR,LF
 DB 9,'active.$'

NHLP	DB 9,'New Disk/Directory',CR,LF,LF
 DB 9,'You will be prompted to enter a letter (A-P) to designate the new',CR,LF
 DB 9,'default  drive.    You  can specify the current drive by pressing',CR,LF
 DB 9,'RETURN.  After you select a drive, HFM will  search  the  current',CR,LF
 DB 9,'directory  on  that drive for directory names.  If there are any,',CR,LF
 DB 9,'they will be displayed.  You may then enter a directory  pathname',CR,LF
 DB 9,'to become the new current directory.   Enter  a  RETURN  only  in',CR,LF
 DB 9,'response to the prompt to retain the current directory.',CR,LF,LF
 DB 9,'When you select a NEW drive, the root  directory  on  that  drive',CR,LF
 DB 9,'becomes  the  current  directory  that  is searched for directory',CR,LF
 DB 9,'names.  If the drive you designate is the CURRENT drive, the last',CR,LF
 DB 9,'directory  selected is retained as the current directory, and any',CR,LF
 DB 9,'directory names in it will be displayed.  Therefore, by repeated-',CR,LF
 DB 9,'ly  selecting  the  current  drive,  you can work your way into a',CR,LF
 DB 9,'directory tree of several branches.  To work backwards in a tree,',CR,LF
 DB 9,'enter .. as the new directory name.',CR,LF,LF
 DB 9,'If there are no sub directories in  the  current  directory,  you',CR,LF
 DB 9,'will hear a beep, and the current directory will be displayed.',CR,LF,LF
 DB 9,'To change disks in a drive, change the disks first, then use this',CR,LF
 DB 9,'command and select the drive where the change was made.$'

PHLP	DB 9,'Print File',CR,LF,LF
 DB 9,'You will be asked if you want to use  PRINT.COM  to print the se-',CR,LF
 DB 9,'lected file.   If you answer Y(es),  the file will be  passed  to',CR,LF
 DB 9,'PRINT.COM,  which  will  store it in its queue and return control',CR,LF
 DB 9,'to HFM.   Printing will procede while you  perform  other  tasks.',CR,LF
 DB 9,'PRINT.COM must have been loaded before you started HFM if you se-',CR,LF
 DB 9,'lect  this  option.   If it has not been loaded, a large block of',CR,LF
 DB 9,'system memory will be lost when you exit HFM.   (The memory  lost',CR,LF
 DB 9,'is restored if you re-boot.)',CR,LF,LF
 DB 9,'If you do not use PRINT.COM to print the file,  HFM will print it',CR,LF
 DB 9,'itself,  and will not return to the directory menu until the file',CR,LF
 DB 9,'has been printed.$'

QHLP	DB 9,'Quit File Manager',CR,LF,LF
 DB 9,'The HUG File Manager returns control to the operating system.$'

RHLP	DB 9,'Rename File',CR,LF,LF
 DB 9,'You will be prompted for a new name for the selected file.    The',CR,LF
 DB 9,'file will then be renamed.$'

SHLP	DB 9,'Sort Directory',CR,LF,LF
 DB 9,'The directory is sorted alphabetically and displayed in that form',CR,LF
 DB 9,'on the screen.   This is the normal condition when the program is',CR,LF
 DB 9,'started.$'

THLP	DB 9,'Type File',CR,LF,LF
 DB 9,'The contents of the text file you have selected are displayed  on',CR,LF
 DB 9,'the screen.  The display will pause each time 23 lines have  been',CR,LF
 DB 9,'printed.   Type  Control-C  to exit before the file has been com-',CR,LF
 DB 9,'pletely printed, or any other key to continue.$'

UHLP	DB 9,'Unsort/Unflag Directory',CR,LF,LF
 DB 9,'The directory is unsorted and the file names are displayed on the',CR,LF
 DB 9,'screen  in  the  order  in  which  they  are  stored  in the disk',CR,LF
 DB 9,'directory.   Any  flags  that  were placed on files with the Flag',CR,LF
 DB 9,'command are removed.$'

WHLP	DB 9,'Wildcard Specification',CR,LF,LF
 DB 9,'You will be prompted for a wild card specification that will  de-',CR,LF
 DB 9,'termine  which  files from the current directory are shown on the',CR,LF
 DB 9,'screen.   For example,  if  you  want to see only files ending in',CR,LF
 DB 9,'.ASM, you can enter *.ASM as the wildcard specification.  To show',CR,LF
 DB 9,'show all files in the current directory again,  use  this command',CR,LF
 DB 9,'and enter *.* as the specification.  Note:  The wildcard specifi-',CR,LF
 DB 9,'cation  is  cleared to show all files when the Newdisk command is',CR,LF
 DB 9,'used.$'

;
WAITKEY	LABEL	byte
	ADDR	25,1
	DB	esc,'K'
	DB	'Type any character to return to directory menu..$'
WAITKEY1	LABEL	BYTE
	ADDR	25,1
	DB	ESC,'K'
	DB	7
WAITKEY2	DB	'Type any character..$'

CRLF	DB	CR,LF,'$'
TOMSG	DB	' to $'
BEGLIN	DB	':  $'
SEPMSG	DB	'  ',27,'F`',27,'G$'
COPYING	DB	'Copying...',CR,LF,'$'
;
wildcard	DB	'????????.???',0
;
FIND_BUF	struc
res		DB	21 DUP (?)
attr		DB	?
time		DW	?
date		DW	?
size_l		DW	?
size_h		DW	?
pname		DB	13 DUP (?)
FIND_BUF	ends
;
PROG_BLK	LABEL	WORD
	DW	0
	DW	BUF,0
	DW	fcb1,0
	DW	fcb2,0
;
PRNT_PROG	DB	64 DUP (0)
;
PRINTCOM	DB	9,'PRINT.COM'
PATH		DB	5,'PATH='
;
DIR_ENT_ADDR	LABEL	byte
	ADDR	5,2
	ADDR	6,2
	ADDR	7,2
	ADDR	8,2
	ADDR	9,2
	ADDR	10,2
	ADDR	11,2
	ADDR	12,2
	ADDR	13,2
	ADDR	14,2
	ADDR	15,2
	ADDR	16,2
	ADDR	17,2
	ADDR	18,2
	ADDR	19,2
	ADDR	20,2
	ADDR	21,2
	ADDR	5,16
	ADDR	6,16
	ADDR	7,16
	ADDR	8,16
	ADDR	9,16
	ADDR	10,16
	ADDR	11,16
	ADDR	12,16
	ADDR	13,16
	ADDR	14,16
	ADDR	15,16
	ADDR	16,16
	ADDR	17,16
	ADDR	18,16
	ADDR	19,16
	ADDR	20,16
	ADDR	21,16
	ADDR	5,30
	ADDR	6,30
	ADDR	7,30
	ADDR	8,30
	ADDR	9,30
	ADDR	10,30
	ADDR	11,30
	ADDR	12,30
	ADDR	13,30
	ADDR	14,30
	ADDR	15,30
	ADDR	16,30
	ADDR	17,30
	ADDR	18,30
	ADDR	19,30
	ADDR	20,30
	ADDR	21,30
	ADDR	5,44
	ADDR	6,44
	ADDR	7,44
	ADDR	8,44
	ADDR	9,44
	ADDR	10,44
	ADDR	11,44
	ADDR	12,44
	ADDR	13,44
	ADDR	14,44
	ADDR	15,44
	ADDR	16,44
	ADDR	17,44
	ADDR	18,44
	ADDR	19,44
	ADDR	20,44
	ADDR	21,44
	ADDR	5,58
	ADDR	6,58
	ADDR	7,58
	ADDR	8,58
	ADDR	9,58
	ADDR	10,58
	ADDR	11,58
	ADDR	12,58
	ADDR	13,58
	ADDR	14,58
	ADDR	15,58
	ADDR	16,58
	ADDR	17,58
	ADDR	18,58
	ADDR	19,58
	ADDR	20,58
	ADDR	21,58

;	MAIN PROGRAM

;	PERFORM SETUP CHORES

BEGIN:	MOV	SP,OFFSET BA.STACK
	CLD
	MOV	AL,DFATTR
	MOV	VATTR,AL		;SET VIDEO ATTR
	AND	AL,77H			;REMOVE INTENSITY, ETC.
	MOV	AH,AL			;COPY TO AH
	MOV	CL,4
	SHR	AH,CL			;SHIFT HIGH NIBBLE DOWN
	AND	AL,0FH			;ISOLATE LOW
	MOV	BX,OFFSET COLTBL
	XCHG	AL,AH
	XLAT				;TRANSLATE COLORS TO Z-100 VALUES
	XCHG	AL,AH
	XLAT
	ADD	AX,3030H		;MAKE IT ASCII
	MOV	ZATTR,AX		;SET Z-100 COLORS
	OR	AH,80H			;SET HI BIT ON BACKGROUND
	MOV	WORD PTR ZATTR1,AX	;OTHER Z-100 COLOR PLACE
	MOV	AL,HIATTR
	AND	AL,77H
	MOV	AH,AL			;COPY TO AH
	MOV	CL,4
	SHR	AH,CL			;SHIFT HIGH NIBBLE DOWN
	AND	AL,0FH			;ISOLATE LOW
	XCHG	AL,AH
	XLAT				;TRANSLATE COLORS TO Z-100 VALUES
	XCHG	AL,AH
	XLAT
	ADD	AX,3030H		;MAKE IT ASCII
	OR	AH,80H
	MOV	WORD PTR ZHATTR,AX	;SET Z-100 HIGHLIGHT COLORS
	MOV	AH,30H
	INT	21H			; get DOS version
	CMP	AL,2			; ensure MS-DOS 2.x
	JAE	VER_OK
	MOV	DX,OFFSET BADVERSION
	MOV	AH,9
	INT	21H			;SAY "BAD VERSION"
	INT	20H
VER_OK:
;	MOV	AX,0C00H
;	INT	21H			; FLUSH TYPE-AHEAD
	MOV	SI,OFFSET PATH
	MOV	BX,OFFSET PRNT_PROG	; get current PATH
	LODSB
	MOV	CL,AL
	XOR	CH,CH
	CALL	GET_ENV_PARM
	MOV	AL,'\'
	CMP	AL,-1[DI]		; ensure '\' separator
	JE	PATH_PARM_OK
	STOSB		
PATH_PARM_OK:
	MOV	SI,OFFSET PRINTCOM
	LODSB				; PRINT.COM behind PATH
	MOV	CL,AL
	XOR	CH,CH
	REP 	MOVSB
;
	MOV	AH,19H
	INT	21H			; GET CURRENT DISK
	MOV	DL,AL
	ADD	AL,'A'
	MOV	CUR_DISK,AL
	INC	dl
	MOV	SI,OFFSET CUR_DIR
	MOV	AH,47h			; current directory
	INT	21H
;
	MOV	BX,1000H		; USE ALL OF THIS SEGMENT
	MOV	AH,4ah
	INT	21H
	JNC	MEMOK			; ALL MEMORY AVAILABLE
	MOV	AX,BX
	MOV	CL,4
	SHL	AX,CL
	MOV	MEMTOP,AX		; ELSE, SET NEW MEMORY TOP
	SUB	AX,OFFSET BA.RDBUF	;CHECK AVAILABLE MEMORY
	JB	NEMEM			;NOT ENOUGH
	CMP	AX,1000H		;AT LEAST 4K FOR COPYING?
	JAE	MEMOK1			;YES
NEMEM:	MOV	DX,OFFSET BADMEM
	MOV	AH,9
	INT	21H			;ELSE, SAY "NOT ENOUGH MEMORY"
	INT	20H			;AND EXIT
MEMOK1:	MOV	AH,4AH
	INT	21H			; AND FREE THAT MUCH
;
MEMOK:	MOV	AX,ds
	MOV	PROG_BLK[4],AX
	MOV	PROG_BLK[8],AX		; segment fixups
	MOV	PROG_BLK[12],AX
;
	MOV	AX,40H
	MOV	DS,AX			;POINT TO BIOS RAM
	ASSUME	DS:BIOS
	CMP	JMPTBL,0E9H		;CHECK FOR A JUMP
	PUSH	CS
	POP	DS			;FIX DS
	ASSUME	DS:HFM
	JNZ	GOTPC			;IT'S A PC
	MOV	TTYPE,1			;ELSE, FLAG A Z-100
Z100:	CALL	TYPTX
	DB	27,'m'
ZATTR	DW	3137H			;SET COLORS
	DB	27,'E'+80H		;CLEAR SCREEN
	JMP	SHORT GOTZ
GOTPC:	MOV	AH,3
	INT	10H			; GET CURSOR TYPE
	MOV	CURTYPE,CX		; SAVE IT
	CALL	IBMRST			; RESET SCREEN
GOTZ:
	MOV	DX,OFFSET INIT_MSG	; initialize the terminal
	CALL	DSPMSG
	CALL	GET_DIRECT		; GET DIRECTORY

;	MAIN COMMAND LOOP

;	REPAINT ENTIRE SCREEN

REPAINT:MOV	SP,OFFSET BA.STACK	; FIX STACK
	MOV	DX,OFFSET REPAINT
	MOV	AX,2523H
	INT	21H			; SET CONTROL-C ADDRESS
	MOV	DX,OFFSET CLR_SCREEN
	CALL	DSPMSG
	CALL	DISP_CMD_LINE
	CALL 	DIrectory_DISPlay

;	GET SINGLE KEY PRESS, PROCESS IT

GET_KEY:CALL	GETBK			;GET KEY FROM BIOS
	MOV	BX,OFFSET KEY_TABLE	; ASSUME REGULAR TABLE
	CMP	TTYPE,0			;PC?
	JZ	GETPCK
	CMP	AL,1BH			; ESC?
	JZ	GOTESC			; YES
NORKEY:	CALL	MUC			; MAKE CHAR UPPER CASE
KEY_CHK:
	CMP	BYTE PTR [BX],0
	JE	GET_KEY			; ignore if not in table
	CMP	AL,[BX]
	JE	GOT_KEY
	ADD	BX,3
	JMP	KEY_CHK
GOT_KEY:
	INC	BX
	JMP	WORD PTR [BX]
GOTESC:	MOV	BX,OFFSET Z100TBL	; USE Z-100 TABLE
WFKEY:	MOV	CX,50			; SET A COUNTER
WFKEY1:	CALL	GETBKS			; CHECK STATUS
	JNZ	KEY_CHK			; GOT SEQUENCE CHAR
	LOOP	WFKEY1			; ELSE, TRY AGAIN
	JMP	GET_KEY			; TIMED OUT, NO KEY SEQUENCE
GETPCK:	OR	AL,AL			;NULL?
	JNZ	NORKEY			;NO, NORMAL KEY
	MOV	AL,AH			;ELSE, SCAN CODE TO AL
	MOV	BX,OFFSET Z150TBL	; USE Z-150 TABLE
	JMP	SHORT KEY_CHK		;AND CHECK THE KEY
;
KEY_TABLE:
	DB	08h
	DW	OFFSET	DOBS
	DB	09h
	DW	OFFSET	DOTAB
	DB	0dh
	DW	OFFSET	DOCR
	DB	20h
	DW	OFFSET DOSPC
	DB	'C'
	DW	OFFSET DOCOPY
	DB	'D'
	DW	OFFSET DODIR
	DB	'E'
	DW	OFFSET DOERA
	DB	'F'
	DW	OFFSET DOFLAG
	DB	'H'
	DW	OFFSET DOHLP
	DB	'I'
	DW	OFFSET DOID
	DB	'L'
	DW	OFFSET DOHEX
	DB	'M'
	DW	OFFSET DOMORE
	DB	'N'
	DW	OFFSET DONEW
	DB	'P'
	DW	OFFSET DOPRT
	DB	'Q'
	DW	OFFSET DOQUIT
	DB	'R'
	DW	OFFSET DOREN
	DB	'S'
	DW	OFFSET DOSORT
	DB	'T'
	DW	OFFSET DOTYPE
	DB	'U'
	DW	OFFSET DOUNSRT
	DB	'W'
	DW	OFFSET DOWILD
	DB	0
Z100TBL:
	DB	'~'
	DW	OFFSET DOHELP
	DB	'A'
	DW	OFFSET DOUP
	DB	'B'
	DW	OFFSET DODWN
	DB	'C'
	DW	OFFSET DORT
	DB	'D'
	DW	OFFSET DOLFT
	DB	'H'
	DW	OFFSET DOHOM
	DB	'S'
	DW	OFFSET DOHELP
	DB	0
Z150TBL:
	DB	';'
	DW	OFFSET DOHELP
	DB	'H'
	DW	OFFSET DOUP
	DB	'P'
	DW	OFFSET DODWN
	DB	'M'
	DW	OFFSET DORT
	DB	'K'
	DW	OFFSET DOLFT
	DB	'G'
	DW	OFFSET DOHOM
	DB	0

;	EXECUTE COMMANDS

;	MOVE COMMAND INDICATOR LEFT

DOBS:	CALL	NRM_CURC
	DEC	CUR_CMD
	CMP	CUR_CMD,0
	JGE	NO_WRP
	MOV	CUR_CMD,MAX_CMD
NO_WRP:
	CALL	REV_CURC
	JMP	GET_KEY

;	MOVE COMMAND INDICATOR RIGHT

DOSPC:
DOTAB:	CALL	NRM_CURC
	INC	CUR_CMD
	CMP	CUR_CMD,MAX_CMD
	JBE	NO_WRP
	MOV	CUR_CMD,0
	JMP	NO_WRP

;	RETURN PRESSED, EXECUTE SELECTED COMMAND

DOCR:	MOV	SI,CUR_CMD
	SHL	SI,1
	JMP	WORD PTR CMD_JMP_TBL[SI]
;
CMD_JMP_TBL	LABEL	WORD
	DW	OFFSET	DOCOPY
	DW	OFFSET	DODIR
	DW	OFFSET	DOERA
	DW	OFFSET	DOFLAG
	DW	OFFSET  DOHLP
	DW	OFFSET	DOID
	DW	OFFSET	DOHEX
	DW	OFFSET	DOMORE
	DW	OFFSET	DONEW
	DW	OFFSET	DOPRT
	DW	OFFSET	DOQUIT
	DW	OFFSET	DOREN
	DW	OFFSET	DOSORT
	DW	OFFSET	DOTYPE
	DW	OFFSET	DOUNSRT
	DW	OFFSET	DOWILD

;	MOVE FILE INDICATOR RIGHT

DORT:	CMP	FILECNT,0
	JZ	GET_KEYJ
	CALL	CUR_ENT_NRM
	ADD	CUR_ENT,17
	MOV	AX,MAX_ENT
	CMP	AX,CUR_ENT
	JA 	DORT_DISP
	SUB	CUR_ENT,17		; no wrap on right
DORT_DISP:
	CALL	CUR_ENT_REV
	MOV	DX,OFFSET SEL_DISP
	CALL	DSPMSG
	CALL	CUR_ENT_DIS
	CALL	CUR_ENT_SIZE
GET_KEYJ:
	JMP	GET_KEY

;	MOVE FILE INDICATOR LEFT

DOLFT:	CMP	FILECNT,0
	JZ	GET_KEYJ
	CALL	CUR_ENT_NRM
	SUB	CUR_ENT,17
	CMP	CUR_ENT,0
	JGE	DORT_DISP
	ADD	CUR_ENT,17		; no wrap on left
	JMP	DORT_DISP

;	MOVE FILE INDICATOR UP

DOUP:	CMP	FILECNT,0
	JZ	GET_KEYJ
	CALL	CUR_ENT_NRM
	DEC	CUR_ENT
	CMP	CUR_ENT,0
	JGE	DORT_DISP
	MOV	AX,MAX_ENT
	DEC	AX
	MOV	CUR_ENT,AX
	JMP	DORT_DISP

;	MOVE FILE INDICATOR DOWN

DODWN:	CMP	FILECNT,0
	JZ	GET_KEYJ
	CALL	CUR_ENT_NRM
	INC	CUR_ENT
	MOV	AX,CUR_ENT
	CMP	AX,MAX_ENT
	JB 	DORT_DISP
	MOV	CUR_ENT,0
	JMP	DORT_DISP

;	HOME THE FILE INDICATOR

DOHOM:	CMP	FILECNT,0
	JZ	GET_KEYJ
	CALL	CUR_ENT_NRM
	MOV	CUR_ENT,0
	JMP	DORT_DISP

;	SHOW HELP ON SELECTED COMMAND

DOHLP:	MOV	DX,OFFSET CLR_SCREEN
	CALL	DSPMSG
	MOV	DX,OFFSET hhlp
	JMP	DOHELP_DIS

;	SHOW MAIN HELP SCREEN

DOHELP:	MOV	DX,OFFSET CLR_SCREEN	; clear screen
	CALL	DSPMSG
	MOV	SI,CUR_CMD
	SHL	SI,1
	MOV	DX,hlp_vct[SI]
DOHELP_DIS:
	CALL	DSPMSG
WAIT_KEYIN:
	MOV	DX,OFFSET WAITKEY
	CALL	DSPMSG
	CALL	POSCUR
	CALL	GETBK			; WAIT FOR A KEY
	JMP	REPAINT

;	COPY FILE(S)

DOCOPY:	CMP	FILECNT,0
	JNZ 	DOCOPY_OK
	JMP	FILES_ERR
DOCOPY_OK:
	MOV	DX,OFFSET CLEANX
	MOV	AX,2523H
	INT	21H			; SET CONTROL-C EXIT
	MOV	ZEROPOS,OFFSET BA.STACK	; FAKE ZERO POSITION
	MOV	DX,OFFSET INIT_PROMPT		
	CALL	DSPMSG
	MOV	DX,OFFSET DEST_FILE_REQ	; get destination file name
	CALL	DSPMSG
	MOV	AL,7EH
	CALL	GETSTR
	CMP	BA.LINEBUF+1,0		; no action if null entry
	JNE	DOCOPY1
	JMP	RECMDJ
DOCOPY1:MOV	DI,OFFSET BA.LINEBUF+2	;POINT TO ENTRY
	MOV	CL,BA.LINEBUF+1		;GET CHARACTER COUNT
	XOR	CH,CH
	MOV	AL,':'			;LOOK FOR THIS
	CLD
	REPNZ	SCASB
	JNZ	NODRV			;NO DRIVE SPECIFIED
	MOV	AL,-2[DI]		;ELSE, GET DRIVE
	AND	AL,1FH			;REMOVE ASCII
	JMP	SHORT STDRV		;STORE DRIVE CODE
NODRV:	MOV	AH,19H
	INT	21H			;GET DEFAULT DRIVE
	INC	AL			;MAKE IT 1-BASED
STDRV:	MOV	DESTDRV,AL		;STORE IT
	CMP	FLAGCNT,0		; ANY FLAGS?
	JZ	DOCOPY2			; NO
	MOV	AX,FILECNT
	MOV	TFCNT,AX		; ELSE, SET TEMP. COUNT
	MOV	AX,OFFSET BA.DIRPTR
	MOV	CUR_ADR,AX		; SET CURRENT FILE ADDRESS
	MOV	FLG2FLG,1		; AND SET TEMP. FLAG
DOCOPY2:
	MOV	DX,OFFSET CLR_SCREEN
	CALL	DSPMSG			; CLEAR SCREEN
	MOV	DX,OFFSET COPYING
	CALL	DSPMSG			; SAY "COPYING"
COPYLP:
	CALL	GET_CURRENT		; GET CURRENT FILE NAME
	JNC	NCEND
	JMP	COPYX			; END OF COPYING
NCEND:	PUSH	DX			; SAVE NAME ADDRESS
	MOV	AL,':'
	CALL	FIXNAM			; DEST. NAME END IN ":"?
	JNC	GOTCOL			; IT DID
	MOV	AL,'\'
	CALL	FIXNAM			; ELSE, CHECK FOR "\"
GOTCOL:	MOV	SI,DX
	CALL	PRNAME			; PRINT FILE NAME
	MOV	DX,OFFSET TOMSG
	CALL	DSPMSG			; PRINT "TO"
	MOV	SI,OFFSET BA.LINEBUF+2
	CALL	PRNAME			; PRINT DEST. NAME
	CALL	POSCUR			; POSITION CURSOR AFTER MSG
	POP	DX			; GET NAME ADDRESS
	CALL	OPENFIL			; OPEN INPUT FILE
	JNC	DOCOPY3			; OPEN OK
COPYRE:	MOV	DX,OFFSET READ_ERR_MSG
	CALL	DSPMSG			; INDICATE ERROR
	CALL	CLEANUP			; CLOSE FILES
	JMP	COPYR
DOCOPY3:MOV	AH,4EH
	INT	21H			;GET SOURCE FILE DIR. ENTRY
;	PUSH	DX
	MOV	BX,INHAND
	MOV	AX,5700H
	INT	21H			; GET SOURCE FILE DATE
	MOV	DATSAVE,DX		; SAVE DATE
	MOV	TIMSAVE,CX		; SAVE TIME

CHKSPC:	MOV	AH,36H
	MOV	DL,DESTDRV		;GET DESTINATION DRIVE
	INT	21H			; GET FREE SPACE FROM SYSTEM
	MUL	CX			; COMPUTE BYTES/CLUSTER
	MOV	CX,AX
	MOV	AX,BX			; AX = FREE CLUSTERS
	MUL	CX			; COMPUTE BYTES FREE
	SUB	AX,BUF.SIZE_L		;SUBTRACT SOURCE FILE SIZE
	SBB	DX,BUF.SIZE_H
	JAE	SPACEOK			;ENOUGH SPACE ON DISK
	MOV	DX,OFFSET NO_SPACE
	CALL	DSPMSG			;ELSE, SAY "NO SPACE
	MOV	AX,4408H
	MOV	BL,DESTDRV
	INT	21H			;CHECK FOR REMOVABLE DISK
	JC	NOTRMV			;NOT REMOVABLE
	MOV	DX,OFFSET CH_DISK
	CALL	DSPMSG			;ASK "CHANGE DISK?"
	CALL	POSCUR
	MOV	AH,1
	INT	21H			; GET REPLY
	CALL	MUC
	CMP	AL,'Y'			; OK TO CHANGE?
	JNZ	NOTRMV			;NO
	MOV	DX,OFFSET REP_DISK
	CALL	DSPMSG			;PROMPT FOR DISK CHANGE
	CALL	POSCUR
WFCR:	MOV	AH,8
	INT	21H
	CMP	AL,13			;CR?
	JNZ	WFCR			;WAIT FOR ONE
	MOV	DX,OFFSET TRY_COPY
	CALL	DSPMSG
	CALL	POSCUR
	JMP	CHKSPC			;AND CHECK SPACE ON NEW DISK
NOTRMV:	JMP	COPYX			;DISK NOT CHANGED, EXIT

SPACEOK:MOV	DX,OFFSET BA.LINEBUF+2
	MOV	AX,3D00H
	INT	21H			; TRY TO OPEN OUTPUT
	JC	NODEST			; FILE NOT THERE
	MOV	BX,AX
	MOV	AH,3EH
	INT	21H			; ELSE, CLOSE FILE
	PUSH	DX
	MOV	DX,OFFSET FILE_EX
	CALL	DSPMSG			; SAY "FILE EXISTS"
	CALL	POSCUR			;PUT CURSOR AFTER PROMPT
	POP	DX
	MOV	AH,1
	INT	21H			; GET REPLY
	CALL	MUC
	CMP	AL,'Y'			; OK TO DELETE?
	JZ	NODEST			; YES
	MOV	BX,INHAND
	MOV	AH,3EH
	INT	21H			; ELSE, CLOSE INPUT FILE
	JMP	COPYR			; AND LOOP
NODEST:	MOV	CX,20H			; SET ARCHIVE ATTRIBUTE
	MOV	AX,3C01H		; OPEN DESTINATION
	INT	21H
	MOV	OUTHAND,AX		; SAVE OUTPUT HANDLE
	JNC	COPYLP1			; OPEN OK
	JMP	SHORT COPYER
COPYLP1:CALL	READFIL			; READ FROM SOURCE
	JNC	COPYLP2
	JMP	COPYRE
COPYLP2:MOV	BX,OUTHAND
	MOV	AH,40H			; WRITE TO DEST.
	INT	21H
	JNC	DOCOPY4			; WRITE OK
COPYER:	MOV	DX,OFFSET WRIT_ERR_MSG
	CALL	DSPMSG
	CALL	CLEANUP			; CLOSE OPEN FILES
	JMP	SHORT COPYR
DOCOPY4:CMP	BYTE PTR EOFFLG,0	; END OF FILE?
	JZ	COPYLP1			; IF NOT, LOOP
	MOV	DX,DATSAVE
	MOV	CX,TIMSAVE
	MOV	BX,OUTHAND
	MOV	AX,5701H
	INT	21H			; SET TIME IN OUTPUT FILE
	MOV	BX,INHAND
	MOV	AH,3EH			; CLOSE INPUT FILE
	INT	21H
	MOV	BX,OUTHAND
	MOV	AH,3EH			; CLOSE OUTPUT FILE
	INT	21H
	JC	COPYER			; NO
COPYR:	MOV	DX,OFFSET CRLF
	CALL	DSPMSG			; PRINT CR, LF
	CMP	FLAGCNT,0		; COPYING FLAGGED FILES?
	JZ	COPYX			; IF NOT, DONE
	MOV	SI,ZEROPOS
	MOV	BYTE PTR [SI],0		; FIX ZERO IN OUTPUT NAME
	JMP	COPYLP			; LOOP
COPYX:	MOV	FLG2FLG,0
	JMP	WAIT_KEYIN
CLEANX:	MOV	FLG2FLG,0
	CALL	CLEANUP			; CLOSE OPEN FILES
	JMP	REPAINT
;
FILES_ERR:
	MOV	DX,OFFSET MSG_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET FILE_ERR_MSG
ERR_XIT:
	CALL	DSPMSG
	JMP	WAITJ

;	MAKE/REMOVE DIRECTORY

DODIR:	MOV	DX,OFFSET INIT_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET DIR_TYPE_REQ
	CALL	DSPMSG
	CALL	POSCUR			;PUT CURSOR AFTER PROMT
	MOV	AH,1
	INT	21H
	CALL	MUC
	MOV	BP,AX			; SAVE ANSWER
	CMP	AL,'M'			; CHECK FOR VALID ANSWER
	JZ	DODIR1
	CMP	AL,'R'
	JZ	DODIR1
	JMP	RECMDJ			; BAD ENTRY
DODIR1:	MOV	DX,OFFSET INIT_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET DIR_NAM_REQ
	CALL	DSPMSG
	MOV	AL,7EH
	CALL	GETSTR
	CMP	BA.LINEBUF+1,0		; ignore if null entry
	JNE	DODIR2
	JMP	RECMDJ
DODIR2:	MOV	BL,BA.LINEBUF+1
	XOR	BH,BH			; BX = CHAR COUNT
	MOV	BA.LINEBUF+2[BX],0	; null string terminator
	MOV	DX,OFFSET BA.LINEBUF+2	; POINT TO NEW NAME
	MOV	AX,BP			; GET USER SELECTION
	MOV	AH,39H			; ASSUME MAKE
	CMP	AL,'R'			; REMOVE?
	JNZ	DODIR3			; NO
	MOV	AH,3AH			; ELSE, USE REMOVE FUNCTION
DODIR3:	INT	21H			; PERFORM FUNCTION
	JC	DODIRER			; ERROR
DODIRX:	CALL	DISP_CMD_LINE		; REPLACE COMMAND LINE
	CALL	GETFREE			; GET FREE SPACE
	CALL	SHOWBOT			; SHOW FREE SPACE
	JMP	GET_KEY
DODIRER:MOV	DX,OFFSET MSG_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET DIR_ERR_MSG
	CALL	DSPMSG
	MOV	DX,OFFSET WAITKEY1
	CALL	DSPMSG
	CALL	GETBK			; WAIT FOR KEY
	JMP	DODIRX

;	ERASE FILE(S)

DOERA:	CMP	FILECNT,0
	JNZ	DOERA0
	JMP	FILES_ERR
DOERA0:	MOV	DX,OFFSET INIT_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET CONFIRM_REQ	; ask for confirmation
	CMP	FLAGCNT,0		; ANY FLAGS?
	JZ	DOERA1			; NO
	MOV	AX,FILECNT
	MOV	TFCNT,AX		; ELSE, SET TEMP. COUNT
	MOV	AX,OFFSET BA.DIRPTR
	MOV	CUR_ADR,AX		; SET CURRENT ADDRESS
	MOV	FLG2FLG,1		; AND SET TEMP. FLAG
	MOV	DX,OFFSET CONFIRM_REQ1	; USE SPECIAL CONFIRM MSG.
DOERA1:	CALL	DSPMSG
	CALL	POSCUR			;PUT CURSOR AFTER PROMPT
	MOV	AH,1
	INT	21H  			; get reply
	CALL	MUC
	CMP	AL,"Y"
	JE	DEL_OK			; must be Y or y
RECMDJ:
	MOV	FLG2FLG,0		; CLEAR TEMP. FLAG
	CALL	DISP_CMD_LINE
	JMP	GET_KEY
DEL_OK:
	CALL 	GET_CURRENT
	MOV	SI,DX			; SAVE CUR. ADDRESS
	JC	DELX			; END OF DELETIONS
	PUSH	DX
	MOV	DX,OFFSET ERASING
	CALL	DSPMSG			; SAY "ERASING"
	POP	DX
	MOV	AH,41h			; delete file
	INT	21H
	JC	DEL_ERR
	CMP	FLAGCNT,0		; DOING FLAGS?
	JNZ	DEL_OK			; IF SO, LOOP
DELX:	MOV	CUR_ENT,0
	CALL	GET_DIR0		; RE-GET DIRECTORY
REPAINTJ:
	MOV	FLG2FLG,0
	JMP	REPAINT			; RE-SHOW DIRECTORY
DEL_ERR:
	MOV	DX,OFFSET MSG_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET DEL_ERR_MSG
	CALL	DSPMSG
	CLD
	CALL	PRNAME			; PRINT FILE NAME
	CMP	FLAGCNT,0		; DOING FLAGS?
	JZ	WAITJ			; IF NOT, EXIT
	MOV	DX,OFFSET WAITKEY1
	CALL	DSPMSG
	CALL	GETBK			; WAIT FOR KEY
	JMP	DEL_OK			; AND LOOP
WAITJ:	MOV	FLG2FLG,0
	JMP	WAIT_KEYIN

;	FLAG/UNFLAG FILE

DOFLAG:	MOV	SI,CUR_ENT		; GET CURRENT FILE NO.
	PUSH	SI
	SHL	SI,1
	SHL	SI,1			; MPY BY 4
	MOV	CX,4
FLAGLP:
	MOV	AL,DIR_ENT_ADDR[SI]	; address cursor to entry position
	CALL	SCOUT
	INC	SI
	LOOP	FLAGLP
	POP	SI			; GET CURRENT NO. AGAIN
	ADD	SI,PAGECNT		; ADD PAGE COUNT
	SHL	SI,1			; MPY BY 2
	TEST	WORD PTR BA.DIRPTR[SI],8000H	; TEST FOR FLAG BIT
	JNZ	UNFLAG			; SET, SO REMOVE FLAG
	OR	WORD PTR BA.DIRPTR[SI],8000H	; SET FLAG BIT
	INC	FLAGCNT			; COUNT FLAG
	MOV	DX,OFFSET FLG_MSG
	CALL	DSPMSG			; MARK FILE ON SCREEN
	CALL	GET_SIZE		; GET FILE SIZE
	ADD	FLAG_L,BX		; ADD TO TOTAL
	ADC	FLAG_H,AX
	JMP	SHORT FLAGX
UNFLAG:	AND	WORD PTR BA.DIRPTR[SI],7FFFH	; KILL FLAG BIT
	DEC	FLAGCNT			; DECREMENT COUNTER
	MOV	AL,8
	CALL	SCOUT			; REMOVE FLAG FROM DISPLAY
	MOV	AL,' '
	CALL	SCOUT
	CALL	GET_SIZE		; GET FILE SIZE
	SUB	FLAG_L,BX		; SUB FROM TOTAL
	SBB	FLAG_H,AX
FLAGX:	MOV	DX,OFFSET FSPC_MSG
	CALL	DSPMSG
	MOV	BX,FLAG_L		; GET TOTAL BYTES FLAGGED
	MOV	AX,FLAG_H
	CALL	DDECOUT			; SHOW FLAG BYTES
	JMP	GET_KEY

;	CHANGE/CREATE DISK ID

DOID:	CLD
	MOV	DX,OFFSET BUF
	MOV	AH,1AH
	INT	21H			; SET DTA TO BUF
	MOV	DX,OFFSET INIT_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET NEW_ID_REQ
	CALL	DSPMSG
	MOV	AL,12
	CALL	GETSTR
	MOV	BL,BA.LINEBUF+1
	XOR	BH,BH			; BX = CHAR COUNT
	CMP	BL,0			; IGNORE IF NULL ENTRY
	JNE	DOID1
	JMP	RECMDJ
DOID1:
	PUSH	BX			; SAVE CHAR COUNT
	CMP	LABFLAG,0		; OLD LABEL PRESENT?
	JNZ	DOID2			; YES
	MOV	SI,OFFSET DLFCB		; ELSE, PREPARE TO MAKE ONE
	MOV	DI,OFFSET BUF
	MOV	CX,(OFFSET DLFCBX)-(OFFSET DLFCB)
	REP	MOVSB
	MOV	SI,OFFSET NONE
	MOV	DI,(OFFSET BUF)+8
	MOV	CX,11
	REP	MOVSB
	MOV	DX,OFFSET BUF
	MOV	AH,16H			; CREATE DUMMY LABEL
	INT	21H
	OR	AL,AL
	JNZ	DOIDERR			; COULDN'T DO IT
DOID2:	CALL	GET_LABEL		; GET OLD LABEL
	MOV	DI,(OFFSET BUF)+18H
	MOV	CX,11
	MOV	AL,' '
	REP	STOSB			; FILL NEW NAME WITH SPACES
	POP	CX			; GET ENTERED CHAR COUNT
	MOV	SI,OFFSET BA.LINEBUF+2	; POINT TO NEW LABEL
	MOV	DI,(OFFSET BUF)+18H	; PUT IT HERE
	REP	MOVSB			; MOVE IT IN
	MOV	DX,OFFSET BUF
	MOV	AH,17H			; CHANGE LABEL NAME
	INT	21H
	OR	AL,AL
	JNZ	DOIDERR			; COULDN'T DO IT
	CALL	GET_LABEL		; ELSE, GET NEW LABEL
	MOV	DX,OFFSET LAB_MSG
	CALL	DSPMSG			; SHOW IT
	JMP	RECMDJ
DOIDERR:JMP	REN_ERR			; USE RENAME ERR MSG.

;	LIST FILE IN HEX

DOHEX:	CMP	FILECNT,0
	JNZ	DOHEX1
	JMP	FILES_ERR
DOHEX1:	MOV	LINECNT,16		; SET LINE COUNTER
	MOV	DX,OFFSET CLR_SCREEN
	CALL	DSPMSG
	MOV	DX,OFFSET CRLF
	CALL	DSPMSG
	CALL	GET_CURRENT
	PUSH	DX			; SAVE ADDRESS
	CALL	OPENFIL
	POP	DX
	JNC	DOHEX2
BHREAD:	MOV	DX,OFFSET READ_ERR_MSG
	CALL	DSPMSG
	CALL	CLEANUP			; CLOSE FILES
READEX:	JMP	WAIT_KEYIN
DOHEX2:	MOV	DI,0			; ASSUME START AT 0
	MOV	SI,DX			; POINT TO INPUT
DFPER:	LODSB
	OR	AL,AL			; END?
	JZ	HEXLP			; YES
	CMP	AL,'.'			; PERIOD?
	JNZ	DFPER			; LOOK FOR IT
	LODSW				; GET NEXT 3 CHARS
	MOV	BX,AX
	LODSB
	CMP	BX,'OC'			; COM FILE?
	JNZ	HEXLP			; NO
	CMP	AL,'M'
	JNZ	HEXLP
	MOV	DI,100H			; ELSE, START AT 100H
HEXLP:	CALL	READFIL			; READ IN FILE
	JC	BHREAD
	OR	CX,CX			; NULL FILE?
	JNZ	NOTNUL
	JMP	DONE			; IF SO, DONE
NOTNUL:	PUSH	CX
	SHR	CX,1
	SHR	CX,1
	SHR	CX,1
	SHR	CX,1
	POP	AX
	AND	AX,15
	MOV	BX,16			; ASSUME FULL LAST LINE
	JE	NOXTRA
	INC	CX   			; # 16-byte display lines in au
	MOV	BX,AX			; SAVE LAST LINE SIZE
NOXTRA:	MOV	SI,OFFSET BA.RDBUF	; buffer address
LINLP:	PUSH	CX
	PUSH	BX
	MOV	BX,DI
	MOV	AL,BH
	CALL	CVTBYTE			; PRINT ADDRESS HIGH
	MOV	AL,BL
	CALL	CVTBYTE			; PRINT ADDRESS LOW
	POP	BX
	MOV	DX,OFFSET BEGLIN
	CALL	DSPMSG			; DISPLAY LINE BEGINNING
	CMP	CX,1			; LAST LINE?
	MOV	CX,16			; ASSUME NOT, 16 bytes/line
	JNZ	NOTLST
	MOV	CX,BX			; ELSE, GET LAST LINE SIZE
NOTLST:	PUSH	CX			; SAVE COUNT
CHRLP:	LODSB
	CALL	CVTBYTE
	MOV	AL,' '
	CMP	CX,9			; SEP = '-' on 8th byte
	JNE	SEP
	MOV	AL,'-'
SEP:	CALL	SCOUT
	LOOP	CHRLP
	POP	CX			; GET BYTE COUNT FOR LINE
	SUB	SI,CX			; BACK UP TO LINE START
	MOV	DX,OFFSET SEPMSG
	CALL	DSPMSG
ASCLP:	XOR	AH,AH
	LODSB
	CMP	AL,' '
	JAE	HICHK
ASCLP1:	MOV	AL,'.'
HICHK:	CMP	AL,7FH			; CHAR > DELETE?
	JB	PRTIT
	AND	AL,7FH
	CMP	AL,7FH
	JZ	ASCLP1			; DONT'T PRINT DELETE CHAR
	CMP	AL,' '
	JC	ASCLP1
	PUSH	AX
	MOV	DX,OFFSET REV_MSG
	CALL	DSPMSG			; CHARS > 7FH ARE REVERSE VID.
	POP	AX
	MOV	AH,1
PRTIT:	CALL	SCOUT
	CMP	AH,0
	JZ	PRTIT1
	MOV	DX,OFFSET NRM_MSG
	CALL	DSPMSG
PRTIT1:	LOOP	ASCLP
	MOV	DX,OFFSET SEPMSG+2
	CALL	DSPMSG
	MOV	DX,OFFSET CRLF
	CALL	DSPMSG
	ADD	DI,16
	DEC	LINECNT			; COUNT THIS LINE
	JNZ	NOT16			; NOT 16 LINES
	MOV	DX,OFFSET WAITKEY2
	CALL	DSPMSG
	CALL	GETBK			; WAIT FOR KEY
	CMP	AL,3			; CONTROL-C?
	JNZ	NOTCC			; NO
	MOV	BX,INHAND
	MOV	AH,3EH			; CLOSE FILE
	INT	21H
	JMP	REPAINT			; ELSE, QUIT
NOTCC:	MOV	DX,OFFSET CRLF
	CALL	DSPMSG
	MOV	LINECNT,16		; RESET LINE COUNTER
NOT16:	POP	CX
	LOOP	LINLPJ
	JMP	ENDLN
LINLPJ:	CALL	GETBKS			; LOOK FOR A KEY
	JZ	LINLPJ1
	CMP	AL,3			; CONTROL-C?
	JZ	DONE			; IF SO, DONE
LINLPJ1:JMP	LINLP
ENDLN:	CMP	BYTE PTR EOFFLG,0	; END?
	JNZ	DONE
	JMP	HEXLP
DONE:	MOV	BX,INHAND
	MOV	AH,3EH			; CLOSE FILE
	INT	21H
	MOV	DX,OFFSET CRLF
	CALL	DSPMSG
	JMP	WAIT_KEYIN

;	SHOW MORE OF LARGE DIRECTORY

DOMORE:	CMP	BYTE PTR MOREFLG,0	; MORE FILES?
	JNZ	DOMORE1			; YES
	JMP	GET_KEY			; ELSE, IGNORE
DOMORE1:MOV	CUR_ENT,0
	ADD	PAGECNT,85		; SKIP 85 FILES
	MOV	DX,OFFSET CLR_SCREEN
	CALL	DSPMSG
	CALL	DISP_CMD_LINE
	CALL 	DIrectory_DISPlay
	JMP	GET_KEY

;	GET NEW DISK/DIRECTORY

DONEW:	MOV	DX,OFFSET INIT_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET NEW_DISK_REQ	; request new drive ID
	CALL	DSPMSG
	CALL	POSCUR			;PUT CURSOR AFTER PROMPT
	MOV	AH,1
	INT	21H
	CALL	MUC
	CMP	AL,'A'
	JB 	NO_NEW_DISK		; ignore invalid entries
	CMP	AL,'P'+1
	JNC	NO_NEW_DISK
	MOV	CUR_DISK,AL
	SUB	AL,'A'
	MOV	DL,AL
	MOV	AH,0EH
	INT	21H			; set new default drive
	XOR	DL,DL
	MOV	SI,OFFSET CUR_DIR	; new current directory
	MOV	AH,47h
	INT	21H
	MOV	CUR_ENT,0
NO_NEW_DISK:
	CALL	SUBDIRECTORY_DISPLAY
	JC	NO_NEW_DIR		; NO SUB DIRECTORIES
	MOV	DX,OFFSET NEW_DIR_REQ
	CALL	DSPMSG
	MOV	AL,36
	CALL	GETSTR
	CMP	BA.LINEBUF+1,0
	JE	NO_NEW_dir
	MOV	BL,BA.LINEBUF+1
	XOR	BH,BH
	MOV	BA.LINEBUF+2[BX],0	; string terminator
	MOV	DX,OFFSET BA.LINEBUF+2
	MOV	AH,3bh			; change current directory
	INT	21H
	JC	NEW_DIR_ERR
	MOV	SI,OFFSET CUR_DIR
	MOV	DL,0			; save in CUR_DIR
	MOV	AH,47h
	INT	21H
	MOV	CUR_ENT,0
NO_NEW_dir:
	CALL	GET_DIRECT		; GET NEW DIRECTORY
	JMP	REPAINT
NEW_DIR_ERR:
	MOV	DX,OFFSET DIR_ERR_MSG
	JMP	ERR_XIT

;	PRINT FILE (VIA PRINT UTILITY)

DOPRT:	CMP	FILECNT,0
	JNZ	DOPRT_OK
	JMP	FILES_ERR
DOPRT_OK:
	MOV	DX,OFFSET INIT_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET PRINT_REQ
	CALL	DSPMSG			; ASK "USE PRINT.COM?"
	CALL	POSCUR			;PUT CURSOR AFTER PROMPT
	MOV	AH,1
	INT	21H			; GET REPLY
	CALL	MUC
	CMP	AL,'Y'
	JZ	DOPRT1			; HE WANTS PRINT.COM
	CMP	AL,'N'
	JZ	DOPRT2
	JMP	RECMDJ			; BAD ANSWER
DOPRT1:	MOV	DX,OFFSET CLR_SCREEN
	CALL	DSPMSG
	MOV	DX,OFFSET CUR_ON
	CALL	DSPMSG
	CALL	SET_PARM
	MOV	DX,OFFSET PRNT_PROG
	CALL	LOAD_PROG
	JMP	WAIT_KEYIN
DOPRT2:	MOV	DX,OFFSET CLEANX
	MOV	AX,2523H
	INT	21H			; SET CONTROL-C EXIT
	CALL	GET_CURRENT		; GET CURRENT FILE
	CALL	OPENFIL			; OPEN IT
	JNC	DOPRT3			; OPEN OK
DOPRTR:	JMP	BHREAD
DOPRT3:	CALL	READFIL			; READ FILE
	JC	DOPRTR			; BAD FILE
	OR	CX,CX			; NULL FILE?
	JZ	DOPRTX
	MOV	DX,OFFSET BA.RDBUF
	MOV	BX,4			; USE STD PRN
	MOV	AH,40H			; WRITE TO PRINTER
	INT	21H
	JC	DOPRTR
	CMP	EOFFLG,0		; END OF FILE?
	JZ	DOPRT3			; IF NOT, LOOP
DOPRTX:	MOV	BX,INHAND
	MOV	AH,3EH			; ELSE, CLOSE FILE
	INT	21H
	MOV	DX,OFFSET REPAINT
	MOV	AX,2523H
	INT	21H			; RESET CONTROL-C EXIT
	JMP	RECMDJ			; EXIT

;	QUIT -- EXIT TO DOS

DOQUIT:	MOV	DX,OFFSET xit_MSG
	CALL	DSPMSG
	CMP	Byte Ptr TTYPE,0	; H150?
	JNZ	EXIT1			; NO
	MOV	AL,DISTYPE		; ELSE, GET OLD DISPLAY TYPE
	CMP	AL,3			; MODE 3?
	JZ	IS3
	XOR	AH,AH
	INT	10H			; SET IT
IS3:	MOV	CX,CURTYPE		; GET CURSOR TYPE
	MOV	AH,1
	INT	10H			; SET IT
	CALL	POSCUR			;PUT CURSOR AT HOME POSITION
EXIT1:	MOV	AX,4C00H
	INT	21H			; EXIT

;	RENAME FILE

DOREN:	CMP	FILECNT,0
	JNZ	DOREN_OK
	JMP	FILES_ERR
DOREN_OK:
	MOV	DX,OFFSET INIT_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET NEW_NAME_REQ
	CALL	DSPMSG
	MOV	AL,7EH
	CALL	GETSTR
	CMP	BA.LINEBUF+1,0		; ignore if null entry
	JNE	DOREN_CONT
	JMP	RECMDJ
DOREN_CONT:
	MOV	BL,BA.LINEBUF+1
	XOR	BH,BH
	MOV	BA.LINEBUF+2[BX],0	; null string terminator
	CALL	GET_CURRENT
	MOV	DI,OFFSET BA.LINEBUF+2
	MOV	AH,56h			; rename file
	INT	21H
	JC	REN_ERR
	MOV	FILECNT,0
	CALL	GET_DIR1		; GET NEW NAME IN DIRECTORY
	JMP	REPAINT
REN_ERR:
	MOV	DX,OFFSET MSG_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET REN_ERR_MSG
	CALL	DSPMSG
	MOV	DX,OFFSET WAITKEY1
	CALL	DSPMSG
	CALL	GETBK			; WAIT FOR KEY
	CALL	SHOWBOT
	JMP	RECMDJ

;	SORT DIRECTORY

DOSORT:	MOV	SORTFLG,1		; MARK FILES SORTED
	CMP	FILECNT,0		; ANY FILES
	JNZ	SRTFLS			; YES, SORT THEM
	JMP	GET_KEY			; ELSE, EXIT
SRTFLS:	CALL	SORT			; SORT THE DIRECTORY
	JMP	REPAINT			; RE-DISPLAY FILES

;	TYPE FILES ON SCREEN

DOTYPE:	CMP	FILECNT,0
	JNZ	DOTYP1
	JMP	FILES_ERR
DOTYP1:	MOV	LINECNT,22		; SET LINE COUNT
	MOV	DX,OFFSET CLR_SCREEN
	CALL	DSPMSG
	CALL	GET_CURRENT
	CALL	OPENFIL			; OPEN FILE TO TYPE
	JNC	TYPLP			; NO ERROR
DOTYPR:	JMP	BHREAD			; ELSE, EXIT
TYPLP:	CALL	READFIL			; READ IN FILE
	JNC	TYPLP0
	JMP	BHREAD			; CAN'T READ
TYPLP0:	OR	CX,CX
	JZ	DOTYPX
	MOV	SI,OFFSET BA.RDBUF	; POINT TO BUFFER
	CLD
TYPLP1:	LODSB				; GET A CHARACTER
	CMP	AL,1AH			; EOF?
	JZ	DOTYPX			; YES
	PUSH	AX
	CALL	SCOUT			; PRINT TO SCREEN
	POP	AX
	AND	AL,7FH			; STRIP PARITY
	CMP	AL,LF			; LINE FEED?
	JNZ	TYPLP2			; NO
	DEC	LINECNT			; ELSE INCREMENT LINE COUNT
	JNZ	TYPLP2			; NOT ENOUGH LINES
	MOV	LINECNT,22		; RESET LINE COUNT
TWAIT:	CALL	GETBK			; GET IT
	CMP	AL,3			; CONTROL-C?
	JNZ	TYPLP2			; NO
	MOV	BX,INHAND
	MOV	AH,3EH			; CLOSE FILE
	INT	21H
	JMP	REPAINT
TYPLP2:	CALL	GETBKS			;CHECK KEYBOARD
	JZ	TYPLP3
	CMP	AL,3			; CONTROL-C?
	JZ	DOTYPX			; IF SO, EXIT
	CMP	AL,'S'-'@'		; CONTROL-S?
	JZ	TWAIT			; IF SO, WAIT
TYPLP3:	LOOP	TYPLP1			; FINISH BUFFER
	CMP	EOFFLG,0		; END?
	JZ	TYPLP			; IF NOT, LOOP
DOTYPX:	MOV	BX,INHAND
	MOV	AH,3EH			; CLOSE INPUT FILE
	INT	21H
	JMP	WAIT_KEYIN

;	UNSORT/UNFLAG DIRECTORY

DOUNSRT:XOR	AX,AX
	MOV	FLAG_L,AX		; ZERO FLAG BYTE COUNT
	MOV	FLAG_H,AX
	MOV	SORTFLG,AL		; MARK FILES UNSORTED
	MOV	FLAGCNT,AL		; MARK THEM UNFLAGGED
	CMP	FILECNT,0		; ANY FILES
	JNZ	USFLS			; IF SO, UNSORT THEM
	JMP	GET_KEY			; ELSE, IGNORE
USFLS:	CALL	UNSORT			; UNSORT FILES
	JMP	REPAINT			; RE-DISPLAY THEM

;	ALTER WILDCARD SPECIFICATION

DOWILD:	MOV	DX,OFFSET INIT_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET WILD_CARD_REQ
	CALL	DSPMSG
	MOV	AL,13
	CALL	GETSTR
	MOV	BL,BA.LINEBUF+1
	XOR	BH,BH			; BX = CHAR COUNT
	CMP	BL,0			; IGNORE IF NULL ENTRY
	JNE	DOWILD1
	JMP	RECMDJ
DOWILD1:
	MOV	BA.LINEBUF+2[BX],0	; null string terminator
	MOV	SI,OFFSET BA.LINEBUF+2	; POINT TO NEW SPEC.
	MOV	DI,OFFSET WILDCARD	; PUT IT HERE
	MOV	CX,BX
	INC	CX			; ALLOW FOR TERMINATOR
	CLD
	REP	MOVSB			; MOVE IT IN
	CALL	GET_DIR0		; GET NEW RESTRICTED DIRECTORY
	JMP	REPAINT

;	PROCEDURES

;	OPEN A FILE FOR READING

OPENFIL:MOV	AX,3D00H
	MOV	CX,0
	INT	21H			; OPEN THE FILE
	MOV	INHAND,AX		; SAVE THE HANDLE NUMBER
	RET

;	READ A FILE

READFIL:MOV	BYTE PTR EOFFLG,0	; CLEAR EOF FLAG
	MOV	CX,WORD PTR MEMTOP	; GET MEMORY TOP
	MOV	AX,OFFSET BA.RDBUF
	SUB	CX,AX			; GET BUFFER SIZE
	AND	CX,0FFF0H		; MAKE IT MULTIPLE OF 16
	MOV	BX,INHAND		; GET INPUT HANDLE
	MOV	DX,OFFSET BA.RDBUF	; PUT FILE HERE
	PUSH	CX			; SAVE COUNT
	MOV	AH,3FH			; READ THE FILE
	INT	21H
	POP	CX
	JC	READX			; BAD READ
	CMP	CX,AX			; BUFFER FILLED?
	JZ	READFB			; YES
	MOV	BYTE PTR EOFFLG,1	; ELSE, MARK END OF FILE
	MOV	CX,AX			; CX = BYTES READ
READFB:	CLC				; ENSURE NO CARRY
READX:	RET

;	CLEANUP AFTER FILE ERRORS

CLEANUP:MOV	BX,5			; CLOSE POSSIBLE HANDLES
	MOV	AH,3EH
	INT	21H
	MOV	BX,6
	MOV	AH,3EH
	INT	21H
	RET

;	GET INPUT STRING (AL = LIMIT)

GETSTR	PROC	NEAR
	PUSH	SI
	MOV	SI,OFFSET BA.LINEBUF
	MOV	[SI],AL
	CALL	POSCUR
	MOV	DX,SI
	MOV	AH,0AH
	INT	21H
	INC	SI
	LODSB				; GET CHAR COUNT
	XOR	AH,AH
	MOV	DI,SI
	ADD	SI,AX
	MOV	BYTE PTR [SI],0		; TERMINATE ENTRY
	MOV	SI,DI
	MOV	CX,AX			; COUNT TO CX
	INC	CX			; COUNT TERMINATOR
	INC	CX
	MOV	AL,' '
	REPZ	SCASB			; LOOK FOR NON-SPACE
	DEC	DI			; POINT TO FIRST NON-SPACE
	CMP	DI,SI			; ANY SPACES?
	JZ	GETSX			; IF NOT, EXIT
	XCHG	SI,DI
	REP	MOVSB			; MOVE STRING DOWN
GETSX:	POP	SI
	RET
GETSTR	ENDP

;	POSITION CURSOR ON SCREEN

POSCUR:	CMP	TTYPE,1			;Z-100?
	JZ	POSCUX			;YES, CURSOR ALREADY POSITIONED
	MOV	DX,CURPOS
	MOV	BH,0
	MOV	AH,2
	INT	10H			;ELSE, PUT CURSOR AFTER PROMPT
POSCUX:	RET

;	MAP LOWER TO UPPER CASE

MUC	PROC	NEAR			; CAPITALIZE CHAR IN AL
	CMP	AL,'a'
	JC	MUCX
	CMP	AL,'z'+1
	JNC	MUCX
	AND	AL,5FH			; CAPITALIZE
MUCX:	RET
MUC	ENDP

;	PRINT FILE NAME AT (SI)

PRNAME	PROC	NEAR
	LODSB				; GET A CHAR
	OR	AL,AL
	JZ	MUCX			; END
	CALL	SCOUT
	JMP	PRNAME
PRNAME	ENDP

;	FIX DEST. NAME ENDING IN SPECIFIED CHARACTER
;	ENTER WITH DX POINTING TO SOURCE NAME, AND AL = CHAR.

FIXNAM	PROC	NEAR
	MOV	DI,OFFSET BA.LINEBUF+2	; POINT TO DEST. FILE
	MOV	CL,-1[DI]		; GET COUNT
	XOR	CH,CH
FIXN1:	REPNZ	SCASB			; LOOK FOR CHAR IN AL
	JNZ	NOCOL			; NOT FOUND
	CMP	BYTE PTR [DI],0		; FOLLOWED BY ZERO?
	JNZ	FIXN1			; NO
	MOV	ZEROPOS,DI		; SAVE POSITION OF ZERO
	MOV	SI,DX			; ELSE, POINT TO INPUT NAME
MOVNAM:	LODSB				; GET A CHARACTER
	STOSB				; STORE IT
	OR	AL,AL			; END?
	JNZ	MOVNAM
	RET
NOCOL:	STC
	RET
FIXNAM	ENDP

;	DISPLAY COMMAND LINE

DISP_CMD_LINE	PROC	NEAR
	MOV	DX,OFFSET INIT_CMD_LINE
	CALL	DSPMSG
	CMP	BYTE PTR TTYPE,0	; Z-150?
	JNZ	NOT150
	MOV	AH,1
	MOV	CX,2020H
	INT	10H			; TURN OFF CURSOR
NOT150:	MOV	CX,NCMDS
	PUSH	CUR_CMD
	MOV	CUR_CMD,0
DISPC_LP:
	CALL	NRM_CURC
	INC	CUR_CMD
	LOOP	DISPC_LP
	POP	CUR_CMD
	CALL 	REV_CURC
	RET
DISP_CMD_LINE	ENDP

;	DISPLAY CURRENT COMMAND

REV_CURC	PROC	NEAR
	MOV	DX,OFFSET REV_MSG
	CALL	DSPMSG
NRM_CURC:
	MOV	SI,CUR_CMD
	SHL	SI,1
	MOV	DX,CMD_LINE_TBL[SI]
	CALL	DSPMSG
	MOV	DX,OFFSET NRM_MSG
	CALL	DSPMSG
	RET
REV_CURC	ENDP

;	DISPLAY DIRECTORY ON SCREEN

DIRECTORY_DISPLAY	PROC	NEAR
	MOV	DX,OFFSET DIR_HDR
	CALL	DSPMSG
	MOV	AL,CUR_DISK
	CALL	SCOUT
	MOV	AL,':'
	CALL	SCOUT
	MOV	AL,'\'
	CALL	SCOUT
	MOV	SI,OFFSET CUR_DIR
DISDIR:
	LODSB
	CMP	AL,0
	JE	DISENTS
	CALL	SCOUT
	JMP	DISDIR
DISENTS:
	MOV	DX,OFFSET LAB_MSG
	CALL	DSPMSG			; SHOW DISK ID
	PUSH	CUR_ENT			; save current entry pointer
	MOV	CUR_ENT,0		; reset for display
DISENT0:CMP	FILECNT,0		; ANY FILES?
	JNZ	DISPENTS		; YES
DISENT1:MOV	DX,OFFSET NO_FIL_MSG
	CALL	DSPMSG
	POP	CUR_ENT
	MOV	CUR_ENT,0
	JMP	DIR_FREE		; SHOW DISK FREE SPACE
DISPENTS:
	MOV	DI,OFFSET BA.DIR_ENT_BUF ; POINT TO DIRECTORY ENTRIES
	MOV	BX,OFFSET BA.DIRPTR	; POINT TO DIRECTORY POINTER
	MOV	AX,PAGECNT		; GET CURRENT COUNT
	CMP	AX,FILECNT		; REACHED FILE COUNT?
	JB	OKCNT			; NO
	MOV	AX,0			; ELSE, START OVER
	MOV	PAGECNT,0
OKCNT:	SHL	AX,1			; DOUBLE COUNT
	ADD	BX,AX			; ADD TO POINTER POS.
	CLD
DIS_LOOP:
	MOV	SI,CUR_ENT
	SHL	SI,1
	SHL	SI,1
	MOV	CX,4
ADR_LUP:
	MOV	AL,DIR_ENT_ADDR[SI]	; address cursor to entry position
	CALL	SCOUT
	INC	SI
	LOOP	ADR_LUP
	MOV	SI,[BX]			; GET FILE NAME ADDRESS
	TEST	SI,8000H		; TEST FOR FLAG
	JZ	NOFLG			; NO FLAG
	AND	SI,7FFFH		; REMOVE FLAG
	MOV	DX,OFFSET FLG_MSG
	CALL	DSPMSG			; SHOW FLAG ON FILE
NOFLG:	CALL	PRNAME			; PRINT FILE NAME
	ADD	BX,2			; MOVE TABLE POINTER
	INC	CUR_ENT			; COUNT SCREEN FILE
	MOV	AX,PAGECNT
	ADD	AX,CUR_ENT
	CMP	AX,FILECNT		; DONE ALL FILES?
	JZ	ALLIN
	CMP	CUR_ENT,84
	JBE	DIS_LOOP
	MOV	BYTE PTR MOREFLG,1	; INDICATE MORE AVAILABLE
ALLIN:
	CMP	BYTE PTR MOREFLG,0	; MORE FILES?
	JZ	ALLIN1			; NO
	MOV	DX,OFFSET MORE_DIR
	CALL	DSPMSG			; ELSE, SHOW "MORE.."
ALLIN1:	MOV	AX,CUR_ENT
	MOV	MAX_ENT,AX
	POP	CUR_ENT
	CALL	CUR_ENT_REV
	MOV	DX,OFFSET FSPC_MSG
	CALL	DSPMSG			; SAY "FLAG BYTES"
	MOV	BX,FLAG_L		; GET FLAG BYTES
	MOV	AX,FLAG_H
	CALL	DDECOUT			; SHOW THEM
SHOWBOT:
	MOV	DX,OFFSET SEL_DISP
	CALL	DSPMSG
	CALL	CUR_ENT_DIS
	CALL	CUR_ENT_SIZE
DIR_FREE:
	MOV	DX,OFFSET FREE_MSG
	CALL	DSPMSG			; SAY "FREE SPACE"
	MOV	BX,FREE_L		; GET FREE SPACE
	MOV	AX,FREE_H
	CALL	DDECOUT			; SHOW IT
	ret
DIRECTORY_DISPLAY	ENDP

;	GET DIRECTORY FILES, STORE IN BUFFER

GET_DIRECT	PROC	NEAR
	MOV	WORD PTR WILDCARD,'.*'
	MOV	WORD PTR WILDCARD+2,'*'	; RESET WILDCARD SPEC.
	CALL	GET_LABEL		; GET DISK LABEL
GET_DIR0:
	XOR	AX,AX
	MOV	FILECNT,AX		; CLEAR FILE COUNT
	MOV	PAGECNT,AX		; AND PAGE COUNT
	MOV	CUR_ENT,AX		; AND CURRENT ENTRY
	MOV	MOREFLG,AL		; AND MORE FLAG
	MOV	FLAGCNT,AL		; AND FLAG COUNT
	MOV	FLAG_L,AX		; AND FLAG BYTES
	MOV	FLAG_H,AX
GET_DIR1:
	MOV	DX,OFFSET BUF
	MOV	AH,1AH
	INT	21H			; SET DTA TO BUF
	MOV	DI,OFFSET BA.DIR_ENT_BUF ; POINT TO DIR BUFFER
	MOV	DX,OFFSET WILDCARD
	MOV	CX,6
	MOV	AH,4EH			; CHECK FOR ENTRY
	INT	21H
	JC	GETFREE			; NO FILES, GET FREE SPACE
GOTFILES:
	MOV	SI,OFFSET BUF.PNAME
	MOV	CX,13
	CLD
	REP	MOVSB			; MOVE FILE NAME TO BUFFER
	MOV	SI,OFFSET BUF.SIZE_L
	MOVSW
	MOVSW				; MOVE IN FILE SIZE
	INC	FILECNT			; COUNT THIS FILE
	MOV	AH,4FH			; CHECK FOR ANOTHER FILE
	INT	21H
	JNC	GOTFILES		; MOVE IT
	CALL	UNSORT			; SET POINTER TABLE
	CMP	SORTFLG,0		; SORT FILES?
	JZ	GETFREE			; NO
	CALL	SORT			; SORT THE DIRECTORY
GETFREE:MOV	AH,36H
	XOR	DL,DL
	INT	21H			; GET FREE SPACE FROM SYSTEM
	MUL	CX			; COMPUTE BYTES/CLUSTER
	MOV	CX,AX
	MOV	AX,BX			; AX = FREE CLUSTERS
	MUL	CX			; COMPUTE BYTES FREE
	MOV	FREE_L,AX		; SAVE RESULT
	MOV	FREE_H,DX
	RET
GET_DIRECT	ENDP

;	GET DISK LABEL

GET_LABEL	PROC	NEAR
	MOV	DX,OFFSET BUF
	MOV	AH,1AH
	INT	21H			; SET DTA TO BUF
	MOV	DLFCBDR,0
	MOV	DX,OFFSET DLFCB
	MOV	AH,11H			; LOOK FOR DISK LABEL
	INT	21H
	OR	AL,AL			; ANY FOUND?
	MOV	SI,OFFSET BUF+8		; ASSUME YES
	MOV	LABFLAG,1
	JZ	MOVLAB			; YES
	MOV	SI,OFFSET NONE		; ELSE USE "NONE"
	MOV	LABFLAG,0
MOVLAB:	MOV	DI,OFFSET DISKLAB	; PUT LABEL HERE
	MOV	CX,11
	CLD
	REP	MOVSB
	RET
GET_LABEL	ENDP

;	UNSORT DIRECTORY (SET POINTERS FOR SORT)

UNSORT	PROC	NEAR
	MOV	AX,OFFSET BA.DIR_ENT_BUF ; POINT TO DIR BUFFER
	MOV	DI,OFFSET BA.DIRPTR	; AND POINTER
	MOV	CX,FILECNT		; GET FILE COUNT
	CLD
UNSLP:	STOSW				; STORE ENTRY ADDRESS
	ADD	AX,17			; MOVE TO NEXT ONE
	LOOP	UNSLP			; CONTINUE TILL DONE
	RET
UNSORT	ENDP

; SHELL-METZNER STRING SORTING ROUTINE
;	ENTRY:  'FILECNT' = NUMBER OF STRINGS TO BE SORTED
;		'DIRPTR'  = START OF POINTER TABLE
;		POINTER TABLE MADE UP OF A SERIES OF 16 BIT ADDRESSES
;		   POINTING TO THE POSITION IN THE DATA TABLE FOR EACH
;		   OF THE ITEMS TO BE SORTED.
;	EXIT:	POINTER TABLE REARRANGED TO POINT TO STRINGS IN
;		ALPHABETICAL ORDER.
;		STRING DATA TABLE IS UNCHANGED.

SORT	PROC	NEAR
	MOV	BX,FILECNT
	CMP	BX,2			;2 OR MORE FILES?
	JNB	SORT1			;YES
	RET				;ELSE NO SORT NEEDED!
SORT1:	MOV	VARM,BX
SETM:	MOV	BX,VARM
	SHR	BX,1
	MOV	VARM,BX			;VARM = VARM / 2 
	CMP	BX,0
	JNZ	NOTEND	
	RET				;IF END OF SORT
NOTEND:	MOV	BX,1
	MOV	VARJ,BX			;VARJ = 1
	MOV	BX,FILECNT
	MOV	DX,VARM
	SUB	BX,DX
	MOV	VARK,BX			;VARK = SCOUNT - VARM
SETI:	MOV	BX,VARJ
	MOV	VARI,BX			;VARI = VARJ
SETL:	MOV	BX,VARI
	MOV	DX,VARM
	ADD	BX,DX
	MOV	VARL,BX			;VARL = VARI + VARM
	CALL	SYMVAL			;BX = START OF DATA POINTED BY VARL
	PUSH	BX
	MOV	BX,VARI
	CALL	SYMVAL
	POP	SI
	MOV	CX,12			;*GET STRING LENGTH
	MOV	DI,BX			;SI AND DI POINT TO START OF STRINGS
	CLD
	REPZ	CMPSB			;COMPARE THE STRINGS
NOMACH:	JNB	SETJ			;IF NO REARRANGEMENT REQUIRED

; SWITCH THE POINTER ADDRESS AT (VARI) WITH THAT AT (VARL)

	MOV	BX,VARI
	CALL	TABADD
	PUSH	BX			;STACK = POINTER DATA FOR (VARI)
	MOV	BX,VARL
	CALL	TABADD			;BX = POINTER DATA FOR (VARL)
	POP	SI
	MOV	AX,[SI]
	MOV	DX,[BX]
	MOV	[SI],DX
	MOV	[BX],AX

; SWITCH COMPLETED

	MOV	BX,VARI
	MOV	DX,VARM
	SUB	BX,DX
	MOV	VARI,BX			;VARI = VARI - VARM
	DEC	BX
	JS	SETJ	
	JMP	SETL			;IF VARI >= 1
SETJ:	MOV	BX,VARJ
	INC	BX
	MOV	VARJ,BX			;VARJ = VARJ + 1
	MOV	DX,VARK
	SUB	DX,BX
	JNB	SETJ0	
	JMP	SETM			;IF VARJ > VARK
SETJ0:	JMP	SETI

; TABADD -- FIND LOCATION OF DATA POINTER IN TABLE
;	ENTRY: BX = INTEGER VALUE ( 1 -> N )
;	EXIT:  BX = ADDR OF TWO BYTE DATA POINTER ( FOR INPUT VALUE )

TABADD:	DEC	BX			;START AT ZERO
	SHL	BX,1			;BX = [(ORIGINAL BX) - 1] * 2
	MOV	DX,OFFSET BA.DIRPTR
	ADD	BX,DX
	RET

; SYMVAL -- FIND DATA RELATED TO INPUT INTEGER VALUE IN ARRAY
;	ENTRY: BX = INTEGER VALUE ( 1 -> N ) POINTING TO DATA ARRAY
;	EXIT:  BX = FWA STRING DATA FOR THAT VALUE

SYMVAL:	CALL	TABADD
	MOV	BX,[BX]
	AND	BX,7FFFH		; REMOVE FLAG BIT
	RET
SORT	ENDP

;	DDECOUT - PRINT 32 BIT NO. IN AX,BX IN DECIMAL
;	AX = HIGH WORD, BX = LOW WORD

DDECOUT	PROC	NEAR
	MOV	SI,0			;CLEAR ZERO SUPPRESS FLAG
	MOV	CX,3B9AH
	MOV	DX,0CA00H		;CX,DX = 1,000,000,000
	CALL	DIVPR			;DIVIDE AND PRINT
	CALL	COMMA			;PRINT A COMMA (IF NO. PRINTED)
	MOV	CX,5F5H
	MOV	DX,0E100H		;CX,DX = 100,000,000
	CALL	DIVPR
	MOV	CX,98H
	MOV	DX,9680H		;CX,DX = 10,000,000
	CALL	DIVPR
	MOV	CX,0FH
	MOV	DX,4240H		;CX,DX = 1,000,000
	CALL	DIVPR
	CALL	COMMA
	MOV	CX,1
	MOV	DX,86A0H		;CX,DX = 100,000
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,10000		;CX,DX = 10000
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,1000			;CX,DX = 1000
	CALL	DIVPR
	CALL	COMMA
	MOV	CX,0
	MOV	DX,100			;CX,DX = 100
	CALL	DIVPR
	MOV	CX,0
	MOV	DX,10			;CX,DX = 10
	CALL	DIVPR
	MOV	AL,BL			;GET ONES DIGIT
	ADD	AL,'0'			;ADD ASCII
	JMP	SCOUT			;PRINT IT AND RETURN
DIVPR:	MOV	DI,-1			;SET A COUNTER
DIVPR1:	INC	DI			;INCREMENT COUNTER
	SUB	BX,DX			;SUBTRACT DIVISOR
	SBB	AX,CX
	JNB	DIVPR1			;REPEAT UNTIL OVERFLOW
	ADD	BX,DX			;ADD DIVISOR BACK IN ONCE
	ADC	AX,CX
	PUSH	AX			;SAVE AX
	MOV	AX,DI			;GET COUNTER (WHICH IS DIGIT)
	ADD	AL,'0'			;ADD ASCII OFFSET
	CMP	SI,0			;CKECK ZERO FLAG
	JNZ	DIVPR2			;PASSED LEADING ZEROS, PRINT NO.
	CMP	AL,'0'			;IS NO. ZERO?
	JZ	DIVPR3			;IF SO, EXIT
	INC	SI			;ELSE, FLAG ZEROS PASSED
DIVPR2:	CALL	SCOUT			;PRINT NO.
DIVPR3:	POP	AX			;RESTORE AX
	RET
COMMA:	CMP	SI,0			;ANY NUMBERS PRINTED?
	JZ	COMMA1			;NO
	PUSH	AX
	MOV	AL,','			;ELSE, PRINT COMMA
	CALL	SCOUT
	POP	AX
COMMA1:	RET
DDECOUT	ENDP

;	SET PARAMETERS FOR PROGRAM LOAD

SET_PARM	PROC	NEAR
	MOV	BUF,1
	MOV	DI,OFFSET buf+2
	MOV	buf+1,' '		; space separator
	JMP	setprm_getadr
SET_PARM_CMD:				; special entry for COMMAND.COM parms
	MOV	CL,[SI]			; requested command first
	MOV	BUF,CL
	XOR	CH,CH
	INC	SI
	MOV	DI,OFFSET buf+1
	CLD
	REP	MOVSB
setprm_getadr:
	CALL	GET_CURRENT
	JNC	SETP1			; GOT CURRENT ADDRESS OK
	RET				; ELSE RETURN
SETP1:	MOV	SI,DX
setprm_cpy:
	LODSB				; copy in current selection
	CMP	AL,0
	JE	setprm_cpydon
	STOSB
	INC	buf
	JMP	setprm_cpy
setprm_cpydon:
	MOV	BYTE PTR [DI],0dh
	OR	AL,AL			; CLEAR CARRY
	ret
SET_PARM	ENDP

;	LOAD AND EXECUTE A PROGRAM

LOAD_PROG	PROC	NEAR
	PUSH	DX
	MOV	DX,OFFSET LOADX
	MOV	AX,2523H
	INT	21H			; SET CONTROL-C ADDRESS
	POP	DX
	MOV	SPSAVE,SP
	MOV	BX,OFFSET PROG_BLK
	MOV	AL,0
	MOV	AH,4bh			; load and execute prog
	INT	21H
LOADX:	CLI
	MOV	BX,CS
	MOV	DS,BX
	MOV	ES,BX
	MOV	SS,BX
	MOV	SP,SPSAVE
	STI
	JC	PROG_ERR
	RET
PROG_ERR:
	MOV	DX,OFFSET MSG_PROMPT
	CALL	DSPMSG
	MOV	DX,OFFSET PROG_ERR_MSG
	CALL	DSPMSG
	RET
LOAD_PROG	ENDP

;	DISPLAY CURRENT ENTRY

CUR_ENT_REV	PROC	NEAR
	MOV	DX,OFFSET REV_MSG
	CALL	DSPMSG
CUR_ENT_NRM:
	MOV	BX,CUR_ENT
	SHL	BX,1
	SHL	BX,1
	MOV	CX,4
ENT_ADR_LOOP:
	MOV	AL,DIR_ENT_ADDR[BX]
	CALL	SCOUT
	INC	BX
	LOOP	ENT_ADR_LOOP
CUR_ENT_DIS:
	PUSH	SI
	MOV	SI,CUR_ENT		; GET CURRENT ENTRY NO.
	ADD	SI,PAGECNT		; ADD PAGE COUNT
	SHL	SI,1			; MPY BY 2
	MOV	SI,WORD PTR BA.DIRPTR[SI] ; GET ENTRY ADDRESS
	AND	SI,7FFFH		; REMOVE FLAG BIT
	CALL	PRNAME			; PRINT FILE NAME
	MOV	DX,OFFSET NRM_MSG
	CALL	DSPMSG
	POP	SI
	RET
CUR_ENT_REV	ENDP
;
;	SHOW SIZE OF CURRENT FILE
;
CUR_ENT_SIZE	PROC	NEAR
	MOV	DX,OFFSET SIZ_MSG
	CALL	DSPMSG			; SAY "FILE SIZE"
	CALL	GET_SIZE		; GET SIZE OF FILE
	CALL	DDECOUT			; PRINT FILE SIZE
CUR_ENT_SIZE	ENDP

GET_SIZE	PROC	NEAR
	MOV	SI,CUR_ENT		; GET CURRENT ENTRY NO.
	ADD	SI,PAGECNT		; ADD PAGE COUNT
	SHL	SI,1			; MPY BY 2
	MOV	SI,WORD PTR BA.DIRPTR[SI] ; GET ENTRY ADDRESS
	AND	SI,7FFFH		; REMOVE FLAG BIT
	MOV	BX,13[SI]		; GET SIZE LOW
	MOV	AX,15[SI]		; GET SIZE HIGH
	RET
GET_SIZE	ENDP

;	return address of current selection

GET_CURRENT	PROC	NEAR
	PUSH	SI
	CMP	FLG2FLG,0		; DOING FLAGS?
	JZ	GET1			; NO
	MOV	SI,CUR_ADR		; ELSE, GET FILE ADDRESS PTR.
	PUSH	CX
	MOV	CX,TFCNT		; AND TEMP. COUNT
	OR	CX,CX			; FILES USED UP?
	JZ	GOTEND			; YES
GETLP:	LODSW				; GET ADDRESS
	TEST	AX,8000H		; TEST FOR FLAGGED FILE
	JNZ	GOTFLG			; GOT ONE
	LOOP	GETLP			; LOOP UNTIL END OR ONE FOUND
GOTEND:	POP	CX
	POP	SI
	STC				; NONE FOUND, FLAG END OF FILES
	RET
GOTFLG:	DEC	CX			; COUNT THIS FILE
	MOV	TFCNT,CX		; SAVE COUNT
	POP	CX
	MOV	CUR_ADR,SI		; SAVE FILE PTR ADDRESS
	MOV	DX,AX			; FILE ADDR TO DX
	JMP	SHORT GETX	
GET1:	MOV	SI,CUR_ENT		; GET CURRENT NO.
	ADD	SI,PAGECNT		; ADD PAGE COUNT
	SHL	SI,1			; MPY BY 2
	MOV	DX,WORD PTR BA.DIRPTR[SI]
GETX:	AND	DX,7FFFH		; REMOVE FLAG BIT
	POP	SI
	OR	AL,AL			; CLEAR CARRY
	ret
GET_CURRENT	ENDP
;
;	GET_ENV_PARM - get an environment parameter
;
;		SI=addr of string of parm name
;		CX=size of string
;		BX=addr of buffer to contain value
;
;	on return - parm (if found) is in buffer and di
;		    points to nxt chr after it.
;
GET_ENV_PARM	PROC	NEAR		; get an environment parameter
	PUSH	ds
	PUSH	CX
	PUSH	SI
	MOV	DS,env_seg		; env addr
	MOV	SI,0
FIND_PARM:
	POP	DI
	POP	CX
	PUSH	CX
	PUSH	DI
	CMP	BYTE PTR [SI],0		; end of environment list?
	JE	NO_PARM			;  yes - no parm to copy
	PUSH	SI
	rep	cmpsb			; requested identifier?
	JE	copy_PARM
	POP	SI
eos_loop:				;  no - find end of asciz string
	LODSB
	CMP	AL,0
	JNE	eos_loop
	JMP	FIND_PARM
copy_PARM:
	POP	AX			; trash start of parm
	MOV	DI,BX
copy_PARM_loop:
	LODSB
	STOSB
	CMP	AL,';'
	JNZ	NOTSEMI
	XOR	AL,AL
NOTSEMI:CMP	AL,0
	JNE	copy_PARM_loop
	DEC	DI
NO_PARM:
	POP	SI
	POP	CX			; restore regs
	POP	ds
	ret
GET_ENV_PARM	ENDP
;
SUBDIRECTORY_DISPLAY	PROC	NEAR
	PUSH	CUR_ENT
	MOV	DX,OFFSET BUF
	MOV	AH,1AH
	INT	21H			; SET DTA TO BUF
	MOV	DX,OFFSET CLR_SCREEN
	CALL	DSPMSG
	MOV	DX,OFFSET SUBDIR_HDR
	CALL	DSPMSG
	MOV	AL,CUR_DISK
	CALL	SCOUT
	MOV	AL,':'
	CALL	SCOUT
	MOV	AL,'\'
	CALL	SCOUT
	MOV	SI,OFFSET CUR_DIR
DISSUBDIR:
	LODSB
	CMP	AL,0
	JE	DISSUBENTS
	CALL	SCOUT
	JMP	DISSUBDIR
DISSUBENTS:
	MOV	CUR_ENT,0
	MOV	WORD PTR WILDCARD,'.*'
	MOV	WORD PTR WILDCARD+2,'*'	; RESET WILDCARD SPEC.
	MOV	DX,OFFSET wildcard
	MOV	CX,10h			; search only for directories
	MOV	AH,4eh			; get 1st entry
	INT	21H
	JNC	DISPSUBENT
NOSUBS:
	MOV	DX,OFFSET NO_SUBFIL_MSG
	CALL	DSPMSG
	POP	CUR_ENT
	STC				; FLAG NO SUB DIRECTORIES
	RET
SUBDIS_LOOP:
	MOV	AH,4fh			; next entry
	INT	21H
	JNC	DISPSUBENT
	CMP	CUR_ENT,0
	JE	NOSUBS
	JMP	SUBDIR_DIS_RET
DISPSUBENT:
	MOV	SI,OFFSET BUF
	TEST 	[SI].attr,10h		; is it a directory?
	JZ 	SUBDIS_LOOP
;
	MOV	BX,CUR_ENT
	SHL	BX,1
	SHL	BX,1
	MOV	CX,4
SUBADR_LUP:
	MOV	AL,DIR_ENT_ADDR[BX]
	CALL	SCOUT
	INC	BX
	LOOP	SUBADR_LUP
SUBNAM_LUP:
	MOV	AL,[SI].pname
	CMP	AL,0
	JE	SUBENT_FIN
	CALL	SCOUT
	INC	SI
	JMP	SUBNAM_LUP
SUBENT_FIN:
	INC	CUR_ENT
	CMP	CUR_ENT,84
	JBE	SUBDIS_LOOP
SUBDIR_DIS_RET:
	POP	CUR_ENT
	STC
	CMC				; FLAG SUB DIRECTORIES PRESENT
	RET
SUBDIRECTORY_DISPLAY	ENDP

;	GET A SINGLE KEY VIA THE BIOS

GETBK:	CMP	BYTE PTR TTYPE,0	;PC?
	JZ	GETPBK			;YES
GETBK1:	CALL	ZKEY			;ELSE, GET Z-100 BIOS KEY
	OR	AL,AL
	RET
GETPBK:	MOV	AH,0
	INT	16H			;GET KEY
	RET

;	CHECK KEYBOARD STATUS VIA THE BIOS

GETBKS:	CMP	BYTE PTR TTYPE,0	;PC?
	JZ	GETPBS			;YES
	CALL	ZKSTAT			;ELSE, GET Z-100 STATUS
	JNZ	GETBK1			;KEY TYPED, GET IT
	RET
GETPBS:	MOV	AH,1
	INT	16H
	JNZ	GETPBK			;KEY TYPED, GET IT
	RET

;	CONVERT BINARY BYTE TO HEX ASCII

CVTBYTE	PROC	NEAR
	PUSH	AX
	AND	AL,0F0H
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1			; MOVE HIGH NIBBLE DOWN
	CALL	CVTNIB			; PRINT IT
	POP	AX
	AND	AL,0FH
CVTNIB:	ADD	AL,90H			; CONVERT TO HEX ASCII
	DAA
	ADC	AL,40H
	DAA
;	JMP	SCOUT
CVTBYTE	ENDP

;	SCOUT - SINGLE CHARACTER OUTPUT

SCOUT:	PUSH	CX
	PUSH	DX
	PUSH	BX
	PUSHF
	PUSH	AX
	CMP	BYTE PTR TTYPE,0	;TEST COMPUTER TYPE
	JNZ	SCOUT1			;Z100
	CALL	IBMOUT			;ELSE, CALL IBM OUTPUT
	JMP	SCOUTX
SCOUT1:	MOV	AH,LSTCHR		;GET LAST CHARACTER
	MOV	LSTCHR,AL		;UPDATE IT
	CMP	AH,1BH			;LAST CHAR ESCAPE?
	JNZ	SCOUT3			;NO
	CMP	AL,'p'			;SET REV. VID?
	JNZ	SCOUT2			;NO
	CALL	TYPTX
	DB	'm'
ZHATTR	DB	'0','3'+80H
	JMP	SHORT SCOUTX
SCOUT2:	CMP	AL,'q'			;SET NORMAL VIDEO?
	JNZ	SCOUT3			;NO
	CALL	TYPTX
	DB	'm'
ZATTR1	DB	'7','1'+80H
	JMP	SHORT SCOUTX
SCOUT3:	PUSH	SI
	PUSH	DI
	PUSH	ES			;SAVE THESE
	CLD				;MUST BE CLEARED!
	CALL	ROMOUT			;LET ROM DO OUTPUT
	POP	ES
	POP	DI
	POP	SI
SCOUTX:	POP	AX
	POPF
	POP	BX
	POP	DX
	POP	CX
	RET

;	TYPTX - TYPE TEXT FOLLOWING CALL

TYPTX:	MOV	BP,SP			;GET ADDRESS OF TEXT
	XCHG	BX,[BP]
	CALL	TYPTX1
	MOV	BP,SP
	XCHG	BX,[BP]
	RET
TYPTX1:	MOV	AL,[BX]
	AND	AL,7FH
	CALL	SCOUT
	CMP	AL,[BX]
	PUSHF
	INC	BX
	POPF
	JZ	TYPTX1
	RET

;	DISPLAY MESSAGE ON SCREEN

DSPMSG:	PUSH	SI
	CLD
	MOV	SI,DX			; SI POINTS TO MSG
DSPMLP:	LODSB				; GET A CHARACTER
	CMP	AL,'$'			; END?
	JZ	DSPMX			; YES
	CALL	SCOUT			; ELSE, DISPLAY CHARACTER
	JMP	DSPMLP
DSPMX:	POP	SI
	RET

;	Z19 CODE TO IBM TRANSLATOR -- WITH THANKS TO BOB METZ
;	MODIFIED TO WRITE DIRECTLY TO VIDEO RAM

IBMOUT:	JMP	WORD PTR IBMJMP
IBMOUT1:AND	AL,7FH
	CMP	AL,1BH			;ESCAPE?
	JNZ	CRT_OUT			;NO, NORMAL CHAR
	MOV	WORD PTR IBMJMP,OFFSET FIND_CODE	;ELSE, FIND CODE NEXT
IBMRET:	RET				;AND IGNORE ESC

CRT_OUT:OR	AL,AL			;NUL?
	JZ	IBMRET			;IF SO, RETURN
	CMP	AL,9			;TAB?
	JNZ	CRTOT1
	JMP	TAB			;IF SO, PROCESS IT HERE
CRTOT1:	CMP	AL,' '			;LET WRT TTY DO CONTROL
	JB	WRT_TTY
	CMP	BYTE PTR GRAFLG,0	;GRAPHICS MODE?
	JE	SCREEN_OUT		; NO - NORMAL
	CMP	AL,5EH			; YES - GRAPHICS CHR?
	JB	SCREEN_OUT
	CMP	AL,7EH		
	JA	SCREEN_OUT
	SUB	AL,5EH
	MOV	BX,OFFSET IBMGRPH
	XLAT
SCREEN_OUT:
	PUSH	ES
	PUSH	DI
	PUSH	AX			;SAVE CHARACTER
	MOV	AX,MEMADR
	MOV	ES,AX
	MOV	AL,BYTE PTR CURPOS+1	;GET ROW
	XOR	AH,AH			;IN AX
	MOV	CL,80
	MUL	CL			;MPY BY 80
	MOV	CL,BYTE PTR CURPOS
	XOR	CH,CH
	ADD	AX,CX			;ADD COLUMN
	SHL	AX,1			;2 BYTES/CHAR
	MOV	DI,AX			;POSITION TO DI
	POP	AX			;GET CHARACTER
	MOV	AH,VATTR		;ATTRIBUTE TO AH
	STOSW				;STORE CHARACTER
	POP	DI
	POP	ES
	JMP	CURRT			;MOVE CURSOR OVER
WRT_TTY:CMP	AL,0DH			;CR?
	JNZ	NOTCR
	MOV	BYTE PTR CURPOS,0	;ELSE, ZERO COLUMN
	RET
NOTCR:	CMP	AL,10			;LF?
	JNE	WRT_TTY1
	MOV	DX,WORD PTR CURPOS	;YES, GET CURSOR POSITION
	CMP	DH,23			;IF LINE <24 THEN NORMAL LF
	JAE	SCROL_24
	INC	DH			;INCREMENT COLUMN
	MOV	WORD PTR CURPOS,DX
	RET				;IF LINE = 25 THEN IGNORE LF
SCROL_24:
	MOV	AX,601H
	MOV	CX,0
	MOV	DH,23
	MOV	DL,79
	MOV	BH,VATTR
	INT	10H
	RET
WRT_TTY1:
	CMP	AL,8			;BACK SPACE?
	JNZ	NOTBS			;NO
	MOV	AL,BYTE PTR CURPOS	;ELSE, GET COLUMN
	OR	AL,AL			;AT ZERO?
	JZ	NOBS			;YES
	DEC	AL			;ELSE, DECREMENT IT
	MOV	BYTE PTR CURPOS,AL
NOBS:	RET
NOTBS:	MOV	AH,14			; WRITE TTY TO SCREEN
	MOV	BL,VATTR 
	MOV	BH,0
	INT	10H
	RET
;
FIND_CODE:
	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	MOV	BX,OFFSET CODETABLE
FIND_LP:CMP	BYTE PTR [BX],0		;END OF TABLE?
	JNE	CHKIT			; NO
	RET				; YES - IGNORE ESC SEQUENCE
CHKIT:	CMP	AL,[BX]	
	JE	PROCESSIT
	ADD	BX,3			;NOT THIS ENTRY - CHECK NXT
	JMP	FIND_LP
PROCESSIT:
	JMP	WORD PTR 1[BX]		;ENTER ESC SEQ PROCESSOR

;	ESCAPE SEQUENCE PROCESSORS

;	RESET SCREEN

IBMRST:	MOV	AL,BYTE PTR DFATTR
	MOV	BYTE PTR VATTR,AL	;RESET ATTRIBUTE
	MOV	BYTE PTR GRAFLG,0	;GRAPHIC MODE OFF
	MOV	AH,15
	INT	10H			;READ DISPLAY TYPE
	MOV	DISTYPE,AL		;SAVE IT
	CMP	AL,7			;MONO?
	JNZ	COLOR			;NO, COLOR
	MOV	MEMADR,0B000H		;ELSE, FIX VIDEO MEMORY ADDRESS
	JMP	SHORT MODEOK		;MODE SHOULD BE ALREADY SET
COLOR:	CMP	AL,2			;MODE 2?
	JZ	CKPG			;YES
	CMP	AL,3			;MODE 3
	JNZ	MAKM3			;NO, MAKE IT 3
CKPG:	CMP	BH,0			;PAGE 0?
	JZ	MODEOK			;IF SO, MODE IS OK
MAKM3:	MOV	AX,3			;ELSE, FORCE MODE 3
	INT	10H
MODEOK:	MOV	AX,600H
	MOV	BH,VATTR		;GET ATTRIBUTE
	MOV	CX,0
	MOV	DH,24			;CLEAR SCREEN
	MOV	DL,79
	INT	10H
	JMP	HOME

GRAFON:	MOV	BYTE PTR GRAFLG,1	;GRAPHIC MODE ON
	RET
GRAFOF:	MOV	BYTE PTR GRAFLG,0	;GRAPHIC MODE OFF
	RET

REVIND:	MOV	DX,CURPOS		;REVERSE INDEX
	CMP	DH,0			;LINE 1?
	JNZ	CURUP			;NO
	MOV	AX,701H			;ELSE, SCROLL DOWN
	MOV	CX,0
	MOV	DH,23
	MOV	DL,79
	MOV	BH,VATTR
	INT	10H
	RET

;	CURSOR ADDRESSING

DOADR:	MOV	WORD PTR IBMJMP,OFFSET GETROW	;NEXT CHAR IS ROW
	RET
GETROW:	MOV	SAV_ROW,AL			;SAVE ROW
	MOV	WORD PTR IBMJMP,OFFSET GETCOL	;NEXT CHAR IS COLUMN
	RET
GETCOL:	MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	MOV	DH,SAV_ROW
	MOV	DL,AL				;AL = COLUMN
	SUB	DX,'  '			;CONVERT TO 0 BASE
SETCURS:MOV	CURPOS,DX		;SET CURSOR
	RET
;
CURUP:	MOV	DX,CURPOS
CURUP1:	DEC	DH
	CMP	DH,0
	JAE	SETCURS
	INC	DH			;DON'T ALLOW TO GO OFF SCREEN
	JMP SHORT SETCURS
;
CURDWN:	MOV	DX,CURPOS
CURDWN1:CMP	DH,24			;AT BOTTOM LINE?
	JZ	CURDWN2			;IF SO, NO SCROLL
	INC	DH
	CMP	DH,23
	JLE	SETCURS
CURDWN2:RET
;
TAB:	MOV	DX,CURPOS		;PROCESS TABS
	ADD	DL,8
	AND	DL,0F8H			;MOVE TO NEXT TAB STOP
	JMP SHORT CURRT1
;
CURRT:	MOV	DX,CURPOS
	INC	DL
CURRT1:	CMP	DL,79
	JBE	SETCURS
	RET				;CURSOR IN LAST COLUMN
;
CURLFT:	MOV	DX,CURPOS
	DEC	DL
	CMP	DL,0
	JAE	SETCURS
	RET				;CURSOR IN FIRST COLUMN

HOME:	MOV	DX,0			;HOME CURSOR
	JMP	SETCURS
;
DOCLR:	MOV	AX,600H			;CLEAR SCREEN
	MOV	BH,VATTR
	MOV	CX,0			;ERASE LINES 1-24,COLS 1-80
	MOV	DH,23
	MOV	DL,79
	INT	10H
	JMP SHORT HOME
;
ERSEOL:	MOV	DX,CURPOS		;ERASE TO END OF LINE
	MOV	AH,2
	MOV	BH,0
	INT	10H			;SET CURSOR
	MOV	AX,600H
	MOV	BH,VATTR
	MOV	CX,DX
	MOV	DL,79
	INT	10H
	RET
;
ERSEOS:	MOV	DX,CURPOS		;ERASE TO END OF SCREEN
	MOV	AH,2
	MOV	BH,0
	INT	10H			;SET CURSOR
	MOV	AX,600H
	MOV	BH,VATTR		;ERSEOL FIRST
	MOV	CX,DX
	MOV	DL,79
	PUSH	CX			;SAVE CURSOR POSITION
	INT	10H
	POP	CX
	MOV	DH,23
	MOV	DL,79
	CMP	CH,23
	JE 	ERS_RET
	INC	CH
	MOV	AX,600H
	MOV	BH,VATTR
	INT	10H
ERS_RET:RET

ERSLIN:	MOV	DX,CURPOS		;ERASE LINE
	MOV	CX,DX
	MOV	CL,0
	MOV	DL,79
	MOV	AX,0600H		;SCROLL REGION (SINGLE LINE) CLEAR
	MOV	BH,VATTR
	INT	10H
	RET
;
SAVCRS:	MOV	DX,CURPOS		;SAVE CURSOR POSITION
	MOV	CURSAV,DX
	RET
;
RSTCRS:	MOV	DX,CURSAV		;RESTORE CURSOR POSITION
	JMP	SETCURS
;
DOREV:	MOV	AL,HIATTR
	MOV	BYTE PTR VATTR,AL 	;REV. VIDEO
	RET
;
DONRM:	MOV	AL,DFATTR
	MOV	BYTE PTR VATTR,AL	;NOR. VIDEO
	RET

RESMOD:	MOV	WORD PTR IBMJMP,OFFSET RESMOD1	; GET NEXT CHAR
	RET
RESMOD1:MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	; RESET JUMP
	CMP	AL,'5'			; RESTORE CURSOR?
	JZ	CURON			; YES
	RET				; ELSE, IGNORE
CURON:	MOV	AH,1
	MOV	CX,CURTYPE
	INT	10H			; RESTORE CURSOR
	RET

IGNORE:	MOV	WORD PTR IBMJMP,OFFSET IGNORE1	;IGNORE NEXT CHAR
	RET
IGNORE1:MOV	WORD PTR IBMJMP,OFFSET IBMOUT1	;RESET JUMP
	RET

IBMJMP	DW	IBMOUT1			;JUMP INTO CODE
MEMADR	DW	0B800H			;VIDEO MEMORY ADDRESS
LSTCHR	DB	0			;LAST CHARACTER
GRAFLG	DB	0			;GRAPHICS MODE FLAG
VATTR	DB	(BGC SHL 4)+FGC		;DEFAULT ATTRIBUTE
SAV_ROW	DB	0			;SAVED ROW POSITION
CURPOS	DW	0			;CURSOR POSITION
CURSAV	DW	0			;SAVED CURSOR POSITION
COLTBL	DB	0,1,4,5,2,3,6,7
;
CODETABLE:				;ESC SEQUENCE PROCESSOR TABLE
	DB	'Y'
	DW	OFFSET DOADR
	DB	'E'
	DW	OFFSET DOCLR
	DB	'F'
	DW	OFFSET GRAFON
	DB	'G'
	DW	OFFSET GRAFOF
	DB	'J'
	DW	OFFSET ERSEOS
	DB	'K'
	DW	OFFSET ERSEOL
	DB	'A'
	DW	OFFSET CURUP
	DB	'B'
	DW	OFFSET CURDWN
	DB	'C'
	DW	OFFSET CURRT
	DB	'D'
	DW	OFFSET CURLFT
	DB	'H'
	DW	OFFSET HOME
	DB	'I'
	DW	OFFSET REVIND
	DB	'l'
	DW	ERSLIN
	DB	'p'
	DW	OFFSET DOREV
	DB	'q'
	DW	OFFSET DONRM
	DB	'j'
	DW	OFFSET SAVCRS
	DB	'k'
	DW	OFFSET RSTCRS
	DB	'x'
	DW	OFFSET IGNORE
	DB	'y'
	DW	OFFSET RESMOD
	DB	'z'
	DW	OFFSET IBMRST
	DB	0			;END OF TABLE
;
;      Z-100 to IBM PC graphic chr xlat table
;	only locs 5eh to 7eh are present    
;
IBMGRPH	LABEL	BYTE
	DB	0f9h	; ^
	DB	0dbh	; _
	DB	0b3h	; `
	DB	0c4h	; a
	DB	0c5h	; b
	DB	0bfh	; c
	DB	0d9h	; d
	DB	0c0h	; e
	DB	0dah	; f
	DB	0f1h	; g
	DB	01ah	; h
	DB	0b0h	; i
	DB	0f6h	; j
	DB	019h	; k
	DB	0dah	; l
	DB	0bfh	; m
	DB	0d9h	; n
	DB	0c0h	; o
	DB	0dfh	; p
	DB	0deh	; q
	DB	0dbh	; r
	DB	0c2h	; s
	DB	0b4h	; t
	DB	0c1h	; u
	DB	0c3h	; v
	DB	058h	; w
	DB	02fh	; x
	DB	05ch	; y
	DB	0dfh	; z
	DB	0dch	; {
	DB	0ddh	; |
	DB	0deh	; }
	DB	014h	; ~
	DB	0dbh	; del
;
	EVEN
BA:					; BUFFER AREA
BUFF		STRUC
		DB	256 DUP (?)
STACK		DB	?
LINEBUF		DB	128 DUP (?)
DIRPTR		DB	2*512 DUP (?)	; DIRECTORY ENTRY POINTER
DIR_ENT_BUF	DB	17*512 DUP (?)  ; ROOM FOR 512 ENTRIES
RDBUF		DB	?
BUFF		ENDS
HFM	ENDS
	END	START
