	PAGE	,132
;	ZENITH LAPTOP STATUS PROGRAM.  THIS PROGRAM RETURNS
;	THE STATUS OF VARIOUS ROM SETTINGS ON A ZENITH SUPERSPORT
;	286 OR TURBOSPORT 386 COMPUTER.  IT ALSO ALLOWS THE
;	SETTING OF SOME PARAMETERS.
;
;	BY P. SWAYNE, HUG SOFTWARE ENGINEER  11-MAY-89

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H

START:	MOV	DX,OFFSET SIGNON
	CALL	PMSG			;PRINT SIGN-ON
	MOV	AX,0F000H
	MOV	ES,AX			;POINT TO ROM
	MOV	DI,0FFE3H		;POINT TO ZBIOS SIGNATURE
	MOV	SI,OFFSET ZBMSG
	MOV	CX,5
	REPZ	CMPSB			;CHECK SIGNATURE
	JZ	GOTSIG			;WE HAVE SIGNATURE
	MOV	DX,OFFSET NOZB
	CALL	PMSG			;ELSE, SAY "NO ZBIOS"
	INT	20H			;AND EXIT
GOTSIG:	MOV	AX,ES:[DI]		;GET ZBIOS OFFSET
	MOV	ZBADR,AX		;STORE IT
	PUSH	CS
	POP	ES			;FIX ES
	MOV	BYTE PTR CALLNO,0		;START AT BEGINNING

;	MAIN STATUS LOOP

MLOOP:	MOV	DX,0F000H		;DX MUST POINT TO ROM SEGMENT
	MOV	SI,40H
	MOV	ES,SI			;ES MUST POINT TO ROM DATA SEGMENT
	MOV	CX,0			;CX MUST POINT TO 0, FOR SOME
	MOV	AH,CALLNO		;GET CALL NUMBER
	MOV	AL,0FFH			;REQUEST INFORMATION
	CALL	DWORD PTR ZBADR		;CALL ZBIOS PROCESSOR
	PUSHF				;SAVE FLAGS
	MOV	DL,CALLNO		;GET CALL NUMBER AGAIN
	SHL	DL,1			;DOUBLE IT
	SHL	DL,1			;QUADRUPLE IT
	XOR	DH,DH
	MOV	SI,OFFSET MSGTBL	;POINT TO MESSAGE/ROUTINE TABLE
	ADD	SI,DX			;POINT TO THIS ENTRY
	MOV	DX,[SI]			;GET MESSAGE ADDRESS
	OR	DX,DX			;ANY MESSAGE FOR THIS NUMBER?
	JNZ	GOTMSG			;YES
	POPF				;ELSE, DUMP FLAGS
	JMP	NOMSG			;NO MESSAGE
GOTMSG:	MOV	DI,2[SI]		;GET SUBROUTINE ADDRESS
	CALL	PMSG			;PRINT MESSAGE
	POPF				;GET FLAGS
	CALL	DI			;CALL SUBROUTINE
NOMSG:	INC	BYTE PTR CALLNO		;INCREMENT CALL NUMBER
	CMP	BYTE PTR CALLNO,12	;DONE?
	JNZ	MLOOP			;NO, CONTINUE
	MOV	DX,OFFSET CRLF
	CALL	PMSG			;ELSE, PRINT CR, LF
	INT	20H			;EXIT

;	STATUS FUNCTION SUBROUTINES

GATESUB:CALL	NOTDET
	MOV	BYTE PTR ZPORT,'E'	;SET UP ZENITH PORT
REAL2:	MOV	CL,ATMSGS		;GET MESSAGE SIZE
	MUL	CL			;GET OFFSET TO MESSAGE
	MOV	DX,OFFSET ATMSG
	ADD	DX,AX			;DX POINTS TO MESSAGE
	CALL	PMSG			;PRINT GATE STATUS MESSAGE
	MOV	DL,')'
	MOV	AH,2
	INT	21H			;CLOSE PARENTHESES
	RET

REALSUB:CALL	NOTDET
	MOV	BYTE PTR ZPORT,'F'	;FIX ZENITH PORT
	JMP	REAL2

BACKSUB:CALL	NOTDET
	MOV	DX,OFFSET NONEMSG	;ASSUME NO BACKLIGHT
	OR	BX,BX			;IS THERE
	JZ	PBMSG			;YES
	MOV	DX,OFFSET ALLMSG	;ASSUME ALWAYS ON
	CMP	BX,0FFFFH		;IS IT
	JZ	PBMSG			;YES
	CALL	DECOUT			;ELSE, PRINT TIME-OUT VALUE
	RET
PBMSG:	JMP	PMSG

MODMSUB:CALL	NOTDET
	MOV	DX,OFFSET DISMSG	;ASSUME DISABLED
	OR	AL,AL			;IS IT
	JZ	PMMSG			;YES
	MOV	DX,OFFSET ENMSG
PMMSG:	JMP	PMSG

SPDSUB:	MOV	CL,FSTMSGS		;GET FAST MSG SIZE
	MUL	CL			;GET OFFSET TO MESSAGE
	MOV	DX,OFFSET FASTMSG	;POINT TO MESSAGES
	ADD	DX,AX			;POINT TO PROPER MESSAGE
	JMP	PMSG			;PRINT IT

CASHSUB:CALL	NOTDET
	CMP	AL,0FFH			;CACHE INSTALLED?
	JNZ	MODMSUB			;COULD BE
	CALL	NOTDET1			;ELSE, CAN'T BE DETERMINED
	RET				;SHOULDN'T GET HERE

PALSUB:	CALL	NOTDET
	PUSH	AX			;SAVE NUMBER OF PALETTES
	CALL	DECOUT			;PRINT CURRENT PALETTE NUMBER
	MOV	DX,OFFSET PALMSG2
	CALL	PMSG			;PRINT "NO. OF PALETTES"
	POP	BX			;GET NUMBER OF PALETTES
	CALL	DECOUT			;PRINT IT
	RET

BATSUB:	CALL	NOTDET
	CMP	AL,10
	JAE	BATOK
	CALL	NOTDET1
BATOK:	MOV	BX,AX
	CALL	DECOUT
	RET

MODLSUB:MOV	SI,BX
	SHL	AL,1
	SHL	AL,1
	SHL	AL,1
	SHL	AL,1
	MOV	AH,AL
	XOR	AL,AL			;CONVERT AX TO SEGMENT
	MOV	DS,AX			;PUT IN DS
MODPLP:	LODSB				;GET A CHARACTER
	MOV	DL,AL
MODLP1:	MOV	AH,2
	INT	21H			;PRINT IT
	LOOP	MODPLP
	PUSH	CS
	POP	DS			;FIX DS
	RET

ROMSUB:	MOV	SI,BX
	SHL	AL,1
	SHL	AL,1
	SHL	AL,1
	SHL	AL,1
	MOV	AH,AL
	XOR	AL,AL			;CONVERT AX TO SEGMENT
	MOV	DS,AX			;PUT IN DS
	LODSB				;GET FIRST ROM NUMBER
	MOV	DL,AL			;IN DL
	MOV	AH,2
	INT	21H			;PRINT IT
;	DEC	CX			;COUNT IT
	MOV	DL,'.'			;PERIOD AFTER
	JMP	MODLP1			;PRINT REST

DISKSUB:CALL	NOTDET
	JMP	BACKSUB			;USE BACKLIGHT SUBROUTINE

;	PRINT "NOT DETERMINED" IF C FLAG SET OR Z FLAG SET AND AX = 0

NOTDET:	JC	NOTDET1			;
	JNZ	NOTDEX			;Z NOT SET
	OR	AX,AX
	JNZ	NOTDEX			;AX HAS SOMETHING
NOTDET1:MOV	DX,OFFSET NDMSG
	CALL	PMSG			;SAY "NOT DETERMINED"
	POP	AX			;DUMP THE RETURN FROM CALL TO HERE
NOTDEX:	RET

;	PRINT MESSAGES

PMSG:	PUSH	AX
	MOV	AH,9
	INT	21H
	POP	AX
	RET

;	DECOUT - PRINT BX IN DECIMAL
;	THIS IS A TRICKY ROUTINE THAT MAKES USE OF THE
;	STACK TO STORE DECODED DIGITS.

DECOUT:	PUSH	CX
	PUSH	DX
	PUSH	BX			;SAVE REGISTERS
	MOV	CX,10			;RADIX FOR CONVERSION
	MOV	DX,0
	MOV	AX,BX
	DIV	CX			;DIVIDE BY 10
	MOV	BX,AX			;ANSWER TO BX (DX [REMAINDER] = DIGIT)
	CMP	BX,0			;DONE?
	JZ	DEC1	
	CALL	DECOUT			;CALL RECURSIVELY UNTIL DONE
DEC1:	ADD	DL,'0'			;ADD ASCII BIAS
	MOV	AH,2
	INT	21H			;PRINT DIGIT
	POP	BX			;RESTORE REGISTERS
	POP	DX
	POP	CX
	RET

CALLNO	DB	0			;CALL NUMBER
ZBADR	DW	0,0F000H

MSGTBL	DW	OFFSET GATEMSG,OFFSET GATESUB
	DW	OFFSET REALMSG,OFFSET REALSUB
	DW	0,0			;REBOOT - NO STATUS
	DW	OFFSET BACKMSG,OFFSET BACKSUB
	DW	OFFSET MODMMSG,OFFSET MODMSUB
	DW	OFFSET SPDMSG,OFFSET SPDSUB
	DW	OFFSET CASHMSG,OFFSET CASHSUB
	DW	OFFSET PALMSG,OFFSET PALSUB
	DW	OFFSET BATMSG,OFFSET BATSUB
	DW	OFFSET MODLMSG,OFFSET MODLSUB
	DW	OFFSET ROMMSG,OFFSET ROMSUB
	DW	OFFSET DISKMSG,OFFSET DISKSUB

SIGNON	DB	'Zenith Laptop Status Utility, v. 1.0$'
ZBMSG	DB	'ZBIOS'
NOZB	DB	13,10,10,'This computer does not support Zenith ZBIOS.',13,10,'$'
GATEMSG	DB	13,10,10,'Address line 20 gating method: $'
ATMSG	DB	'AT-Compatible$  '
ATMSGS	EQU	$-ATMSG
ZMSG	DB	'Zenith (port E'
ZPORT	DB	'EH$'
PSMSG	DB	'PS/2 (port 92H)$'
REALMSG	DB	13,10,'Real mode implementation method: $'
BACKMSG	DB	13,10,'Backlight time-out value: $'
NONEMSG	DB	'None$'
ALLMSG	DB	'Always on$'
NDMSG	DB	'Not determined$'
MODMMSG	DB	13,10,'Internal modem status: $'
ENMSG	DB	'Enabled$'
DISMSG	DB	'Disabled$'
SPDMSG	DB	13,10,'Processor speed is set to: $'
FASTMSG	DB	'Fast$ '
FSTMSGS	EQU	$-FASTMSG
SLOWMSG	DB	'Slow$ '
SMARMSG	DB	'Smart$'
CRAWMSG	DB	'Crawl$'
CASHMSG	DB	13,10,'Memory cache status: $'
PALMSG	DB	13,10,'LCD palette is set to: $'
PALMSG2	DB	13,10,'Highest palette number is: $'
BATMSG	DB	13,10,'Battery life remaining is: $'
MODLMSG	DB	13,10,'This computer is model: $'
ROMMSG	DB	13,10,'The ROM version number is: $'
DISKMSG	DB	13,10,'The hard disk timeout is: $'
CRLF	DB	13,10,'$'

CODE	ENDS
	END	START
