	PAGE	,132
;	REVSCRN -- SCREEN REVERSE UTILITY.  THIS PROGRAM
;	REVERSES THE BACKGROUND AND FOREGROUND SCREEN COLORS
;	WHEN YOU TYPE CTRL-SHIFT-R.
;
;	BY P. SWAYNE HUG SOFTWARE ENGINEER  01-MAY-89

;	BIOS RAM LOCATIONS

BIOS	SEGMENT AT 40H
	ORG	49H
MODE	LABEL	BYTE			;CURRENT VIDEO MODE
	ORG	4AH
COLS	LABEL	BYTE			;COLUMNS/LINE
	ORG	4EH
PGOFF	LABEL	WORD			;PAGE OFFSET
	ORG	50H
CURPOS	LABEL	WORD			;CURSOR POSITION
	ORG	60H
CURTYP	LABEL	WORD			;CURSOR TYPE
	ORG	62H
PAGENO	LABEL	BYTE			;CURRENT PAGE NUMBER
	ORG	63H
VPORT	LABEL	WORD			;BASE VIDEO PORT
	ORG	84H
LINES	LABEL	BYTE			;LINES/PAGE -1
BIOS	ENDS

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
;	DEFINE SOME MEMORY LOCATIONS

	ORG	1
PSPSEG	LABEL	WORD			;PROGRAM SEGMENT PREFIX SEGMENT ADDR.
	ORG	3
MCBSIZE	LABEL	WORD			;MEMORY CONTROL BLOCK SIZE
	ORG	2CH
ENVSEG	LABEL	WORD			;ENVIRONMENT SEGMENT
	ORG	5DH
FCBN	LABEL	BYTE			;DEFINE FCB NAME
	ORG	100H

START:	JMP	SETUP			;GO SET UP PROGRAM

SIG	DB	'REVSCRN  1.0'		;PROGRAM SIGNATURE
INT09V	DW	0,0			;INT 9 VECTOR
INT28V	DW	0,0			;INT 28 VECTOR
ENFLG	DB	1			;ENABLE FLAG
KEYFLG	DB	0			;KEY FLAG
FIXRFLG	DB	0			;FIX R KEY FLAG

;	KEYBOARD INTERRUPT PROCESSOR.  HERE WE CHECK FOR CTRL-SHIFT-R,
;	AND REVERSE THE SCREEN COLORS IF IT IS FOUND.

INT09:	TEST	CS:ENFLG-0C0H,1		;PROGRAM ENABLED?
	JNZ	INT09A			;YES
INT09X:	JMP	CS:DWORD PTR INT09V-0C0H	;ELSE, EXIT
INT09A:	PUSH	AX
	IN	AL,60H			;GET KEY TYPED?
	MOV	AH,1			;ASSUME CTRL DOWN
	CMP	AL,1DH			;CTRL DOWN?
	JZ	SETDN			;YES
	INC	AH			;ASSUME SHIFT DOWN
	CMP	AL,2AH
	JZ	SETDN			;IT'S DOWN
	CMP	AL,36H
	JZ	SETDN			;OTHER SHIFT DOWN
	MOV	AH,0FFH-1		;ASSUME CTRL UP
	CMP	AL,9DH			;CTRL UP?
	JZ	SETKUP			;IT'S UP
	DEC	AH			;ASSUME SHIFT UP
	CMP	AL,0AAH
	JZ	SETKUP
	CMP	AL,0B6H
	JZ	SETKUP			;OTHER SHIFT UP
	CMP	AL,13H			;R KEY?
	JZ	RKEY			;YES
	CMP	AL,93H			;R UP?
	JZ	RKEYUP			;YES
INT09X1:POP	AX
	JMP	CS:DWORD PTR INT09V-0C0H	;ELSE, EXIT
SETDN:	OR	CS:KEYFLG-0C0H,AH	;SET KEY FLAG
	JMP	INT09X1
SETKUP:	AND	CS:KEYFLG-0C0H,AH	;MARK KEY RELEASED
	JMP	INT09X1
RKEY:	CMP	CS:KEYFLG-0C0H,3	;CTRL AND SHIFT DOWN?
	JZ	REVSCRN			;IF SO, REVERSE SCREEN
	JMP	INT09X1
RKEYUP:	CMP	CS:FIXRFLG-0C0H,1	;TIME TO FIX R KEY?
	JNZ	INT09X1			;NO
	MOV	CS:FIXRFLG-0C0H,0	;ELSE, FIX FLAG
	JMP	ABSORB			;AND ABSORB KEY
REVSCRN:MOV	CS:FIXRFLG-0C0H,1	;MARK R UP NEEDS FIXING
	PUSH	CX
	PUSH	SI
	PUSH	DS
	CLD
	MOV	AX,BIOS
	MOV	DS,AX			;POINT TO BIOS RAM
	ASSUME	DS:BIOS
	MOV	AL,MODE			;GET VIDEO MODE
	CMP	AL,4			;TEXT MODE?
	JB	REVTXT			;YES
	CMP	AL,6			;GRAPHICS MODE?
	JBE	REVGR			;YES
	JMP	SHORT NOFIX		;IF NOT, DO NOT FIX
REVTXT:	MOV	AL,LINES		;GET LINES/PAGE
	OR	AL,AL
	JNZ	LINESOK			;LINES ARE OK
	MOV	AL,24
LINESOK:INC	AL			;FIX LINES
	MUL	COLS			;MULTIPLY BY COLUMNS
	MOV	CX,AX			;RESULT TO CX
	MOV	SI,PGOFF		;GET PAGE START
	INC	SI			;POINT AT ATTRIBUTE BYTE
	MOV	AX,0B800H
	MOV	DS,AX			;POINT TO VIDEO RAM
	ASSUME	DS:CODE
	MOV	AH,0FFH			;ASSUME NO HIGH BIT FILTER
	TEST	CS:ENFLG-0C0H,80H	;IS THERE?
	JZ	REVLP			;NO
	MOV	AH,7FH			;ELSE, REMOVE HIGH BIT IN MASK
REVLP:	LODSB				;GET AN ATTRIBUTE BYTE
	ROL	AL,1			;REVERSE FOREGROUND, BACKGROUND
	ROL	AL,1
	ROL	AL,1
	ROL	AL,1
	AND	AL,AH			;APPLY MASK
	MOV	-1[SI],AL		;REPLACE ATTRIBUTE BYTE
	INC	SI			;SKIP CHARACTER BYTE
	LOOP	REVLP
	JMP	NOFIX			;DONE
REVGR:	MOV	AX,0B800H
	MOV	DS,AX			;POINT TO VIDEO RAM
	XOR	SI,SI			;POINT TO VIDEO RAM START
	MOV	CX,8000			;8000 BYTES TO FIX
REVGLP1:LODSB				;GET A BYTE
	NOT	AL			;INVERT IT
	MOV	-1[SI],AL		;REPLACE IT
	LOOP	REVGLP1
	MOV	SI,2000H		;POINT TO VRAM SECOND PAGE
	MOV	CX,8000
REVGLP2:LODSB				;GET A BYTE
	NOT	AL			;INVERT IT
	MOV	-1[SI],AL		;REPLACE IT
	LOOP	REVGLP2
NOFIX:	POP	DS
	POP	SI
	POP	CX
ABSORB:	MOV	AH,AL			;SAVE KEY IN AH
	IN	AL,61H
	OR	AL,80H
	OUT	61H,AL			;ABSORB KEY
	AND	AL,7FH
	OUT	61H,AL
	MOV	AL,20H
	OUT	20H,AL			;RESET INTERRUPT CONTROLLER
;	MOV	AL,AH			;KEY TO AL
	POP	AX
	IRET

;	INT 28H PROCESSOR.  USED FOR UN-INSTALLING REVSCRN.

INT28:	CMP	CS:ENFLG-0C0H,2		;UN-INSTALL REVSCRN?
	JZ	UNINS			;YES
	JMP	CS:DWORD PTR INT28V-0C0H	;ELSE, EXIT
UNINS:	PUSH	CS
	POP	DS			;POINT TO THIS SEGMENT
	XOR	AX,AX
	MOV	ES,AX			;AND TO INT. SEGMENT
	MOV	SI,OFFSET INT09V-0C0H	;POINT TO INT 9 VECTOR
	MOV	DI,9H*4			;WHERE IT GOES
	CLD
	MOVSW				;RESTORE VECTOR
	MOVSW
	MOV	SI,OFFSET INT28V-0C0H	;POINT TO INT 28 VECTOR
	MOV	DI,28H*4		;WHERE IT GOES
	MOVSW				;RESTORE VECTOR
	MOVSW
	PUSH	CS
	POP	ES			;PUT ES HERE
	MOV	AH,49H
	INT	21H			;RELEASE THIS PROGRAM'S MEMORY
	MOV	ES,ENVSEG		;POINT TO ENVIRONMENT SEGMENT
	MOV	AH,49H
	INT	21H			;RELEASE ENVIRONMENT SEGMENT
	STI				;ENABLE INTERRUPTS
	INT	20H			;EXIT
ENDRES:

;	SET UP PROGRAM

SETUP:	MOV	AL,FCBN			;GET FCB NAME CHARACTER
	MOV	FCBARG,AL		;SAVE IT
	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H			;PRINT SIGN-ON
	CMP	FCBARG,'?'		;ASKING HELP?
	JNZ	SETUP1			;NO
	MOV	DX,OFFSET HLPMSG
	MOV	AH,9
	INT	21H			;PRINT HELP MSG
	MOV	DX,OFFSET INSMSG2
	MOV	AH,9
	INT	21H			;SHOW HOW TO WORK IT
	INT	20H			;AND EXIT
SETUP1:	MOV	AH,52H
	INT	21H			;GET MEMORY CONTROL BLOCK ADDR.
	MOV	AX,ES:[BX-2]		;GET FIRST MCB SEGMENT
	MOV	DS,AX			;POINT TO IT
FNDLP:	MOV	AX,PSPSEG		;GET PSP SEGMENT
	MOV	DX,CS
	CMP	AX,DX			;IN THIS SEGMENT?
	JAE	CHKFND			;IF SO, CHECK IF REVSCRN FOUND
	MOV	ES,AX			;ELSE, PSP SEGMENT TO ES
	MOV	SI,OFFSET SIG
	MOV	DI,SI
	SUB	DI,0C0H			;PROGRAM IS MOVED DOWN
	PUSH	DS			;SAVE MCB SEGMENT
	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	CX,6			;5 WORDS IN SIGNATURE
	REPZ	CMPSW			;IS REVSCRN HERE?
	JZ	GOTCC			;WE FOUND REVSCRN
	MOV	LSTSEG,ES		;SAVE PSP SEGMENT
FNDNXT:	POP	DS			;RESTORE MCB SEGMENT
	MOV	AX,MCBSIZE		;GET MCB SIZE
	INC	AX			;CORRECT IT
	MOV	BX,DS
	ADD	AX,BX			;CALCULATE NEXT MCB SEGMENT
	MOV	DS,AX			;POINT TO IT
	JMP	FNDLP			;TRY AGAIN
GOTCC:	MOV	FNDSEG,ES		;SAVE SEGMENT WHERE FOUND
	MOV	BYTE PTR FNDFLG,1	;MARK PROGRAM FOUND
	JMP	FNDNXT
CHKFND:	PUSH	CS
	POP	DS			;FIX DS
	CMP	BYTE PTR FNDFLG,1	;WAS REVSCRN FOUND?
	JNZ	NOTFND			;NO
	MOV	ES,FNDSEG		;GET SEGMENT WHERE FOUND
	XOR	AL,AL			;ASSUME DISABLE WANTED
	MOV	DX,OFFSET DISMSG
	CMP	FCBARG,'D'		;DISABLE REVSCRN?
	JZ	SETFLG			;YES
	MOV	AL,2			;ASSUME UNINSTALL
	MOV	DX,OFFSET UNMSG
	CMP	FCBARG,'U'		;UNINSTALL?
	JNZ	ENABLE			;NO, ENABLE REVSCRN
	MOV	BX,FNDSEG		;GET SEGMENT WHERE FOUND
	CMP	BX,LSTSEG		;COMPARE WITH LAST PSP FOUND
	JNC	SETFLG			;OK TO UNLOAD
	MOV	DX,OFFSET NOUNMSG
	MOV	AH,9
	INT	21H			;ELSE, SAY "CAN'T UNLOAD"
	INT	20H
ENABLE:	DEC	AL			;ELSE, ENABLE REVSCRN
	MOV	DX,OFFSET ENMSG
SETFLG:	PUSH	AX			;SAVE FLAG
	MOV	AH,9
	INT	21H			;PRINT APPROPRIATE MSG
	POP	AX			;GET FLAG
	MOV	ES:ENFLG-0C0H,AL	;SET CONDITION
	CMP	FCBARG,'F'		;SET HIGH FILTER?
	JNZ	NOFLTR			;NO
	OR	ES:ENFLG-0C0H,80H	;ELSE, SET HIGH BIT
	MOV	DX,OFFSET FILMSG
	MOV	AH,9
	INT	21H			;INDICATE FILTER ON
NOFLTR:	INT	20H			;AND EXIT
NOTFND:	CMP	FCBARG,'U'		;UNINSTALL?
	JNZ	DOINS			;NO
	MOV	DX,OFFSET NINMSG
	MOV	AH,9
	INT	21H			;SAY "NOT INSTALLED"
	INT	20H
DOINS:	PUSH	CS
	POP	ES			;FIX ES
	MOV	SI,OFFSET START		;POINT TO START OF PROGRAM
	MOV	DI,40H			;PUT IT HERE
	MOV	CX,ENDRES-START		;SIZE OF PROGRAM
	CLD
	REP	MOVSB			;MOVE PROGRAM DOWN
	XOR	AX,AX
	MOV	DS,AX			;POINT TO INT. PAGE
	MOV	SI,OFFSET 9*4		;POINT TO INT 9 VECTOR
	MOV	DI,OFFSET INT09V-0C0H	;PUT IT HERE
	PUSH	SI
	MOVSW				;MOVE VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET INT09-0C0H	;SET NEW VECTOR
	MOV	2[SI],CS
	MOV	SI,OFFSET 28H*4		;POINT TO INT 28 VECTOR
	MOV	DI,OFFSET INT28V-0C0H	;PUT IT HERE
	PUSH	SI
	MOVSW				;MOVE VECTOR
	MOVSW
	POP	SI
	MOV	WORD PTR [SI],OFFSET INT28-0C0H	;SET NEW VECTOR
	MOV	2[SI],CS
	PUSH	CS
	POP	DS			;FIX DS
	MOV	DX,OFFSET INSMSG
	MOV	AH,9
	INT	21H			;PRINT INSTALLATION MSG
	CMP	FCBARG,'D'		;DISABLE?
	JNZ	NOTDIS			;NO
	MOV	BYTE PTR ENFLG-0C0H,0	;ELSE, KILL ENABLE FLAG
	MOV	DX,OFFSET DISMSG
	MOV	AH,9
	INT	21H			;SAY "REVSCRN DISABLED"
NOTDIS:	CMP	FCBARG,'F'		;FILTER HIGH BIT?
	JNZ	NOTHIF
	OR	BYTE PTR ENFLG-0C0H,80H	;SET HIGH BIT
	MOV	DX,OFFSET FILMSG
	MOV	AH,9
	INT	21H
NOTHIF:	MOV	DX,OFFSET ENDRES-0C0H
	INT	27H			;EXIT WITH REVSCRN RESIDENT

FCBARG	DB	0			;FCB ARGUMENT SAVED HERE
LSTSEG	DW	0			;LAST PSP SEGMENT (SHOULD BE < PSPSEG)
FNDSEG	DW	0			;SEGMENT WHERE FOUND
FNDFLG	DB	0			;PROGRAM FOUND FLAG

SIGNON	DB	13,10,'REVSCRN -- Screen Color Reverser, v. 1.0',13,10
	DB	"Copyright (C) Heath/Zenith Users' Group 1989.  All rights reserved."
	DB	13,10,10,'$'
INSMSG	DB	'REVSCRN is now installed in memory.  You may control it',13,10
	DB	'by entering',13,10,10
INSMSG2	DB	'  REVSCRN D		To disable REVSCRN.',13,10
	DB	'  REVSCRN		To enable REVSCRN.',13,10
	DB	'  REVSCRN F		To enable REVSCRN with high bit filter on.',13,10
	DB	'  REVSCRN U		To uninstall REVSCRN.  You can only',13,10
	DB	'			uninstall if REVSCRN is the last',13,10
	DB	'			TSR loaded.',13,10,10
	DB	'Type Ctrl-Shift-R to reverse the screen.',13,10,'$'
DISMSG	DB	'REVSCRN is now disabled.',13,10,'$'
ENMSG	DB	'REVSCRN is now enabled.',13,10,'$'
FILMSG	DB	'High bit filter is on.',13,10,'$'
UNMSG	DB	'REVSCRN is now uninstalled.',13,10,'$'
NOUNMSG	DB	"REVSCRN is not the last TSR.  Can't uninstall.",13,10,'$'
NINMSG	DB	"REVSCRN is already not installed.",13,10,'$'
HLPMSG	DB	'To use REVSCRN, enter',13,10,10,'$'

CODE	ENDS
	END	START
