	PAGE	60,132

	TITLE	BOOT.COM - MS-DOS Reboot Utility

;	Version 1.2 (C) 14-Oct-86 by John Stetson

;	This command is designed to be placed in .BAT files
;	which temporarily rename AUTOEXEC.BAT and CONFIG.SYS
;	files for testing purposes.  After they are renamed,
;	a system reset (reboot) is caused which allows
;	testing to occur in an environment free of resident
;	processes, etc.  After testing is complete, another
;	batch file is executed to rename the files back to
;	their original names and to reboot the system again.

;	Command line syntax: BOOT [WARM | COLD]

;	For PC compatibles, BOOT WARM (the default) causes
;	a reboot without the Power-On Self Tests.  BOOT COLD
;	causes a full system reboot and runs the POST tests.

;	Running BOOT.COM is equivalent to pressing CTRL-RESET
;	on a Z-100 or ALT-CTRL-DEL on an IBM-PC compatible.

;	Sample NATIVE.BAT file:

;	ren config.sys config.bak
;	ren autoexec.bat autoexec.bak
;	boot

;	Sample NORMAL.BAT file:

;	ren config.bak config.sys
;	ren autoexec.bak autoexec.bat
;	boot

;	Another possible use of this program is to temporarily
;	reboot the system without a CONFIG.SYS or AUTOEXEC.BAT
;	file in order to be able to execute a program with as
;	much memory available to it as possible (e.g. LOTUS 1-2-3).
;	By using this utility in a properly constructed .BAT file,
;	the entire process can be automated, and will appear
;	relatively transparent to an end user.	For example:

;	Sample 123.BAT file:

;	ren config.sys config.bak
;	ren autoexec.bat autoexec.bak
;	ren auto123.bat autoexec.bat
;	boot

;	Sample AUTO123.BAT file:

;	123 (execute the target program)
;	ren autoexec.bat auto123.bat
;	ren autoexec.bak autoexec.bat
;	ren config.bak config.sys
;	boot

;	MASM, LINK, and EXE2BIN to make BOOT.COM

;	System Equates

FALSE	EQU	0
TRUE	EQU	NOT FALSE

Z100	EQU	TRUE		;Set TRUE for Z-100, FALSE for PC
IBMPC	EQU	NOT Z100

DEFDTA	EQU	80H		;Default Disk Transfer Area

;	Z-100 MTR-100 ROM Equates

	IF	Z100
MTRSEG	SEGMENT AT 0FE01H	;MTR-100 ROM Segment
	ORG	5*0		;Offset to Reset Function
RESET	LABEL	FAR		;Monitor Reset Function
MTRSEG	ENDS
	ENDIF

;	IBM-PC ROM BIOS Equates

	IF	IBMPC
ROMDAT	SEGMENT AT 40H		;ROM BIOS Data Segment
	ORG	0072H		;Offset to Reset Flag
FLAG	LABEL	FAR		;Keyboard Reset Flag
ROMDAT	ENDS

RSTSEG	SEGMENT AT 0FFFFH	;8088 Reset Segment
	ORG	0000H		;Offset to ROM Entry Point
RESET	LABEL	FAR		;ROM Entry Point
RSTSEG	ENDS
	ENDIF

;	Initialization

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:NOTHING,SS:NOTHING

	ORG	100H

;	Start of Program

BOOT:
	IF	IBMPC
	MOV	SI,DEFDTA		;SI -> Default DTA
	MOV	AL,[SI] 		;Length of possible operand
	CMP	AL,2			;Operand present?
	JL	WARM			;Jump if not
	MOV	AL,[SI+2]		;AL = first operand character
	CMP	AL,'a'
	JL	CASEOK
	SUB	AL,32			;Convert to upper case
CASEOK: CMP	AL,'C'                  ;Cold reboot requested?
	JZ	COLD			;Jump if so

	ASSUME	DS:ROMDAT

WARM:	MOV	AX,40H			;ROM BIOS Data Segment
	MOV	DS,AX
	MOV	WORD PTR FLAG,1234H	;Indicate warm reboot
	JMP	SHORT EXIT

COLD:	MOV	AX,40H			;ROM BIOS Data Segment
	MOV	DS,AX
	MOV	WORD PTR FLAG,0000H	;Indicate cold reboot

EXIT:
	ENDIF

	JMP	FAR PTR RESET		;Bye!

CODE	ENDS

	END	BOOT
